--------------------------------------------------------
--  File created - 15/11/2018
--------------------------------------------------------
--------------------------------------------------------
--  DDL for Table EMP
--------------------------------------------------------

DROP TABLE "EMP";

alter session set NLS_LANGUAGE=ENGLISH; -- set month format to english strings

CREATE TABLE "EMP" 
(	"EMPNO" NUMBER(6,0), 
    "ENAME" VARCHAR2(20 BYTE), 
    "JOB" VARCHAR2(11 BYTE), 
    "MGR" NUMBER(6,0), 
    "HIREDATE" DATE, 
    "SAL" NUMBER(7,2), 
    "COMM" NUMBER(7,2), 
    "DEPTNO" NUMBER(3,0)
) SEGMENT CREATION IMMEDIATE 
PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
STORAGE(INITIAL 4194304 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
TABLESPACE "USERS" ;

REM INSERTING into EMP
SET DEFINE OFF;
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4899','ESPOSITO LUDOVICO','MANAGER','3163',to_date('09/JUN/81','DD/MON/RR'),'311',null,'193');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4900','PETRARCA FEDERICO','SECRETARY','4729',to_date('09-JUN-81','DD-MON-RR'),'602',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4901','BIANCHI ELENA','SECRETARY','537',to_date('09-JUN-81','DD-MON-RR'),'851',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4902','CORONA DAMIANO','LAWYER','2026',to_date('09-JUN-81','DD-MON-RR'),'1505',null,'71');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4903','TIBALDI GAETANO','TECHNICIAN','3607',to_date('09-JUN-81','DD-MON-RR'),'368',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4904','NERI LUCIA','MANAGER','1835',to_date('09-JUN-81','DD-MON-RR'),'564',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4905','COZZA ANGELO','SECRETARY','1556',to_date('09-JUN-81','DD-MON-RR'),'1876',null,'20');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4906','PETRARCA SILVIA','LAWYER','668',to_date('09-JUN-81','DD-MON-RR'),'1756',null,'139');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4907','ECO CLARA','SUPERVISOR','3945',to_date('09-JUN-81','DD-MON-RR'),'542',null,'217');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4908','FO ELIO','PROFESSOR','2693',to_date('09-JUN-81','DD-MON-RR'),'239',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4909','MANZONI MASSIMO','ENGINEER','2516',to_date('09-JUN-81','DD-MON-RR'),'632',null,'394');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4910','BIANCHI GAETANO','ENGINEER','356',to_date('09-JUN-81','DD-MON-RR'),'791',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4911','FO UMBERTO','MANAGER','4748',to_date('09-JUN-81','DD-MON-RR'),'1007',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4912','FO FEDERICO','HEADMASTER','4553',to_date('09-JUN-81','DD-MON-RR'),'419',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4913','CARBONE LUCA','SUPERVISOR','228',to_date('09-JUN-81','DD-MON-RR'),'1411',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4914','CORONA ANDREA','ENGINEER','2076',to_date('09-JUN-81','DD-MON-RR'),'133',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4915','NERI LUCIA','ENGINEER','4784',to_date('09-JUN-81','DD-MON-RR'),'943',null,'356');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4916','FUMAROLA DONATO','SUPERVISOR','703',to_date('09-JUN-81','DD-MON-RR'),'1105',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4917','LEOPARDI ANTONIO','PHDSTUDENT','3421',to_date('09-JUN-81','DD-MON-RR'),'1450',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4918','ESPOSITO COSIMO','TECHNICIAN','165',to_date('09-JUN-81','DD-MON-RR'),'265',null,'31');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4919','CALVINO UMBERTO','LAWYER','4608',to_date('09-JUN-81','DD-MON-RR'),'942',null,'341');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4920','GRIMALDI LUDOVICO','MANAGER','2425',to_date('09-JUN-81','DD-MON-RR'),'1312',null,'277');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4921','PETRARCA ALFONSO','ENGINEER','1408',to_date('09-JUN-81','DD-MON-RR'),'946',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4922','ESPOSITO ANGELO','PHDSTUDENT','4236',to_date('09-JUN-81','DD-MON-RR'),'1319',null,'108');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4923','COZZA MARIA','LAWYER','2057',to_date('09-JUN-81','DD-MON-RR'),'1732',null,'217');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4924','CORONA PAOLO','ENGINEER','480',to_date('09-JUN-81','DD-MON-RR'),'1634',null,'477');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4925','GRIMALDI MARIO','HEADMASTER','4254',to_date('09-JUN-81','DD-MON-RR'),'971',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4926','CARBONE IVANO','PROFESSOR','2752',to_date('09-JUN-81','DD-MON-RR'),'1955',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4927','PETRARCA PASQUALE','LAWYER','3661',to_date('09-JUN-81','DD-MON-RR'),'1418',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4928','DANTE LUCA','SUPERVISOR','1289',to_date('09-JUN-81','DD-MON-RR'),'376',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4929','COZZA ANGELO','MANAGER','889',to_date('09-JUN-81','DD-MON-RR'),'1532',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4930','SANTE ANDREA','MANAGER','3814',to_date('09-JUN-81','DD-MON-RR'),'822',null,'298');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4931','SANTE ELIO','PHDSTUDENT','3417',to_date('09-JUN-81','DD-MON-RR'),'776',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4932','CARBONE FEDERICO','SECRETARY','4211',to_date('09-JUN-81','DD-MON-RR'),'766',null,'412');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4933','MANZONI LUDOVICO','ENGINEER','645',to_date('09-JUN-81','DD-MON-RR'),'1208',null,'391');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4934','CALVINO DAMIANO','TECHNICIAN','4209',to_date('09-JUN-81','DD-MON-RR'),'962',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4935','LEVI LUCIA','HEADMASTER','413',to_date('09-JUN-81','DD-MON-RR'),'781',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4936','ESPOSITO MASSIMO','SECRETARY','4792',to_date('09-JUN-81','DD-MON-RR'),'304',null,'197');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4937','MANZONI MASSIMO','PHDSTUDENT','1749',to_date('09-JUN-81','DD-MON-RR'),'1595',null,'209');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4938','ESPOSITO GIOVANNI','MANAGER','3826',to_date('09-JUN-81','DD-MON-RR'),'1009',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4939','NERI LUCA','LAWYER','51',to_date('09-JUN-81','DD-MON-RR'),'1819',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4940','MANZONI ANTONIO','MANAGER','4913',to_date('09-JUN-81','DD-MON-RR'),'1930',null,'77');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4941','DANTE LUDOVICO','SECRETARY','881',to_date('09-JUN-81','DD-MON-RR'),'1235',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4942','GRIMALDI ROBERTA','HEADMASTER','3008',to_date('09-JUN-81','DD-MON-RR'),'421',null,'254');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4943','PETRARCA ELENA','MANAGER','3896',to_date('09-JUN-81','DD-MON-RR'),'330',null,'193');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4944','DANTE FRANCESCO','PHDSTUDENT','4054',to_date('09-JUN-81','DD-MON-RR'),'1468',null,'176');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4945','PETRARCA CLARA','SECRETARY','3623',to_date('09-JUN-81','DD-MON-RR'),'1914',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4946','LEOPARDI GIOVANNI','MANAGER','2491',to_date('09-JUN-81','DD-MON-RR'),'614',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4947','COZZA LUCA','PROFESSOR','4860',to_date('09-JUN-81','DD-MON-RR'),'979',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4948','CALVINO ELENA','SECRETARY','1852',to_date('09-JUN-81','DD-MON-RR'),'610',null,'44');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4949','PETRARCA LUCIA','HEADMASTER','1017',to_date('09-JUN-81','DD-MON-RR'),'557',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4950','PETRARCA LUCA','MANAGER','3930',to_date('09-JUN-81','DD-MON-RR'),'1959',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4951','NERI FRANCESCO','SUPERVISOR','4167',to_date('09-JUN-81','DD-MON-RR'),'744',null,'451');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4952','CORONA UGO','LAWYER','3112',to_date('09-JUN-81','DD-MON-RR'),'1251',null,'136');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4953','CARBONE SILVIA','SECRETARY','414',to_date('09-JUN-81','DD-MON-RR'),'983',null,'47');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4954','SANTE MARIA','ENGINEER','4873',to_date('09-JUN-81','DD-MON-RR'),'918',null,'416');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4955','NERI IVANO','PHDSTUDENT','188',to_date('09-JUN-81','DD-MON-RR'),'1624',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4956','ESPOSITO FEDERICO','MANAGER','491',to_date('09-JUN-81','DD-MON-RR'),'1296',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4957','GRIMALDI MASSIMO','MANAGER','3892',to_date('09-JUN-81','DD-MON-RR'),'1168',null,'284');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4958','FO CLARA','LAWYER','4205',to_date('09-JUN-81','DD-MON-RR'),'1657',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4959','DANTE FEDERICO','TECHNICIAN','2466',to_date('09-JUN-81','DD-MON-RR'),'1968',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4960','ESPOSITO PASQUALE','PHDSTUDENT','2033',to_date('09-JUN-81','DD-MON-RR'),'1104',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4961','PETRARCA DONATO','SECRETARY','1969',to_date('09-JUN-81','DD-MON-RR'),'310',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4962','MANZONI ANDREA','MANAGER','3177',to_date('09-JUN-81','DD-MON-RR'),'1884',null,'357');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4963','CARBONE LUIGI','MANAGER','4447',to_date('09-JUN-81','DD-MON-RR'),'1697',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4964','CALVINO ANGELO','LAWYER','2513',to_date('09-JUN-81','DD-MON-RR'),'579',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4965','BIANCHI FEDERICO','PROFESSOR','1520',to_date('09-JUN-81','DD-MON-RR'),'59',null,'170');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4966','CORONA ELENA','PROFESSOR','2758',to_date('09-JUN-81','DD-MON-RR'),'1792',null,'276');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4967','FUMAROLA ANTONIO','LAWYER','4290',to_date('09-JUN-81','DD-MON-RR'),'467',null,'326');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4968','NERI PASQUALE','HEADMASTER','202',to_date('09-JUN-81','DD-MON-RR'),'678',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4969','NERI ANGELO','SUPERVISOR','3086',to_date('09-JUN-81','DD-MON-RR'),'1840',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4970','MANZONI LUCA','LAWYER','3405',to_date('09-JUN-81','DD-MON-RR'),'1247',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4971','SANTE FRANCESCO','LAWYER','2105',to_date('09-JUN-81','DD-MON-RR'),'413',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4972','MANZONI DAMIANO','HEADMASTER','3411',to_date('09-JUN-81','DD-MON-RR'),'1605',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4973','BIANCHI ELENA','MANAGER','4928',to_date('09-JUN-81','DD-MON-RR'),'846',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4974','CORONA UGO','MANAGER','3915',to_date('09-JUN-81','DD-MON-RR'),'750',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4975','FO UMBERTO','LAWYER','2860',to_date('09-JUN-81','DD-MON-RR'),'1913',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4976','CARBONE ANGELO','SECRETARY','2693',to_date('09-JUN-81','DD-MON-RR'),'812',null,'186');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4977','ECO UGO','PROFESSOR','1954',to_date('09-JUN-81','DD-MON-RR'),'137',null,'56');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4978','CALVINO MARIA','MANAGER','3722',to_date('09-JUN-81','DD-MON-RR'),'796',null,'459');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4979','DANTE LUIGI','SECRETARY','3182',to_date('09-JUN-81','DD-MON-RR'),'1356',null,'24');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4980','BIANCHI CLARA','LAWYER','511',to_date('09-JUN-81','DD-MON-RR'),'1248',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4981','SANTE ANDREA','TECHNICIAN','3897',to_date('09-JUN-81','DD-MON-RR'),'1948',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4982','COZZA ALFONSO','PROFESSOR','2323',to_date('09-JUN-81','DD-MON-RR'),'1074',null,'58');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4983','SANTE DONATO','LAWYER','382',to_date('09-JUN-81','DD-MON-RR'),'267',null,'461');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4984','ECO PASQUALE','PHDSTUDENT','3335',to_date('09-JUN-81','DD-MON-RR'),'1518',null,'245');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4985','MANZONI FRANCESCO','MANAGER','184',to_date('09-JUN-81','DD-MON-RR'),'148',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4986','COZZA GIOVANNI','MANAGER','2851',to_date('09-JUN-81','DD-MON-RR'),'947',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4987','LEOPARDI ELENA','PHDSTUDENT','1422',to_date('09-JUN-81','DD-MON-RR'),'190',null,'127');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4988','CARBONE UGO','LAWYER','4617',to_date('09-JUN-81','DD-MON-RR'),'1504',null,'386');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4989','CALVINO DONATO','MANAGER','3297',to_date('09-JUN-81','DD-MON-RR'),'834',null,'326');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4990','COZZA LUIGI','HEADMASTER','3457',to_date('09-JUN-81','DD-MON-RR'),'343',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4991','LEVI ALFONSO','PHDSTUDENT','2275',to_date('09-JUN-81','DD-MON-RR'),'113',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4992','LEOPARDI COSIMO','PROFESSOR','3719',to_date('09-JUN-81','DD-MON-RR'),'1158',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4993','BIANCHI CLARA','MANAGER','3191',to_date('09-JUN-81','DD-MON-RR'),'1813',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4994','ECO COSIMO','PROFESSOR','1531',to_date('09-JUN-81','DD-MON-RR'),'830',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4995','ECO SILVIA','LAWYER','2917',to_date('09-JUN-81','DD-MON-RR'),'521',null,'243');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4996','BIANCHI LUIGI','PHDSTUDENT','3358',to_date('09-JUN-81','DD-MON-RR'),'1149',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4997','BIANCHI CLARA','LAWYER','133',to_date('09-JUN-81','DD-MON-RR'),'695',null,'450');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4998','DANTE LUDOVICO','MANAGER','4376',to_date('09-JUN-81','DD-MON-RR'),'1972',null,'394');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4999','BIANCHI FRANCESCO','HEADMASTER','3260',to_date('09-JUN-81','DD-MON-RR'),'1411',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5000','FO UMBERTO','PROFESSOR','735',to_date('09-JUN-81','DD-MON-RR'),'499',null,'393');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5001','GRIMALDI GAETANO','HEADMASTER','3028',to_date('09-JUN-81','DD-MON-RR'),'408',null,'240');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5002','NERI SILVIA','PROFESSOR','4783',to_date('09-JUN-81','DD-MON-RR'),'1532',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5003','CALVINO IVANO','PROFESSOR','3702',to_date('09-JUN-81','DD-MON-RR'),'510',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5004','BIANCHI ELENA','ENGINEER','365',to_date('09-JUN-81','DD-MON-RR'),'1595',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5005','LEVI DONATO','TECHNICIAN','2796',to_date('09-JUN-81','DD-MON-RR'),'1553',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5006','MANZONI ALFONSO','LAWYER','1261',to_date('09-JUN-81','DD-MON-RR'),'32',null,'260');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5007','DANTE MARIO','LAWYER','4083',to_date('09-JUN-81','DD-MON-RR'),'1213',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5008','GRIMALDI UMBERTO','MANAGER','121',to_date('09-JUN-81','DD-MON-RR'),'408',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5009','CALVINO CLARA','ENGINEER','4767',to_date('09-JUN-81','DD-MON-RR'),'1613',null,'302');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5010','TIBALDI IVANO','MANAGER','1780',to_date('09-JUN-81','DD-MON-RR'),'794',null,'5');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5011','SANTE ROBERTA','SECRETARY','2283',to_date('09-JUN-81','DD-MON-RR'),'1990',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5012','ESPOSITO PAOLO','SECRETARY','1186',to_date('09-JUN-81','DD-MON-RR'),'1086',null,'347');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5013','BIANCHI FEDERICO','SUPERVISOR','3359',to_date('09-JUN-81','DD-MON-RR'),'1628',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5014','CALVINO CLARA','LAWYER','698',to_date('09-JUN-81','DD-MON-RR'),'1108',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5015','BIANCHI MARIO','PHDSTUDENT','4907',to_date('09-JUN-81','DD-MON-RR'),'1461',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5016','FUMAROLA ANDREA','SECRETARY','2068',to_date('09-JUN-81','DD-MON-RR'),'651',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5017','TIBALDI ALFONSO','MANAGER','4714',to_date('09-JUN-81','DD-MON-RR'),'1078',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5018','CALVINO MASSIMO','SUPERVISOR','3988',to_date('09-JUN-81','DD-MON-RR'),'945',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5019','GRIMALDI ALFONSO','MANAGER','1288',to_date('09-JUN-81','DD-MON-RR'),'1888',null,'456');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5020','DANTE LUCIA','SUPERVISOR','4537',to_date('09-JUN-81','DD-MON-RR'),'1333',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5021','CALVINO ANDREA','MANAGER','4659',to_date('09-JUN-81','DD-MON-RR'),'138',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5022','DANTE MARIO','MANAGER','2081',to_date('09-JUN-81','DD-MON-RR'),'1719',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5023','ESPOSITO MARIO','TECHNICIAN','2540',to_date('09-JUN-81','DD-MON-RR'),'579',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5024','SANTE ANTONIO','ENGINEER','3105',to_date('09-JUN-81','DD-MON-RR'),'1411',null,'39');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5025','CALVINO GIOVANNI','ENGINEER','4108',to_date('09-JUN-81','DD-MON-RR'),'1540',null,'217');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5026','PETRARCA LUCA','ENGINEER','3637',to_date('09-JUN-81','DD-MON-RR'),'1485',null,'80');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5027','ESPOSITO MASSIMO','LAWYER','2279',to_date('09-JUN-81','DD-MON-RR'),'1928',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5028','LEVI PAOLO','MANAGER','1841',to_date('09-JUN-81','DD-MON-RR'),'70',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5029','PETRARCA COSIMO','TECHNICIAN','4184',to_date('09-JUN-81','DD-MON-RR'),'1828',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5030','MANZONI ALFONSO','PHDSTUDENT','3416',to_date('09-JUN-81','DD-MON-RR'),'523',null,'258');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5031','FO ANGELO','HEADMASTER','1034',to_date('09-JUN-81','DD-MON-RR'),'1642',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5032','BIANCHI FEDERICO','HEADMASTER','2252',to_date('09-JUN-81','DD-MON-RR'),'424',null,'294');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5033','FO DONATO','MANAGER','4152',to_date('09-JUN-81','DD-MON-RR'),'174',null,'77');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5034','GRIMALDI PAOLO','ENGINEER','3654',to_date('09-JUN-81','DD-MON-RR'),'1231',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6930','LEOPARDI LUCA','PROFESSOR','3294',to_date('09-JUN-81','DD-MON-RR'),'1725',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6931','TIBALDI LUCA','SECRETARY','2546',to_date('09-JUN-81','DD-MON-RR'),'1003',null,'477');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6932','LEOPARDI ROBERTA','PHDSTUDENT','660',to_date('09-JUN-81','DD-MON-RR'),'821',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6933','COZZA UMBERTO','PROFESSOR','287',to_date('09-JUN-81','DD-MON-RR'),'566',null,'488');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6934','PETRARCA LUDOVICO','SECRETARY','3054',to_date('09-JUN-81','DD-MON-RR'),'1108',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6935','SANTE SILVIA','TECHNICIAN','2193',to_date('09-JUN-81','DD-MON-RR'),'730',null,'221');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6936','CARBONE ANGELO','SUPERVISOR','613',to_date('09-JUN-81','DD-MON-RR'),'263',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6937','CARBONE DAMIANO','LAWYER','2092',to_date('09-JUN-81','DD-MON-RR'),'1709',null,'321');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6938','BIANCHI MARIA','SECRETARY','180',to_date('09-JUN-81','DD-MON-RR'),'86',null,'267');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6939','ESPOSITO MASSIMO','ENGINEER','5830',to_date('09-JUN-81','DD-MON-RR'),'1901',null,'395');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6940','LEVI ELIO','MANAGER','333',to_date('09-JUN-81','DD-MON-RR'),'245',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6941','DANTE DAMIANO','SECRETARY','6339',to_date('09-JUN-81','DD-MON-RR'),'1125',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6942','CORONA LUCA','SECRETARY','487',to_date('09-JUN-81','DD-MON-RR'),'1816',null,'277');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6943','CALVINO LUDOVICO','PHDSTUDENT','6695',to_date('09-JUN-81','DD-MON-RR'),'518',null,'300');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6944','PETRARCA ALFONSO','MANAGER','5104',to_date('09-JUN-81','DD-MON-RR'),'205',null,'31');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6945','SANTE ALFONSO','PROFESSOR','1428',to_date('09-JUN-81','DD-MON-RR'),'1238',null,'495');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6946','CALVINO FEDERICO','PROFESSOR','418',to_date('09-JUN-81','DD-MON-RR'),'45',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6947','COZZA UGO','LAWYER','4876',to_date('09-JUN-81','DD-MON-RR'),'1862',null,'271');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6948','DANTE MARIA','PROFESSOR','5657',to_date('09-JUN-81','DD-MON-RR'),'1217',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6949','ESPOSITO ANTONIO','MANAGER','3654',to_date('09-JUN-81','DD-MON-RR'),'1685',null,'199');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6950','CARBONE DAMIANO','ENGINEER','3170',to_date('09-JUN-81','DD-MON-RR'),'1148',null,'294');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6951','LEOPARDI ELIO','PROFESSOR','6337',to_date('09-JUN-81','DD-MON-RR'),'1770',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6952','SANTE MARIA','PHDSTUDENT','3987',to_date('09-JUN-81','DD-MON-RR'),'1176',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6953','ESPOSITO DAMIANO','MANAGER','6201',to_date('09-JUN-81','DD-MON-RR'),'1319',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6954','LEVI ANGELO','SUPERVISOR','1558',to_date('09-JUN-81','DD-MON-RR'),'1200',null,'359');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6955','MANZONI ELENA','HEADMASTER','4136',to_date('09-JUN-81','DD-MON-RR'),'1288',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6956','MANZONI ELIO','MANAGER','6150',to_date('09-JUN-81','DD-MON-RR'),'5',null,'185');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6957','GRIMALDI ALFONSO','TECHNICIAN','1325',to_date('09-JUN-81','DD-MON-RR'),'1031',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6958','NERI PAOLO','HEADMASTER','6019',to_date('09-JUN-81','DD-MON-RR'),'1047',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6959','GRIMALDI ELIO','PHDSTUDENT','3545',to_date('09-JUN-81','DD-MON-RR'),'1349',null,'12');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6960','SANTE UGO','TECHNICIAN','2196',to_date('09-JUN-81','DD-MON-RR'),'1786',null,'428');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6961','LEOPARDI ANTONIO','TECHNICIAN','3224',to_date('09-JUN-81','DD-MON-RR'),'1924',null,'475');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6962','FO MARIO','HEADMASTER','641',to_date('09-JUN-81','DD-MON-RR'),'1519',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6963','TIBALDI ANDREA','HEADMASTER','4380',to_date('09-JUN-81','DD-MON-RR'),'660',null,'282');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6964','BIANCHI UMBERTO','ENGINEER','2819',to_date('09-JUN-81','DD-MON-RR'),'946',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6965','FUMAROLA UMBERTO','PHDSTUDENT','4481',to_date('09-JUN-81','DD-MON-RR'),'34',null,'441');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6966','CORONA UGO','SUPERVISOR','3133',to_date('09-JUN-81','DD-MON-RR'),'915',null,'461');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6967','NERI ROBERTA','HEADMASTER','2055',to_date('09-JUN-81','DD-MON-RR'),'768',null,'125');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6968','GRIMALDI MARIA','TECHNICIAN','5194',to_date('09-JUN-81','DD-MON-RR'),'1902',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6969','CORONA IVANO','TECHNICIAN','2272',to_date('09-JUN-81','DD-MON-RR'),'671',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6970','FO DAMIANO','TECHNICIAN','37',to_date('09-JUN-81','DD-MON-RR'),'818',null,'101');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6971','ECO PAOLO','LAWYER','5908',to_date('09-JUN-81','DD-MON-RR'),'720',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6972','FUMAROLA LUDOVICO','PROFESSOR','1820',to_date('09-JUN-81','DD-MON-RR'),'113',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6973','GRIMALDI LUCIA','MANAGER','1589',to_date('09-JUN-81','DD-MON-RR'),'1012',null,'302');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6974','SANTE ELENA','TECHNICIAN','1983',to_date('09-JUN-81','DD-MON-RR'),'285',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6975','SANTE DONATO','SECRETARY','6649',to_date('09-JUN-81','DD-MON-RR'),'329',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6976','BIANCHI DAMIANO','HEADMASTER','2462',to_date('09-JUN-81','DD-MON-RR'),'1799',null,'158');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6977','ESPOSITO LUCIA','ENGINEER','6659',to_date('09-JUN-81','DD-MON-RR'),'1861',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6978','LEVI ANGELO','SECRETARY','6548',to_date('09-JUN-81','DD-MON-RR'),'1341',null,'201');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6979','CARBONE MASSIMO','PHDSTUDENT','544',to_date('09-JUN-81','DD-MON-RR'),'459',null,'181');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6980','FO MASSIMO','HEADMASTER','4092',to_date('09-JUN-81','DD-MON-RR'),'1901',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6981','SANTE LUCA','MANAGER','4116',to_date('09-JUN-81','DD-MON-RR'),'919',null,'319');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6982','TIBALDI LUIGI','MANAGER','6882',to_date('09-JUN-81','DD-MON-RR'),'844',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6983','NERI LUDOVICO','PROFESSOR','122',to_date('09-JUN-81','DD-MON-RR'),'1291',null,'176');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6984','FUMAROLA LUCIA','MANAGER','4467',to_date('09-JUN-81','DD-MON-RR'),'533',null,'263');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6985','PETRARCA ALFONSO','LAWYER','3656',to_date('09-JUN-81','DD-MON-RR'),'1604',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6986','ESPOSITO FRANCESCO','HEADMASTER','6625',to_date('09-JUN-81','DD-MON-RR'),'49',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6987','CARBONE CLARA','HEADMASTER','6251',to_date('09-JUN-81','DD-MON-RR'),'1834',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6988','LEOPARDI COSIMO','TECHNICIAN','5695',to_date('09-JUN-81','DD-MON-RR'),'112',null,'142');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6989','NERI PASQUALE','TECHNICIAN','3251',to_date('09-JUN-81','DD-MON-RR'),'232',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6990','CALVINO LUIGI','LAWYER','3617',to_date('09-JUN-81','DD-MON-RR'),'1283',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6991','BIANCHI ANTONIO','SUPERVISOR','4026',to_date('09-JUN-81','DD-MON-RR'),'1599',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6992','PETRARCA FEDERICO','ENGINEER','898',to_date('09-JUN-81','DD-MON-RR'),'562',null,'33');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6993','NERI COSIMO','SECRETARY','4898',to_date('09-JUN-81','DD-MON-RR'),'459',null,'81');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6994','COZZA ANDREA','MANAGER','3220',to_date('09-JUN-81','DD-MON-RR'),'1725',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6995','NERI SILVIA','ENGINEER','1107',to_date('09-JUN-81','DD-MON-RR'),'745',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6996','ESPOSITO IVANO','PROFESSOR','776',to_date('09-JUN-81','DD-MON-RR'),'1883',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6997','BIANCHI FEDERICO','MANAGER','3352',to_date('09-JUN-81','DD-MON-RR'),'1377',null,'416');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6998','MANZONI ALFONSO','MANAGER','4565',to_date('09-JUN-81','DD-MON-RR'),'900',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6999','CALVINO ELIO','MANAGER','3172',to_date('09-JUN-81','DD-MON-RR'),'1793',null,'369');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7000','FUMAROLA GAETANO','SUPERVISOR','566',to_date('09-JUN-81','DD-MON-RR'),'513',null,'483');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7001','COZZA GIOVANNI','PROFESSOR','6729',to_date('09-JUN-81','DD-MON-RR'),'569',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7002','TIBALDI ANTONIO','SUPERVISOR','4755',to_date('09-JUN-81','DD-MON-RR'),'186',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7003','FO ALFONSO','PHDSTUDENT','5329',to_date('09-JUN-81','DD-MON-RR'),'584',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7004','PETRARCA ANDREA','PROFESSOR','803',to_date('09-JUN-81','DD-MON-RR'),'1119',null,'28');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7005','FO MARIA','MANAGER','3126',to_date('09-JUN-81','DD-MON-RR'),'1697',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7006','LEVI FRANCESCO','TECHNICIAN','5216',to_date('09-JUN-81','DD-MON-RR'),'810',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7007','NERI LUCA','MANAGER','5976',to_date('09-JUN-81','DD-MON-RR'),'422',null,'288');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7008','CARBONE ROBERTA','SECRETARY','4550',to_date('09-JUN-81','DD-MON-RR'),'970',null,'254');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7009','DANTE UMBERTO','HEADMASTER','3729',to_date('09-JUN-81','DD-MON-RR'),'1677',null,'87');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7010','LEOPARDI FEDERICO','ENGINEER','5211',to_date('09-JUN-81','DD-MON-RR'),'276',null,'395');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7011','LEOPARDI ANTONIO','SECRETARY','5188',to_date('09-JUN-81','DD-MON-RR'),'590',null,'320');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7012','GRIMALDI GIOVANNI','PHDSTUDENT','656',to_date('09-JUN-81','DD-MON-RR'),'333',null,'192');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7013','CALVINO ELIO','ENGINEER','6221',to_date('09-JUN-81','DD-MON-RR'),'384',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7014','GRIMALDI MASSIMO','MANAGER','76',to_date('09-JUN-81','DD-MON-RR'),'193',null,'78');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7015','MANZONI COSIMO','SECRETARY','903',to_date('09-JUN-81','DD-MON-RR'),'858',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7016','FUMAROLA ELENA','PROFESSOR','1094',to_date('09-JUN-81','DD-MON-RR'),'647',null,'416');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7017','CALVINO SILVIA','TECHNICIAN','6806',to_date('09-JUN-81','DD-MON-RR'),'54',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7018','BIANCHI GIOVANNI','ENGINEER','3249',to_date('09-JUN-81','DD-MON-RR'),'1169',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7019','ESPOSITO CLARA','SUPERVISOR','2628',to_date('09-JUN-81','DD-MON-RR'),'1983',null,'354');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7020','TIBALDI LUCA','ENGINEER','2666',to_date('09-JUN-81','DD-MON-RR'),'612',null,'412');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7021','LEOPARDI DONATO','PROFESSOR','6344',to_date('09-JUN-81','DD-MON-RR'),'764',null,'365');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7022','NERI UMBERTO','MANAGER','6193',to_date('09-JUN-81','DD-MON-RR'),'298',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7023','CORONA COSIMO','SUPERVISOR','354',to_date('09-JUN-81','DD-MON-RR'),'1933',null,'487');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7024','BIANCHI COSIMO','PHDSTUDENT','4994',to_date('09-JUN-81','DD-MON-RR'),'795',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7025','TIBALDI GAETANO','HEADMASTER','5733',to_date('09-JUN-81','DD-MON-RR'),'618',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7026','FO LUCIA','LAWYER','341',to_date('09-JUN-81','DD-MON-RR'),'1158',null,'20');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7027','BIANCHI UGO','ENGINEER','3135',to_date('09-JUN-81','DD-MON-RR'),'394',null,'184');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7028','CORONA ANGELO','ENGINEER','3723',to_date('09-JUN-81','DD-MON-RR'),'884',null,'419');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7029','MANZONI SILVIA','TECHNICIAN','3245',to_date('09-JUN-81','DD-MON-RR'),'503',null,'130');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7030','MANZONI LUIGI','MANAGER','3758',to_date('09-JUN-81','DD-MON-RR'),'977',null,'249');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7031','LEOPARDI LUIGI','MANAGER','4385',to_date('09-JUN-81','DD-MON-RR'),'355',null,'376');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7032','SANTE PAOLO','HEADMASTER','6213',to_date('09-JUN-81','DD-MON-RR'),'808',null,'132');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7033','CALVINO GIOVANNI','TECHNICIAN','878',to_date('09-JUN-81','DD-MON-RR'),'146',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7034','CARBONE MASSIMO','ENGINEER','5814',to_date('09-JUN-81','DD-MON-RR'),'80',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7035','BIANCHI SILVIA','HEADMASTER','1946',to_date('09-JUN-81','DD-MON-RR'),'1969',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7036','DANTE PAOLO','MANAGER','6679',to_date('09-JUN-81','DD-MON-RR'),'1148',null,'179');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7037','FUMAROLA GAETANO','SECRETARY','5424',to_date('09-JUN-81','DD-MON-RR'),'243',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7038','CALVINO MASSIMO','PHDSTUDENT','4880',to_date('09-JUN-81','DD-MON-RR'),'998',null,'169');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7039','LEOPARDI LUIGI','ENGINEER','3046',to_date('09-JUN-81','DD-MON-RR'),'580',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7040','LEVI DAMIANO','SUPERVISOR','6256',to_date('09-JUN-81','DD-MON-RR'),'1307',null,'195');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7041','CALVINO MASSIMO','TECHNICIAN','868',to_date('09-JUN-81','DD-MON-RR'),'757',null,'458');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7042','MANZONI LUIGI','LAWYER','5633',to_date('09-JUN-81','DD-MON-RR'),'1703',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7043','LEOPARDI PAOLO','SECRETARY','5538',to_date('09-JUN-81','DD-MON-RR'),'1163',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7044','TIBALDI ALFONSO','ENGINEER','290',to_date('09-JUN-81','DD-MON-RR'),'1614',null,'451');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7045','SANTE MASSIMO','ENGINEER','2856',to_date('09-JUN-81','DD-MON-RR'),'41',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7046','SANTE COSIMO','MANAGER','981',to_date('09-JUN-81','DD-MON-RR'),'170',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7047','GRIMALDI SILVIA','LAWYER','1485',to_date('09-JUN-81','DD-MON-RR'),'736',null,'337');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7048','ECO UGO','PHDSTUDENT','977',to_date('09-JUN-81','DD-MON-RR'),'1351',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7049','SANTE DONATO','MANAGER','6364',to_date('09-JUN-81','DD-MON-RR'),'1683',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7050','BIANCHI MASSIMO','TECHNICIAN','617',to_date('09-JUN-81','DD-MON-RR'),'491',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8048','FUMAROLA MASSIMO','PHDSTUDENT','7703',to_date('09-JUN-81','DD-MON-RR'),'1190',null,'391');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8049','CORONA ALFONSO','ENGINEER','1809',to_date('09-JUN-81','DD-MON-RR'),'1513',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8050','ECO CLARA','TECHNICIAN','3430',to_date('09-JUN-81','DD-MON-RR'),'410',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8051','TIBALDI MARIA','PROFESSOR','2170',to_date('09-JUN-81','DD-MON-RR'),'1104',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8052','ESPOSITO LUCA','SECRETARY','2167',to_date('09-JUN-81','DD-MON-RR'),'895',null,'481');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8053','GRIMALDI IVANO','PROFESSOR','2225',to_date('09-JUN-81','DD-MON-RR'),'282',null,'368');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8054','COZZA ANGELO','LAWYER','6509',to_date('09-JUN-81','DD-MON-RR'),'214',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8055','PETRARCA ELIO','MANAGER','2505',to_date('09-JUN-81','DD-MON-RR'),'111',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8056','TIBALDI MASSIMO','SECRETARY','1765',to_date('09-JUN-81','DD-MON-RR'),'965',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8057','SANTE LUDOVICO','MANAGER','7078',to_date('09-JUN-81','DD-MON-RR'),'1163',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8058','GRIMALDI PAOLO','PHDSTUDENT','7916',to_date('09-JUN-81','DD-MON-RR'),'1040',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8059','COZZA GAETANO','MANAGER','5751',to_date('09-JUN-81','DD-MON-RR'),'774',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8060','NERI ALFONSO','HEADMASTER','6878',to_date('09-JUN-81','DD-MON-RR'),'353',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8061','LEOPARDI GAETANO','HEADMASTER','4814',to_date('09-JUN-81','DD-MON-RR'),'22',null,'36');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1770','TIBALDI PAOLO','PHDSTUDENT','1458',to_date('09-JUN-81','DD-MON-RR'),'1358',null,'419');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1771','MANZONI ANTONIO','TECHNICIAN','1043',to_date('09-JUN-81','DD-MON-RR'),'897',null,'359');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1772','PETRARCA ALFONSO','MANAGER','1001',to_date('09-JUN-81','DD-MON-RR'),'1221',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1773','LEVI MARIA','MANAGER','1742',to_date('09-JUN-81','DD-MON-RR'),'1450',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1774','NERI ELENA','HEADMASTER','1727',to_date('09-JUN-81','DD-MON-RR'),'670',null,'44');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1775','TIBALDI DONATO','SECRETARY','1569',to_date('09-JUN-81','DD-MON-RR'),'495',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1776','COZZA MASSIMO','TECHNICIAN','782',to_date('09-JUN-81','DD-MON-RR'),'740',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1777','GRIMALDI PAOLO','ENGINEER','210',to_date('09-JUN-81','DD-MON-RR'),'1304',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1778','TIBALDI LUCA','ENGINEER','1048',to_date('09-JUN-81','DD-MON-RR'),'430',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1779','BIANCHI LUCIA','ENGINEER','347',to_date('09-JUN-81','DD-MON-RR'),'1771',null,'91');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1780','FO GAETANO','SUPERVISOR','1116',to_date('09-JUN-81','DD-MON-RR'),'646',null,'426');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1781','CARBONE DAMIANO','SUPERVISOR','907',to_date('09-JUN-81','DD-MON-RR'),'971',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1782','CALVINO ELIO','MANAGER','17',to_date('09-JUN-81','DD-MON-RR'),'1528',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1783','DANTE LUCIA','SECRETARY','659',to_date('09-JUN-81','DD-MON-RR'),'353',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1784','CARBONE DONATO','HEADMASTER','891',to_date('09-JUN-81','DD-MON-RR'),'1526',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1785','MANZONI MASSIMO','PROFESSOR','513',to_date('09-JUN-81','DD-MON-RR'),'1350',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1786','FUMAROLA MASSIMO','SUPERVISOR','1386',to_date('09-JUN-81','DD-MON-RR'),'1667',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1787','MANZONI ANGELO','SUPERVISOR','1558',to_date('09-JUN-81','DD-MON-RR'),'1324',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1788','NERI IVANO','SUPERVISOR','1057',to_date('09-JUN-81','DD-MON-RR'),'1688',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1789','CORONA ANDREA','SECRETARY','1584',to_date('09-JUN-81','DD-MON-RR'),'1994',null,'393');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1790','LEVI UMBERTO','MANAGER','542',to_date('09-JUN-81','DD-MON-RR'),'1934',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1791','ECO LUCA','SECRETARY','1524',to_date('09-JUN-81','DD-MON-RR'),'1769',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1792','DANTE ELENA','PHDSTUDENT','112',to_date('09-JUN-81','DD-MON-RR'),'1075',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1793','TIBALDI COSIMO','PROFESSOR','63',to_date('09-JUN-81','DD-MON-RR'),'1489',null,'151');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1794','DANTE CLARA','HEADMASTER','926',to_date('09-JUN-81','DD-MON-RR'),'826',null,'398');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1795','FUMAROLA ELENA','MANAGER','250',to_date('09-JUN-81','DD-MON-RR'),'1181',null,'221');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1796','SANTE FRANCESCO','SUPERVISOR','871',to_date('09-JUN-81','DD-MON-RR'),'992',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1797','SANTE PAOLO','PHDSTUDENT','855',to_date('09-JUN-81','DD-MON-RR'),'1386',null,'320');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1798','LEOPARDI SILVIA','PHDSTUDENT','1652',to_date('09-JUN-81','DD-MON-RR'),'968',null,'269');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1799','ESPOSITO ANGELO','MANAGER','38',to_date('09-JUN-81','DD-MON-RR'),'985',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1800','CALVINO ALFONSO','LAWYER','530',to_date('09-JUN-81','DD-MON-RR'),'1872',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1801','TIBALDI UMBERTO','TECHNICIAN','521',to_date('09-JUN-81','DD-MON-RR'),'143',null,'249');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1802','FO COSIMO','ENGINEER','1492',to_date('09-JUN-81','DD-MON-RR'),'1405',null,'411');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1803','DANTE MARIA','PROFESSOR','472',to_date('09-JUN-81','DD-MON-RR'),'164',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1804','SANTE ELIO','SECRETARY','1560',to_date('09-JUN-81','DD-MON-RR'),'650',null,'112');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1805','FUMAROLA CLARA','PROFESSOR','199',to_date('09-JUN-81','DD-MON-RR'),'876',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('875','FUMAROLA ROBERTA','PHDSTUDENT','491',to_date('09-JUN-81','DD-MON-RR'),'235',null,'394');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('876','DANTE PASQUALE','PROFESSOR','632',to_date('09-JUN-81','DD-MON-RR'),'1722',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('877','FUMAROLA UMBERTO','SUPERVISOR','511',to_date('09-JUN-81','DD-MON-RR'),'1637',null,'423');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('878','NERI ELIO','ENGINEER','310',to_date('09-JUN-81','DD-MON-RR'),'848',null,'57');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('879','CARBONE MARIO','SECRETARY','78',to_date('09-JUN-81','DD-MON-RR'),'1501',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('880','ESPOSITO LUCA','SUPERVISOR','573',to_date('09-JUN-81','DD-MON-RR'),'1605',null,'54');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('881','ESPOSITO DAMIANO','LAWYER','462',to_date('09-JUN-81','DD-MON-RR'),'1334',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('882','MANZONI FRANCESCO','MANAGER','157',to_date('09-JUN-81','DD-MON-RR'),'455',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('883','NERI UGO','TECHNICIAN','834',to_date('09-JUN-81','DD-MON-RR'),'1997',null,'333');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('884','CALVINO MARIA','MANAGER','709',to_date('09-JUN-81','DD-MON-RR'),'627',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('885','ECO LUCIA','ENGINEER','821',to_date('09-JUN-81','DD-MON-RR'),'1023',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('886','MANZONI MASSIMO','MANAGER','636',to_date('09-JUN-81','DD-MON-RR'),'954',null,'436');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('887','DANTE FRANCESCO','PROFESSOR','551',to_date('09-JUN-81','DD-MON-RR'),'991',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('888','LEOPARDI UMBERTO','PHDSTUDENT','40',to_date('09-JUN-81','DD-MON-RR'),'933',null,'194');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('889','CARBONE DONATO','TECHNICIAN','158',to_date('09-JUN-81','DD-MON-RR'),'660',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('890','SANTE PAOLO','TECHNICIAN','756',to_date('09-JUN-81','DD-MON-RR'),'391',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('891','PETRARCA ANDREA','LAWYER','279',to_date('09-JUN-81','DD-MON-RR'),'1904',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('892','CARBONE FEDERICO','TECHNICIAN','627',to_date('09-JUN-81','DD-MON-RR'),'1669',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('893','ECO PASQUALE','SUPERVISOR','747',to_date('09-JUN-81','DD-MON-RR'),'1367',null,'264');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('894','FUMAROLA DAMIANO','PHDSTUDENT','750',to_date('09-JUN-81','DD-MON-RR'),'1151',null,'193');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('895','LEVI GAETANO','MANAGER','495',to_date('09-JUN-81','DD-MON-RR'),'1637',null,'424');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('896','PETRARCA ANTONIO','MANAGER','92',to_date('09-JUN-81','DD-MON-RR'),'483',null,'18');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('897','PETRARCA DAMIANO','SUPERVISOR','785',to_date('09-JUN-81','DD-MON-RR'),'263',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('898','CORONA PASQUALE','MANAGER','428',to_date('09-JUN-81','DD-MON-RR'),'832',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('899','MANZONI PAOLO','HEADMASTER','56',to_date('09-JUN-81','DD-MON-RR'),'961',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('900','PETRARCA GIOVANNI','SUPERVISOR','94',to_date('09-JUN-81','DD-MON-RR'),'1602',null,'83');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('901','TIBALDI IVANO','ENGINEER','34',to_date('09-JUN-81','DD-MON-RR'),'1514',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('902','FUMAROLA ELIO','ENGINEER','291',to_date('09-JUN-81','DD-MON-RR'),'925',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('903','CORONA LUIGI','SECRETARY','116',to_date('09-JUN-81','DD-MON-RR'),'712',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('904','PETRARCA FRANCESCO','SUPERVISOR','304',to_date('09-JUN-81','DD-MON-RR'),'852',null,'6');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('905','CORONA ANDREA','SECRETARY','56',to_date('09-JUN-81','DD-MON-RR'),'1962',null,'31');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('906','LEVI ANDREA','MANAGER','292',to_date('09-JUN-81','DD-MON-RR'),'1948',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('907','LEOPARDI GAETANO','PHDSTUDENT','383',to_date('09-JUN-81','DD-MON-RR'),'744',null,'262');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('908','FUMAROLA IVANO','MANAGER','721',to_date('09-JUN-81','DD-MON-RR'),'1817',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('909','DANTE LUCIA','TECHNICIAN','198',to_date('09-JUN-81','DD-MON-RR'),'1558',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('910','DANTE GIOVANNI','SECRETARY','449',to_date('09-JUN-81','DD-MON-RR'),'1113',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('911','MANZONI LUCA','SUPERVISOR','248',to_date('09-JUN-81','DD-MON-RR'),'217',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('912','CORONA PASQUALE','PROFESSOR','736',to_date('09-JUN-81','DD-MON-RR'),'380',null,'368');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('913','FO SILVIA','LAWYER','671',to_date('09-JUN-81','DD-MON-RR'),'607',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('914','CORONA ANTONIO','PHDSTUDENT','563',to_date('09-JUN-81','DD-MON-RR'),'415',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('915','NERI ELIO','MANAGER','539',to_date('09-JUN-81','DD-MON-RR'),'1866',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('916','TIBALDI ANGELO','ENGINEER','309',to_date('09-JUN-81','DD-MON-RR'),'1524',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('917','COZZA ANTONIO','TECHNICIAN','17',to_date('09-JUN-81','DD-MON-RR'),'633',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('918','LEOPARDI UMBERTO','PROFESSOR','249',to_date('09-JUN-81','DD-MON-RR'),'769',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('919','CORONA ELENA','SUPERVISOR','519',to_date('09-JUN-81','DD-MON-RR'),'990',null,'280');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('920','FO LUDOVICO','SUPERVISOR','326',to_date('09-JUN-81','DD-MON-RR'),'500',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('921','ESPOSITO ALFONSO','LAWYER','496',to_date('09-JUN-81','DD-MON-RR'),'1168',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('922','CALVINO IVANO','SUPERVISOR','453',to_date('09-JUN-81','DD-MON-RR'),'513',null,'5');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('923','GRIMALDI ALFONSO','MANAGER','95',to_date('09-JUN-81','DD-MON-RR'),'569',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('924','COZZA ANTONIO','LAWYER','758',to_date('09-JUN-81','DD-MON-RR'),'1095',null,'209');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('925','CARBONE FEDERICO','MANAGER','354',to_date('09-JUN-81','DD-MON-RR'),'231',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('926','GRIMALDI ELENA','MANAGER','686',to_date('09-JUN-81','DD-MON-RR'),'1416',null,'80');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('927','COZZA ANDREA','SECRETARY','575',to_date('09-JUN-81','DD-MON-RR'),'664',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('928','CALVINO ELIO','HEADMASTER','271',to_date('09-JUN-81','DD-MON-RR'),'957',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('929','GRIMALDI COSIMO','MANAGER','242',to_date('09-JUN-81','DD-MON-RR'),'1535',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('930','DANTE PASQUALE','SUPERVISOR','707',to_date('09-JUN-81','DD-MON-RR'),'1067',null,'179');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('931','GRIMALDI PAOLO','HEADMASTER','620',to_date('09-JUN-81','DD-MON-RR'),'1184',null,'118');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('932','DANTE SILVIA','PROFESSOR','210',to_date('09-JUN-81','DD-MON-RR'),'279',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('933','TIBALDI ELENA','LAWYER','513',to_date('09-JUN-81','DD-MON-RR'),'128',null,'132');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('934','NERI ELIO','MANAGER','409',to_date('09-JUN-81','DD-MON-RR'),'1325',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('935','BIANCHI CLARA','PROFESSOR','153',to_date('09-JUN-81','DD-MON-RR'),'206',null,'331');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('936','FO DONATO','TECHNICIAN','49',to_date('09-JUN-81','DD-MON-RR'),'1720',null,'53');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('937','LEOPARDI ELENA','HEADMASTER','344',to_date('09-JUN-81','DD-MON-RR'),'1827',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('938','GRIMALDI DAMIANO','SUPERVISOR','528',to_date('09-JUN-81','DD-MON-RR'),'694',null,'300');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('939','MANZONI LUCA','SUPERVISOR','35',to_date('09-JUN-81','DD-MON-RR'),'578',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('940','MANZONI MASSIMO','MANAGER','136',to_date('09-JUN-81','DD-MON-RR'),'749',null,'55');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('941','MANZONI FRANCESCO','SUPERVISOR','303',to_date('09-JUN-81','DD-MON-RR'),'1903',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('942','MANZONI COSIMO','HEADMASTER','51',to_date('09-JUN-81','DD-MON-RR'),'1220',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('943','CALVINO DAMIANO','LAWYER','337',to_date('09-JUN-81','DD-MON-RR'),'1902',null,'455');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('944','DANTE UGO','TECHNICIAN','907',to_date('09-JUN-81','DD-MON-RR'),'1632',null,'25');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('945','BIANCHI LUCA','MANAGER','599',to_date('09-JUN-81','DD-MON-RR'),'1955',null,'317');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('946','ESPOSITO DONATO','PHDSTUDENT','49',to_date('09-JUN-81','DD-MON-RR'),'217',null,'243');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('947','CARBONE MASSIMO','MANAGER','67',to_date('09-JUN-81','DD-MON-RR'),'1186',null,'169');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('948','MANZONI LUIGI','MANAGER','381',to_date('09-JUN-81','DD-MON-RR'),'1543',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('949','LEOPARDI ANGELO','MANAGER','71',to_date('09-JUN-81','DD-MON-RR'),'1383',null,'136');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('950','NERI MARIA','PROFESSOR','367',to_date('09-JUN-81','DD-MON-RR'),'1906',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('951','LEOPARDI UMBERTO','LAWYER','529',to_date('09-JUN-81','DD-MON-RR'),'1503',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('952','SANTE UGO','SECRETARY','734',to_date('09-JUN-81','DD-MON-RR'),'83',null,'54');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('953','NERI ANDREA','SUPERVISOR','797',to_date('09-JUN-81','DD-MON-RR'),'567',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('954','GRIMALDI DAMIANO','PHDSTUDENT','926',to_date('09-JUN-81','DD-MON-RR'),'1343',null,'358');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('955','CALVINO ELIO','MANAGER','334',to_date('09-JUN-81','DD-MON-RR'),'367',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('956','CALVINO ANGELO','TECHNICIAN','290',to_date('09-JUN-81','DD-MON-RR'),'1527',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('957','GRIMALDI ANDREA','MANAGER','763',to_date('09-JUN-81','DD-MON-RR'),'1158',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('958','BIANCHI PAOLO','MANAGER','413',to_date('09-JUN-81','DD-MON-RR'),'1053',null,'308');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('959','LEVI FRANCESCO','SECRETARY','720',to_date('09-JUN-81','DD-MON-RR'),'26',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('960','LEVI MARIA','ENGINEER','483',to_date('09-JUN-81','DD-MON-RR'),'1216',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('961','LEVI DONATO','ENGINEER','172',to_date('09-JUN-81','DD-MON-RR'),'691',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('962','NERI LUDOVICO','HEADMASTER','28',to_date('09-JUN-81','DD-MON-RR'),'851',null,'111');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('963','CARBONE ALFONSO','ENGINEER','784',to_date('09-JUN-81','DD-MON-RR'),'1528',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('964','SANTE MASSIMO','SUPERVISOR','620',to_date('09-JUN-81','DD-MON-RR'),'483',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('965','SANTE IVANO','PROFESSOR','203',to_date('09-JUN-81','DD-MON-RR'),'427',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('966','LEOPARDI PAOLO','SECRETARY','145',to_date('09-JUN-81','DD-MON-RR'),'1770',null,'374');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('967','ECO FRANCESCO','PROFESSOR','610',to_date('09-JUN-81','DD-MON-RR'),'1069',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('968','BIANCHI DONATO','ENGINEER','742',to_date('09-JUN-81','DD-MON-RR'),'1662',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('969','MANZONI SILVIA','ENGINEER','667',to_date('09-JUN-81','DD-MON-RR'),'1810',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('970','CARBONE UMBERTO','MANAGER','908',to_date('09-JUN-81','DD-MON-RR'),'1290',null,'277');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('971','CARBONE GAETANO','MANAGER','681',to_date('09-JUN-81','DD-MON-RR'),'1746',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('972','FO DONATO','TECHNICIAN','803',to_date('09-JUN-81','DD-MON-RR'),'981',null,'93');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('686','LEOPARDI FRANCESCO','LAWYER','34',to_date('09-JUN-81','DD-MON-RR'),'513',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2870','NERI FEDERICO','LAWYER','2505',to_date('09-JUN-81','DD-MON-RR'),'1030',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2871','MANZONI MASSIMO','SECRETARY','2433',to_date('09-JUN-81','DD-MON-RR'),'780',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2872','ECO ANTONIO','TECHNICIAN','371',to_date('09-JUN-81','DD-MON-RR'),'368',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2873','NERI MASSIMO','PROFESSOR','2381',to_date('09-JUN-81','DD-MON-RR'),'1170',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2874','ECO PAOLO','LAWYER','2621',to_date('09-JUN-81','DD-MON-RR'),'1605',null,'341');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2875','GRIMALDI ANDREA','SUPERVISOR','973',to_date('09-JUN-81','DD-MON-RR'),'673',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2876','LEVI UMBERTO','SUPERVISOR','663',to_date('09-JUN-81','DD-MON-RR'),'863',null,'311');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2877','CORONA FRANCESCO','PROFESSOR','827',to_date('09-JUN-81','DD-MON-RR'),'173',null,'264');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2878','FUMAROLA ANDREA','TECHNICIAN','760',to_date('09-JUN-81','DD-MON-RR'),'1579',null,'168');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2879','GRIMALDI MASSIMO','MANAGER','2599',to_date('09-JUN-81','DD-MON-RR'),'1315',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2880','CALVINO ELENA','MANAGER','1300',to_date('09-JUN-81','DD-MON-RR'),'1817',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2881','ECO ANTONIO','PHDSTUDENT','186',to_date('09-JUN-81','DD-MON-RR'),'1625',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2882','BIANCHI LUCIA','SUPERVISOR','93',to_date('09-JUN-81','DD-MON-RR'),'1475',null,'233');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2883','ESPOSITO ELIO','HEADMASTER','903',to_date('09-JUN-81','DD-MON-RR'),'1744',null,'108');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2884','FO GIOVANNI','ENGINEER','1312',to_date('09-JUN-81','DD-MON-RR'),'1303',null,'309');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2885','COZZA CLARA','MANAGER','384',to_date('09-JUN-81','DD-MON-RR'),'1379',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2886','DANTE ALFONSO','MANAGER','1537',to_date('09-JUN-81','DD-MON-RR'),'1171',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2887','ECO MARIA','MANAGER','970',to_date('09-JUN-81','DD-MON-RR'),'613',null,'341');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2888','PETRARCA MARIA','LAWYER','666',to_date('09-JUN-81','DD-MON-RR'),'362',null,'81');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2889','LEOPARDI PAOLO','MANAGER','1184',to_date('09-JUN-81','DD-MON-RR'),'574',null,'281');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2890','COZZA MARIA','MANAGER','635',to_date('09-JUN-81','DD-MON-RR'),'965',null,'245');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2891','FUMAROLA MARIO','ENGINEER','0',to_date('09-JUN-81','DD-MON-RR'),'1113',null,'299');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2892','PETRARCA UGO','SECRETARY','1268',to_date('09-JUN-81','DD-MON-RR'),'1696',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2893','ECO FEDERICO','MANAGER','1188',to_date('09-JUN-81','DD-MON-RR'),'1764',null,'114');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2894','LEVI LUCA','SECRETARY','1400',to_date('09-JUN-81','DD-MON-RR'),'1480',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2895','SANTE MARIA','PROFESSOR','2454',to_date('09-JUN-81','DD-MON-RR'),'1979',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2896','FO ANDREA','MANAGER','1017',to_date('09-JUN-81','DD-MON-RR'),'617',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2897','SANTE FEDERICO','PHDSTUDENT','2380',to_date('09-JUN-81','DD-MON-RR'),'483',null,'60');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2898','NERI ANGELO','PROFESSOR','138',to_date('09-JUN-81','DD-MON-RR'),'1546',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2899','PETRARCA FEDERICO','ENGINEER','975',to_date('09-JUN-81','DD-MON-RR'),'1660',null,'362');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2900','NERI ROBERTA','LAWYER','1103',to_date('09-JUN-81','DD-MON-RR'),'1450',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2901','CARBONE IVANO','TECHNICIAN','2214',to_date('09-JUN-81','DD-MON-RR'),'830',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2902','PETRARCA LUCIA','HEADMASTER','2309',to_date('09-JUN-81','DD-MON-RR'),'372',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2903','LEVI IVANO','LAWYER','2000',to_date('09-JUN-81','DD-MON-RR'),'469',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2904','FUMAROLA ROBERTA','MANAGER','954',to_date('09-JUN-81','DD-MON-RR'),'1694',null,'229');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2905','ECO DONATO','ENGINEER','1593',to_date('09-JUN-81','DD-MON-RR'),'1823',null,'30');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2906','ECO PASQUALE','MANAGER','2400',to_date('09-JUN-81','DD-MON-RR'),'470',null,'269');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2907','SANTE ELIO','PROFESSOR','2421',to_date('09-JUN-81','DD-MON-RR'),'1108',null,'45');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2908','ESPOSITO FRANCESCO','MANAGER','1419',to_date('09-JUN-81','DD-MON-RR'),'319',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2909','CALVINO ANGELO','LAWYER','1159',to_date('09-JUN-81','DD-MON-RR'),'1664',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2910','LEVI ALFONSO','SECRETARY','561',to_date('09-JUN-81','DD-MON-RR'),'868',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2911','FUMAROLA DAMIANO','PHDSTUDENT','1102',to_date('09-JUN-81','DD-MON-RR'),'586',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2912','CARBONE COSIMO','MANAGER','2396',to_date('09-JUN-81','DD-MON-RR'),'108',null,'166');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2913','COZZA IVANO','HEADMASTER','557',to_date('09-JUN-81','DD-MON-RR'),'1043',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2914','PETRARCA DAMIANO','LAWYER','2118',to_date('09-JUN-81','DD-MON-RR'),'1381',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2915','FO MARIO','LAWYER','2912',to_date('09-JUN-81','DD-MON-RR'),'1482',null,'310');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2916','TIBALDI PAOLO','TECHNICIAN','285',to_date('09-JUN-81','DD-MON-RR'),'747',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2917','PETRARCA LUCIA','HEADMASTER','2618',to_date('09-JUN-81','DD-MON-RR'),'230',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2918','CORONA CLARA','MANAGER','104',to_date('09-JUN-81','DD-MON-RR'),'441',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2919','PETRARCA FEDERICO','PHDSTUDENT','1365',to_date('09-JUN-81','DD-MON-RR'),'1302',null,'97');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2920','FUMAROLA ALFONSO','ENGINEER','2786',to_date('09-JUN-81','DD-MON-RR'),'495',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2921','FO ANTONIO','LAWYER','1935',to_date('09-JUN-81','DD-MON-RR'),'1317',null,'426');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2922','DANTE FRANCESCO','SECRETARY','1889',to_date('09-JUN-81','DD-MON-RR'),'1350',null,'130');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2923','GRIMALDI LUCA','TECHNICIAN','2906',to_date('09-JUN-81','DD-MON-RR'),'1884',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2924','NERI ANTONIO','SUPERVISOR','2081',to_date('09-JUN-81','DD-MON-RR'),'820',null,'43');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2925','DANTE SILVIA','SUPERVISOR','1904',to_date('09-JUN-81','DD-MON-RR'),'265',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2926','LEOPARDI MASSIMO','MANAGER','1800',to_date('09-JUN-81','DD-MON-RR'),'740',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2927','GRIMALDI ANGELO','LAWYER','1798',to_date('09-JUN-81','DD-MON-RR'),'121',null,'127');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2928','CARBONE COSIMO','MANAGER','486',to_date('09-JUN-81','DD-MON-RR'),'717',null,'51');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2929','CALVINO UGO','SUPERVISOR','329',to_date('09-JUN-81','DD-MON-RR'),'554',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2930','ECO COSIMO','HEADMASTER','1564',to_date('09-JUN-81','DD-MON-RR'),'1671',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2931','CORONA UMBERTO','ENGINEER','763',to_date('09-JUN-81','DD-MON-RR'),'1174',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2932','CALVINO GAETANO','MANAGER','1883',to_date('09-JUN-81','DD-MON-RR'),'1341',null,'159');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2933','CORONA LUIGI','SUPERVISOR','171',to_date('09-JUN-81','DD-MON-RR'),'1425',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2934','DANTE FRANCESCO','PHDSTUDENT','609',to_date('09-JUN-81','DD-MON-RR'),'1004',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2935','BIANCHI DAMIANO','PROFESSOR','873',to_date('09-JUN-81','DD-MON-RR'),'469',null,'453');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2936','LEOPARDI IVANO','PROFESSOR','1581',to_date('09-JUN-81','DD-MON-RR'),'1224',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2937','CALVINO ELIO','HEADMASTER','1885',to_date('09-JUN-81','DD-MON-RR'),'633',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2938','FO ELENA','ENGINEER','1896',to_date('09-JUN-81','DD-MON-RR'),'545',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2939','NERI LUIGI','ENGINEER','871',to_date('09-JUN-81','DD-MON-RR'),'1284',null,'171');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2940','PETRARCA LUDOVICO','TECHNICIAN','741',to_date('09-JUN-81','DD-MON-RR'),'1206',null,'139');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2941','COZZA GAETANO','MANAGER','107',to_date('09-JUN-81','DD-MON-RR'),'412',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2942','CORONA IVANO','MANAGER','66',to_date('09-JUN-81','DD-MON-RR'),'462',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2943','DANTE MARIO','PHDSTUDENT','2803',to_date('09-JUN-81','DD-MON-RR'),'1676',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2944','LEVI GIOVANNI','PHDSTUDENT','719',to_date('09-JUN-81','DD-MON-RR'),'1645',null,'398');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2945','ESPOSITO FEDERICO','ENGINEER','1859',to_date('09-JUN-81','DD-MON-RR'),'513',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2946','ESPOSITO LUCA','HEADMASTER','1594',to_date('09-JUN-81','DD-MON-RR'),'904',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2947','ECO MASSIMO','PHDSTUDENT','2067',to_date('09-JUN-81','DD-MON-RR'),'1952',null,'200');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2948','DANTE LUDOVICO','PROFESSOR','1134',to_date('09-JUN-81','DD-MON-RR'),'286',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2949','SANTE MARIO','PHDSTUDENT','771',to_date('09-JUN-81','DD-MON-RR'),'1582',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2950','PETRARCA PAOLO','HEADMASTER','481',to_date('09-JUN-81','DD-MON-RR'),'19',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2951','GRIMALDI LUCA','PROFESSOR','723',to_date('09-JUN-81','DD-MON-RR'),'923',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2952','GRIMALDI SILVIA','SECRETARY','2940',to_date('09-JUN-81','DD-MON-RR'),'1894',null,'419');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2953','LEOPARDI UGO','PROFESSOR','2926',to_date('09-JUN-81','DD-MON-RR'),'536',null,'86');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2954','DANTE FRANCESCO','SECRETARY','1124',to_date('09-JUN-81','DD-MON-RR'),'1271',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2955','SANTE MARIA','TECHNICIAN','2797',to_date('09-JUN-81','DD-MON-RR'),'1717',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2956','CARBONE PAOLO','PHDSTUDENT','1319',to_date('09-JUN-81','DD-MON-RR'),'1949',null,'140');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2957','TIBALDI SILVIA','HEADMASTER','647',to_date('09-JUN-81','DD-MON-RR'),'1593',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2958','CARBONE ELENA','PHDSTUDENT','261',to_date('09-JUN-81','DD-MON-RR'),'370',null,'313');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2959','PETRARCA CLARA','SECRETARY','2905',to_date('09-JUN-81','DD-MON-RR'),'1977',null,'318');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2960','NERI MASSIMO','ENGINEER','1133',to_date('09-JUN-81','DD-MON-RR'),'193',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2961','GRIMALDI MARIA','LAWYER','303',to_date('09-JUN-81','DD-MON-RR'),'1063',null,'447');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2962','FO PASQUALE','TECHNICIAN','2699',to_date('09-JUN-81','DD-MON-RR'),'213',null,'245');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2963','CALVINO MASSIMO','ENGINEER','2205',to_date('09-JUN-81','DD-MON-RR'),'507',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2964','ECO LUCIA','MANAGER','1101',to_date('09-JUN-81','DD-MON-RR'),'994',null,'233');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2965','PETRARCA ELIO','SECRETARY','1008',to_date('09-JUN-81','DD-MON-RR'),'747',null,'357');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2966','MANZONI ANGELO','LAWYER','1337',to_date('09-JUN-81','DD-MON-RR'),'1518',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2967','CORONA IVANO','SECRETARY','120',to_date('09-JUN-81','DD-MON-RR'),'109',null,'162');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2968','ECO LUCIA','TECHNICIAN','648',to_date('09-JUN-81','DD-MON-RR'),'370',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2969','DANTE LUIGI','MANAGER','1687',to_date('09-JUN-81','DD-MON-RR'),'1854',null,'378');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2970','BIANCHI DAMIANO','MANAGER','1939',to_date('09-JUN-81','DD-MON-RR'),'550',null,'60');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2971','NERI DONATO','SECRETARY','494',to_date('09-JUN-81','DD-MON-RR'),'514',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2972','LEOPARDI GAETANO','PHDSTUDENT','2126',to_date('09-JUN-81','DD-MON-RR'),'1287',null,'367');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2973','ESPOSITO ALFONSO','MANAGER','1576',to_date('09-JUN-81','DD-MON-RR'),'789',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2974','LEOPARDI PASQUALE','PROFESSOR','1584',to_date('09-JUN-81','DD-MON-RR'),'105',null,'421');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2975','ECO DAMIANO','LAWYER','108',to_date('09-JUN-81','DD-MON-RR'),'1482',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2976','LEOPARDI MASSIMO','ENGINEER','2782',to_date('09-JUN-81','DD-MON-RR'),'550',null,'58');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2977','COZZA ANTONIO','LAWYER','450',to_date('09-JUN-81','DD-MON-RR'),'975',null,'181');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2978','NERI ELENA','LAWYER','179',to_date('09-JUN-81','DD-MON-RR'),'116',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2979','FUMAROLA UMBERTO','PROFESSOR','1001',to_date('09-JUN-81','DD-MON-RR'),'1729',null,'235');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2980','MANZONI PASQUALE','LAWYER','2855',to_date('09-JUN-81','DD-MON-RR'),'381',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2981','ESPOSITO MARIA','PROFESSOR','2601',to_date('09-JUN-81','DD-MON-RR'),'566',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2982','LEVI FRANCESCO','LAWYER','2118',to_date('09-JUN-81','DD-MON-RR'),'1811',null,'472');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2983','ESPOSITO MARIA','LAWYER','1832',to_date('09-JUN-81','DD-MON-RR'),'1703',null,'265');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2984','CALVINO COSIMO','HEADMASTER','2890',to_date('09-JUN-81','DD-MON-RR'),'1216',null,'364');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2985','LEVI DONATO','PROFESSOR','2',to_date('09-JUN-81','DD-MON-RR'),'1492',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2986','CARBONE COSIMO','MANAGER','2129',to_date('09-JUN-81','DD-MON-RR'),'1262',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2987','GRIMALDI FRANCESCO','PROFESSOR','2558',to_date('09-JUN-81','DD-MON-RR'),'664',null,'183');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2988','PETRARCA MARIO','MANAGER','823',to_date('09-JUN-81','DD-MON-RR'),'41',null,'4');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2989','CALVINO ANTONIO','MANAGER','2007',to_date('09-JUN-81','DD-MON-RR'),'1077',null,'444');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2990','MANZONI ANTONIO','MANAGER','849',to_date('09-JUN-81','DD-MON-RR'),'1960',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2991','DANTE ANTONIO','TECHNICIAN','2334',to_date('09-JUN-81','DD-MON-RR'),'1991',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2992','SANTE PASQUALE','SUPERVISOR','2831',to_date('09-JUN-81','DD-MON-RR'),'502',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2993','ECO ANGELO','SUPERVISOR','1408',to_date('09-JUN-81','DD-MON-RR'),'657',null,'97');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2994','FO DONATO','TECHNICIAN','2278',to_date('09-JUN-81','DD-MON-RR'),'1615',null,'151');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2995','MANZONI FRANCESCO','ENGINEER','981',to_date('09-JUN-81','DD-MON-RR'),'985',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2996','CALVINO PASQUALE','MANAGER','2795',to_date('09-JUN-81','DD-MON-RR'),'1263',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2997','ESPOSITO MARIO','ENGINEER','542',to_date('09-JUN-81','DD-MON-RR'),'128',null,'93');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2998','LEOPARDI PASQUALE','HEADMASTER','364',to_date('09-JUN-81','DD-MON-RR'),'1695',null,'284');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2999','CARBONE ALFONSO','PHDSTUDENT','241',to_date('09-JUN-81','DD-MON-RR'),'177',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3000','LEOPARDI LUCA','MANAGER','2000',to_date('09-JUN-81','DD-MON-RR'),'134',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1922','PETRARCA MARIO','HEADMASTER','1316',to_date('09-JUN-81','DD-MON-RR'),'994',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1923','ESPOSITO COSIMO','PHDSTUDENT','391',to_date('09-JUN-81','DD-MON-RR'),'1916',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1924','BIANCHI ANGELO','LAWYER','1032',to_date('09-JUN-81','DD-MON-RR'),'859',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1925','LEVI ELIO','SECRETARY','1511',to_date('09-JUN-81','DD-MON-RR'),'1678',null,'443');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1926','LEOPARDI DAMIANO','ENGINEER','490',to_date('09-JUN-81','DD-MON-RR'),'1871',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3951','PETRARCA PASQUALE','LAWYER','3911',to_date('09-JUN-81','DD-MON-RR'),'285',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3952','BIANCHI PAOLO','TECHNICIAN','1707',to_date('09-JUN-81','DD-MON-RR'),'1135',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3953','CALVINO LUCIA','MANAGER','1489',to_date('09-JUN-81','DD-MON-RR'),'36',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3954','ESPOSITO CLARA','PHDSTUDENT','1008',to_date('09-JUN-81','DD-MON-RR'),'224',null,'337');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3955','ESPOSITO LUIGI','TECHNICIAN','3241',to_date('09-JUN-81','DD-MON-RR'),'1857',null,'177');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3956','COZZA ANDREA','ENGINEER','88',to_date('09-JUN-81','DD-MON-RR'),'977',null,'367');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3957','NERI UMBERTO','PROFESSOR','3535',to_date('09-JUN-81','DD-MON-RR'),'1731',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3958','MANZONI GIOVANNI','ENGINEER','539',to_date('09-JUN-81','DD-MON-RR'),'597',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3959','CORONA ANDREA','SECRETARY','3921',to_date('09-JUN-81','DD-MON-RR'),'667',null,'243');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3960','FUMAROLA LUCIA','MANAGER','1418',to_date('09-JUN-81','DD-MON-RR'),'490',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3961','ECO MARIA','SUPERVISOR','1212',to_date('09-JUN-81','DD-MON-RR'),'106',null,'317');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3962','SANTE CLARA','SECRETARY','939',to_date('09-JUN-81','DD-MON-RR'),'753',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3963','CALVINO UGO','MANAGER','2614',to_date('09-JUN-81','DD-MON-RR'),'1291',null,'77');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3964','GRIMALDI ANTONIO','PROFESSOR','2826',to_date('09-JUN-81','DD-MON-RR'),'918',null,'283');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3965','GRIMALDI SILVIA','MANAGER','3644',to_date('09-JUN-81','DD-MON-RR'),'964',null,'118');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3966','TIBALDI ANTONIO','SUPERVISOR','2822',to_date('09-JUN-81','DD-MON-RR'),'1003',null,'160');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3967','NERI LUCA','TECHNICIAN','1643',to_date('09-JUN-81','DD-MON-RR'),'1560',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3968','CORONA LUCIA','PHDSTUDENT','810',to_date('09-JUN-81','DD-MON-RR'),'880',null,'168');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3969','LEVI LUDOVICO','SECRETARY','2349',to_date('09-JUN-81','DD-MON-RR'),'980',null,'132');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3970','CARBONE PAOLO','LAWYER','601',to_date('09-JUN-81','DD-MON-RR'),'1220',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3971','NERI LUCA','SUPERVISOR','2609',to_date('09-JUN-81','DD-MON-RR'),'1776',null,'284');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3972','CALVINO UMBERTO','PROFESSOR','3112',to_date('09-JUN-81','DD-MON-RR'),'1296',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3973','PETRARCA SILVIA','SECRETARY','2605',to_date('09-JUN-81','DD-MON-RR'),'401',null,'55');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3974','PETRARCA GAETANO','PHDSTUDENT','3171',to_date('09-JUN-81','DD-MON-RR'),'303',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3975','ESPOSITO ANDREA','MANAGER','1792',to_date('09-JUN-81','DD-MON-RR'),'924',null,'340');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3976','GRIMALDI COSIMO','LAWYER','1542',to_date('09-JUN-81','DD-MON-RR'),'1015',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3977','FO ROBERTA','HEADMASTER','267',to_date('09-JUN-81','DD-MON-RR'),'540',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3978','FUMAROLA MARIA','LAWYER','2506',to_date('09-JUN-81','DD-MON-RR'),'1782',null,'412');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3979','CARBONE ANTONIO','HEADMASTER','2511',to_date('09-JUN-81','DD-MON-RR'),'1364',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3980','FUMAROLA ELENA','PHDSTUDENT','325',to_date('09-JUN-81','DD-MON-RR'),'391',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3981','SANTE ALFONSO','SUPERVISOR','2471',to_date('09-JUN-81','DD-MON-RR'),'1811',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3982','ESPOSITO MARIA','TECHNICIAN','1380',to_date('09-JUN-81','DD-MON-RR'),'1857',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3983','SANTE LUCA','SECRETARY','2388',to_date('09-JUN-81','DD-MON-RR'),'1034',null,'276');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3984','LEOPARDI SILVIA','ENGINEER','3229',to_date('09-JUN-81','DD-MON-RR'),'1781',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3985','PETRARCA DONATO','SECRETARY','776',to_date('09-JUN-81','DD-MON-RR'),'1965',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3986','CARBONE ANTONIO','PROFESSOR','2648',to_date('09-JUN-81','DD-MON-RR'),'733',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3987','FO MARIO','PHDSTUDENT','1943',to_date('09-JUN-81','DD-MON-RR'),'160',null,'136');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3988','CORONA LUCIA','HEADMASTER','2288',to_date('09-JUN-81','DD-MON-RR'),'1309',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3989','COZZA DAMIANO','TECHNICIAN','2243',to_date('09-JUN-81','DD-MON-RR'),'1781',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3990','FUMAROLA IVANO','SUPERVISOR','2174',to_date('09-JUN-81','DD-MON-RR'),'865',null,'356');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3991','CORONA FEDERICO','SUPERVISOR','725',to_date('09-JUN-81','DD-MON-RR'),'1203',null,'412');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3992','CARBONE SILVIA','LAWYER','36',to_date('09-JUN-81','DD-MON-RR'),'843',null,'319');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3993','COZZA MASSIMO','MANAGER','1771',to_date('09-JUN-81','DD-MON-RR'),'1817',null,'174');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3994','CORONA ELENA','SUPERVISOR','237',to_date('09-JUN-81','DD-MON-RR'),'1194',null,'159');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3995','GRIMALDI MARIO','SECRETARY','2465',to_date('09-JUN-81','DD-MON-RR'),'1646',null,'495');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3996','PETRARCA ALFONSO','SUPERVISOR','3149',to_date('09-JUN-81','DD-MON-RR'),'1218',null,'264');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3997','CORONA FRANCESCO','ENGINEER','687',to_date('09-JUN-81','DD-MON-RR'),'565',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3998','CALVINO FRANCESCO','SECRETARY','2017',to_date('09-JUN-81','DD-MON-RR'),'18',null,'64');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3999','FUMAROLA GAETANO','MANAGER','1126',to_date('09-JUN-81','DD-MON-RR'),'381',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4000','CARBONE LUCIA','SECRETARY','633',to_date('09-JUN-81','DD-MON-RR'),'1391',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4001','SANTE LUCA','SECRETARY','305',to_date('09-JUN-81','DD-MON-RR'),'1626',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4002','LEVI COSIMO','TECHNICIAN','278',to_date('09-JUN-81','DD-MON-RR'),'1197',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4003','DANTE ROBERTA','MANAGER','703',to_date('09-JUN-81','DD-MON-RR'),'1829',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4004','NERI FEDERICO','PHDSTUDENT','1876',to_date('09-JUN-81','DD-MON-RR'),'99',null,'176');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4005','SANTE ANDREA','MANAGER','1075',to_date('09-JUN-81','DD-MON-RR'),'1617',null,'63');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4006','CARBONE ANDREA','HEADMASTER','1684',to_date('09-JUN-81','DD-MON-RR'),'67',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4007','FO PAOLO','PHDSTUDENT','1974',to_date('09-JUN-81','DD-MON-RR'),'1418',null,'495');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4008','MANZONI DONATO','LAWYER','3888',to_date('09-JUN-81','DD-MON-RR'),'1680',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4009','MANZONI LUCA','SUPERVISOR','653',to_date('09-JUN-81','DD-MON-RR'),'1227',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4010','COZZA ELIO','SUPERVISOR','3797',to_date('09-JUN-81','DD-MON-RR'),'223',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4011','SANTE CLARA','PHDSTUDENT','907',to_date('09-JUN-81','DD-MON-RR'),'1326',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4012','FUMAROLA ANDREA','TECHNICIAN','2345',to_date('09-JUN-81','DD-MON-RR'),'951',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4013','TIBALDI GIOVANNI','PHDSTUDENT','3921',to_date('09-JUN-81','DD-MON-RR'),'788',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4014','MANZONI IVANO','LAWYER','1510',to_date('09-JUN-81','DD-MON-RR'),'1116',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4015','MANZONI UGO','TECHNICIAN','1177',to_date('09-JUN-81','DD-MON-RR'),'41',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4016','CORONA PASQUALE','TECHNICIAN','1753',to_date('09-JUN-81','DD-MON-RR'),'642',null,'28');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4017','TIBALDI FEDERICO','PROFESSOR','983',to_date('09-JUN-81','DD-MON-RR'),'195',null,'258');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4018','CALVINO MARIA','TECHNICIAN','3114',to_date('09-JUN-81','DD-MON-RR'),'1301',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4019','FUMAROLA LUCIA','MANAGER','3196',to_date('09-JUN-81','DD-MON-RR'),'640',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4020','ESPOSITO MARIA','ENGINEER','127',to_date('09-JUN-81','DD-MON-RR'),'246',null,'191');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4021','BIANCHI ELENA','MANAGER','2323',to_date('09-JUN-81','DD-MON-RR'),'891',null,'399');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4022','LEVI ROBERTA','LAWYER','2719',to_date('09-JUN-81','DD-MON-RR'),'1422',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4023','CALVINO MARIO','ENGINEER','533',to_date('09-JUN-81','DD-MON-RR'),'1328',null,'367');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4024','FO LUCIA','ENGINEER','792',to_date('09-JUN-81','DD-MON-RR'),'1344',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4025','FO MARIA','PHDSTUDENT','3404',to_date('09-JUN-81','DD-MON-RR'),'1391',null,'475');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4026','BIANCHI UMBERTO','HEADMASTER','2839',to_date('09-JUN-81','DD-MON-RR'),'913',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4027','GRIMALDI MASSIMO','PROFESSOR','3283',to_date('09-JUN-81','DD-MON-RR'),'1537',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4028','TIBALDI LUCIA','MANAGER','1240',to_date('09-JUN-81','DD-MON-RR'),'187',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4029','FUMAROLA PAOLO','MANAGER','2900',to_date('09-JUN-81','DD-MON-RR'),'1515',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4030','SANTE DAMIANO','TECHNICIAN','2201',to_date('09-JUN-81','DD-MON-RR'),'176',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4031','PETRARCA LUCA','PROFESSOR','1845',to_date('09-JUN-81','DD-MON-RR'),'44',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4032','PETRARCA UGO','PHDSTUDENT','2971',to_date('09-JUN-81','DD-MON-RR'),'682',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4033','ECO LUIGI','SUPERVISOR','3206',to_date('09-JUN-81','DD-MON-RR'),'1747',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4034','SANTE FEDERICO','TECHNICIAN','3821',to_date('09-JUN-81','DD-MON-RR'),'1271',null,'308');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4035','CALVINO PAOLO','HEADMASTER','3971',to_date('09-JUN-81','DD-MON-RR'),'1800',null,'474');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4036','TIBALDI LUDOVICO','TECHNICIAN','3855',to_date('09-JUN-81','DD-MON-RR'),'1710',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4037','CARBONE SILVIA','TECHNICIAN','3277',to_date('09-JUN-81','DD-MON-RR'),'913',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4038','CORONA ANTONIO','MANAGER','1048',to_date('09-JUN-81','DD-MON-RR'),'1145',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4039','DANTE LUCIA','PHDSTUDENT','1686',to_date('09-JUN-81','DD-MON-RR'),'906',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4040','FO DAMIANO','SECRETARY','3614',to_date('09-JUN-81','DD-MON-RR'),'142',null,'199');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4041','LEOPARDI MARIA','PROFESSOR','435',to_date('09-JUN-81','DD-MON-RR'),'113',null,'326');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4042','CALVINO COSIMO','PHDSTUDENT','838',to_date('09-JUN-81','DD-MON-RR'),'412',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4043','CARBONE MASSIMO','MANAGER','328',to_date('09-JUN-81','DD-MON-RR'),'1041',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4044','FUMAROLA ANTONIO','TECHNICIAN','746',to_date('09-JUN-81','DD-MON-RR'),'992',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4045','BIANCHI GIOVANNI','ENGINEER','3356',to_date('09-JUN-81','DD-MON-RR'),'852',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4046','CALVINO CLARA','SUPERVISOR','110',to_date('09-JUN-81','DD-MON-RR'),'753',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4047','CARBONE FRANCESCO','MANAGER','214',to_date('09-JUN-81','DD-MON-RR'),'1958',null,'28');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4048','PETRARCA ANDREA','HEADMASTER','1981',to_date('09-JUN-81','DD-MON-RR'),'843',null,'419');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4049','CARBONE MASSIMO','LAWYER','1440',to_date('09-JUN-81','DD-MON-RR'),'563',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4050','PETRARCA ALFONSO','ENGINEER','2919',to_date('09-JUN-81','DD-MON-RR'),'882',null,'185');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4051','DANTE DONATO','MANAGER','1689',to_date('09-JUN-81','DD-MON-RR'),'1396',null,'8');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4052','ESPOSITO DONATO','LAWYER','2930',to_date('09-JUN-81','DD-MON-RR'),'862',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4053','COZZA IVANO','SUPERVISOR','391',to_date('09-JUN-81','DD-MON-RR'),'1606',null,'265');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4054','FUMAROLA PASQUALE','MANAGER','3453',to_date('09-JUN-81','DD-MON-RR'),'1657',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4055','FUMAROLA ELENA','SECRETARY','852',to_date('09-JUN-81','DD-MON-RR'),'88',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4056','CARBONE GIOVANNI','TECHNICIAN','896',to_date('09-JUN-81','DD-MON-RR'),'959',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4057','LEOPARDI DAMIANO','SUPERVISOR','105',to_date('09-JUN-81','DD-MON-RR'),'151',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4058','PETRARCA IVANO','MANAGER','3659',to_date('09-JUN-81','DD-MON-RR'),'1903',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4059','CARBONE MARIO','SECRETARY','240',to_date('09-JUN-81','DD-MON-RR'),'1476',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4060','CALVINO FRANCESCO','LAWYER','1983',to_date('09-JUN-81','DD-MON-RR'),'428',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4061','DANTE ELIO','PHDSTUDENT','338',to_date('09-JUN-81','DD-MON-RR'),'32',null,'234');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5059','PETRARCA ELIO','ENGINEER','3421',to_date('09-JUN-81','DD-MON-RR'),'1255',null,'364');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5060','COZZA ROBERTA','PHDSTUDENT','4929',to_date('09-JUN-81','DD-MON-RR'),'1271',null,'251');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5061','TIBALDI ELIO','LAWYER','1171',to_date('09-JUN-81','DD-MON-RR'),'1525',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5062','DANTE GAETANO','ENGINEER','4702',to_date('09-JUN-81','DD-MON-RR'),'111',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5063','COZZA CLARA','HEADMASTER','1922',to_date('09-JUN-81','DD-MON-RR'),'1959',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5064','ESPOSITO ROBERTA','MANAGER','1036',to_date('09-JUN-81','DD-MON-RR'),'1598',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5065','FUMAROLA UMBERTO','TECHNICIAN','574',to_date('09-JUN-81','DD-MON-RR'),'1123',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5066','DANTE ELIO','PROFESSOR','3759',to_date('09-JUN-81','DD-MON-RR'),'435',null,'60');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5067','LEVI MASSIMO','SECRETARY','1914',to_date('09-JUN-81','DD-MON-RR'),'1716',null,'248');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5068','LEOPARDI ELENA','PROFESSOR','1959',to_date('09-JUN-81','DD-MON-RR'),'1654',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5069','ESPOSITO CLARA','MANAGER','4677',to_date('09-JUN-81','DD-MON-RR'),'1458',null,'258');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5070','COZZA MARIA','MANAGER','4252',to_date('09-JUN-81','DD-MON-RR'),'1551',null,'333');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5071','CORONA PASQUALE','PROFESSOR','4885',to_date('09-JUN-81','DD-MON-RR'),'269',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5072','NERI ANGELO','MANAGER','2672',to_date('09-JUN-81','DD-MON-RR'),'785',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5073','ECO COSIMO','SUPERVISOR','3245',to_date('09-JUN-81','DD-MON-RR'),'923',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5074','PETRARCA LUIGI','MANAGER','4831',to_date('09-JUN-81','DD-MON-RR'),'299',null,'93');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5075','MANZONI IVANO','MANAGER','2909',to_date('09-JUN-81','DD-MON-RR'),'1393',null,'312');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5076','FUMAROLA MARIO','SUPERVISOR','4524',to_date('09-JUN-81','DD-MON-RR'),'530',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5077','COZZA ROBERTA','PROFESSOR','2843',to_date('09-JUN-81','DD-MON-RR'),'1753',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5078','TIBALDI COSIMO','SECRETARY','1636',to_date('09-JUN-81','DD-MON-RR'),'1083',null,'47');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5079','CARBONE ANGELO','PHDSTUDENT','3612',to_date('09-JUN-81','DD-MON-RR'),'1456',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5080','ECO ANGELO','HEADMASTER','3790',to_date('09-JUN-81','DD-MON-RR'),'1540',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5081','MANZONI LUIGI','SECRETARY','1967',to_date('09-JUN-81','DD-MON-RR'),'1802',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5082','BIANCHI COSIMO','MANAGER','3582',to_date('09-JUN-81','DD-MON-RR'),'444',null,'410');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8062','CARBONE DAMIANO','LAWYER','1843',to_date('09-JUN-81','DD-MON-RR'),'307',null,'483');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5980','DANTE FEDERICO','SUPERVISOR','1001',to_date('09-JUN-81','DD-MON-RR'),'1089',null,'472');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5981','COZZA CLARA','MANAGER','3907',to_date('09-JUN-81','DD-MON-RR'),'1202',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5982','CALVINO DONATO','MANAGER','2432',to_date('09-JUN-81','DD-MON-RR'),'1081',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5983','FUMAROLA IVANO','MANAGER','470',to_date('09-JUN-81','DD-MON-RR'),'1701',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5984','SANTE LUDOVICO','HEADMASTER','1499',to_date('09-JUN-81','DD-MON-RR'),'1474',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5985','LEVI LUCIA','HEADMASTER','1221',to_date('09-JUN-81','DD-MON-RR'),'1181',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5986','SANTE DONATO','PROFESSOR','1845',to_date('09-JUN-81','DD-MON-RR'),'1988',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5987','SANTE LUDOVICO','ENGINEER','2407',to_date('09-JUN-81','DD-MON-RR'),'260',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5988','GRIMALDI ELENA','SUPERVISOR','5062',to_date('09-JUN-81','DD-MON-RR'),'874',null,'248');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5989','NERI CLARA','TECHNICIAN','3516',to_date('09-JUN-81','DD-MON-RR'),'1220',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5990','CORONA COSIMO','HEADMASTER','4481',to_date('09-JUN-81','DD-MON-RR'),'86',null,'425');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5991','GRIMALDI SILVIA','MANAGER','3928',to_date('09-JUN-81','DD-MON-RR'),'999',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5992','LEVI GAETANO','SUPERVISOR','5322',to_date('09-JUN-81','DD-MON-RR'),'1214',null,'19');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5993','FO ALFONSO','PHDSTUDENT','4404',to_date('09-JUN-81','DD-MON-RR'),'1560',null,'417');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5994','FUMAROLA PASQUALE','PROFESSOR','1983',to_date('09-JUN-81','DD-MON-RR'),'1269',null,'402');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5995','CORONA UGO','MANAGER','2562',to_date('09-JUN-81','DD-MON-RR'),'1479',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5996','GRIMALDI GAETANO','HEADMASTER','2816',to_date('09-JUN-81','DD-MON-RR'),'158',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5997','COZZA UGO','SUPERVISOR','3384',to_date('09-JUN-81','DD-MON-RR'),'392',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5998','FUMAROLA SILVIA','HEADMASTER','5',to_date('09-JUN-81','DD-MON-RR'),'39',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5999','CARBONE IVANO','LAWYER','178',to_date('09-JUN-81','DD-MON-RR'),'1165',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6000','TIBALDI ANTONIO','MANAGER','2866',to_date('09-JUN-81','DD-MON-RR'),'355',null,'159');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6001','LEOPARDI UGO','PHDSTUDENT','254',to_date('09-JUN-81','DD-MON-RR'),'1851',null,'410');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6002','FO ELENA','SUPERVISOR','20',to_date('09-JUN-81','DD-MON-RR'),'290',null,'162');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6003','COZZA IVANO','MANAGER','1915',to_date('09-JUN-81','DD-MON-RR'),'1499',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6004','DANTE DAMIANO','LAWYER','1063',to_date('09-JUN-81','DD-MON-RR'),'1229',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6005','SANTE PASQUALE','ENGINEER','2064',to_date('09-JUN-81','DD-MON-RR'),'1853',null,'196');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6006','FO DONATO','MANAGER','2432',to_date('09-JUN-81','DD-MON-RR'),'267',null,'386');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6007','BIANCHI MARIO','SECRETARY','2141',to_date('09-JUN-81','DD-MON-RR'),'1114',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6008','MANZONI FRANCESCO','MANAGER','1759',to_date('09-JUN-81','DD-MON-RR'),'140',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6009','ECO LUDOVICO','TECHNICIAN','4837',to_date('09-JUN-81','DD-MON-RR'),'943',null,'99');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6010','SANTE ANTONIO','PROFESSOR','2907',to_date('09-JUN-81','DD-MON-RR'),'1160',null,'287');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6011','CALVINO COSIMO','SECRETARY','4351',to_date('09-JUN-81','DD-MON-RR'),'1296',null,'399');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6012','CALVINO CLARA','SUPERVISOR','5124',to_date('09-JUN-81','DD-MON-RR'),'462',null,'455');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6013','CALVINO ANGELO','HEADMASTER','3616',to_date('09-JUN-81','DD-MON-RR'),'412',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6014','MANZONI COSIMO','SUPERVISOR','1105',to_date('09-JUN-81','DD-MON-RR'),'1869',null,'249');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6015','BIANCHI LUCIA','SECRETARY','183',to_date('09-JUN-81','DD-MON-RR'),'1375',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6016','NERI MASSIMO','LAWYER','1633',to_date('09-JUN-81','DD-MON-RR'),'575',null,'103');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6017','ESPOSITO SILVIA','TECHNICIAN','2555',to_date('09-JUN-81','DD-MON-RR'),'1274',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6018','CALVINO DAMIANO','HEADMASTER','6000',to_date('09-JUN-81','DD-MON-RR'),'1182',null,'216');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6019','BIANCHI UMBERTO','SECRETARY','4549',to_date('09-JUN-81','DD-MON-RR'),'750',null,'248');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6020','NERI LUDOVICO','HEADMASTER','5956',to_date('09-JUN-81','DD-MON-RR'),'1576',null,'194');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6021','LEVI PAOLO','MANAGER','5196',to_date('09-JUN-81','DD-MON-RR'),'1330',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6022','LEVI ROBERTA','ENGINEER','907',to_date('09-JUN-81','DD-MON-RR'),'322',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6023','PETRARCA MASSIMO','SUPERVISOR','4150',to_date('09-JUN-81','DD-MON-RR'),'987',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6024','PETRARCA LUCA','MANAGER','4118',to_date('09-JUN-81','DD-MON-RR'),'1956',null,'405');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6025','TIBALDI ROBERTA','PHDSTUDENT','5304',to_date('09-JUN-81','DD-MON-RR'),'444',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6026','PETRARCA UMBERTO','SECRETARY','1327',to_date('09-JUN-81','DD-MON-RR'),'780',null,'207');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6027','SANTE ELENA','HEADMASTER','2917',to_date('09-JUN-81','DD-MON-RR'),'1220',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6028','DANTE LUCA','PROFESSOR','4809',to_date('09-JUN-81','DD-MON-RR'),'1525',null,'151');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6029','BIANCHI ELIO','HEADMASTER','2871',to_date('09-JUN-81','DD-MON-RR'),'1135',null,'252');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6030','COZZA MARIO','PHDSTUDENT','5156',to_date('09-JUN-81','DD-MON-RR'),'1256',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6031','PETRARCA PASQUALE','PHDSTUDENT','5806',to_date('09-JUN-81','DD-MON-RR'),'234',null,'438');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6032','CALVINO SILVIA','LAWYER','3201',to_date('09-JUN-81','DD-MON-RR'),'121',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6033','ECO GAETANO','ENGINEER','3944',to_date('09-JUN-81','DD-MON-RR'),'9',null,'391');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6034','GRIMALDI FEDERICO','MANAGER','2914',to_date('09-JUN-81','DD-MON-RR'),'1044',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6035','GRIMALDI ANTONIO','TECHNICIAN','4373',to_date('09-JUN-81','DD-MON-RR'),'1328',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6036','CARBONE MASSIMO','LAWYER','1031',to_date('09-JUN-81','DD-MON-RR'),'1678',null,'312');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6037','CARBONE FEDERICO','LAWYER','2318',to_date('09-JUN-81','DD-MON-RR'),'1496',null,'130');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6038','LEVI IVANO','MANAGER','2116',to_date('09-JUN-81','DD-MON-RR'),'492',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6039','GRIMALDI DONATO','HEADMASTER','4827',to_date('09-JUN-81','DD-MON-RR'),'1373',null,'20');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6040','CORONA MARIA','MANAGER','95',to_date('09-JUN-81','DD-MON-RR'),'797',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6041','FO ANGELO','SECRETARY','807',to_date('09-JUN-81','DD-MON-RR'),'507',null,'114');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6042','TIBALDI PAOLO','SECRETARY','5795',to_date('09-JUN-81','DD-MON-RR'),'1371',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6043','COZZA COSIMO','TECHNICIAN','4167',to_date('09-JUN-81','DD-MON-RR'),'733',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6044','FUMAROLA ANTONIO','ENGINEER','4121',to_date('09-JUN-81','DD-MON-RR'),'597',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6045','COZZA ANGELO','PROFESSOR','3467',to_date('09-JUN-81','DD-MON-RR'),'696',null,'498');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6046','ECO GAETANO','PROFESSOR','2897',to_date('09-JUN-81','DD-MON-RR'),'216',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6047','GRIMALDI ALFONSO','ENGINEER','948',to_date('09-JUN-81','DD-MON-RR'),'1650',null,'160');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6048','DANTE COSIMO','SECRETARY','855',to_date('09-JUN-81','DD-MON-RR'),'1472',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6049','ECO ELENA','ENGINEER','2510',to_date('09-JUN-81','DD-MON-RR'),'1161',null,'251');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6050','LEVI PAOLO','MANAGER','5680',to_date('09-JUN-81','DD-MON-RR'),'1755',null,'91');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6051','ESPOSITO SILVIA','PROFESSOR','104',to_date('09-JUN-81','DD-MON-RR'),'890',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7051','LEVI ANGELO','MANAGER','2723',to_date('09-JUN-81','DD-MON-RR'),'364',null,'263');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7052','PETRARCA PAOLO','PROFESSOR','6716',to_date('09-JUN-81','DD-MON-RR'),'897',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7053','NERI DAMIANO','SUPERVISOR','1351',to_date('09-JUN-81','DD-MON-RR'),'150',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7054','COZZA SILVIA','SUPERVISOR','6039',to_date('09-JUN-81','DD-MON-RR'),'533',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7055','NERI DAMIANO','PROFESSOR','4524',to_date('09-JUN-81','DD-MON-RR'),'322',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7056','CALVINO UGO','MANAGER','3959',to_date('09-JUN-81','DD-MON-RR'),'1139',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7057','CARBONE ROBERTA','ENGINEER','1285',to_date('09-JUN-81','DD-MON-RR'),'1302',null,'333');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7058','PETRARCA UMBERTO','SUPERVISOR','7034',to_date('09-JUN-81','DD-MON-RR'),'941',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7059','CARBONE UGO','SECRETARY','6020',to_date('09-JUN-81','DD-MON-RR'),'1326',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7060','DANTE ANDREA','PROFESSOR','231',to_date('09-JUN-81','DD-MON-RR'),'975',null,'271');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7061','CARBONE DONATO','HEADMASTER','4140',to_date('09-JUN-81','DD-MON-RR'),'338',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7062','LEOPARDI FEDERICO','SUPERVISOR','5542',to_date('09-JUN-81','DD-MON-RR'),'877',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7063','ECO ANDREA','SUPERVISOR','387',to_date('09-JUN-81','DD-MON-RR'),'160',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7064','ECO DONATO','MANAGER','5476',to_date('09-JUN-81','DD-MON-RR'),'1915',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7065','COZZA LUCA','LAWYER','3300',to_date('09-JUN-81','DD-MON-RR'),'1026',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7066','ESPOSITO PAOLO','SUPERVISOR','5218',to_date('09-JUN-81','DD-MON-RR'),'1776',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7067','DANTE GAETANO','PROFESSOR','224',to_date('09-JUN-81','DD-MON-RR'),'478',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7068','ESPOSITO MARIO','ENGINEER','4273',to_date('09-JUN-81','DD-MON-RR'),'1491',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7069','FO CLARA','MANAGER','1447',to_date('09-JUN-81','DD-MON-RR'),'508',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7070','LEVI MARIA','MANAGER','5554',to_date('09-JUN-81','DD-MON-RR'),'1611',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7071','ESPOSITO ANGELO','LAWYER','5627',to_date('09-JUN-81','DD-MON-RR'),'1110',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7072','CORONA ROBERTA','LAWYER','61',to_date('09-JUN-81','DD-MON-RR'),'1245',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7073','CALVINO ANTONIO','TECHNICIAN','3107',to_date('09-JUN-81','DD-MON-RR'),'1812',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7074','LEOPARDI LUCIA','LAWYER','1547',to_date('09-JUN-81','DD-MON-RR'),'224',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7075','BIANCHI LUDOVICO','ENGINEER','3530',to_date('09-JUN-81','DD-MON-RR'),'1939',null,'45');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7076','DANTE ELIO','LAWYER','4160',to_date('09-JUN-81','DD-MON-RR'),'1504',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7077','CALVINO FRANCESCO','LAWYER','1480',to_date('09-JUN-81','DD-MON-RR'),'1070',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7078','LEOPARDI PASQUALE','TECHNICIAN','3220',to_date('09-JUN-81','DD-MON-RR'),'1313',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7079','CARBONE FRANCESCO','SUPERVISOR','2565',to_date('09-JUN-81','DD-MON-RR'),'304',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7080','TIBALDI ROBERTA','HEADMASTER','4214',to_date('09-JUN-81','DD-MON-RR'),'1539',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7081','ECO ANTONIO','TECHNICIAN','4211',to_date('09-JUN-81','DD-MON-RR'),'1500',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7082','FO MARIO','MANAGER','797',to_date('09-JUN-81','DD-MON-RR'),'1261',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7083','DANTE COSIMO','PROFESSOR','5445',to_date('09-JUN-81','DD-MON-RR'),'144',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7084','DANTE CLARA','SECRETARY','3161',to_date('09-JUN-81','DD-MON-RR'),'208',null,'393');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7085','BIANCHI LUIGI','PROFESSOR','3111',to_date('09-JUN-81','DD-MON-RR'),'18',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7086','FO ELIO','LAWYER','3628',to_date('09-JUN-81','DD-MON-RR'),'581',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7087','COZZA UGO','ENGINEER','4058',to_date('09-JUN-81','DD-MON-RR'),'922',null,'396');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7088','GRIMALDI UMBERTO','HEADMASTER','3167',to_date('09-JUN-81','DD-MON-RR'),'40',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7089','LEVI DONATO','ENGINEER','5564',to_date('09-JUN-81','DD-MON-RR'),'240',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7090','CARBONE LUDOVICO','MANAGER','4475',to_date('09-JUN-81','DD-MON-RR'),'1820',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7091','BIANCHI ANDREA','PROFESSOR','3191',to_date('09-JUN-81','DD-MON-RR'),'1839',null,'369');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7092','CALVINO DAMIANO','PHDSTUDENT','2507',to_date('09-JUN-81','DD-MON-RR'),'1543',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7093','BIANCHI DAMIANO','PROFESSOR','3954',to_date('09-JUN-81','DD-MON-RR'),'1239',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7094','ESPOSITO ELENA','PHDSTUDENT','1883',to_date('09-JUN-81','DD-MON-RR'),'1107',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7095','ESPOSITO LUCIA','LAWYER','2392',to_date('09-JUN-81','DD-MON-RR'),'1516',null,'497');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7096','TIBALDI IVANO','ENGINEER','3808',to_date('09-JUN-81','DD-MON-RR'),'1335',null,'160');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7097','CORONA IVANO','PHDSTUDENT','2568',to_date('09-JUN-81','DD-MON-RR'),'424',null,'145');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7098','LEVI UGO','PHDSTUDENT','5036',to_date('09-JUN-81','DD-MON-RR'),'1833',null,'42');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7099','NERI LUDOVICO','HEADMASTER','161',to_date('09-JUN-81','DD-MON-RR'),'445',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7100','DANTE LUDOVICO','TECHNICIAN','5121',to_date('09-JUN-81','DD-MON-RR'),'308',null,'146');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7101','PETRARCA ALFONSO','SECRETARY','839',to_date('09-JUN-81','DD-MON-RR'),'1560',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7102','FO UMBERTO','ENGINEER','6819',to_date('09-JUN-81','DD-MON-RR'),'833',null,'124');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7103','CORONA UMBERTO','HEADMASTER','5091',to_date('09-JUN-81','DD-MON-RR'),'73',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7104','TIBALDI GIOVANNI','PROFESSOR','4648',to_date('09-JUN-81','DD-MON-RR'),'1177',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7105','CARBONE PASQUALE','SUPERVISOR','4231',to_date('09-JUN-81','DD-MON-RR'),'1893',null,'337');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7106','DANTE GIOVANNI','SUPERVISOR','2823',to_date('09-JUN-81','DD-MON-RR'),'1561',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7107','SANTE UGO','PROFESSOR','4339',to_date('09-JUN-81','DD-MON-RR'),'362',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7108','NERI UGO','SUPERVISOR','3310',to_date('09-JUN-81','DD-MON-RR'),'300',null,'267');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7109','DANTE ALFONSO','HEADMASTER','3342',to_date('09-JUN-81','DD-MON-RR'),'1210',null,'344');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7110','MANZONI LUIGI','SECRETARY','4938',to_date('09-JUN-81','DD-MON-RR'),'525',null,'430');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7111','DANTE ELIO','MANAGER','2049',to_date('09-JUN-81','DD-MON-RR'),'1095',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7112','ECO UMBERTO','ENGINEER','5264',to_date('09-JUN-81','DD-MON-RR'),'1466',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7113','BIANCHI ANDREA','PHDSTUDENT','2905',to_date('09-JUN-81','DD-MON-RR'),'115',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('687','ESPOSITO ANDREA','SECRETARY','427',to_date('09-JUN-81','DD-MON-RR'),'1323',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('688','SANTE MARIA','MANAGER','320',to_date('09-JUN-81','DD-MON-RR'),'1278',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('689','PETRARCA DONATO','MANAGER','185',to_date('09-JUN-81','DD-MON-RR'),'813',null,'451');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('690','NERI MASSIMO','SUPERVISOR','328',to_date('09-JUN-81','DD-MON-RR'),'737',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('691','ECO UMBERTO','MANAGER','637',to_date('09-JUN-81','DD-MON-RR'),'1468',null,'469');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('692','PETRARCA ELIO','PROFESSOR','555',to_date('09-JUN-81','DD-MON-RR'),'262',null,'34');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('693','LEOPARDI ANTONIO','SECRETARY','604',to_date('09-JUN-81','DD-MON-RR'),'278',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('694','GRIMALDI CLARA','MANAGER','452',to_date('09-JUN-81','DD-MON-RR'),'1712',null,'468');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('695','NERI LUCIA','PROFESSOR','198',to_date('09-JUN-81','DD-MON-RR'),'1076',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('696','ECO ALFONSO','MANAGER','453',to_date('09-JUN-81','DD-MON-RR'),'108',null,'61');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('697','PETRARCA GAETANO','HEADMASTER','694',to_date('09-JUN-81','DD-MON-RR'),'607',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('698','MANZONI PAOLO','MANAGER','28',to_date('09-JUN-81','DD-MON-RR'),'490',null,'288');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('699','TIBALDI MARIA','ENGINEER','130',to_date('09-JUN-81','DD-MON-RR'),'451',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('700','TIBALDI COSIMO','HEADMASTER','322',to_date('09-JUN-81','DD-MON-RR'),'131',null,'310');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('701','COZZA PASQUALE','PHDSTUDENT','389',to_date('09-JUN-81','DD-MON-RR'),'1376',null,'402');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('702','COZZA ELIO','ENGINEER','217',to_date('09-JUN-81','DD-MON-RR'),'548',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('703','CALVINO LUCIA','SECRETARY','358',to_date('09-JUN-81','DD-MON-RR'),'758',null,'114');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('704','NERI LUCIA','TECHNICIAN','176',to_date('09-JUN-81','DD-MON-RR'),'443',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('705','SANTE ELENA','PHDSTUDENT','248',to_date('09-JUN-81','DD-MON-RR'),'1611',null,'437');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('706','NERI LUDOVICO','PROFESSOR','511',to_date('09-JUN-81','DD-MON-RR'),'1053',null,'299');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('707','FO ALFONSO','MANAGER','591',to_date('09-JUN-81','DD-MON-RR'),'1029',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('708','CARBONE COSIMO','MANAGER','305',to_date('09-JUN-81','DD-MON-RR'),'195',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('709','NERI MARIA','MANAGER','327',to_date('09-JUN-81','DD-MON-RR'),'869',null,'63');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('710','SANTE ALFONSO','LAWYER','212',to_date('09-JUN-81','DD-MON-RR'),'115',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('711','DANTE ANDREA','LAWYER','60',to_date('09-JUN-81','DD-MON-RR'),'1512',null,'387');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('712','TIBALDI ROBERTA','MANAGER','398',to_date('09-JUN-81','DD-MON-RR'),'247',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('713','LEOPARDI LUCA','TECHNICIAN','143',to_date('09-JUN-81','DD-MON-RR'),'4',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('714','GRIMALDI CLARA','LAWYER','695',to_date('09-JUN-81','DD-MON-RR'),'248',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('715','GRIMALDI GAETANO','PROFESSOR','409',to_date('09-JUN-81','DD-MON-RR'),'1827',null,'281');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('716','PETRARCA MASSIMO','LAWYER','71',to_date('09-JUN-81','DD-MON-RR'),'343',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('717','BIANCHI UGO','ENGINEER','613',to_date('09-JUN-81','DD-MON-RR'),'830',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('718','NERI ANDREA','SECRETARY','311',to_date('09-JUN-81','DD-MON-RR'),'654',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('719','CALVINO DAMIANO','SUPERVISOR','705',to_date('09-JUN-81','DD-MON-RR'),'742',null,'60');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('720','SANTE COSIMO','MANAGER','207',to_date('09-JUN-81','DD-MON-RR'),'90',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('721','CORONA ANTONIO','HEADMASTER','321',to_date('09-JUN-81','DD-MON-RR'),'1989',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('722','PETRARCA ALFONSO','SUPERVISOR','313',to_date('09-JUN-81','DD-MON-RR'),'1449',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('723','LEOPARDI MARIA','MANAGER','381',to_date('09-JUN-81','DD-MON-RR'),'1018',null,'316');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('724','CALVINO LUCIA','MANAGER','622',to_date('09-JUN-81','DD-MON-RR'),'211',null,'200');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('725','BIANCHI ELENA','HEADMASTER','518',to_date('09-JUN-81','DD-MON-RR'),'349',null,'458');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('726','BIANCHI ELIO','SECRETARY','72',to_date('09-JUN-81','DD-MON-RR'),'944',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('727','CORONA IVANO','LAWYER','561',to_date('09-JUN-81','DD-MON-RR'),'1407',null,'200');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('728','DANTE DONATO','MANAGER','186',to_date('09-JUN-81','DD-MON-RR'),'854',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('729','LEOPARDI ANDREA','MANAGER','668',to_date('09-JUN-81','DD-MON-RR'),'298',null,'108');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('730','DANTE DONATO','LAWYER','138',to_date('09-JUN-81','DD-MON-RR'),'1688',null,'139');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('731','BIANCHI MARIO','PHDSTUDENT','673',to_date('09-JUN-81','DD-MON-RR'),'618',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('732','SANTE DAMIANO','SECRETARY','297',to_date('09-JUN-81','DD-MON-RR'),'179',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('733','ECO ANTONIO','MANAGER','209',to_date('09-JUN-81','DD-MON-RR'),'591',null,'38');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('734','MANZONI MARIA','TECHNICIAN','280',to_date('09-JUN-81','DD-MON-RR'),'200',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('735','CALVINO PASQUALE','PHDSTUDENT','516',to_date('09-JUN-81','DD-MON-RR'),'1215',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('736','SANTE MASSIMO','PROFESSOR','210',to_date('09-JUN-81','DD-MON-RR'),'1274',null,'3');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('737','COZZA PASQUALE','MANAGER','80',to_date('09-JUN-81','DD-MON-RR'),'1545',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('738','FUMAROLA ANGELO','HEADMASTER','375',to_date('09-JUN-81','DD-MON-RR'),'1732',null,'374');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('739','CALVINO MASSIMO','MANAGER','703',to_date('09-JUN-81','DD-MON-RR'),'1039',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('740','CARBONE UGO','SECRETARY','83',to_date('09-JUN-81','DD-MON-RR'),'1641',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('741','SANTE DAMIANO','SUPERVISOR','221',to_date('09-JUN-81','DD-MON-RR'),'176',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('742','CALVINO CLARA','ENGINEER','467',to_date('09-JUN-81','DD-MON-RR'),'522',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('743','COZZA DONATO','MANAGER','370',to_date('09-JUN-81','DD-MON-RR'),'1259',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('744','SANTE FRANCESCO','SECRETARY','134',to_date('09-JUN-81','DD-MON-RR'),'336',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('745','PETRARCA ANDREA','PROFESSOR','496',to_date('09-JUN-81','DD-MON-RR'),'1498',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('746','FUMAROLA LUCA','ENGINEER','373',to_date('09-JUN-81','DD-MON-RR'),'1301',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('747','DANTE LUDOVICO','HEADMASTER','515',to_date('09-JUN-81','DD-MON-RR'),'1174',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('748','ECO ANGELO','SECRETARY','280',to_date('09-JUN-81','DD-MON-RR'),'258',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('749','LEVI LUDOVICO','LAWYER','382',to_date('09-JUN-81','DD-MON-RR'),'1116',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('750','CALVINO ANTONIO','MANAGER','705',to_date('09-JUN-81','DD-MON-RR'),'879',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('751','GRIMALDI MASSIMO','MANAGER','701',to_date('09-JUN-81','DD-MON-RR'),'1331',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('752','FUMAROLA IVANO','LAWYER','42',to_date('09-JUN-81','DD-MON-RR'),'537',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('753','FO IVANO','MANAGER','733',to_date('09-JUN-81','DD-MON-RR'),'1770',null,'362');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('754','SANTE SILVIA','SUPERVISOR','366',to_date('09-JUN-81','DD-MON-RR'),'1537',null,'329');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('755','LEVI IVANO','SECRETARY','141',to_date('09-JUN-81','DD-MON-RR'),'1752',null,'436');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('756','BIANCHI CLARA','PROFESSOR','283',to_date('09-JUN-81','DD-MON-RR'),'694',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('757','PETRARCA UMBERTO','TECHNICIAN','130',to_date('09-JUN-81','DD-MON-RR'),'1648',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('758','ECO MARIA','MANAGER','553',to_date('09-JUN-81','DD-MON-RR'),'1507',null,'472');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('759','DANTE MARIO','SECRETARY','421',to_date('09-JUN-81','DD-MON-RR'),'1726',null,'486');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('760','FO COSIMO','MANAGER','492',to_date('09-JUN-81','DD-MON-RR'),'1139',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('761','NERI UGO','SECRETARY','424',to_date('09-JUN-81','DD-MON-RR'),'1099',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('762','FUMAROLA DONATO','TECHNICIAN','412',to_date('09-JUN-81','DD-MON-RR'),'1032',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('763','CALVINO LUIGI','MANAGER','115',to_date('09-JUN-81','DD-MON-RR'),'766',null,'335');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('764','CORONA IVANO','TECHNICIAN','229',to_date('09-JUN-81','DD-MON-RR'),'787',null,'455');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('765','FO IVANO','MANAGER','139',to_date('09-JUN-81','DD-MON-RR'),'513',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('766','COZZA DAMIANO','LAWYER','125',to_date('09-JUN-81','DD-MON-RR'),'669',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('767','CARBONE UMBERTO','LAWYER','16',to_date('09-JUN-81','DD-MON-RR'),'274',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('768','FO PASQUALE','PHDSTUDENT','57',to_date('09-JUN-81','DD-MON-RR'),'760',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('769','CORONA MARIA','ENGINEER','609',to_date('09-JUN-81','DD-MON-RR'),'1556',null,'357');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('770','ESPOSITO PAOLO','MANAGER','766',to_date('09-JUN-81','DD-MON-RR'),'468',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('771','TIBALDI LUCIA','SUPERVISOR','689',to_date('09-JUN-81','DD-MON-RR'),'731',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('772','TIBALDI ELENA','LAWYER','318',to_date('09-JUN-81','DD-MON-RR'),'193',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('773','ECO DONATO','ENGINEER','742',to_date('09-JUN-81','DD-MON-RR'),'661',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('774','CALVINO ANGELO','MANAGER','592',to_date('09-JUN-81','DD-MON-RR'),'1738',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('775','SANTE PASQUALE','MANAGER','623',to_date('09-JUN-81','DD-MON-RR'),'1135',null,'287');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('776','LEOPARDI LUDOVICO','PHDSTUDENT','576',to_date('09-JUN-81','DD-MON-RR'),'639',null,'71');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('777','COZZA COSIMO','SUPERVISOR','562',to_date('09-JUN-81','DD-MON-RR'),'428',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('778','BIANCHI MASSIMO','ENGINEER','624',to_date('09-JUN-81','DD-MON-RR'),'72',null,'450');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('779','CORONA DAMIANO','SUPERVISOR','271',to_date('09-JUN-81','DD-MON-RR'),'491',null,'423');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('780','FUMAROLA ANGELO','LAWYER','763',to_date('09-JUN-81','DD-MON-RR'),'1061',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('781','NERI GIOVANNI','PROFESSOR','258',to_date('09-JUN-81','DD-MON-RR'),'1318',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('782','CARBONE UGO','PROFESSOR','540',to_date('09-JUN-81','DD-MON-RR'),'1636',null,'374');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('783','TIBALDI UGO','PROFESSOR','449',to_date('09-JUN-81','DD-MON-RR'),'1540',null,'429');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('784','LEVI PAOLO','TECHNICIAN','354',to_date('09-JUN-81','DD-MON-RR'),'1910',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('785','PETRARCA GAETANO','PROFESSOR','564',to_date('09-JUN-81','DD-MON-RR'),'1143',null,'420');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('786','FUMAROLA IVANO','MANAGER','93',to_date('09-JUN-81','DD-MON-RR'),'913',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('787','TIBALDI PAOLO','PHDSTUDENT','302',to_date('09-JUN-81','DD-MON-RR'),'1241',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('788','CORONA LUDOVICO','SUPERVISOR','753',to_date('09-JUN-81','DD-MON-RR'),'400',null,'34');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('789','MANZONI LUCIA','MANAGER','121',to_date('09-JUN-81','DD-MON-RR'),'255',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('790','MANZONI FEDERICO','SUPERVISOR','39',to_date('09-JUN-81','DD-MON-RR'),'291',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('791','DANTE ELENA','SECRETARY','514',to_date('09-JUN-81','DD-MON-RR'),'1939',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('792','PETRARCA ELIO','LAWYER','460',to_date('09-JUN-81','DD-MON-RR'),'411',null,'464');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('793','TIBALDI PASQUALE','MANAGER','166',to_date('09-JUN-81','DD-MON-RR'),'589',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('794','FUMAROLA COSIMO','TECHNICIAN','758',to_date('09-JUN-81','DD-MON-RR'),'528',null,'278');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('795','COZZA SILVIA','PROFESSOR','644',to_date('09-JUN-81','DD-MON-RR'),'108',null,'65');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('796','LEOPARDI LUDOVICO','SECRETARY','420',to_date('09-JUN-81','DD-MON-RR'),'1195',null,'475');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('797','TIBALDI ELENA','HEADMASTER','171',to_date('09-JUN-81','DD-MON-RR'),'493',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('798','COZZA MARIA','SUPERVISOR','557',to_date('09-JUN-81','DD-MON-RR'),'739',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('799','DANTE GIOVANNI','MANAGER','706',to_date('09-JUN-81','DD-MON-RR'),'1208',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('800','SANTE DONATO','PHDSTUDENT','341',to_date('09-JUN-81','DD-MON-RR'),'2',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('801','CARBONE MARIO','PROFESSOR','431',to_date('09-JUN-81','DD-MON-RR'),'270',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('802','COZZA ANTONIO','SUPERVISOR','211',to_date('09-JUN-81','DD-MON-RR'),'513',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('803','FO GIOVANNI','ENGINEER','449',to_date('09-JUN-81','DD-MON-RR'),'199',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('804','LEVI LUDOVICO','ENGINEER','718',to_date('09-JUN-81','DD-MON-RR'),'875',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('805','FUMAROLA ELIO','TECHNICIAN','700',to_date('09-JUN-81','DD-MON-RR'),'613',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('806','CALVINO FEDERICO','ENGINEER','728',to_date('09-JUN-81','DD-MON-RR'),'805',null,'108');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('807','MANZONI DONATO','PROFESSOR','601',to_date('09-JUN-81','DD-MON-RR'),'314',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1','COZZA MARIA','PROFESSOR','0',to_date('09-JUN-81','DD-MON-RR'),'1181',null,'126');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2','ECO LUIGI','PHDSTUDENT','0',to_date('09-JUN-81','DD-MON-RR'),'1360',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3','CORONA CLARA','PHDSTUDENT','2',to_date('09-JUN-81','DD-MON-RR'),'624',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4','CALVINO MASSIMO','PROFESSOR','2',to_date('09-JUN-81','DD-MON-RR'),'1224',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5','PETRARCA LUCIA','PHDSTUDENT','2',to_date('09-JUN-81','DD-MON-RR'),'1098',null,'18');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6','CALVINO MARIA','LAWYER','3',to_date('09-JUN-81','DD-MON-RR'),'1513',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7','DANTE UGO','MANAGER','6',to_date('09-JUN-81','DD-MON-RR'),'1751',null,'280');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8','BIANCHI IVANO','ENGINEER','7',to_date('09-JUN-81','DD-MON-RR'),'716',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('9','ESPOSITO ELIO','SECRETARY','3',to_date('09-JUN-81','DD-MON-RR'),'56',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('10','MANZONI ANTONIO','PHDSTUDENT','0',to_date('09-JUN-81','DD-MON-RR'),'1096',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('11','LEVI GIOVANNI','SECRETARY','10',to_date('09-JUN-81','DD-MON-RR'),'1320',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('12','CORONA ANTONIO','MANAGER','3',to_date('09-JUN-81','DD-MON-RR'),'964',null,'24');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('13','LEOPARDI PASQUALE','TECHNICIAN','12',to_date('09-JUN-81','DD-MON-RR'),'1488',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('14','TIBALDI LUCIA','SECRETARY','11',to_date('09-JUN-81','DD-MON-RR'),'207',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('15','SANTE UGO','MANAGER','14',to_date('09-JUN-81','DD-MON-RR'),'1619',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('16','ECO LUDOVICO','PHDSTUDENT','9',to_date('09-JUN-81','DD-MON-RR'),'1664',null,'267');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1927','FO ELENA','LAWYER','241',to_date('09-JUN-81','DD-MON-RR'),'255',null,'471');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1928','LEVI UMBERTO','ENGINEER','1641',to_date('09-JUN-81','DD-MON-RR'),'340',null,'423');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1929','ESPOSITO MARIA','PHDSTUDENT','414',to_date('09-JUN-81','DD-MON-RR'),'640',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1930','COZZA ANTONIO','PROFESSOR','1077',to_date('09-JUN-81','DD-MON-RR'),'1953',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1931','TIBALDI GIOVANNI','PHDSTUDENT','413',to_date('09-JUN-81','DD-MON-RR'),'470',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1932','TIBALDI CLARA','LAWYER','1066',to_date('09-JUN-81','DD-MON-RR'),'1719',null,'51');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1933','SANTE LUDOVICO','SECRETARY','740',to_date('09-JUN-81','DD-MON-RR'),'663',null,'120');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1934','ESPOSITO MARIA','TECHNICIAN','898',to_date('09-JUN-81','DD-MON-RR'),'284',null,'171');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1935','COZZA IVANO','TECHNICIAN','1848',to_date('09-JUN-81','DD-MON-RR'),'998',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1936','LEVI UMBERTO','MANAGER','421',to_date('09-JUN-81','DD-MON-RR'),'318',null,'364');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1937','SANTE ELENA','SECRETARY','1407',to_date('09-JUN-81','DD-MON-RR'),'1634',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1938','ECO PAOLO','TECHNICIAN','1744',to_date('09-JUN-81','DD-MON-RR'),'1388',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1939','NERI SILVIA','SECRETARY','317',to_date('09-JUN-81','DD-MON-RR'),'778',null,'101');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1940','FUMAROLA LUDOVICO','SUPERVISOR','84',to_date('09-JUN-81','DD-MON-RR'),'947',null,'322');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1941','LEVI IVANO','SECRETARY','97',to_date('09-JUN-81','DD-MON-RR'),'625',null,'373');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1942','LEVI LUCIA','HEADMASTER','470',to_date('09-JUN-81','DD-MON-RR'),'1580',null,'415');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1943','LEVI MARIO','MANAGER','714',to_date('09-JUN-81','DD-MON-RR'),'1040',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1944','FO ROBERTA','SUPERVISOR','1095',to_date('09-JUN-81','DD-MON-RR'),'1648',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1945','FUMAROLA ALFONSO','MANAGER','1773',to_date('09-JUN-81','DD-MON-RR'),'751',null,'71');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1946','PETRARCA LUCIA','MANAGER','281',to_date('09-JUN-81','DD-MON-RR'),'1965',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1947','NERI ANGELO','ENGINEER','1764',to_date('09-JUN-81','DD-MON-RR'),'8',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1948','FUMAROLA PAOLO','SECRETARY','1713',to_date('09-JUN-81','DD-MON-RR'),'1873',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1949','BIANCHI ANDREA','SUPERVISOR','930',to_date('09-JUN-81','DD-MON-RR'),'4',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1950','CORONA ELIO','PHDSTUDENT','580',to_date('09-JUN-81','DD-MON-RR'),'1362',null,'368');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1951','PETRARCA MARIA','MANAGER','1323',to_date('09-JUN-81','DD-MON-RR'),'763',null,'326');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1952','GRIMALDI PAOLO','SECRETARY','1646',to_date('09-JUN-81','DD-MON-RR'),'361',null,'209');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1953','BIANCHI FEDERICO','TECHNICIAN','532',to_date('09-JUN-81','DD-MON-RR'),'1594',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1954','ESPOSITO UMBERTO','LAWYER','47',to_date('09-JUN-81','DD-MON-RR'),'1981',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1955','CALVINO ELIO','PHDSTUDENT','813',to_date('09-JUN-81','DD-MON-RR'),'1833',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1956','BIANCHI ANDREA','MANAGER','1610',to_date('09-JUN-81','DD-MON-RR'),'71',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1957','PETRARCA ANDREA','MANAGER','1741',to_date('09-JUN-81','DD-MON-RR'),'216',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1958','CARBONE ELIO','PHDSTUDENT','579',to_date('09-JUN-81','DD-MON-RR'),'1257',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1959','MANZONI PAOLO','HEADMASTER','1144',to_date('09-JUN-81','DD-MON-RR'),'942',null,'55');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1960','CARBONE IVANO','ENGINEER','167',to_date('09-JUN-81','DD-MON-RR'),'1883',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1961','DANTE UMBERTO','MANAGER','1875',to_date('09-JUN-81','DD-MON-RR'),'1837',null,'19');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1962','FUMAROLA LUDOVICO','TECHNICIAN','201',to_date('09-JUN-81','DD-MON-RR'),'568',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1963','BIANCHI LUCIA','MANAGER','1576',to_date('09-JUN-81','DD-MON-RR'),'1778',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1964','ECO LUCA','MANAGER','1037',to_date('09-JUN-81','DD-MON-RR'),'1387',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1965','NERI MASSIMO','HEADMASTER','723',to_date('09-JUN-81','DD-MON-RR'),'1459',null,'391');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1966','COZZA ANTONIO','MANAGER','34',to_date('09-JUN-81','DD-MON-RR'),'1176',null,'398');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1967','DANTE UMBERTO','PROFESSOR','709',to_date('09-JUN-81','DD-MON-RR'),'167',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1968','CALVINO LUCIA','TECHNICIAN','1065',to_date('09-JUN-81','DD-MON-RR'),'1761',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1969','FUMAROLA GIOVANNI','SECRETARY','1541',to_date('09-JUN-81','DD-MON-RR'),'1637',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1970','GRIMALDI DONATO','LAWYER','1851',to_date('09-JUN-81','DD-MON-RR'),'1651',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1971','LEOPARDI ELIO','ENGINEER','1182',to_date('09-JUN-81','DD-MON-RR'),'1715',null,'177');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1972','ESPOSITO LUDOVICO','LAWYER','1158',to_date('09-JUN-81','DD-MON-RR'),'550',null,'209');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1973','MANZONI SILVIA','TECHNICIAN','257',to_date('09-JUN-81','DD-MON-RR'),'1179',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1974','ESPOSITO LUCIA','PHDSTUDENT','304',to_date('09-JUN-81','DD-MON-RR'),'622',null,'243');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1975','MANZONI LUIGI','LAWYER','632',to_date('09-JUN-81','DD-MON-RR'),'698',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1976','CORONA MARIO','MANAGER','437',to_date('09-JUN-81','DD-MON-RR'),'1343',null,'233');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1977','COZZA GIOVANNI','TECHNICIAN','1802',to_date('09-JUN-81','DD-MON-RR'),'1311',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1978','LEVI ANTONIO','PROFESSOR','1637',to_date('09-JUN-81','DD-MON-RR'),'1696',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1979','CORONA FEDERICO','TECHNICIAN','1729',to_date('09-JUN-81','DD-MON-RR'),'179',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1980','CARBONE LUCIA','ENGINEER','604',to_date('09-JUN-81','DD-MON-RR'),'650',null,'447');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1981','CORONA ELENA','HEADMASTER','1357',to_date('09-JUN-81','DD-MON-RR'),'2',null,'318');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1982','PETRARCA ROBERTA','LAWYER','1060',to_date('09-JUN-81','DD-MON-RR'),'978',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1983','TIBALDI UMBERTO','MANAGER','1782',to_date('09-JUN-81','DD-MON-RR'),'1295',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1984','CALVINO MASSIMO','PROFESSOR','38',to_date('09-JUN-81','DD-MON-RR'),'1456',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1985','ECO UMBERTO','ENGINEER','1388',to_date('09-JUN-81','DD-MON-RR'),'788',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1986','SANTE UMBERTO','HEADMASTER','1111',to_date('09-JUN-81','DD-MON-RR'),'309',null,'32');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1987','BIANCHI ELENA','HEADMASTER','1794',to_date('09-JUN-81','DD-MON-RR'),'1685',null,'65');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1988','GRIMALDI ELENA','ENGINEER','682',to_date('09-JUN-81','DD-MON-RR'),'1868',null,'299');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1989','FUMAROLA MARIA','PHDSTUDENT','266',to_date('09-JUN-81','DD-MON-RR'),'296',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1990','LEVI DONATO','SECRETARY','89',to_date('09-JUN-81','DD-MON-RR'),'4',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1991','NERI FEDERICO','MANAGER','779',to_date('09-JUN-81','DD-MON-RR'),'310',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1992','BIANCHI LUCIA','PHDSTUDENT','195',to_date('09-JUN-81','DD-MON-RR'),'510',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1993','CARBONE FRANCESCO','ENGINEER','358',to_date('09-JUN-81','DD-MON-RR'),'1725',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1994','PETRARCA LUIGI','TECHNICIAN','462',to_date('09-JUN-81','DD-MON-RR'),'535',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1995','CALVINO LUCIA','SECRETARY','1363',to_date('09-JUN-81','DD-MON-RR'),'798',null,'495');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1996','PETRARCA MASSIMO','TECHNICIAN','962',to_date('09-JUN-81','DD-MON-RR'),'237',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1997','CORONA FEDERICO','LAWYER','732',to_date('09-JUN-81','DD-MON-RR'),'1345',null,'174');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1998','FUMAROLA COSIMO','MANAGER','558',to_date('09-JUN-81','DD-MON-RR'),'163',null,'365');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1999','MANZONI GIOVANNI','LAWYER','449',to_date('09-JUN-81','DD-MON-RR'),'185',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2000','NERI UMBERTO','PROFESSOR','1798',to_date('09-JUN-81','DD-MON-RR'),'379',null,'443');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2001','CALVINO ANDREA','PROFESSOR','953',to_date('09-JUN-81','DD-MON-RR'),'39',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2002','CALVINO MARIA','LAWYER','624',to_date('09-JUN-81','DD-MON-RR'),'314',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2003','COZZA LUDOVICO','SUPERVISOR','1061',to_date('09-JUN-81','DD-MON-RR'),'483',null,'481');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2004','DANTE ALFONSO','MANAGER','253',to_date('09-JUN-81','DD-MON-RR'),'309',null,'458');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2005','LEVI ALFONSO','PROFESSOR','1496',to_date('09-JUN-81','DD-MON-RR'),'1928',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2006','CORONA COSIMO','SUPERVISOR','495',to_date('09-JUN-81','DD-MON-RR'),'660',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2007','ESPOSITO PAOLO','ENGINEER','577',to_date('09-JUN-81','DD-MON-RR'),'1721',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2008','COZZA PAOLO','TECHNICIAN','302',to_date('09-JUN-81','DD-MON-RR'),'103',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2009','FO MARIA','MANAGER','1886',to_date('09-JUN-81','DD-MON-RR'),'879',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2010','SANTE COSIMO','PHDSTUDENT','563',to_date('09-JUN-81','DD-MON-RR'),'890',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2011','CARBONE ELIO','SECRETARY','90',to_date('09-JUN-81','DD-MON-RR'),'651',null,'310');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2012','ECO MARIA','LAWYER','356',to_date('09-JUN-81','DD-MON-RR'),'1186',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2013','ESPOSITO PAOLO','PROFESSOR','757',to_date('09-JUN-81','DD-MON-RR'),'24',null,'301');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2014','GRIMALDI MARIA','TECHNICIAN','1915',to_date('09-JUN-81','DD-MON-RR'),'131',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2015','SANTE MASSIMO','TECHNICIAN','1672',to_date('09-JUN-81','DD-MON-RR'),'405',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2016','CARBONE LUCA','HEADMASTER','1122',to_date('09-JUN-81','DD-MON-RR'),'283',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2017','MANZONI FRANCESCO','HEADMASTER','699',to_date('09-JUN-81','DD-MON-RR'),'1070',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2018','GRIMALDI DAMIANO','LAWYER','1875',to_date('09-JUN-81','DD-MON-RR'),'413',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2019','CALVINO SILVIA','HEADMASTER','908',to_date('09-JUN-81','DD-MON-RR'),'1713',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2020','GRIMALDI MARIO','LAWYER','1741',to_date('09-JUN-81','DD-MON-RR'),'89',null,'497');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2021','DANTE ANTONIO','ENGINEER','1904',to_date('09-JUN-81','DD-MON-RR'),'1734',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2022','GRIMALDI DAMIANO','TECHNICIAN','116',to_date('09-JUN-81','DD-MON-RR'),'783',null,'63');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2023','NERI PASQUALE','HEADMASTER','1065',to_date('09-JUN-81','DD-MON-RR'),'1396',null,'81');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2024','DANTE COSIMO','LAWYER','17',to_date('09-JUN-81','DD-MON-RR'),'1362',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2025','GRIMALDI ELENA','LAWYER','1358',to_date('09-JUN-81','DD-MON-RR'),'701',null,'93');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2026','LEOPARDI LUCIA','HEADMASTER','1535',to_date('09-JUN-81','DD-MON-RR'),'1311',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2027','NERI UMBERTO','SUPERVISOR','1183',to_date('09-JUN-81','DD-MON-RR'),'1120',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2028','CALVINO LUDOVICO','SECRETARY','1354',to_date('09-JUN-81','DD-MON-RR'),'1896',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2029','ESPOSITO ALFONSO','LAWYER','1829',to_date('09-JUN-81','DD-MON-RR'),'322',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2030','GRIMALDI UGO','PHDSTUDENT','1967',to_date('09-JUN-81','DD-MON-RR'),'1421',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2031','GRIMALDI ANTONIO','PROFESSOR','1324',to_date('09-JUN-81','DD-MON-RR'),'268',null,'194');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2032','GRIMALDI ELIO','PROFESSOR','865',to_date('09-JUN-81','DD-MON-RR'),'1419',null,'226');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2033','PETRARCA MARIA','PROFESSOR','1619',to_date('09-JUN-81','DD-MON-RR'),'177',null,'411');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2034','MANZONI ROBERTA','ENGINEER','1147',to_date('09-JUN-81','DD-MON-RR'),'1644',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2035','MANZONI LUCA','ENGINEER','841',to_date('09-JUN-81','DD-MON-RR'),'1238',null,'443');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2036','GRIMALDI LUDOVICO','LAWYER','338',to_date('09-JUN-81','DD-MON-RR'),'854',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2037','SANTE PASQUALE','HEADMASTER','911',to_date('09-JUN-81','DD-MON-RR'),'1739',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2038','ESPOSITO COSIMO','TECHNICIAN','1577',to_date('09-JUN-81','DD-MON-RR'),'1786',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2039','TIBALDI GAETANO','PHDSTUDENT','1164',to_date('09-JUN-81','DD-MON-RR'),'1044',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2040','ESPOSITO PAOLO','SUPERVISOR','1802',to_date('09-JUN-81','DD-MON-RR'),'1360',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2041','BIANCHI MARIO','ENGINEER','67',to_date('09-JUN-81','DD-MON-RR'),'559',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2042','LEVI LUCA','HEADMASTER','1947',to_date('09-JUN-81','DD-MON-RR'),'564',null,'134');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2043','CARBONE PAOLO','PROFESSOR','1718',to_date('09-JUN-81','DD-MON-RR'),'1912',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2044','CARBONE CLARA','MANAGER','504',to_date('09-JUN-81','DD-MON-RR'),'247',null,'369');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2045','ECO GAETANO','TECHNICIAN','1772',to_date('09-JUN-81','DD-MON-RR'),'1429',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2046','COZZA GIOVANNI','TECHNICIAN','308',to_date('09-JUN-81','DD-MON-RR'),'1034',null,'40');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2047','LEOPARDI COSIMO','PROFESSOR','1038',to_date('09-JUN-81','DD-MON-RR'),'1802',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2048','TIBALDI LUCIA','PHDSTUDENT','293',to_date('09-JUN-81','DD-MON-RR'),'1859',null,'168');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2049','SANTE GAETANO','PROFESSOR','1272',to_date('09-JUN-81','DD-MON-RR'),'1520',null,'6');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2050','COZZA ELIO','PROFESSOR','753',to_date('09-JUN-81','DD-MON-RR'),'717',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2051','ECO ELIO','TECHNICIAN','1754',to_date('09-JUN-81','DD-MON-RR'),'262',null,'280');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2052','PETRARCA DAMIANO','ENGINEER','1745',to_date('09-JUN-81','DD-MON-RR'),'1491',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2053','CORONA DAMIANO','PHDSTUDENT','879',to_date('09-JUN-81','DD-MON-RR'),'1332',null,'213');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2054','GRIMALDI CLARA','SUPERVISOR','1341',to_date('09-JUN-81','DD-MON-RR'),'1380',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2055','SANTE ROBERTA','LAWYER','1045',to_date('09-JUN-81','DD-MON-RR'),'837',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2056','ESPOSITO LUDOVICO','SECRETARY','225',to_date('09-JUN-81','DD-MON-RR'),'657',null,'331');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2057','CORONA ANTONIO','HEADMASTER','365',to_date('09-JUN-81','DD-MON-RR'),'229',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2058','CARBONE ELIO','MANAGER','173',to_date('09-JUN-81','DD-MON-RR'),'1182',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2059','SANTE ELIO','SECRETARY','931',to_date('09-JUN-81','DD-MON-RR'),'17',null,'298');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2060','SANTE LUIGI','SUPERVISOR','712',to_date('09-JUN-81','DD-MON-RR'),'366',null,'33');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2061','ESPOSITO SILVIA','ENGINEER','885',to_date('09-JUN-81','DD-MON-RR'),'719',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5083','LEOPARDI LUDOVICO','MANAGER','4563',to_date('09-JUN-81','DD-MON-RR'),'1523',null,'132');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5084','LEOPARDI LUDOVICO','LAWYER','1609',to_date('09-JUN-81','DD-MON-RR'),'1455',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5085','MANZONI ALFONSO','SECRETARY','606',to_date('09-JUN-81','DD-MON-RR'),'742',null,'368');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5086','BIANCHI CLARA','PHDSTUDENT','2420',to_date('09-JUN-81','DD-MON-RR'),'257',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5087','CORONA FEDERICO','SUPERVISOR','76',to_date('09-JUN-81','DD-MON-RR'),'744',null,'265');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5088','CALVINO PASQUALE','PROFESSOR','2847',to_date('09-JUN-81','DD-MON-RR'),'1068',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5089','FO ROBERTA','ENGINEER','4401',to_date('09-JUN-81','DD-MON-RR'),'1688',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5090','GRIMALDI LUIGI','PROFESSOR','3053',to_date('09-JUN-81','DD-MON-RR'),'1505',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5091','DANTE LUCA','MANAGER','420',to_date('09-JUN-81','DD-MON-RR'),'750',null,'171');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5092','CARBONE ALFONSO','MANAGER','199',to_date('09-JUN-81','DD-MON-RR'),'921',null,'191');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5093','ECO PAOLO','HEADMASTER','2760',to_date('09-JUN-81','DD-MON-RR'),'1713',null,'277');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5094','CALVINO DONATO','SECRETARY','125',to_date('09-JUN-81','DD-MON-RR'),'1092',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5095','NERI MARIO','HEADMASTER','3076',to_date('09-JUN-81','DD-MON-RR'),'1559',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5096','BIANCHI UMBERTO','MANAGER','1488',to_date('09-JUN-81','DD-MON-RR'),'398',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5097','ESPOSITO GAETANO','PROFESSOR','3298',to_date('09-JUN-81','DD-MON-RR'),'1935',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5098','BIANCHI LUCA','MANAGER','259',to_date('09-JUN-81','DD-MON-RR'),'161',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5099','CORONA ANDREA','MANAGER','3503',to_date('09-JUN-81','DD-MON-RR'),'761',null,'437');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5100','NERI MARIO','MANAGER','881',to_date('09-JUN-81','DD-MON-RR'),'972',null,'417');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5101','GRIMALDI LUCIA','SUPERVISOR','3550',to_date('09-JUN-81','DD-MON-RR'),'1711',null,'74');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5102','CORONA UGO','LAWYER','1604',to_date('09-JUN-81','DD-MON-RR'),'277',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5103','ECO ANTONIO','MANAGER','3048',to_date('09-JUN-81','DD-MON-RR'),'440',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5104','FUMAROLA ANDREA','SUPERVISOR','2922',to_date('09-JUN-81','DD-MON-RR'),'1025',null,'201');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5105','CARBONE LUCA','PHDSTUDENT','2556',to_date('09-JUN-81','DD-MON-RR'),'597',null,'385');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5106','TIBALDI IVANO','HEADMASTER','1457',to_date('09-JUN-81','DD-MON-RR'),'959',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5107','DANTE PASQUALE','MANAGER','2620',to_date('09-JUN-81','DD-MON-RR'),'153',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5108','ECO ELIO','PHDSTUDENT','737',to_date('09-JUN-81','DD-MON-RR'),'962',null,'104');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5109','LEVI ANDREA','TECHNICIAN','4248',to_date('09-JUN-81','DD-MON-RR'),'596',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5110','TIBALDI GAETANO','MANAGER','2647',to_date('09-JUN-81','DD-MON-RR'),'491',null,'485');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5111','DANTE MARIA','MANAGER','3183',to_date('09-JUN-81','DD-MON-RR'),'1731',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5112','TIBALDI FEDERICO','SUPERVISOR','2522',to_date('09-JUN-81','DD-MON-RR'),'1627',null,'36');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5113','LEVI SILVIA','PROFESSOR','1543',to_date('09-JUN-81','DD-MON-RR'),'1034',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5114','LEVI ELENA','MANAGER','2793',to_date('09-JUN-81','DD-MON-RR'),'317',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5115','ECO MASSIMO','MANAGER','3922',to_date('09-JUN-81','DD-MON-RR'),'1821',null,'226');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5116','PETRARCA UGO','TECHNICIAN','2529',to_date('09-JUN-81','DD-MON-RR'),'1645',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5117','SANTE FEDERICO','PROFESSOR','3720',to_date('09-JUN-81','DD-MON-RR'),'256',null,'6');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5118','DANTE ANTONIO','HEADMASTER','3882',to_date('09-JUN-81','DD-MON-RR'),'1486',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5119','DANTE PAOLO','MANAGER','1851',to_date('09-JUN-81','DD-MON-RR'),'1601',null,'195');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5120','PETRARCA ANTONIO','ENGINEER','158',to_date('09-JUN-81','DD-MON-RR'),'1322',null,'347');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5121','TIBALDI SILVIA','PHDSTUDENT','2646',to_date('09-JUN-81','DD-MON-RR'),'1789',null,'358');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5122','LEOPARDI COSIMO','PHDSTUDENT','3152',to_date('09-JUN-81','DD-MON-RR'),'703',null,'240');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5123','LEVI LUDOVICO','PHDSTUDENT','81',to_date('09-JUN-81','DD-MON-RR'),'1822',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5124','CALVINO MARIA','SECRETARY','779',to_date('09-JUN-81','DD-MON-RR'),'941',null,'359');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5125','DANTE ELIO','ENGINEER','1672',to_date('09-JUN-81','DD-MON-RR'),'650',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5126','LEVI LUCA','LAWYER','4689',to_date('09-JUN-81','DD-MON-RR'),'651',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5127','DANTE IVANO','MANAGER','5040',to_date('09-JUN-81','DD-MON-RR'),'714',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5128','PETRARCA ANGELO','ENGINEER','1972',to_date('09-JUN-81','DD-MON-RR'),'4',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5129','CORONA ANTONIO','MANAGER','4966',to_date('09-JUN-81','DD-MON-RR'),'149',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5130','MANZONI PAOLO','TECHNICIAN','1552',to_date('09-JUN-81','DD-MON-RR'),'1887',null,'405');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5131','ESPOSITO MARIO','PHDSTUDENT','1305',to_date('09-JUN-81','DD-MON-RR'),'1758',null,'472');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5132','COZZA PASQUALE','MANAGER','107',to_date('09-JUN-81','DD-MON-RR'),'987',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5133','COZZA LUIGI','LAWYER','1376',to_date('09-JUN-81','DD-MON-RR'),'683',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5134','LEOPARDI IVANO','HEADMASTER','3080',to_date('09-JUN-81','DD-MON-RR'),'718',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5135','NERI MARIA','HEADMASTER','1419',to_date('09-JUN-81','DD-MON-RR'),'700',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5136','LEVI IVANO','TECHNICIAN','3632',to_date('09-JUN-81','DD-MON-RR'),'365',null,'217');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5137','COZZA UGO','SUPERVISOR','1748',to_date('09-JUN-81','DD-MON-RR'),'58',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5138','LEVI PASQUALE','LAWYER','2135',to_date('09-JUN-81','DD-MON-RR'),'1731',null,'369');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5139','PETRARCA ELIO','SECRETARY','2079',to_date('09-JUN-81','DD-MON-RR'),'690',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5140','COZZA ELENA','MANAGER','426',to_date('09-JUN-81','DD-MON-RR'),'824',null,'443');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5141','CALVINO FEDERICO','SECRETARY','1186',to_date('09-JUN-81','DD-MON-RR'),'413',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5142','CARBONE CLARA','SECRETARY','3147',to_date('09-JUN-81','DD-MON-RR'),'400',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5143','FUMAROLA CLARA','SUPERVISOR','2308',to_date('09-JUN-81','DD-MON-RR'),'1',null,'249');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5144','CARBONE UMBERTO','HEADMASTER','1633',to_date('09-JUN-81','DD-MON-RR'),'1707',null,'294');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5145','TIBALDI ELENA','TECHNICIAN','1766',to_date('09-JUN-81','DD-MON-RR'),'743',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5146','LEVI LUCIA','SUPERVISOR','233',to_date('09-JUN-81','DD-MON-RR'),'554',null,'421');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5147','GRIMALDI ALFONSO','PHDSTUDENT','257',to_date('09-JUN-81','DD-MON-RR'),'1110',null,'451');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5148','FO UGO','PHDSTUDENT','3699',to_date('09-JUN-81','DD-MON-RR'),'112',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5149','LEOPARDI LUDOVICO','MANAGER','2372',to_date('09-JUN-81','DD-MON-RR'),'1122',null,'396');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5150','CALVINO CLARA','ENGINEER','3988',to_date('09-JUN-81','DD-MON-RR'),'1423',null,'226');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5151','SANTE ELENA','PROFESSOR','2826',to_date('09-JUN-81','DD-MON-RR'),'1974',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5152','BIANCHI GAETANO','HEADMASTER','495',to_date('09-JUN-81','DD-MON-RR'),'161',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5153','COZZA LUDOVICO','MANAGER','2518',to_date('09-JUN-81','DD-MON-RR'),'1769',null,'469');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5154','NERI FRANCESCO','ENGINEER','4723',to_date('09-JUN-81','DD-MON-RR'),'1125',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5155','LEVI ROBERTA','ENGINEER','4073',to_date('09-JUN-81','DD-MON-RR'),'773',null,'412');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5156','FUMAROLA ALFONSO','MANAGER','3830',to_date('09-JUN-81','DD-MON-RR'),'1694',null,'376');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5157','LEVI COSIMO','TECHNICIAN','1239',to_date('09-JUN-81','DD-MON-RR'),'672',null,'432');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5158','CARBONE ANTONIO','SUPERVISOR','2060',to_date('09-JUN-81','DD-MON-RR'),'1649',null,'457');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5159','LEOPARDI IVANO','HEADMASTER','2693',to_date('09-JUN-81','DD-MON-RR'),'1438',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5160','GRIMALDI GAETANO','MANAGER','1958',to_date('09-JUN-81','DD-MON-RR'),'436',null,'289');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5161','SANTE ELENA','SECRETARY','5007',to_date('09-JUN-81','DD-MON-RR'),'408',null,'362');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5162','ESPOSITO ROBERTA','PROFESSOR','2620',to_date('09-JUN-81','DD-MON-RR'),'1929',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5163','LEOPARDI PAOLO','ENGINEER','2082',to_date('09-JUN-81','DD-MON-RR'),'1761',null,'230');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5164','TIBALDI LUCIA','SUPERVISOR','1740',to_date('09-JUN-81','DD-MON-RR'),'1482',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5165','CARBONE DAMIANO','TECHNICIAN','571',to_date('09-JUN-81','DD-MON-RR'),'775',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5166','ESPOSITO GIOVANNI','SUPERVISOR','2935',to_date('09-JUN-81','DD-MON-RR'),'1123',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5167','ESPOSITO GIOVANNI','PHDSTUDENT','1335',to_date('09-JUN-81','DD-MON-RR'),'1586',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5168','FUMAROLA PASQUALE','PHDSTUDENT','1015',to_date('09-JUN-81','DD-MON-RR'),'1137',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5169','LEOPARDI MARIO','SECRETARY','4770',to_date('09-JUN-81','DD-MON-RR'),'450',null,'153');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5170','PETRARCA MARIA','PHDSTUDENT','1644',to_date('09-JUN-81','DD-MON-RR'),'506',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5171','FUMAROLA LUCIA','HEADMASTER','201',to_date('09-JUN-81','DD-MON-RR'),'1023',null,'428');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5172','FO LUCA','TECHNICIAN','1834',to_date('09-JUN-81','DD-MON-RR'),'127',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5173','FUMAROLA DAMIANO','SECRETARY','4166',to_date('09-JUN-81','DD-MON-RR'),'1639',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5174','ECO ELIO','SECRETARY','3713',to_date('09-JUN-81','DD-MON-RR'),'802',null,'391');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5175','LEOPARDI MASSIMO','MANAGER','1760',to_date('09-JUN-81','DD-MON-RR'),'1251',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5176','ESPOSITO CLARA','MANAGER','1746',to_date('09-JUN-81','DD-MON-RR'),'1225',null,'317');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5177','NERI MARIA','SUPERVISOR','1740',to_date('09-JUN-81','DD-MON-RR'),'604',null,'251');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5178','TIBALDI ALFONSO','SECRETARY','1930',to_date('09-JUN-81','DD-MON-RR'),'894',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5179','GRIMALDI PAOLO','MANAGER','3111',to_date('09-JUN-81','DD-MON-RR'),'633',null,'413');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5180','TIBALDI LUDOVICO','PHDSTUDENT','1606',to_date('09-JUN-81','DD-MON-RR'),'1364',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5181','LEOPARDI MARIA','PHDSTUDENT','3171',to_date('09-JUN-81','DD-MON-RR'),'124',null,'472');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5182','TIBALDI ANGELO','MANAGER','3558',to_date('09-JUN-81','DD-MON-RR'),'1185',null,'97');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5183','MANZONI LUDOVICO','LAWYER','1644',to_date('09-JUN-81','DD-MON-RR'),'474',null,'142');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5184','FO LUCA','ENGINEER','3570',to_date('09-JUN-81','DD-MON-RR'),'1762',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5185','FO ANGELO','PHDSTUDENT','3362',to_date('09-JUN-81','DD-MON-RR'),'1150',null,'112');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5186','ESPOSITO LUIGI','SECRETARY','3844',to_date('09-JUN-81','DD-MON-RR'),'1353',null,'5');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5187','LEVI CLARA','PHDSTUDENT','3011',to_date('09-JUN-81','DD-MON-RR'),'1220',null,'430');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5188','DANTE ELIO','HEADMASTER','3182',to_date('09-JUN-81','DD-MON-RR'),'235',null,'481');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5189','COZZA GIOVANNI','MANAGER','4054',to_date('09-JUN-81','DD-MON-RR'),'141',null,'62');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5190','DANTE ANDREA','HEADMASTER','2721',to_date('09-JUN-81','DD-MON-RR'),'468',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5191','CARBONE ANGELO','ENGINEER','3625',to_date('09-JUN-81','DD-MON-RR'),'766',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5192','LEVI LUCIA','PHDSTUDENT','5082',to_date('09-JUN-81','DD-MON-RR'),'1302',null,'120');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5193','PETRARCA ANGELO','MANAGER','2939',to_date('09-JUN-81','DD-MON-RR'),'81',null,'79');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5194','CORONA ELENA','LAWYER','4013',to_date('09-JUN-81','DD-MON-RR'),'1439',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5195','PETRARCA IVANO','SECRETARY','1490',to_date('09-JUN-81','DD-MON-RR'),'452',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5196','LEVI DAMIANO','PROFESSOR','1460',to_date('09-JUN-81','DD-MON-RR'),'1346',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5197','BIANCHI COSIMO','LAWYER','3206',to_date('09-JUN-81','DD-MON-RR'),'724',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5198','FUMAROLA COSIMO','SECRETARY','4668',to_date('09-JUN-81','DD-MON-RR'),'1537',null,'322');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5199','COZZA IVANO','PROFESSOR','3105',to_date('09-JUN-81','DD-MON-RR'),'141',null,'151');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5200','LEOPARDI ANDREA','LAWYER','2107',to_date('09-JUN-81','DD-MON-RR'),'510',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5201','DANTE ANDREA','PHDSTUDENT','4725',to_date('09-JUN-81','DD-MON-RR'),'1575',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5202','SANTE LUCA','SUPERVISOR','4634',to_date('09-JUN-81','DD-MON-RR'),'784',null,'312');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5203','CALVINO PAOLO','ENGINEER','3503',to_date('09-JUN-81','DD-MON-RR'),'294',null,'298');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5204','TIBALDI IVANO','PHDSTUDENT','4698',to_date('09-JUN-81','DD-MON-RR'),'1603',null,'483');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5205','ESPOSITO COSIMO','TECHNICIAN','1103',to_date('09-JUN-81','DD-MON-RR'),'831',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5206','BIANCHI LUDOVICO','SECRETARY','3383',to_date('09-JUN-81','DD-MON-RR'),'320',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5207','BIANCHI LUIGI','TECHNICIAN','4128',to_date('09-JUN-81','DD-MON-RR'),'831',null,'325');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5208','CALVINO MASSIMO','MANAGER','1286',to_date('09-JUN-81','DD-MON-RR'),'314',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5209','ECO ELIO','PROFESSOR','3851',to_date('09-JUN-81','DD-MON-RR'),'758',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5210','TIBALDI SILVIA','TECHNICIAN','3333',to_date('09-JUN-81','DD-MON-RR'),'1595',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5211','BIANCHI MARIA','LAWYER','2736',to_date('09-JUN-81','DD-MON-RR'),'1781',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5212','LEVI PAOLO','MANAGER','1393',to_date('09-JUN-81','DD-MON-RR'),'426',null,'415');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5213','PETRARCA DAMIANO','MANAGER','4264',to_date('09-JUN-81','DD-MON-RR'),'1758',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5214','ESPOSITO FEDERICO','SECRETARY','610',to_date('09-JUN-81','DD-MON-RR'),'925',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5215','CORONA FEDERICO','HEADMASTER','1223',to_date('09-JUN-81','DD-MON-RR'),'1616',null,'355');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5216','GRIMALDI PAOLO','MANAGER','2320',to_date('09-JUN-81','DD-MON-RR'),'324',null,'421');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5217','LEVI ANDREA','SUPERVISOR','3921',to_date('09-JUN-81','DD-MON-RR'),'876',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7114','CARBONE MARIA','ENGINEER','306',to_date('09-JUN-81','DD-MON-RR'),'1034',null,'423');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7115','GRIMALDI ELIO','TECHNICIAN','4600',to_date('09-JUN-81','DD-MON-RR'),'770',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7116','COZZA DONATO','ENGINEER','224',to_date('09-JUN-81','DD-MON-RR'),'86',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7117','CARBONE LUIGI','SECRETARY','6134',to_date('09-JUN-81','DD-MON-RR'),'1540',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7118','CORONA GIOVANNI','MANAGER','5043',to_date('09-JUN-81','DD-MON-RR'),'179',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7119','NERI DONATO','SUPERVISOR','1704',to_date('09-JUN-81','DD-MON-RR'),'151',null,'271');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7120','CARBONE DAMIANO','ENGINEER','4267',to_date('09-JUN-81','DD-MON-RR'),'908',null,'309');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7121','BIANCHI CLARA','HEADMASTER','2150',to_date('09-JUN-81','DD-MON-RR'),'1987',null,'209');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7122','LEVI ANDREA','MANAGER','2656',to_date('09-JUN-81','DD-MON-RR'),'383',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7123','FUMAROLA ANDREA','MANAGER','4447',to_date('09-JUN-81','DD-MON-RR'),'938',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7124','CARBONE GAETANO','ENGINEER','4486',to_date('09-JUN-81','DD-MON-RR'),'1413',null,'48');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7125','ECO IVANO','SECRETARY','2900',to_date('09-JUN-81','DD-MON-RR'),'784',null,'179');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7126','DANTE MARIO','MANAGER','2860',to_date('09-JUN-81','DD-MON-RR'),'139',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7127','FUMAROLA MARIO','MANAGER','1907',to_date('09-JUN-81','DD-MON-RR'),'437',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7128','FUMAROLA LUIGI','TECHNICIAN','2749',to_date('09-JUN-81','DD-MON-RR'),'1092',null,'33');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7129','COZZA ALFONSO','HEADMASTER','2828',to_date('09-JUN-81','DD-MON-RR'),'1558',null,'120');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7130','PETRARCA COSIMO','HEADMASTER','2847',to_date('09-JUN-81','DD-MON-RR'),'718',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7131','FO SILVIA','HEADMASTER','573',to_date('09-JUN-81','DD-MON-RR'),'1575',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7132','SANTE LUIGI','TECHNICIAN','288',to_date('09-JUN-81','DD-MON-RR'),'1749',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7133','TIBALDI LUCIA','MANAGER','3385',to_date('09-JUN-81','DD-MON-RR'),'1493',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7134','FUMAROLA MARIO','PHDSTUDENT','534',to_date('09-JUN-81','DD-MON-RR'),'1037',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7135','LEVI DONATO','TECHNICIAN','2490',to_date('09-JUN-81','DD-MON-RR'),'824',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7136','ESPOSITO GAETANO','PHDSTUDENT','6905',to_date('09-JUN-81','DD-MON-RR'),'502',null,'104');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7137','LEOPARDI CLARA','HEADMASTER','2418',to_date('09-JUN-81','DD-MON-RR'),'1374',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7138','SANTE ELIO','MANAGER','6530',to_date('09-JUN-81','DD-MON-RR'),'78',null,'399');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7139','BIANCHI LUIGI','ENGINEER','4670',to_date('09-JUN-81','DD-MON-RR'),'1310',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7140','LEVI GAETANO','SUPERVISOR','389',to_date('09-JUN-81','DD-MON-RR'),'639',null,'432');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7141','FUMAROLA ALFONSO','SECRETARY','3658',to_date('09-JUN-81','DD-MON-RR'),'123',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7142','ESPOSITO LUCA','LAWYER','3846',to_date('09-JUN-81','DD-MON-RR'),'1262',null,'310');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7143','DANTE PASQUALE','MANAGER','2020',to_date('09-JUN-81','DD-MON-RR'),'424',null,'112');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7144','FO ALFONSO','LAWYER','24',to_date('09-JUN-81','DD-MON-RR'),'1152',null,'230');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7145','DANTE DAMIANO','MANAGER','6400',to_date('09-JUN-81','DD-MON-RR'),'17',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7146','ESPOSITO COSIMO','LAWYER','5688',to_date('09-JUN-81','DD-MON-RR'),'1222',null,'453');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7147','FUMAROLA GIOVANNI','TECHNICIAN','122',to_date('09-JUN-81','DD-MON-RR'),'1743',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7148','PETRARCA LUIGI','SECRETARY','5891',to_date('09-JUN-81','DD-MON-RR'),'769',null,'169');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7149','ESPOSITO PAOLO','MANAGER','6109',to_date('09-JUN-81','DD-MON-RR'),'940',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7150','COZZA FRANCESCO','PROFESSOR','5331',to_date('09-JUN-81','DD-MON-RR'),'1619',null,'399');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7151','CARBONE DAMIANO','TECHNICIAN','2436',to_date('09-JUN-81','DD-MON-RR'),'732',null,'254');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7152','COZZA LUIGI','MANAGER','3189',to_date('09-JUN-81','DD-MON-RR'),'932',null,'357');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7153','ECO CLARA','PROFESSOR','2878',to_date('09-JUN-81','DD-MON-RR'),'1857',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7154','TIBALDI IVANO','PROFESSOR','14',to_date('09-JUN-81','DD-MON-RR'),'1665',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7155','LEVI ROBERTA','ENGINEER','4503',to_date('09-JUN-81','DD-MON-RR'),'1786',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7156','GRIMALDI FEDERICO','MANAGER','2342',to_date('09-JUN-81','DD-MON-RR'),'1460',null,'399');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7157','MANZONI ELENA','LAWYER','4868',to_date('09-JUN-81','DD-MON-RR'),'846',null,'356');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7158','GRIMALDI LUCIA','PROFESSOR','1515',to_date('09-JUN-81','DD-MON-RR'),'202',null,'373');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7159','NERI SILVIA','PROFESSOR','586',to_date('09-JUN-81','DD-MON-RR'),'1689',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7160','ECO FEDERICO','HEADMASTER','1961',to_date('09-JUN-81','DD-MON-RR'),'625',null,'299');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7161','TIBALDI MARIA','SUPERVISOR','4071',to_date('09-JUN-81','DD-MON-RR'),'138',null,'359');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7162','LEVI LUIGI','PROFESSOR','4402',to_date('09-JUN-81','DD-MON-RR'),'1172',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7163','BIANCHI ANDREA','SUPERVISOR','1055',to_date('09-JUN-81','DD-MON-RR'),'386',null,'459');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7164','GRIMALDI ELIO','TECHNICIAN','4448',to_date('09-JUN-81','DD-MON-RR'),'1377',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7165','DANTE LUCA','TECHNICIAN','6349',to_date('09-JUN-81','DD-MON-RR'),'367',null,'301');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7166','DANTE MASSIMO','TECHNICIAN','3402',to_date('09-JUN-81','DD-MON-RR'),'1776',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7167','FUMAROLA MASSIMO','TECHNICIAN','6377',to_date('09-JUN-81','DD-MON-RR'),'1740',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7168','DANTE ROBERTA','HEADMASTER','5930',to_date('09-JUN-81','DD-MON-RR'),'692',null,'40');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7169','FO LUIGI','LAWYER','3647',to_date('09-JUN-81','DD-MON-RR'),'1724',null,'187');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7170','FUMAROLA FEDERICO','HEADMASTER','2906',to_date('09-JUN-81','DD-MON-RR'),'1856',null,'234');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7171','MANZONI ELIO','TECHNICIAN','2525',to_date('09-JUN-81','DD-MON-RR'),'1777',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7172','CALVINO LUCA','SECRETARY','608',to_date('09-JUN-81','DD-MON-RR'),'1944',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7173','CORONA SILVIA','ENGINEER','6297',to_date('09-JUN-81','DD-MON-RR'),'1617',null,'174');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7174','COZZA ALFONSO','TECHNICIAN','4631',to_date('09-JUN-81','DD-MON-RR'),'129',null,'226');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7175','TIBALDI ALFONSO','LAWYER','2200',to_date('09-JUN-81','DD-MON-RR'),'1170',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7176','ESPOSITO CLARA','MANAGER','4048',to_date('09-JUN-81','DD-MON-RR'),'1891',null,'362');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7177','LEVI FEDERICO','SUPERVISOR','1247',to_date('09-JUN-81','DD-MON-RR'),'1591',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7178','ECO SILVIA','MANAGER','7024',to_date('09-JUN-81','DD-MON-RR'),'1328',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7179','BIANCHI PASQUALE','HEADMASTER','6580',to_date('09-JUN-81','DD-MON-RR'),'537',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7180','SANTE ANDREA','MANAGER','6195',to_date('09-JUN-81','DD-MON-RR'),'1193',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7181','MANZONI ANGELO','PHDSTUDENT','876',to_date('09-JUN-81','DD-MON-RR'),'1872',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7182','SANTE FRANCESCO','ENGINEER','4708',to_date('09-JUN-81','DD-MON-RR'),'702',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7183','ECO LUDOVICO','LAWYER','1424',to_date('09-JUN-81','DD-MON-RR'),'613',null,'226');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7184','SANTE PAOLO','PROFESSOR','6436',to_date('09-JUN-81','DD-MON-RR'),'1100',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7185','ESPOSITO ROBERTA','PHDSTUDENT','3294',to_date('09-JUN-81','DD-MON-RR'),'1563',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7186','BIANCHI LUIGI','MANAGER','6936',to_date('09-JUN-81','DD-MON-RR'),'378',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7187','LEVI LUCIA','TECHNICIAN','4800',to_date('09-JUN-81','DD-MON-RR'),'1384',null,'34');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7188','PETRARCA PASQUALE','SUPERVISOR','3303',to_date('09-JUN-81','DD-MON-RR'),'653',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7189','SANTE CLARA','TECHNICIAN','7114',to_date('09-JUN-81','DD-MON-RR'),'1984',null,'444');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7190','FUMAROLA ANDREA','MANAGER','6971',to_date('09-JUN-81','DD-MON-RR'),'1075',null,'294');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7191','MANZONI ANDREA','PHDSTUDENT','5788',to_date('09-JUN-81','DD-MON-RR'),'1836',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7192','CALVINO GIOVANNI','TECHNICIAN','451',to_date('09-JUN-81','DD-MON-RR'),'94',null,'287');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7193','CORONA COSIMO','LAWYER','3808',to_date('09-JUN-81','DD-MON-RR'),'355',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7194','CORONA ANTONIO','HEADMASTER','4112',to_date('09-JUN-81','DD-MON-RR'),'160',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7195','CORONA IVANO','SUPERVISOR','1920',to_date('09-JUN-81','DD-MON-RR'),'769',null,'367');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7196','FO FRANCESCO','TECHNICIAN','3682',to_date('09-JUN-81','DD-MON-RR'),'781',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7197','ECO UGO','ENGINEER','1720',to_date('09-JUN-81','DD-MON-RR'),'1597',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7198','FO LUDOVICO','SUPERVISOR','3717',to_date('09-JUN-81','DD-MON-RR'),'920',null,'464');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7199','PETRARCA FRANCESCO','SECRETARY','4841',to_date('09-JUN-81','DD-MON-RR'),'531',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7200','DANTE ROBERTA','SUPERVISOR','7116',to_date('09-JUN-81','DD-MON-RR'),'1984',null,'450');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7201','BIANCHI GAETANO','SECRETARY','2972',to_date('09-JUN-81','DD-MON-RR'),'719',null,'438');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7202','NERI UMBERTO','MANAGER','48',to_date('09-JUN-81','DD-MON-RR'),'1911',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7203','ESPOSITO LUCIA','PROFESSOR','5712',to_date('09-JUN-81','DD-MON-RR'),'571',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7204','BIANCHI DONATO','ENGINEER','5353',to_date('09-JUN-81','DD-MON-RR'),'1009',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7205','COZZA GIOVANNI','PROFESSOR','2591',to_date('09-JUN-81','DD-MON-RR'),'567',null,'240');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7206','ESPOSITO LUCIA','SUPERVISOR','5378',to_date('09-JUN-81','DD-MON-RR'),'841',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7207','FUMAROLA UMBERTO','ENGINEER','1708',to_date('09-JUN-81','DD-MON-RR'),'894',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7208','ESPOSITO LUDOVICO','PROFESSOR','7150',to_date('09-JUN-81','DD-MON-RR'),'562',null,'207');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7209','COZZA UMBERTO','SECRETARY','2106',to_date('09-JUN-81','DD-MON-RR'),'1494',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7210','ESPOSITO ANTONIO','SECRETARY','3913',to_date('09-JUN-81','DD-MON-RR'),'1901',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7211','MANZONI LUCIA','MANAGER','2530',to_date('09-JUN-81','DD-MON-RR'),'1914',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7212','ECO SILVIA','LAWYER','3195',to_date('09-JUN-81','DD-MON-RR'),'1635',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7213','ESPOSITO UMBERTO','HEADMASTER','6726',to_date('09-JUN-81','DD-MON-RR'),'918',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7214','ESPOSITO IVANO','MANAGER','4289',to_date('09-JUN-81','DD-MON-RR'),'1092',null,'83');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7215','BIANCHI ELENA','TECHNICIAN','2840',to_date('09-JUN-81','DD-MON-RR'),'288',null,'354');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7216','GRIMALDI FEDERICO','PROFESSOR','458',to_date('09-JUN-81','DD-MON-RR'),'1035',null,'438');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7217','ESPOSITO MARIA','SECRETARY','164',to_date('09-JUN-81','DD-MON-RR'),'1999',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7218','GRIMALDI GIOVANNI','SUPERVISOR','5811',to_date('09-JUN-81','DD-MON-RR'),'1470',null,'101');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7219','FUMAROLA CLARA','TECHNICIAN','4633',to_date('09-JUN-81','DD-MON-RR'),'1355',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7220','ECO ELENA','SECRETARY','4101',to_date('09-JUN-81','DD-MON-RR'),'835',null,'374');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7221','LEVI DAMIANO','TECHNICIAN','1425',to_date('09-JUN-81','DD-MON-RR'),'411',null,'216');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7222','GRIMALDI ELIO','MANAGER','3849',to_date('09-JUN-81','DD-MON-RR'),'103',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7223','MANZONI MARIA','TECHNICIAN','3989',to_date('09-JUN-81','DD-MON-RR'),'1053',null,'263');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7224','FUMAROLA GIOVANNI','LAWYER','1525',to_date('09-JUN-81','DD-MON-RR'),'779',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7225','FUMAROLA COSIMO','SECRETARY','5911',to_date('09-JUN-81','DD-MON-RR'),'1534',null,'365');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7226','ECO DAMIANO','PROFESSOR','3478',to_date('09-JUN-81','DD-MON-RR'),'484',null,'39');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7227','LEVI PAOLO','TECHNICIAN','6533',to_date('09-JUN-81','DD-MON-RR'),'1699',null,'79');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7228','PETRARCA GAETANO','PROFESSOR','4957',to_date('09-JUN-81','DD-MON-RR'),'422',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7229','ESPOSITO ANTONIO','HEADMASTER','5960',to_date('09-JUN-81','DD-MON-RR'),'354',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7230','GRIMALDI FEDERICO','ENGINEER','3077',to_date('09-JUN-81','DD-MON-RR'),'418',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7231','NERI UMBERTO','MANAGER','210',to_date('09-JUN-81','DD-MON-RR'),'514',null,'399');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7232','SANTE UGO','SECRETARY','1560',to_date('09-JUN-81','DD-MON-RR'),'151',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7233','GRIMALDI PASQUALE','PHDSTUDENT','1850',to_date('09-JUN-81','DD-MON-RR'),'1309',null,'417');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7234','TIBALDI DONATO','PROFESSOR','5920',to_date('09-JUN-81','DD-MON-RR'),'1385',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7235','TIBALDI PAOLO','SECRETARY','781',to_date('09-JUN-81','DD-MON-RR'),'463',null,'289');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7236','COZZA ANGELO','TECHNICIAN','1273',to_date('09-JUN-81','DD-MON-RR'),'833',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7237','TIBALDI FRANCESCO','HEADMASTER','647',to_date('09-JUN-81','DD-MON-RR'),'1481',null,'429');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7238','LEVI UGO','MANAGER','4908',to_date('09-JUN-81','DD-MON-RR'),'743',null,'240');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7239','NERI MASSIMO','MANAGER','2274',to_date('09-JUN-81','DD-MON-RR'),'1706',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7240','LEVI FEDERICO','MANAGER','4788',to_date('09-JUN-81','DD-MON-RR'),'649',null,'40');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7241','ESPOSITO ELENA','PHDSTUDENT','4299',to_date('09-JUN-81','DD-MON-RR'),'241',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7242','GRIMALDI UGO','PHDSTUDENT','7150',to_date('09-JUN-81','DD-MON-RR'),'369',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7243','MANZONI UGO','SUPERVISOR','4869',to_date('09-JUN-81','DD-MON-RR'),'1834',null,'319');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7244','CARBONE SILVIA','MANAGER','3654',to_date('09-JUN-81','DD-MON-RR'),'1488',null,'263');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7245','FUMAROLA CLARA','SECRETARY','2875',to_date('09-JUN-81','DD-MON-RR'),'1395',null,'34');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7246','MANZONI SILVIA','TECHNICIAN','6857',to_date('09-JUN-81','DD-MON-RR'),'1063',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7247','PETRARCA ALFONSO','PHDSTUDENT','1758',to_date('09-JUN-81','DD-MON-RR'),'1447',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7248','FO LUIGI','HEADMASTER','4795',to_date('09-JUN-81','DD-MON-RR'),'482',null,'284');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('17','MANZONI LUCIA','MANAGER','7',to_date('09-JUN-81','DD-MON-RR'),'976',null,'259');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('18','LEVI FEDERICO','TECHNICIAN','0',to_date('09-JUN-81','DD-MON-RR'),'544',null,'52');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('19','LEVI LUIGI','MANAGER','2',to_date('09-JUN-81','DD-MON-RR'),'962',null,'443');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('20','ESPOSITO LUDOVICO','SUPERVISOR','13',to_date('09-JUN-81','DD-MON-RR'),'618',null,'229');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('21','MANZONI MARIA','PROFESSOR','7',to_date('09-JUN-81','DD-MON-RR'),'1163',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('22','LEOPARDI DAMIANO','PROFESSOR','20',to_date('09-JUN-81','DD-MON-RR'),'602',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('23','FUMAROLA GAETANO','PHDSTUDENT','18',to_date('09-JUN-81','DD-MON-RR'),'1628',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('24','CORONA PASQUALE','SECRETARY','16',to_date('09-JUN-81','DD-MON-RR'),'1715',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('25','CARBONE CLARA','PHDSTUDENT','5',to_date('09-JUN-81','DD-MON-RR'),'1907',null,'132');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('26','ECO ANTONIO','TECHNICIAN','1',to_date('09-JUN-81','DD-MON-RR'),'1564',null,'415');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('27','SANTE MASSIMO','TECHNICIAN','17',to_date('09-JUN-81','DD-MON-RR'),'1187',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('28','BIANCHI ROBERTA','SECRETARY','20',to_date('09-JUN-81','DD-MON-RR'),'1679',null,'299');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('29','LEVI ELIO','MANAGER','10',to_date('09-JUN-81','DD-MON-RR'),'881',null,'84');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('30','FO SILVIA','TECHNICIAN','28',to_date('09-JUN-81','DD-MON-RR'),'495',null,'201');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('31','CALVINO LUCA','ENGINEER','14',to_date('09-JUN-81','DD-MON-RR'),'1952',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('32','FUMAROLA UMBERTO','MANAGER','31',to_date('09-JUN-81','DD-MON-RR'),'1661',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('33','GRIMALDI DAMIANO','SUPERVISOR','25',to_date('09-JUN-81','DD-MON-RR'),'172',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('34','FO ANGELO','LAWYER','22',to_date('09-JUN-81','DD-MON-RR'),'1330',null,'472');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('35','PETRARCA LUCA','SECRETARY','10',to_date('09-JUN-81','DD-MON-RR'),'1224',null,'105');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('36','CORONA ELIO','TECHNICIAN','18',to_date('09-JUN-81','DD-MON-RR'),'588',null,'62');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('37','COZZA FEDERICO','MANAGER','15',to_date('09-JUN-81','DD-MON-RR'),'1154',null,'78');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('38','CARBONE DONATO','PROFESSOR','8',to_date('09-JUN-81','DD-MON-RR'),'616',null,'298');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('39','MANZONI LUCIA','PROFESSOR','18',to_date('09-JUN-81','DD-MON-RR'),'669',null,'281');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('40','CALVINO PAOLO','SECRETARY','15',to_date('09-JUN-81','DD-MON-RR'),'923',null,'417');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('41','ECO SILVIA','MANAGER','30',to_date('09-JUN-81','DD-MON-RR'),'1347',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('42','BIANCHI ELIO','TECHNICIAN','8',to_date('09-JUN-81','DD-MON-RR'),'467',null,'63');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('43','GRIMALDI IVANO','SUPERVISOR','36',to_date('09-JUN-81','DD-MON-RR'),'1503',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('44','TIBALDI GIOVANNI','SECRETARY','15',to_date('09-JUN-81','DD-MON-RR'),'396',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('45','SANTE FRANCESCO','PHDSTUDENT','6',to_date('09-JUN-81','DD-MON-RR'),'4',null,'311');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('46','FUMAROLA GAETANO','MANAGER','29',to_date('09-JUN-81','DD-MON-RR'),'684',null,'224');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('47','CARBONE ANGELO','SUPERVISOR','6',to_date('09-JUN-81','DD-MON-RR'),'808',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('48','SANTE PAOLO','PHDSTUDENT','45',to_date('09-JUN-81','DD-MON-RR'),'1227',null,'389');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('49','DANTE ROBERTA','ENGINEER','29',to_date('09-JUN-81','DD-MON-RR'),'844',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('50','DANTE ANTONIO','MANAGER','37',to_date('09-JUN-81','DD-MON-RR'),'952',null,'160');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('51','MANZONI LUCA','TECHNICIAN','7',to_date('09-JUN-81','DD-MON-RR'),'177',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('52','BIANCHI ALFONSO','SUPERVISOR','43',to_date('09-JUN-81','DD-MON-RR'),'1664',null,'438');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('53','SANTE FEDERICO','HEADMASTER','19',to_date('09-JUN-81','DD-MON-RR'),'121',null,'122');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('54','ESPOSITO PASQUALE','PHDSTUDENT','34',to_date('09-JUN-81','DD-MON-RR'),'1185',null,'368');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('55','TIBALDI IVANO','SECRETARY','36',to_date('09-JUN-81','DD-MON-RR'),'1825',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('56','CORONA DAMIANO','MANAGER','50',to_date('09-JUN-81','DD-MON-RR'),'829',null,'44');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('57','SANTE CLARA','PHDSTUDENT','36',to_date('09-JUN-81','DD-MON-RR'),'1693',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('58','CORONA ANDREA','MANAGER','8',to_date('09-JUN-81','DD-MON-RR'),'1103',null,'387');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('59','BIANCHI GIOVANNI','MANAGER','41',to_date('09-JUN-81','DD-MON-RR'),'689',null,'183');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('60','MANZONI LUIGI','PROFESSOR','31',to_date('09-JUN-81','DD-MON-RR'),'719',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('61','GRIMALDI ANGELO','MANAGER','4',to_date('09-JUN-81','DD-MON-RR'),'510',null,'71');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('62','CORONA ROBERTA','SECRETARY','57',to_date('09-JUN-81','DD-MON-RR'),'135',null,'495');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('63','FO MARIO','LAWYER','15',to_date('09-JUN-81','DD-MON-RR'),'1473',null,'364');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('64','DANTE COSIMO','PROFESSOR','51',to_date('09-JUN-81','DD-MON-RR'),'1677',null,'385');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('65','ECO ELENA','MANAGER','45',to_date('09-JUN-81','DD-MON-RR'),'1601',null,'411');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('66','ESPOSITO LUCA','MANAGER','58',to_date('09-JUN-81','DD-MON-RR'),'1872',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('67','NERI ANDREA','PROFESSOR','11',to_date('09-JUN-81','DD-MON-RR'),'46',null,'459');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('68','MANZONI DONATO','MANAGER','23',to_date('09-JUN-81','DD-MON-RR'),'1621',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('69','ESPOSITO ROBERTA','MANAGER','34',to_date('09-JUN-81','DD-MON-RR'),'1268',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1074','LEVI UMBERTO','SECRETARY','631',to_date('09-JUN-81','DD-MON-RR'),'493',null,'166');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1075','PETRARCA CLARA','PHDSTUDENT','692',to_date('09-JUN-81','DD-MON-RR'),'1710',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1076','GRIMALDI LUDOVICO','SECRETARY','1031',to_date('09-JUN-81','DD-MON-RR'),'1146',null,'331');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1077','CORONA ROBERTA','MANAGER','416',to_date('09-JUN-81','DD-MON-RR'),'1038',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1078','LEOPARDI PASQUALE','PROFESSOR','647',to_date('09-JUN-81','DD-MON-RR'),'1126',null,'424');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1079','LEVI GAETANO','MANAGER','470',to_date('09-JUN-81','DD-MON-RR'),'1101',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1080','BIANCHI COSIMO','SUPERVISOR','632',to_date('09-JUN-81','DD-MON-RR'),'411',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1081','COZZA DAMIANO','SECRETARY','178',to_date('09-JUN-81','DD-MON-RR'),'1243',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1082','SANTE UMBERTO','SECRETARY','599',to_date('09-JUN-81','DD-MON-RR'),'1769',null,'337');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1083','COZZA FRANCESCO','PHDSTUDENT','971',to_date('09-JUN-81','DD-MON-RR'),'251',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1084','TIBALDI ELENA','HEADMASTER','589',to_date('09-JUN-81','DD-MON-RR'),'1910',null,'405');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1085','LEOPARDI PAOLO','PROFESSOR','779',to_date('09-JUN-81','DD-MON-RR'),'621',null,'289');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1086','FO ANGELO','ENGINEER','971',to_date('09-JUN-81','DD-MON-RR'),'1713',null,'432');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1087','CORONA ELIO','MANAGER','885',to_date('09-JUN-81','DD-MON-RR'),'478',null,'123');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1088','COZZA ANDREA','LAWYER','245',to_date('09-JUN-81','DD-MON-RR'),'881',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1089','PETRARCA CLARA','SECRETARY','854',to_date('09-JUN-81','DD-MON-RR'),'1458',null,'186');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1090','LEVI ANTONIO','PHDSTUDENT','1056',to_date('09-JUN-81','DD-MON-RR'),'72',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1091','CARBONE MARIO','PHDSTUDENT','862',to_date('09-JUN-81','DD-MON-RR'),'1271',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1092','CARBONE LUIGI','MANAGER','18',to_date('09-JUN-81','DD-MON-RR'),'217',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1093','COZZA GAETANO','LAWYER','39',to_date('09-JUN-81','DD-MON-RR'),'1649',null,'432');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1094','LEVI ANGELO','MANAGER','383',to_date('09-JUN-81','DD-MON-RR'),'267',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1095','PETRARCA UMBERTO','MANAGER','898',to_date('09-JUN-81','DD-MON-RR'),'1400',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1096','ESPOSITO GAETANO','TECHNICIAN','360',to_date('09-JUN-81','DD-MON-RR'),'77',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1097','GRIMALDI ELIO','SUPERVISOR','1017',to_date('09-JUN-81','DD-MON-RR'),'1420',null,'457');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1098','GRIMALDI ROBERTA','PROFESSOR','255',to_date('09-JUN-81','DD-MON-RR'),'19',null,'169');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1099','PETRARCA FEDERICO','LAWYER','163',to_date('09-JUN-81','DD-MON-RR'),'588',null,'410');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1100','ESPOSITO ANDREA','HEADMASTER','30',to_date('09-JUN-81','DD-MON-RR'),'1677',null,'126');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1101','BIANCHI SILVIA','HEADMASTER','41',to_date('09-JUN-81','DD-MON-RR'),'794',null,'269');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1102','CORONA MARIA','PHDSTUDENT','390',to_date('09-JUN-81','DD-MON-RR'),'1220',null,'471');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1103','ESPOSITO MASSIMO','SUPERVISOR','863',to_date('09-JUN-81','DD-MON-RR'),'1301',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1104','CARBONE ELIO','SECRETARY','893',to_date('09-JUN-81','DD-MON-RR'),'1795',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1105','GRIMALDI MARIO','HEADMASTER','202',to_date('09-JUN-81','DD-MON-RR'),'1710',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1106','COZZA FEDERICO','PROFESSOR','1034',to_date('09-JUN-81','DD-MON-RR'),'110',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1107','COZZA UGO','HEADMASTER','782',to_date('09-JUN-81','DD-MON-RR'),'1918',null,'389');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1108','DANTE ANGELO','MANAGER','627',to_date('09-JUN-81','DD-MON-RR'),'23',null,'423');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1109','GRIMALDI ANGELO','MANAGER','402',to_date('09-JUN-81','DD-MON-RR'),'1885',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1110','CARBONE IVANO','HEADMASTER','787',to_date('09-JUN-81','DD-MON-RR'),'1514',null,'87');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1111','PETRARCA ELENA','ENGINEER','908',to_date('09-JUN-81','DD-MON-RR'),'255',null,'124');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1112','SANTE PAOLO','PHDSTUDENT','524',to_date('09-JUN-81','DD-MON-RR'),'618',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1113','TIBALDI PASQUALE','PHDSTUDENT','496',to_date('09-JUN-81','DD-MON-RR'),'1050',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1114','DANTE PAOLO','MANAGER','989',to_date('09-JUN-81','DD-MON-RR'),'762',null,'64');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1115','ESPOSITO IVANO','TECHNICIAN','782',to_date('09-JUN-81','DD-MON-RR'),'1236',null,'230');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1116','NERI GAETANO','MANAGER','78',to_date('09-JUN-81','DD-MON-RR'),'332',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1117','LEVI PASQUALE','LAWYER','191',to_date('09-JUN-81','DD-MON-RR'),'1882',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1118','FO COSIMO','HEADMASTER','28',to_date('09-JUN-81','DD-MON-RR'),'1273',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1119','DANTE UMBERTO','ENGINEER','295',to_date('09-JUN-81','DD-MON-RR'),'1635',null,'288');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1120','COZZA IVANO','HEADMASTER','108',to_date('09-JUN-81','DD-MON-RR'),'1800',null,'51');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1121','LEOPARDI ALFONSO','HEADMASTER','235',to_date('09-JUN-81','DD-MON-RR'),'1694',null,'308');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1122','CORONA LUDOVICO','LAWYER','419',to_date('09-JUN-81','DD-MON-RR'),'675',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1123','LEOPARDI ANGELO','LAWYER','805',to_date('09-JUN-81','DD-MON-RR'),'693',null,'427');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1124','TIBALDI MASSIMO','TECHNICIAN','99',to_date('09-JUN-81','DD-MON-RR'),'1377',null,'301');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1125','ESPOSITO FRANCESCO','PHDSTUDENT','168',to_date('09-JUN-81','DD-MON-RR'),'356',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1126','FUMAROLA PASQUALE','ENGINEER','792',to_date('09-JUN-81','DD-MON-RR'),'1889',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1127','COZZA ELENA','PHDSTUDENT','459',to_date('09-JUN-81','DD-MON-RR'),'618',null,'415');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1128','BIANCHI ANTONIO','PHDSTUDENT','738',to_date('09-JUN-81','DD-MON-RR'),'185',null,'249');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1129','FUMAROLA PASQUALE','LAWYER','334',to_date('09-JUN-81','DD-MON-RR'),'151',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1130','PETRARCA GAETANO','PROFESSOR','791',to_date('09-JUN-81','DD-MON-RR'),'1780',null,'436');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1131','NERI SILVIA','SECRETARY','996',to_date('09-JUN-81','DD-MON-RR'),'1694',null,'276');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1132','LEOPARDI PAOLO','PHDSTUDENT','792',to_date('09-JUN-81','DD-MON-RR'),'1152',null,'398');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1133','LEVI IVANO','TECHNICIAN','773',to_date('09-JUN-81','DD-MON-RR'),'1334',null,'132');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1134','TIBALDI GIOVANNI','TECHNICIAN','119',to_date('09-JUN-81','DD-MON-RR'),'948',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1135','SANTE ROBERTA','SECRETARY','467',to_date('09-JUN-81','DD-MON-RR'),'147',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1136','FO LUDOVICO','PHDSTUDENT','1013',to_date('09-JUN-81','DD-MON-RR'),'713',null,'475');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1137','CALVINO IVANO','SECRETARY','1061',to_date('09-JUN-81','DD-MON-RR'),'528',null,'347');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1138','CALVINO FRANCESCO','LAWYER','1029',to_date('09-JUN-81','DD-MON-RR'),'953',null,'186');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1139','ESPOSITO DAMIANO','SECRETARY','481',to_date('09-JUN-81','DD-MON-RR'),'1526',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1140','TIBALDI GAETANO','SUPERVISOR','936',to_date('09-JUN-81','DD-MON-RR'),'1784',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1141','ESPOSITO DAMIANO','HEADMASTER','1008',to_date('09-JUN-81','DD-MON-RR'),'138',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1142','CALVINO IVANO','MANAGER','1087',to_date('09-JUN-81','DD-MON-RR'),'897',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1143','CALVINO CLARA','ENGINEER','403',to_date('09-JUN-81','DD-MON-RR'),'168',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1144','FO COSIMO','SECRETARY','318',to_date('09-JUN-81','DD-MON-RR'),'1355',null,'413');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1145','MANZONI ANTONIO','ENGINEER','805',to_date('09-JUN-81','DD-MON-RR'),'500',null,'99');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1146','BIANCHI COSIMO','TECHNICIAN','143',to_date('09-JUN-81','DD-MON-RR'),'1830',null,'222');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1147','TIBALDI PAOLO','SUPERVISOR','344',to_date('09-JUN-81','DD-MON-RR'),'1403',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1148','FUMAROLA UMBERTO','SUPERVISOR','416',to_date('09-JUN-81','DD-MON-RR'),'1401',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1149','NERI PAOLO','LAWYER','955',to_date('09-JUN-81','DD-MON-RR'),'1410',null,'302');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1150','FO FRANCESCO','MANAGER','1109',to_date('09-JUN-81','DD-MON-RR'),'1426',null,'142');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1151','LEVI IVANO','PROFESSOR','620',to_date('09-JUN-81','DD-MON-RR'),'31',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1152','DANTE SILVIA','ENGINEER','1087',to_date('09-JUN-81','DD-MON-RR'),'1494',null,'340');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1153','FO ANGELO','MANAGER','1083',to_date('09-JUN-81','DD-MON-RR'),'1089',null,'365');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1154','LEOPARDI ALFONSO','MANAGER','622',to_date('09-JUN-81','DD-MON-RR'),'289',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1155','LEOPARDI PAOLO','HEADMASTER','205',to_date('09-JUN-81','DD-MON-RR'),'1533',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1156','TIBALDI ANTONIO','TECHNICIAN','899',to_date('09-JUN-81','DD-MON-RR'),'937',null,'245');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1157','LEVI ELENA','PHDSTUDENT','1143',to_date('09-JUN-81','DD-MON-RR'),'793',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2062','FO FEDERICO','HEADMASTER','2049',to_date('09-JUN-81','DD-MON-RR'),'413',null,'123');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2063','CARBONE IVANO','ENGINEER','1674',to_date('09-JUN-81','DD-MON-RR'),'1755',null,'0');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2064','FO MARIA','PROFESSOR','1145',to_date('09-JUN-81','DD-MON-RR'),'1684',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2065','BIANCHI LUCIA','TECHNICIAN','1651',to_date('09-JUN-81','DD-MON-RR'),'682',null,'111');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2066','FUMAROLA MASSIMO','SECRETARY','838',to_date('09-JUN-81','DD-MON-RR'),'1337',null,'416');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2067','MANZONI CLARA','PROFESSOR','841',to_date('09-JUN-81','DD-MON-RR'),'1510',null,'34');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2068','NERI IVANO','TECHNICIAN','132',to_date('09-JUN-81','DD-MON-RR'),'416',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2069','ECO LUIGI','MANAGER','874',to_date('09-JUN-81','DD-MON-RR'),'823',null,'485');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2070','FUMAROLA FEDERICO','LAWYER','1714',to_date('09-JUN-81','DD-MON-RR'),'726',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3064','BIANCHI GIOVANNI','ENGINEER','888',to_date('09-JUN-81','DD-MON-RR'),'458',null,'304');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3065','GRIMALDI ALFONSO','SUPERVISOR','1117',to_date('09-JUN-81','DD-MON-RR'),'248',null,'325');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3066','CALVINO LUCIA','PHDSTUDENT','1823',to_date('09-JUN-81','DD-MON-RR'),'1932',null,'395');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3067','ECO LUCA','MANAGER','1308',to_date('09-JUN-81','DD-MON-RR'),'523',null,'207');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3068','BIANCHI ALFONSO','PHDSTUDENT','77',to_date('09-JUN-81','DD-MON-RR'),'743',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3069','GRIMALDI IVANO','SUPERVISOR','1498',to_date('09-JUN-81','DD-MON-RR'),'1454',null,'3');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3070','CARBONE LUIGI','LAWYER','29',to_date('09-JUN-81','DD-MON-RR'),'1016',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3071','CALVINO LUIGI','MANAGER','3059',to_date('09-JUN-81','DD-MON-RR'),'1518',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3072','FUMAROLA LUCA','SUPERVISOR','716',to_date('09-JUN-81','DD-MON-RR'),'607',null,'103');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3073','LEVI COSIMO','MANAGER','2311',to_date('09-JUN-81','DD-MON-RR'),'1487',null,'47');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3074','FUMAROLA CLARA','SECRETARY','2061',to_date('09-JUN-81','DD-MON-RR'),'795',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3075','DANTE DAMIANO','SUPERVISOR','1868',to_date('09-JUN-81','DD-MON-RR'),'1008',null,'455');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3076','SANTE LUCA','LAWYER','2664',to_date('09-JUN-81','DD-MON-RR'),'324',null,'417');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3077','CARBONE LUCIA','HEADMASTER','3022',to_date('09-JUN-81','DD-MON-RR'),'367',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3078','COZZA MASSIMO','SUPERVISOR','2809',to_date('09-JUN-81','DD-MON-RR'),'1166',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3079','MANZONI PASQUALE','PROFESSOR','1659',to_date('09-JUN-81','DD-MON-RR'),'293',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3080','GRIMALDI DAMIANO','SECRETARY','616',to_date('09-JUN-81','DD-MON-RR'),'864',null,'391');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3081','FO UGO','TECHNICIAN','573',to_date('09-JUN-81','DD-MON-RR'),'1920',null,'55');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3082','GRIMALDI IVANO','PHDSTUDENT','2257',to_date('09-JUN-81','DD-MON-RR'),'1958',null,'122');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3083','ECO SILVIA','HEADMASTER','1484',to_date('09-JUN-81','DD-MON-RR'),'163',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3084','DANTE ROBERTA','MANAGER','1065',to_date('09-JUN-81','DD-MON-RR'),'1256',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3085','ECO ROBERTA','HEADMASTER','1261',to_date('09-JUN-81','DD-MON-RR'),'1252',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3086','FUMAROLA ROBERTA','MANAGER','437',to_date('09-JUN-81','DD-MON-RR'),'1846',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3087','DANTE UGO','SUPERVISOR','974',to_date('09-JUN-81','DD-MON-RR'),'1352',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3088','SANTE FEDERICO','PROFESSOR','1971',to_date('09-JUN-81','DD-MON-RR'),'1811',null,'410');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3089','CARBONE PASQUALE','MANAGER','1345',to_date('09-JUN-81','DD-MON-RR'),'420',null,'269');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3090','LEOPARDI MASSIMO','HEADMASTER','2556',to_date('09-JUN-81','DD-MON-RR'),'1497',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3091','NERI ROBERTA','MANAGER','3',to_date('09-JUN-81','DD-MON-RR'),'165',null,'125');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3092','LEOPARDI UMBERTO','HEADMASTER','575',to_date('09-JUN-81','DD-MON-RR'),'1304',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3093','GRIMALDI ANGELO','TECHNICIAN','1532',to_date('09-JUN-81','DD-MON-RR'),'1704',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3094','MANZONI ROBERTA','HEADMASTER','701',to_date('09-JUN-81','DD-MON-RR'),'1173',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3095','ESPOSITO ELIO','TECHNICIAN','2258',to_date('09-JUN-81','DD-MON-RR'),'266',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3096','ECO PASQUALE','MANAGER','2007',to_date('09-JUN-81','DD-MON-RR'),'1003',null,'194');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3097','CARBONE LUIGI','TECHNICIAN','291',to_date('09-JUN-81','DD-MON-RR'),'565',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3098','FO LUIGI','HEADMASTER','808',to_date('09-JUN-81','DD-MON-RR'),'1069',null,'222');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3099','DANTE LUCIA','SUPERVISOR','1638',to_date('09-JUN-81','DD-MON-RR'),'155',null,'91');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3100','LEOPARDI PASQUALE','SECRETARY','1305',to_date('09-JUN-81','DD-MON-RR'),'1145',null,'310');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3101','MANZONI GIOVANNI','HEADMASTER','285',to_date('09-JUN-81','DD-MON-RR'),'1082',null,'311');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3102','MANZONI ANGELO','MANAGER','641',to_date('09-JUN-81','DD-MON-RR'),'1069',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3103','GRIMALDI SILVIA','TECHNICIAN','547',to_date('09-JUN-81','DD-MON-RR'),'1522',null,'288');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3104','SANTE PAOLO','HEADMASTER','669',to_date('09-JUN-81','DD-MON-RR'),'1504',null,'253');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3105','BIANCHI PASQUALE','ENGINEER','2750',to_date('09-JUN-81','DD-MON-RR'),'1956',null,'461');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3106','LEOPARDI GAETANO','SECRETARY','1952',to_date('09-JUN-81','DD-MON-RR'),'1713',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3107','DANTE MARIO','SECRETARY','3019',to_date('09-JUN-81','DD-MON-RR'),'1089',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3108','COZZA MASSIMO','HEADMASTER','53',to_date('09-JUN-81','DD-MON-RR'),'611',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3109','CALVINO DONATO','TECHNICIAN','71',to_date('09-JUN-81','DD-MON-RR'),'283',null,'284');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3110','LEVI PAOLO','MANAGER','2732',to_date('09-JUN-81','DD-MON-RR'),'851',null,'52');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3111','LEOPARDI GAETANO','LAWYER','1916',to_date('09-JUN-81','DD-MON-RR'),'1122',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3112','BIANCHI MARIO','SECRETARY','2395',to_date('09-JUN-81','DD-MON-RR'),'1569',null,'304');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3113','BIANCHI DAMIANO','MANAGER','2907',to_date('09-JUN-81','DD-MON-RR'),'1553',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3114','FO PAOLO','PROFESSOR','1072',to_date('09-JUN-81','DD-MON-RR'),'788',null,'56');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3115','SANTE SILVIA','LAWYER','127',to_date('09-JUN-81','DD-MON-RR'),'1604',null,'38');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3116','PETRARCA MARIA','SUPERVISOR','50',to_date('09-JUN-81','DD-MON-RR'),'438',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3117','SANTE LUIGI','PROFESSOR','2515',to_date('09-JUN-81','DD-MON-RR'),'1922',null,'84');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3118','PETRARCA MARIA','ENGINEER','482',to_date('09-JUN-81','DD-MON-RR'),'1993',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3119','GRIMALDI DAMIANO','ENGINEER','527',to_date('09-JUN-81','DD-MON-RR'),'1736',null,'235');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3120','CALVINO GIOVANNI','HEADMASTER','2910',to_date('09-JUN-81','DD-MON-RR'),'1646',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3121','TIBALDI MARIO','SECRETARY','64',to_date('09-JUN-81','DD-MON-RR'),'1970',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3122','CORONA GIOVANNI','PHDSTUDENT','3050',to_date('09-JUN-81','DD-MON-RR'),'1070',null,'86');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3123','LEOPARDI DAMIANO','PROFESSOR','237',to_date('09-JUN-81','DD-MON-RR'),'212',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3124','CALVINO MASSIMO','LAWYER','2687',to_date('09-JUN-81','DD-MON-RR'),'947',null,'312');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3125','PETRARCA ANGELO','PHDSTUDENT','2273',to_date('09-JUN-81','DD-MON-RR'),'1375',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3126','SANTE LUDOVICO','MANAGER','2269',to_date('09-JUN-81','DD-MON-RR'),'1438',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3127','CORONA ANDREA','MANAGER','2993',to_date('09-JUN-81','DD-MON-RR'),'577',null,'224');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3128','NERI DAMIANO','ENGINEER','1145',to_date('09-JUN-81','DD-MON-RR'),'1023',null,'253');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3129','CORONA DAMIANO','SECRETARY','1114',to_date('09-JUN-81','DD-MON-RR'),'308',null,'142');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3130','CARBONE ELENA','MANAGER','1219',to_date('09-JUN-81','DD-MON-RR'),'427',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3131','ECO FRANCESCO','MANAGER','2569',to_date('09-JUN-81','DD-MON-RR'),'1730',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3132','COZZA MARIA','PROFESSOR','2882',to_date('09-JUN-81','DD-MON-RR'),'1136',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3133','CARBONE UGO','SUPERVISOR','2411',to_date('09-JUN-81','DD-MON-RR'),'129',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3134','SANTE ANTONIO','TECHNICIAN','273',to_date('09-JUN-81','DD-MON-RR'),'40',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3135','ESPOSITO UGO','LAWYER','1293',to_date('09-JUN-81','DD-MON-RR'),'783',null,'420');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3136','COZZA ALFONSO','MANAGER','1776',to_date('09-JUN-81','DD-MON-RR'),'1665',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3137','MANZONI UMBERTO','SUPERVISOR','528',to_date('09-JUN-81','DD-MON-RR'),'1518',null,'12');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3138','NERI ALFONSO','SUPERVISOR','297',to_date('09-JUN-81','DD-MON-RR'),'1796',null,'394');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3139','ESPOSITO DONATO','HEADMASTER','2430',to_date('09-JUN-81','DD-MON-RR'),'523',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3140','TIBALDI ANTONIO','HEADMASTER','1704',to_date('09-JUN-81','DD-MON-RR'),'93',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3141','TIBALDI DONATO','PROFESSOR','1146',to_date('09-JUN-81','DD-MON-RR'),'1506',null,'355');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3142','MANZONI ANGELO','LAWYER','2097',to_date('09-JUN-81','DD-MON-RR'),'1266',null,'155');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3143','MANZONI MARIA','LAWYER','1308',to_date('09-JUN-81','DD-MON-RR'),'1283',null,'168');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3144','COZZA ELIO','ENGINEER','2069',to_date('09-JUN-81','DD-MON-RR'),'407',null,'386');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3145','CARBONE DONATO','MANAGER','1910',to_date('09-JUN-81','DD-MON-RR'),'1323',null,'226');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3146','SANTE GIOVANNI','SUPERVISOR','1113',to_date('09-JUN-81','DD-MON-RR'),'822',null,'196');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3147','CARBONE PASQUALE','HEADMASTER','1941',to_date('09-JUN-81','DD-MON-RR'),'578',null,'245');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3148','MANZONI IVANO','HEADMASTER','1151',to_date('09-JUN-81','DD-MON-RR'),'796',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3149','TIBALDI FEDERICO','HEADMASTER','671',to_date('09-JUN-81','DD-MON-RR'),'523',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3150','CORONA UGO','MANAGER','1235',to_date('09-JUN-81','DD-MON-RR'),'2',null,'46');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3151','TIBALDI UGO','LAWYER','1528',to_date('09-JUN-81','DD-MON-RR'),'1659',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3152','TIBALDI UGO','ENGINEER','2318',to_date('09-JUN-81','DD-MON-RR'),'1024',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3153','LEOPARDI COSIMO','PROFESSOR','832',to_date('09-JUN-81','DD-MON-RR'),'1609',null,'421');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3154','DANTE MARIO','TECHNICIAN','165',to_date('09-JUN-81','DD-MON-RR'),'1441',null,'354');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3155','PETRARCA ANDREA','MANAGER','2513',to_date('09-JUN-81','DD-MON-RR'),'197',null,'51');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3156','LEVI DONATO','LAWYER','93',to_date('09-JUN-81','DD-MON-RR'),'858',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3157','NERI IVANO','LAWYER','2378',to_date('09-JUN-81','DD-MON-RR'),'85',null,'407');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3158','CARBONE MASSIMO','LAWYER','2083',to_date('09-JUN-81','DD-MON-RR'),'1065',null,'30');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3159','LEVI DONATO','MANAGER','2997',to_date('09-JUN-81','DD-MON-RR'),'1057',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3160','BIANCHI PAOLO','LAWYER','2399',to_date('09-JUN-81','DD-MON-RR'),'1381',null,'46');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3161','CORONA SILVIA','MANAGER','1394',to_date('09-JUN-81','DD-MON-RR'),'1220',null,'233');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3162','TIBALDI COSIMO','LAWYER','484',to_date('09-JUN-81','DD-MON-RR'),'1887',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3163','CALVINO LUDOVICO','ENGINEER','709',to_date('09-JUN-81','DD-MON-RR'),'1638',null,'309');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3164','SANTE GAETANO','TECHNICIAN','2694',to_date('09-JUN-81','DD-MON-RR'),'541',null,'311');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3165','CORONA ANTONIO','PHDSTUDENT','426',to_date('09-JUN-81','DD-MON-RR'),'1374',null,'104');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3166','CORONA MARIO','TECHNICIAN','841',to_date('09-JUN-81','DD-MON-RR'),'1980',null,'199');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3167','BIANCHI ANDREA','PHDSTUDENT','1605',to_date('09-JUN-81','DD-MON-RR'),'1986',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3168','LEVI ROBERTA','TECHNICIAN','1295',to_date('09-JUN-81','DD-MON-RR'),'373',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3169','DANTE GAETANO','LAWYER','387',to_date('09-JUN-81','DD-MON-RR'),'646',null,'52');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3170','DANTE FRANCESCO','ENGINEER','836',to_date('09-JUN-81','DD-MON-RR'),'1195',null,'359');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3171','GRIMALDI DONATO','TECHNICIAN','827',to_date('09-JUN-81','DD-MON-RR'),'183',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3172','LEOPARDI LUCA','TECHNICIAN','790',to_date('09-JUN-81','DD-MON-RR'),'662',null,'46');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3173','CORONA CLARA','SECRETARY','1509',to_date('09-JUN-81','DD-MON-RR'),'127',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3174','LEVI COSIMO','ENGINEER','2609',to_date('09-JUN-81','DD-MON-RR'),'427',null,'18');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3175','CORONA ROBERTA','MANAGER','3047',to_date('09-JUN-81','DD-MON-RR'),'447',null,'48');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3176','SANTE GAETANO','SUPERVISOR','3012',to_date('09-JUN-81','DD-MON-RR'),'1913',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3177','ESPOSITO LUIGI','PHDSTUDENT','976',to_date('09-JUN-81','DD-MON-RR'),'1731',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3178','NERI IVANO','ENGINEER','1447',to_date('09-JUN-81','DD-MON-RR'),'247',null,'444');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3179','PETRARCA ALFONSO','LAWYER','1307',to_date('09-JUN-81','DD-MON-RR'),'1868',null,'97');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3180','MANZONI COSIMO','HEADMASTER','3014',to_date('09-JUN-81','DD-MON-RR'),'1642',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3181','BIANCHI FRANCESCO','TECHNICIAN','3080',to_date('09-JUN-81','DD-MON-RR'),'898',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3182','CARBONE GIOVANNI','MANAGER','2618',to_date('09-JUN-81','DD-MON-RR'),'1929',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3183','BIANCHI DONATO','PROFESSOR','2609',to_date('09-JUN-81','DD-MON-RR'),'1640',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3184','GRIMALDI PAOLO','HEADMASTER','2197',to_date('09-JUN-81','DD-MON-RR'),'1858',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3185','CALVINO PASQUALE','LAWYER','123',to_date('09-JUN-81','DD-MON-RR'),'650',null,'6');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3186','CORONA MARIO','LAWYER','1559',to_date('09-JUN-81','DD-MON-RR'),'678',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3187','GRIMALDI ANGELO','HEADMASTER','527',to_date('09-JUN-81','DD-MON-RR'),'290',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3188','NERI ELENA','MANAGER','2669',to_date('09-JUN-81','DD-MON-RR'),'1917',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3189','BIANCHI SILVIA','TECHNICIAN','1649',to_date('09-JUN-81','DD-MON-RR'),'717',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5218','ESPOSITO PASQUALE','MANAGER','4688',to_date('09-JUN-81','DD-MON-RR'),'348',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5219','CORONA LUDOVICO','LAWYER','1671',to_date('09-JUN-81','DD-MON-RR'),'313',null,'87');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5220','FUMAROLA ELIO','SECRETARY','2934',to_date('09-JUN-81','DD-MON-RR'),'1124',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5221','CORONA UMBERTO','SECRETARY','1180',to_date('09-JUN-81','DD-MON-RR'),'1442',null,'475');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5222','BIANCHI ALFONSO','TECHNICIAN','1741',to_date('09-JUN-81','DD-MON-RR'),'1617',null,'280');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5223','SANTE FEDERICO','MANAGER','4806',to_date('09-JUN-81','DD-MON-RR'),'580',null,'45');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5224','TIBALDI ANTONIO','PROFESSOR','3242',to_date('09-JUN-81','DD-MON-RR'),'1963',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5225','CARBONE CLARA','PROFESSOR','724',to_date('09-JUN-81','DD-MON-RR'),'385',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5226','CORONA ELENA','SUPERVISOR','410',to_date('09-JUN-81','DD-MON-RR'),'1384',null,'87');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5227','CORONA ELIO','MANAGER','791',to_date('09-JUN-81','DD-MON-RR'),'190',null,'20');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5228','TIBALDI MARIO','PHDSTUDENT','3285',to_date('09-JUN-81','DD-MON-RR'),'1652',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5229','LEOPARDI COSIMO','TECHNICIAN','4445',to_date('09-JUN-81','DD-MON-RR'),'711',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5230','FUMAROLA MASSIMO','PHDSTUDENT','3938',to_date('09-JUN-81','DD-MON-RR'),'579',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5231','ESPOSITO ANGELO','MANAGER','2008',to_date('09-JUN-81','DD-MON-RR'),'1316',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5232','SANTE ANGELO','ENGINEER','4134',to_date('09-JUN-81','DD-MON-RR'),'1677',null,'101');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5233','NERI ANTONIO','SUPERVISOR','1375',to_date('09-JUN-81','DD-MON-RR'),'358',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5234','COZZA ANGELO','ENGINEER','1934',to_date('09-JUN-81','DD-MON-RR'),'1497',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5235','PETRARCA FRANCESCO','SUPERVISOR','3831',to_date('09-JUN-81','DD-MON-RR'),'1278',null,'233');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5236','NERI GAETANO','PHDSTUDENT','3013',to_date('09-JUN-81','DD-MON-RR'),'1908',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5237','LEVI ANTONIO','ENGINEER','164',to_date('09-JUN-81','DD-MON-RR'),'605',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5238','DANTE ANGELO','MANAGER','1806',to_date('09-JUN-81','DD-MON-RR'),'793',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5239','SANTE MARIO','PHDSTUDENT','4983',to_date('09-JUN-81','DD-MON-RR'),'1503',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5240','CORONA GAETANO','TECHNICIAN','810',to_date('09-JUN-81','DD-MON-RR'),'438',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5241','CORONA LUCA','TECHNICIAN','3501',to_date('09-JUN-81','DD-MON-RR'),'1430',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5242','CALVINO PASQUALE','MANAGER','4009',to_date('09-JUN-81','DD-MON-RR'),'1338',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5243','FO ANDREA','PROFESSOR','4077',to_date('09-JUN-81','DD-MON-RR'),'498',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5244','TIBALDI ANTONIO','LAWYER','3133',to_date('09-JUN-81','DD-MON-RR'),'962',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5245','NERI DAMIANO','TECHNICIAN','3667',to_date('09-JUN-81','DD-MON-RR'),'1227',null,'421');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5246','LEOPARDI GAETANO','SECRETARY','2812',to_date('09-JUN-81','DD-MON-RR'),'1806',null,'348');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5247','FUMAROLA SILVIA','PHDSTUDENT','1908',to_date('09-JUN-81','DD-MON-RR'),'81',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5248','NERI MARIO','MANAGER','2326',to_date('09-JUN-81','DD-MON-RR'),'1628',null,'79');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5249','CARBONE ALFONSO','PHDSTUDENT','4363',to_date('09-JUN-81','DD-MON-RR'),'300',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5250','FO FRANCESCO','HEADMASTER','3107',to_date('09-JUN-81','DD-MON-RR'),'108',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5251','PETRARCA MARIO','PROFESSOR','2192',to_date('09-JUN-81','DD-MON-RR'),'846',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5252','FUMAROLA LUIGI','LAWYER','2369',to_date('09-JUN-81','DD-MON-RR'),'1960',null,'348');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5253','DANTE UMBERTO','MANAGER','1921',to_date('09-JUN-81','DD-MON-RR'),'520',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5254','FO PAOLO','SUPERVISOR','1123',to_date('09-JUN-81','DD-MON-RR'),'1075',null,'125');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5255','CORONA FRANCESCO','PROFESSOR','70',to_date('09-JUN-81','DD-MON-RR'),'195',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5256','NERI ELIO','HEADMASTER','3858',to_date('09-JUN-81','DD-MON-RR'),'1900',null,'485');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5257','FO ELIO','HEADMASTER','4057',to_date('09-JUN-81','DD-MON-RR'),'1033',null,'284');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5258','LEOPARDI ALFONSO','PROFESSOR','1069',to_date('09-JUN-81','DD-MON-RR'),'677',null,'322');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5259','LEVI DONATO','ENGINEER','4483',to_date('09-JUN-81','DD-MON-RR'),'154',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5260','ESPOSITO FRANCESCO','PROFESSOR','3733',to_date('09-JUN-81','DD-MON-RR'),'949',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5261','CARBONE IVANO','TECHNICIAN','4830',to_date('09-JUN-81','DD-MON-RR'),'930',null,'488');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5262','COZZA GIOVANNI','ENGINEER','2508',to_date('09-JUN-81','DD-MON-RR'),'704',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5263','CARBONE GIOVANNI','MANAGER','2262',to_date('09-JUN-81','DD-MON-RR'),'49',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5264','GRIMALDI GIOVANNI','PHDSTUDENT','2249',to_date('09-JUN-81','DD-MON-RR'),'1257',null,'405');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5265','SANTE PAOLO','ENGINEER','3756',to_date('09-JUN-81','DD-MON-RR'),'884',null,'373');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5266','FUMAROLA ELENA','SUPERVISOR','1231',to_date('09-JUN-81','DD-MON-RR'),'1461',null,'471');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5267','MANZONI UMBERTO','MANAGER','1330',to_date('09-JUN-81','DD-MON-RR'),'193',null,'437');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5268','ECO GAETANO','MANAGER','1808',to_date('09-JUN-81','DD-MON-RR'),'1142',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5269','CARBONE DONATO','SECRETARY','4993',to_date('09-JUN-81','DD-MON-RR'),'147',null,'63');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5270','LEVI MARIO','LAWYER','166',to_date('09-JUN-81','DD-MON-RR'),'209',null,'151');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5271','TIBALDI UGO','LAWYER','1356',to_date('09-JUN-81','DD-MON-RR'),'1092',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5272','LEVI LUCA','SUPERVISOR','3819',to_date('09-JUN-81','DD-MON-RR'),'18',null,'281');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5273','SANTE ANDREA','HEADMASTER','1567',to_date('09-JUN-81','DD-MON-RR'),'328',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5274','DANTE ELENA','SECRETARY','2730',to_date('09-JUN-81','DD-MON-RR'),'651',null,'497');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5275','MANZONI LUDOVICO','ENGINEER','2663',to_date('09-JUN-81','DD-MON-RR'),'232',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5276','ECO MARIO','MANAGER','4865',to_date('09-JUN-81','DD-MON-RR'),'304',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5277','FUMAROLA ANTONIO','MANAGER','1235',to_date('09-JUN-81','DD-MON-RR'),'155',null,'58');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5278','MANZONI LUCIA','HEADMASTER','2642',to_date('09-JUN-81','DD-MON-RR'),'1950',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5279','LEOPARDI ANDREA','PROFESSOR','3684',to_date('09-JUN-81','DD-MON-RR'),'1024',null,'402');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5280','ESPOSITO ALFONSO','LAWYER','428',to_date('09-JUN-81','DD-MON-RR'),'1324',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5281','NERI FEDERICO','MANAGER','1995',to_date('09-JUN-81','DD-MON-RR'),'783',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5282','CORONA FEDERICO','SUPERVISOR','4413',to_date('09-JUN-81','DD-MON-RR'),'787',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5283','CALVINO FRANCESCO','PHDSTUDENT','4696',to_date('09-JUN-81','DD-MON-RR'),'1382',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5284','PETRARCA ANDREA','ENGINEER','2479',to_date('09-JUN-81','DD-MON-RR'),'330',null,'322');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5285','MANZONI ROBERTA','MANAGER','862',to_date('09-JUN-81','DD-MON-RR'),'1880',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5286','BIANCHI UGO','TECHNICIAN','367',to_date('09-JUN-81','DD-MON-RR'),'1783',null,'162');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5287','ESPOSITO ELENA','SUPERVISOR','2796',to_date('09-JUN-81','DD-MON-RR'),'912',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5288','PETRARCA LUCA','ENGINEER','925',to_date('09-JUN-81','DD-MON-RR'),'594',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5289','CALVINO GIOVANNI','MANAGER','2349',to_date('09-JUN-81','DD-MON-RR'),'1512',null,'197');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5290','LEVI MARIO','PROFESSOR','4709',to_date('09-JUN-81','DD-MON-RR'),'386',null,'97');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5291','FO ANTONIO','PROFESSOR','1524',to_date('09-JUN-81','DD-MON-RR'),'863',null,'299');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5292','PETRARCA PASQUALE','MANAGER','525',to_date('09-JUN-81','DD-MON-RR'),'166',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5293','CARBONE ANDREA','SECRETARY','260',to_date('09-JUN-81','DD-MON-RR'),'542',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5294','CARBONE GAETANO','LAWYER','210',to_date('09-JUN-81','DD-MON-RR'),'55',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5295','SANTE MASSIMO','ENGINEER','3642',to_date('09-JUN-81','DD-MON-RR'),'12',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5296','ECO COSIMO','SECRETARY','3125',to_date('09-JUN-81','DD-MON-RR'),'1297',null,'221');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5297','FO ANTONIO','LAWYER','2173',to_date('09-JUN-81','DD-MON-RR'),'723',null,'39');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5298','MANZONI ELIO','PROFESSOR','905',to_date('09-JUN-81','DD-MON-RR'),'779',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5299','BIANCHI MARIO','SUPERVISOR','1169',to_date('09-JUN-81','DD-MON-RR'),'481',null,'28');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5300','CARBONE DONATO','SUPERVISOR','533',to_date('09-JUN-81','DD-MON-RR'),'725',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5301','BIANCHI PASQUALE','PROFESSOR','4027',to_date('09-JUN-81','DD-MON-RR'),'1669',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5302','NERI PASQUALE','PHDSTUDENT','1054',to_date('09-JUN-81','DD-MON-RR'),'870',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5303','ESPOSITO ANTONIO','PHDSTUDENT','2409',to_date('09-JUN-81','DD-MON-RR'),'1386',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5304','ECO IVANO','SUPERVISOR','4939',to_date('09-JUN-81','DD-MON-RR'),'932',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5305','LEOPARDI DAMIANO','TECHNICIAN','864',to_date('09-JUN-81','DD-MON-RR'),'424',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5306','NERI ELIO','LAWYER','4689',to_date('09-JUN-81','DD-MON-RR'),'1442',null,'51');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5307','SANTE IVANO','PHDSTUDENT','2787',to_date('09-JUN-81','DD-MON-RR'),'244',null,'281');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5308','CALVINO GIOVANNI','PHDSTUDENT','2620',to_date('09-JUN-81','DD-MON-RR'),'1710',null,'389');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5309','TIBALDI IVANO','PHDSTUDENT','4160',to_date('09-JUN-81','DD-MON-RR'),'1374',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5310','ESPOSITO FEDERICO','MANAGER','2284',to_date('09-JUN-81','DD-MON-RR'),'1678',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5311','DANTE ELENA','SECRETARY','3832',to_date('09-JUN-81','DD-MON-RR'),'132',null,'248');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5312','LEVI MARIO','MANAGER','5060',to_date('09-JUN-81','DD-MON-RR'),'1329',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5313','FUMAROLA SILVIA','SUPERVISOR','3194',to_date('09-JUN-81','DD-MON-RR'),'995',null,'398');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5314','COZZA COSIMO','MANAGER','2143',to_date('09-JUN-81','DD-MON-RR'),'639',null,'120');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5315','TIBALDI UGO','SUPERVISOR','2627',to_date('09-JUN-81','DD-MON-RR'),'1039',null,'378');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5316','LEOPARDI GIOVANNI','TECHNICIAN','441',to_date('09-JUN-81','DD-MON-RR'),'1389',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5317','CORONA PAOLO','TECHNICIAN','5311',to_date('09-JUN-81','DD-MON-RR'),'944',null,'405');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5318','ECO UMBERTO','SUPERVISOR','2572',to_date('09-JUN-81','DD-MON-RR'),'1179',null,'155');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5319','ESPOSITO COSIMO','HEADMASTER','4444',to_date('09-JUN-81','DD-MON-RR'),'745',null,'83');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5320','NERI ANTONIO','LAWYER','5293',to_date('09-JUN-81','DD-MON-RR'),'1520',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5321','COZZA ELIO','TECHNICIAN','3683',to_date('09-JUN-81','DD-MON-RR'),'302',null,'222');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5322','TIBALDI MASSIMO','PROFESSOR','4489',to_date('09-JUN-81','DD-MON-RR'),'1459',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5323','TIBALDI DAMIANO','LAWYER','2489',to_date('09-JUN-81','DD-MON-RR'),'1508',null,'6');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5324','BIANCHI PASQUALE','LAWYER','3335',to_date('09-JUN-81','DD-MON-RR'),'1743',null,'177');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5788','MANZONI ANTONIO','MANAGER','1622',to_date('09-JUN-81','DD-MON-RR'),'1780',null,'110');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5789','NERI LUCIA','MANAGER','1701',to_date('09-JUN-81','DD-MON-RR'),'596',null,'308');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5790','CORONA LUCIA','SECRETARY','930',to_date('09-JUN-81','DD-MON-RR'),'310',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5791','CARBONE MASSIMO','PROFESSOR','4488',to_date('09-JUN-81','DD-MON-RR'),'824',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5792','BIANCHI MASSIMO','PHDSTUDENT','233',to_date('09-JUN-81','DD-MON-RR'),'1974',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5793','COZZA PASQUALE','HEADMASTER','741',to_date('09-JUN-81','DD-MON-RR'),'285',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5794','LEVI LUIGI','PHDSTUDENT','1628',to_date('09-JUN-81','DD-MON-RR'),'454',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5795','SANTE CLARA','ENGINEER','2060',to_date('09-JUN-81','DD-MON-RR'),'1657',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5796','FUMAROLA ANTONIO','LAWYER','4695',to_date('09-JUN-81','DD-MON-RR'),'1639',null,'325');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5797','CALVINO GAETANO','ENGINEER','2850',to_date('09-JUN-81','DD-MON-RR'),'562',null,'484');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5798','CORONA DAMIANO','PROFESSOR','4919',to_date('09-JUN-81','DD-MON-RR'),'230',null,'486');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5799','GRIMALDI GAETANO','LAWYER','3350',to_date('09-JUN-81','DD-MON-RR'),'1492',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5800','ESPOSITO ANTONIO','ENGINEER','4928',to_date('09-JUN-81','DD-MON-RR'),'1997',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5801','CALVINO FRANCESCO','ENGINEER','2716',to_date('09-JUN-81','DD-MON-RR'),'1206',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5802','PETRARCA ALFONSO','MANAGER','582',to_date('09-JUN-81','DD-MON-RR'),'1854',null,'8');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5803','ECO LUCA','TECHNICIAN','5215',to_date('09-JUN-81','DD-MON-RR'),'1069',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5804','PETRARCA ANGELO','ENGINEER','4515',to_date('09-JUN-81','DD-MON-RR'),'1881',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5805','CALVINO MASSIMO','PHDSTUDENT','4137',to_date('09-JUN-81','DD-MON-RR'),'832',null,'486');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5806','GRIMALDI UGO','PROFESSOR','99',to_date('09-JUN-81','DD-MON-RR'),'227',null,'184');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5807','DANTE UGO','SUPERVISOR','1434',to_date('09-JUN-81','DD-MON-RR'),'667',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5808','MANZONI FEDERICO','PHDSTUDENT','1554',to_date('09-JUN-81','DD-MON-RR'),'601',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5809','CORONA FRANCESCO','ENGINEER','5643',to_date('09-JUN-81','DD-MON-RR'),'1901',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5810','CORONA LUIGI','PHDSTUDENT','1601',to_date('09-JUN-81','DD-MON-RR'),'1149',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5811','PETRARCA MARIO','SECRETARY','80',to_date('09-JUN-81','DD-MON-RR'),'1869',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5812','DANTE DAMIANO','MANAGER','1088',to_date('09-JUN-81','DD-MON-RR'),'1386',null,'283');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5813','CARBONE FEDERICO','PHDSTUDENT','1963',to_date('09-JUN-81','DD-MON-RR'),'448',null,'134');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5814','LEOPARDI LUDOVICO','SECRETARY','3528',to_date('09-JUN-81','DD-MON-RR'),'1165',null,'196');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5815','DANTE ANGELO','SECRETARY','3999',to_date('09-JUN-81','DD-MON-RR'),'320',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7249','SANTE ANDREA','SECRETARY','7068',to_date('09-JUN-81','DD-MON-RR'),'1800',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7250','LEOPARDI LUIGI','SUPERVISOR','1790',to_date('09-JUN-81','DD-MON-RR'),'1689',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7251','ECO LUCA','PHDSTUDENT','2392',to_date('09-JUN-81','DD-MON-RR'),'537',null,'474');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7252','ECO CLARA','TECHNICIAN','5030',to_date('09-JUN-81','DD-MON-RR'),'686',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7253','LEOPARDI ANGELO','LAWYER','5514',to_date('09-JUN-81','DD-MON-RR'),'798',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7254','GRIMALDI MASSIMO','MANAGER','2396',to_date('09-JUN-81','DD-MON-RR'),'1350',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7255','TIBALDI COSIMO','TECHNICIAN','6209',to_date('09-JUN-81','DD-MON-RR'),'849',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7256','NERI LUCIA','ENGINEER','5455',to_date('09-JUN-81','DD-MON-RR'),'141',null,'199');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7257','LEVI LUDOVICO','SUPERVISOR','2795',to_date('09-JUN-81','DD-MON-RR'),'457',null,'421');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7258','ESPOSITO CLARA','ENGINEER','5599',to_date('09-JUN-81','DD-MON-RR'),'192',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7259','LEOPARDI ROBERTA','SECRETARY','4394',to_date('09-JUN-81','DD-MON-RR'),'1513',null,'177');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7260','DANTE FEDERICO','PROFESSOR','602',to_date('09-JUN-81','DD-MON-RR'),'1375',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7261','NERI GAETANO','ENGINEER','145',to_date('09-JUN-81','DD-MON-RR'),'1549',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7262','COZZA ELIO','ENGINEER','6664',to_date('09-JUN-81','DD-MON-RR'),'1720',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7263','COZZA FEDERICO','MANAGER','2469',to_date('09-JUN-81','DD-MON-RR'),'850',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7264','PETRARCA SILVIA','MANAGER','7251',to_date('09-JUN-81','DD-MON-RR'),'42',null,'74');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7265','FO MARIO','HEADMASTER','6427',to_date('09-JUN-81','DD-MON-RR'),'448',null,'333');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7266','CARBONE UMBERTO','PHDSTUDENT','3917',to_date('09-JUN-81','DD-MON-RR'),'269',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7267','LEOPARDI GIOVANNI','PROFESSOR','4438',to_date('09-JUN-81','DD-MON-RR'),'941',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7268','MANZONI UGO','MANAGER','80',to_date('09-JUN-81','DD-MON-RR'),'1142',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7269','TIBALDI ELENA','HEADMASTER','2668',to_date('09-JUN-81','DD-MON-RR'),'1777',null,'158');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7270','CALVINO PASQUALE','MANAGER','3601',to_date('09-JUN-81','DD-MON-RR'),'252',null,'341');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7271','COZZA SILVIA','MANAGER','6207',to_date('09-JUN-81','DD-MON-RR'),'1013',null,'465');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7272','CORONA GIOVANNI','MANAGER','1882',to_date('09-JUN-81','DD-MON-RR'),'849',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7273','MANZONI LUCA','PHDSTUDENT','3729',to_date('09-JUN-81','DD-MON-RR'),'1157',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7274','LEOPARDI UGO','HEADMASTER','4997',to_date('09-JUN-81','DD-MON-RR'),'1843',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7275','BIANCHI MARIO','HEADMASTER','3356',to_date('09-JUN-81','DD-MON-RR'),'1864',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7276','LEOPARDI PAOLO','PROFESSOR','6845',to_date('09-JUN-81','DD-MON-RR'),'1898',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7277','CORONA COSIMO','MANAGER','2604',to_date('09-JUN-81','DD-MON-RR'),'1053',null,'309');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7278','PETRARCA FEDERICO','MANAGER','3650',to_date('09-JUN-81','DD-MON-RR'),'197',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7279','LEOPARDI IVANO','TECHNICIAN','6616',to_date('09-JUN-81','DD-MON-RR'),'355',null,'120');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7280','BIANCHI DONATO','ENGINEER','1641',to_date('09-JUN-81','DD-MON-RR'),'1285',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7281','DANTE LUIGI','PROFESSOR','21',to_date('09-JUN-81','DD-MON-RR'),'1454',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7282','FUMAROLA UGO','SECRETARY','4189',to_date('09-JUN-81','DD-MON-RR'),'1915',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7283','LEOPARDI FEDERICO','LAWYER','2763',to_date('09-JUN-81','DD-MON-RR'),'1547',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7284','DANTE COSIMO','PROFESSOR','3377',to_date('09-JUN-81','DD-MON-RR'),'1885',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7285','MANZONI IVANO','SECRETARY','2791',to_date('09-JUN-81','DD-MON-RR'),'1229',null,'313');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7286','PETRARCA GAETANO','MANAGER','5102',to_date('09-JUN-81','DD-MON-RR'),'1496',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7287','CORONA MASSIMO','ENGINEER','2040',to_date('09-JUN-81','DD-MON-RR'),'1411',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7288','FO COSIMO','HEADMASTER','5596',to_date('09-JUN-81','DD-MON-RR'),'557',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7289','FO DONATO','LAWYER','3860',to_date('09-JUN-81','DD-MON-RR'),'1773',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7290','FUMAROLA MASSIMO','TECHNICIAN','2323',to_date('09-JUN-81','DD-MON-RR'),'1949',null,'362');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7291','CORONA LUDOVICO','PROFESSOR','2629',to_date('09-JUN-81','DD-MON-RR'),'1337',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7292','MANZONI LUCA','MANAGER','1771',to_date('09-JUN-81','DD-MON-RR'),'609',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7293','ECO MASSIMO','SECRETARY','6658',to_date('09-JUN-81','DD-MON-RR'),'1607',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7294','LEOPARDI LUDOVICO','PHDSTUDENT','3181',to_date('09-JUN-81','DD-MON-RR'),'474',null,'271');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7295','ECO ELIO','SECRETARY','1955',to_date('09-JUN-81','DD-MON-RR'),'1778',null,'54');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7296','MANZONI MARIA','SECRETARY','3389',to_date('09-JUN-81','DD-MON-RR'),'393',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7297','NERI ELENA','SECRETARY','242',to_date('09-JUN-81','DD-MON-RR'),'1882',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7298','NERI DAMIANO','MANAGER','311',to_date('09-JUN-81','DD-MON-RR'),'1592',null,'457');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7299','NERI SILVIA','MANAGER','6797',to_date('09-JUN-81','DD-MON-RR'),'1780',null,'429');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7300','PETRARCA ELENA','MANAGER','4433',to_date('09-JUN-81','DD-MON-RR'),'631',null,'159');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7301','FUMAROLA PAOLO','HEADMASTER','5784',to_date('09-JUN-81','DD-MON-RR'),'1548',null,'176');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7302','CORONA CLARA','SECRETARY','2248',to_date('09-JUN-81','DD-MON-RR'),'981',null,'496');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7303','LEOPARDI ROBERTA','SUPERVISOR','3610',to_date('09-JUN-81','DD-MON-RR'),'1244',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7304','CARBONE MARIA','HEADMASTER','234',to_date('09-JUN-81','DD-MON-RR'),'1657',null,'8');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7305','LEVI MARIA','LAWYER','2350',to_date('09-JUN-81','DD-MON-RR'),'1819',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7306','LEOPARDI ANGELO','LAWYER','5821',to_date('09-JUN-81','DD-MON-RR'),'835',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7307','ECO UGO','MANAGER','1457',to_date('09-JUN-81','DD-MON-RR'),'526',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7308','CORONA CLARA','MANAGER','490',to_date('09-JUN-81','DD-MON-RR'),'281',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7309','CALVINO MARIO','MANAGER','6324',to_date('09-JUN-81','DD-MON-RR'),'1165',null,'170');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7310','LEVI LUDOVICO','HEADMASTER','6916',to_date('09-JUN-81','DD-MON-RR'),'1591',null,'276');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7311','CORONA DONATO','MANAGER','118',to_date('09-JUN-81','DD-MON-RR'),'467',null,'298');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7312','DANTE LUCA','TECHNICIAN','2937',to_date('09-JUN-81','DD-MON-RR'),'1164',null,'407');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7313','FO UMBERTO','SUPERVISOR','5896',to_date('09-JUN-81','DD-MON-RR'),'1682',null,'301');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7314','ECO IVANO','SECRETARY','6814',to_date('09-JUN-81','DD-MON-RR'),'891',null,'367');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7315','PETRARCA LUIGI','HEADMASTER','6696',to_date('09-JUN-81','DD-MON-RR'),'547',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7316','BIANCHI DAMIANO','LAWYER','4734',to_date('09-JUN-81','DD-MON-RR'),'1232',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7317','FUMAROLA PASQUALE','MANAGER','5817',to_date('09-JUN-81','DD-MON-RR'),'996',null,'321');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7783','CALVINO PAOLO','LAWYER','2593',to_date('09-JUN-81','DD-MON-RR'),'1571',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7784','BIANCHI IVANO','SECRETARY','7647',to_date('09-JUN-81','DD-MON-RR'),'249',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7785','ECO COSIMO','PROFESSOR','3014',to_date('09-JUN-81','DD-MON-RR'),'1994',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7786','GRIMALDI LUCIA','SECRETARY','878',to_date('09-JUN-81','DD-MON-RR'),'1791',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7787','FUMAROLA DAMIANO','SUPERVISOR','857',to_date('09-JUN-81','DD-MON-RR'),'340',null,'105');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7788','NERI ROBERTA','MANAGER','6480',to_date('09-JUN-81','DD-MON-RR'),'704',null,'304');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7789','ESPOSITO CLARA','TECHNICIAN','4640',to_date('09-JUN-81','DD-MON-RR'),'787',null,'184');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7790','PETRARCA FRANCESCO','PHDSTUDENT','5899',to_date('09-JUN-81','DD-MON-RR'),'38',null,'488');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7791','LEOPARDI FEDERICO','PROFESSOR','6964',to_date('09-JUN-81','DD-MON-RR'),'1143',null,'426');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7792','ESPOSITO ANTONIO','LAWYER','7399',to_date('09-JUN-81','DD-MON-RR'),'1003',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7793','CARBONE ANGELO','PROFESSOR','7681',to_date('09-JUN-81','DD-MON-RR'),'1924',null,'46');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7794','PETRARCA SILVIA','SECRETARY','6542',to_date('09-JUN-81','DD-MON-RR'),'1314',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7795','FUMAROLA LUCIA','SECRETARY','1462',to_date('09-JUN-81','DD-MON-RR'),'18',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7796','NERI ELENA','TECHNICIAN','952',to_date('09-JUN-81','DD-MON-RR'),'1806',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7797','LEVI LUDOVICO','ENGINEER','4102',to_date('09-JUN-81','DD-MON-RR'),'947',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7798','CARBONE ANTONIO','MANAGER','7699',to_date('09-JUN-81','DD-MON-RR'),'1241',null,'282');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7799','FO COSIMO','MANAGER','4551',to_date('09-JUN-81','DD-MON-RR'),'111',null,'142');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7800','DANTE ANTONIO','SUPERVISOR','83',to_date('09-JUN-81','DD-MON-RR'),'902',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7801','SANTE SILVIA','SECRETARY','4430',to_date('09-JUN-81','DD-MON-RR'),'1475',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7802','ESPOSITO ROBERTA','PROFESSOR','936',to_date('09-JUN-81','DD-MON-RR'),'478',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7803','BIANCHI ANGELO','PROFESSOR','1541',to_date('09-JUN-81','DD-MON-RR'),'948',null,'355');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7804','LEVI LUCIA','PROFESSOR','3047',to_date('09-JUN-81','DD-MON-RR'),'275',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7805','PETRARCA SILVIA','PHDSTUDENT','1647',to_date('09-JUN-81','DD-MON-RR'),'1258',null,'348');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7806','CARBONE CLARA','SUPERVISOR','2426',to_date('09-JUN-81','DD-MON-RR'),'1514',null,'25');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7807','GRIMALDI DAMIANO','ENGINEER','5857',to_date('09-JUN-81','DD-MON-RR'),'50',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7808','FO LUDOVICO','SECRETARY','2307',to_date('09-JUN-81','DD-MON-RR'),'1632',null,'481');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7809','FO GAETANO','MANAGER','7285',to_date('09-JUN-81','DD-MON-RR'),'1940',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7810','FO CLARA','LAWYER','1257',to_date('09-JUN-81','DD-MON-RR'),'1712',null,'451');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7811','LEVI LUIGI','MANAGER','1332',to_date('09-JUN-81','DD-MON-RR'),'1846',null,'424');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7812','COZZA ELENA','PHDSTUDENT','7690',to_date('09-JUN-81','DD-MON-RR'),'884',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7813','CARBONE ELIO','LAWYER','3728',to_date('09-JUN-81','DD-MON-RR'),'1886',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7814','NERI ANTONIO','LAWYER','7492',to_date('09-JUN-81','DD-MON-RR'),'1764',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7815','BIANCHI FRANCESCO','MANAGER','6945',to_date('09-JUN-81','DD-MON-RR'),'1917',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7816','CORONA ALFONSO','MANAGER','6919',to_date('09-JUN-81','DD-MON-RR'),'1974',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7817','CARBONE DAMIANO','PROFESSOR','3831',to_date('09-JUN-81','DD-MON-RR'),'384',null,'468');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7818','CORONA GAETANO','MANAGER','5230',to_date('09-JUN-81','DD-MON-RR'),'1314',null,'264');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7819','FUMAROLA COSIMO','LAWYER','5313',to_date('09-JUN-81','DD-MON-RR'),'114',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7820','ECO ANTONIO','PROFESSOR','6692',to_date('09-JUN-81','DD-MON-RR'),'1120',null,'58');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7821','FUMAROLA MARIA','SECRETARY','21',to_date('09-JUN-81','DD-MON-RR'),'476',null,'459');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7822','LEVI GAETANO','SUPERVISOR','2356',to_date('09-JUN-81','DD-MON-RR'),'926',null,'160');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7823','COZZA ELENA','TECHNICIAN','6444',to_date('09-JUN-81','DD-MON-RR'),'805',null,'78');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7824','MANZONI ANTONIO','SECRETARY','6492',to_date('09-JUN-81','DD-MON-RR'),'1933',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7825','CARBONE FEDERICO','HEADMASTER','2719',to_date('09-JUN-81','DD-MON-RR'),'534',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7826','ESPOSITO LUDOVICO','MANAGER','3103',to_date('09-JUN-81','DD-MON-RR'),'786',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7827','TIBALDI LUCIA','MANAGER','3478',to_date('09-JUN-81','DD-MON-RR'),'1000',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7828','MANZONI ANGELO','MANAGER','2073',to_date('09-JUN-81','DD-MON-RR'),'1125',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7829','CORONA LUDOVICO','ENGINEER','5304',to_date('09-JUN-81','DD-MON-RR'),'1489',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7830','COZZA PAOLO','ENGINEER','7625',to_date('09-JUN-81','DD-MON-RR'),'564',null,'320');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7831','ECO FEDERICO','MANAGER','3249',to_date('09-JUN-81','DD-MON-RR'),'284',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7832','PETRARCA GAETANO','TECHNICIAN','5154',to_date('09-JUN-81','DD-MON-RR'),'1806',null,'61');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7833','MANZONI LUCIA','MANAGER','4189',to_date('09-JUN-81','DD-MON-RR'),'1865',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7834','CARBONE GAETANO','TECHNICIAN','1858',to_date('09-JUN-81','DD-MON-RR'),'65',null,'42');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7835','PETRARCA FEDERICO','ENGINEER','4474',to_date('09-JUN-81','DD-MON-RR'),'1992',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7836','DANTE IVANO','SECRETARY','1894',to_date('09-JUN-81','DD-MON-RR'),'1858',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7837','PETRARCA FRANCESCO','PHDSTUDENT','2259',to_date('09-JUN-81','DD-MON-RR'),'274',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7838','CARBONE ELENA','MANAGER','2145',to_date('09-JUN-81','DD-MON-RR'),'1803',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7839','PETRARCA LUIGI','PROFESSOR','301',to_date('09-JUN-81','DD-MON-RR'),'763',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7840','LEOPARDI GAETANO','TECHNICIAN','1113',to_date('09-JUN-81','DD-MON-RR'),'302',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7841','ESPOSITO LUCIA','HEADMASTER','3846',to_date('09-JUN-81','DD-MON-RR'),'1208',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7842','CORONA ANTONIO','LAWYER','2577',to_date('09-JUN-81','DD-MON-RR'),'1116',null,'309');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7843','ESPOSITO ANDREA','ENGINEER','785',to_date('09-JUN-81','DD-MON-RR'),'486',null,'444');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7844','CORONA MARIA','MANAGER','5964',to_date('09-JUN-81','DD-MON-RR'),'1960',null,'207');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7845','SANTE DONATO','PHDSTUDENT','6771',to_date('09-JUN-81','DD-MON-RR'),'490',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7846','FO ANGELO','SUPERVISOR','3891',to_date('09-JUN-81','DD-MON-RR'),'358',null,'56');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7847','CORONA SILVIA','SUPERVISOR','7700',to_date('09-JUN-81','DD-MON-RR'),'376',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7848','BIANCHI LUIGI','TECHNICIAN','4612',to_date('09-JUN-81','DD-MON-RR'),'337',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7318','TIBALDI DONATO','PHDSTUDENT','524',to_date('09-JUN-81','DD-MON-RR'),'237',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1158','FUMAROLA SILVIA','PROFESSOR','809',to_date('09-JUN-81','DD-MON-RR'),'1377',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1159','NERI IVANO','MANAGER','680',to_date('09-JUN-81','DD-MON-RR'),'1681',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1160','LEOPARDI ALFONSO','TECHNICIAN','374',to_date('09-JUN-81','DD-MON-RR'),'326',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1161','LEVI SILVIA','MANAGER','447',to_date('09-JUN-81','DD-MON-RR'),'807',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1162','FO GIOVANNI','PHDSTUDENT','947',to_date('09-JUN-81','DD-MON-RR'),'801',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1163','MANZONI ALFONSO','PROFESSOR','427',to_date('09-JUN-81','DD-MON-RR'),'1540',null,'62');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1164','ECO DAMIANO','MANAGER','588',to_date('09-JUN-81','DD-MON-RR'),'1573',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1165','PETRARCA MARIA','SECRETARY','54',to_date('09-JUN-81','DD-MON-RR'),'1119',null,'207');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1166','ECO MASSIMO','SECRETARY','995',to_date('09-JUN-81','DD-MON-RR'),'1707',null,'222');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1167','ECO GIOVANNI','SECRETARY','1145',to_date('09-JUN-81','DD-MON-RR'),'1091',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1168','TIBALDI CLARA','TECHNICIAN','121',to_date('09-JUN-81','DD-MON-RR'),'828',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1169','FO ANTONIO','TECHNICIAN','765',to_date('09-JUN-81','DD-MON-RR'),'1399',null,'43');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1170','DANTE UGO','MANAGER','203',to_date('09-JUN-81','DD-MON-RR'),'243',null,'441');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1171','LEVI MARIO','SECRETARY','739',to_date('09-JUN-81','DD-MON-RR'),'921',null,'102');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1172','CARBONE DONATO','TECHNICIAN','1094',to_date('09-JUN-81','DD-MON-RR'),'266',null,'240');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1173','PETRARCA FRANCESCO','SUPERVISOR','611',to_date('09-JUN-81','DD-MON-RR'),'1811',null,'471');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1174','NERI PASQUALE','SECRETARY','1080',to_date('09-JUN-81','DD-MON-RR'),'1580',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1175','COZZA GIOVANNI','MANAGER','388',to_date('09-JUN-81','DD-MON-RR'),'1773',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1176','TIBALDI MARIO','PROFESSOR','664',to_date('09-JUN-81','DD-MON-RR'),'215',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1177','MANZONI SILVIA','PHDSTUDENT','831',to_date('09-JUN-81','DD-MON-RR'),'236',null,'193');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1178','CORONA DAMIANO','SECRETARY','843',to_date('09-JUN-81','DD-MON-RR'),'1664',null,'46');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1179','GRIMALDI GIOVANNI','HEADMASTER','938',to_date('09-JUN-81','DD-MON-RR'),'747',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1180','LEOPARDI ANTONIO','MANAGER','643',to_date('09-JUN-81','DD-MON-RR'),'1422',null,'308');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1181','PETRARCA LUDOVICO','PROFESSOR','259',to_date('09-JUN-81','DD-MON-RR'),'979',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1182','TIBALDI COSIMO','LAWYER','678',to_date('09-JUN-81','DD-MON-RR'),'1933',null,'252');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1183','FO SILVIA','MANAGER','175',to_date('09-JUN-81','DD-MON-RR'),'1742',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1184','CARBONE LUCIA','PROFESSOR','557',to_date('09-JUN-81','DD-MON-RR'),'652',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1185','LEVI LUCA','SECRETARY','261',to_date('09-JUN-81','DD-MON-RR'),'1009',null,'283');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1186','CARBONE ELIO','SECRETARY','1106',to_date('09-JUN-81','DD-MON-RR'),'606',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1187','CARBONE ELIO','PHDSTUDENT','618',to_date('09-JUN-81','DD-MON-RR'),'396',null,'104');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1188','NERI GAETANO','PHDSTUDENT','997',to_date('09-JUN-81','DD-MON-RR'),'614',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1189','FO DONATO','MANAGER','698',to_date('09-JUN-81','DD-MON-RR'),'40',null,'45');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1190','TIBALDI COSIMO','PHDSTUDENT','1091',to_date('09-JUN-81','DD-MON-RR'),'1462',null,'277');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1191','CALVINO ROBERTA','HEADMASTER','1161',to_date('09-JUN-81','DD-MON-RR'),'1006',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1192','ECO MARIO','ENGINEER','236',to_date('09-JUN-81','DD-MON-RR'),'317',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1193','DANTE LUIGI','HEADMASTER','917',to_date('09-JUN-81','DD-MON-RR'),'47',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1194','CARBONE UGO','SECRETARY','915',to_date('09-JUN-81','DD-MON-RR'),'196',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1195','FO UMBERTO','PHDSTUDENT','1083',to_date('09-JUN-81','DD-MON-RR'),'154',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1196','LEVI FEDERICO','TECHNICIAN','120',to_date('09-JUN-81','DD-MON-RR'),'1073',null,'57');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1197','CALVINO LUDOVICO','LAWYER','729',to_date('09-JUN-81','DD-MON-RR'),'1383',null,'456');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1198','PETRARCA LUDOVICO','SUPERVISOR','356',to_date('09-JUN-81','DD-MON-RR'),'1733',null,'60');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1199','BIANCHI SILVIA','HEADMASTER','370',to_date('09-JUN-81','DD-MON-RR'),'1272',null,'364');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1200','CARBONE ANGELO','SUPERVISOR','505',to_date('09-JUN-81','DD-MON-RR'),'800',null,'483');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1201','FO LUCIA','PROFESSOR','92',to_date('09-JUN-81','DD-MON-RR'),'1926',null,'32');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1202','DANTE MASSIMO','MANAGER','1137',to_date('09-JUN-81','DD-MON-RR'),'1230',null,'124');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1203','FO ALFONSO','PROFESSOR','1148',to_date('09-JUN-81','DD-MON-RR'),'572',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1204','CORONA ELENA','LAWYER','850',to_date('09-JUN-81','DD-MON-RR'),'246',null,'359');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1205','ECO GAETANO','PHDSTUDENT','391',to_date('09-JUN-81','DD-MON-RR'),'1308',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1206','ESPOSITO PAOLO','MANAGER','987',to_date('09-JUN-81','DD-MON-RR'),'389',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1207','BIANCHI CLARA','HEADMASTER','531',to_date('09-JUN-81','DD-MON-RR'),'668',null,'30');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1208','ESPOSITO FRANCESCO','PROFESSOR','44',to_date('09-JUN-81','DD-MON-RR'),'296',null,'168');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1209','ESPOSITO PAOLO','HEADMASTER','403',to_date('09-JUN-81','DD-MON-RR'),'1858',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1210','GRIMALDI LUIGI','SUPERVISOR','322',to_date('09-JUN-81','DD-MON-RR'),'1378',null,'80');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1211','CALVINO ELIO','PHDSTUDENT','429',to_date('09-JUN-81','DD-MON-RR'),'1597',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1212','SANTE ROBERTA','SECRETARY','290',to_date('09-JUN-81','DD-MON-RR'),'245',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1213','PETRARCA ELENA','MANAGER','424',to_date('09-JUN-81','DD-MON-RR'),'1698',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1214','PETRARCA ANTONIO','ENGINEER','1015',to_date('09-JUN-81','DD-MON-RR'),'867',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1215','CALVINO LUCIA','PROFESSOR','751',to_date('09-JUN-81','DD-MON-RR'),'1506',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1216','CALVINO UMBERTO','ENGINEER','73',to_date('09-JUN-81','DD-MON-RR'),'1974',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1217','FUMAROLA FRANCESCO','PHDSTUDENT','484',to_date('09-JUN-81','DD-MON-RR'),'41',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1218','GRIMALDI ANGELO','LAWYER','1199',to_date('09-JUN-81','DD-MON-RR'),'1340',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1219','CARBONE ELENA','TECHNICIAN','345',to_date('09-JUN-81','DD-MON-RR'),'385',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1220','FUMAROLA IVANO','SECRETARY','35',to_date('09-JUN-81','DD-MON-RR'),'1843',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1221','MANZONI FEDERICO','LAWYER','607',to_date('09-JUN-81','DD-MON-RR'),'1524',null,'191');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1222','MANZONI COSIMO','LAWYER','276',to_date('09-JUN-81','DD-MON-RR'),'1390',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1223','FUMAROLA ANGELO','MANAGER','848',to_date('09-JUN-81','DD-MON-RR'),'548',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1224','FUMAROLA ROBERTA','HEADMASTER','946',to_date('09-JUN-81','DD-MON-RR'),'161',null,'362');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1225','BIANCHI DONATO','HEADMASTER','375',to_date('09-JUN-81','DD-MON-RR'),'168',null,'474');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1226','TIBALDI ANGELO','PHDSTUDENT','569',to_date('09-JUN-81','DD-MON-RR'),'711',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1227','SANTE UGO','TECHNICIAN','13',to_date('09-JUN-81','DD-MON-RR'),'1204',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1228','CALVINO ANDREA','PHDSTUDENT','861',to_date('09-JUN-81','DD-MON-RR'),'1700',null,'485');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1229','LEOPARDI FEDERICO','MANAGER','503',to_date('09-JUN-81','DD-MON-RR'),'614',null,'424');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1230','TIBALDI ELENA','TECHNICIAN','200',to_date('09-JUN-81','DD-MON-RR'),'1819',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1231','NERI MASSIMO','HEADMASTER','940',to_date('09-JUN-81','DD-MON-RR'),'886',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1232','SANTE ALFONSO','HEADMASTER','1095',to_date('09-JUN-81','DD-MON-RR'),'603',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1233','LEOPARDI MARIO','PHDSTUDENT','1222',to_date('09-JUN-81','DD-MON-RR'),'399',null,'93');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1234','LEVI PASQUALE','SECRETARY','900',to_date('09-JUN-81','DD-MON-RR'),'974',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1235','CARBONE DAMIANO','MANAGER','594',to_date('09-JUN-81','DD-MON-RR'),'1570',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1236','CARBONE ANDREA','HEADMASTER','388',to_date('09-JUN-81','DD-MON-RR'),'1324',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1237','DANTE ANDREA','ENGINEER','116',to_date('09-JUN-81','DD-MON-RR'),'1458',null,'277');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1238','CALVINO DONATO','LAWYER','756',to_date('09-JUN-81','DD-MON-RR'),'32',null,'126');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1239','MANZONI GAETANO','LAWYER','642',to_date('09-JUN-81','DD-MON-RR'),'1414',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1240','LEVI MASSIMO','SECRETARY','221',to_date('09-JUN-81','DD-MON-RR'),'1532',null,'112');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1241','CARBONE DAMIANO','SUPERVISOR','299',to_date('09-JUN-81','DD-MON-RR'),'1098',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1242','CALVINO LUIGI','MANAGER','571',to_date('09-JUN-81','DD-MON-RR'),'318',null,'177');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1243','ESPOSITO UGO','SECRETARY','86',to_date('09-JUN-81','DD-MON-RR'),'87',null,'197');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1244','FO LUCA','TECHNICIAN','813',to_date('09-JUN-81','DD-MON-RR'),'719',null,'40');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1245','DANTE ALFONSO','SECRETARY','1135',to_date('09-JUN-81','DD-MON-RR'),'171',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1246','ESPOSITO UGO','ENGINEER','324',to_date('09-JUN-81','DD-MON-RR'),'96',null,'458');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1247','NERI PAOLO','LAWYER','837',to_date('09-JUN-81','DD-MON-RR'),'1427',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1248','PETRARCA ANGELO','LAWYER','507',to_date('09-JUN-81','DD-MON-RR'),'1599',null,'308');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1249','ECO ANDREA','MANAGER','220',to_date('09-JUN-81','DD-MON-RR'),'1552',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1250','CALVINO LUIGI','MANAGER','779',to_date('09-JUN-81','DD-MON-RR'),'319',null,'405');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1251','COZZA COSIMO','MANAGER','154',to_date('09-JUN-81','DD-MON-RR'),'1114',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1252','CALVINO GIOVANNI','HEADMASTER','26',to_date('09-JUN-81','DD-MON-RR'),'548',null,'316');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1253','FUMAROLA PASQUALE','PHDSTUDENT','922',to_date('09-JUN-81','DD-MON-RR'),'1415',null,'81');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1254','MANZONI UMBERTO','MANAGER','1019',to_date('09-JUN-81','DD-MON-RR'),'1373',null,'31');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1255','LEVI ALFONSO','HEADMASTER','449',to_date('09-JUN-81','DD-MON-RR'),'1136',null,'235');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1256','FUMAROLA UGO','SUPERVISOR','989',to_date('09-JUN-81','DD-MON-RR'),'894',null,'162');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1257','GRIMALDI LUDOVICO','ENGINEER','469',to_date('09-JUN-81','DD-MON-RR'),'1016',null,'101');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1258','COZZA LUIGI','LAWYER','466',to_date('09-JUN-81','DD-MON-RR'),'813',null,'105');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1259','FUMAROLA CLARA','LAWYER','1032',to_date('09-JUN-81','DD-MON-RR'),'1147',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1260','CORONA CLARA','LAWYER','244',to_date('09-JUN-81','DD-MON-RR'),'1128',null,'460');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1261','ESPOSITO UMBERTO','PROFESSOR','545',to_date('09-JUN-81','DD-MON-RR'),'1043',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1262','COZZA ROBERTA','LAWYER','865',to_date('09-JUN-81','DD-MON-RR'),'696',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1263','ECO ANDREA','SECRETARY','496',to_date('09-JUN-81','DD-MON-RR'),'1450',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1264','GRIMALDI CLARA','HEADMASTER','412',to_date('09-JUN-81','DD-MON-RR'),'159',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1265','LEVI ANDREA','ENGINEER','110',to_date('09-JUN-81','DD-MON-RR'),'313',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1266','DANTE GAETANO','MANAGER','320',to_date('09-JUN-81','DD-MON-RR'),'507',null,'62');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1267','ESPOSITO ALFONSO','PROFESSOR','156',to_date('09-JUN-81','DD-MON-RR'),'1394',null,'224');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1268','LEOPARDI ELIO','SUPERVISOR','214',to_date('09-JUN-81','DD-MON-RR'),'1958',null,'264');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1269','TIBALDI FEDERICO','ENGINEER','581',to_date('09-JUN-81','DD-MON-RR'),'1819',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1270','ESPOSITO ANTONIO','PROFESSOR','1094',to_date('09-JUN-81','DD-MON-RR'),'1463',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1271','FUMAROLA ALFONSO','TECHNICIAN','425',to_date('09-JUN-81','DD-MON-RR'),'1985',null,'30');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1272','COZZA LUIGI','HEADMASTER','712',to_date('09-JUN-81','DD-MON-RR'),'122',null,'385');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1273','ESPOSITO GAETANO','MANAGER','1033',to_date('09-JUN-81','DD-MON-RR'),'82',null,'168');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1274','DANTE ELIO','PROFESSOR','163',to_date('09-JUN-81','DD-MON-RR'),'866',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1275','PETRARCA MARIO','PROFESSOR','1053',to_date('09-JUN-81','DD-MON-RR'),'1704',null,'102');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1276','TIBALDI UMBERTO','TECHNICIAN','793',to_date('09-JUN-81','DD-MON-RR'),'1836',null,'468');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1277','LEOPARDI CLARA','SECRETARY','966',to_date('09-JUN-81','DD-MON-RR'),'1876',null,'468');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1278','LEOPARDI CLARA','PROFESSOR','1130',to_date('09-JUN-81','DD-MON-RR'),'1515',null,'425');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1279','TIBALDI ELIO','TECHNICIAN','178',to_date('09-JUN-81','DD-MON-RR'),'452',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1280','MANZONI MARIO','TECHNICIAN','567',to_date('09-JUN-81','DD-MON-RR'),'98',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1281','LEVI MARIO','SUPERVISOR','761',to_date('09-JUN-81','DD-MON-RR'),'968',null,'301');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1282','MANZONI DAMIANO','PROFESSOR','522',to_date('09-JUN-81','DD-MON-RR'),'1849',null,'459');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1283','DANTE MARIO','ENGINEER','196',to_date('09-JUN-81','DD-MON-RR'),'673',null,'311');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1284','GRIMALDI ANTONIO','SECRETARY','1065',to_date('09-JUN-81','DD-MON-RR'),'1393',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1285','LEVI PAOLO','TECHNICIAN','432',to_date('09-JUN-81','DD-MON-RR'),'218',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1286','PETRARCA LUDOVICO','LAWYER','157',to_date('09-JUN-81','DD-MON-RR'),'704',null,'283');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1287','SANTE DAMIANO','ENGINEER','908',to_date('09-JUN-81','DD-MON-RR'),'583',null,'329');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1288','MANZONI COSIMO','MANAGER','631',to_date('09-JUN-81','DD-MON-RR'),'1578',null,'224');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1289','GRIMALDI ROBERTA','SECRETARY','1075',to_date('09-JUN-81','DD-MON-RR'),'1245',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1290','TIBALDI LUDOVICO','TECHNICIAN','1228',to_date('09-JUN-81','DD-MON-RR'),'95',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1291','CALVINO DAMIANO','HEADMASTER','327',to_date('09-JUN-81','DD-MON-RR'),'1215',null,'294');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1292','CALVINO LUDOVICO','MANAGER','717',to_date('09-JUN-81','DD-MON-RR'),'76',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3190','ESPOSITO LUDOVICO','PROFESSOR','122',to_date('09-JUN-81','DD-MON-RR'),'563',null,'459');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3191','NERI DONATO','ENGINEER','1797',to_date('09-JUN-81','DD-MON-RR'),'375',null,'313');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3192','SANTE DAMIANO','TECHNICIAN','459',to_date('09-JUN-81','DD-MON-RR'),'1744',null,'47');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3193','FO IVANO','MANAGER','2156',to_date('09-JUN-81','DD-MON-RR'),'773',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3194','MANZONI UMBERTO','ENGINEER','2330',to_date('09-JUN-81','DD-MON-RR'),'50',null,'110');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3195','CALVINO CLARA','SUPERVISOR','1718',to_date('09-JUN-81','DD-MON-RR'),'1821',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3196','FUMAROLA ROBERTA','SECRETARY','2379',to_date('09-JUN-81','DD-MON-RR'),'1049',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3197','DANTE ROBERTA','MANAGER','1029',to_date('09-JUN-81','DD-MON-RR'),'387',null,'105');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3198','PETRARCA FEDERICO','MANAGER','2085',to_date('09-JUN-81','DD-MON-RR'),'1193',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3199','TIBALDI DAMIANO','MANAGER','2262',to_date('09-JUN-81','DD-MON-RR'),'1539',null,'340');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3200','COZZA MASSIMO','LAWYER','1251',to_date('09-JUN-81','DD-MON-RR'),'505',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3201','CARBONE DAMIANO','ENGINEER','1856',to_date('09-JUN-81','DD-MON-RR'),'906',null,'475');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3202','GRIMALDI IVANO','ENGINEER','1758',to_date('09-JUN-81','DD-MON-RR'),'294',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3203','ECO MASSIMO','LAWYER','1665',to_date('09-JUN-81','DD-MON-RR'),'433',null,'355');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3204','SANTE FEDERICO','SECRETARY','1034',to_date('09-JUN-81','DD-MON-RR'),'1539',null,'260');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3205','CALVINO CLARA','LAWYER','1784',to_date('09-JUN-81','DD-MON-RR'),'177',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3206','BIANCHI DAMIANO','ENGINEER','1430',to_date('09-JUN-81','DD-MON-RR'),'1610',null,'325');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3207','CALVINO IVANO','PHDSTUDENT','1270',to_date('09-JUN-81','DD-MON-RR'),'1130',null,'312');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3208','FO UMBERTO','MANAGER','2261',to_date('09-JUN-81','DD-MON-RR'),'1690',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3209','GRIMALDI ELIO','MANAGER','539',to_date('09-JUN-81','DD-MON-RR'),'1671',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3210','CALVINO SILVIA','HEADMASTER','2973',to_date('09-JUN-81','DD-MON-RR'),'791',null,'12');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3211','COZZA LUIGI','PHDSTUDENT','1972',to_date('09-JUN-81','DD-MON-RR'),'1725',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3212','PETRARCA MASSIMO','MANAGER','2386',to_date('09-JUN-81','DD-MON-RR'),'1310',null,'318');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3213','CALVINO COSIMO','ENGINEER','1789',to_date('09-JUN-81','DD-MON-RR'),'1900',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3214','DANTE IVANO','SUPERVISOR','1389',to_date('09-JUN-81','DD-MON-RR'),'1069',null,'77');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3215','SANTE DONATO','PROFESSOR','1953',to_date('09-JUN-81','DD-MON-RR'),'302',null,'195');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3216','CALVINO DAMIANO','PHDSTUDENT','2838',to_date('09-JUN-81','DD-MON-RR'),'363',null,'335');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3217','ESPOSITO GIOVANNI','LAWYER','28',to_date('09-JUN-81','DD-MON-RR'),'381',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3218','LEOPARDI ALFONSO','MANAGER','1954',to_date('09-JUN-81','DD-MON-RR'),'229',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3219','FO DAMIANO','SECRETARY','2365',to_date('09-JUN-81','DD-MON-RR'),'1021',null,'341');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3220','ECO UGO','PROFESSOR','2852',to_date('09-JUN-81','DD-MON-RR'),'1579',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3221','PETRARCA ANTONIO','HEADMASTER','271',to_date('09-JUN-81','DD-MON-RR'),'609',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3222','ESPOSITO LUIGI','SUPERVISOR','2205',to_date('09-JUN-81','DD-MON-RR'),'502',null,'222');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3223','COZZA ALFONSO','LAWYER','322',to_date('09-JUN-81','DD-MON-RR'),'1007',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3224','CORONA DAMIANO','LAWYER','92',to_date('09-JUN-81','DD-MON-RR'),'1307',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3225','ECO SILVIA','MANAGER','1994',to_date('09-JUN-81','DD-MON-RR'),'860',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3226','COZZA PAOLO','PROFESSOR','977',to_date('09-JUN-81','DD-MON-RR'),'1583',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3227','FO ELIO','PHDSTUDENT','1178',to_date('09-JUN-81','DD-MON-RR'),'462',null,'450');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3228','CALVINO IVANO','PROFESSOR','2628',to_date('09-JUN-81','DD-MON-RR'),'1201',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3229','MANZONI LUCA','LAWYER','418',to_date('09-JUN-81','DD-MON-RR'),'1021',null,'436');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3230','DANTE SILVIA','SUPERVISOR','2347',to_date('09-JUN-81','DD-MON-RR'),'1680',null,'423');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3231','CARBONE ANDREA','MANAGER','1641',to_date('09-JUN-81','DD-MON-RR'),'1640',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3232','ESPOSITO MASSIMO','MANAGER','1822',to_date('09-JUN-81','DD-MON-RR'),'591',null,'62');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3233','GRIMALDI LUCA','MANAGER','844',to_date('09-JUN-81','DD-MON-RR'),'1841',null,'113');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3234','SANTE ALFONSO','MANAGER','2526',to_date('09-JUN-81','DD-MON-RR'),'1965',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3235','NERI ELIO','ENGINEER','232',to_date('09-JUN-81','DD-MON-RR'),'1093',null,'140');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3236','MANZONI IVANO','SECRETARY','1536',to_date('09-JUN-81','DD-MON-RR'),'922',null,'308');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3237','CARBONE PAOLO','MANAGER','2312',to_date('09-JUN-81','DD-MON-RR'),'1879',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3238','SANTE PAOLO','SECRETARY','1501',to_date('09-JUN-81','DD-MON-RR'),'1330',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3239','FUMAROLA ROBERTA','MANAGER','1287',to_date('09-JUN-81','DD-MON-RR'),'16',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3240','CARBONE MARIO','SECRETARY','182',to_date('09-JUN-81','DD-MON-RR'),'1469',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3241','DANTE ELIO','PHDSTUDENT','435',to_date('09-JUN-81','DD-MON-RR'),'258',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3242','GRIMALDI GIOVANNI','SECRETARY','974',to_date('09-JUN-81','DD-MON-RR'),'1330',null,'402');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3243','FUMAROLA LUIGI','MANAGER','310',to_date('09-JUN-81','DD-MON-RR'),'1934',null,'437');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3244','COZZA PASQUALE','MANAGER','2244',to_date('09-JUN-81','DD-MON-RR'),'109',null,'54');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3245','TIBALDI CLARA','SUPERVISOR','3007',to_date('09-JUN-81','DD-MON-RR'),'1454',null,'253');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3246','GRIMALDI ELENA','TECHNICIAN','91',to_date('09-JUN-81','DD-MON-RR'),'396',null,'145');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3247','GRIMALDI ANGELO','TECHNICIAN','1239',to_date('09-JUN-81','DD-MON-RR'),'502',null,'453');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3248','DANTE SILVIA','MANAGER','1283',to_date('09-JUN-81','DD-MON-RR'),'983',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3249','BIANCHI ELENA','SECRETARY','1203',to_date('09-JUN-81','DD-MON-RR'),'302',null,'44');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3250','SANTE LUCA','PHDSTUDENT','819',to_date('09-JUN-81','DD-MON-RR'),'954',null,'243');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3251','ECO ALFONSO','MANAGER','2992',to_date('09-JUN-81','DD-MON-RR'),'1013',null,'374');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3252','FUMAROLA MASSIMO','PHDSTUDENT','1471',to_date('09-JUN-81','DD-MON-RR'),'810',null,'475');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3253','ESPOSITO PASQUALE','TECHNICIAN','2501',to_date('09-JUN-81','DD-MON-RR'),'1973',null,'419');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3254','DANTE GIOVANNI','TECHNICIAN','588',to_date('09-JUN-81','DD-MON-RR'),'1253',null,'224');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3255','ESPOSITO ROBERTA','SUPERVISOR','97',to_date('09-JUN-81','DD-MON-RR'),'718',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3256','SANTE MARIA','ENGINEER','221',to_date('09-JUN-81','DD-MON-RR'),'77',null,'230');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3257','ECO LUIGI','LAWYER','1682',to_date('09-JUN-81','DD-MON-RR'),'1405',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3258','NERI DAMIANO','HEADMASTER','2649',to_date('09-JUN-81','DD-MON-RR'),'1660',null,'234');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3259','FUMAROLA ANTONIO','PROFESSOR','3093',to_date('09-JUN-81','DD-MON-RR'),'315',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3260','CARBONE LUCA','MANAGER','1295',to_date('09-JUN-81','DD-MON-RR'),'915',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3261','FUMAROLA MARIO','HEADMASTER','2703',to_date('09-JUN-81','DD-MON-RR'),'86',null,'487');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3262','CORONA GAETANO','MANAGER','2528',to_date('09-JUN-81','DD-MON-RR'),'753',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3263','FUMAROLA GAETANO','LAWYER','480',to_date('09-JUN-81','DD-MON-RR'),'1313',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3264','PETRARCA UMBERTO','TECHNICIAN','1112',to_date('09-JUN-81','DD-MON-RR'),'515',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3265','CORONA ANTONIO','ENGINEER','493',to_date('09-JUN-81','DD-MON-RR'),'106',null,'419');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3266','NERI LUIGI','HEADMASTER','2954',to_date('09-JUN-81','DD-MON-RR'),'1511',null,'428');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3267','SANTE PAOLO','LAWYER','339',to_date('09-JUN-81','DD-MON-RR'),'1642',null,'47');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3268','SANTE GIOVANNI','MANAGER','66',to_date('09-JUN-81','DD-MON-RR'),'1268',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3269','NERI UGO','TECHNICIAN','2077',to_date('09-JUN-81','DD-MON-RR'),'1181',null,'80');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3270','MANZONI FEDERICO','PROFESSOR','3174',to_date('09-JUN-81','DD-MON-RR'),'869',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3271','BIANCHI LUCIA','PHDSTUDENT','2042',to_date('09-JUN-81','DD-MON-RR'),'616',null,'276');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3272','GRIMALDI LUIGI','PHDSTUDENT','653',to_date('09-JUN-81','DD-MON-RR'),'582',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3273','CORONA CLARA','ENGINEER','761',to_date('09-JUN-81','DD-MON-RR'),'685',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3274','ECO SILVIA','MANAGER','2394',to_date('09-JUN-81','DD-MON-RR'),'1636',null,'191');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3275','DANTE GIOVANNI','SUPERVISOR','2324',to_date('09-JUN-81','DD-MON-RR'),'756',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3276','TIBALDI ANDREA','SECRETARY','1234',to_date('09-JUN-81','DD-MON-RR'),'1625',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3277','LEVI MASSIMO','SUPERVISOR','1734',to_date('09-JUN-81','DD-MON-RR'),'988',null,'145');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3278','DANTE CLARA','TECHNICIAN','2811',to_date('09-JUN-81','DD-MON-RR'),'42',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3279','SANTE FEDERICO','MANAGER','626',to_date('09-JUN-81','DD-MON-RR'),'1160',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3280','COZZA DONATO','TECHNICIAN','784',to_date('09-JUN-81','DD-MON-RR'),'365',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3281','BIANCHI SILVIA','PROFESSOR','2768',to_date('09-JUN-81','DD-MON-RR'),'278',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3282','COZZA IVANO','HEADMASTER','2150',to_date('09-JUN-81','DD-MON-RR'),'1196',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3283','FO ANDREA','HEADMASTER','1835',to_date('09-JUN-81','DD-MON-RR'),'811',null,'171');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3284','ESPOSITO ANGELO','LAWYER','2148',to_date('09-JUN-81','DD-MON-RR'),'1992',null,'386');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3285','PETRARCA DAMIANO','LAWYER','3202',to_date('09-JUN-81','DD-MON-RR'),'1617',null,'213');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3286','ECO IVANO','LAWYER','2130',to_date('09-JUN-81','DD-MON-RR'),'1984',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3287','MANZONI GAETANO','PHDSTUDENT','1413',to_date('09-JUN-81','DD-MON-RR'),'606',null,'497');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3288','CARBONE ANDREA','TECHNICIAN','934',to_date('09-JUN-81','DD-MON-RR'),'1616',null,'474');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3289','MANZONI DAMIANO','ENGINEER','2693',to_date('09-JUN-81','DD-MON-RR'),'1955',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3290','TIBALDI GIOVANNI','PROFESSOR','2751',to_date('09-JUN-81','DD-MON-RR'),'1127',null,'65');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3291','LEVI UGO','LAWYER','1493',to_date('09-JUN-81','DD-MON-RR'),'1858',null,'135');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3292','MANZONI ALFONSO','PHDSTUDENT','593',to_date('09-JUN-81','DD-MON-RR'),'1502',null,'111');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3293','LEVI SILVIA','PROFESSOR','2371',to_date('09-JUN-81','DD-MON-RR'),'1996',null,'139');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3294','LEVI FRANCESCO','HEADMASTER','1401',to_date('09-JUN-81','DD-MON-RR'),'889',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3295','ECO PAOLO','MANAGER','1641',to_date('09-JUN-81','DD-MON-RR'),'1743',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3296','ESPOSITO GAETANO','SECRETARY','2989',to_date('09-JUN-81','DD-MON-RR'),'1179',null,'471');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3297','SANTE MARIO','MANAGER','321',to_date('09-JUN-81','DD-MON-RR'),'1104',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3298','LEVI GAETANO','HEADMASTER','2610',to_date('09-JUN-81','DD-MON-RR'),'897',null,'364');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3299','TIBALDI DAMIANO','PROFESSOR','2223',to_date('09-JUN-81','DD-MON-RR'),'1088',null,'399');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3300','COZZA FRANCESCO','MANAGER','1400',to_date('09-JUN-81','DD-MON-RR'),'438',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3301','SANTE LUIGI','TECHNICIAN','567',to_date('09-JUN-81','DD-MON-RR'),'1509',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3302','CARBONE CLARA','MANAGER','1253',to_date('09-JUN-81','DD-MON-RR'),'61',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3303','CORONA UMBERTO','TECHNICIAN','414',to_date('09-JUN-81','DD-MON-RR'),'284',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3304','FO UMBERTO','LAWYER','686',to_date('09-JUN-81','DD-MON-RR'),'1774',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3305','LEOPARDI ELENA','MANAGER','2778',to_date('09-JUN-81','DD-MON-RR'),'1133',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3306','TIBALDI UMBERTO','PHDSTUDENT','1286',to_date('09-JUN-81','DD-MON-RR'),'1792',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3307','FUMAROLA MARIO','MANAGER','2064',to_date('09-JUN-81','DD-MON-RR'),'782',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3308','DANTE MARIA','HEADMASTER','216',to_date('09-JUN-81','DD-MON-RR'),'1824',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3309','ESPOSITO LUDOVICO','ENGINEER','835',to_date('09-JUN-81','DD-MON-RR'),'1947',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3310','BIANCHI FEDERICO','TECHNICIAN','1219',to_date('09-JUN-81','DD-MON-RR'),'1641',null,'3');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3311','FO PASQUALE','SECRETARY','1629',to_date('09-JUN-81','DD-MON-RR'),'1513',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3312','NERI UGO','LAWYER','3002',to_date('09-JUN-81','DD-MON-RR'),'404',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3313','NERI ANDREA','SUPERVISOR','2209',to_date('09-JUN-81','DD-MON-RR'),'496',null,'365');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3314','FO GIOVANNI','TECHNICIAN','913',to_date('09-JUN-81','DD-MON-RR'),'199',null,'235');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3315','LEVI ANTONIO','LAWYER','49',to_date('09-JUN-81','DD-MON-RR'),'1836',null,'135');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3316','NERI COSIMO','ENGINEER','2503',to_date('09-JUN-81','DD-MON-RR'),'1833',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3317','CORONA UGO','HEADMASTER','79',to_date('09-JUN-81','DD-MON-RR'),'112',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3318','NERI LUIGI','MANAGER','2900',to_date('09-JUN-81','DD-MON-RR'),'668',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3319','ESPOSITO ANTONIO','MANAGER','339',to_date('09-JUN-81','DD-MON-RR'),'949',null,'277');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3320','CORONA ANTONIO','ENGINEER','79',to_date('09-JUN-81','DD-MON-RR'),'126',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3321','SANTE ANGELO','PROFESSOR','3107',to_date('09-JUN-81','DD-MON-RR'),'1681',null,'181');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3322','ESPOSITO COSIMO','SUPERVISOR','1018',to_date('09-JUN-81','DD-MON-RR'),'496',null,'284');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3323','ECO ALFONSO','HEADMASTER','2797',to_date('09-JUN-81','DD-MON-RR'),'355',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3324','GRIMALDI FEDERICO','LAWYER','3005',to_date('09-JUN-81','DD-MON-RR'),'1770',null,'122');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3325','LEOPARDI ELIO','MANAGER','1873',to_date('09-JUN-81','DD-MON-RR'),'964',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6505','COZZA UGO','ENGINEER','2390',to_date('09-JUN-81','DD-MON-RR'),'127',null,'344');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6506','CORONA FEDERICO','TECHNICIAN','2907',to_date('09-JUN-81','DD-MON-RR'),'1992',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6507','NERI LUDOVICO','PROFESSOR','2093',to_date('09-JUN-81','DD-MON-RR'),'1776',null,'124');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6508','MANZONI CLARA','ENGINEER','3483',to_date('09-JUN-81','DD-MON-RR'),'158',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6509','PETRARCA CLARA','ENGINEER','3753',to_date('09-JUN-81','DD-MON-RR'),'230',null,'430');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6510','DANTE PAOLO','ENGINEER','453',to_date('09-JUN-81','DD-MON-RR'),'512',null,'481');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6511','NERI ELIO','LAWYER','2573',to_date('09-JUN-81','DD-MON-RR'),'1466',null,'35');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6512','CORONA MARIA','SUPERVISOR','1692',to_date('09-JUN-81','DD-MON-RR'),'1722',null,'40');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6513','SANTE CLARA','MANAGER','3064',to_date('09-JUN-81','DD-MON-RR'),'1320',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6514','PETRARCA LUIGI','SECRETARY','3254',to_date('09-JUN-81','DD-MON-RR'),'1874',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6515','ECO LUCA','LAWYER','1696',to_date('09-JUN-81','DD-MON-RR'),'1825',null,'222');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6516','COZZA MASSIMO','MANAGER','1948',to_date('09-JUN-81','DD-MON-RR'),'131',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6517','CARBONE UMBERTO','PHDSTUDENT','3668',to_date('09-JUN-81','DD-MON-RR'),'977',null,'432');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6518','SANTE GAETANO','PROFESSOR','2079',to_date('09-JUN-81','DD-MON-RR'),'934',null,'325');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6519','ESPOSITO PASQUALE','MANAGER','1691',to_date('09-JUN-81','DD-MON-RR'),'133',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6520','FUMAROLA FRANCESCO','TECHNICIAN','4888',to_date('09-JUN-81','DD-MON-RR'),'1375',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6521','DANTE ALFONSO','PHDSTUDENT','6047',to_date('09-JUN-81','DD-MON-RR'),'420',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6522','COZZA UGO','HEADMASTER','2585',to_date('09-JUN-81','DD-MON-RR'),'288',null,'78');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6523','FUMAROLA ELENA','MANAGER','1641',to_date('09-JUN-81','DD-MON-RR'),'212',null,'310');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6524','COZZA CLARA','MANAGER','5951',to_date('09-JUN-81','DD-MON-RR'),'880',null,'127');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6525','COZZA GIOVANNI','LAWYER','4245',to_date('09-JUN-81','DD-MON-RR'),'1500',null,'185');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6526','CARBONE ANTONIO','MANAGER','4749',to_date('09-JUN-81','DD-MON-RR'),'1746',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6527','FO PAOLO','PROFESSOR','5455',to_date('09-JUN-81','DD-MON-RR'),'1323',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6528','GRIMALDI LUIGI','MANAGER','964',to_date('09-JUN-81','DD-MON-RR'),'350',null,'55');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6529','PETRARCA ANTONIO','MANAGER','6258',to_date('09-JUN-81','DD-MON-RR'),'1978',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6530','LEOPARDI ANDREA','HEADMASTER','5858',to_date('09-JUN-81','DD-MON-RR'),'999',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6531','CALVINO SILVIA','LAWYER','3595',to_date('09-JUN-81','DD-MON-RR'),'1162',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6532','COZZA PAOLO','HEADMASTER','766',to_date('09-JUN-81','DD-MON-RR'),'1168',null,'114');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6533','CALVINO COSIMO','MANAGER','2227',to_date('09-JUN-81','DD-MON-RR'),'1451',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6534','LEOPARDI FEDERICO','MANAGER','4871',to_date('09-JUN-81','DD-MON-RR'),'907',null,'196');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6535','CORONA ANDREA','HEADMASTER','1380',to_date('09-JUN-81','DD-MON-RR'),'1129',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6536','FO FEDERICO','MANAGER','806',to_date('09-JUN-81','DD-MON-RR'),'767',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6537','LEOPARDI CLARA','TECHNICIAN','6487',to_date('09-JUN-81','DD-MON-RR'),'1088',null,'254');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6538','FO ANGELO','ENGINEER','2441',to_date('09-JUN-81','DD-MON-RR'),'441',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6539','PETRARCA PAOLO','MANAGER','684',to_date('09-JUN-81','DD-MON-RR'),'838',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6540','GRIMALDI PAOLO','MANAGER','4839',to_date('09-JUN-81','DD-MON-RR'),'217',null,'497');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6541','DANTE LUIGI','PHDSTUDENT','505',to_date('09-JUN-81','DD-MON-RR'),'1852',null,'105');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6542','NERI LUCIA','PROFESSOR','1174',to_date('09-JUN-81','DD-MON-RR'),'688',null,'91');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6543','COZZA ELENA','TECHNICIAN','5085',to_date('09-JUN-81','DD-MON-RR'),'1877',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6544','COZZA PAOLO','LAWYER','5883',to_date('09-JUN-81','DD-MON-RR'),'1488',null,'187');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6545','GRIMALDI ROBERTA','ENGINEER','595',to_date('09-JUN-81','DD-MON-RR'),'1963',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6546','ESPOSITO ANDREA','TECHNICIAN','5979',to_date('09-JUN-81','DD-MON-RR'),'1081',null,'55');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6547','TIBALDI ROBERTA','ENGINEER','4995',to_date('09-JUN-81','DD-MON-RR'),'1948',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6548','NERI ELENA','PROFESSOR','49',to_date('09-JUN-81','DD-MON-RR'),'882',null,'155');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6549','DANTE PAOLO','ENGINEER','1614',to_date('09-JUN-81','DD-MON-RR'),'1861',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6550','ECO SILVIA','TECHNICIAN','5858',to_date('09-JUN-81','DD-MON-RR'),'1365',null,'458');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6551','LEOPARDI COSIMO','MANAGER','3010',to_date('09-JUN-81','DD-MON-RR'),'1363',null,'460');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6552','ECO ANDREA','PROFESSOR','210',to_date('09-JUN-81','DD-MON-RR'),'1139',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6553','DANTE LUIGI','SUPERVISOR','1374',to_date('09-JUN-81','DD-MON-RR'),'1045',null,'398');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6554','ESPOSITO PASQUALE','MANAGER','3076',to_date('09-JUN-81','DD-MON-RR'),'119',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6555','FUMAROLA ANTONIO','PHDSTUDENT','644',to_date('09-JUN-81','DD-MON-RR'),'1151',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6556','CALVINO PASQUALE','TECHNICIAN','2599',to_date('09-JUN-81','DD-MON-RR'),'621',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6557','ESPOSITO FEDERICO','SUPERVISOR','230',to_date('09-JUN-81','DD-MON-RR'),'1825',null,'430');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6558','CALVINO IVANO','MANAGER','535',to_date('09-JUN-81','DD-MON-RR'),'1921',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6559','NERI ANTONIO','PHDSTUDENT','4631',to_date('09-JUN-81','DD-MON-RR'),'1900',null,'385');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6560','CORONA UGO','LAWYER','5352',to_date('09-JUN-81','DD-MON-RR'),'422',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6561','ESPOSITO LUCIA','MANAGER','4277',to_date('09-JUN-81','DD-MON-RR'),'1247',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6562','BIANCHI LUCIA','SUPERVISOR','2801',to_date('09-JUN-81','DD-MON-RR'),'1954',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6563','DANTE ELENA','SUPERVISOR','4351',to_date('09-JUN-81','DD-MON-RR'),'1570',null,'347');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6564','ECO ELENA','ENGINEER','1787',to_date('09-JUN-81','DD-MON-RR'),'738',null,'63');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6565','CORONA GAETANO','LAWYER','3250',to_date('09-JUN-81','DD-MON-RR'),'1300',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6566','BIANCHI GAETANO','LAWYER','2640',to_date('09-JUN-81','DD-MON-RR'),'303',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6567','COZZA MARIA','ENGINEER','4351',to_date('09-JUN-81','DD-MON-RR'),'1429',null,'110');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6568','CORONA FRANCESCO','SUPERVISOR','2500',to_date('09-JUN-81','DD-MON-RR'),'1330',null,'354');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6569','ESPOSITO MARIO','HEADMASTER','1657',to_date('09-JUN-81','DD-MON-RR'),'997',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6570','CARBONE MASSIMO','MANAGER','4060',to_date('09-JUN-81','DD-MON-RR'),'74',null,'112');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6571','CALVINO LUCA','MANAGER','4907',to_date('09-JUN-81','DD-MON-RR'),'1924',null,'438');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6572','LEVI SILVIA','HEADMASTER','1916',to_date('09-JUN-81','DD-MON-RR'),'434',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6573','NERI LUDOVICO','LAWYER','2867',to_date('09-JUN-81','DD-MON-RR'),'487',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6574','DANTE CLARA','ENGINEER','3404',to_date('09-JUN-81','DD-MON-RR'),'1144',null,'136');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6575','MANZONI LUIGI','MANAGER','5490',to_date('09-JUN-81','DD-MON-RR'),'1137',null,'425');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6576','BIANCHI ELENA','LAWYER','5170',to_date('09-JUN-81','DD-MON-RR'),'769',null,'187');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6577','LEVI LUCA','MANAGER','5448',to_date('09-JUN-81','DD-MON-RR'),'1449',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6578','DANTE FEDERICO','ENGINEER','3883',to_date('09-JUN-81','DD-MON-RR'),'1346',null,'126');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6579','GRIMALDI ALFONSO','SECRETARY','5998',to_date('09-JUN-81','DD-MON-RR'),'672',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6580','ESPOSITO DAMIANO','ENGINEER','6574',to_date('09-JUN-81','DD-MON-RR'),'861',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6581','FO CLARA','LAWYER','1727',to_date('09-JUN-81','DD-MON-RR'),'555',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6582','FO MARIA','HEADMASTER','3718',to_date('09-JUN-81','DD-MON-RR'),'1539',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6583','MANZONI UMBERTO','LAWYER','4733',to_date('09-JUN-81','DD-MON-RR'),'136',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6584','GRIMALDI ELIO','PHDSTUDENT','3582',to_date('09-JUN-81','DD-MON-RR'),'236',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6585','NERI PASQUALE','MANAGER','5165',to_date('09-JUN-81','DD-MON-RR'),'603',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6586','TIBALDI MASSIMO','SECRETARY','4949',to_date('09-JUN-81','DD-MON-RR'),'830',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6587','FUMAROLA MARIO','MANAGER','3679',to_date('09-JUN-81','DD-MON-RR'),'1233',null,'207');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6588','FO ALFONSO','PHDSTUDENT','3191',to_date('09-JUN-81','DD-MON-RR'),'92',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6589','FUMAROLA SILVIA','MANAGER','5348',to_date('09-JUN-81','DD-MON-RR'),'1123',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6590','MANZONI LUDOVICO','LAWYER','1490',to_date('09-JUN-81','DD-MON-RR'),'69',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6591','CARBONE ROBERTA','ENGINEER','3884',to_date('09-JUN-81','DD-MON-RR'),'470',null,'229');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6592','MANZONI FRANCESCO','TECHNICIAN','6199',to_date('09-JUN-81','DD-MON-RR'),'465',null,'63');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6593','LEVI UMBERTO','PROFESSOR','1646',to_date('09-JUN-81','DD-MON-RR'),'240',null,'249');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6594','MANZONI COSIMO','PROFESSOR','2503',to_date('09-JUN-81','DD-MON-RR'),'341',null,'39');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6595','CARBONE LUCIA','PHDSTUDENT','1678',to_date('09-JUN-81','DD-MON-RR'),'236',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6596','CORONA DAMIANO','SUPERVISOR','1239',to_date('09-JUN-81','DD-MON-RR'),'1739',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6597','ECO PASQUALE','SECRETARY','1028',to_date('09-JUN-81','DD-MON-RR'),'208',null,'495');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6598','DANTE LUDOVICO','LAWYER','4855',to_date('09-JUN-81','DD-MON-RR'),'1420',null,'373');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6599','ESPOSITO GIOVANNI','SECRETARY','4966',to_date('09-JUN-81','DD-MON-RR'),'602',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6600','FUMAROLA ELIO','MANAGER','1061',to_date('09-JUN-81','DD-MON-RR'),'443',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6601','COZZA ANGELO','ENGINEER','2463',to_date('09-JUN-81','DD-MON-RR'),'1109',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6602','DANTE MASSIMO','MANAGER','1417',to_date('09-JUN-81','DD-MON-RR'),'713',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6603','LEVI UMBERTO','SUPERVISOR','5491',to_date('09-JUN-81','DD-MON-RR'),'750',null,'437');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6604','CORONA COSIMO','ENGINEER','4520',to_date('09-JUN-81','DD-MON-RR'),'726',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6605','MANZONI FEDERICO','LAWYER','861',to_date('09-JUN-81','DD-MON-RR'),'710',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6606','CORONA DONATO','SUPERVISOR','6506',to_date('09-JUN-81','DD-MON-RR'),'507',null,'104');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6607','DANTE LUIGI','MANAGER','149',to_date('09-JUN-81','DD-MON-RR'),'1850',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6608','CARBONE ANGELO','HEADMASTER','5901',to_date('09-JUN-81','DD-MON-RR'),'1924',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6609','BIANCHI SILVIA','MANAGER','3740',to_date('09-JUN-81','DD-MON-RR'),'450',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6610','MANZONI GAETANO','ENGINEER','4831',to_date('09-JUN-81','DD-MON-RR'),'633',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6611','LEOPARDI ELIO','PROFESSOR','4453',to_date('09-JUN-81','DD-MON-RR'),'1438',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6612','NERI DONATO','LAWYER','1940',to_date('09-JUN-81','DD-MON-RR'),'327',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6613','FUMAROLA UMBERTO','MANAGER','3088',to_date('09-JUN-81','DD-MON-RR'),'1568',null,'83');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6614','LEVI UMBERTO','SECRETARY','4235',to_date('09-JUN-81','DD-MON-RR'),'237',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6615','SANTE FEDERICO','PROFESSOR','2282',to_date('09-JUN-81','DD-MON-RR'),'1029',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6616','FO LUDOVICO','SUPERVISOR','5523',to_date('09-JUN-81','DD-MON-RR'),'414',null,'444');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6617','CARBONE MASSIMO','PROFESSOR','2797',to_date('09-JUN-81','DD-MON-RR'),'767',null,'97');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6618','ECO LUDOVICO','LAWYER','4647',to_date('09-JUN-81','DD-MON-RR'),'1822',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6619','LEVI DONATO','SECRETARY','3819',to_date('09-JUN-81','DD-MON-RR'),'1600',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6620','TIBALDI SILVIA','TECHNICIAN','4165',to_date('09-JUN-81','DD-MON-RR'),'1081',null,'420');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6621','ECO GAETANO','ENGINEER','1560',to_date('09-JUN-81','DD-MON-RR'),'50',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6622','TIBALDI UMBERTO','TECHNICIAN','1034',to_date('09-JUN-81','DD-MON-RR'),'1443',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6623','ECO COSIMO','LAWYER','2891',to_date('09-JUN-81','DD-MON-RR'),'1842',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6624','CORONA PAOLO','MANAGER','4834',to_date('09-JUN-81','DD-MON-RR'),'734',null,'185');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6625','MANZONI MARIO','LAWYER','3958',to_date('09-JUN-81','DD-MON-RR'),'1012',null,'53');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6626','CALVINO PASQUALE','HEADMASTER','5378',to_date('09-JUN-81','DD-MON-RR'),'1614',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6627','COZZA ROBERTA','MANAGER','428',to_date('09-JUN-81','DD-MON-RR'),'178',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6628','COZZA UMBERTO','MANAGER','4109',to_date('09-JUN-81','DD-MON-RR'),'1753',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6629','GRIMALDI MARIA','SECRETARY','3994',to_date('09-JUN-81','DD-MON-RR'),'1826',null,'321');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6630','FO DAMIANO','PHDSTUDENT','3588',to_date('09-JUN-81','DD-MON-RR'),'1565',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6631','PETRARCA DONATO','PHDSTUDENT','6284',to_date('09-JUN-81','DD-MON-RR'),'64',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6632','ESPOSITO COSIMO','HEADMASTER','5931',to_date('09-JUN-81','DD-MON-RR'),'979',null,'213');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6633','NERI COSIMO','MANAGER','5321',to_date('09-JUN-81','DD-MON-RR'),'459',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6634','ESPOSITO SILVIA','HEADMASTER','3724',to_date('09-JUN-81','DD-MON-RR'),'1727',null,'420');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6635','CALVINO ANGELO','LAWYER','4798',to_date('09-JUN-81','DD-MON-RR'),'758',null,'404');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6636','CALVINO SILVIA','MANAGER','2303',to_date('09-JUN-81','DD-MON-RR'),'1952',null,'30');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6637','TIBALDI UGO','MANAGER','601',to_date('09-JUN-81','DD-MON-RR'),'284',null,'488');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6638','CALVINO FRANCESCO','LAWYER','2557',to_date('09-JUN-81','DD-MON-RR'),'366',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6639','COZZA UGO','PROFESSOR','377',to_date('09-JUN-81','DD-MON-RR'),'62',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6640','GRIMALDI COSIMO','MANAGER','6133',to_date('09-JUN-81','DD-MON-RR'),'1916',null,'78');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6641','DANTE LUCA','TECHNICIAN','5058',to_date('09-JUN-81','DD-MON-RR'),'109',null,'81');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8672','ECO GIOVANNI','PROFESSOR','7363',to_date('09-JUN-81','DD-MON-RR'),'1687',null,'444');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8673','MANZONI GIOVANNI','HEADMASTER','1561',to_date('09-JUN-81','DD-MON-RR'),'951',null,'254');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8674','BIANCHI IVANO','SUPERVISOR','140',to_date('09-JUN-81','DD-MON-RR'),'516',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8675','PETRARCA FEDERICO','LAWYER','7576',to_date('09-JUN-81','DD-MON-RR'),'1800',null,'459');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8676','LEOPARDI COSIMO','MANAGER','4354',to_date('09-JUN-81','DD-MON-RR'),'1247',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8677','ECO PASQUALE','LAWYER','199',to_date('09-JUN-81','DD-MON-RR'),'711',null,'325');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8678','ESPOSITO MARIA','MANAGER','6810',to_date('09-JUN-81','DD-MON-RR'),'1393',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8679','MANZONI LUCA','MANAGER','4341',to_date('09-JUN-81','DD-MON-RR'),'1665',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8680','ESPOSITO ROBERTA','LAWYER','2133',to_date('09-JUN-81','DD-MON-RR'),'1946',null,'456');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8681','GRIMALDI SILVIA','PHDSTUDENT','6177',to_date('09-JUN-81','DD-MON-RR'),'53',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8682','TIBALDI LUIGI','PHDSTUDENT','3668',to_date('09-JUN-81','DD-MON-RR'),'286',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8683','LEOPARDI DAMIANO','ENGINEER','5171',to_date('09-JUN-81','DD-MON-RR'),'1679',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8684','LEVI GIOVANNI','LAWYER','4224',to_date('09-JUN-81','DD-MON-RR'),'1265',null,'373');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8685','GRIMALDI ANDREA','TECHNICIAN','5631',to_date('09-JUN-81','DD-MON-RR'),'1801',null,'410');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8686','MANZONI UMBERTO','PROFESSOR','8334',to_date('09-JUN-81','DD-MON-RR'),'1554',null,'186');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8687','CALVINO ELENA','SUPERVISOR','4437',to_date('09-JUN-81','DD-MON-RR'),'1632',null,'317');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8688','TIBALDI FRANCESCO','ENGINEER','6918',to_date('09-JUN-81','DD-MON-RR'),'968',null,'265');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8689','ESPOSITO GAETANO','MANAGER','7030',to_date('09-JUN-81','DD-MON-RR'),'1130',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8690','TIBALDI UMBERTO','MANAGER','3514',to_date('09-JUN-81','DD-MON-RR'),'1700',null,'426');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8691','CORONA ANTONIO','SUPERVISOR','4960',to_date('09-JUN-81','DD-MON-RR'),'740',null,'347');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8692','GRIMALDI DONATO','HEADMASTER','3789',to_date('09-JUN-81','DD-MON-RR'),'1726',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8693','ESPOSITO COSIMO','MANAGER','6630',to_date('09-JUN-81','DD-MON-RR'),'109',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8694','PETRARCA MARIA','MANAGER','8317',to_date('09-JUN-81','DD-MON-RR'),'1516',null,'460');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8695','DANTE COSIMO','ENGINEER','1778',to_date('09-JUN-81','DD-MON-RR'),'1438',null,'486');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8696','SANTE MASSIMO','PHDSTUDENT','8475',to_date('09-JUN-81','DD-MON-RR'),'1030',null,'376');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8697','COZZA ANTONIO','MANAGER','6590',to_date('09-JUN-81','DD-MON-RR'),'1789',null,'484');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8698','CALVINO ELENA','PROFESSOR','3958',to_date('09-JUN-81','DD-MON-RR'),'1458',null,'140');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8699','CORONA FRANCESCO','SECRETARY','766',to_date('09-JUN-81','DD-MON-RR'),'1958',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8700','BIANCHI LUDOVICO','MANAGER','1142',to_date('09-JUN-81','DD-MON-RR'),'873',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8701','TIBALDI SILVIA','HEADMASTER','4238',to_date('09-JUN-81','DD-MON-RR'),'936',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8702','CORONA LUDOVICO','ENGINEER','3016',to_date('09-JUN-81','DD-MON-RR'),'1790',null,'417');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8703','DANTE FEDERICO','MANAGER','4724',to_date('09-JUN-81','DD-MON-RR'),'25',null,'265');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8704','FO UGO','SUPERVISOR','483',to_date('09-JUN-81','DD-MON-RR'),'1666',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8705','DANTE IVANO','PHDSTUDENT','3031',to_date('09-JUN-81','DD-MON-RR'),'1946',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8706','ECO LUDOVICO','LAWYER','2952',to_date('09-JUN-81','DD-MON-RR'),'1128',null,'81');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8707','TIBALDI LUCIA','SUPERVISOR','6645',to_date('09-JUN-81','DD-MON-RR'),'303',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8708','ESPOSITO GIOVANNI','TECHNICIAN','3495',to_date('09-JUN-81','DD-MON-RR'),'20',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8709','COZZA CLARA','MANAGER','4239',to_date('09-JUN-81','DD-MON-RR'),'1781',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8710','TIBALDI ELENA','MANAGER','6837',to_date('09-JUN-81','DD-MON-RR'),'566',null,'80');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8711','CALVINO UGO','HEADMASTER','5943',to_date('09-JUN-81','DD-MON-RR'),'1987',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8712','NERI FRANCESCO','SUPERVISOR','1280',to_date('09-JUN-81','DD-MON-RR'),'1157',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8713','COZZA MARIO','ENGINEER','852',to_date('09-JUN-81','DD-MON-RR'),'1159',null,'118');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8714','SANTE PASQUALE','MANAGER','3285',to_date('09-JUN-81','DD-MON-RR'),'1998',null,'481');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8715','CARBONE DAMIANO','SECRETARY','7927',to_date('09-JUN-81','DD-MON-RR'),'1608',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8716','DANTE ANDREA','ENGINEER','2688',to_date('09-JUN-81','DD-MON-RR'),'946',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8717','CALVINO CLARA','MANAGER','6261',to_date('09-JUN-81','DD-MON-RR'),'931',null,'111');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8718','NERI MARIO','SECRETARY','6136',to_date('09-JUN-81','DD-MON-RR'),'1814',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8719','CALVINO PAOLO','PHDSTUDENT','106',to_date('09-JUN-81','DD-MON-RR'),'298',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8720','TIBALDI COSIMO','MANAGER','7599',to_date('09-JUN-81','DD-MON-RR'),'1562',null,'158');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8721','FUMAROLA ANGELO','ENGINEER','7736',to_date('09-JUN-81','DD-MON-RR'),'320',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8722','MANZONI ANGELO','SECRETARY','3145',to_date('09-JUN-81','DD-MON-RR'),'1979',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8723','ECO MASSIMO','SUPERVISOR','8601',to_date('09-JUN-81','DD-MON-RR'),'341',null,'40');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8724','FUMAROLA ANGELO','HEADMASTER','4025',to_date('09-JUN-81','DD-MON-RR'),'247',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8725','CALVINO PASQUALE','ENGINEER','4073',to_date('09-JUN-81','DD-MON-RR'),'1939',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8726','FO UMBERTO','MANAGER','7767',to_date('09-JUN-81','DD-MON-RR'),'1817',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8727','CARBONE ROBERTA','MANAGER','3225',to_date('09-JUN-81','DD-MON-RR'),'1970',null,'464');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8728','SANTE ANTONIO','PROFESSOR','7934',to_date('09-JUN-81','DD-MON-RR'),'1111',null,'283');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8729','NERI GIOVANNI','MANAGER','7376',to_date('09-JUN-81','DD-MON-RR'),'1969',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8730','CARBONE CLARA','MANAGER','6317',to_date('09-JUN-81','DD-MON-RR'),'812',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8731','LEOPARDI UMBERTO','MANAGER','7756',to_date('09-JUN-81','DD-MON-RR'),'158',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8732','PETRARCA ALFONSO','PHDSTUDENT','4337',to_date('09-JUN-81','DD-MON-RR'),'1838',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8733','CALVINO GIOVANNI','LAWYER','7182',to_date('09-JUN-81','DD-MON-RR'),'1126',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8734','FUMAROLA DONATO','HEADMASTER','599',to_date('09-JUN-81','DD-MON-RR'),'798',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8735','PETRARCA LUDOVICO','LAWYER','6745',to_date('09-JUN-81','DD-MON-RR'),'1942',null,'194');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8736','COZZA MARIA','PHDSTUDENT','4672',to_date('09-JUN-81','DD-MON-RR'),'479',null,'329');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8737','ESPOSITO UGO','PHDSTUDENT','6649',to_date('09-JUN-81','DD-MON-RR'),'586',null,'63');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8738','CARBONE LUCA','PROFESSOR','1329',to_date('09-JUN-81','DD-MON-RR'),'1083',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8739','LEVI SILVIA','SUPERVISOR','6532',to_date('09-JUN-81','DD-MON-RR'),'0',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8740','FO LUIGI','LAWYER','6772',to_date('09-JUN-81','DD-MON-RR'),'1287',null,'258');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8741','COZZA CLARA','MANAGER','6498',to_date('09-JUN-81','DD-MON-RR'),'1642',null,'53');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8742','COZZA ALFONSO','TECHNICIAN','5333',to_date('09-JUN-81','DD-MON-RR'),'1836',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8743','DANTE IVANO','PHDSTUDENT','4542',to_date('09-JUN-81','DD-MON-RR'),'484',null,'229');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8744','BIANCHI SILVIA','LAWYER','6673',to_date('09-JUN-81','DD-MON-RR'),'1355',null,'195');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8745','TIBALDI ELENA','LAWYER','5304',to_date('09-JUN-81','DD-MON-RR'),'488',null,'453');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8746','SANTE GIOVANNI','MANAGER','8669',to_date('09-JUN-81','DD-MON-RR'),'304',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8747','LEVI FRANCESCO','SUPERVISOR','28',to_date('09-JUN-81','DD-MON-RR'),'328',null,'44');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8748','PETRARCA ELENA','MANAGER','1033',to_date('09-JUN-81','DD-MON-RR'),'843',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8749','CALVINO FRANCESCO','SECRETARY','8469',to_date('09-JUN-81','DD-MON-RR'),'98',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8750','SANTE FEDERICO','SUPERVISOR','5442',to_date('09-JUN-81','DD-MON-RR'),'1433',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8751','CORONA LUIGI','TECHNICIAN','6319',to_date('09-JUN-81','DD-MON-RR'),'1662',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8752','CALVINO COSIMO','PHDSTUDENT','7953',to_date('09-JUN-81','DD-MON-RR'),'1867',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8753','LEVI LUIGI','MANAGER','1563',to_date('09-JUN-81','DD-MON-RR'),'505',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8754','CARBONE DONATO','ENGINEER','8341',to_date('09-JUN-81','DD-MON-RR'),'1596',null,'340');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8755','FUMAROLA LUIGI','LAWYER','4224',to_date('09-JUN-81','DD-MON-RR'),'1558',null,'254');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8756','FO ANTONIO','LAWYER','3319',to_date('09-JUN-81','DD-MON-RR'),'60',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8757','SANTE COSIMO','MANAGER','4757',to_date('09-JUN-81','DD-MON-RR'),'1351',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8758','MANZONI LUCA','HEADMASTER','4307',to_date('09-JUN-81','DD-MON-RR'),'1706',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8759','LEVI PASQUALE','LAWYER','4126',to_date('09-JUN-81','DD-MON-RR'),'813',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8760','NERI GIOVANNI','SUPERVISOR','8275',to_date('09-JUN-81','DD-MON-RR'),'1744',null,'497');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8761','MANZONI IVANO','MANAGER','7025',to_date('09-JUN-81','DD-MON-RR'),'955',null,'166');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8762','ESPOSITO LUCA','PROFESSOR','805',to_date('09-JUN-81','DD-MON-RR'),'1410',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8763','ESPOSITO ANDREA','LAWYER','2749',to_date('09-JUN-81','DD-MON-RR'),'1526',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8764','TIBALDI ELENA','MANAGER','49',to_date('09-JUN-81','DD-MON-RR'),'146',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8765','COZZA LUCIA','PROFESSOR','2461',to_date('09-JUN-81','DD-MON-RR'),'341',null,'213');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8766','ECO IVANO','LAWYER','5085',to_date('09-JUN-81','DD-MON-RR'),'851',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8767','CALVINO ELENA','SUPERVISOR','131',to_date('09-JUN-81','DD-MON-RR'),'998',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8768','GRIMALDI UGO','MANAGER','2134',to_date('09-JUN-81','DD-MON-RR'),'1897',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8769','DANTE PASQUALE','HEADMASTER','2691',to_date('09-JUN-81','DD-MON-RR'),'1398',null,'289');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8770','COZZA ELENA','TECHNICIAN','238',to_date('09-JUN-81','DD-MON-RR'),'89',null,'488');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8771','GRIMALDI PASQUALE','SECRETARY','8594',to_date('09-JUN-81','DD-MON-RR'),'1802',null,'12');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8772','CARBONE IVANO','SECRETARY','1297',to_date('09-JUN-81','DD-MON-RR'),'1660',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8773','CARBONE ROBERTA','MANAGER','1398',to_date('09-JUN-81','DD-MON-RR'),'1731',null,'258');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8774','BIANCHI CLARA','PROFESSOR','5009',to_date('09-JUN-81','DD-MON-RR'),'1441',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8775','BIANCHI LUCA','SUPERVISOR','8391',to_date('09-JUN-81','DD-MON-RR'),'440',null,'358');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8776','ECO ANDREA','PHDSTUDENT','4674',to_date('09-JUN-81','DD-MON-RR'),'1308',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8777','ECO LUCA','PROFESSOR','8704',to_date('09-JUN-81','DD-MON-RR'),'1570',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7849','CALVINO DAMIANO','LAWYER','3997',to_date('09-JUN-81','DD-MON-RR'),'363',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7850','TIBALDI CLARA','HEADMASTER','7210',to_date('09-JUN-81','DD-MON-RR'),'690',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7851','ESPOSITO ELENA','LAWYER','4496',to_date('09-JUN-81','DD-MON-RR'),'527',null,'145');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7852','NERI ELENA','LAWYER','531',to_date('09-JUN-81','DD-MON-RR'),'1488',null,'169');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7853','CARBONE FRANCESCO','PROFESSOR','7208',to_date('09-JUN-81','DD-MON-RR'),'1866',null,'287');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7854','ESPOSITO DONATO','ENGINEER','1303',to_date('09-JUN-81','DD-MON-RR'),'1837',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7855','CALVINO MARIA','SECRETARY','3295',to_date('09-JUN-81','DD-MON-RR'),'1522',null,'3');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7856','ECO MASSIMO','PHDSTUDENT','7504',to_date('09-JUN-81','DD-MON-RR'),'796',null,'19');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7857','TIBALDI ALFONSO','SUPERVISOR','3120',to_date('09-JUN-81','DD-MON-RR'),'302',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7858','BIANCHI DAMIANO','TECHNICIAN','1124',to_date('09-JUN-81','DD-MON-RR'),'154',null,'412');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7859','BIANCHI LUDOVICO','PHDSTUDENT','5630',to_date('09-JUN-81','DD-MON-RR'),'629',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7860','CORONA PAOLO','ENGINEER','4379',to_date('09-JUN-81','DD-MON-RR'),'1950',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7861','CORONA ANDREA','PROFESSOR','2666',to_date('09-JUN-81','DD-MON-RR'),'1547',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7862','GRIMALDI PAOLO','SUPERVISOR','1410',to_date('09-JUN-81','DD-MON-RR'),'834',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7863','DANTE LUIGI','SUPERVISOR','4847',to_date('09-JUN-81','DD-MON-RR'),'592',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7864','ECO PASQUALE','LAWYER','5302',to_date('09-JUN-81','DD-MON-RR'),'1463',null,'457');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7865','DANTE LUCA','PHDSTUDENT','6459',to_date('09-JUN-81','DD-MON-RR'),'369',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7866','TIBALDI CLARA','SUPERVISOR','1248',to_date('09-JUN-81','DD-MON-RR'),'176',null,'19');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7867','LEVI UGO','SECRETARY','1589',to_date('09-JUN-81','DD-MON-RR'),'1291',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7868','GRIMALDI FRANCESCO','SUPERVISOR','6226',to_date('09-JUN-81','DD-MON-RR'),'1974',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7869','CORONA ANDREA','PHDSTUDENT','6640',to_date('09-JUN-81','DD-MON-RR'),'204',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7870','FUMAROLA FRANCESCO','PROFESSOR','1808',to_date('09-JUN-81','DD-MON-RR'),'1500',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7871','LEVI GIOVANNI','LAWYER','7403',to_date('09-JUN-81','DD-MON-RR'),'971',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7872','FO LUCIA','PROFESSOR','293',to_date('09-JUN-81','DD-MON-RR'),'1652',null,'217');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7873','FO PAOLO','HEADMASTER','1122',to_date('09-JUN-81','DD-MON-RR'),'69',null,'396');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7874','NERI ELIO','LAWYER','75',to_date('09-JUN-81','DD-MON-RR'),'244',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7875','PETRARCA DAMIANO','LAWYER','7746',to_date('09-JUN-81','DD-MON-RR'),'221',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7876','CORONA FEDERICO','ENGINEER','5546',to_date('09-JUN-81','DD-MON-RR'),'1454',null,'407');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7877','GRIMALDI CLARA','PROFESSOR','6434',to_date('09-JUN-81','DD-MON-RR'),'1487',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7878','FUMAROLA ELENA','SECRETARY','454',to_date('09-JUN-81','DD-MON-RR'),'798',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2447','COZZA UGO','TECHNICIAN','1342',to_date('09-JUN-81','DD-MON-RR'),'1867',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2448','SANTE UMBERTO','ENGINEER','2126',to_date('09-JUN-81','DD-MON-RR'),'1639',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2449','CARBONE GIOVANNI','TECHNICIAN','2270',to_date('09-JUN-81','DD-MON-RR'),'1095',null,'254');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2450','CORONA ANGELO','MANAGER','2375',to_date('09-JUN-81','DD-MON-RR'),'476',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2451','FUMAROLA DONATO','SUPERVISOR','2049',to_date('09-JUN-81','DD-MON-RR'),'1080',null,'132');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2452','CALVINO ANTONIO','SUPERVISOR','2260',to_date('09-JUN-81','DD-MON-RR'),'1219',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2453','PETRARCA LUDOVICO','TECHNICIAN','365',to_date('09-JUN-81','DD-MON-RR'),'1177',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2454','MANZONI LUCIA','MANAGER','305',to_date('09-JUN-81','DD-MON-RR'),'838',null,'318');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2455','CALVINO DONATO','MANAGER','1862',to_date('09-JUN-81','DD-MON-RR'),'1082',null,'33');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2456','ECO LUCIA','ENGINEER','575',to_date('09-JUN-81','DD-MON-RR'),'1533',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2457','LEVI IVANO','HEADMASTER','1916',to_date('09-JUN-81','DD-MON-RR'),'1019',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2458','COZZA GIOVANNI','MANAGER','2261',to_date('09-JUN-81','DD-MON-RR'),'836',null,'428');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2459','FO LUIGI','PROFESSOR','1853',to_date('09-JUN-81','DD-MON-RR'),'1237',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2460','PETRARCA PASQUALE','SUPERVISOR','536',to_date('09-JUN-81','DD-MON-RR'),'22',null,'441');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2461','FO COSIMO','HEADMASTER','1532',to_date('09-JUN-81','DD-MON-RR'),'371',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2462','CALVINO FRANCESCO','PHDSTUDENT','1086',to_date('09-JUN-81','DD-MON-RR'),'928',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2463','CALVINO ROBERTA','MANAGER','639',to_date('09-JUN-81','DD-MON-RR'),'758',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2464','CARBONE COSIMO','PROFESSOR','1153',to_date('09-JUN-81','DD-MON-RR'),'1596',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2465','MANZONI IVANO','PHDSTUDENT','1428',to_date('09-JUN-81','DD-MON-RR'),'811',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2466','MANZONI MARIA','TECHNICIAN','680',to_date('09-JUN-81','DD-MON-RR'),'625',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2467','GRIMALDI ELIO','MANAGER','60',to_date('09-JUN-81','DD-MON-RR'),'511',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2468','FO ANDREA','SUPERVISOR','1603',to_date('09-JUN-81','DD-MON-RR'),'1012',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2469','LEVI ELENA','LAWYER','2158',to_date('09-JUN-81','DD-MON-RR'),'183',null,'354');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2470','SANTE COSIMO','SECRETARY','204',to_date('09-JUN-81','DD-MON-RR'),'1817',null,'151');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2471','COZZA ANDREA','MANAGER','1281',to_date('09-JUN-81','DD-MON-RR'),'1294',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2472','ESPOSITO COSIMO','PROFESSOR','2378',to_date('09-JUN-81','DD-MON-RR'),'1056',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2473','GRIMALDI GIOVANNI','TECHNICIAN','1182',to_date('09-JUN-81','DD-MON-RR'),'1761',null,'64');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2474','ECO LUIGI','MANAGER','632',to_date('09-JUN-81','DD-MON-RR'),'1539',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2475','CALVINO PAOLO','MANAGER','2133',to_date('09-JUN-81','DD-MON-RR'),'410',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2476','NERI MARIA','HEADMASTER','391',to_date('09-JUN-81','DD-MON-RR'),'1097',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2477','LEOPARDI LUIGI','PROFESSOR','1447',to_date('09-JUN-81','DD-MON-RR'),'1818',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2478','FO ANDREA','PHDSTUDENT','1445',to_date('09-JUN-81','DD-MON-RR'),'755',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2479','CALVINO FRANCESCO','MANAGER','1150',to_date('09-JUN-81','DD-MON-RR'),'1956',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2480','BIANCHI SILVIA','LAWYER','1194',to_date('09-JUN-81','DD-MON-RR'),'1610',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2481','DANTE DONATO','SECRETARY','44',to_date('09-JUN-81','DD-MON-RR'),'256',null,'407');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2482','NERI LUCA','TECHNICIAN','1794',to_date('09-JUN-81','DD-MON-RR'),'353',null,'335');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2483','TIBALDI LUCA','MANAGER','541',to_date('09-JUN-81','DD-MON-RR'),'1440',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2484','NERI MARIO','HEADMASTER','1491',to_date('09-JUN-81','DD-MON-RR'),'1792',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2485','CALVINO PAOLO','PROFESSOR','1342',to_date('09-JUN-81','DD-MON-RR'),'1371',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2486','PETRARCA GIOVANNI','HEADMASTER','104',to_date('09-JUN-81','DD-MON-RR'),'536',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2487','ESPOSITO UGO','SECRETARY','1535',to_date('09-JUN-81','DD-MON-RR'),'220',null,'132');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2488','NERI LUIGI','LAWYER','2134',to_date('09-JUN-81','DD-MON-RR'),'367',null,'61');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2489','LEVI LUCIA','MANAGER','1185',to_date('09-JUN-81','DD-MON-RR'),'491',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2490','ESPOSITO ALFONSO','PHDSTUDENT','1785',to_date('09-JUN-81','DD-MON-RR'),'590',null,'170');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2491','LEOPARDI FRANCESCO','HEADMASTER','1200',to_date('09-JUN-81','DD-MON-RR'),'226',null,'429');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2492','ECO FRANCESCO','PROFESSOR','164',to_date('09-JUN-81','DD-MON-RR'),'1174',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2493','ECO MARIA','SECRETARY','1827',to_date('09-JUN-81','DD-MON-RR'),'1465',null,'253');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2494','FO FEDERICO','MANAGER','1022',to_date('09-JUN-81','DD-MON-RR'),'29',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2495','BIANCHI PASQUALE','SECRETARY','1286',to_date('09-JUN-81','DD-MON-RR'),'1713',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2496','GRIMALDI LUCIA','PROFESSOR','1118',to_date('09-JUN-81','DD-MON-RR'),'905',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2497','CARBONE IVANO','MANAGER','1384',to_date('09-JUN-81','DD-MON-RR'),'993',null,'93');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2498','CARBONE FEDERICO','MANAGER','585',to_date('09-JUN-81','DD-MON-RR'),'1120',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2499','NERI IVANO','MANAGER','2229',to_date('09-JUN-81','DD-MON-RR'),'1651',null,'174');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2500','SANTE ELIO','SUPERVISOR','1103',to_date('09-JUN-81','DD-MON-RR'),'403',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2501','TIBALDI CLARA','LAWYER','1016',to_date('09-JUN-81','DD-MON-RR'),'1013',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2502','ECO ANTONIO','SUPERVISOR','1597',to_date('09-JUN-81','DD-MON-RR'),'737',null,'347');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2503','CORONA ANDREA','SUPERVISOR','2225',to_date('09-JUN-81','DD-MON-RR'),'1030',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2504','CALVINO FEDERICO','LAWYER','45',to_date('09-JUN-81','DD-MON-RR'),'295',null,'162');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2505','GRIMALDI ALFONSO','MANAGER','2140',to_date('09-JUN-81','DD-MON-RR'),'1757',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2506','MANZONI GAETANO','SECRETARY','1290',to_date('09-JUN-81','DD-MON-RR'),'346',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2507','FO PAOLO','SECRETARY','1207',to_date('09-JUN-81','DD-MON-RR'),'1699',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2508','COZZA ELIO','LAWYER','1755',to_date('09-JUN-81','DD-MON-RR'),'1130',null,'378');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2509','ECO LUIGI','HEADMASTER','705',to_date('09-JUN-81','DD-MON-RR'),'535',null,'80');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2510','PETRARCA GAETANO','HEADMASTER','1545',to_date('09-JUN-81','DD-MON-RR'),'977',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2511','ESPOSITO DAMIANO','MANAGER','247',to_date('09-JUN-81','DD-MON-RR'),'405',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2512','CARBONE LUDOVICO','SUPERVISOR','1175',to_date('09-JUN-81','DD-MON-RR'),'1935',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2513','GRIMALDI GAETANO','MANAGER','1684',to_date('09-JUN-81','DD-MON-RR'),'1689',null,'359');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2514','COZZA UMBERTO','MANAGER','1104',to_date('09-JUN-81','DD-MON-RR'),'1817',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2515','GRIMALDI FEDERICO','LAWYER','496',to_date('09-JUN-81','DD-MON-RR'),'259',null,'179');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2516','GRIMALDI LUDOVICO','LAWYER','2305',to_date('09-JUN-81','DD-MON-RR'),'112',null,'124');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2517','CARBONE UGO','SUPERVISOR','2417',to_date('09-JUN-81','DD-MON-RR'),'800',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2518','ESPOSITO ANDREA','HEADMASTER','1488',to_date('09-JUN-81','DD-MON-RR'),'999',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2519','GRIMALDI MASSIMO','PROFESSOR','699',to_date('09-JUN-81','DD-MON-RR'),'732',null,'114');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2520','LEOPARDI LUDOVICO','PROFESSOR','965',to_date('09-JUN-81','DD-MON-RR'),'326',null,'436');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2521','CORONA ALFONSO','TECHNICIAN','1986',to_date('09-JUN-81','DD-MON-RR'),'1506',null,'443');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2522','SANTE ROBERTA','SUPERVISOR','1948',to_date('09-JUN-81','DD-MON-RR'),'92',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2523','CORONA DAMIANO','PHDSTUDENT','816',to_date('09-JUN-81','DD-MON-RR'),'149',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2524','GRIMALDI LUCIA','SECRETARY','849',to_date('09-JUN-81','DD-MON-RR'),'1324',null,'420');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2525','FUMAROLA LUIGI','SECRETARY','780',to_date('09-JUN-81','DD-MON-RR'),'1118',null,'484');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2526','ECO DONATO','HEADMASTER','31',to_date('09-JUN-81','DD-MON-RR'),'177',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2527','ECO UGO','SECRETARY','1813',to_date('09-JUN-81','DD-MON-RR'),'1797',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2528','SANTE LUIGI','MANAGER','2490',to_date('09-JUN-81','DD-MON-RR'),'1395',null,'125');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2529','SANTE LUDOVICO','PHDSTUDENT','21',to_date('09-JUN-81','DD-MON-RR'),'101',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2530','NERI COSIMO','ENGINEER','1660',to_date('09-JUN-81','DD-MON-RR'),'1851',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2531','CORONA DONATO','SECRETARY','1095',to_date('09-JUN-81','DD-MON-RR'),'239',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2532','BIANCHI PASQUALE','PHDSTUDENT','1615',to_date('09-JUN-81','DD-MON-RR'),'1472',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2533','LEOPARDI MASSIMO','MANAGER','1279',to_date('09-JUN-81','DD-MON-RR'),'1315',null,'259');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2534','PETRARCA CLARA','TECHNICIAN','989',to_date('09-JUN-81','DD-MON-RR'),'399',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2535','CORONA LUCA','SECRETARY','409',to_date('09-JUN-81','DD-MON-RR'),'1411',null,'412');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2536','FUMAROLA LUCIA','ENGINEER','1339',to_date('09-JUN-81','DD-MON-RR'),'1529',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2537','ESPOSITO ELENA','LAWYER','1267',to_date('09-JUN-81','DD-MON-RR'),'790',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2538','MANZONI UGO','LAWYER','1951',to_date('09-JUN-81','DD-MON-RR'),'459',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2539','LEOPARDI ALFONSO','MANAGER','1324',to_date('09-JUN-81','DD-MON-RR'),'751',null,'264');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2540','COZZA ANTONIO','PROFESSOR','1792',to_date('09-JUN-81','DD-MON-RR'),'450',null,'142');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2541','PETRARCA LUCIA','MANAGER','1181',to_date('09-JUN-81','DD-MON-RR'),'1895',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2542','ESPOSITO MARIA','SECRETARY','1498',to_date('09-JUN-81','DD-MON-RR'),'796',null,'267');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2543','ESPOSITO MARIO','ENGINEER','2231',to_date('09-JUN-81','DD-MON-RR'),'229',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2544','CALVINO FEDERICO','SUPERVISOR','878',to_date('09-JUN-81','DD-MON-RR'),'1849',null,'425');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2545','DANTE DONATO','PROFESSOR','1154',to_date('09-JUN-81','DD-MON-RR'),'871',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2546','BIANCHI ELENA','MANAGER','904',to_date('09-JUN-81','DD-MON-RR'),'865',null,'253');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2547','CARBONE LUCA','MANAGER','2231',to_date('09-JUN-81','DD-MON-RR'),'1080',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2548','ESPOSITO LUDOVICO','PHDSTUDENT','1706',to_date('09-JUN-81','DD-MON-RR'),'1629',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2549','GRIMALDI LUDOVICO','PROFESSOR','1615',to_date('09-JUN-81','DD-MON-RR'),'352',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2550','SANTE MARIA','MANAGER','1015',to_date('09-JUN-81','DD-MON-RR'),'1009',null,'378');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2551','PETRARCA MARIA','TECHNICIAN','247',to_date('09-JUN-81','DD-MON-RR'),'1196',null,'78');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2552','NERI DONATO','ENGINEER','22',to_date('09-JUN-81','DD-MON-RR'),'423',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2553','FO ANTONIO','PROFESSOR','2454',to_date('09-JUN-81','DD-MON-RR'),'584',null,'200');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2554','CALVINO MARIO','PHDSTUDENT','2276',to_date('09-JUN-81','DD-MON-RR'),'169',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2555','MANZONI UMBERTO','TECHNICIAN','2053',to_date('09-JUN-81','DD-MON-RR'),'1934',null,'481');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2556','CARBONE LUCA','PHDSTUDENT','729',to_date('09-JUN-81','DD-MON-RR'),'1204',null,'402');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2557','NERI ALFONSO','ENGINEER','1407',to_date('09-JUN-81','DD-MON-RR'),'429',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2558','MANZONI ELENA','PROFESSOR','2006',to_date('09-JUN-81','DD-MON-RR'),'1976',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2559','MANZONI GAETANO','ENGINEER','1065',to_date('09-JUN-81','DD-MON-RR'),'209',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2560','ESPOSITO FEDERICO','LAWYER','722',to_date('09-JUN-81','DD-MON-RR'),'781',null,'169');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2561','GRIMALDI ROBERTA','PROFESSOR','1155',to_date('09-JUN-81','DD-MON-RR'),'474',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2562','SANTE LUCIA','MANAGER','1013',to_date('09-JUN-81','DD-MON-RR'),'460',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2563','GRIMALDI LUCIA','MANAGER','1850',to_date('09-JUN-81','DD-MON-RR'),'426',null,'441');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2564','LEOPARDI FEDERICO','PHDSTUDENT','1810',to_date('09-JUN-81','DD-MON-RR'),'1630',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2565','COZZA COSIMO','LAWYER','2258',to_date('09-JUN-81','DD-MON-RR'),'1842',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2566','LEVI UMBERTO','LAWYER','164',to_date('09-JUN-81','DD-MON-RR'),'1234',null,'183');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2567','CORONA GIOVANNI','PROFESSOR','419',to_date('09-JUN-81','DD-MON-RR'),'537',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2568','LEVI PASQUALE','ENGINEER','2375',to_date('09-JUN-81','DD-MON-RR'),'1476',null,'459');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2569','CARBONE DAMIANO','TECHNICIAN','2319',to_date('09-JUN-81','DD-MON-RR'),'865',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2570','TIBALDI IVANO','HEADMASTER','2289',to_date('09-JUN-81','DD-MON-RR'),'1644',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2571','LEVI SILVIA','PROFESSOR','513',to_date('09-JUN-81','DD-MON-RR'),'212',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2572','ESPOSITO FEDERICO','ENGINEER','1579',to_date('09-JUN-81','DD-MON-RR'),'1561',null,'309');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2573','GRIMALDI CLARA','LAWYER','1538',to_date('09-JUN-81','DD-MON-RR'),'1472',null,'187');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2574','CALVINO ANDREA','ENGINEER','2153',to_date('09-JUN-81','DD-MON-RR'),'893',null,'267');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2575','CALVINO UGO','MANAGER','1913',to_date('09-JUN-81','DD-MON-RR'),'881',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2576','TIBALDI GAETANO','MANAGER','766',to_date('09-JUN-81','DD-MON-RR'),'1419',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2577','FUMAROLA FRANCESCO','SUPERVISOR','324',to_date('09-JUN-81','DD-MON-RR'),'1781',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2578','ESPOSITO DONATO','HEADMASTER','984',to_date('09-JUN-81','DD-MON-RR'),'760',null,'196');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2579','TIBALDI ANGELO','MANAGER','2212',to_date('09-JUN-81','DD-MON-RR'),'1470',null,'191');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2580','COZZA FEDERICO','PROFESSOR','2240',to_date('09-JUN-81','DD-MON-RR'),'897',null,'186');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2581','ESPOSITO ALFONSO','PHDSTUDENT','1310',to_date('09-JUN-81','DD-MON-RR'),'366',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4478','ECO ANTONIO','SECRETARY','436',to_date('09-JUN-81','DD-MON-RR'),'557',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4479','FO FEDERICO','LAWYER','3965',to_date('09-JUN-81','DD-MON-RR'),'436',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4480','COZZA PAOLO','PROFESSOR','2660',to_date('09-JUN-81','DD-MON-RR'),'241',null,'122');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4481','MANZONI FRANCESCO','MANAGER','164',to_date('09-JUN-81','DD-MON-RR'),'281',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4482','CORONA SILVIA','SUPERVISOR','2330',to_date('09-JUN-81','DD-MON-RR'),'1610',null,'459');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4483','DANTE UGO','PROFESSOR','3890',to_date('09-JUN-81','DD-MON-RR'),'452',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4484','SANTE ELIO','SECRETARY','1046',to_date('09-JUN-81','DD-MON-RR'),'1149',null,'376');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4485','FO ANTONIO','MANAGER','1724',to_date('09-JUN-81','DD-MON-RR'),'1222',null,'39');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4486','SANTE GAETANO','SECRETARY','4280',to_date('09-JUN-81','DD-MON-RR'),'371',null,'162');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4487','CARBONE UGO','PROFESSOR','2508',to_date('09-JUN-81','DD-MON-RR'),'423',null,'197');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4488','FO ANGELO','MANAGER','3810',to_date('09-JUN-81','DD-MON-RR'),'1625',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4489','PETRARCA CLARA','SECRETARY','156',to_date('09-JUN-81','DD-MON-RR'),'256',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4490','CALVINO PAOLO','TECHNICIAN','3353',to_date('09-JUN-81','DD-MON-RR'),'1017',null,'321');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4491','PETRARCA ELENA','MANAGER','46',to_date('09-JUN-81','DD-MON-RR'),'183',null,'488');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4492','LEVI DAMIANO','PHDSTUDENT','4157',to_date('09-JUN-81','DD-MON-RR'),'1697',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4493','GRIMALDI ELIO','PHDSTUDENT','3794',to_date('09-JUN-81','DD-MON-RR'),'351',null,'319');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4494','CALVINO MARIO','HEADMASTER','153',to_date('09-JUN-81','DD-MON-RR'),'1418',null,'331');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4495','PETRARCA GIOVANNI','SECRETARY','359',to_date('09-JUN-81','DD-MON-RR'),'490',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4496','LEOPARDI LUDOVICO','LAWYER','2312',to_date('09-JUN-81','DD-MON-RR'),'162',null,'262');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4497','BIANCHI ANDREA','MANAGER','724',to_date('09-JUN-81','DD-MON-RR'),'684',null,'331');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4498','BIANCHI LUDOVICO','PROFESSOR','3906',to_date('09-JUN-81','DD-MON-RR'),'1015',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4499','ECO DAMIANO','LAWYER','185',to_date('09-JUN-81','DD-MON-RR'),'273',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4500','ESPOSITO UGO','PHDSTUDENT','2203',to_date('09-JUN-81','DD-MON-RR'),'529',null,'145');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4501','ECO LUIGI','MANAGER','976',to_date('09-JUN-81','DD-MON-RR'),'1003',null,'221');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4502','ESPOSITO ANDREA','MANAGER','2496',to_date('09-JUN-81','DD-MON-RR'),'308',null,'101');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4503','PETRARCA FEDERICO','PROFESSOR','927',to_date('09-JUN-81','DD-MON-RR'),'130',null,'186');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4504','CARBONE PASQUALE','HEADMASTER','944',to_date('09-JUN-81','DD-MON-RR'),'1227',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4505','MANZONI FEDERICO','TECHNICIAN','3625',to_date('09-JUN-81','DD-MON-RR'),'1614',null,'31');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4506','TIBALDI LUCIA','LAWYER','2067',to_date('09-JUN-81','DD-MON-RR'),'1616',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4507','LEVI GAETANO','TECHNICIAN','3442',to_date('09-JUN-81','DD-MON-RR'),'207',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4508','DANTE COSIMO','MANAGER','3756',to_date('09-JUN-81','DD-MON-RR'),'1053',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4509','FO FRANCESCO','SUPERVISOR','3081',to_date('09-JUN-81','DD-MON-RR'),'214',null,'74');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4510','MANZONI DONATO','LAWYER','423',to_date('09-JUN-81','DD-MON-RR'),'1339',null,'136');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4511','PETRARCA MASSIMO','HEADMASTER','931',to_date('09-JUN-81','DD-MON-RR'),'450',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4512','FUMAROLA FRANCESCO','SECRETARY','1369',to_date('09-JUN-81','DD-MON-RR'),'1783',null,'162');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4513','CARBONE UGO','MANAGER','4060',to_date('09-JUN-81','DD-MON-RR'),'1384',null,'86');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4514','FO ANDREA','MANAGER','1787',to_date('09-JUN-81','DD-MON-RR'),'1166',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4515','CARBONE LUCA','SUPERVISOR','44',to_date('09-JUN-81','DD-MON-RR'),'1946',null,'356');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4516','ESPOSITO LUDOVICO','ENGINEER','663',to_date('09-JUN-81','DD-MON-RR'),'672',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4517','COZZA DONATO','PHDSTUDENT','187',to_date('09-JUN-81','DD-MON-RR'),'796',null,'362');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4518','CALVINO FRANCESCO','MANAGER','63',to_date('09-JUN-81','DD-MON-RR'),'602',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4519','NERI ANTONIO','SECRETARY','1170',to_date('09-JUN-81','DD-MON-RR'),'1117',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4520','SANTE LUCIA','SECRETARY','2175',to_date('09-JUN-81','DD-MON-RR'),'225',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4521','LEVI LUIGI','LAWYER','3050',to_date('09-JUN-81','DD-MON-RR'),'1084',null,'38');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4522','CALVINO IVANO','SECRETARY','963',to_date('09-JUN-81','DD-MON-RR'),'806',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4523','MANZONI PAOLO','MANAGER','2362',to_date('09-JUN-81','DD-MON-RR'),'1569',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4524','NERI MASSIMO','LAWYER','4410',to_date('09-JUN-81','DD-MON-RR'),'463',null,'497');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4525','ECO ALFONSO','PROFESSOR','1685',to_date('09-JUN-81','DD-MON-RR'),'300',null,'105');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4526','NERI UMBERTO','TECHNICIAN','3284',to_date('09-JUN-81','DD-MON-RR'),'39',null,'74');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4527','PETRARCA LUDOVICO','SUPERVISOR','4420',to_date('09-JUN-81','DD-MON-RR'),'1225',null,'457');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4528','LEOPARDI LUCA','HEADMASTER','2357',to_date('09-JUN-81','DD-MON-RR'),'146',null,'234');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4529','FUMAROLA FEDERICO','PHDSTUDENT','1050',to_date('09-JUN-81','DD-MON-RR'),'1693',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4530','MANZONI DAMIANO','HEADMASTER','1479',to_date('09-JUN-81','DD-MON-RR'),'1906',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4531','NERI MASSIMO','SECRETARY','659',to_date('09-JUN-81','DD-MON-RR'),'1326',null,'428');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4532','SANTE ELENA','PROFESSOR','3653',to_date('09-JUN-81','DD-MON-RR'),'886',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4533','CALVINO PASQUALE','SECRETARY','1837',to_date('09-JUN-81','DD-MON-RR'),'1023',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4534','LEVI LUCIA','SUPERVISOR','1435',to_date('09-JUN-81','DD-MON-RR'),'1077',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4535','TIBALDI ANGELO','MANAGER','1508',to_date('09-JUN-81','DD-MON-RR'),'186',null,'374');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4536','BIANCHI LUCIA','TECHNICIAN','3010',to_date('09-JUN-81','DD-MON-RR'),'1554',null,'174');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4537','DANTE LUDOVICO','ENGINEER','3536',to_date('09-JUN-81','DD-MON-RR'),'1756',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4538','MANZONI PASQUALE','SUPERVISOR','325',to_date('09-JUN-81','DD-MON-RR'),'7',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4539','FUMAROLA UMBERTO','TECHNICIAN','4238',to_date('09-JUN-81','DD-MON-RR'),'390',null,'304');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4540','CALVINO PASQUALE','ENGINEER','4280',to_date('09-JUN-81','DD-MON-RR'),'1036',null,'234');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4541','GRIMALDI ELENA','SECRETARY','1711',to_date('09-JUN-81','DD-MON-RR'),'15',null,'438');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4542','FUMAROLA COSIMO','HEADMASTER','2461',to_date('09-JUN-81','DD-MON-RR'),'617',null,'413');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4543','LEVI ANTONIO','SUPERVISOR','236',to_date('09-JUN-81','DD-MON-RR'),'60',null,'214');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4544','CALVINO ANDREA','ENGINEER','4017',to_date('09-JUN-81','DD-MON-RR'),'1062',null,'251');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4545','SANTE GAETANO','ENGINEER','3941',to_date('09-JUN-81','DD-MON-RR'),'1243',null,'103');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4546','CORONA FRANCESCO','SECRETARY','1978',to_date('09-JUN-81','DD-MON-RR'),'1379',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4547','CARBONE MARIO','SUPERVISOR','1186',to_date('09-JUN-81','DD-MON-RR'),'1915',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4548','FUMAROLA FRANCESCO','HEADMASTER','2334',to_date('09-JUN-81','DD-MON-RR'),'1622',null,'192');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4549','CARBONE CLARA','MANAGER','1140',to_date('09-JUN-81','DD-MON-RR'),'1019',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4550','DANTE SILVIA','PROFESSOR','2015',to_date('09-JUN-81','DD-MON-RR'),'1739',null,'407');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4551','ESPOSITO ELENA','TECHNICIAN','914',to_date('09-JUN-81','DD-MON-RR'),'1280',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4552','FUMAROLA ELIO','HEADMASTER','3856',to_date('09-JUN-81','DD-MON-RR'),'425',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4553','TIBALDI CLARA','SECRETARY','2725',to_date('09-JUN-81','DD-MON-RR'),'1628',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4554','FUMAROLA LUCA','SECRETARY','4402',to_date('09-JUN-81','DD-MON-RR'),'15',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4555','TIBALDI CLARA','MANAGER','3064',to_date('09-JUN-81','DD-MON-RR'),'410',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4556','PETRARCA ANDREA','HEADMASTER','2800',to_date('09-JUN-81','DD-MON-RR'),'112',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4557','NERI GAETANO','SECRETARY','3029',to_date('09-JUN-81','DD-MON-RR'),'1326',null,'389');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4558','LEOPARDI UGO','ENGINEER','3670',to_date('09-JUN-81','DD-MON-RR'),'1010',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4559','FO FEDERICO','MANAGER','4344',to_date('09-JUN-81','DD-MON-RR'),'912',null,'329');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4560','TIBALDI CLARA','LAWYER','3413',to_date('09-JUN-81','DD-MON-RR'),'1218',null,'312');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4561','PETRARCA ANGELO','LAWYER','2236',to_date('09-JUN-81','DD-MON-RR'),'1422',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4562','NERI SILVIA','HEADMASTER','3053',to_date('09-JUN-81','DD-MON-RR'),'1616',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4563','DANTE LUDOVICO','HEADMASTER','2404',to_date('09-JUN-81','DD-MON-RR'),'938',null,'213');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4564','CALVINO CLARA','SECRETARY','322',to_date('09-JUN-81','DD-MON-RR'),'1976',null,'186');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4565','CORONA ROBERTA','MANAGER','680',to_date('09-JUN-81','DD-MON-RR'),'1172',null,'459');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4566','FO ANTONIO','MANAGER','1163',to_date('09-JUN-81','DD-MON-RR'),'1187',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4567','ESPOSITO LUDOVICO','PROFESSOR','655',to_date('09-JUN-81','DD-MON-RR'),'734',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4568','LEOPARDI CLARA','PHDSTUDENT','369',to_date('09-JUN-81','DD-MON-RR'),'683',null,'405');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4569','PETRARCA MARIA','PHDSTUDENT','1942',to_date('09-JUN-81','DD-MON-RR'),'1665',null,'417');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4570','NERI ELIO','SECRETARY','492',to_date('09-JUN-81','DD-MON-RR'),'1421',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4571','GRIMALDI ROBERTA','TECHNICIAN','195',to_date('09-JUN-81','DD-MON-RR'),'1479',null,'477');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4572','TIBALDI GAETANO','MANAGER','2927',to_date('09-JUN-81','DD-MON-RR'),'1349',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4573','LEVI PASQUALE','SUPERVISOR','3021',to_date('09-JUN-81','DD-MON-RR'),'1828',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4574','ESPOSITO FRANCESCO','HEADMASTER','1454',to_date('09-JUN-81','DD-MON-RR'),'1695',null,'385');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4575','LEVI PAOLO','TECHNICIAN','3773',to_date('09-JUN-81','DD-MON-RR'),'1507',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4576','FUMAROLA ELIO','ENGINEER','2037',to_date('09-JUN-81','DD-MON-RR'),'1646',null,'134');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4577','FUMAROLA GIOVANNI','PROFESSOR','247',to_date('09-JUN-81','DD-MON-RR'),'467',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4578','GRIMALDI IVANO','ENGINEER','4163',to_date('09-JUN-81','DD-MON-RR'),'425',null,'110');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4579','FUMAROLA LUDOVICO','SUPERVISOR','113',to_date('09-JUN-81','DD-MON-RR'),'5',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4580','DANTE LUIGI','LAWYER','589',to_date('09-JUN-81','DD-MON-RR'),'1960',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4581','CALVINO ROBERTA','PHDSTUDENT','3208',to_date('09-JUN-81','DD-MON-RR'),'1017',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4582','CALVINO GAETANO','LAWYER','3517',to_date('09-JUN-81','DD-MON-RR'),'1927',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4583','FO ELENA','SECRETARY','2514',to_date('09-JUN-81','DD-MON-RR'),'1894',null,'43');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4584','DANTE MASSIMO','HEADMASTER','1900',to_date('09-JUN-81','DD-MON-RR'),'116',null,'387');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4585','MANZONI DAMIANO','PROFESSOR','205',to_date('09-JUN-81','DD-MON-RR'),'1966',null,'455');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4586','MANZONI UGO','LAWYER','2791',to_date('09-JUN-81','DD-MON-RR'),'1711',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4587','PETRARCA SILVIA','MANAGER','887',to_date('09-JUN-81','DD-MON-RR'),'1183',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4588','SANTE UMBERTO','TECHNICIAN','1793',to_date('09-JUN-81','DD-MON-RR'),'763',null,'170');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4589','MANZONI ELENA','TECHNICIAN','1153',to_date('09-JUN-81','DD-MON-RR'),'1133',null,'216');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4590','BIANCHI GAETANO','SUPERVISOR','4395',to_date('09-JUN-81','DD-MON-RR'),'1036',null,'135');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4591','CALVINO MARIA','ENGINEER','3870',to_date('09-JUN-81','DD-MON-RR'),'126',null,'140');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4592','NERI IVANO','LAWYER','3301',to_date('09-JUN-81','DD-MON-RR'),'722',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4593','FUMAROLA DONATO','ENGINEER','2154',to_date('09-JUN-81','DD-MON-RR'),'536',null,'456');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4594','GRIMALDI MARIA','PHDSTUDENT','852',to_date('09-JUN-81','DD-MON-RR'),'1997',null,'316');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4595','TIBALDI ANGELO','LAWYER','4165',to_date('09-JUN-81','DD-MON-RR'),'1965',null,'312');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4596','CALVINO ANTONIO','HEADMASTER','2773',to_date('09-JUN-81','DD-MON-RR'),'1389',null,'71');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4597','PETRARCA ROBERTA','MANAGER','4557',to_date('09-JUN-81','DD-MON-RR'),'1479',null,'335');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4598','GRIMALDI SILVIA','SUPERVISOR','1014',to_date('09-JUN-81','DD-MON-RR'),'568',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4599','PETRARCA DONATO','HEADMASTER','916',to_date('09-JUN-81','DD-MON-RR'),'560',null,'281');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4600','COZZA DAMIANO','TECHNICIAN','4312',to_date('09-JUN-81','DD-MON-RR'),'1611',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4601','FO DAMIANO','MANAGER','2948',to_date('09-JUN-81','DD-MON-RR'),'1172',null,'58');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4602','LEVI ELIO','MANAGER','432',to_date('09-JUN-81','DD-MON-RR'),'926',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4603','PETRARCA CLARA','PROFESSOR','1447',to_date('09-JUN-81','DD-MON-RR'),'746',null,'488');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4604','GRIMALDI PASQUALE','SUPERVISOR','3204',to_date('09-JUN-81','DD-MON-RR'),'1412',null,'176');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4605','CALVINO DAMIANO','SUPERVISOR','3901',to_date('09-JUN-81','DD-MON-RR'),'950',null,'28');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4606','CALVINO LUIGI','PROFESSOR','3873',to_date('09-JUN-81','DD-MON-RR'),'1355',null,'312');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4607','ESPOSITO CLARA','ENGINEER','444',to_date('09-JUN-81','DD-MON-RR'),'1110',null,'280');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4608','BIANCHI PASQUALE','MANAGER','3076',to_date('09-JUN-81','DD-MON-RR'),'1271',null,'43');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4609','CALVINO DAMIANO','SUPERVISOR','3303',to_date('09-JUN-81','DD-MON-RR'),'926',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4610','COZZA ROBERTA','SUPERVISOR','1474',to_date('09-JUN-81','DD-MON-RR'),'1139',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4611','SANTE MARIO','TECHNICIAN','1919',to_date('09-JUN-81','DD-MON-RR'),'1658',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6642','FUMAROLA PASQUALE','LAWYER','2057',to_date('09-JUN-81','DD-MON-RR'),'1795',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6643','SANTE UGO','TECHNICIAN','5795',to_date('09-JUN-81','DD-MON-RR'),'1602',null,'58');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6644','LEVI ANTONIO','LAWYER','5086',to_date('09-JUN-81','DD-MON-RR'),'1974',null,'308');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6645','SANTE CLARA','ENGINEER','3224',to_date('09-JUN-81','DD-MON-RR'),'1617',null,'405');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6646','TIBALDI ANGELO','TECHNICIAN','5509',to_date('09-JUN-81','DD-MON-RR'),'605',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6647','CALVINO ELIO','TECHNICIAN','2664',to_date('09-JUN-81','DD-MON-RR'),'871',null,'139');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6648','PETRARCA FRANCESCO','SECRETARY','5887',to_date('09-JUN-81','DD-MON-RR'),'1188',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6649','ECO MARIO','MANAGER','3908',to_date('09-JUN-81','DD-MON-RR'),'96',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6650','BIANCHI FEDERICO','SECRETARY','384',to_date('09-JUN-81','DD-MON-RR'),'480',null,'53');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6651','SANTE CLARA','ENGINEER','2578',to_date('09-JUN-81','DD-MON-RR'),'1424',null,'475');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6652','SANTE MASSIMO','TECHNICIAN','2276',to_date('09-JUN-81','DD-MON-RR'),'208',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6653','COZZA ANTONIO','PHDSTUDENT','2099',to_date('09-JUN-81','DD-MON-RR'),'1885',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6654','FO LUDOVICO','MANAGER','1578',to_date('09-JUN-81','DD-MON-RR'),'1064',null,'79');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6655','FO FEDERICO','MANAGER','6312',to_date('09-JUN-81','DD-MON-RR'),'1590',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6656','PETRARCA PAOLO','MANAGER','4681',to_date('09-JUN-81','DD-MON-RR'),'104',null,'374');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6657','CALVINO LUCA','LAWYER','4864',to_date('09-JUN-81','DD-MON-RR'),'711',null,'278');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6658','COZZA ANDREA','SECRETARY','3177',to_date('09-JUN-81','DD-MON-RR'),'584',null,'277');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6659','FO ALFONSO','PROFESSOR','2772',to_date('09-JUN-81','DD-MON-RR'),'680',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6660','FO PASQUALE','SECRETARY','3257',to_date('09-JUN-81','DD-MON-RR'),'1878',null,'282');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6661','TIBALDI UMBERTO','PROFESSOR','4527',to_date('09-JUN-81','DD-MON-RR'),'1396',null,'140');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6662','SANTE MARIA','PHDSTUDENT','5867',to_date('09-JUN-81','DD-MON-RR'),'165',null,'325');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6663','COZZA MASSIMO','PROFESSOR','335',to_date('09-JUN-81','DD-MON-RR'),'1606',null,'459');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6664','MANZONI ROBERTA','PHDSTUDENT','711',to_date('09-JUN-81','DD-MON-RR'),'1050',null,'181');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6665','CORONA LUIGI','PROFESSOR','6061',to_date('09-JUN-81','DD-MON-RR'),'1179',null,'146');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6666','NERI ROBERTA','HEADMASTER','4698',to_date('09-JUN-81','DD-MON-RR'),'1825',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6667','TIBALDI LUDOVICO','TECHNICIAN','1880',to_date('09-JUN-81','DD-MON-RR'),'444',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6668','FO ALFONSO','LAWYER','3736',to_date('09-JUN-81','DD-MON-RR'),'1419',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6669','ESPOSITO MASSIMO','SECRETARY','3353',to_date('09-JUN-81','DD-MON-RR'),'845',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6670','FO MARIA','MANAGER','1470',to_date('09-JUN-81','DD-MON-RR'),'942',null,'437');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6671','LEVI FRANCESCO','ENGINEER','5352',to_date('09-JUN-81','DD-MON-RR'),'1302',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6672','CALVINO FRANCESCO','MANAGER','848',to_date('09-JUN-81','DD-MON-RR'),'1840',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6673','MANZONI ELENA','ENGINEER','1974',to_date('09-JUN-81','DD-MON-RR'),'827',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6674','GRIMALDI DONATO','SUPERVISOR','3378',to_date('09-JUN-81','DD-MON-RR'),'793',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6675','LEVI LUIGI','MANAGER','6521',to_date('09-JUN-81','DD-MON-RR'),'966',null,'362');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6676','CARBONE DONATO','PHDSTUDENT','6417',to_date('09-JUN-81','DD-MON-RR'),'1599',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6677','COZZA UMBERTO','ENGINEER','2302',to_date('09-JUN-81','DD-MON-RR'),'1431',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6678','MANZONI GAETANO','SUPERVISOR','1153',to_date('09-JUN-81','DD-MON-RR'),'1119',null,'74');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6679','LEVI SILVIA','HEADMASTER','2638',to_date('09-JUN-81','DD-MON-RR'),'1825',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6680','NERI LUCIA','SECRETARY','2274',to_date('09-JUN-81','DD-MON-RR'),'1162',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6681','ESPOSITO ELIO','PHDSTUDENT','4924',to_date('09-JUN-81','DD-MON-RR'),'790',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6682','BIANCHI ANTONIO','PROFESSOR','139',to_date('09-JUN-81','DD-MON-RR'),'1444',null,'142');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6683','CORONA ELENA','ENGINEER','4253',to_date('09-JUN-81','DD-MON-RR'),'1648',null,'54');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6684','CORONA LUCA','HEADMASTER','5522',to_date('09-JUN-81','DD-MON-RR'),'690',null,'214');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6685','GRIMALDI ELIO','SUPERVISOR','6453',to_date('09-JUN-81','DD-MON-RR'),'1545',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6686','ECO LUCA','LAWYER','2214',to_date('09-JUN-81','DD-MON-RR'),'1150',null,'221');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6687','BIANCHI UGO','SECRETARY','5901',to_date('09-JUN-81','DD-MON-RR'),'1312',null,'271');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6688','DANTE ELENA','PROFESSOR','4800',to_date('09-JUN-81','DD-MON-RR'),'389',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6689','DANTE COSIMO','MANAGER','2299',to_date('09-JUN-81','DD-MON-RR'),'1611',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6690','CALVINO LUDOVICO','LAWYER','5391',to_date('09-JUN-81','DD-MON-RR'),'70',null,'260');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6691','SANTE COSIMO','MANAGER','3134',to_date('09-JUN-81','DD-MON-RR'),'1032',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6692','BIANCHI MARIO','HEADMASTER','4903',to_date('09-JUN-81','DD-MON-RR'),'1422',null,'112');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6693','COZZA MARIA','MANAGER','3153',to_date('09-JUN-81','DD-MON-RR'),'1194',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6694','ESPOSITO ELENA','LAWYER','3080',to_date('09-JUN-81','DD-MON-RR'),'1537',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6695','FO PAOLO','TECHNICIAN','3498',to_date('09-JUN-81','DD-MON-RR'),'694',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6696','FUMAROLA ELIO','HEADMASTER','2684',to_date('09-JUN-81','DD-MON-RR'),'471',null,'284');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6697','LEOPARDI PASQUALE','SECRETARY','6053',to_date('09-JUN-81','DD-MON-RR'),'1760',null,'55');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6698','MANZONI PASQUALE','ENGINEER','6114',to_date('09-JUN-81','DD-MON-RR'),'1255',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6699','CORONA ELIO','MANAGER','5686',to_date('09-JUN-81','DD-MON-RR'),'1156',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6700','DANTE ANTONIO','SUPERVISOR','2983',to_date('09-JUN-81','DD-MON-RR'),'1752',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6701','COZZA FRANCESCO','PROFESSOR','2462',to_date('09-JUN-81','DD-MON-RR'),'640',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6702','DANTE MARIA','MANAGER','2252',to_date('09-JUN-81','DD-MON-RR'),'1117',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6703','TIBALDI MARIA','MANAGER','2924',to_date('09-JUN-81','DD-MON-RR'),'1201',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6704','TIBALDI DONATO','MANAGER','238',to_date('09-JUN-81','DD-MON-RR'),'681',null,'91');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6705','ESPOSITO ANTONIO','SUPERVISOR','926',to_date('09-JUN-81','DD-MON-RR'),'796',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6706','LEVI SILVIA','LAWYER','1639',to_date('09-JUN-81','DD-MON-RR'),'159',null,'325');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6707','PETRARCA UGO','HEADMASTER','4949',to_date('09-JUN-81','DD-MON-RR'),'706',null,'432');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6708','ECO COSIMO','SECRETARY','1991',to_date('09-JUN-81','DD-MON-RR'),'471',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6709','FUMAROLA UMBERTO','MANAGER','2590',to_date('09-JUN-81','DD-MON-RR'),'589',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6710','BIANCHI FRANCESCO','SECRETARY','700',to_date('09-JUN-81','DD-MON-RR'),'498',null,'169');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6711','COZZA UMBERTO','HEADMASTER','5692',to_date('09-JUN-81','DD-MON-RR'),'602',null,'65');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6712','CALVINO ALFONSO','HEADMASTER','5410',to_date('09-JUN-81','DD-MON-RR'),'1913',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6713','FO COSIMO','HEADMASTER','1503',to_date('09-JUN-81','DD-MON-RR'),'1385',null,'267');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6714','PETRARCA DAMIANO','PHDSTUDENT','158',to_date('09-JUN-81','DD-MON-RR'),'1722',null,'44');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6715','PETRARCA MARIA','MANAGER','6380',to_date('09-JUN-81','DD-MON-RR'),'1067',null,'224');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6716','FO ROBERTA','MANAGER','2276',to_date('09-JUN-81','DD-MON-RR'),'1797',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6717','FO UGO','PHDSTUDENT','4141',to_date('09-JUN-81','DD-MON-RR'),'409',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6718','CARBONE PAOLO','PHDSTUDENT','2800',to_date('09-JUN-81','DD-MON-RR'),'199',null,'35');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6719','LEOPARDI ALFONSO','SUPERVISOR','5022',to_date('09-JUN-81','DD-MON-RR'),'1001',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6720','CARBONE MASSIMO','TECHNICIAN','253',to_date('09-JUN-81','DD-MON-RR'),'922',null,'185');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6721','MANZONI ALFONSO','TECHNICIAN','6679',to_date('09-JUN-81','DD-MON-RR'),'178',null,'159');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6722','LEVI GAETANO','HEADMASTER','5564',to_date('09-JUN-81','DD-MON-RR'),'349',null,'461');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6723','SANTE FEDERICO','TECHNICIAN','1273',to_date('09-JUN-81','DD-MON-RR'),'1417',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6724','BIANCHI LUIGI','PHDSTUDENT','5426',to_date('09-JUN-81','DD-MON-RR'),'817',null,'438');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6725','ESPOSITO PASQUALE','SUPERVISOR','344',to_date('09-JUN-81','DD-MON-RR'),'566',null,'424');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6726','DANTE ELIO','LAWYER','5669',to_date('09-JUN-81','DD-MON-RR'),'1529',null,'344');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6727','FO LUCIA','MANAGER','5928',to_date('09-JUN-81','DD-MON-RR'),'788',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6728','SANTE FRANCESCO','PHDSTUDENT','4060',to_date('09-JUN-81','DD-MON-RR'),'788',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6729','CARBONE PAOLO','PROFESSOR','5908',to_date('09-JUN-81','DD-MON-RR'),'923',null,'245');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6730','GRIMALDI LUDOVICO','MANAGER','962',to_date('09-JUN-81','DD-MON-RR'),'1455',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6731','PETRARCA UGO','ENGINEER','3985',to_date('09-JUN-81','DD-MON-RR'),'1984',null,'278');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6732','GRIMALDI UGO','TECHNICIAN','3552',to_date('09-JUN-81','DD-MON-RR'),'73',null,'258');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6733','CORONA ANGELO','LAWYER','4463',to_date('09-JUN-81','DD-MON-RR'),'889',null,'57');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6734','SANTE LUDOVICO','SECRETARY','1132',to_date('09-JUN-81','DD-MON-RR'),'1649',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6735','PETRARCA DONATO','TECHNICIAN','2676',to_date('09-JUN-81','DD-MON-RR'),'1444',null,'318');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6736','PETRARCA MARIA','PROFESSOR','1416',to_date('09-JUN-81','DD-MON-RR'),'614',null,'389');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6737','FO IVANO','ENGINEER','5994',to_date('09-JUN-81','DD-MON-RR'),'231',null,'485');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6738','COZZA CLARA','TECHNICIAN','863',to_date('09-JUN-81','DD-MON-RR'),'1456',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6739','TIBALDI UMBERTO','SECRETARY','97',to_date('09-JUN-81','DD-MON-RR'),'1962',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6740','GRIMALDI FRANCESCO','TECHNICIAN','1053',to_date('09-JUN-81','DD-MON-RR'),'77',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6741','ESPOSITO DAMIANO','MANAGER','3906',to_date('09-JUN-81','DD-MON-RR'),'1334',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6742','FO ANTONIO','PROFESSOR','1970',to_date('09-JUN-81','DD-MON-RR'),'648',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6743','PETRARCA ALFONSO','TECHNICIAN','503',to_date('09-JUN-81','DD-MON-RR'),'1717',null,'424');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6744','PETRARCA ROBERTA','SECRETARY','3599',to_date('09-JUN-81','DD-MON-RR'),'234',null,'321');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6745','FUMAROLA LUCA','TECHNICIAN','1135',to_date('09-JUN-81','DD-MON-RR'),'1041',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6746','FUMAROLA UGO','SECRETARY','3657',to_date('09-JUN-81','DD-MON-RR'),'1786',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6747','CORONA DONATO','SUPERVISOR','5623',to_date('09-JUN-81','DD-MON-RR'),'1087',null,'102');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6748','LEVI GAETANO','SECRETARY','62',to_date('09-JUN-81','DD-MON-RR'),'1762',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6749','LEOPARDI UGO','TECHNICIAN','3505',to_date('09-JUN-81','DD-MON-RR'),'1491',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6750','MANZONI CLARA','ENGINEER','3013',to_date('09-JUN-81','DD-MON-RR'),'950',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6751','ESPOSITO ANTONIO','ENGINEER','3705',to_date('09-JUN-81','DD-MON-RR'),'1030',null,'53');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6752','ECO ELENA','HEADMASTER','5926',to_date('09-JUN-81','DD-MON-RR'),'485',null,'450');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6753','PETRARCA UGO','PROFESSOR','132',to_date('09-JUN-81','DD-MON-RR'),'281',null,'294');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6754','NERI MARIO','MANAGER','4811',to_date('09-JUN-81','DD-MON-RR'),'1035',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6755','SANTE ANGELO','TECHNICIAN','717',to_date('09-JUN-81','DD-MON-RR'),'253',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6756','BIANCHI MARIA','SUPERVISOR','1478',to_date('09-JUN-81','DD-MON-RR'),'889',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6757','CARBONE IVANO','TECHNICIAN','4612',to_date('09-JUN-81','DD-MON-RR'),'636',null,'234');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6758','NERI ROBERTA','MANAGER','1969',to_date('09-JUN-81','DD-MON-RR'),'842',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6759','DANTE DONATO','PROFESSOR','4603',to_date('09-JUN-81','DD-MON-RR'),'1896',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6760','CARBONE FEDERICO','HEADMASTER','550',to_date('09-JUN-81','DD-MON-RR'),'1563',null,'32');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6761','CORONA UMBERTO','PHDSTUDENT','4820',to_date('09-JUN-81','DD-MON-RR'),'12',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6762','FO CLARA','PHDSTUDENT','5126',to_date('09-JUN-81','DD-MON-RR'),'28',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6763','SANTE COSIMO','ENGINEER','5609',to_date('09-JUN-81','DD-MON-RR'),'1778',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6764','DANTE SILVIA','LAWYER','2110',to_date('09-JUN-81','DD-MON-RR'),'901',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6765','NERI LUIGI','PHDSTUDENT','3443',to_date('09-JUN-81','DD-MON-RR'),'1519',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6766','NERI UGO','SUPERVISOR','3621',to_date('09-JUN-81','DD-MON-RR'),'1766',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6767','LEVI ANTONIO','SECRETARY','5325',to_date('09-JUN-81','DD-MON-RR'),'344',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6768','CORONA COSIMO','HEADMASTER','3503',to_date('09-JUN-81','DD-MON-RR'),'459',null,'127');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6769','FUMAROLA UMBERTO','MANAGER','4932',to_date('09-JUN-81','DD-MON-RR'),'226',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6770','CARBONE COSIMO','TECHNICIAN','5063',to_date('09-JUN-81','DD-MON-RR'),'385',null,'456');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6771','COZZA FEDERICO','SUPERVISOR','5372',to_date('09-JUN-81','DD-MON-RR'),'604',null,'483');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6772','PETRARCA DAMIANO','TECHNICIAN','6573',to_date('09-JUN-81','DD-MON-RR'),'59',null,'276');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6773','GRIMALDI FRANCESCO','HEADMASTER','713',to_date('09-JUN-81','DD-MON-RR'),'997',null,'91');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6774','LEOPARDI MASSIMO','SECRETARY','2615',to_date('09-JUN-81','DD-MON-RR'),'1465',null,'48');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6775','COZZA IVANO','PHDSTUDENT','104',to_date('09-JUN-81','DD-MON-RR'),'762',null,'486');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6776','ECO GAETANO','MANAGER','83',to_date('09-JUN-81','DD-MON-RR'),'1103',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5035','FO ELIO','PROFESSOR','1780',to_date('09-JUN-81','DD-MON-RR'),'413',null,'35');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8537','FO UMBERTO','PHDSTUDENT','5223',to_date('09-JUN-81','DD-MON-RR'),'1367',null,'25');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8538','ECO ROBERTA','PHDSTUDENT','4435',to_date('09-JUN-81','DD-MON-RR'),'1867',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8539','LEVI ELIO','ENGINEER','5031',to_date('09-JUN-81','DD-MON-RR'),'1766',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8540','FO SILVIA','PROFESSOR','2157',to_date('09-JUN-81','DD-MON-RR'),'1085',null,'105');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8541','DANTE FEDERICO','ENGINEER','7520',to_date('09-JUN-81','DD-MON-RR'),'1216',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8542','CARBONE LUCA','LAWYER','7143',to_date('09-JUN-81','DD-MON-RR'),'403',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8543','CARBONE MARIA','LAWYER','5485',to_date('09-JUN-81','DD-MON-RR'),'513',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8544','CARBONE GAETANO','TECHNICIAN','2006',to_date('09-JUN-81','DD-MON-RR'),'857',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8545','ESPOSITO UMBERTO','HEADMASTER','6918',to_date('09-JUN-81','DD-MON-RR'),'467',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8546','DANTE DONATO','TECHNICIAN','2228',to_date('09-JUN-81','DD-MON-RR'),'494',null,'483');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8547','DANTE ROBERTA','TECHNICIAN','7730',to_date('09-JUN-81','DD-MON-RR'),'1363',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8548','FO MASSIMO','TECHNICIAN','5947',to_date('09-JUN-81','DD-MON-RR'),'420',null,'376');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8549','COZZA ELENA','SECRETARY','3012',to_date('09-JUN-81','DD-MON-RR'),'474',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8550','GRIMALDI ANDREA','PROFESSOR','7347',to_date('09-JUN-81','DD-MON-RR'),'1657',null,'118');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8551','FO ANGELO','ENGINEER','7233',to_date('09-JUN-81','DD-MON-RR'),'221',null,'425');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8552','GRIMALDI PAOLO','SECRETARY','3150',to_date('09-JUN-81','DD-MON-RR'),'1994',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8553','TIBALDI DAMIANO','ENGINEER','5322',to_date('09-JUN-81','DD-MON-RR'),'408',null,'77');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8554','DANTE DONATO','TECHNICIAN','8275',to_date('09-JUN-81','DD-MON-RR'),'741',null,'197');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8555','TIBALDI COSIMO','ENGINEER','8480',to_date('09-JUN-81','DD-MON-RR'),'7',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8556','ECO ELENA','TECHNICIAN','7105',to_date('09-JUN-81','DD-MON-RR'),'675',null,'102');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8557','LEVI MARIA','PROFESSOR','3217',to_date('09-JUN-81','DD-MON-RR'),'1036',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8558','NERI FEDERICO','HEADMASTER','5980',to_date('09-JUN-81','DD-MON-RR'),'534',null,'3');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8559','LEVI LUDOVICO','SECRETARY','113',to_date('09-JUN-81','DD-MON-RR'),'1219',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8560','BIANCHI FRANCESCO','PHDSTUDENT','7053',to_date('09-JUN-81','DD-MON-RR'),'1179',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8561','BIANCHI ELENA','MANAGER','1384',to_date('09-JUN-81','DD-MON-RR'),'1295',null,'187');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8562','FO ALFONSO','PHDSTUDENT','5688',to_date('09-JUN-81','DD-MON-RR'),'1408',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8563','COZZA LUIGI','SECRETARY','6527',to_date('09-JUN-81','DD-MON-RR'),'312',null,'477');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8564','COZZA UGO','LAWYER','6810',to_date('09-JUN-81','DD-MON-RR'),'48',null,'103');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8565','SANTE GIOVANNI','MANAGER','6276',to_date('09-JUN-81','DD-MON-RR'),'514',null,'197');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8566','FUMAROLA ANTONIO','LAWYER','2694',to_date('09-JUN-81','DD-MON-RR'),'973',null,'430');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8567','TIBALDI IVANO','SUPERVISOR','1829',to_date('09-JUN-81','DD-MON-RR'),'1035',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8568','CALVINO MASSIMO','PROFESSOR','8087',to_date('09-JUN-81','DD-MON-RR'),'478',null,'253');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8569','PETRARCA PAOLO','LAWYER','4249',to_date('09-JUN-81','DD-MON-RR'),'1608',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8570','COZZA ALFONSO','TECHNICIAN','4354',to_date('09-JUN-81','DD-MON-RR'),'1457',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8571','CARBONE GAETANO','TECHNICIAN','989',to_date('09-JUN-81','DD-MON-RR'),'642',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8572','ECO PASQUALE','LAWYER','1404',to_date('09-JUN-81','DD-MON-RR'),'447',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8573','BIANCHI ALFONSO','SUPERVISOR','3485',to_date('09-JUN-81','DD-MON-RR'),'847',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8574','CORONA DONATO','PHDSTUDENT','3692',to_date('09-JUN-81','DD-MON-RR'),'1636',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8575','BIANCHI ANGELO','SECRETARY','8129',to_date('09-JUN-81','DD-MON-RR'),'58',null,'335');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8576','ESPOSITO GAETANO','ENGINEER','6334',to_date('09-JUN-81','DD-MON-RR'),'95',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8577','FO ALFONSO','PROFESSOR','5846',to_date('09-JUN-81','DD-MON-RR'),'374',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8578','ECO GIOVANNI','ENGINEER','8505',to_date('09-JUN-81','DD-MON-RR'),'1300',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8579','LEOPARDI ALFONSO','PROFESSOR','2285',to_date('09-JUN-81','DD-MON-RR'),'1987',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8580','MANZONI MARIA','TECHNICIAN','1325',to_date('09-JUN-81','DD-MON-RR'),'1829',null,'413');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8581','SANTE MASSIMO','PROFESSOR','4312',to_date('09-JUN-81','DD-MON-RR'),'1668',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8582','DANTE FRANCESCO','LAWYER','4370',to_date('09-JUN-81','DD-MON-RR'),'598',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8583','CALVINO GAETANO','TECHNICIAN','3891',to_date('09-JUN-81','DD-MON-RR'),'777',null,'456');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8584','CARBONE ANDREA','PHDSTUDENT','407',to_date('09-JUN-81','DD-MON-RR'),'1558',null,'234');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8585','CARBONE PASQUALE','MANAGER','1049',to_date('09-JUN-81','DD-MON-RR'),'292',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8586','GRIMALDI FEDERICO','PHDSTUDENT','6091',to_date('09-JUN-81','DD-MON-RR'),'948',null,'140');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8587','CALVINO SILVIA','TECHNICIAN','2990',to_date('09-JUN-81','DD-MON-RR'),'968',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8588','CALVINO UGO','SUPERVISOR','5396',to_date('09-JUN-81','DD-MON-RR'),'1358',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8589','LEOPARDI CLARA','LAWYER','134',to_date('09-JUN-81','DD-MON-RR'),'631',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8590','PETRARCA ROBERTA','SUPERVISOR','7909',to_date('09-JUN-81','DD-MON-RR'),'1524',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8591','GRIMALDI ELENA','MANAGER','6163',to_date('09-JUN-81','DD-MON-RR'),'842',null,'429');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8592','BIANCHI LUIGI','SUPERVISOR','7689',to_date('09-JUN-81','DD-MON-RR'),'573',null,'159');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8593','MANZONI DONATO','ENGINEER','5886',to_date('09-JUN-81','DD-MON-RR'),'563',null,'111');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8594','ESPOSITO MARIA','PROFESSOR','1396',to_date('09-JUN-81','DD-MON-RR'),'1675',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8595','COZZA LUCA','MANAGER','6049',to_date('09-JUN-81','DD-MON-RR'),'486',null,'105');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8596','BIANCHI ANDREA','ENGINEER','4314',to_date('09-JUN-81','DD-MON-RR'),'464',null,'171');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8597','MANZONI ALFONSO','SUPERVISOR','1679',to_date('09-JUN-81','DD-MON-RR'),'249',null,'284');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8598','ECO IVANO','HEADMASTER','500',to_date('09-JUN-81','DD-MON-RR'),'1802',null,'251');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8599','FO ROBERTA','PROFESSOR','6652',to_date('09-JUN-81','DD-MON-RR'),'1461',null,'81');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8600','CARBONE MASSIMO','HEADMASTER','249',to_date('09-JUN-81','DD-MON-RR'),'1743',null,'364');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8601','COZZA LUIGI','MANAGER','1383',to_date('09-JUN-81','DD-MON-RR'),'981',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8602','GRIMALDI MASSIMO','PROFESSOR','6761',to_date('09-JUN-81','DD-MON-RR'),'94',null,'415');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8603','LEOPARDI FRANCESCO','PHDSTUDENT','4961',to_date('09-JUN-81','DD-MON-RR'),'1238',null,'474');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8604','DANTE MARIA','LAWYER','3494',to_date('09-JUN-81','DD-MON-RR'),'1349',null,'123');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8605','ECO UMBERTO','LAWYER','479',to_date('09-JUN-81','DD-MON-RR'),'569',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8606','PETRARCA ELENA','LAWYER','256',to_date('09-JUN-81','DD-MON-RR'),'1369',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8607','MANZONI CLARA','TECHNICIAN','1833',to_date('09-JUN-81','DD-MON-RR'),'1950',null,'333');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8608','ECO LUCA','ENGINEER','789',to_date('09-JUN-81','DD-MON-RR'),'1812',null,'423');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8609','LEVI ANTONIO','LAWYER','4794',to_date('09-JUN-81','DD-MON-RR'),'785',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8610','TIBALDI ELENA','SECRETARY','1896',to_date('09-JUN-81','DD-MON-RR'),'36',null,'481');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8611','FO ANDREA','MANAGER','6755',to_date('09-JUN-81','DD-MON-RR'),'1666',null,'86');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8612','ECO LUCIA','ENGINEER','1474',to_date('09-JUN-81','DD-MON-RR'),'1105',null,'168');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8613','SANTE LUDOVICO','PROFESSOR','564',to_date('09-JUN-81','DD-MON-RR'),'1377',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8614','GRIMALDI PAOLO','MANAGER','5691',to_date('09-JUN-81','DD-MON-RR'),'572',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8615','FUMAROLA ROBERTA','PROFESSOR','6569',to_date('09-JUN-81','DD-MON-RR'),'622',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8616','COZZA DONATO','PROFESSOR','1846',to_date('09-JUN-81','DD-MON-RR'),'1206',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8617','CALVINO FEDERICO','TECHNICIAN','6453',to_date('09-JUN-81','DD-MON-RR'),'653',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8618','SANTE FRANCESCO','PHDSTUDENT','6486',to_date('09-JUN-81','DD-MON-RR'),'459',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8619','CARBONE MARIO','TECHNICIAN','7636',to_date('09-JUN-81','DD-MON-RR'),'1606',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8620','CALVINO UMBERTO','HEADMASTER','6504',to_date('09-JUN-81','DD-MON-RR'),'1298',null,'83');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8621','PETRARCA UMBERTO','HEADMASTER','3673',to_date('09-JUN-81','DD-MON-RR'),'1180',null,'294');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8622','ESPOSITO SILVIA','LAWYER','7828',to_date('09-JUN-81','DD-MON-RR'),'1452',null,'35');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8623','LEVI ROBERTA','TECHNICIAN','3733',to_date('09-JUN-81','DD-MON-RR'),'1129',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8624','CARBONE ANDREA','HEADMASTER','5710',to_date('09-JUN-81','DD-MON-RR'),'1553',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8625','FUMAROLA ELIO','MANAGER','2444',to_date('09-JUN-81','DD-MON-RR'),'740',null,'474');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8626','LEVI MARIO','TECHNICIAN','3763',to_date('09-JUN-81','DD-MON-RR'),'970',null,'457');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8627','SANTE FRANCESCO','SECRETARY','6646',to_date('09-JUN-81','DD-MON-RR'),'780',null,'308');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8628','FUMAROLA CLARA','LAWYER','671',to_date('09-JUN-81','DD-MON-RR'),'390',null,'497');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8629','CALVINO GAETANO','TECHNICIAN','1313',to_date('09-JUN-81','DD-MON-RR'),'80',null,'331');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8630','PETRARCA LUCA','PHDSTUDENT','7445',to_date('09-JUN-81','DD-MON-RR'),'1502',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8631','DANTE ANTONIO','MANAGER','1165',to_date('09-JUN-81','DD-MON-RR'),'1275',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8632','FUMAROLA DONATO','MANAGER','8120',to_date('09-JUN-81','DD-MON-RR'),'867',null,'32');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8633','LEOPARDI FRANCESCO','LAWYER','8531',to_date('09-JUN-81','DD-MON-RR'),'707',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8634','LEOPARDI MARIO','PROFESSOR','7497',to_date('09-JUN-81','DD-MON-RR'),'98',null,'220');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8635','ECO DAMIANO','ENGINEER','6982',to_date('09-JUN-81','DD-MON-RR'),'952',null,'329');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8636','NERI PASQUALE','LAWYER','1421',to_date('09-JUN-81','DD-MON-RR'),'844',null,'249');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8637','GRIMALDI LUCIA','MANAGER','277',to_date('09-JUN-81','DD-MON-RR'),'824',null,'298');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8638','MANZONI FRANCESCO','MANAGER','7987',to_date('09-JUN-81','DD-MON-RR'),'1918',null,'112');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8639','DANTE FRANCESCO','TECHNICIAN','3004',to_date('09-JUN-81','DD-MON-RR'),'1620',null,'86');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8640','ECO UGO','TECHNICIAN','6026',to_date('09-JUN-81','DD-MON-RR'),'299',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8641','TIBALDI DONATO','PROFESSOR','1892',to_date('09-JUN-81','DD-MON-RR'),'1542',null,'485');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8642','SANTE COSIMO','MANAGER','7612',to_date('09-JUN-81','DD-MON-RR'),'321',null,'427');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8643','GRIMALDI DONATO','PHDSTUDENT','3022',to_date('09-JUN-81','DD-MON-RR'),'365',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8644','TIBALDI GAETANO','PHDSTUDENT','6036',to_date('09-JUN-81','DD-MON-RR'),'955',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8645','FUMAROLA DAMIANO','MANAGER','5678',to_date('09-JUN-81','DD-MON-RR'),'1928',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8646','FO UMBERTO','SUPERVISOR','4052',to_date('09-JUN-81','DD-MON-RR'),'1081',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8647','PETRARCA IVANO','PROFESSOR','7644',to_date('09-JUN-81','DD-MON-RR'),'279',null,'348');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8648','FUMAROLA PAOLO','TECHNICIAN','4898',to_date('09-JUN-81','DD-MON-RR'),'1933',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8649','NERI PAOLO','HEADMASTER','687',to_date('09-JUN-81','DD-MON-RR'),'481',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8650','CARBONE LUCA','HEADMASTER','4292',to_date('09-JUN-81','DD-MON-RR'),'1536',null,'487');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8651','CALVINO ANDREA','MANAGER','1387',to_date('09-JUN-81','DD-MON-RR'),'312',null,'419');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8652','NERI IVANO','PROFESSOR','890',to_date('09-JUN-81','DD-MON-RR'),'961',null,'118');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8653','MANZONI SILVIA','ENGINEER','6524',to_date('09-JUN-81','DD-MON-RR'),'1574',null,'410');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8654','CALVINO CLARA','SECRETARY','1376',to_date('09-JUN-81','DD-MON-RR'),'437',null,'301');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8655','ECO ANDREA','SUPERVISOR','7929',to_date('09-JUN-81','DD-MON-RR'),'664',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8656','COZZA DAMIANO','SECRETARY','1640',to_date('09-JUN-81','DD-MON-RR'),'35',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8657','TIBALDI IVANO','PHDSTUDENT','1076',to_date('09-JUN-81','DD-MON-RR'),'1375',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8658','DANTE ELIO','MANAGER','1858',to_date('09-JUN-81','DD-MON-RR'),'482',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8659','DANTE CLARA','TECHNICIAN','3446',to_date('09-JUN-81','DD-MON-RR'),'583',null,'385');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8660','BIANCHI MASSIMO','HEADMASTER','6202',to_date('09-JUN-81','DD-MON-RR'),'224',null,'469');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8661','LEVI MASSIMO','SECRETARY','3204',to_date('09-JUN-81','DD-MON-RR'),'387',null,'407');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8662','TIBALDI MARIO','SUPERVISOR','5375',to_date('09-JUN-81','DD-MON-RR'),'691',null,'43');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8663','GRIMALDI ANTONIO','SECRETARY','5638',to_date('09-JUN-81','DD-MON-RR'),'1842',null,'407');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8664','ESPOSITO MASSIMO','LAWYER','5335',to_date('09-JUN-81','DD-MON-RR'),'708',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8665','LEVI COSIMO','MANAGER','8610',to_date('09-JUN-81','DD-MON-RR'),'144',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8666','PETRARCA LUDOVICO','SECRETARY','6321',to_date('09-JUN-81','DD-MON-RR'),'1282',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8667','CARBONE LUCIA','SUPERVISOR','8168',to_date('09-JUN-81','DD-MON-RR'),'1917',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8668','NERI ANGELO','SUPERVISOR','5224',to_date('09-JUN-81','DD-MON-RR'),'1270',null,'469');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8669','SANTE ELIO','SUPERVISOR','3162',to_date('09-JUN-81','DD-MON-RR'),'629',null,'125');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8670','DANTE DAMIANO','PROFESSOR','335',to_date('09-JUN-81','DD-MON-RR'),'1390',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8671','BIANCHI IVANO','HEADMASTER','1191',to_date('09-JUN-81','DD-MON-RR'),'715',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2582','NERI GIOVANNI','SUPERVISOR','49',to_date('09-JUN-81','DD-MON-RR'),'168',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2583','CARBONE PAOLO','ENGINEER','1342',to_date('09-JUN-81','DD-MON-RR'),'422',null,'461');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2584','NERI IVANO','SECRETARY','2190',to_date('09-JUN-81','DD-MON-RR'),'1650',null,'278');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2585','LEVI UMBERTO','HEADMASTER','420',to_date('09-JUN-81','DD-MON-RR'),'171',null,'355');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2586','FUMAROLA ALFONSO','PROFESSOR','1083',to_date('09-JUN-81','DD-MON-RR'),'1520',null,'389');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2587','CARBONE PAOLO','LAWYER','2280',to_date('09-JUN-81','DD-MON-RR'),'1468',null,'410');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2588','ESPOSITO ALFONSO','PROFESSOR','477',to_date('09-JUN-81','DD-MON-RR'),'235',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2589','BIANCHI DONATO','SECRETARY','2405',to_date('09-JUN-81','DD-MON-RR'),'1755',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2590','TIBALDI PAOLO','LAWYER','1937',to_date('09-JUN-81','DD-MON-RR'),'540',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2591','CALVINO MASSIMO','LAWYER','142',to_date('09-JUN-81','DD-MON-RR'),'449',null,'485');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2592','ESPOSITO PASQUALE','PROFESSOR','1483',to_date('09-JUN-81','DD-MON-RR'),'236',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2593','GRIMALDI FEDERICO','PHDSTUDENT','117',to_date('09-JUN-81','DD-MON-RR'),'1888',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2594','FUMAROLA IVANO','SECRETARY','1914',to_date('09-JUN-81','DD-MON-RR'),'1961',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2595','LEOPARDI PASQUALE','PHDSTUDENT','692',to_date('09-JUN-81','DD-MON-RR'),'429',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2596','NERI MARIO','LAWYER','1134',to_date('09-JUN-81','DD-MON-RR'),'1457',null,'226');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2597','NERI DONATO','TECHNICIAN','247',to_date('09-JUN-81','DD-MON-RR'),'271',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2598','TIBALDI ROBERTA','SUPERVISOR','1391',to_date('09-JUN-81','DD-MON-RR'),'1149',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2599','LEOPARDI GIOVANNI','SUPERVISOR','2181',to_date('09-JUN-81','DD-MON-RR'),'441',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2600','PETRARCA UMBERTO','SECRETARY','92',to_date('09-JUN-81','DD-MON-RR'),'1762',null,'112');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2601','COZZA MARIO','HEADMASTER','1785',to_date('09-JUN-81','DD-MON-RR'),'1088',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2602','LEVI UMBERTO','LAWYER','2157',to_date('09-JUN-81','DD-MON-RR'),'96',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2603','ESPOSITO LUIGI','SECRETARY','533',to_date('09-JUN-81','DD-MON-RR'),'199',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2604','PETRARCA ROBERTA','LAWYER','729',to_date('09-JUN-81','DD-MON-RR'),'1223',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2605','ECO DAMIANO','MANAGER','2177',to_date('09-JUN-81','DD-MON-RR'),'1061',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2606','ECO ALFONSO','SECRETARY','2504',to_date('09-JUN-81','DD-MON-RR'),'1350',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2607','NERI ANGELO','MANAGER','2034',to_date('09-JUN-81','DD-MON-RR'),'1287',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2608','ECO DONATO','SUPERVISOR','2514',to_date('09-JUN-81','DD-MON-RR'),'971',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2609','FO ANGELO','PHDSTUDENT','808',to_date('09-JUN-81','DD-MON-RR'),'965',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2610','PETRARCA UMBERTO','SUPERVISOR','507',to_date('09-JUN-81','DD-MON-RR'),'286',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2611','ESPOSITO LUCIA','LAWYER','1471',to_date('09-JUN-81','DD-MON-RR'),'331',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2612','GRIMALDI PASQUALE','MANAGER','212',to_date('09-JUN-81','DD-MON-RR'),'1070',null,'240');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2613','BIANCHI GAETANO','PHDSTUDENT','556',to_date('09-JUN-81','DD-MON-RR'),'1213',null,'123');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2614','MANZONI COSIMO','ENGINEER','2303',to_date('09-JUN-81','DD-MON-RR'),'624',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2615','DANTE COSIMO','PROFESSOR','104',to_date('09-JUN-81','DD-MON-RR'),'1902',null,'191');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2616','MANZONI ALFONSO','PROFESSOR','1948',to_date('09-JUN-81','DD-MON-RR'),'680',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2617','ECO DAMIANO','SECRETARY','1580',to_date('09-JUN-81','DD-MON-RR'),'536',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2618','SANTE FEDERICO','LAWYER','2215',to_date('09-JUN-81','DD-MON-RR'),'1691',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2619','LEOPARDI ALFONSO','SECRETARY','1424',to_date('09-JUN-81','DD-MON-RR'),'1775',null,'304');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2620','LEOPARDI UMBERTO','LAWYER','1878',to_date('09-JUN-81','DD-MON-RR'),'281',null,'158');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2621','BIANCHI ALFONSO','TECHNICIAN','1805',to_date('09-JUN-81','DD-MON-RR'),'567',null,'217');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2622','BIANCHI LUDOVICO','MANAGER','2498',to_date('09-JUN-81','DD-MON-RR'),'1309',null,'444');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2623','NERI GAETANO','ENGINEER','1797',to_date('09-JUN-81','DD-MON-RR'),'1171',null,'184');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2624','NERI SILVIA','ENGINEER','726',to_date('09-JUN-81','DD-MON-RR'),'447',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2625','CALVINO MARIA','TECHNICIAN','660',to_date('09-JUN-81','DD-MON-RR'),'835',null,'251');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2626','TIBALDI FEDERICO','SUPERVISOR','1739',to_date('09-JUN-81','DD-MON-RR'),'414',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2627','FUMAROLA LUDOVICO','PROFESSOR','1885',to_date('09-JUN-81','DD-MON-RR'),'1206',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2628','NERI GAETANO','SUPERVISOR','338',to_date('09-JUN-81','DD-MON-RR'),'571',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2629','GRIMALDI FRANCESCO','TECHNICIAN','2291',to_date('09-JUN-81','DD-MON-RR'),'1085',null,'130');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2630','FUMAROLA LUCA','MANAGER','1307',to_date('09-JUN-81','DD-MON-RR'),'1360',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2631','CORONA SILVIA','SUPERVISOR','114',to_date('09-JUN-81','DD-MON-RR'),'1822',null,'51');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2632','ECO UGO','SUPERVISOR','1964',to_date('09-JUN-81','DD-MON-RR'),'1450',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2633','GRIMALDI CLARA','SECRETARY','1444',to_date('09-JUN-81','DD-MON-RR'),'921',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2634','BIANCHI UMBERTO','SECRETARY','2479',to_date('09-JUN-81','DD-MON-RR'),'1658',null,'25');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2635','FUMAROLA GIOVANNI','MANAGER','427',to_date('09-JUN-81','DD-MON-RR'),'920',null,'80');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2636','CALVINO SILVIA','SUPERVISOR','1150',to_date('09-JUN-81','DD-MON-RR'),'1010',null,'160');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2637','TIBALDI ANGELO','SECRETARY','773',to_date('09-JUN-81','DD-MON-RR'),'1242',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2638','LEOPARDI ALFONSO','HEADMASTER','1602',to_date('09-JUN-81','DD-MON-RR'),'1894',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2639','MANZONI ROBERTA','PROFESSOR','949',to_date('09-JUN-81','DD-MON-RR'),'1587',null,'316');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2640','PETRARCA IVANO','ENGINEER','2354',to_date('09-JUN-81','DD-MON-RR'),'315',null,'28');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2641','PETRARCA FRANCESCO','ENGINEER','1217',to_date('09-JUN-81','DD-MON-RR'),'268',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2642','LEOPARDI FEDERICO','LAWYER','287',to_date('09-JUN-81','DD-MON-RR'),'1935',null,'259');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2643','CORONA DONATO','MANAGER','1445',to_date('09-JUN-81','DD-MON-RR'),'450',null,'432');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2644','CALVINO ROBERTA','PROFESSOR','519',to_date('09-JUN-81','DD-MON-RR'),'871',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2645','ESPOSITO DONATO','SECRETARY','1125',to_date('09-JUN-81','DD-MON-RR'),'1478',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2646','SANTE PASQUALE','LAWYER','2645',to_date('09-JUN-81','DD-MON-RR'),'504',null,'248');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2647','MANZONI LUIGI','ENGINEER','2437',to_date('09-JUN-81','DD-MON-RR'),'283',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2648','ESPOSITO ANTONIO','ENGINEER','949',to_date('09-JUN-81','DD-MON-RR'),'1701',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2649','MANZONI ROBERTA','TECHNICIAN','2496',to_date('09-JUN-81','DD-MON-RR'),'880',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2650','BIANCHI IVANO','PHDSTUDENT','2549',to_date('09-JUN-81','DD-MON-RR'),'1390',null,'40');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2651','LEOPARDI UGO','SUPERVISOR','2625',to_date('09-JUN-81','DD-MON-RR'),'353',null,'62');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2652','TIBALDI ALFONSO','MANAGER','1749',to_date('09-JUN-81','DD-MON-RR'),'241',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2653','FUMAROLA UGO','TECHNICIAN','1476',to_date('09-JUN-81','DD-MON-RR'),'1838',null,'226');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2654','CORONA ELIO','SECRETARY','1586',to_date('09-JUN-81','DD-MON-RR'),'171',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2655','CALVINO LUDOVICO','SUPERVISOR','1152',to_date('09-JUN-81','DD-MON-RR'),'1005',null,'51');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2656','ESPOSITO FRANCESCO','PHDSTUDENT','1028',to_date('09-JUN-81','DD-MON-RR'),'241',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2657','BIANCHI UGO','PROFESSOR','1776',to_date('09-JUN-81','DD-MON-RR'),'536',null,'387');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2658','TIBALDI LUCA','MANAGER','1516',to_date('09-JUN-81','DD-MON-RR'),'1248',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2659','LEVI MARIA','HEADMASTER','1917',to_date('09-JUN-81','DD-MON-RR'),'1522',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2660','CORONA LUCIA','SECRETARY','707',to_date('09-JUN-81','DD-MON-RR'),'574',null,'264');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2661','BIANCHI IVANO','ENGINEER','1721',to_date('09-JUN-81','DD-MON-RR'),'379',null,'389');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2662','FUMAROLA PASQUALE','TECHNICIAN','2017',to_date('09-JUN-81','DD-MON-RR'),'739',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2663','ESPOSITO IVANO','ENGINEER','2318',to_date('09-JUN-81','DD-MON-RR'),'1816',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2664','CALVINO PAOLO','SECRETARY','1403',to_date('09-JUN-81','DD-MON-RR'),'1306',null,'135');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2665','ESPOSITO UGO','MANAGER','101',to_date('09-JUN-81','DD-MON-RR'),'1556',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2666','NERI LUCIA','ENGINEER','600',to_date('09-JUN-81','DD-MON-RR'),'1586',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2667','NERI LUCA','MANAGER','1045',to_date('09-JUN-81','DD-MON-RR'),'1307',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2668','LEVI LUIGI','PHDSTUDENT','2058',to_date('09-JUN-81','DD-MON-RR'),'116',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2669','ECO ROBERTA','HEADMASTER','1682',to_date('09-JUN-81','DD-MON-RR'),'1424',null,'153');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2670','CORONA FEDERICO','SECRETARY','73',to_date('09-JUN-81','DD-MON-RR'),'1525',null,'298');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2671','ESPOSITO GIOVANNI','LAWYER','1750',to_date('09-JUN-81','DD-MON-RR'),'1109',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2672','NERI IVANO','HEADMASTER','445',to_date('09-JUN-81','DD-MON-RR'),'1901',null,'43');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2673','DANTE LUCA','PROFESSOR','1220',to_date('09-JUN-81','DD-MON-RR'),'1540',null,'166');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2674','ESPOSITO GAETANO','SECRETARY','2227',to_date('09-JUN-81','DD-MON-RR'),'1039',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2675','CALVINO FRANCESCO','PHDSTUDENT','2569',to_date('09-JUN-81','DD-MON-RR'),'898',null,'358');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2676','BIANCHI FEDERICO','PHDSTUDENT','809',to_date('09-JUN-81','DD-MON-RR'),'1089',null,'300');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2677','BIANCHI LUDOVICO','LAWYER','729',to_date('09-JUN-81','DD-MON-RR'),'1543',null,'55');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2678','CORONA GAETANO','MANAGER','1695',to_date('09-JUN-81','DD-MON-RR'),'1742',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2679','NERI CLARA','SUPERVISOR','1294',to_date('09-JUN-81','DD-MON-RR'),'1765',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2680','FUMAROLA LUDOVICO','HEADMASTER','1790',to_date('09-JUN-81','DD-MON-RR'),'1968',null,'80');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2681','LEVI PAOLO','MANAGER','1160',to_date('09-JUN-81','DD-MON-RR'),'1690',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2682','CORONA LUDOVICO','PHDSTUDENT','522',to_date('09-JUN-81','DD-MON-RR'),'1914',null,'485');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2683','LEVI ELENA','ENGINEER','1116',to_date('09-JUN-81','DD-MON-RR'),'1897',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2684','GRIMALDI LUCIA','SECRETARY','176',to_date('09-JUN-81','DD-MON-RR'),'795',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2685','MANZONI GIOVANNI','HEADMASTER','178',to_date('09-JUN-81','DD-MON-RR'),'1558',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2686','BIANCHI DAMIANO','MANAGER','744',to_date('09-JUN-81','DD-MON-RR'),'1195',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2687','DANTE FRANCESCO','LAWYER','193',to_date('09-JUN-81','DD-MON-RR'),'1653',null,'113');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2688','NERI ANDREA','PHDSTUDENT','1155',to_date('09-JUN-81','DD-MON-RR'),'1098',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2689','ESPOSITO FEDERICO','SUPERVISOR','2672',to_date('09-JUN-81','DD-MON-RR'),'1822',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2690','CALVINO UGO','LAWYER','1067',to_date('09-JUN-81','DD-MON-RR'),'665',null,'347');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2691','SANTE ALFONSO','MANAGER','899',to_date('09-JUN-81','DD-MON-RR'),'1673',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2692','COZZA MARIA','ENGINEER','510',to_date('09-JUN-81','DD-MON-RR'),'1560',null,'457');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2693','FO UGO','SUPERVISOR','2584',to_date('09-JUN-81','DD-MON-RR'),'507',null,'298');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2694','DANTE ELIO','ENGINEER','2312',to_date('09-JUN-81','DD-MON-RR'),'1869',null,'176');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2695','CARBONE ALFONSO','PROFESSOR','1555',to_date('09-JUN-81','DD-MON-RR'),'1030',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2696','LEVI MASSIMO','PROFESSOR','350',to_date('09-JUN-81','DD-MON-RR'),'886',null,'174');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2697','SANTE MASSIMO','SUPERVISOR','1819',to_date('09-JUN-81','DD-MON-RR'),'1105',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2698','LEOPARDI UGO','LAWYER','1721',to_date('09-JUN-81','DD-MON-RR'),'1858',null,'457');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2699','FUMAROLA MASSIMO','PROFESSOR','1830',to_date('09-JUN-81','DD-MON-RR'),'478',null,'395');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2700','COZZA COSIMO','TECHNICIAN','1759',to_date('09-JUN-81','DD-MON-RR'),'956',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2701','SANTE ANTONIO','PHDSTUDENT','312',to_date('09-JUN-81','DD-MON-RR'),'1758',null,'488');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2702','BIANCHI ANGELO','MANAGER','1407',to_date('09-JUN-81','DD-MON-RR'),'280',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2703','ESPOSITO ANTONIO','HEADMASTER','52',to_date('09-JUN-81','DD-MON-RR'),'737',null,'395');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2704','DANTE MASSIMO','MANAGER','2137',to_date('09-JUN-81','DD-MON-RR'),'564',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2705','DANTE SILVIA','LAWYER','1326',to_date('09-JUN-81','DD-MON-RR'),'1931',null,'395');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2706','PETRARCA ROBERTA','TECHNICIAN','1212',to_date('09-JUN-81','DD-MON-RR'),'1370',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2707','CORONA UMBERTO','LAWYER','2071',to_date('09-JUN-81','DD-MON-RR'),'1340',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2708','FO LUCIA','PHDSTUDENT','1407',to_date('09-JUN-81','DD-MON-RR'),'95',null,'62');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2709','PETRARCA IVANO','HEADMASTER','1308',to_date('09-JUN-81','DD-MON-RR'),'1545',null,'5');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2710','ECO MARIO','PROFESSOR','562',to_date('09-JUN-81','DD-MON-RR'),'1688',null,'145');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2711','ECO SILVIA','SECRETARY','1464',to_date('09-JUN-81','DD-MON-RR'),'414',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2712','NERI LUDOVICO','ENGINEER','2296',to_date('09-JUN-81','DD-MON-RR'),'795',null,'183');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('973','ECO FRANCESCO','TECHNICIAN','742',to_date('09-JUN-81','DD-MON-RR'),'224',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('974','LEVI ELIO','SUPERVISOR','51',to_date('09-JUN-81','DD-MON-RR'),'15',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('975','DANTE MARIO','MANAGER','26',to_date('09-JUN-81','DD-MON-RR'),'257',null,'140');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('976','LEVI ROBERTA','PHDSTUDENT','823',to_date('09-JUN-81','DD-MON-RR'),'256',null,'438');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4612','TIBALDI FEDERICO','ENGINEER','643',to_date('09-JUN-81','DD-MON-RR'),'1768',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4613','ESPOSITO ELIO','MANAGER','1904',to_date('09-JUN-81','DD-MON-RR'),'1052',null,'0');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4614','CARBONE ANDREA','SUPERVISOR','424',to_date('09-JUN-81','DD-MON-RR'),'1775',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4615','CORONA LUDOVICO','HEADMASTER','1053',to_date('09-JUN-81','DD-MON-RR'),'553',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4616','NERI UGO','MANAGER','4105',to_date('09-JUN-81','DD-MON-RR'),'138',null,'170');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4617','TIBALDI GIOVANNI','PROFESSOR','1867',to_date('09-JUN-81','DD-MON-RR'),'502',null,'5');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4618','PETRARCA LUIGI','PHDSTUDENT','3753',to_date('09-JUN-81','DD-MON-RR'),'728',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4619','LEVI DONATO','PHDSTUDENT','2679',to_date('09-JUN-81','DD-MON-RR'),'1910',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4620','CALVINO IVANO','TECHNICIAN','3530',to_date('09-JUN-81','DD-MON-RR'),'1149',null,'344');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4621','ESPOSITO ELENA','ENGINEER','3687',to_date('09-JUN-81','DD-MON-RR'),'9',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4622','CORONA PAOLO','SECRETARY','1226',to_date('09-JUN-81','DD-MON-RR'),'651',null,'387');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4623','BIANCHI SILVIA','SECRETARY','680',to_date('09-JUN-81','DD-MON-RR'),'1173',null,'44');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4624','LEVI FRANCESCO','PHDSTUDENT','517',to_date('09-JUN-81','DD-MON-RR'),'1959',null,'453');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4625','NERI ROBERTA','MANAGER','4533',to_date('09-JUN-81','DD-MON-RR'),'1109',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4626','CORONA IVANO','PHDSTUDENT','53',to_date('09-JUN-81','DD-MON-RR'),'1279',null,'474');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4627','ESPOSITO LUCIA','SUPERVISOR','4379',to_date('09-JUN-81','DD-MON-RR'),'86',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4628','GRIMALDI MARIA','MANAGER','2066',to_date('09-JUN-81','DD-MON-RR'),'934',null,'278');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4629','NERI DAMIANO','SECRETARY','2262',to_date('09-JUN-81','DD-MON-RR'),'246',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4630','LEVI LUCA','SECRETARY','3015',to_date('09-JUN-81','DD-MON-RR'),'1341',null,'140');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4631','DANTE ROBERTA','ENGINEER','1969',to_date('09-JUN-81','DD-MON-RR'),'703',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4632','SANTE ALFONSO','PHDSTUDENT','1136',to_date('09-JUN-81','DD-MON-RR'),'1443',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4633','TIBALDI ANDREA','MANAGER','1906',to_date('09-JUN-81','DD-MON-RR'),'1777',null,'185');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4634','PETRARCA IVANO','TECHNICIAN','4282',to_date('09-JUN-81','DD-MON-RR'),'1827',null,'252');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4635','FUMAROLA MASSIMO','TECHNICIAN','2716',to_date('09-JUN-81','DD-MON-RR'),'1923',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4636','ECO LUDOVICO','HEADMASTER','4588',to_date('09-JUN-81','DD-MON-RR'),'1735',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4637','FUMAROLA LUIGI','SUPERVISOR','1356',to_date('09-JUN-81','DD-MON-RR'),'975',null,'28');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4638','GRIMALDI DONATO','LAWYER','3615',to_date('09-JUN-81','DD-MON-RR'),'681',null,'193');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4639','TIBALDI LUCA','PROFESSOR','2473',to_date('09-JUN-81','DD-MON-RR'),'466',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4640','GRIMALDI GIOVANNI','TECHNICIAN','1092',to_date('09-JUN-81','DD-MON-RR'),'1358',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4641','SANTE ROBERTA','MANAGER','1443',to_date('09-JUN-81','DD-MON-RR'),'1071',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4642','LEOPARDI PASQUALE','PHDSTUDENT','952',to_date('09-JUN-81','DD-MON-RR'),'1161',null,'19');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4643','FO GIOVANNI','ENGINEER','3528',to_date('09-JUN-81','DD-MON-RR'),'472',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4644','DANTE FEDERICO','HEADMASTER','4459',to_date('09-JUN-81','DD-MON-RR'),'1839',null,'425');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4645','TIBALDI ELIO','LAWYER','3361',to_date('09-JUN-81','DD-MON-RR'),'388',null,'312');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4646','CORONA LUCIA','TECHNICIAN','759',to_date('09-JUN-81','DD-MON-RR'),'1216',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4647','CALVINO ROBERTA','MANAGER','108',to_date('09-JUN-81','DD-MON-RR'),'1368',null,'287');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4648','CARBONE CLARA','PROFESSOR','143',to_date('09-JUN-81','DD-MON-RR'),'1410',null,'134');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4649','TIBALDI DAMIANO','TECHNICIAN','4458',to_date('09-JUN-81','DD-MON-RR'),'1626',null,'287');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4650','CALVINO FEDERICO','MANAGER','3515',to_date('09-JUN-81','DD-MON-RR'),'447',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4651','DANTE PASQUALE','ENGINEER','2563',to_date('09-JUN-81','DD-MON-RR'),'218',null,'316');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4652','MANZONI ALFONSO','MANAGER','1173',to_date('09-JUN-81','DD-MON-RR'),'1210',null,'398');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4653','LEOPARDI DAMIANO','MANAGER','4000',to_date('09-JUN-81','DD-MON-RR'),'1396',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4654','SANTE ANTONIO','LAWYER','3641',to_date('09-JUN-81','DD-MON-RR'),'1995',null,'56');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4655','LEVI IVANO','TECHNICIAN','4143',to_date('09-JUN-81','DD-MON-RR'),'1129',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4656','NERI SILVIA','PROFESSOR','2990',to_date('09-JUN-81','DD-MON-RR'),'992',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4657','FUMAROLA DONATO','HEADMASTER','1804',to_date('09-JUN-81','DD-MON-RR'),'12',null,'39');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4658','PETRARCA IVANO','SUPERVISOR','4307',to_date('09-JUN-81','DD-MON-RR'),'1387',null,'222');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4659','MANZONI ANGELO','MANAGER','3127',to_date('09-JUN-81','DD-MON-RR'),'1207',null,'240');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4660','MANZONI LUDOVICO','ENGINEER','1849',to_date('09-JUN-81','DD-MON-RR'),'1701',null,'426');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4661','CORONA MASSIMO','LAWYER','70',to_date('09-JUN-81','DD-MON-RR'),'221',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4662','BIANCHI COSIMO','TECHNICIAN','1770',to_date('09-JUN-81','DD-MON-RR'),'1547',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4663','CORONA CLARA','PROFESSOR','949',to_date('09-JUN-81','DD-MON-RR'),'1763',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4664','CORONA IVANO','MANAGER','608',to_date('09-JUN-81','DD-MON-RR'),'1849',null,'4');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4665','BIANCHI ELIO','ENGINEER','4199',to_date('09-JUN-81','DD-MON-RR'),'211',null,'410');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4666','FO GIOVANNI','SECRETARY','2582',to_date('09-JUN-81','DD-MON-RR'),'707',null,'199');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4667','ESPOSITO UGO','SUPERVISOR','4193',to_date('09-JUN-81','DD-MON-RR'),'1280',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4668','PETRARCA CLARA','LAWYER','3939',to_date('09-JUN-81','DD-MON-RR'),'603',null,'199');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4669','COZZA GIOVANNI','HEADMASTER','3885',to_date('09-JUN-81','DD-MON-RR'),'159',null,'288');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4670','NERI FRANCESCO','SECRETARY','3783',to_date('09-JUN-81','DD-MON-RR'),'1182',null,'195');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4671','CALVINO LUIGI','SECRETARY','4294',to_date('09-JUN-81','DD-MON-RR'),'1797',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4672','LEVI UMBERTO','LAWYER','488',to_date('09-JUN-81','DD-MON-RR'),'1292',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4673','DANTE COSIMO','SECRETARY','840',to_date('09-JUN-81','DD-MON-RR'),'889',null,'192');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4674','PETRARCA PASQUALE','LAWYER','1072',to_date('09-JUN-81','DD-MON-RR'),'1408',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4675','FO LUDOVICO','PHDSTUDENT','424',to_date('09-JUN-81','DD-MON-RR'),'710',null,'347');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4676','CORONA LUIGI','ENGINEER','983',to_date('09-JUN-81','DD-MON-RR'),'1809',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4677','FO LUDOVICO','ENGINEER','2978',to_date('09-JUN-81','DD-MON-RR'),'656',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4678','COZZA DONATO','MANAGER','3289',to_date('09-JUN-81','DD-MON-RR'),'343',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4679','FO ELIO','SECRETARY','1972',to_date('09-JUN-81','DD-MON-RR'),'1959',null,'477');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4680','MANZONI ANGELO','LAWYER','4399',to_date('09-JUN-81','DD-MON-RR'),'1751',null,'427');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4681','CARBONE ALFONSO','MANAGER','3170',to_date('09-JUN-81','DD-MON-RR'),'1135',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4682','CALVINO MARIO','ENGINEER','1429',to_date('09-JUN-81','DD-MON-RR'),'995',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4683','CALVINO ELIO','TECHNICIAN','2689',to_date('09-JUN-81','DD-MON-RR'),'1643',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4684','COZZA LUDOVICO','PHDSTUDENT','959',to_date('09-JUN-81','DD-MON-RR'),'661',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4685','BIANCHI LUDOVICO','MANAGER','3094',to_date('09-JUN-81','DD-MON-RR'),'212',null,'426');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4686','PETRARCA DAMIANO','SUPERVISOR','1672',to_date('09-JUN-81','DD-MON-RR'),'839',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4687','BIANCHI GAETANO','MANAGER','340',to_date('09-JUN-81','DD-MON-RR'),'685',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4688','DANTE LUCIA','MANAGER','3098',to_date('09-JUN-81','DD-MON-RR'),'1113',null,'38');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4689','CALVINO IVANO','TECHNICIAN','1571',to_date('09-JUN-81','DD-MON-RR'),'1430',null,'158');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4690','NERI ANDREA','MANAGER','2361',to_date('09-JUN-81','DD-MON-RR'),'1072',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4691','FO GIOVANNI','MANAGER','2657',to_date('09-JUN-81','DD-MON-RR'),'817',null,'376');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4692','LEOPARDI MARIO','HEADMASTER','4610',to_date('09-JUN-81','DD-MON-RR'),'1168',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4693','TIBALDI FEDERICO','MANAGER','1755',to_date('09-JUN-81','DD-MON-RR'),'1232',null,'335');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4694','ESPOSITO PAOLO','SECRETARY','2054',to_date('09-JUN-81','DD-MON-RR'),'148',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4695','LEOPARDI ALFONSO','TECHNICIAN','1121',to_date('09-JUN-81','DD-MON-RR'),'208',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4696','FO SILVIA','PROFESSOR','761',to_date('09-JUN-81','DD-MON-RR'),'54',null,'385');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4697','NERI LUCA','PHDSTUDENT','3310',to_date('09-JUN-81','DD-MON-RR'),'707',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4698','BIANCHI LUDOVICO','MANAGER','4477',to_date('09-JUN-81','DD-MON-RR'),'1693',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4699','GRIMALDI DONATO','MANAGER','3793',to_date('09-JUN-81','DD-MON-RR'),'1471',null,'125');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4700','ESPOSITO CLARA','ENGINEER','2247',to_date('09-JUN-81','DD-MON-RR'),'1459',null,'477');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4701','FUMAROLA MARIO','MANAGER','700',to_date('09-JUN-81','DD-MON-RR'),'1441',null,'221');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4702','FUMAROLA GAETANO','PHDSTUDENT','947',to_date('09-JUN-81','DD-MON-RR'),'681',null,'84');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4703','GRIMALDI FEDERICO','TECHNICIAN','4183',to_date('09-JUN-81','DD-MON-RR'),'262',null,'243');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4704','NERI LUCIA','HEADMASTER','2370',to_date('09-JUN-81','DD-MON-RR'),'1127',null,'260');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4705','GRIMALDI DAMIANO','SUPERVISOR','2851',to_date('09-JUN-81','DD-MON-RR'),'1493',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4706','LEVI ANDREA','TECHNICIAN','4602',to_date('09-JUN-81','DD-MON-RR'),'1366',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4707','NERI ANDREA','ENGINEER','1109',to_date('09-JUN-81','DD-MON-RR'),'1607',null,'498');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4708','NERI ANGELO','MANAGER','210',to_date('09-JUN-81','DD-MON-RR'),'1522',null,'153');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4709','PETRARCA ALFONSO','ENGINEER','1497',to_date('09-JUN-81','DD-MON-RR'),'1185',null,'313');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4710','LEOPARDI PASQUALE','MANAGER','4009',to_date('09-JUN-81','DD-MON-RR'),'1907',null,'321');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4711','CORONA UGO','SECRETARY','4208',to_date('09-JUN-81','DD-MON-RR'),'986',null,'429');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4712','TIBALDI ROBERTA','SECRETARY','2695',to_date('09-JUN-81','DD-MON-RR'),'301',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4713','DANTE PAOLO','LAWYER','3517',to_date('09-JUN-81','DD-MON-RR'),'1198',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4714','FUMAROLA ANGELO','MANAGER','557',to_date('09-JUN-81','DD-MON-RR'),'899',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4715','LEVI PAOLO','MANAGER','3027',to_date('09-JUN-81','DD-MON-RR'),'280',null,'441');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4716','CALVINO MARIO','LAWYER','2175',to_date('09-JUN-81','DD-MON-RR'),'1252',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4717','ECO GIOVANNI','MANAGER','3694',to_date('09-JUN-81','DD-MON-RR'),'226',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4718','TIBALDI DAMIANO','ENGINEER','884',to_date('09-JUN-81','DD-MON-RR'),'859',null,'54');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4719','CALVINO PAOLO','MANAGER','355',to_date('09-JUN-81','DD-MON-RR'),'1204',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4720','DANTE MARIO','ENGINEER','2760',to_date('09-JUN-81','DD-MON-RR'),'1980',null,'60');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4721','COZZA FEDERICO','PHDSTUDENT','4079',to_date('09-JUN-81','DD-MON-RR'),'1472',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4722','ECO MASSIMO','ENGINEER','2646',to_date('09-JUN-81','DD-MON-RR'),'1680',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4723','PETRARCA LUCA','PHDSTUDENT','127',to_date('09-JUN-81','DD-MON-RR'),'154',null,'123');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4724','TIBALDI LUCA','ENGINEER','1784',to_date('09-JUN-81','DD-MON-RR'),'479',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4725','CARBONE ROBERTA','PHDSTUDENT','230',to_date('09-JUN-81','DD-MON-RR'),'961',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4726','SANTE DONATO','PROFESSOR','105',to_date('09-JUN-81','DD-MON-RR'),'1623',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4727','TIBALDI FRANCESCO','HEADMASTER','2473',to_date('09-JUN-81','DD-MON-RR'),'254',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4728','BIANCHI GIOVANNI','PHDSTUDENT','2250',to_date('09-JUN-81','DD-MON-RR'),'1341',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4729','CARBONE SILVIA','MANAGER','2155',to_date('09-JUN-81','DD-MON-RR'),'370',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4730','FO ANTONIO','LAWYER','2236',to_date('09-JUN-81','DD-MON-RR'),'605',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4731','DANTE LUIGI','ENGINEER','446',to_date('09-JUN-81','DD-MON-RR'),'988',null,'45');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4732','TIBALDI ANDREA','PHDSTUDENT','2463',to_date('09-JUN-81','DD-MON-RR'),'1039',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4733','GRIMALDI FEDERICO','SECRETARY','2721',to_date('09-JUN-81','DD-MON-RR'),'1307',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4734','LEVI LUIGI','ENGINEER','3969',to_date('09-JUN-81','DD-MON-RR'),'1666',null,'45');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4735','TIBALDI IVANO','PHDSTUDENT','3038',to_date('09-JUN-81','DD-MON-RR'),'191',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4736','CARBONE UMBERTO','PROFESSOR','1186',to_date('09-JUN-81','DD-MON-RR'),'672',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4737','COZZA DAMIANO','MANAGER','4726',to_date('09-JUN-81','DD-MON-RR'),'1271',null,'65');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4738','COZZA ALFONSO','MANAGER','997',to_date('09-JUN-81','DD-MON-RR'),'627',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4739','CALVINO CLARA','LAWYER','1024',to_date('09-JUN-81','DD-MON-RR'),'553',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4740','CALVINO ANTONIO','HEADMASTER','3099',to_date('09-JUN-81','DD-MON-RR'),'1421',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4741','BIANCHI ELIO','LAWYER','2003',to_date('09-JUN-81','DD-MON-RR'),'1866',null,'234');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4742','SANTE DAMIANO','MANAGER','3072',to_date('09-JUN-81','DD-MON-RR'),'543',null,'110');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4743','LEVI MARIO','SUPERVISOR','409',to_date('09-JUN-81','DD-MON-RR'),'529',null,'136');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4744','NERI MARIA','PROFESSOR','1834',to_date('09-JUN-81','DD-MON-RR'),'1581',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4745','PETRARCA ELIO','MANAGER','1678',to_date('09-JUN-81','DD-MON-RR'),'1505',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4746','TIBALDI LUDOVICO','MANAGER','1793',to_date('09-JUN-81','DD-MON-RR'),'955',null,'192');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3001','SANTE LUCIA','LAWYER','1425',to_date('09-JUN-81','DD-MON-RR'),'1502',null,'348');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5036','ESPOSITO ROBERTA','ENGINEER','1022',to_date('09-JUN-81','DD-MON-RR'),'1051',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5037','DANTE UGO','HEADMASTER','4546',to_date('09-JUN-81','DD-MON-RR'),'680',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5038','LEOPARDI UMBERTO','MANAGER','3075',to_date('09-JUN-81','DD-MON-RR'),'1107',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5039','ESPOSITO CLARA','LAWYER','1079',to_date('09-JUN-81','DD-MON-RR'),'1662',null,'84');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5040','COZZA DAMIANO','TECHNICIAN','1949',to_date('09-JUN-81','DD-MON-RR'),'1582',null,'451');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5041','CALVINO CLARA','LAWYER','3151',to_date('09-JUN-81','DD-MON-RR'),'1730',null,'374');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5042','LEOPARDI PAOLO','LAWYER','1828',to_date('09-JUN-81','DD-MON-RR'),'91',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5043','COZZA DAMIANO','HEADMASTER','24',to_date('09-JUN-81','DD-MON-RR'),'295',null,'132');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5044','GRIMALDI ROBERTA','PROFESSOR','1645',to_date('09-JUN-81','DD-MON-RR'),'252',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5045','DANTE PASQUALE','SUPERVISOR','961',to_date('09-JUN-81','DD-MON-RR'),'183',null,'214');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5046','CALVINO ANDREA','SECRETARY','1592',to_date('09-JUN-81','DD-MON-RR'),'347',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5047','CALVINO LUCA','MANAGER','3561',to_date('09-JUN-81','DD-MON-RR'),'301',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5048','NERI ANTONIO','ENGINEER','2006',to_date('09-JUN-81','DD-MON-RR'),'958',null,'415');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5049','PETRARCA MASSIMO','PHDSTUDENT','158',to_date('09-JUN-81','DD-MON-RR'),'1157',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5050','FUMAROLA PAOLO','LAWYER','4393',to_date('09-JUN-81','DD-MON-RR'),'528',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5051','FO CLARA','PROFESSOR','1973',to_date('09-JUN-81','DD-MON-RR'),'1345',null,'193');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5052','ESPOSITO CLARA','TECHNICIAN','2258',to_date('09-JUN-81','DD-MON-RR'),'885',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5053','ESPOSITO ALFONSO','TECHNICIAN','1389',to_date('09-JUN-81','DD-MON-RR'),'1055',null,'140');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5054','LEVI GAETANO','SUPERVISOR','4285',to_date('09-JUN-81','DD-MON-RR'),'441',null,'56');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5055','COZZA ANTONIO','SECRETARY','1471',to_date('09-JUN-81','DD-MON-RR'),'645',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5056','SANTE LUIGI','SUPERVISOR','862',to_date('09-JUN-81','DD-MON-RR'),'25',null,'240');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5057','CORONA PASQUALE','SUPERVISOR','3714',to_date('09-JUN-81','DD-MON-RR'),'1613',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5058','FUMAROLA ELIO','MANAGER','4363',to_date('09-JUN-81','DD-MON-RR'),'1348',null,'158');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6052','LEOPARDI MARIO','MANAGER','5978',to_date('09-JUN-81','DD-MON-RR'),'622',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6053','NERI GIOVANNI','PROFESSOR','3918',to_date('09-JUN-81','DD-MON-RR'),'1611',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6054','ECO ANGELO','LAWYER','3364',to_date('09-JUN-81','DD-MON-RR'),'794',null,'110');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6055','CORONA ELIO','PHDSTUDENT','5411',to_date('09-JUN-81','DD-MON-RR'),'1352',null,'201');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6056','CALVINO MARIA','MANAGER','1425',to_date('09-JUN-81','DD-MON-RR'),'1259',null,'407');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6057','ECO GAETANO','LAWYER','3840',to_date('09-JUN-81','DD-MON-RR'),'1938',null,'140');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6058','BIANCHI GAETANO','LAWYER','3613',to_date('09-JUN-81','DD-MON-RR'),'1852',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6059','ESPOSITO LUCIA','HEADMASTER','5919',to_date('09-JUN-81','DD-MON-RR'),'1667',null,'64');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6060','FUMAROLA FEDERICO','SECRETARY','4380',to_date('09-JUN-81','DD-MON-RR'),'1572',null,'271');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6061','BIANCHI ANGELO','PROFESSOR','2999',to_date('09-JUN-81','DD-MON-RR'),'197',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6062','ESPOSITO ANTONIO','PHDSTUDENT','1687',to_date('09-JUN-81','DD-MON-RR'),'468',null,'367');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6063','GRIMALDI MASSIMO','TECHNICIAN','3049',to_date('09-JUN-81','DD-MON-RR'),'845',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6064','FO LUIGI','HEADMASTER','5973',to_date('09-JUN-81','DD-MON-RR'),'1473',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6065','FO IVANO','MANAGER','5946',to_date('09-JUN-81','DD-MON-RR'),'1315',null,'365');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6066','LEVI MARIO','PROFESSOR','4110',to_date('09-JUN-81','DD-MON-RR'),'556',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6067','PETRARCA FRANCESCO','MANAGER','1389',to_date('09-JUN-81','DD-MON-RR'),'1731',null,'263');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6068','FUMAROLA DONATO','TECHNICIAN','5946',to_date('09-JUN-81','DD-MON-RR'),'1855',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6069','GRIMALDI DAMIANO','HEADMASTER','850',to_date('09-JUN-81','DD-MON-RR'),'331',null,'136');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6070','TIBALDI PAOLO','PHDSTUDENT','837',to_date('09-JUN-81','DD-MON-RR'),'520',null,'432');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6071','CARBONE FEDERICO','HEADMASTER','2815',to_date('09-JUN-81','DD-MON-RR'),'921',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6072','MANZONI DAMIANO','LAWYER','2736',to_date('09-JUN-81','DD-MON-RR'),'304',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6073','CORONA ALFONSO','PHDSTUDENT','2021',to_date('09-JUN-81','DD-MON-RR'),'194',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6074','GRIMALDI LUIGI','HEADMASTER','3926',to_date('09-JUN-81','DD-MON-RR'),'316',null,'39');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6075','CARBONE LUCIA','SUPERVISOR','779',to_date('09-JUN-81','DD-MON-RR'),'978',null,'309');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6076','LEVI ANTONIO','HEADMASTER','3907',to_date('09-JUN-81','DD-MON-RR'),'1644',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6077','BIANCHI ANGELO','MANAGER','518',to_date('09-JUN-81','DD-MON-RR'),'860',null,'469');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6078','CALVINO UGO','SECRETARY','1651',to_date('09-JUN-81','DD-MON-RR'),'1483',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6079','BIANCHI LUIGI','SUPERVISOR','5581',to_date('09-JUN-81','DD-MON-RR'),'995',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6080','DANTE LUCIA','MANAGER','2167',to_date('09-JUN-81','DD-MON-RR'),'1092',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6081','LEOPARDI DONATO','TECHNICIAN','2301',to_date('09-JUN-81','DD-MON-RR'),'366',null,'176');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6082','TIBALDI GAETANO','TECHNICIAN','174',to_date('09-JUN-81','DD-MON-RR'),'1678',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6083','CORONA UMBERTO','MANAGER','149',to_date('09-JUN-81','DD-MON-RR'),'1154',null,'456');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6084','CARBONE FRANCESCO','SECRETARY','2132',to_date('09-JUN-81','DD-MON-RR'),'1000',null,'130');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6085','FO GIOVANNI','SECRETARY','2208',to_date('09-JUN-81','DD-MON-RR'),'1708',null,'112');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6086','GRIMALDI LUIGI','MANAGER','389',to_date('09-JUN-81','DD-MON-RR'),'417',null,'474');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6087','LEOPARDI GIOVANNI','ENGINEER','4550',to_date('09-JUN-81','DD-MON-RR'),'958',null,'271');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6088','NERI MARIA','PROFESSOR','4140',to_date('09-JUN-81','DD-MON-RR'),'943',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6089','SANTE LUCIA','SECRETARY','2169',to_date('09-JUN-81','DD-MON-RR'),'1',null,'253');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6090','FO UMBERTO','PROFESSOR','1811',to_date('09-JUN-81','DD-MON-RR'),'89',null,'429');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6091','COZZA PAOLO','PROFESSOR','1762',to_date('09-JUN-81','DD-MON-RR'),'1285',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6092','PETRARCA LUCIA','SUPERVISOR','5739',to_date('09-JUN-81','DD-MON-RR'),'1613',null,'413');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6093','SANTE LUDOVICO','PROFESSOR','2027',to_date('09-JUN-81','DD-MON-RR'),'1992',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6094','TIBALDI ELENA','LAWYER','4662',to_date('09-JUN-81','DD-MON-RR'),'1889',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6095','ESPOSITO COSIMO','TECHNICIAN','1689',to_date('09-JUN-81','DD-MON-RR'),'1720',null,'61');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6096','NERI DAMIANO','TECHNICIAN','5027',to_date('09-JUN-81','DD-MON-RR'),'1345',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6097','TIBALDI CLARA','SECRETARY','425',to_date('09-JUN-81','DD-MON-RR'),'1707',null,'105');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6098','GRIMALDI FRANCESCO','TECHNICIAN','1043',to_date('09-JUN-81','DD-MON-RR'),'1342',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6099','NERI ANTONIO','MANAGER','1910',to_date('09-JUN-81','DD-MON-RR'),'389',null,'28');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6100','LEOPARDI GAETANO','ENGINEER','4810',to_date('09-JUN-81','DD-MON-RR'),'1488',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6101','COZZA DAMIANO','TECHNICIAN','3749',to_date('09-JUN-81','DD-MON-RR'),'1409',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6102','GRIMALDI FRANCESCO','PROFESSOR','2223',to_date('09-JUN-81','DD-MON-RR'),'993',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6103','ESPOSITO ANTONIO','LAWYER','625',to_date('09-JUN-81','DD-MON-RR'),'1129',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6104','NERI MARIA','PROFESSOR','4503',to_date('09-JUN-81','DD-MON-RR'),'1589',null,'468');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6105','DANTE DONATO','PROFESSOR','2527',to_date('09-JUN-81','DD-MON-RR'),'587',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6106','ECO DAMIANO','TECHNICIAN','4622',to_date('09-JUN-81','DD-MON-RR'),'1640',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6107','COZZA CLARA','TECHNICIAN','4525',to_date('09-JUN-81','DD-MON-RR'),'289',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6108','FO CLARA','LAWYER','4173',to_date('09-JUN-81','DD-MON-RR'),'1645',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6109','LEVI MARIA','MANAGER','4501',to_date('09-JUN-81','DD-MON-RR'),'372',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6110','ESPOSITO FRANCESCO','LAWYER','465',to_date('09-JUN-81','DD-MON-RR'),'789',null,'344');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6111','LEVI IVANO','MANAGER','1533',to_date('09-JUN-81','DD-MON-RR'),'91',null,'357');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6112','ECO FRANCESCO','ENGINEER','871',to_date('09-JUN-81','DD-MON-RR'),'159',null,'320');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6113','CALVINO ANDREA','LAWYER','5183',to_date('09-JUN-81','DD-MON-RR'),'1611',null,'91');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6114','BIANCHI PASQUALE','PHDSTUDENT','3411',to_date('09-JUN-81','DD-MON-RR'),'1076',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6115','FUMAROLA FEDERICO','MANAGER','5166',to_date('09-JUN-81','DD-MON-RR'),'574',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6116','MANZONI GIOVANNI','MANAGER','2629',to_date('09-JUN-81','DD-MON-RR'),'1523',null,'263');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6117','DANTE CLARA','ENGINEER','3924',to_date('09-JUN-81','DD-MON-RR'),'1775',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6118','COZZA SILVIA','TECHNICIAN','3930',to_date('09-JUN-81','DD-MON-RR'),'1068',null,'437');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6119','CORONA LUCIA','SUPERVISOR','2796',to_date('09-JUN-81','DD-MON-RR'),'1108',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6120','CORONA ANGELO','SECRETARY','446',to_date('09-JUN-81','DD-MON-RR'),'1696',null,'356');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6121','BIANCHI ALFONSO','MANAGER','4578',to_date('09-JUN-81','DD-MON-RR'),'1625',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6122','CARBONE LUDOVICO','LAWYER','868',to_date('09-JUN-81','DD-MON-RR'),'1199',null,'309');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6123','LEVI GIOVANNI','SUPERVISOR','958',to_date('09-JUN-81','DD-MON-RR'),'1048',null,'419');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6124','ESPOSITO COSIMO','PHDSTUDENT','4329',to_date('09-JUN-81','DD-MON-RR'),'1613',null,'194');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6125','CORONA FRANCESCO','PROFESSOR','2121',to_date('09-JUN-81','DD-MON-RR'),'308',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6126','FUMAROLA DAMIANO','TECHNICIAN','1732',to_date('09-JUN-81','DD-MON-RR'),'336',null,'217');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6127','LEOPARDI ANGELO','SECRETARY','6120',to_date('09-JUN-81','DD-MON-RR'),'1171',null,'496');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6128','ESPOSITO ELIO','PROFESSOR','5647',to_date('09-JUN-81','DD-MON-RR'),'1659',null,'199');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6129','BIANCHI GAETANO','MANAGER','3644',to_date('09-JUN-81','DD-MON-RR'),'1136',null,'277');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6130','SANTE LUCA','TECHNICIAN','2300',to_date('09-JUN-81','DD-MON-RR'),'1671',null,'395');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6131','ESPOSITO LUCIA','PROFESSOR','1457',to_date('09-JUN-81','DD-MON-RR'),'354',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6132','ECO LUCIA','PHDSTUDENT','404',to_date('09-JUN-81','DD-MON-RR'),'888',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6133','FO SILVIA','PROFESSOR','5725',to_date('09-JUN-81','DD-MON-RR'),'1966',null,'456');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6134','ESPOSITO LUIGI','PHDSTUDENT','497',to_date('09-JUN-81','DD-MON-RR'),'675',null,'170');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6135','COZZA FEDERICO','SECRETARY','1675',to_date('09-JUN-81','DD-MON-RR'),'1393',null,'333');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6136','GRIMALDI ANDREA','TECHNICIAN','1688',to_date('09-JUN-81','DD-MON-RR'),'1098',null,'369');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6137','LEVI ANTONIO','SECRETARY','2934',to_date('09-JUN-81','DD-MON-RR'),'576',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6138','TIBALDI PASQUALE','ENGINEER','5953',to_date('09-JUN-81','DD-MON-RR'),'561',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6139','FO LUDOVICO','MANAGER','4028',to_date('09-JUN-81','DD-MON-RR'),'1388',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6140','CARBONE MARIA','LAWYER','5089',to_date('09-JUN-81','DD-MON-RR'),'1207',null,'386');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6141','MANZONI SILVIA','LAWYER','346',to_date('09-JUN-81','DD-MON-RR'),'1885',null,'316');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6142','NERI ELIO','MANAGER','6012',to_date('09-JUN-81','DD-MON-RR'),'151',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6143','NERI LUDOVICO','PHDSTUDENT','1827',to_date('09-JUN-81','DD-MON-RR'),'1865',null,'386');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6144','MANZONI ROBERTA','TECHNICIAN','2382',to_date('09-JUN-81','DD-MON-RR'),'943',null,'39');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6145','SANTE PAOLO','MANAGER','1344',to_date('09-JUN-81','DD-MON-RR'),'596',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6146','NERI ELIO','HEADMASTER','467',to_date('09-JUN-81','DD-MON-RR'),'1700',null,'312');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6147','LEOPARDI MARIA','PROFESSOR','3478',to_date('09-JUN-81','DD-MON-RR'),'1247',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6148','COZZA CLARA','PROFESSOR','1239',to_date('09-JUN-81','DD-MON-RR'),'1057',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6149','LEVI COSIMO','PROFESSOR','2208',to_date('09-JUN-81','DD-MON-RR'),'1775',null,'240');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6150','FO UGO','SUPERVISOR','5221',to_date('09-JUN-81','DD-MON-RR'),'497',null,'124');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6151','PETRARCA PAOLO','SECRETARY','3351',to_date('09-JUN-81','DD-MON-RR'),'633',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6152','ECO SILVIA','PROFESSOR','2406',to_date('09-JUN-81','DD-MON-RR'),'1184',null,'80');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6153','TIBALDI GIOVANNI','SECRETARY','5840',to_date('09-JUN-81','DD-MON-RR'),'1008',null,'460');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6154','NERI FEDERICO','TECHNICIAN','928',to_date('09-JUN-81','DD-MON-RR'),'1674',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6155','LEVI ALFONSO','SECRETARY','3574',to_date('09-JUN-81','DD-MON-RR'),'250',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6156','CARBONE ANDREA','PROFESSOR','5361',to_date('09-JUN-81','DD-MON-RR'),'1066',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6157','NERI FRANCESCO','HEADMASTER','1847',to_date('09-JUN-81','DD-MON-RR'),'187',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6158','SANTE ELENA','MANAGER','5253',to_date('09-JUN-81','DD-MON-RR'),'1462',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6159','NERI SILVIA','ENGINEER','1197',to_date('09-JUN-81','DD-MON-RR'),'49',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6160','CALVINO COSIMO','PHDSTUDENT','5178',to_date('09-JUN-81','DD-MON-RR'),'473',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6161','CORONA FRANCESCO','ENGINEER','1573',to_date('09-JUN-81','DD-MON-RR'),'1873',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6162','FO COSIMO','MANAGER','3514',to_date('09-JUN-81','DD-MON-RR'),'1999',null,'301');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7455','ECO MASSIMO','MANAGER','666',to_date('09-JUN-81','DD-MON-RR'),'187',null,'220');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('551','DANTE ELENA','MANAGER','369',to_date('09-JUN-81','DD-MON-RR'),'1148',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('552','ESPOSITO SILVIA','MANAGER','541',to_date('09-JUN-81','DD-MON-RR'),'1810',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('553','MANZONI ANDREA','LAWYER','390',to_date('09-JUN-81','DD-MON-RR'),'213',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('554','DANTE ROBERTA','MANAGER','268',to_date('09-JUN-81','DD-MON-RR'),'996',null,'394');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('555','LEOPARDI FRANCESCO','SUPERVISOR','357',to_date('09-JUN-81','DD-MON-RR'),'910',null,'28');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('556','SANTE UMBERTO','ENGINEER','291',to_date('09-JUN-81','DD-MON-RR'),'167',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('557','BIANCHI LUCIA','SECRETARY','248',to_date('09-JUN-81','DD-MON-RR'),'1835',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('558','LEOPARDI DONATO','MANAGER','327',to_date('09-JUN-81','DD-MON-RR'),'1422',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('559','CORONA PASQUALE','SUPERVISOR','453',to_date('09-JUN-81','DD-MON-RR'),'1121',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('560','PETRARCA SILVIA','SUPERVISOR','543',to_date('09-JUN-81','DD-MON-RR'),'1812',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('561','CALVINO ANDREA','HEADMASTER','384',to_date('09-JUN-81','DD-MON-RR'),'1016',null,'6');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('562','ESPOSITO LUCIA','TECHNICIAN','86',to_date('09-JUN-81','DD-MON-RR'),'124',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('563','PETRARCA IVANO','ENGINEER','250',to_date('09-JUN-81','DD-MON-RR'),'457',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('564','ESPOSITO FEDERICO','PROFESSOR','214',to_date('09-JUN-81','DD-MON-RR'),'709',null,'110');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('565','NERI SILVIA','MANAGER','348',to_date('09-JUN-81','DD-MON-RR'),'1852',null,'194');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('566','CALVINO LUCA','TECHNICIAN','35',to_date('09-JUN-81','DD-MON-RR'),'1280',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('567','ESPOSITO GAETANO','PHDSTUDENT','13',to_date('09-JUN-81','DD-MON-RR'),'1426',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('568','GRIMALDI LUIGI','ENGINEER','432',to_date('09-JUN-81','DD-MON-RR'),'905',null,'214');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('569','CARBONE DONATO','SUPERVISOR','1',to_date('09-JUN-81','DD-MON-RR'),'1072',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('570','CORONA LUCIA','ENGINEER','402',to_date('09-JUN-81','DD-MON-RR'),'1422',null,'104');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('571','PETRARCA PASQUALE','HEADMASTER','266',to_date('09-JUN-81','DD-MON-RR'),'1812',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('572','LEOPARDI LUCIA','MANAGER','483',to_date('09-JUN-81','DD-MON-RR'),'7',null,'38');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('573','ESPOSITO DAMIANO','PROFESSOR','347',to_date('09-JUN-81','DD-MON-RR'),'1307',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('574','FO IVANO','MANAGER','5',to_date('09-JUN-81','DD-MON-RR'),'1',null,'114');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('575','LEOPARDI UGO','SECRETARY','356',to_date('09-JUN-81','DD-MON-RR'),'1860',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('576','ECO LUCIA','SUPERVISOR','571',to_date('09-JUN-81','DD-MON-RR'),'985',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('577','LEVI MARIA','ENGINEER','91',to_date('09-JUN-81','DD-MON-RR'),'1373',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('578','CORONA ALFONSO','HEADMASTER','184',to_date('09-JUN-81','DD-MON-RR'),'1396',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('579','LEOPARDI ROBERTA','PROFESSOR','316',to_date('09-JUN-81','DD-MON-RR'),'1485',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('580','DANTE LUCA','MANAGER','56',to_date('09-JUN-81','DD-MON-RR'),'1398',null,'233');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('581','NERI PAOLO','SECRETARY','4',to_date('09-JUN-81','DD-MON-RR'),'1042',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('582','SANTE MARIA','HEADMASTER','324',to_date('09-JUN-81','DD-MON-RR'),'953',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('583','ESPOSITO MARIO','MANAGER','576',to_date('09-JUN-81','DD-MON-RR'),'60',null,'151');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('584','MANZONI LUCA','PROFESSOR','360',to_date('09-JUN-81','DD-MON-RR'),'863',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('585','COZZA PASQUALE','ENGINEER','274',to_date('09-JUN-81','DD-MON-RR'),'609',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('586','SANTE ROBERTA','LAWYER','251',to_date('09-JUN-81','DD-MON-RR'),'886',null,'304');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('587','DANTE CLARA','LAWYER','141',to_date('09-JUN-81','DD-MON-RR'),'1586',null,'201');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('588','TIBALDI GAETANO','MANAGER','211',to_date('09-JUN-81','DD-MON-RR'),'215',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('589','LEOPARDI UMBERTO','PHDSTUDENT','413',to_date('09-JUN-81','DD-MON-RR'),'58',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('590','ECO DAMIANO','PHDSTUDENT','201',to_date('09-JUN-81','DD-MON-RR'),'858',null,'487');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('591','CALVINO LUIGI','SECRETARY','584',to_date('09-JUN-81','DD-MON-RR'),'1592',null,'426');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('592','ECO ELIO','TECHNICIAN','310',to_date('09-JUN-81','DD-MON-RR'),'904',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('593','NERI ELIO','PROFESSOR','24',to_date('09-JUN-81','DD-MON-RR'),'1134',null,'54');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('594','CORONA MARIA','HEADMASTER','129',to_date('09-JUN-81','DD-MON-RR'),'1865',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('595','NERI COSIMO','SUPERVISOR','207',to_date('09-JUN-81','DD-MON-RR'),'1514',null,'469');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('596','SANTE SILVIA','ENGINEER','436',to_date('09-JUN-81','DD-MON-RR'),'1293',null,'51');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('597','DANTE ANTONIO','MANAGER','402',to_date('09-JUN-81','DD-MON-RR'),'1536',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('598','MANZONI IVANO','MANAGER','332',to_date('09-JUN-81','DD-MON-RR'),'1474',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('599','LEVI LUCIA','SUPERVISOR','111',to_date('09-JUN-81','DD-MON-RR'),'283',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('600','BIANCHI LUCIA','SUPERVISOR','148',to_date('09-JUN-81','DD-MON-RR'),'340',null,'438');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('601','DANTE GIOVANNI','PHDSTUDENT','296',to_date('09-JUN-81','DD-MON-RR'),'451',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('602','SANTE UGO','LAWYER','546',to_date('09-JUN-81','DD-MON-RR'),'967',null,'97');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('603','FO COSIMO','SECRETARY','390',to_date('09-JUN-81','DD-MON-RR'),'1191',null,'313');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('604','GRIMALDI GAETANO','HEADMASTER','579',to_date('09-JUN-81','DD-MON-RR'),'896',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('605','MANZONI IVANO','TECHNICIAN','473',to_date('09-JUN-81','DD-MON-RR'),'863',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('606','FUMAROLA PASQUALE','HEADMASTER','118',to_date('09-JUN-81','DD-MON-RR'),'222',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('607','COZZA MARIO','LAWYER','487',to_date('09-JUN-81','DD-MON-RR'),'1228',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('608','MANZONI IVANO','SECRETARY','539',to_date('09-JUN-81','DD-MON-RR'),'1870',null,'166');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('609','CORONA LUDOVICO','HEADMASTER','40',to_date('09-JUN-81','DD-MON-RR'),'162',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('610','GRIMALDI PAOLO','LAWYER','167',to_date('09-JUN-81','DD-MON-RR'),'1055',null,'329');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('611','TIBALDI ELENA','SECRETARY','84',to_date('09-JUN-81','DD-MON-RR'),'765',null,'194');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('612','TIBALDI ROBERTA','PHDSTUDENT','463',to_date('09-JUN-81','DD-MON-RR'),'1124',null,'354');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('613','CARBONE FRANCESCO','MANAGER','118',to_date('09-JUN-81','DD-MON-RR'),'892',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('614','FO MASSIMO','MANAGER','74',to_date('09-JUN-81','DD-MON-RR'),'53',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('615','GRIMALDI ALFONSO','SUPERVISOR','241',to_date('09-JUN-81','DD-MON-RR'),'122',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('616','SANTE UGO','MANAGER','203',to_date('09-JUN-81','DD-MON-RR'),'320',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('617','LEOPARDI MASSIMO','SUPERVISOR','502',to_date('09-JUN-81','DD-MON-RR'),'921',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('618','COZZA ANDREA','MANAGER','322',to_date('09-JUN-81','DD-MON-RR'),'219',null,'153');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('619','LEVI ROBERTA','TECHNICIAN','315',to_date('09-JUN-81','DD-MON-RR'),'1515',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('620','ECO ROBERTA','LAWYER','325',to_date('09-JUN-81','DD-MON-RR'),'630',null,'71');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('621','TIBALDI LUDOVICO','ENGINEER','329',to_date('09-JUN-81','DD-MON-RR'),'1396',null,'162');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('622','CARBONE FEDERICO','SECRETARY','155',to_date('09-JUN-81','DD-MON-RR'),'465',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('623','CORONA COSIMO','MANAGER','256',to_date('09-JUN-81','DD-MON-RR'),'556',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('624','CORONA COSIMO','SECRETARY','616',to_date('09-JUN-81','DD-MON-RR'),'482',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('625','FO GAETANO','LAWYER','228',to_date('09-JUN-81','DD-MON-RR'),'823',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('626','GRIMALDI UMBERTO','MANAGER','421',to_date('09-JUN-81','DD-MON-RR'),'1753',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('627','CALVINO MASSIMO','PHDSTUDENT','16',to_date('09-JUN-81','DD-MON-RR'),'1272',null,'432');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('628','CARBONE SILVIA','TECHNICIAN','578',to_date('09-JUN-81','DD-MON-RR'),'1199',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('629','BIANCHI FRANCESCO','HEADMASTER','370',to_date('09-JUN-81','DD-MON-RR'),'614',null,'436');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('630','LEOPARDI MARIO','TECHNICIAN','208',to_date('09-JUN-81','DD-MON-RR'),'1911',null,'84');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('631','LEOPARDI SILVIA','LAWYER','626',to_date('09-JUN-81','DD-MON-RR'),'276',null,'196');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('632','CALVINO MARIO','MANAGER','530',to_date('09-JUN-81','DD-MON-RR'),'327',null,'207');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('633','GRIMALDI FRANCESCO','ENGINEER','205',to_date('09-JUN-81','DD-MON-RR'),'1203',null,'101');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('634','BIANCHI PASQUALE','TECHNICIAN','541',to_date('09-JUN-81','DD-MON-RR'),'1256',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('635','DANTE SILVIA','MANAGER','307',to_date('09-JUN-81','DD-MON-RR'),'915',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('636','CORONA ANTONIO','TECHNICIAN','107',to_date('09-JUN-81','DD-MON-RR'),'1858',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('637','MANZONI COSIMO','MANAGER','217',to_date('09-JUN-81','DD-MON-RR'),'1951',null,'139');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('638','ECO LUIGI','HEADMASTER','229',to_date('09-JUN-81','DD-MON-RR'),'6',null,'280');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('639','NERI LUDOVICO','MANAGER','54',to_date('09-JUN-81','DD-MON-RR'),'161',null,'114');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('640','DANTE ANGELO','PROFESSOR','213',to_date('09-JUN-81','DD-MON-RR'),'582',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('641','TIBALDI GAETANO','SUPERVISOR','353',to_date('09-JUN-81','DD-MON-RR'),'229',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('642','LEOPARDI ANTONIO','MANAGER','414',to_date('09-JUN-81','DD-MON-RR'),'35',null,'395');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('643','COZZA ROBERTA','ENGINEER','569',to_date('09-JUN-81','DD-MON-RR'),'269',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('644','CARBONE COSIMO','MANAGER','30',to_date('09-JUN-81','DD-MON-RR'),'1564',null,'389');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('645','FO ELENA','TECHNICIAN','407',to_date('09-JUN-81','DD-MON-RR'),'61',null,'438');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('646','LEVI ALFONSO','PHDSTUDENT','124',to_date('09-JUN-81','DD-MON-RR'),'584',null,'468');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('647','CORONA ELIO','ENGINEER','443',to_date('09-JUN-81','DD-MON-RR'),'937',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('648','FO SILVIA','HEADMASTER','611',to_date('09-JUN-81','DD-MON-RR'),'559',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('649','TIBALDI FEDERICO','TECHNICIAN','74',to_date('09-JUN-81','DD-MON-RR'),'1549',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('650','TIBALDI DONATO','ENGINEER','312',to_date('09-JUN-81','DD-MON-RR'),'1364',null,'373');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('651','SANTE IVANO','SECRETARY','117',to_date('09-JUN-81','DD-MON-RR'),'637',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('652','TIBALDI LUCA','SECRETARY','476',to_date('09-JUN-81','DD-MON-RR'),'1747',null,'36');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('653','ESPOSITO CLARA','SUPERVISOR','501',to_date('09-JUN-81','DD-MON-RR'),'586',null,'373');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('654','DANTE LUDOVICO','TECHNICIAN','357',to_date('09-JUN-81','DD-MON-RR'),'1650',null,'124');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('655','PETRARCA LUDOVICO','PROFESSOR','185',to_date('09-JUN-81','DD-MON-RR'),'400',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('656','FO ALFONSO','TECHNICIAN','340',to_date('09-JUN-81','DD-MON-RR'),'1475',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('657','CORONA GIOVANNI','TECHNICIAN','593',to_date('09-JUN-81','DD-MON-RR'),'1169',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('658','ESPOSITO ELIO','SUPERVISOR','291',to_date('09-JUN-81','DD-MON-RR'),'1428',null,'65');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('659','CARBONE LUCIA','LAWYER','436',to_date('09-JUN-81','DD-MON-RR'),'1136',null,'333');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('660','CALVINO LUCIA','MANAGER','138',to_date('09-JUN-81','DD-MON-RR'),'836',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('661','CORONA COSIMO','LAWYER','196',to_date('09-JUN-81','DD-MON-RR'),'1935',null,'441');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('662','COZZA LUIGI','MANAGER','224',to_date('09-JUN-81','DD-MON-RR'),'343',null,'160');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('663','ECO GAETANO','MANAGER','440',to_date('09-JUN-81','DD-MON-RR'),'1180',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('664','SANTE ANDREA','MANAGER','423',to_date('09-JUN-81','DD-MON-RR'),'884',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('665','LEOPARDI FRANCESCO','PHDSTUDENT','458',to_date('09-JUN-81','DD-MON-RR'),'1125',null,'62');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('666','SANTE SILVIA','TECHNICIAN','280',to_date('09-JUN-81','DD-MON-RR'),'102',null,'271');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('667','FUMAROLA MARIO','SUPERVISOR','26',to_date('09-JUN-81','DD-MON-RR'),'226',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('668','DANTE ANDREA','SUPERVISOR','419',to_date('09-JUN-81','DD-MON-RR'),'1211',null,'359');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('669','DANTE ELIO','ENGINEER','411',to_date('09-JUN-81','DD-MON-RR'),'78',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('670','NERI ANGELO','SECRETARY','600',to_date('09-JUN-81','DD-MON-RR'),'65',null,'428');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('671','FO MARIO','LAWYER','399',to_date('09-JUN-81','DD-MON-RR'),'1458',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('672','DANTE MARIA','SECRETARY','636',to_date('09-JUN-81','DD-MON-RR'),'141',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('673','CORONA MARIA','ENGINEER','39',to_date('09-JUN-81','DD-MON-RR'),'120',null,'48');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('674','DANTE PAOLO','MANAGER','186',to_date('09-JUN-81','DD-MON-RR'),'572',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('675','GRIMALDI MASSIMO','MANAGER','345',to_date('09-JUN-81','DD-MON-RR'),'739',null,'456');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('676','CARBONE DAMIANO','MANAGER','661',to_date('09-JUN-81','DD-MON-RR'),'1973',null,'475');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('677','CARBONE PAOLO','HEADMASTER','51',to_date('09-JUN-81','DD-MON-RR'),'144',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('678','ESPOSITO LUCA','ENGINEER','79',to_date('09-JUN-81','DD-MON-RR'),'120',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('679','CALVINO LUDOVICO','SUPERVISOR','483',to_date('09-JUN-81','DD-MON-RR'),'231',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('680','ECO LUDOVICO','SUPERVISOR','87',to_date('09-JUN-81','DD-MON-RR'),'1691',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('681','CORONA LUIGI','MANAGER','177',to_date('09-JUN-81','DD-MON-RR'),'385',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('682','ESPOSITO PAOLO','LAWYER','131',to_date('09-JUN-81','DD-MON-RR'),'1819',null,'460');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('683','LEOPARDI ELIO','MANAGER','499',to_date('09-JUN-81','DD-MON-RR'),'1307',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('684','LEVI UGO','MANAGER','336',to_date('09-JUN-81','DD-MON-RR'),'1157',null,'468');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('685','CORONA IVANO','PHDSTUDENT','663',to_date('09-JUN-81','DD-MON-RR'),'1910',null,'58');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('413','FUMAROLA ANGELO','SECRETARY','84',to_date('09-JUN-81','DD-MON-RR'),'1467',null,'43');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('977','BIANCHI ALFONSO','MANAGER','628',to_date('09-JUN-81','DD-MON-RR'),'810',null,'113');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('978','TIBALDI ANGELO','ENGINEER','32',to_date('09-JUN-81','DD-MON-RR'),'1594',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('979','CARBONE LUCA','SUPERVISOR','356',to_date('09-JUN-81','DD-MON-RR'),'1026',null,'5');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('980','ECO PASQUALE','SUPERVISOR','197',to_date('09-JUN-81','DD-MON-RR'),'449',null,'166');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('981','SANTE LUCIA','LAWYER','475',to_date('09-JUN-81','DD-MON-RR'),'1303',null,'443');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('982','LEVI LUIGI','SECRETARY','95',to_date('09-JUN-81','DD-MON-RR'),'571',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('983','DANTE FRANCESCO','HEADMASTER','881',to_date('09-JUN-81','DD-MON-RR'),'298',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('984','FO FRANCESCO','SECRETARY','576',to_date('09-JUN-81','DD-MON-RR'),'1163',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('985','GRIMALDI ANDREA','MANAGER','788',to_date('09-JUN-81','DD-MON-RR'),'697',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('986','ESPOSITO ELIO','HEADMASTER','879',to_date('09-JUN-81','DD-MON-RR'),'630',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('987','LEVI MARIO','PROFESSOR','241',to_date('09-JUN-81','DD-MON-RR'),'1546',null,'243');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('988','GRIMALDI UGO','HEADMASTER','21',to_date('09-JUN-81','DD-MON-RR'),'1990',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('989','PETRARCA IVANO','SUPERVISOR','877',to_date('09-JUN-81','DD-MON-RR'),'325',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('990','LEVI FEDERICO','LAWYER','433',to_date('09-JUN-81','DD-MON-RR'),'1120',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('991','FUMAROLA GIOVANNI','TECHNICIAN','439',to_date('09-JUN-81','DD-MON-RR'),'1168',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('992','CARBONE ELENA','MANAGER','202',to_date('09-JUN-81','DD-MON-RR'),'1216',null,'320');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('993','CARBONE LUDOVICO','PHDSTUDENT','292',to_date('09-JUN-81','DD-MON-RR'),'1491',null,'367');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('994','DANTE LUIGI','TECHNICIAN','15',to_date('09-JUN-81','DD-MON-RR'),'712',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('995','TIBALDI ELENA','MANAGER','262',to_date('09-JUN-81','DD-MON-RR'),'713',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('996','SANTE MARIA','MANAGER','187',to_date('09-JUN-81','DD-MON-RR'),'674',null,'36');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('997','ESPOSITO PAOLO','MANAGER','247',to_date('09-JUN-81','DD-MON-RR'),'1087',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('998','TIBALDI UMBERTO','MANAGER','628',to_date('09-JUN-81','DD-MON-RR'),'1057',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('999','COZZA GIOVANNI','PHDSTUDENT','676',to_date('09-JUN-81','DD-MON-RR'),'1180',null,'170');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1000','TIBALDI GAETANO','PHDSTUDENT','387',to_date('09-JUN-81','DD-MON-RR'),'840',null,'308');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1001','GRIMALDI LUCIA','SUPERVISOR','670',to_date('09-JUN-81','DD-MON-RR'),'1838',null,'423');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1002','GRIMALDI MARIA','TECHNICIAN','178',to_date('09-JUN-81','DD-MON-RR'),'1095',null,'365');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1003','GRIMALDI ELENA','SUPERVISOR','993',to_date('09-JUN-81','DD-MON-RR'),'134',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1004','FO LUDOVICO','LAWYER','490',to_date('09-JUN-81','DD-MON-RR'),'219',null,'329');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1005','COZZA ALFONSO','PHDSTUDENT','88',to_date('09-JUN-81','DD-MON-RR'),'1298',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1006','CARBONE ROBERTA','SECRETARY','215',to_date('09-JUN-81','DD-MON-RR'),'1003',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1007','LEOPARDI GAETANO','SECRETARY','250',to_date('09-JUN-81','DD-MON-RR'),'845',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1008','SANTE IVANO','SUPERVISOR','951',to_date('09-JUN-81','DD-MON-RR'),'1272',null,'118');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1009','ESPOSITO MARIO','ENGINEER','510',to_date('09-JUN-81','DD-MON-RR'),'1259',null,'389');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1010','COZZA ELIO','TECHNICIAN','990',to_date('09-JUN-81','DD-MON-RR'),'1093',null,'344');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1011','FO ELENA','MANAGER','184',to_date('09-JUN-81','DD-MON-RR'),'931',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1012','BIANCHI UMBERTO','MANAGER','255',to_date('09-JUN-81','DD-MON-RR'),'1552',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1013','TIBALDI FRANCESCO','LAWYER','156',to_date('09-JUN-81','DD-MON-RR'),'1396',null,'486');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1014','ESPOSITO ELENA','HEADMASTER','61',to_date('09-JUN-81','DD-MON-RR'),'1284',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1015','GRIMALDI ANGELO','TECHNICIAN','892',to_date('09-JUN-81','DD-MON-RR'),'1576',null,'373');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1016','LEOPARDI LUDOVICO','TECHNICIAN','92',to_date('09-JUN-81','DD-MON-RR'),'372',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1017','COZZA MARIO','SECRETARY','388',to_date('09-JUN-81','DD-MON-RR'),'1013',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1018','PETRARCA ANTONIO','LAWYER','416',to_date('09-JUN-81','DD-MON-RR'),'1293',null,'110');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1019','ESPOSITO ROBERTA','LAWYER','503',to_date('09-JUN-81','DD-MON-RR'),'197',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1020','TIBALDI ELIO','MANAGER','447',to_date('09-JUN-81','DD-MON-RR'),'1634',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1021','MANZONI ALFONSO','ENGINEER','188',to_date('09-JUN-81','DD-MON-RR'),'955',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1022','DANTE PAOLO','SUPERVISOR','656',to_date('09-JUN-81','DD-MON-RR'),'1947',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1023','GRIMALDI LUIGI','PROFESSOR','956',to_date('09-JUN-81','DD-MON-RR'),'910',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1024','MANZONI ELENA','SUPERVISOR','526',to_date('09-JUN-81','DD-MON-RR'),'661',null,'411');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1025','CALVINO ANGELO','TECHNICIAN','328',to_date('09-JUN-81','DD-MON-RR'),'12',null,'288');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1026','BIANCHI ALFONSO','LAWYER','527',to_date('09-JUN-81','DD-MON-RR'),'753',null,'220');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1027','MANZONI UGO','SUPERVISOR','347',to_date('09-JUN-81','DD-MON-RR'),'1338',null,'3');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1028','CALVINO LUCA','SUPERVISOR','949',to_date('09-JUN-81','DD-MON-RR'),'31',null,'254');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1029','FO GAETANO','MANAGER','340',to_date('09-JUN-81','DD-MON-RR'),'1372',null,'337');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1030','FUMAROLA MARIA','SECRETARY','940',to_date('09-JUN-81','DD-MON-RR'),'1041',null,'124');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1031','MANZONI SILVIA','PHDSTUDENT','468',to_date('09-JUN-81','DD-MON-RR'),'1901',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1032','MANZONI ROBERTA','SECRETARY','959',to_date('09-JUN-81','DD-MON-RR'),'1177',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1033','CALVINO SILVIA','HEADMASTER','1022',to_date('09-JUN-81','DD-MON-RR'),'794',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1034','FUMAROLA IVANO','PHDSTUDENT','871',to_date('09-JUN-81','DD-MON-RR'),'672',null,'234');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1035','CALVINO LUIGI','PHDSTUDENT','787',to_date('09-JUN-81','DD-MON-RR'),'806',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1036','CALVINO MARIO','PROFESSOR','468',to_date('09-JUN-81','DD-MON-RR'),'697',null,'288');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1037','NERI LUIGI','SUPERVISOR','119',to_date('09-JUN-81','DD-MON-RR'),'350',null,'207');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1038','TIBALDI IVANO','PHDSTUDENT','233',to_date('09-JUN-81','DD-MON-RR'),'204',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1039','CALVINO ROBERTA','MANAGER','641',to_date('09-JUN-81','DD-MON-RR'),'887',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1040','FUMAROLA COSIMO','PHDSTUDENT','786',to_date('09-JUN-81','DD-MON-RR'),'1446',null,'260');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1041','ECO LUCIA','LAWYER','595',to_date('09-JUN-81','DD-MON-RR'),'371',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1042','CORONA SILVIA','SECRETARY','1016',to_date('09-JUN-81','DD-MON-RR'),'1143',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1043','ECO ANTONIO','TECHNICIAN','292',to_date('09-JUN-81','DD-MON-RR'),'851',null,'199');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1044','CARBONE COSIMO','PROFESSOR','896',to_date('09-JUN-81','DD-MON-RR'),'1757',null,'221');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1045','SANTE PAOLO','MANAGER','633',to_date('09-JUN-81','DD-MON-RR'),'1443',null,'64');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1046','LEOPARDI PASQUALE','HEADMASTER','566',to_date('09-JUN-81','DD-MON-RR'),'479',null,'24');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1047','SANTE IVANO','ENGINEER','329',to_date('09-JUN-81','DD-MON-RR'),'726',null,'38');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1048','COZZA PASQUALE','MANAGER','833',to_date('09-JUN-81','DD-MON-RR'),'68',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1049','DANTE ANDREA','TECHNICIAN','202',to_date('09-JUN-81','DD-MON-RR'),'921',null,'421');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1050','BIANCHI ANDREA','ENGINEER','44',to_date('09-JUN-81','DD-MON-RR'),'1107',null,'265');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1051','ESPOSITO MASSIMO','HEADMASTER','35',to_date('09-JUN-81','DD-MON-RR'),'445',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1052','PETRARCA IVANO','ENGINEER','617',to_date('09-JUN-81','DD-MON-RR'),'1685',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1053','GRIMALDI UMBERTO','SECRETARY','991',to_date('09-JUN-81','DD-MON-RR'),'272',null,'488');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1054','CALVINO ELIO','PHDSTUDENT','642',to_date('09-JUN-81','DD-MON-RR'),'1046',null,'19');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1055','PETRARCA UMBERTO','TECHNICIAN','275',to_date('09-JUN-81','DD-MON-RR'),'404',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1056','BIANCHI MASSIMO','MANAGER','1044',to_date('09-JUN-81','DD-MON-RR'),'813',null,'222');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1057','CARBONE ELENA','MANAGER','266',to_date('09-JUN-81','DD-MON-RR'),'152',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1058','PETRARCA GAETANO','MANAGER','405',to_date('09-JUN-81','DD-MON-RR'),'1363',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1059','NERI LUDOVICO','PROFESSOR','995',to_date('09-JUN-81','DD-MON-RR'),'1872',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1060','LEVI LUCIA','PROFESSOR','1024',to_date('09-JUN-81','DD-MON-RR'),'1299',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1061','LEVI MASSIMO','ENGINEER','774',to_date('09-JUN-81','DD-MON-RR'),'859',null,'145');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1062','LEVI MARIA','HEADMASTER','158',to_date('09-JUN-81','DD-MON-RR'),'216',null,'428');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1063','PETRARCA COSIMO','PHDSTUDENT','131',to_date('09-JUN-81','DD-MON-RR'),'1864',null,'139');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1064','GRIMALDI DONATO','PROFESSOR','44',to_date('09-JUN-81','DD-MON-RR'),'466',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1065','LEOPARDI GIOVANNI','SUPERVISOR','530',to_date('09-JUN-81','DD-MON-RR'),'357',null,'289');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1066','PETRARCA LUDOVICO','PHDSTUDENT','950',to_date('09-JUN-81','DD-MON-RR'),'834',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1067','TIBALDI MASSIMO','TECHNICIAN','1026',to_date('09-JUN-81','DD-MON-RR'),'1484',null,'207');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1068','GRIMALDI PASQUALE','SUPERVISOR','442',to_date('09-JUN-81','DD-MON-RR'),'1663',null,'447');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1069','CORONA ANDREA','SUPERVISOR','318',to_date('09-JUN-81','DD-MON-RR'),'583',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1070','ESPOSITO IVANO','TECHNICIAN','823',to_date('09-JUN-81','DD-MON-RR'),'1959',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1071','GRIMALDI ROBERTA','MANAGER','395',to_date('09-JUN-81','DD-MON-RR'),'1759',null,'458');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1072','ECO LUIGI','HEADMASTER','135',to_date('09-JUN-81','DD-MON-RR'),'48',null,'126');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1073','CORONA FEDERICO','LAWYER','540',to_date('09-JUN-81','DD-MON-RR'),'513',null,'396');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2071','CALVINO UGO','PROFESSOR','1086',to_date('09-JUN-81','DD-MON-RR'),'1271',null,'108');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2072','COZZA MARIO','SUPERVISOR','455',to_date('09-JUN-81','DD-MON-RR'),'633',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2073','LEOPARDI ANTONIO','SECRETARY','312',to_date('09-JUN-81','DD-MON-RR'),'70',null,'168');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2074','LEOPARDI IVANO','MANAGER','43',to_date('09-JUN-81','DD-MON-RR'),'1046',null,'302');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2075','ESPOSITO LUIGI','SUPERVISOR','1991',to_date('09-JUN-81','DD-MON-RR'),'279',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2076','LEOPARDI PASQUALE','HEADMASTER','1694',to_date('09-JUN-81','DD-MON-RR'),'1432',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2077','MANZONI LUDOVICO','PHDSTUDENT','21',to_date('09-JUN-81','DD-MON-RR'),'587',null,'312');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2078','FUMAROLA MARIO','TECHNICIAN','1810',to_date('09-JUN-81','DD-MON-RR'),'1466',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2079','CARBONE DONATO','SECRETARY','836',to_date('09-JUN-81','DD-MON-RR'),'1290',null,'127');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2080','COZZA PASQUALE','MANAGER','369',to_date('09-JUN-81','DD-MON-RR'),'1195',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2081','LEOPARDI PAOLO','SUPERVISOR','982',to_date('09-JUN-81','DD-MON-RR'),'1365',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2082','SANTE DONATO','SUPERVISOR','369',to_date('09-JUN-81','DD-MON-RR'),'1451',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2083','LEOPARDI LUCA','HEADMASTER','828',to_date('09-JUN-81','DD-MON-RR'),'679',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2084','PETRARCA PAOLO','LAWYER','1583',to_date('09-JUN-81','DD-MON-RR'),'1901',null,'283');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2085','COZZA MARIA','MANAGER','1210',to_date('09-JUN-81','DD-MON-RR'),'272',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2086','LEOPARDI SILVIA','MANAGER','384',to_date('09-JUN-81','DD-MON-RR'),'636',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2087','COZZA LUIGI','PHDSTUDENT','1014',to_date('09-JUN-81','DD-MON-RR'),'731',null,'396');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2088','CORONA MARIO','PROFESSOR','64',to_date('09-JUN-81','DD-MON-RR'),'1130',null,'300');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2089','FO GAETANO','SUPERVISOR','520',to_date('09-JUN-81','DD-MON-RR'),'707',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2090','PETRARCA DONATO','PHDSTUDENT','42',to_date('09-JUN-81','DD-MON-RR'),'1897',null,'97');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2091','FO LUIGI','SECRETARY','1027',to_date('09-JUN-81','DD-MON-RR'),'840',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2092','MANZONI CLARA','HEADMASTER','1905',to_date('09-JUN-81','DD-MON-RR'),'1409',null,'457');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2093','FUMAROLA COSIMO','LAWYER','2022',to_date('09-JUN-81','DD-MON-RR'),'405',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2094','LEVI IVANO','MANAGER','1504',to_date('09-JUN-81','DD-MON-RR'),'1559',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2095','FUMAROLA ELIO','SUPERVISOR','1842',to_date('09-JUN-81','DD-MON-RR'),'1231',null,'455');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2096','DANTE FEDERICO','MANAGER','245',to_date('09-JUN-81','DD-MON-RR'),'1859',null,'283');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2097','MANZONI ELENA','ENGINEER','54',to_date('09-JUN-81','DD-MON-RR'),'1367',null,'245');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2098','GRIMALDI MARIO','ENGINEER','46',to_date('09-JUN-81','DD-MON-RR'),'709',null,'432');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2099','GRIMALDI UGO','ENGINEER','1908',to_date('09-JUN-81','DD-MON-RR'),'1283',null,'87');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2100','MANZONI ANGELO','PROFESSOR','978',to_date('09-JUN-81','DD-MON-RR'),'680',null,'193');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2101','CALVINO LUDOVICO','PROFESSOR','1100',to_date('09-JUN-81','DD-MON-RR'),'1065',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2102','LEVI FEDERICO','MANAGER','1842',to_date('09-JUN-81','DD-MON-RR'),'72',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2103','CORONA PAOLO','SECRETARY','59',to_date('09-JUN-81','DD-MON-RR'),'1997',null,'477');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2104','ESPOSITO ALFONSO','ENGINEER','607',to_date('09-JUN-81','DD-MON-RR'),'1154',null,'259');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3391','SANTE ANDREA','TECHNICIAN','2440',to_date('09-JUN-81','DD-MON-RR'),'226',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3392','COZZA ANDREA','SECRETARY','1755',to_date('09-JUN-81','DD-MON-RR'),'1017',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3393','SANTE LUCA','PROFESSOR','859',to_date('09-JUN-81','DD-MON-RR'),'1801',null,'140');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3394','CALVINO ROBERTA','LAWYER','469',to_date('09-JUN-81','DD-MON-RR'),'148',null,'53');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3002','COZZA ELENA','SUPERVISOR','2860',to_date('09-JUN-81','DD-MON-RR'),'1356',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3003','MANZONI ALFONSO','TECHNICIAN','1142',to_date('09-JUN-81','DD-MON-RR'),'1495',null,'52');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3004','MANZONI ANGELO','LAWYER','1967',to_date('09-JUN-81','DD-MON-RR'),'288',null,'260');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3005','DANTE ELIO','LAWYER','2673',to_date('09-JUN-81','DD-MON-RR'),'390',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3006','PETRARCA UGO','PROFESSOR','510',to_date('09-JUN-81','DD-MON-RR'),'1199',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3007','NERI MARIA','ENGINEER','2054',to_date('09-JUN-81','DD-MON-RR'),'1137',null,'36');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3008','PETRARCA MASSIMO','ENGINEER','2467',to_date('09-JUN-81','DD-MON-RR'),'179',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3009','COZZA ANGELO','MANAGER','1077',to_date('09-JUN-81','DD-MON-RR'),'1388',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3010','FUMAROLA UGO','HEADMASTER','421',to_date('09-JUN-81','DD-MON-RR'),'1502',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3011','COZZA GAETANO','PROFESSOR','1847',to_date('09-JUN-81','DD-MON-RR'),'50',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3012','SANTE PAOLO','PHDSTUDENT','2725',to_date('09-JUN-81','DD-MON-RR'),'1152',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3013','CALVINO PASQUALE','HEADMASTER','2036',to_date('09-JUN-81','DD-MON-RR'),'1919',null,'42');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3014','FO ANTONIO','SECRETARY','1905',to_date('09-JUN-81','DD-MON-RR'),'486',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3015','CORONA UGO','MANAGER','1412',to_date('09-JUN-81','DD-MON-RR'),'525',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3016','PETRARCA LUIGI','SECRETARY','1049',to_date('09-JUN-81','DD-MON-RR'),'688',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3017','LEVI DAMIANO','LAWYER','503',to_date('09-JUN-81','DD-MON-RR'),'1519',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3018','PETRARCA CLARA','MANAGER','1353',to_date('09-JUN-81','DD-MON-RR'),'825',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3019','SANTE LUDOVICO','LAWYER','1985',to_date('09-JUN-81','DD-MON-RR'),'333',null,'4');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3020','ESPOSITO PASQUALE','ENGINEER','471',to_date('09-JUN-81','DD-MON-RR'),'1843',null,'197');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3021','CALVINO ELENA','SUPERVISOR','2642',to_date('09-JUN-81','DD-MON-RR'),'231',null,'234');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3022','FO COSIMO','MANAGER','1186',to_date('09-JUN-81','DD-MON-RR'),'1463',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3023','DANTE IVANO','TECHNICIAN','287',to_date('09-JUN-81','DD-MON-RR'),'1267',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3024','PETRARCA UMBERTO','HEADMASTER','2240',to_date('09-JUN-81','DD-MON-RR'),'1649',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3025','ECO CLARA','MANAGER','2664',to_date('09-JUN-81','DD-MON-RR'),'914',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3026','MANZONI COSIMO','SUPERVISOR','1210',to_date('09-JUN-81','DD-MON-RR'),'1839',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3027','GRIMALDI LUCA','SECRETARY','586',to_date('09-JUN-81','DD-MON-RR'),'998',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3028','GRIMALDI ELENA','LAWYER','297',to_date('09-JUN-81','DD-MON-RR'),'1537',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3029','DANTE GAETANO','SECRETARY','302',to_date('09-JUN-81','DD-MON-RR'),'969',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3030','CALVINO COSIMO','SUPERVISOR','1282',to_date('09-JUN-81','DD-MON-RR'),'230',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3031','ECO LUCIA','PROFESSOR','2457',to_date('09-JUN-81','DD-MON-RR'),'1580',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3032','CALVINO LUCA','HEADMASTER','2311',to_date('09-JUN-81','DD-MON-RR'),'1706',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3033','FUMAROLA ANDREA','PHDSTUDENT','2812',to_date('09-JUN-81','DD-MON-RR'),'457',null,'35');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3034','BIANCHI ANGELO','SUPERVISOR','2157',to_date('09-JUN-81','DD-MON-RR'),'1320',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3035','CARBONE ELENA','PHDSTUDENT','1861',to_date('09-JUN-81','DD-MON-RR'),'236',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3036','ESPOSITO ROBERTA','TECHNICIAN','2356',to_date('09-JUN-81','DD-MON-RR'),'1324',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3037','FO DAMIANO','ENGINEER','2822',to_date('09-JUN-81','DD-MON-RR'),'857',null,'171');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3038','DANTE ANDREA','SUPERVISOR','2616',to_date('09-JUN-81','DD-MON-RR'),'1216',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3039','LEVI GAETANO','ENGINEER','2273',to_date('09-JUN-81','DD-MON-RR'),'1110',null,'461');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3040','SANTE UMBERTO','SUPERVISOR','1771',to_date('09-JUN-81','DD-MON-RR'),'361',null,'367');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3041','CORONA MARIA','MANAGER','826',to_date('09-JUN-81','DD-MON-RR'),'1257',null,'124');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3042','TIBALDI LUCA','SUPERVISOR','1798',to_date('09-JUN-81','DD-MON-RR'),'715',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3043','MANZONI GIOVANNI','LAWYER','1240',to_date('09-JUN-81','DD-MON-RR'),'1555',null,'317');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3044','ESPOSITO MASSIMO','PROFESSOR','1133',to_date('09-JUN-81','DD-MON-RR'),'916',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3045','LEOPARDI ANGELO','ENGINEER','2778',to_date('09-JUN-81','DD-MON-RR'),'178',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3046','DANTE GAETANO','SUPERVISOR','717',to_date('09-JUN-81','DD-MON-RR'),'1187',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3047','CORONA IVANO','ENGINEER','1223',to_date('09-JUN-81','DD-MON-RR'),'573',null,'24');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3048','LEVI ELENA','HEADMASTER','2355',to_date('09-JUN-81','DD-MON-RR'),'1256',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3049','FUMAROLA ALFONSO','MANAGER','2702',to_date('09-JUN-81','DD-MON-RR'),'220',null,'456');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3050','CARBONE GAETANO','SUPERVISOR','1590',to_date('09-JUN-81','DD-MON-RR'),'635',null,'254');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3051','GRIMALDI ANTONIO','HEADMASTER','2861',to_date('09-JUN-81','DD-MON-RR'),'402',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3052','GRIMALDI COSIMO','ENGINEER','2726',to_date('09-JUN-81','DD-MON-RR'),'176',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3053','ECO PAOLO','PROFESSOR','2772',to_date('09-JUN-81','DD-MON-RR'),'1215',null,'126');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3054','ESPOSITO ANDREA','SECRETARY','320',to_date('09-JUN-81','DD-MON-RR'),'1803',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3055','PETRARCA ANDREA','HEADMASTER','1330',to_date('09-JUN-81','DD-MON-RR'),'686',null,'412');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3056','ECO PAOLO','PHDSTUDENT','2364',to_date('09-JUN-81','DD-MON-RR'),'1169',null,'496');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3057','LEVI LUDOVICO','HEADMASTER','964',to_date('09-JUN-81','DD-MON-RR'),'1358',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3058','CORONA MARIA','TECHNICIAN','1059',to_date('09-JUN-81','DD-MON-RR'),'1060',null,'104');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3059','MANZONI PAOLO','TECHNICIAN','1811',to_date('09-JUN-81','DD-MON-RR'),'573',null,'63');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3060','MANZONI UMBERTO','TECHNICIAN','615',to_date('09-JUN-81','DD-MON-RR'),'1478',null,'145');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3061','FO UGO','SECRETARY','2498',to_date('09-JUN-81','DD-MON-RR'),'913',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3062','LEOPARDI ALFONSO','LAWYER','1491',to_date('09-JUN-81','DD-MON-RR'),'1938',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3063','TIBALDI ROBERTA','PHDSTUDENT','2621',to_date('09-JUN-81','DD-MON-RR'),'72',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4062','ECO MARIO','PHDSTUDENT','503',to_date('09-JUN-81','DD-MON-RR'),'559',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4063','MANZONI ALFONSO','HEADMASTER','2925',to_date('09-JUN-81','DD-MON-RR'),'1950',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4064','FO IVANO','PROFESSOR','2880',to_date('09-JUN-81','DD-MON-RR'),'933',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4065','BIANCHI UGO','TECHNICIAN','614',to_date('09-JUN-81','DD-MON-RR'),'1846',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4066','ECO MARIO','ENGINEER','275',to_date('09-JUN-81','DD-MON-RR'),'914',null,'179');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4067','SANTE LUDOVICO','SECRETARY','1457',to_date('09-JUN-81','DD-MON-RR'),'1990',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4068','FUMAROLA UMBERTO','HEADMASTER','33',to_date('09-JUN-81','DD-MON-RR'),'1961',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4069','ECO COSIMO','PHDSTUDENT','1233',to_date('09-JUN-81','DD-MON-RR'),'1335',null,'407');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4070','PETRARCA ANDREA','PROFESSOR','3928',to_date('09-JUN-81','DD-MON-RR'),'174',null,'87');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4071','NERI MASSIMO','MANAGER','3481',to_date('09-JUN-81','DD-MON-RR'),'465',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4072','SANTE GAETANO','ENGINEER','3368',to_date('09-JUN-81','DD-MON-RR'),'256',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4073','PETRARCA MASSIMO','SUPERVISOR','2795',to_date('09-JUN-81','DD-MON-RR'),'784',null,'56');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4074','ESPOSITO ANGELO','PHDSTUDENT','3980',to_date('09-JUN-81','DD-MON-RR'),'815',null,'369');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4075','FO MASSIMO','TECHNICIAN','176',to_date('09-JUN-81','DD-MON-RR'),'10',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4076','PETRARCA MARIA','MANAGER','3119',to_date('09-JUN-81','DD-MON-RR'),'746',null,'80');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4077','LEVI LUCIA','HEADMASTER','2635',to_date('09-JUN-81','DD-MON-RR'),'828',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4078','CORONA SILVIA','PROFESSOR','2653',to_date('09-JUN-81','DD-MON-RR'),'1641',null,'417');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4079','GRIMALDI ANGELO','PHDSTUDENT','3409',to_date('09-JUN-81','DD-MON-RR'),'851',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4080','SANTE ANGELO','HEADMASTER','1022',to_date('09-JUN-81','DD-MON-RR'),'523',null,'195');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4081','LEOPARDI LUDOVICO','TECHNICIAN','3837',to_date('09-JUN-81','DD-MON-RR'),'489',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4082','ESPOSITO GAETANO','SECRETARY','126',to_date('09-JUN-81','DD-MON-RR'),'1322',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4083','COZZA LUCIA','PROFESSOR','2169',to_date('09-JUN-81','DD-MON-RR'),'1660',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4084','LEVI ANTONIO','MANAGER','1242',to_date('09-JUN-81','DD-MON-RR'),'860',null,'56');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4085','DANTE LUCA','MANAGER','150',to_date('09-JUN-81','DD-MON-RR'),'512',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4086','NERI MARIA','SUPERVISOR','1378',to_date('09-JUN-81','DD-MON-RR'),'418',null,'158');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4087','NERI PASQUALE','PHDSTUDENT','1998',to_date('09-JUN-81','DD-MON-RR'),'682',null,'496');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4088','GRIMALDI FRANCESCO','MANAGER','780',to_date('09-JUN-81','DD-MON-RR'),'1923',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4089','GRIMALDI CLARA','MANAGER','479',to_date('09-JUN-81','DD-MON-RR'),'1263',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4090','LEOPARDI LUCIA','TECHNICIAN','2298',to_date('09-JUN-81','DD-MON-RR'),'637',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4091','CARBONE SILVIA','PHDSTUDENT','933',to_date('09-JUN-81','DD-MON-RR'),'168',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4092','NERI PAOLO','MANAGER','3591',to_date('09-JUN-81','DD-MON-RR'),'385',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4093','NERI DAMIANO','PROFESSOR','180',to_date('09-JUN-81','DD-MON-RR'),'313',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4094','LEVI MARIA','PHDSTUDENT','2641',to_date('09-JUN-81','DD-MON-RR'),'1407',null,'385');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4095','TIBALDI GIOVANNI','MANAGER','2893',to_date('09-JUN-81','DD-MON-RR'),'993',null,'186');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4096','LEOPARDI ANDREA','PHDSTUDENT','2273',to_date('09-JUN-81','DD-MON-RR'),'1760',null,'102');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4097','ESPOSITO ROBERTA','PHDSTUDENT','1647',to_date('09-JUN-81','DD-MON-RR'),'607',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4098','LEVI ROBERTA','SECRETARY','2757',to_date('09-JUN-81','DD-MON-RR'),'438',null,'111');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4099','FUMAROLA LUCIA','SUPERVISOR','2564',to_date('09-JUN-81','DD-MON-RR'),'1823',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4100','LEOPARDI ELIO','PHDSTUDENT','1851',to_date('09-JUN-81','DD-MON-RR'),'582',null,'472');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4101','LEVI ANGELO','SECRETARY','3873',to_date('09-JUN-81','DD-MON-RR'),'1685',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4102','DANTE ALFONSO','TECHNICIAN','235',to_date('09-JUN-81','DD-MON-RR'),'1136',null,'103');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4103','GRIMALDI PAOLO','HEADMASTER','924',to_date('09-JUN-81','DD-MON-RR'),'126',null,'300');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4104','FUMAROLA LUCIA','PROFESSOR','1064',to_date('09-JUN-81','DD-MON-RR'),'348',null,'389');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4105','CALVINO UGO','SECRETARY','912',to_date('09-JUN-81','DD-MON-RR'),'46',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4106','LEVI ANGELO','HEADMASTER','3140',to_date('09-JUN-81','DD-MON-RR'),'1585',null,'393');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4107','CARBONE ANTONIO','PHDSTUDENT','600',to_date('09-JUN-81','DD-MON-RR'),'1997',null,'260');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4108','FUMAROLA FRANCESCO','MANAGER','3023',to_date('09-JUN-81','DD-MON-RR'),'765',null,'486');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4109','CALVINO ANGELO','SECRETARY','843',to_date('09-JUN-81','DD-MON-RR'),'182',null,'348');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4110','PETRARCA MASSIMO','HEADMASTER','1435',to_date('09-JUN-81','DD-MON-RR'),'173',null,'146');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4111','MANZONI UGO','SECRETARY','3898',to_date('09-JUN-81','DD-MON-RR'),'38',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4112','NERI FEDERICO','ENGINEER','2824',to_date('09-JUN-81','DD-MON-RR'),'816',null,'436');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4113','CALVINO CLARA','MANAGER','486',to_date('09-JUN-81','DD-MON-RR'),'996',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4114','TIBALDI ANDREA','SUPERVISOR','2528',to_date('09-JUN-81','DD-MON-RR'),'82',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4115','CARBONE DAMIANO','MANAGER','2386',to_date('09-JUN-81','DD-MON-RR'),'750',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4116','SANTE ELIO','TECHNICIAN','50',to_date('09-JUN-81','DD-MON-RR'),'656',null,'280');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4117','LEVI ALFONSO','SECRETARY','3371',to_date('09-JUN-81','DD-MON-RR'),'1499',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4118','TIBALDI MARIA','MANAGER','2972',to_date('09-JUN-81','DD-MON-RR'),'150',null,'245');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4119','LEVI FEDERICO','PROFESSOR','1561',to_date('09-JUN-81','DD-MON-RR'),'1563',null,'184');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4120','CALVINO ELIO','ENGINEER','3770',to_date('09-JUN-81','DD-MON-RR'),'1346',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4121','FO FRANCESCO','HEADMASTER','3066',to_date('09-JUN-81','DD-MON-RR'),'1115',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4122','ECO CLARA','TECHNICIAN','527',to_date('09-JUN-81','DD-MON-RR'),'642',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4123','SANTE ANDREA','HEADMASTER','1454',to_date('09-JUN-81','DD-MON-RR'),'1469',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4124','GRIMALDI FRANCESCO','PHDSTUDENT','707',to_date('09-JUN-81','DD-MON-RR'),'497',null,'135');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4125','CARBONE FEDERICO','SECRETARY','3852',to_date('09-JUN-81','DD-MON-RR'),'1757',null,'18');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4126','GRIMALDI SILVIA','SECRETARY','3517',to_date('09-JUN-81','DD-MON-RR'),'1650',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4127','SANTE LUCIA','SUPERVISOR','3591',to_date('09-JUN-81','DD-MON-RR'),'516',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4128','FO UMBERTO','HEADMASTER','1679',to_date('09-JUN-81','DD-MON-RR'),'1940',null,'356');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4129','SANTE LUIGI','LAWYER','902',to_date('09-JUN-81','DD-MON-RR'),'1972',null,'415');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4130','FO PAOLO','SUPERVISOR','3529',to_date('09-JUN-81','DD-MON-RR'),'920',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4131','SANTE ALFONSO','MANAGER','1966',to_date('09-JUN-81','DD-MON-RR'),'32',null,'289');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4132','LEOPARDI LUIGI','SUPERVISOR','1077',to_date('09-JUN-81','DD-MON-RR'),'433',null,'483');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4133','CALVINO UMBERTO','MANAGER','841',to_date('09-JUN-81','DD-MON-RR'),'1567',null,'277');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4134','GRIMALDI LUCA','PROFESSOR','2060',to_date('09-JUN-81','DD-MON-RR'),'1462',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6164','DANTE UGO','HEADMASTER','107',to_date('09-JUN-81','DD-MON-RR'),'564',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6165','PETRARCA COSIMO','PROFESSOR','395',to_date('09-JUN-81','DD-MON-RR'),'1250',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6166','CALVINO LUCIA','PROFESSOR','3854',to_date('09-JUN-81','DD-MON-RR'),'616',null,'455');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6167','DANTE DONATO','LAWYER','5814',to_date('09-JUN-81','DD-MON-RR'),'557',null,'304');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6168','LEVI MARIA','ENGINEER','5749',to_date('09-JUN-81','DD-MON-RR'),'22',null,'192');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6169','CARBONE IVANO','ENGINEER','250',to_date('09-JUN-81','DD-MON-RR'),'1996',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6170','CORONA SILVIA','SECRETARY','4493',to_date('09-JUN-81','DD-MON-RR'),'1929',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6171','COZZA PAOLO','SECRETARY','3769',to_date('09-JUN-81','DD-MON-RR'),'1880',null,'263');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6172','GRIMALDI MARIA','ENGINEER','811',to_date('09-JUN-81','DD-MON-RR'),'632',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6173','SANTE UMBERTO','SECRETARY','5011',to_date('09-JUN-81','DD-MON-RR'),'1589',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6174','CARBONE PASQUALE','SUPERVISOR','4128',to_date('09-JUN-81','DD-MON-RR'),'1769',null,'57');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6175','DANTE ALFONSO','PHDSTUDENT','5943',to_date('09-JUN-81','DD-MON-RR'),'1338',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6176','CALVINO MARIO','PROFESSOR','2128',to_date('09-JUN-81','DD-MON-RR'),'1833',null,'118');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6177','TIBALDI MARIO','MANAGER','648',to_date('09-JUN-81','DD-MON-RR'),'1139',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6178','DANTE GIOVANNI','MANAGER','4589',to_date('09-JUN-81','DD-MON-RR'),'246',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6179','DANTE GIOVANNI','SUPERVISOR','6156',to_date('09-JUN-81','DD-MON-RR'),'1976',null,'155');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6180','SANTE ELIO','PHDSTUDENT','787',to_date('09-JUN-81','DD-MON-RR'),'748',null,'461');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6181','FUMAROLA PASQUALE','TECHNICIAN','2498',to_date('09-JUN-81','DD-MON-RR'),'1691',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6182','FO MASSIMO','MANAGER','1549',to_date('09-JUN-81','DD-MON-RR'),'1643',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6183','NERI PASQUALE','PROFESSOR','5966',to_date('09-JUN-81','DD-MON-RR'),'364',null,'294');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6184','LEVI CLARA','LAWYER','6030',to_date('09-JUN-81','DD-MON-RR'),'115',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6185','LEOPARDI UGO','MANAGER','3339',to_date('09-JUN-81','DD-MON-RR'),'593',null,'340');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6186','DANTE MARIO','SECRETARY','4272',to_date('09-JUN-81','DD-MON-RR'),'1618',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6187','CORONA LUCA','ENGINEER','2598',to_date('09-JUN-81','DD-MON-RR'),'1401',null,'283');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6188','SANTE UMBERTO','HEADMASTER','240',to_date('09-JUN-81','DD-MON-RR'),'1684',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6189','NERI CLARA','SECRETARY','3309',to_date('09-JUN-81','DD-MON-RR'),'731',null,'153');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6190','BIANCHI MASSIMO','TECHNICIAN','4570',to_date('09-JUN-81','DD-MON-RR'),'384',null,'387');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6191','ESPOSITO ELIO','SECRETARY','3732',to_date('09-JUN-81','DD-MON-RR'),'690',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6192','ESPOSITO ROBERTA','MANAGER','2335',to_date('09-JUN-81','DD-MON-RR'),'1203',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6193','LEVI LUDOVICO','MANAGER','5886',to_date('09-JUN-81','DD-MON-RR'),'428',null,'429');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6194','SANTE GIOVANNI','MANAGER','2409',to_date('09-JUN-81','DD-MON-RR'),'751',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6195','FUMAROLA ELENA','MANAGER','1080',to_date('09-JUN-81','DD-MON-RR'),'1089',null,'229');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6196','BIANCHI GAETANO','HEADMASTER','794',to_date('09-JUN-81','DD-MON-RR'),'1135',null,'229');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6197','LEVI MASSIMO','HEADMASTER','3444',to_date('09-JUN-81','DD-MON-RR'),'1153',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6198','CARBONE DAMIANO','ENGINEER','4414',to_date('09-JUN-81','DD-MON-RR'),'942',null,'316');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6199','SANTE UGO','MANAGER','5088',to_date('09-JUN-81','DD-MON-RR'),'1999',null,'424');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6200','FO PAOLO','MANAGER','4361',to_date('09-JUN-81','DD-MON-RR'),'1741',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6201','TIBALDI DONATO','MANAGER','1724',to_date('09-JUN-81','DD-MON-RR'),'1895',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6202','NERI DONATO','LAWYER','2353',to_date('09-JUN-81','DD-MON-RR'),'1241',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6203','DANTE LUCA','MANAGER','252',to_date('09-JUN-81','DD-MON-RR'),'56',null,'251');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6204','NERI CLARA','PHDSTUDENT','910',to_date('09-JUN-81','DD-MON-RR'),'841',null,'56');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6205','DANTE FEDERICO','MANAGER','4046',to_date('09-JUN-81','DD-MON-RR'),'1119',null,'340');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6206','FUMAROLA DAMIANO','TECHNICIAN','117',to_date('09-JUN-81','DD-MON-RR'),'2',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6207','GRIMALDI ELENA','TECHNICIAN','4258',to_date('09-JUN-81','DD-MON-RR'),'237',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6208','FUMAROLA ANGELO','LAWYER','1412',to_date('09-JUN-81','DD-MON-RR'),'1563',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6209','GRIMALDI GIOVANNI','MANAGER','5236',to_date('09-JUN-81','DD-MON-RR'),'1203',null,'248');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6210','FUMAROLA LUCIA','MANAGER','4751',to_date('09-JUN-81','DD-MON-RR'),'500',null,'456');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6211','TIBALDI UMBERTO','LAWYER','5869',to_date('09-JUN-81','DD-MON-RR'),'244',null,'319');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6212','BIANCHI DAMIANO','PHDSTUDENT','5620',to_date('09-JUN-81','DD-MON-RR'),'1122',null,'248');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6213','BIANCHI MASSIMO','SECRETARY','3023',to_date('09-JUN-81','DD-MON-RR'),'1969',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6214','CORONA GAETANO','ENGINEER','254',to_date('09-JUN-81','DD-MON-RR'),'1116',null,'38');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6215','DANTE MARIA','HEADMASTER','5545',to_date('09-JUN-81','DD-MON-RR'),'559',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6216','ECO LUCIA','MANAGER','2755',to_date('09-JUN-81','DD-MON-RR'),'1339',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6217','ESPOSITO IVANO','HEADMASTER','2856',to_date('09-JUN-81','DD-MON-RR'),'1933',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6218','CALVINO ELENA','SUPERVISOR','1203',to_date('09-JUN-81','DD-MON-RR'),'982',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6219','LEVI ELENA','PHDSTUDENT','4278',to_date('09-JUN-81','DD-MON-RR'),'992',null,'301');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6220','MANZONI UGO','MANAGER','2733',to_date('09-JUN-81','DD-MON-RR'),'1854',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6221','COZZA DONATO','MANAGER','2446',to_date('09-JUN-81','DD-MON-RR'),'352',null,'395');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6222','NERI ELIO','HEADMASTER','3548',to_date('09-JUN-81','DD-MON-RR'),'1435',null,'410');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6223','TIBALDI MARIA','MANAGER','3123',to_date('09-JUN-81','DD-MON-RR'),'1734',null,'158');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6224','GRIMALDI ANGELO','HEADMASTER','5450',to_date('09-JUN-81','DD-MON-RR'),'1536',null,'134');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6225','NERI ROBERTA','TECHNICIAN','3706',to_date('09-JUN-81','DD-MON-RR'),'1944',null,'114');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6226','LEVI MARIA','ENGINEER','705',to_date('09-JUN-81','DD-MON-RR'),'1460',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6227','MANZONI GAETANO','SUPERVISOR','4716',to_date('09-JUN-81','DD-MON-RR'),'1690',null,'57');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6228','DANTE MASSIMO','TECHNICIAN','2506',to_date('09-JUN-81','DD-MON-RR'),'1008',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6229','BIANCHI UMBERTO','SUPERVISOR','3054',to_date('09-JUN-81','DD-MON-RR'),'423',null,'251');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6230','ESPOSITO MASSIMO','SUPERVISOR','380',to_date('09-JUN-81','DD-MON-RR'),'571',null,'4');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6231','GRIMALDI COSIMO','PHDSTUDENT','1580',to_date('09-JUN-81','DD-MON-RR'),'781',null,'38');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6232','SANTE ELENA','SECRETARY','4925',to_date('09-JUN-81','DD-MON-RR'),'105',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6233','CARBONE UGO','PROFESSOR','4324',to_date('09-JUN-81','DD-MON-RR'),'65',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6234','TIBALDI ANTONIO','MANAGER','528',to_date('09-JUN-81','DD-MON-RR'),'483',null,'125');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6235','PETRARCA ELIO','LAWYER','3899',to_date('09-JUN-81','DD-MON-RR'),'122',null,'113');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6236','NERI MASSIMO','SUPERVISOR','6118',to_date('09-JUN-81','DD-MON-RR'),'1211',null,'447');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6237','LEVI ANGELO','SUPERVISOR','2553',to_date('09-JUN-81','DD-MON-RR'),'1578',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6238','ECO MARIA','HEADMASTER','5020',to_date('09-JUN-81','DD-MON-RR'),'776',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6239','SANTE MARIO','SECRETARY','3416',to_date('09-JUN-81','DD-MON-RR'),'1644',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6240','GRIMALDI LUCA','MANAGER','4613',to_date('09-JUN-81','DD-MON-RR'),'73',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6241','ECO ROBERTA','LAWYER','2932',to_date('09-JUN-81','DD-MON-RR'),'1304',null,'458');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6242','CALVINO PAOLO','TECHNICIAN','3464',to_date('09-JUN-81','DD-MON-RR'),'239',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6243','DANTE LUCA','SECRETARY','4187',to_date('09-JUN-81','DD-MON-RR'),'1060',null,'393');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6244','ESPOSITO PAOLO','MANAGER','1455',to_date('09-JUN-81','DD-MON-RR'),'1171',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6245','MANZONI ELIO','SECRETARY','187',to_date('09-JUN-81','DD-MON-RR'),'247',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6246','NERI COSIMO','HEADMASTER','1882',to_date('09-JUN-81','DD-MON-RR'),'1119',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6247','LEOPARDI ROBERTA','TECHNICIAN','841',to_date('09-JUN-81','DD-MON-RR'),'958',null,'474');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6248','PETRARCA UGO','MANAGER','1494',to_date('09-JUN-81','DD-MON-RR'),'1896',null,'101');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6249','CORONA UGO','LAWYER','3450',to_date('09-JUN-81','DD-MON-RR'),'1514',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6250','FUMAROLA LUCIA','LAWYER','4113',to_date('09-JUN-81','DD-MON-RR'),'1838',null,'168');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6251','SANTE ELIO','PROFESSOR','5747',to_date('09-JUN-81','DD-MON-RR'),'420',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6252','GRIMALDI COSIMO','ENGINEER','5418',to_date('09-JUN-81','DD-MON-RR'),'1127',null,'194');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6253','COZZA ELENA','ENGINEER','3055',to_date('09-JUN-81','DD-MON-RR'),'1285',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6254','NERI LUDOVICO','MANAGER','5844',to_date('09-JUN-81','DD-MON-RR'),'443',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6255','LEVI CLARA','TECHNICIAN','6099',to_date('09-JUN-81','DD-MON-RR'),'1559',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6256','LEOPARDI CLARA','HEADMASTER','4611',to_date('09-JUN-81','DD-MON-RR'),'304',null,'411');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6257','NERI LUIGI','PROFESSOR','3956',to_date('09-JUN-81','DD-MON-RR'),'113',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6258','GRIMALDI ANDREA','TECHNICIAN','4304',to_date('09-JUN-81','DD-MON-RR'),'720',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6259','LEOPARDI MARIA','SUPERVISOR','2760',to_date('09-JUN-81','DD-MON-RR'),'1974',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6260','COZZA UMBERTO','SUPERVISOR','768',to_date('09-JUN-81','DD-MON-RR'),'1449',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6261','ESPOSITO PAOLO','TECHNICIAN','2758',to_date('09-JUN-81','DD-MON-RR'),'1546',null,'20');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6262','ESPOSITO LUDOVICO','ENGINEER','3238',to_date('09-JUN-81','DD-MON-RR'),'256',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6263','PETRARCA LUDOVICO','SECRETARY','3469',to_date('09-JUN-81','DD-MON-RR'),'1675',null,'260');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6264','SANTE PASQUALE','LAWYER','5946',to_date('09-JUN-81','DD-MON-RR'),'1162',null,'280');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6265','BIANCHI DAMIANO','PHDSTUDENT','3631',to_date('09-JUN-81','DD-MON-RR'),'82',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6266','BIANCHI FEDERICO','MANAGER','775',to_date('09-JUN-81','DD-MON-RR'),'618',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6267','ESPOSITO ELENA','ENGINEER','2478',to_date('09-JUN-81','DD-MON-RR'),'181',null,'234');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6268','COZZA GAETANO','PHDSTUDENT','5284',to_date('09-JUN-81','DD-MON-RR'),'1956',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6269','CORONA CLARA','ENGINEER','5868',to_date('09-JUN-81','DD-MON-RR'),'688',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6270','MANZONI PAOLO','ENGINEER','5055',to_date('09-JUN-81','DD-MON-RR'),'1255',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6271','GRIMALDI DAMIANO','PHDSTUDENT','5722',to_date('09-JUN-81','DD-MON-RR'),'1973',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6272','LEVI IVANO','MANAGER','614',to_date('09-JUN-81','DD-MON-RR'),'1094',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6273','CORONA LUCIA','ENGINEER','1166',to_date('09-JUN-81','DD-MON-RR'),'146',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6274','LEVI LUCIA','MANAGER','1502',to_date('09-JUN-81','DD-MON-RR'),'745',null,'60');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6275','NERI CLARA','TECHNICIAN','3225',to_date('09-JUN-81','DD-MON-RR'),'1350',null,'398');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6276','TIBALDI FRANCESCO','MANAGER','4130',to_date('09-JUN-81','DD-MON-RR'),'858',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6277','FUMAROLA LUCA','ENGINEER','5411',to_date('09-JUN-81','DD-MON-RR'),'569',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6278','CARBONE GAETANO','SECRETARY','1538',to_date('09-JUN-81','DD-MON-RR'),'75',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6279','BIANCHI FRANCESCO','MANAGER','2536',to_date('09-JUN-81','DD-MON-RR'),'1839',null,'229');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6280','SANTE DAMIANO','MANAGER','4363',to_date('09-JUN-81','DD-MON-RR'),'1702',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6281','SANTE ELENA','HEADMASTER','958',to_date('09-JUN-81','DD-MON-RR'),'323',null,'474');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6282','LEVI ELIO','LAWYER','3763',to_date('09-JUN-81','DD-MON-RR'),'1994',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6283','GRIMALDI LUCA','PHDSTUDENT','3277',to_date('09-JUN-81','DD-MON-RR'),'167',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6284','ECO LUIGI','ENGINEER','1622',to_date('09-JUN-81','DD-MON-RR'),'229',null,'455');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6285','ESPOSITO FRANCESCO','ENGINEER','288',to_date('09-JUN-81','DD-MON-RR'),'669',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6286','TIBALDI IVANO','ENGINEER','3584',to_date('09-JUN-81','DD-MON-RR'),'1959',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6287','SANTE FRANCESCO','MANAGER','4125',to_date('09-JUN-81','DD-MON-RR'),'757',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6288','PETRARCA CLARA','HEADMASTER','2196',to_date('09-JUN-81','DD-MON-RR'),'1691',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6289','SANTE DAMIANO','ENGINEER','4085',to_date('09-JUN-81','DD-MON-RR'),'551',null,'322');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6290','NERI DAMIANO','LAWYER','5078',to_date('09-JUN-81','DD-MON-RR'),'78',null,'309');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6291','BIANCHI ANDREA','PROFESSOR','3201',to_date('09-JUN-81','DD-MON-RR'),'1318',null,'213');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6292','LEVI LUDOVICO','ENGINEER','1081',to_date('09-JUN-81','DD-MON-RR'),'1670',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6293','FO FEDERICO','PHDSTUDENT','5052',to_date('09-JUN-81','DD-MON-RR'),'522',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6294','LEVI DAMIANO','ENGINEER','949',to_date('09-JUN-81','DD-MON-RR'),'1140',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6295','ECO ANDREA','LAWYER','499',to_date('09-JUN-81','DD-MON-RR'),'1874',null,'39');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6296','ESPOSITO DAMIANO','LAWYER','912',to_date('09-JUN-81','DD-MON-RR'),'705',null,'413');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6297','CALVINO LUDOVICO','SECRETARY','4891',to_date('09-JUN-81','DD-MON-RR'),'1594',null,'420');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6298','DANTE ALFONSO','LAWYER','1703',to_date('09-JUN-81','DD-MON-RR'),'1336',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6299','ESPOSITO PASQUALE','PROFESSOR','5022',to_date('09-JUN-81','DD-MON-RR'),'881',null,'252');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('414','CORONA DAMIANO','LAWYER','32',to_date('09-JUN-81','DD-MON-RR'),'1482',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('415','ECO COSIMO','HEADMASTER','323',to_date('09-JUN-81','DD-MON-RR'),'1709',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('416','LEOPARDI MARIO','SECRETARY','371',to_date('09-JUN-81','DD-MON-RR'),'1116',null,'337');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('417','CORONA IVANO','LAWYER','399',to_date('09-JUN-81','DD-MON-RR'),'688',null,'447');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('418','ECO MARIA','LAWYER','343',to_date('09-JUN-81','DD-MON-RR'),'1269',null,'54');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('419','FO DAMIANO','LAWYER','131',to_date('09-JUN-81','DD-MON-RR'),'1112',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('420','FUMAROLA LUIGI','PROFESSOR','190',to_date('09-JUN-81','DD-MON-RR'),'1453',null,'497');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('421','COZZA GAETANO','MANAGER','316',to_date('09-JUN-81','DD-MON-RR'),'279',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('422','TIBALDI ALFONSO','TECHNICIAN','175',to_date('09-JUN-81','DD-MON-RR'),'838',null,'130');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('423','FO LUDOVICO','ENGINEER','289',to_date('09-JUN-81','DD-MON-RR'),'834',null,'162');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('424','NERI DONATO','HEADMASTER','114',to_date('09-JUN-81','DD-MON-RR'),'1277',null,'179');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('425','COZZA MARIO','HEADMASTER','267',to_date('09-JUN-81','DD-MON-RR'),'1511',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('426','COZZA FEDERICO','PROFESSOR','259',to_date('09-JUN-81','DD-MON-RR'),'643',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('427','NERI ELIO','MANAGER','28',to_date('09-JUN-81','DD-MON-RR'),'330',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('428','ESPOSITO DAMIANO','LAWYER','8',to_date('09-JUN-81','DD-MON-RR'),'316',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('429','GRIMALDI DONATO','PHDSTUDENT','63',to_date('09-JUN-81','DD-MON-RR'),'441',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('430','ESPOSITO ELENA','SUPERVISOR','350',to_date('09-JUN-81','DD-MON-RR'),'680',null,'168');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('431','DANTE MARIO','SECRETARY','55',to_date('09-JUN-81','DD-MON-RR'),'1151',null,'113');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('432','CORONA ELENA','MANAGER','185',to_date('09-JUN-81','DD-MON-RR'),'1583',null,'71');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('433','MANZONI IVANO','SUPERVISOR','270',to_date('09-JUN-81','DD-MON-RR'),'278',null,'387');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('434','CORONA CLARA','MANAGER','249',to_date('09-JUN-81','DD-MON-RR'),'1262',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('435','SANTE IVANO','SUPERVISOR','187',to_date('09-JUN-81','DD-MON-RR'),'1904',null,'498');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('436','LEVI DAMIANO','MANAGER','293',to_date('09-JUN-81','DD-MON-RR'),'1857',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('437','DANTE COSIMO','LAWYER','383',to_date('09-JUN-81','DD-MON-RR'),'1813',null,'28');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('438','CORONA DAMIANO','ENGINEER','278',to_date('09-JUN-81','DD-MON-RR'),'519',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('439','LEOPARDI GAETANO','MANAGER','60',to_date('09-JUN-81','DD-MON-RR'),'1539',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('440','NERI ANTONIO','LAWYER','326',to_date('09-JUN-81','DD-MON-RR'),'102',null,'260');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('441','DANTE LUCIA','PHDSTUDENT','310',to_date('09-JUN-81','DD-MON-RR'),'981',null,'124');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('442','GRIMALDI SILVIA','PROFESSOR','225',to_date('09-JUN-81','DD-MON-RR'),'535',null,'317');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('443','COZZA GAETANO','HEADMASTER','329',to_date('09-JUN-81','DD-MON-RR'),'1848',null,'264');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('444','TIBALDI DAMIANO','SUPERVISOR','381',to_date('09-JUN-81','DD-MON-RR'),'951',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('445','NERI SILVIA','ENGINEER','381',to_date('09-JUN-81','DD-MON-RR'),'608',null,'83');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('446','FUMAROLA LUDOVICO','PROFESSOR','312',to_date('09-JUN-81','DD-MON-RR'),'1498',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('447','FO FEDERICO','PROFESSOR','302',to_date('09-JUN-81','DD-MON-RR'),'1007',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('448','CALVINO LUCIA','HEADMASTER','260',to_date('09-JUN-81','DD-MON-RR'),'1627',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('449','LEOPARDI GIOVANNI','PHDSTUDENT','375',to_date('09-JUN-81','DD-MON-RR'),'1462',null,'78');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('450','DANTE COSIMO','TECHNICIAN','201',to_date('09-JUN-81','DD-MON-RR'),'1756',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('451','PETRARCA ELIO','ENGINEER','269',to_date('09-JUN-81','DD-MON-RR'),'1914',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('452','MANZONI DONATO','ENGINEER','424',to_date('09-JUN-81','DD-MON-RR'),'1169',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('453','SANTE MARIA','HEADMASTER','223',to_date('09-JUN-81','DD-MON-RR'),'956',null,'99');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('454','SANTE ROBERTA','MANAGER','236',to_date('09-JUN-81','DD-MON-RR'),'853',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('455','CALVINO FRANCESCO','SECRETARY','180',to_date('09-JUN-81','DD-MON-RR'),'410',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('456','ESPOSITO LUCIA','PROFESSOR','222',to_date('09-JUN-81','DD-MON-RR'),'832',null,'457');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('457','LEVI ELIO','SUPERVISOR','52',to_date('09-JUN-81','DD-MON-RR'),'855',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('458','DANTE SILVIA','PROFESSOR','373',to_date('09-JUN-81','DD-MON-RR'),'1986',null,'391');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('459','GRIMALDI CLARA','MANAGER','39',to_date('09-JUN-81','DD-MON-RR'),'705',null,'399');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('460','SANTE FRANCESCO','PROFESSOR','327',to_date('09-JUN-81','DD-MON-RR'),'859',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('461','FUMAROLA PASQUALE','MANAGER','170',to_date('09-JUN-81','DD-MON-RR'),'677',null,'498');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('462','ECO DAMIANO','MANAGER','49',to_date('09-JUN-81','DD-MON-RR'),'1517',null,'456');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('463','SANTE COSIMO','SUPERVISOR','378',to_date('09-JUN-81','DD-MON-RR'),'8',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('464','MANZONI LUCA','PHDSTUDENT','451',to_date('09-JUN-81','DD-MON-RR'),'207',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('465','CALVINO LUDOVICO','MANAGER','152',to_date('09-JUN-81','DD-MON-RR'),'1404',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('466','LEOPARDI LUIGI','LAWYER','311',to_date('09-JUN-81','DD-MON-RR'),'968',null,'120');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('467','COZZA ANTONIO','PHDSTUDENT','70',to_date('09-JUN-81','DD-MON-RR'),'1753',null,'321');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('468','TIBALDI UMBERTO','TECHNICIAN','223',to_date('09-JUN-81','DD-MON-RR'),'420',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('469','LEVI ALFONSO','SECRETARY','57',to_date('09-JUN-81','DD-MON-RR'),'1566',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('470','GRIMALDI GIOVANNI','HEADMASTER','157',to_date('09-JUN-81','DD-MON-RR'),'1763',null,'326');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('471','SANTE FRANCESCO','SUPERVISOR','137',to_date('09-JUN-81','DD-MON-RR'),'1280',null,'126');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('472','NERI ALFONSO','SUPERVISOR','197',to_date('09-JUN-81','DD-MON-RR'),'912',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('473','BIANCHI LUCA','SUPERVISOR','423',to_date('09-JUN-81','DD-MON-RR'),'1993',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('474','FO LUIGI','MANAGER','278',to_date('09-JUN-81','DD-MON-RR'),'2',null,'47');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('475','FO ANTONIO','PROFESSOR','236',to_date('09-JUN-81','DD-MON-RR'),'100',null,'265');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('476','PETRARCA MARIO','HEADMASTER','437',to_date('09-JUN-81','DD-MON-RR'),'1461',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('477','FUMAROLA FRANCESCO','ENGINEER','91',to_date('09-JUN-81','DD-MON-RR'),'1362',null,'451');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('478','MANZONI FEDERICO','PROFESSOR','181',to_date('09-JUN-81','DD-MON-RR'),'1274',null,'209');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('479','DANTE PASQUALE','HEADMASTER','91',to_date('09-JUN-81','DD-MON-RR'),'1912',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('480','FUMAROLA UGO','SECRETARY','448',to_date('09-JUN-81','DD-MON-RR'),'0',null,'33');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('481','MANZONI LUIGI','HEADMASTER','464',to_date('09-JUN-81','DD-MON-RR'),'138',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('482','SANTE UMBERTO','TECHNICIAN','267',to_date('09-JUN-81','DD-MON-RR'),'863',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('483','ECO DAMIANO','ENGINEER','425',to_date('09-JUN-81','DD-MON-RR'),'1804',null,'280');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('484','GRIMALDI ANDREA','SUPERVISOR','290',to_date('09-JUN-81','DD-MON-RR'),'1947',null,'443');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('485','GRIMALDI COSIMO','MANAGER','445',to_date('09-JUN-81','DD-MON-RR'),'387',null,'194');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('486','COZZA LUCIA','TECHNICIAN','237',to_date('09-JUN-81','DD-MON-RR'),'1249',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('487','CALVINO ROBERTA','PROFESSOR','109',to_date('09-JUN-81','DD-MON-RR'),'573',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('488','TIBALDI ROBERTA','LAWYER','160',to_date('09-JUN-81','DD-MON-RR'),'1251',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('489','FUMAROLA ELENA','MANAGER','401',to_date('09-JUN-81','DD-MON-RR'),'1054',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('490','FO FEDERICO','MANAGER','47',to_date('09-JUN-81','DD-MON-RR'),'693',null,'457');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('491','BIANCHI LUIGI','TECHNICIAN','13',to_date('09-JUN-81','DD-MON-RR'),'1639',null,'99');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('492','CORONA ELENA','HEADMASTER','240',to_date('09-JUN-81','DD-MON-RR'),'1539',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('493','FO ANDREA','MANAGER','283',to_date('09-JUN-81','DD-MON-RR'),'1009',null,'294');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('494','PETRARCA ALFONSO','MANAGER','380',to_date('09-JUN-81','DD-MON-RR'),'432',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('495','CORONA ROBERTA','PHDSTUDENT','471',to_date('09-JUN-81','DD-MON-RR'),'39',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('496','TIBALDI ANDREA','MANAGER','220',to_date('09-JUN-81','DD-MON-RR'),'1068',null,'484');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('497','LEVI UGO','ENGINEER','285',to_date('09-JUN-81','DD-MON-RR'),'1321',null,'142');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('498','LEOPARDI UMBERTO','MANAGER','376',to_date('09-JUN-81','DD-MON-RR'),'13',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('499','PETRARCA ALFONSO','MANAGER','428',to_date('09-JUN-81','DD-MON-RR'),'113',null,'288');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('500','ECO PASQUALE','PROFESSOR','187',to_date('09-JUN-81','DD-MON-RR'),'484',null,'259');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('501','NERI ELENA','LAWYER','171',to_date('09-JUN-81','DD-MON-RR'),'1110',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('502','LEVI ANTONIO','SECRETARY','414',to_date('09-JUN-81','DD-MON-RR'),'1545',null,'196');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('503','NERI LUCIA','LAWYER','286',to_date('09-JUN-81','DD-MON-RR'),'643',null,'415');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('504','FUMAROLA MARIA','MANAGER','451',to_date('09-JUN-81','DD-MON-RR'),'1051',null,'87');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('505','FO COSIMO','ENGINEER','489',to_date('09-JUN-81','DD-MON-RR'),'1603',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('506','CALVINO ANTONIO','HEADMASTER','260',to_date('09-JUN-81','DD-MON-RR'),'674',null,'186');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('507','LEOPARDI CLARA','HEADMASTER','408',to_date('09-JUN-81','DD-MON-RR'),'950',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('508','LEVI UMBERTO','PROFESSOR','11',to_date('09-JUN-81','DD-MON-RR'),'313',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('509','ECO MARIO','PROFESSOR','494',to_date('09-JUN-81','DD-MON-RR'),'1172',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('510','GRIMALDI IVANO','LAWYER','311',to_date('09-JUN-81','DD-MON-RR'),'54',null,'326');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('511','FUMAROLA GIOVANNI','MANAGER','69',to_date('09-JUN-81','DD-MON-RR'),'62',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('512','NERI UGO','PHDSTUDENT','40',to_date('09-JUN-81','DD-MON-RR'),'1821',null,'54');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('513','MANZONI UMBERTO','TECHNICIAN','171',to_date('09-JUN-81','DD-MON-RR'),'262',null,'426');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('514','GRIMALDI ANDREA','SUPERVISOR','237',to_date('09-JUN-81','DD-MON-RR'),'1913',null,'64');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('515','NERI ELIO','PROFESSOR','379',to_date('09-JUN-81','DD-MON-RR'),'1431',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('516','COZZA SILVIA','SECRETARY','18',to_date('09-JUN-81','DD-MON-RR'),'339',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('517','CALVINO FRANCESCO','SUPERVISOR','338',to_date('09-JUN-81','DD-MON-RR'),'1516',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('518','DANTE DONATO','MANAGER','238',to_date('09-JUN-81','DD-MON-RR'),'1030',null,'8');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('519','NERI LUDOVICO','SUPERVISOR','444',to_date('09-JUN-81','DD-MON-RR'),'1085',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('520','CARBONE CLARA','MANAGER','90',to_date('09-JUN-81','DD-MON-RR'),'328',null,'389');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('521','FUMAROLA PAOLO','LAWYER','62',to_date('09-JUN-81','DD-MON-RR'),'1179',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('522','SANTE ELIO','MANAGER','391',to_date('09-JUN-81','DD-MON-RR'),'532',null,'209');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('523','FO GAETANO','PROFESSOR','216',to_date('09-JUN-81','DD-MON-RR'),'983',null,'58');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('524','COZZA PAOLO','SECRETARY','227',to_date('09-JUN-81','DD-MON-RR'),'1320',null,'369');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('525','GRIMALDI LUDOVICO','HEADMASTER','239',to_date('09-JUN-81','DD-MON-RR'),'1639',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('526','NERI LUCA','PHDSTUDENT','25',to_date('09-JUN-81','DD-MON-RR'),'653',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('527','NERI FEDERICO','MANAGER','364',to_date('09-JUN-81','DD-MON-RR'),'1916',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('528','DANTE LUCA','TECHNICIAN','375',to_date('09-JUN-81','DD-MON-RR'),'1797',null,'437');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('529','ECO FRANCESCO','HEADMASTER','13',to_date('09-JUN-81','DD-MON-RR'),'1528',null,'169');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('530','ECO COSIMO','MANAGER','493',to_date('09-JUN-81','DD-MON-RR'),'1224',null,'402');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('531','DANTE PASQUALE','SUPERVISOR','78',to_date('09-JUN-81','DD-MON-RR'),'1789',null,'170');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('532','PETRARCA ELENA','HEADMASTER','376',to_date('09-JUN-81','DD-MON-RR'),'1233',null,'253');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('533','LEVI ELENA','SUPERVISOR','235',to_date('09-JUN-81','DD-MON-RR'),'878',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('534','FUMAROLA ANTONIO','PHDSTUDENT','532',to_date('09-JUN-81','DD-MON-RR'),'583',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('535','BIANCHI ROBERTA','LAWYER','172',to_date('09-JUN-81','DD-MON-RR'),'1974',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('536','CARBONE LUCA','MANAGER','75',to_date('09-JUN-81','DD-MON-RR'),'795',null,'248');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('537','MANZONI ANDREA','PROFESSOR','15',to_date('09-JUN-81','DD-MON-RR'),'1454',null,'19');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('538','CARBONE UMBERTO','MANAGER','283',to_date('09-JUN-81','DD-MON-RR'),'457',null,'102');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('539','DANTE ELIO','MANAGER','344',to_date('09-JUN-81','DD-MON-RR'),'1085',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('540','ESPOSITO LUCA','PHDSTUDENT','414',to_date('09-JUN-81','DD-MON-RR'),'400',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('541','ESPOSITO SILVIA','MANAGER','66',to_date('09-JUN-81','DD-MON-RR'),'935',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('542','CARBONE ANTONIO','HEADMASTER','21',to_date('09-JUN-81','DD-MON-RR'),'1953',null,'101');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('543','DANTE CLARA','TECHNICIAN','458',to_date('09-JUN-81','DD-MON-RR'),'81',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('544','ESPOSITO LUIGI','PROFESSOR','284',to_date('09-JUN-81','DD-MON-RR'),'198',null,'153');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('545','PETRARCA FRANCESCO','HEADMASTER','58',to_date('09-JUN-81','DD-MON-RR'),'983',null,'193');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('546','NERI UMBERTO','PROFESSOR','530',to_date('09-JUN-81','DD-MON-RR'),'272',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('547','LEVI SILVIA','LAWYER','494',to_date('09-JUN-81','DD-MON-RR'),'1590',null,'53');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('548','ECO LUDOVICO','LAWYER','52',to_date('09-JUN-81','DD-MON-RR'),'1438',null,'329');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('549','LEVI UMBERTO','TECHNICIAN','42',to_date('09-JUN-81','DD-MON-RR'),'585',null,'108');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1360','BIANCHI MARIA','SECRETARY','1254',to_date('09-JUN-81','DD-MON-RR'),'390',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2107','FUMAROLA SILVIA','PHDSTUDENT','1540',to_date('09-JUN-81','DD-MON-RR'),'828',null,'158');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2108','SANTE FEDERICO','HEADMASTER','1145',to_date('09-JUN-81','DD-MON-RR'),'1617',null,'145');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2109','FO IVANO','TECHNICIAN','795',to_date('09-JUN-81','DD-MON-RR'),'1982',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2110','LEVI ANDREA','SECRETARY','1853',to_date('09-JUN-81','DD-MON-RR'),'1382',null,'81');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2111','MANZONI LUDOVICO','PROFESSOR','1978',to_date('09-JUN-81','DD-MON-RR'),'1524',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2112','FUMAROLA ELIO','TECHNICIAN','1028',to_date('09-JUN-81','DD-MON-RR'),'1393',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2113','COZZA DAMIANO','LAWYER','203',to_date('09-JUN-81','DD-MON-RR'),'366',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2114','TIBALDI MARIA','PHDSTUDENT','733',to_date('09-JUN-81','DD-MON-RR'),'118',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2115','GRIMALDI LUCA','SECRETARY','1058',to_date('09-JUN-81','DD-MON-RR'),'1669',null,'457');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2116','SANTE FEDERICO','TECHNICIAN','1587',to_date('09-JUN-81','DD-MON-RR'),'1943',null,'495');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2117','LEOPARDI PAOLO','ENGINEER','753',to_date('09-JUN-81','DD-MON-RR'),'1330',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2118','MANZONI GAETANO','LAWYER','228',to_date('09-JUN-81','DD-MON-RR'),'1129',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2119','TIBALDI PASQUALE','PROFESSOR','2035',to_date('09-JUN-81','DD-MON-RR'),'598',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2120','FUMAROLA ANGELO','SUPERVISOR','2019',to_date('09-JUN-81','DD-MON-RR'),'1366',null,'5');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2121','LEOPARDI MASSIMO','HEADMASTER','207',to_date('09-JUN-81','DD-MON-RR'),'194',null,'8');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2122','COZZA DAMIANO','ENGINEER','99',to_date('09-JUN-81','DD-MON-RR'),'1473',null,'429');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2123','TIBALDI ANGELO','PHDSTUDENT','2112',to_date('09-JUN-81','DD-MON-RR'),'1372',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2124','SANTE GAETANO','PHDSTUDENT','1342',to_date('09-JUN-81','DD-MON-RR'),'1659',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2125','PETRARCA GIOVANNI','SUPERVISOR','56',to_date('09-JUN-81','DD-MON-RR'),'1022',null,'5');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2126','BIANCHI DAMIANO','PHDSTUDENT','172',to_date('09-JUN-81','DD-MON-RR'),'954',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2127','COZZA GAETANO','PROFESSOR','621',to_date('09-JUN-81','DD-MON-RR'),'1227',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2128','LEVI MASSIMO','HEADMASTER','1021',to_date('09-JUN-81','DD-MON-RR'),'619',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2129','LEOPARDI GIOVANNI','LAWYER','464',to_date('09-JUN-81','DD-MON-RR'),'828',null,'267');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2130','PETRARCA LUIGI','MANAGER','1469',to_date('09-JUN-81','DD-MON-RR'),'584',null,'302');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2131','LEOPARDI ELENA','SECRETARY','123',to_date('09-JUN-81','DD-MON-RR'),'820',null,'230');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2132','CARBONE MARIO','MANAGER','741',to_date('09-JUN-81','DD-MON-RR'),'1599',null,'321');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2133','LEOPARDI ALFONSO','LAWYER','151',to_date('09-JUN-81','DD-MON-RR'),'862',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2134','TIBALDI CLARA','LAWYER','1310',to_date('09-JUN-81','DD-MON-RR'),'44',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2135','BIANCHI SILVIA','PROFESSOR','522',to_date('09-JUN-81','DD-MON-RR'),'149',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2136','SANTE LUIGI','PHDSTUDENT','1783',to_date('09-JUN-81','DD-MON-RR'),'1666',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2137','LEOPARDI CLARA','SUPERVISOR','694',to_date('09-JUN-81','DD-MON-RR'),'1386',null,'34');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2138','CORONA LUIGI','MANAGER','1976',to_date('09-JUN-81','DD-MON-RR'),'1368',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2139','BIANCHI ANTONIO','ENGINEER','515',to_date('09-JUN-81','DD-MON-RR'),'413',null,'139');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2140','GRIMALDI SILVIA','MANAGER','929',to_date('09-JUN-81','DD-MON-RR'),'1202',null,'369');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2141','CORONA GAETANO','MANAGER','1727',to_date('09-JUN-81','DD-MON-RR'),'572',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2142','SANTE MASSIMO','PROFESSOR','1793',to_date('09-JUN-81','DD-MON-RR'),'1815',null,'192');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2143','CORONA ALFONSO','LAWYER','1985',to_date('09-JUN-81','DD-MON-RR'),'1598',null,'341');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2144','FO GAETANO','MANAGER','1361',to_date('09-JUN-81','DD-MON-RR'),'462',null,'240');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2145','GRIMALDI PAOLO','SECRETARY','1236',to_date('09-JUN-81','DD-MON-RR'),'740',null,'220');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2146','LEVI MASSIMO','MANAGER','1776',to_date('09-JUN-81','DD-MON-RR'),'1267',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2147','LEOPARDI LUDOVICO','SUPERVISOR','1862',to_date('09-JUN-81','DD-MON-RR'),'77',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2148','ESPOSITO ELENA','TECHNICIAN','540',to_date('09-JUN-81','DD-MON-RR'),'1743',null,'171');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2149','LEVI UGO','HEADMASTER','451',to_date('09-JUN-81','DD-MON-RR'),'1770',null,'282');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2150','NERI UGO','PROFESSOR','1141',to_date('09-JUN-81','DD-MON-RR'),'750',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2151','LEOPARDI CLARA','HEADMASTER','1856',to_date('09-JUN-81','DD-MON-RR'),'1035',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2152','BIANCHI PAOLO','TECHNICIAN','1725',to_date('09-JUN-81','DD-MON-RR'),'1119',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2153','FO IVANO','PROFESSOR','28',to_date('09-JUN-81','DD-MON-RR'),'128',null,'194');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2154','PETRARCA ANDREA','SUPERVISOR','1483',to_date('09-JUN-81','DD-MON-RR'),'418',null,'262');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2155','CARBONE MARIA','PROFESSOR','1623',to_date('09-JUN-81','DD-MON-RR'),'865',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2156','CALVINO PAOLO','LAWYER','694',to_date('09-JUN-81','DD-MON-RR'),'534',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2157','COZZA COSIMO','MANAGER','401',to_date('09-JUN-81','DD-MON-RR'),'219',null,'78');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2158','MANZONI MARIO','HEADMASTER','593',to_date('09-JUN-81','DD-MON-RR'),'1185',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2159','TIBALDI MARIA','ENGINEER','653',to_date('09-JUN-81','DD-MON-RR'),'1273',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2160','TIBALDI MARIA','SECRETARY','323',to_date('09-JUN-81','DD-MON-RR'),'1286',null,'288');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2161','SANTE LUCA','SUPERVISOR','509',to_date('09-JUN-81','DD-MON-RR'),'1180',null,'124');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2162','CALVINO FEDERICO','MANAGER','1596',to_date('09-JUN-81','DD-MON-RR'),'859',null,'333');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2163','BIANCHI ALFONSO','PROFESSOR','1872',to_date('09-JUN-81','DD-MON-RR'),'925',null,'419');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2164','GRIMALDI COSIMO','PROFESSOR','2019',to_date('09-JUN-81','DD-MON-RR'),'856',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2165','DANTE UMBERTO','MANAGER','694',to_date('09-JUN-81','DD-MON-RR'),'810',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2166','GRIMALDI FRANCESCO','SECRETARY','1905',to_date('09-JUN-81','DD-MON-RR'),'977',null,'407');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2167','DANTE UGO','PHDSTUDENT','1483',to_date('09-JUN-81','DD-MON-RR'),'736',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2168','LEVI IVANO','MANAGER','1294',to_date('09-JUN-81','DD-MON-RR'),'259',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2169','CORONA SILVIA','TECHNICIAN','483',to_date('09-JUN-81','DD-MON-RR'),'1926',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2170','CALVINO COSIMO','LAWYER','2083',to_date('09-JUN-81','DD-MON-RR'),'920',null,'177');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2171','CORONA PASQUALE','TECHNICIAN','308',to_date('09-JUN-81','DD-MON-RR'),'476',null,'48');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2172','LEOPARDI MASSIMO','TECHNICIAN','34',to_date('09-JUN-81','DD-MON-RR'),'101',null,'47');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2173','CALVINO IVANO','ENGINEER','392',to_date('09-JUN-81','DD-MON-RR'),'1998',null,'243');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2174','CORONA DAMIANO','PHDSTUDENT','1271',to_date('09-JUN-81','DD-MON-RR'),'1315',null,'240');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2175','FO DONATO','MANAGER','493',to_date('09-JUN-81','DD-MON-RR'),'528',null,'39');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2176','COZZA LUCA','HEADMASTER','410',to_date('09-JUN-81','DD-MON-RR'),'647',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2177','BIANCHI FEDERICO','HEADMASTER','24',to_date('09-JUN-81','DD-MON-RR'),'593',null,'46');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2178','DANTE FRANCESCO','TECHNICIAN','1009',to_date('09-JUN-81','DD-MON-RR'),'1964',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2179','CORONA MARIO','TECHNICIAN','1020',to_date('09-JUN-81','DD-MON-RR'),'1772',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2180','COZZA DONATO','LAWYER','1238',to_date('09-JUN-81','DD-MON-RR'),'783',null,'77');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2181','BIANCHI GAETANO','LAWYER','188',to_date('09-JUN-81','DD-MON-RR'),'322',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2182','LEVI ALFONSO','LAWYER','1756',to_date('09-JUN-81','DD-MON-RR'),'914',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2183','BIANCHI UMBERTO','MANAGER','860',to_date('09-JUN-81','DD-MON-RR'),'51',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2184','GRIMALDI ANDREA','PHDSTUDENT','1786',to_date('09-JUN-81','DD-MON-RR'),'891',null,'105');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2185','PETRARCA ROBERTA','MANAGER','646',to_date('09-JUN-81','DD-MON-RR'),'1924',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2186','NERI MARIA','SECRETARY','1723',to_date('09-JUN-81','DD-MON-RR'),'1393',null,'450');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2187','CARBONE ANDREA','LAWYER','855',to_date('09-JUN-81','DD-MON-RR'),'529',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2188','GRIMALDI LUIGI','ENGINEER','1465',to_date('09-JUN-81','DD-MON-RR'),'1114',null,'196');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2189','CARBONE ROBERTA','LAWYER','33',to_date('09-JUN-81','DD-MON-RR'),'528',null,'407');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2190','GRIMALDI LUCIA','HEADMASTER','1314',to_date('09-JUN-81','DD-MON-RR'),'1930',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2191','ECO UMBERTO','SUPERVISOR','231',to_date('09-JUN-81','DD-MON-RR'),'410',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2192','LEOPARDI MARIA','MANAGER','771',to_date('09-JUN-81','DD-MON-RR'),'92',null,'101');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2193','SANTE ANDREA','TECHNICIAN','1143',to_date('09-JUN-81','DD-MON-RR'),'691',null,'461');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2194','DANTE DAMIANO','PHDSTUDENT','620',to_date('09-JUN-81','DD-MON-RR'),'105',null,'316');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2195','CALVINO LUIGI','ENGINEER','671',to_date('09-JUN-81','DD-MON-RR'),'1757',null,'134');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2196','SANTE ALFONSO','MANAGER','569',to_date('09-JUN-81','DD-MON-RR'),'701',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2197','CARBONE ANGELO','HEADMASTER','1485',to_date('09-JUN-81','DD-MON-RR'),'1416',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2198','PETRARCA DAMIANO','TECHNICIAN','538',to_date('09-JUN-81','DD-MON-RR'),'770',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2199','SANTE ANDREA','ENGINEER','1183',to_date('09-JUN-81','DD-MON-RR'),'1162',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2200','FO LUCA','MANAGER','1044',to_date('09-JUN-81','DD-MON-RR'),'1969',null,'430');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2201','ESPOSITO SILVIA','SUPERVISOR','943',to_date('09-JUN-81','DD-MON-RR'),'1442',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2202','LEOPARDI ANTONIO','LAWYER','1905',to_date('09-JUN-81','DD-MON-RR'),'271',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2203','NERI COSIMO','LAWYER','1597',to_date('09-JUN-81','DD-MON-RR'),'519',null,'385');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2204','ESPOSITO MARIO','MANAGER','2183',to_date('09-JUN-81','DD-MON-RR'),'1931',null,'325');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2205','DANTE DONATO','MANAGER','1494',to_date('09-JUN-81','DD-MON-RR'),'1225',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2206','SANTE GIOVANNI','MANAGER','1424',to_date('09-JUN-81','DD-MON-RR'),'1569',null,'248');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2207','LEOPARDI LUDOVICO','SECRETARY','2025',to_date('09-JUN-81','DD-MON-RR'),'1938',null,'46');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2208','LEVI ANTONIO','PHDSTUDENT','1824',to_date('09-JUN-81','DD-MON-RR'),'304',null,'183');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2209','ESPOSITO DAMIANO','MANAGER','1473',to_date('09-JUN-81','DD-MON-RR'),'963',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2210','CARBONE LUCA','SUPERVISOR','1431',to_date('09-JUN-81','DD-MON-RR'),'1708',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2211','LEOPARDI FRANCESCO','PHDSTUDENT','1630',to_date('09-JUN-81','DD-MON-RR'),'78',null,'325');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2212','LEVI LUCIA','SUPERVISOR','423',to_date('09-JUN-81','DD-MON-RR'),'120',null,'362');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2213','DANTE ELIO','TECHNICIAN','863',to_date('09-JUN-81','DD-MON-RR'),'653',null,'151');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2214','BIANCHI DAMIANO','MANAGER','1218',to_date('09-JUN-81','DD-MON-RR'),'1182',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2215','LEVI IVANO','HEADMASTER','461',to_date('09-JUN-81','DD-MON-RR'),'1114',null,'153');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2216','CARBONE ANTONIO','TECHNICIAN','1296',to_date('09-JUN-81','DD-MON-RR'),'512',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2217','NERI ANGELO','PROFESSOR','2198',to_date('09-JUN-81','DD-MON-RR'),'1365',null,'471');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2218','NERI DAMIANO','TECHNICIAN','1926',to_date('09-JUN-81','DD-MON-RR'),'713',null,'385');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2219','FUMAROLA LUCIA','ENGINEER','2145',to_date('09-JUN-81','DD-MON-RR'),'1327',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2220','CALVINO SILVIA','LAWYER','1546',to_date('09-JUN-81','DD-MON-RR'),'365',null,'376');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2221','SANTE MARIA','MANAGER','1565',to_date('09-JUN-81','DD-MON-RR'),'973',null,'263');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2222','FUMAROLA DAMIANO','ENGINEER','729',to_date('09-JUN-81','DD-MON-RR'),'1430',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2223','GRIMALDI ANDREA','HEADMASTER','1590',to_date('09-JUN-81','DD-MON-RR'),'600',null,'12');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2224','CARBONE ANGELO','SUPERVISOR','402',to_date('09-JUN-81','DD-MON-RR'),'877',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2225','DANTE DAMIANO','PROFESSOR','1474',to_date('09-JUN-81','DD-MON-RR'),'757',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2226','TIBALDI PASQUALE','PHDSTUDENT','1528',to_date('09-JUN-81','DD-MON-RR'),'176',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2227','ESPOSITO MARIA','MANAGER','520',to_date('09-JUN-81','DD-MON-RR'),'1723',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2228','LEOPARDI IVANO','MANAGER','1345',to_date('09-JUN-81','DD-MON-RR'),'1698',null,'258');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2229','MANZONI MARIO','LAWYER','1710',to_date('09-JUN-81','DD-MON-RR'),'1032',null,'214');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2230','BIANCHI PAOLO','HEADMASTER','770',to_date('09-JUN-81','DD-MON-RR'),'1291',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2231','BIANCHI LUCA','SECRETARY','368',to_date('09-JUN-81','DD-MON-RR'),'1495',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2232','LEOPARDI ANDREA','LAWYER','1301',to_date('09-JUN-81','DD-MON-RR'),'392',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2233','PETRARCA PAOLO','SUPERVISOR','1309',to_date('09-JUN-81','DD-MON-RR'),'1472',null,'169');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2234','CORONA ALFONSO','PROFESSOR','209',to_date('09-JUN-81','DD-MON-RR'),'265',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2235','NERI ELENA','PHDSTUDENT','1415',to_date('09-JUN-81','DD-MON-RR'),'95',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2236','SANTE GAETANO','PROFESSOR','2227',to_date('09-JUN-81','DD-MON-RR'),'1035',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2237','CALVINO UMBERTO','PROFESSOR','1009',to_date('09-JUN-81','DD-MON-RR'),'1227',null,'393');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2238','ECO FEDERICO','SUPERVISOR','664',to_date('09-JUN-81','DD-MON-RR'),'1137',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2239','SANTE UMBERTO','MANAGER','692',to_date('09-JUN-81','DD-MON-RR'),'1532',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2240','BIANCHI LUCIA','MANAGER','1507',to_date('09-JUN-81','DD-MON-RR'),'1844',null,'451');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2241','CARBONE FEDERICO','HEADMASTER','837',to_date('09-JUN-81','DD-MON-RR'),'82',null,'386');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4138','ECO PASQUALE','PHDSTUDENT','1610',to_date('09-JUN-81','DD-MON-RR'),'1502',null,'123');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4139','GRIMALDI LUCA','TECHNICIAN','1302',to_date('09-JUN-81','DD-MON-RR'),'331',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4140','TIBALDI ANGELO','MANAGER','2293',to_date('09-JUN-81','DD-MON-RR'),'1235',null,'393');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4141','GRIMALDI FEDERICO','MANAGER','1670',to_date('09-JUN-81','DD-MON-RR'),'1926',null,'99');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4142','CORONA LUCIA','SUPERVISOR','3294',to_date('09-JUN-81','DD-MON-RR'),'1857',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4143','COZZA GAETANO','HEADMASTER','1422',to_date('09-JUN-81','DD-MON-RR'),'244',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4144','FUMAROLA ELENA','PROFESSOR','1442',to_date('09-JUN-81','DD-MON-RR'),'763',null,'356');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4145','MANZONI ELIO','SUPERVISOR','2275',to_date('09-JUN-81','DD-MON-RR'),'1213',null,'412');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4146','BIANCHI COSIMO','MANAGER','372',to_date('09-JUN-81','DD-MON-RR'),'1814',null,'101');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4147','MANZONI CLARA','PROFESSOR','2271',to_date('09-JUN-81','DD-MON-RR'),'1257',null,'111');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4148','ESPOSITO LUCIA','TECHNICIAN','1068',to_date('09-JUN-81','DD-MON-RR'),'1706',null,'38');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4149','LEOPARDI ALFONSO','MANAGER','2840',to_date('09-JUN-81','DD-MON-RR'),'1581',null,'263');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4150','LEVI GAETANO','TECHNICIAN','2511',to_date('09-JUN-81','DD-MON-RR'),'355',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4151','BIANCHI GIOVANNI','MANAGER','2783',to_date('09-JUN-81','DD-MON-RR'),'1205',null,'298');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4152','CALVINO MARIA','PHDSTUDENT','694',to_date('09-JUN-81','DD-MON-RR'),'876',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4153','CARBONE GIOVANNI','HEADMASTER','1434',to_date('09-JUN-81','DD-MON-RR'),'1650',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4154','CORONA ELIO','PROFESSOR','2358',to_date('09-JUN-81','DD-MON-RR'),'1294',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4155','ESPOSITO PASQUALE','MANAGER','2796',to_date('09-JUN-81','DD-MON-RR'),'1299',null,'230');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4156','LEVI GAETANO','ENGINEER','2275',to_date('09-JUN-81','DD-MON-RR'),'1502',null,'287');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4157','LEVI LUDOVICO','SECRETARY','2381',to_date('09-JUN-81','DD-MON-RR'),'1584',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4158','DANTE ELIO','PHDSTUDENT','826',to_date('09-JUN-81','DD-MON-RR'),'1054',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4159','GRIMALDI GIOVANNI','LAWYER','2008',to_date('09-JUN-81','DD-MON-RR'),'1037',null,'453');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4160','ECO FEDERICO','MANAGER','1746',to_date('09-JUN-81','DD-MON-RR'),'571',null,'300');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4161','ESPOSITO ELIO','MANAGER','3549',to_date('09-JUN-81','DD-MON-RR'),'1382',null,'216');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4162','PETRARCA UGO','PHDSTUDENT','3723',to_date('09-JUN-81','DD-MON-RR'),'815',null,'425');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4163','CALVINO ANDREA','SUPERVISOR','1128',to_date('09-JUN-81','DD-MON-RR'),'475',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4164','LEVI GIOVANNI','PROFESSOR','3446',to_date('09-JUN-81','DD-MON-RR'),'680',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4165','ESPOSITO DAMIANO','ENGINEER','2854',to_date('09-JUN-81','DD-MON-RR'),'1794',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4166','CORONA ELIO','LAWYER','4033',to_date('09-JUN-81','DD-MON-RR'),'1260',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4167','MANZONI LUCIA','MANAGER','1915',to_date('09-JUN-81','DD-MON-RR'),'1906',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4168','GRIMALDI GIOVANNI','HEADMASTER','1425',to_date('09-JUN-81','DD-MON-RR'),'47',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4169','BIANCHI CLARA','PROFESSOR','1719',to_date('09-JUN-81','DD-MON-RR'),'838',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4170','ECO ALFONSO','SUPERVISOR','346',to_date('09-JUN-81','DD-MON-RR'),'1677',null,'427');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4171','MANZONI DAMIANO','PHDSTUDENT','339',to_date('09-JUN-81','DD-MON-RR'),'186',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4172','CALVINO MARIA','LAWYER','1842',to_date('09-JUN-81','DD-MON-RR'),'1908',null,'136');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4173','FO FEDERICO','ENGINEER','2052',to_date('09-JUN-81','DD-MON-RR'),'1212',null,'24');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4174','PETRARCA SILVIA','SUPERVISOR','3814',to_date('09-JUN-81','DD-MON-RR'),'1841',null,'30');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4175','DANTE ELIO','TECHNICIAN','1466',to_date('09-JUN-81','DD-MON-RR'),'889',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4176','CARBONE GIOVANNI','SECRETARY','3498',to_date('09-JUN-81','DD-MON-RR'),'1072',null,'135');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4177','CORONA PAOLO','MANAGER','1756',to_date('09-JUN-81','DD-MON-RR'),'1643',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4178','LEVI LUDOVICO','PHDSTUDENT','3011',to_date('09-JUN-81','DD-MON-RR'),'1522',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4179','TIBALDI IVANO','MANAGER','1723',to_date('09-JUN-81','DD-MON-RR'),'898',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4180','CARBONE CLARA','SECRETARY','2875',to_date('09-JUN-81','DD-MON-RR'),'387',null,'413');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4181','LEOPARDI ELIO','SUPERVISOR','3844',to_date('09-JUN-81','DD-MON-RR'),'474',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4182','TIBALDI ELENA','SUPERVISOR','4006',to_date('09-JUN-81','DD-MON-RR'),'1515',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4183','PETRARCA UMBERTO','HEADMASTER','2779',to_date('09-JUN-81','DD-MON-RR'),'346',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4184','COZZA PASQUALE','TECHNICIAN','1492',to_date('09-JUN-81','DD-MON-RR'),'713',null,'18');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4185','PETRARCA PAOLO','TECHNICIAN','3182',to_date('09-JUN-81','DD-MON-RR'),'1035',null,'36');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4186','LEVI ALFONSO','LAWYER','3647',to_date('09-JUN-81','DD-MON-RR'),'356',null,'355');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4187','COZZA GAETANO','SECRETARY','3729',to_date('09-JUN-81','DD-MON-RR'),'655',null,'402');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4188','NERI PAOLO','MANAGER','851',to_date('09-JUN-81','DD-MON-RR'),'1342',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4189','COZZA UGO','SECRETARY','3530',to_date('09-JUN-81','DD-MON-RR'),'569',null,'365');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4190','MANZONI MARIO','LAWYER','3177',to_date('09-JUN-81','DD-MON-RR'),'845',null,'39');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4191','TIBALDI ANGELO','MANAGER','1273',to_date('09-JUN-81','DD-MON-RR'),'1764',null,'258');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4192','SANTE FRANCESCO','ENGINEER','258',to_date('09-JUN-81','DD-MON-RR'),'927',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4193','CARBONE SILVIA','HEADMASTER','523',to_date('09-JUN-81','DD-MON-RR'),'1159',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4194','FO LUCIA','ENGINEER','3905',to_date('09-JUN-81','DD-MON-RR'),'1356',null,'52');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4195','COZZA PASQUALE','HEADMASTER','943',to_date('09-JUN-81','DD-MON-RR'),'630',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4196','GRIMALDI IVANO','LAWYER','2698',to_date('09-JUN-81','DD-MON-RR'),'901',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4197','CALVINO ROBERTA','SUPERVISOR','197',to_date('09-JUN-81','DD-MON-RR'),'1053',null,'60');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4198','DANTE LUCA','HEADMASTER','2028',to_date('09-JUN-81','DD-MON-RR'),'1037',null,'38');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4199','CORONA ANGELO','HEADMASTER','828',to_date('09-JUN-81','DD-MON-RR'),'11',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4200','FUMAROLA DONATO','TECHNICIAN','295',to_date('09-JUN-81','DD-MON-RR'),'1787',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4201','FO FRANCESCO','PHDSTUDENT','1939',to_date('09-JUN-81','DD-MON-RR'),'1682',null,'30');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4202','ESPOSITO LUCIA','ENGINEER','850',to_date('09-JUN-81','DD-MON-RR'),'96',null,'25');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4203','PETRARCA UMBERTO','PROFESSOR','3449',to_date('09-JUN-81','DD-MON-RR'),'1586',null,'481');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4204','DANTE ROBERTA','SUPERVISOR','3406',to_date('09-JUN-81','DD-MON-RR'),'733',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4205','TIBALDI PAOLO','HEADMASTER','2305',to_date('09-JUN-81','DD-MON-RR'),'1479',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4206','FO ELIO','SECRETARY','2611',to_date('09-JUN-81','DD-MON-RR'),'923',null,'322');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4207','ECO FEDERICO','MANAGER','867',to_date('09-JUN-81','DD-MON-RR'),'419',null,'347');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4208','NERI ELIO','MANAGER','2957',to_date('09-JUN-81','DD-MON-RR'),'707',null,'399');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4209','PETRARCA ANTONIO','TECHNICIAN','2965',to_date('09-JUN-81','DD-MON-RR'),'123',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4210','BIANCHI IVANO','MANAGER','1941',to_date('09-JUN-81','DD-MON-RR'),'21',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4211','COZZA COSIMO','ENGINEER','3669',to_date('09-JUN-81','DD-MON-RR'),'1285',null,'103');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4212','LEOPARDI ANGELO','HEADMASTER','689',to_date('09-JUN-81','DD-MON-RR'),'1059',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4213','SANTE MARIO','SUPERVISOR','3638',to_date('09-JUN-81','DD-MON-RR'),'980',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4214','TIBALDI ELIO','TECHNICIAN','2654',to_date('09-JUN-81','DD-MON-RR'),'1722',null,'311');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4215','FO ANTONIO','SUPERVISOR','4085',to_date('09-JUN-81','DD-MON-RR'),'141',null,'48');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4216','CALVINO UMBERTO','ENGINEER','1929',to_date('09-JUN-81','DD-MON-RR'),'19',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4217','MANZONI MASSIMO','SECRETARY','3701',to_date('09-JUN-81','DD-MON-RR'),'1380',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4218','ECO ANDREA','PHDSTUDENT','1085',to_date('09-JUN-81','DD-MON-RR'),'825',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4219','ESPOSITO CLARA','TECHNICIAN','542',to_date('09-JUN-81','DD-MON-RR'),'1409',null,'455');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4220','CALVINO ANGELO','MANAGER','3531',to_date('09-JUN-81','DD-MON-RR'),'1277',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4221','FO ALFONSO','ENGINEER','214',to_date('09-JUN-81','DD-MON-RR'),'1619',null,'369');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4222','NERI ANGELO','SUPERVISOR','3782',to_date('09-JUN-81','DD-MON-RR'),'702',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4223','MANZONI ANDREA','HEADMASTER','3854',to_date('09-JUN-81','DD-MON-RR'),'1818',null,'458');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4224','BIANCHI UGO','PROFESSOR','3609',to_date('09-JUN-81','DD-MON-RR'),'1210',null,'348');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4225','ESPOSITO DONATO','HEADMASTER','1207',to_date('09-JUN-81','DD-MON-RR'),'386',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4226','FUMAROLA CLARA','HEADMASTER','2566',to_date('09-JUN-81','DD-MON-RR'),'354',null,'83');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4227','PETRARCA GAETANO','ENGINEER','2590',to_date('09-JUN-81','DD-MON-RR'),'1768',null,'495');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4228','SANTE FEDERICO','MANAGER','314',to_date('09-JUN-81','DD-MON-RR'),'615',null,'276');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4229','CARBONE MASSIMO','LAWYER','4162',to_date('09-JUN-81','DD-MON-RR'),'1934',null,'317');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4230','LEVI MASSIMO','SUPERVISOR','200',to_date('09-JUN-81','DD-MON-RR'),'36',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4231','LEOPARDI PAOLO','PROFESSOR','1730',to_date('09-JUN-81','DD-MON-RR'),'1005',null,'243');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4232','LEVI ANGELO','SUPERVISOR','909',to_date('09-JUN-81','DD-MON-RR'),'925',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4233','ECO PASQUALE','ENGINEER','3593',to_date('09-JUN-81','DD-MON-RR'),'212',null,'31');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4234','CORONA ALFONSO','HEADMASTER','1824',to_date('09-JUN-81','DD-MON-RR'),'165',null,'71');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4235','SANTE ALFONSO','MANAGER','238',to_date('09-JUN-81','DD-MON-RR'),'1622',null,'447');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4236','TIBALDI FEDERICO','PHDSTUDENT','2335',to_date('09-JUN-81','DD-MON-RR'),'545',null,'146');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4237','LEOPARDI DONATO','HEADMASTER','2183',to_date('09-JUN-81','DD-MON-RR'),'126',null,'302');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4238','COZZA ALFONSO','SECRETARY','2677',to_date('09-JUN-81','DD-MON-RR'),'235',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4239','MANZONI DAMIANO','MANAGER','3694',to_date('09-JUN-81','DD-MON-RR'),'1900',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4240','CALVINO LUCIA','MANAGER','3780',to_date('09-JUN-81','DD-MON-RR'),'143',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4241','ESPOSITO PAOLO','TECHNICIAN','2446',to_date('09-JUN-81','DD-MON-RR'),'1727',null,'318');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4242','ESPOSITO SILVIA','ENGINEER','58',to_date('09-JUN-81','DD-MON-RR'),'836',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4243','BIANCHI ANTONIO','PHDSTUDENT','1091',to_date('09-JUN-81','DD-MON-RR'),'1852',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4244','TIBALDI LUCA','TECHNICIAN','3581',to_date('09-JUN-81','DD-MON-RR'),'986',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4245','CARBONE ROBERTA','MANAGER','1944',to_date('09-JUN-81','DD-MON-RR'),'800',null,'245');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4246','MANZONI MASSIMO','SUPERVISOR','1369',to_date('09-JUN-81','DD-MON-RR'),'1526',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4247','LEVI FEDERICO','PHDSTUDENT','1887',to_date('09-JUN-81','DD-MON-RR'),'1294',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4248','FO MARIO','SECRETARY','3436',to_date('09-JUN-81','DD-MON-RR'),'1048',null,'105');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4249','ESPOSITO PASQUALE','MANAGER','841',to_date('09-JUN-81','DD-MON-RR'),'739',null,'162');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4250','BIANCHI ELIO','SUPERVISOR','96',to_date('09-JUN-81','DD-MON-RR'),'1193',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4251','ECO MASSIMO','PROFESSOR','1356',to_date('09-JUN-81','DD-MON-RR'),'1755',null,'91');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4252','BIANCHI PAOLO','SUPERVISOR','2374',to_date('09-JUN-81','DD-MON-RR'),'562',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4253','BIANCHI LUCA','SECRETARY','3540',to_date('09-JUN-81','DD-MON-RR'),'165',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4254','MANZONI ELIO','TECHNICIAN','3723',to_date('09-JUN-81','DD-MON-RR'),'48',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4255','GRIMALDI PASQUALE','SECRETARY','147',to_date('09-JUN-81','DD-MON-RR'),'1298',null,'443');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4256','ESPOSITO LUCA','PHDSTUDENT','2931',to_date('09-JUN-81','DD-MON-RR'),'966',null,'159');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4257','BIANCHI ALFONSO','PHDSTUDENT','2936',to_date('09-JUN-81','DD-MON-RR'),'58',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4258','NERI FRANCESCO','HEADMASTER','3774',to_date('09-JUN-81','DD-MON-RR'),'819',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4259','SANTE DONATO','ENGINEER','3936',to_date('09-JUN-81','DD-MON-RR'),'656',null,'322');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4260','NERI ANTONIO','PHDSTUDENT','1557',to_date('09-JUN-81','DD-MON-RR'),'1127',null,'460');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4261','CORONA MARIO','ENGINEER','2954',to_date('09-JUN-81','DD-MON-RR'),'1042',null,'284');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4262','PETRARCA ALFONSO','PHDSTUDENT','720',to_date('09-JUN-81','DD-MON-RR'),'167',null,'33');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4263','LEVI ANDREA','LAWYER','1357',to_date('09-JUN-81','DD-MON-RR'),'249',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4264','FO GIOVANNI','PHDSTUDENT','3124',to_date('09-JUN-81','DD-MON-RR'),'383',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4265','NERI GIOVANNI','MANAGER','2767',to_date('09-JUN-81','DD-MON-RR'),'1265',null,'464');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4266','MANZONI ELIO','MANAGER','2793',to_date('09-JUN-81','DD-MON-RR'),'1156',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4267','LEVI DAMIANO','SUPERVISOR','1116',to_date('09-JUN-81','DD-MON-RR'),'1520',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4268','CORONA ALFONSO','LAWYER','4159',to_date('09-JUN-81','DD-MON-RR'),'1370',null,'61');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4269','CARBONE LUCA','LAWYER','2294',to_date('09-JUN-81','DD-MON-RR'),'1061',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4270','CORONA MASSIMO','HEADMASTER','3155',to_date('09-JUN-81','DD-MON-RR'),'1114',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4271','CARBONE ELENA','MANAGER','1836',to_date('09-JUN-81','DD-MON-RR'),'1563',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4272','LEOPARDI IVANO','ENGINEER','1666',to_date('09-JUN-81','DD-MON-RR'),'532',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6300','FUMAROLA MASSIMO','SECRETARY','5578',to_date('09-JUN-81','DD-MON-RR'),'630',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6301','NERI PAOLO','ENGINEER','841',to_date('09-JUN-81','DD-MON-RR'),'317',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6302','FO GAETANO','PROFESSOR','6096',to_date('09-JUN-81','DD-MON-RR'),'1012',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6303','SANTE GIOVANNI','SUPERVISOR','3545',to_date('09-JUN-81','DD-MON-RR'),'277',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6304','FUMAROLA MARIO','MANAGER','3234',to_date('09-JUN-81','DD-MON-RR'),'1922',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6305','GRIMALDI COSIMO','SUPERVISOR','4127',to_date('09-JUN-81','DD-MON-RR'),'1383',null,'3');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6306','DANTE LUDOVICO','SECRETARY','4064',to_date('09-JUN-81','DD-MON-RR'),'1580',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6307','FUMAROLA COSIMO','TECHNICIAN','5102',to_date('09-JUN-81','DD-MON-RR'),'1437',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6308','COZZA PASQUALE','PHDSTUDENT','375',to_date('09-JUN-81','DD-MON-RR'),'180',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6309','NERI ELIO','TECHNICIAN','5059',to_date('09-JUN-81','DD-MON-RR'),'361',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6310','PETRARCA ANDREA','SECRETARY','6003',to_date('09-JUN-81','DD-MON-RR'),'1708',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6311','ESPOSITO PASQUALE','PROFESSOR','6188',to_date('09-JUN-81','DD-MON-RR'),'1453',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6312','FO LUCIA','LAWYER','442',to_date('09-JUN-81','DD-MON-RR'),'1899',null,'481');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6313','CORONA LUIGI','HEADMASTER','4863',to_date('09-JUN-81','DD-MON-RR'),'21',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6314','CALVINO ANDREA','PROFESSOR','4925',to_date('09-JUN-81','DD-MON-RR'),'1196',null,'214');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6315','PETRARCA PAOLO','PROFESSOR','4310',to_date('09-JUN-81','DD-MON-RR'),'1617',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6316','CORONA SILVIA','PROFESSOR','2725',to_date('09-JUN-81','DD-MON-RR'),'1497',null,'146');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6317','FUMAROLA PAOLO','PHDSTUDENT','1072',to_date('09-JUN-81','DD-MON-RR'),'1958',null,'191');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6785','MANZONI PASQUALE','HEADMASTER','5810',to_date('09-JUN-81','DD-MON-RR'),'778',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6786','PETRARCA ANTONIO','SUPERVISOR','4809',to_date('09-JUN-81','DD-MON-RR'),'1797',null,'191');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6787','TIBALDI IVANO','MANAGER','1297',to_date('09-JUN-81','DD-MON-RR'),'1038',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6788','CARBONE LUCA','HEADMASTER','2695',to_date('09-JUN-81','DD-MON-RR'),'702',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6789','CORONA MARIA','PROFESSOR','1299',to_date('09-JUN-81','DD-MON-RR'),'1738',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6790','ESPOSITO DONATO','MANAGER','5310',to_date('09-JUN-81','DD-MON-RR'),'832',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6791','PETRARCA LUCA','SUPERVISOR','786',to_date('09-JUN-81','DD-MON-RR'),'1056',null,'184');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6792','FO MASSIMO','MANAGER','71',to_date('09-JUN-81','DD-MON-RR'),'570',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6793','SANTE ANTONIO','SECRETARY','2772',to_date('09-JUN-81','DD-MON-RR'),'475',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6794','SANTE ELENA','PHDSTUDENT','365',to_date('09-JUN-81','DD-MON-RR'),'502',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6795','GRIMALDI PAOLO','TECHNICIAN','1285',to_date('09-JUN-81','DD-MON-RR'),'1848',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6796','LEOPARDI ELENA','HEADMASTER','5813',to_date('09-JUN-81','DD-MON-RR'),'1841',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6797','COZZA ANTONIO','PHDSTUDENT','1083',to_date('09-JUN-81','DD-MON-RR'),'861',null,'437');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6798','GRIMALDI LUCA','SECRETARY','5811',to_date('09-JUN-81','DD-MON-RR'),'1695',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6799','LEVI ANGELO','PHDSTUDENT','5099',to_date('09-JUN-81','DD-MON-RR'),'1950',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6800','CORONA PAOLO','TECHNICIAN','4444',to_date('09-JUN-81','DD-MON-RR'),'1093',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6801','ESPOSITO UMBERTO','HEADMASTER','5225',to_date('09-JUN-81','DD-MON-RR'),'1575',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6802','FUMAROLA ROBERTA','HEADMASTER','5799',to_date('09-JUN-81','DD-MON-RR'),'342',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6803','ESPOSITO DONATO','MANAGER','3003',to_date('09-JUN-81','DD-MON-RR'),'1279',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6804','LEVI CLARA','PROFESSOR','2760',to_date('09-JUN-81','DD-MON-RR'),'1674',null,'44');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6805','DANTE SILVIA','LAWYER','502',to_date('09-JUN-81','DD-MON-RR'),'825',null,'496');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6806','FO DAMIANO','MANAGER','3655',to_date('09-JUN-81','DD-MON-RR'),'1964',null,'356');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6807','LEVI IVANO','SUPERVISOR','454',to_date('09-JUN-81','DD-MON-RR'),'197',null,'447');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6808','NERI ELENA','LAWYER','2159',to_date('09-JUN-81','DD-MON-RR'),'534',null,'160');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6809','FUMAROLA ANTONIO','SECRETARY','4249',to_date('09-JUN-81','DD-MON-RR'),'132',null,'122');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6810','TIBALDI PAOLO','SUPERVISOR','1088',to_date('09-JUN-81','DD-MON-RR'),'1618',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6811','LEVI LUIGI','ENGINEER','533',to_date('09-JUN-81','DD-MON-RR'),'1498',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6812','FUMAROLA PAOLO','SECRETARY','3513',to_date('09-JUN-81','DD-MON-RR'),'815',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6813','FUMAROLA ANGELO','SUPERVISOR','630',to_date('09-JUN-81','DD-MON-RR'),'1394',null,'25');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6814','ESPOSITO LUCA','ENGINEER','5592',to_date('09-JUN-81','DD-MON-RR'),'1662',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6815','ECO LUDOVICO','SECRETARY','471',to_date('09-JUN-81','DD-MON-RR'),'1408',null,'160');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6816','ESPOSITO SILVIA','HEADMASTER','790',to_date('09-JUN-81','DD-MON-RR'),'1871',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6817','PETRARCA ROBERTA','MANAGER','4006',to_date('09-JUN-81','DD-MON-RR'),'485',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6818','DANTE LUIGI','HEADMASTER','2236',to_date('09-JUN-81','DD-MON-RR'),'1493',null,'54');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6819','DANTE ANGELO','SUPERVISOR','606',to_date('09-JUN-81','DD-MON-RR'),'1961',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6820','CORONA DAMIANO','PROFESSOR','2583',to_date('09-JUN-81','DD-MON-RR'),'230',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6821','SANTE FEDERICO','TECHNICIAN','1598',to_date('09-JUN-81','DD-MON-RR'),'1433',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6822','GRIMALDI LUCA','LAWYER','966',to_date('09-JUN-81','DD-MON-RR'),'66',null,'79');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6823','DANTE ANGELO','TECHNICIAN','3996',to_date('09-JUN-81','DD-MON-RR'),'1812',null,'280');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6824','FUMAROLA UGO','PHDSTUDENT','77',to_date('09-JUN-81','DD-MON-RR'),'746',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6825','LEOPARDI FEDERICO','PROFESSOR','5810',to_date('09-JUN-81','DD-MON-RR'),'1236',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6826','LEVI PAOLO','TECHNICIAN','3429',to_date('09-JUN-81','DD-MON-RR'),'1106',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6827','ECO UGO','SECRETARY','4160',to_date('09-JUN-81','DD-MON-RR'),'424',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6828','LEVI LUIGI','PHDSTUDENT','3980',to_date('09-JUN-81','DD-MON-RR'),'1943',null,'71');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6829','LEVI IVANO','LAWYER','5902',to_date('09-JUN-81','DD-MON-RR'),'1356',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6830','CALVINO MARIO','PHDSTUDENT','2135',to_date('09-JUN-81','DD-MON-RR'),'1376',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6831','CALVINO FEDERICO','SUPERVISOR','4355',to_date('09-JUN-81','DD-MON-RR'),'878',null,'265');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6832','GRIMALDI PAOLO','PHDSTUDENT','3017',to_date('09-JUN-81','DD-MON-RR'),'1481',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6833','LEOPARDI ELIO','PROFESSOR','2293',to_date('09-JUN-81','DD-MON-RR'),'185',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6834','GRIMALDI ELENA','PHDSTUDENT','6183',to_date('09-JUN-81','DD-MON-RR'),'202',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6835','BIANCHI LUIGI','MANAGER','5089',to_date('09-JUN-81','DD-MON-RR'),'1958',null,'20');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6836','DANTE LUCIA','MANAGER','2593',to_date('09-JUN-81','DD-MON-RR'),'1583',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6837','CALVINO FEDERICO','LAWYER','3487',to_date('09-JUN-81','DD-MON-RR'),'100',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6838','COZZA PAOLO','SECRETARY','3569',to_date('09-JUN-81','DD-MON-RR'),'971',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6839','CALVINO ANTONIO','HEADMASTER','3625',to_date('09-JUN-81','DD-MON-RR'),'1736',null,'114');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6840','GRIMALDI IVANO','PROFESSOR','2723',to_date('09-JUN-81','DD-MON-RR'),'636',null,'437');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6841','ECO LUCA','LAWYER','2851',to_date('09-JUN-81','DD-MON-RR'),'200',null,'410');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6842','MANZONI UGO','PROFESSOR','2612',to_date('09-JUN-81','DD-MON-RR'),'1039',null,'240');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6843','ECO ELIO','SUPERVISOR','3216',to_date('09-JUN-81','DD-MON-RR'),'729',null,'58');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6844','FO FRANCESCO','HEADMASTER','3357',to_date('09-JUN-81','DD-MON-RR'),'1175',null,'474');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6845','GRIMALDI UGO','SUPERVISOR','4218',to_date('09-JUN-81','DD-MON-RR'),'63',null,'419');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6846','ECO ALFONSO','ENGINEER','3569',to_date('09-JUN-81','DD-MON-RR'),'1775',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6847','NERI PAOLO','PHDSTUDENT','5292',to_date('09-JUN-81','DD-MON-RR'),'206',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6848','ECO GIOVANNI','LAWYER','6054',to_date('09-JUN-81','DD-MON-RR'),'488',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6849','FO ANGELO','TECHNICIAN','548',to_date('09-JUN-81','DD-MON-RR'),'193',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6850','LEOPARDI ANGELO','TECHNICIAN','3767',to_date('09-JUN-81','DD-MON-RR'),'865',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6851','SANTE LUCA','MANAGER','6507',to_date('09-JUN-81','DD-MON-RR'),'892',null,'32');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6318','SANTE LUIGI','MANAGER','3945',to_date('09-JUN-81','DD-MON-RR'),'472',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6319','FO MARIA','PROFESSOR','2874',to_date('09-JUN-81','DD-MON-RR'),'418',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6320','DANTE ANDREA','MANAGER','3250',to_date('09-JUN-81','DD-MON-RR'),'440',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6321','GRIMALDI MARIA','PROFESSOR','3567',to_date('09-JUN-81','DD-MON-RR'),'760',null,'461');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6322','FUMAROLA ELENA','LAWYER','1838',to_date('09-JUN-81','DD-MON-RR'),'949',null,'405');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6323','CALVINO ROBERTA','PHDSTUDENT','53',to_date('09-JUN-81','DD-MON-RR'),'465',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6324','FUMAROLA DONATO','ENGINEER','3133',to_date('09-JUN-81','DD-MON-RR'),'1787',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6325','ECO CLARA','MANAGER','5270',to_date('09-JUN-81','DD-MON-RR'),'585',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6326','CALVINO MARIO','SUPERVISOR','2619',to_date('09-JUN-81','DD-MON-RR'),'1711',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6327','TIBALDI LUDOVICO','LAWYER','1069',to_date('09-JUN-81','DD-MON-RR'),'7',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6328','DANTE LUCA','SUPERVISOR','1627',to_date('09-JUN-81','DD-MON-RR'),'1372',null,'430');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6329','TIBALDI ROBERTA','SECRETARY','4507',to_date('09-JUN-81','DD-MON-RR'),'1070',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6330','FUMAROLA UMBERTO','MANAGER','3502',to_date('09-JUN-81','DD-MON-RR'),'1208',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6331','CORONA ANDREA','PHDSTUDENT','2036',to_date('09-JUN-81','DD-MON-RR'),'516',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6332','CORONA ALFONSO','PHDSTUDENT','663',to_date('09-JUN-81','DD-MON-RR'),'1528',null,'63');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6333','SANTE ELENA','SECRETARY','4757',to_date('09-JUN-81','DD-MON-RR'),'3',null,'245');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6334','GRIMALDI LUDOVICO','MANAGER','5766',to_date('09-JUN-81','DD-MON-RR'),'968',null,'32');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6335','GRIMALDI PASQUALE','PROFESSOR','467',to_date('09-JUN-81','DD-MON-RR'),'1802',null,'220');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6336','BIANCHI IVANO','PROFESSOR','5652',to_date('09-JUN-81','DD-MON-RR'),'1372',null,'271');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6337','GRIMALDI DAMIANO','SECRETARY','2694',to_date('09-JUN-81','DD-MON-RR'),'702',null,'451');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6338','ESPOSITO GIOVANNI','TECHNICIAN','2254',to_date('09-JUN-81','DD-MON-RR'),'453',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6339','GRIMALDI UMBERTO','ENGINEER','2382',to_date('09-JUN-81','DD-MON-RR'),'1496',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6340','ECO SILVIA','SECRETARY','1761',to_date('09-JUN-81','DD-MON-RR'),'1849',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6341','SANTE GIOVANNI','HEADMASTER','23',to_date('09-JUN-81','DD-MON-RR'),'308',null,'102');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6342','CALVINO PASQUALE','PROFESSOR','4345',to_date('09-JUN-81','DD-MON-RR'),'1763',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6343','NERI COSIMO','TECHNICIAN','1487',to_date('09-JUN-81','DD-MON-RR'),'1578',null,'252');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6344','FUMAROLA ANGELO','ENGINEER','1927',to_date('09-JUN-81','DD-MON-RR'),'22',null,'45');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6345','LEOPARDI ROBERTA','MANAGER','2923',to_date('09-JUN-81','DD-MON-RR'),'1460',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6346','PETRARCA UGO','SUPERVISOR','842',to_date('09-JUN-81','DD-MON-RR'),'904',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6347','NERI UGO','ENGINEER','5001',to_date('09-JUN-81','DD-MON-RR'),'1368',null,'310');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6348','CARBONE LUCA','TECHNICIAN','5511',to_date('09-JUN-81','DD-MON-RR'),'1013',null,'421');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6349','BIANCHI DAMIANO','PROFESSOR','4537',to_date('09-JUN-81','DD-MON-RR'),'1387',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6350','CORONA ALFONSO','SUPERVISOR','4741',to_date('09-JUN-81','DD-MON-RR'),'725',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6351','COZZA SILVIA','PROFESSOR','4711',to_date('09-JUN-81','DD-MON-RR'),'219',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6352','FO LUIGI','HEADMASTER','4853',to_date('09-JUN-81','DD-MON-RR'),'469',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6353','ECO FEDERICO','LAWYER','2795',to_date('09-JUN-81','DD-MON-RR'),'1387',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6354','CARBONE SILVIA','HEADMASTER','4846',to_date('09-JUN-81','DD-MON-RR'),'1561',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6355','ESPOSITO ANTONIO','SECRETARY','1239',to_date('09-JUN-81','DD-MON-RR'),'665',null,'191');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6356','DANTE DONATO','PROFESSOR','6283',to_date('09-JUN-81','DD-MON-RR'),'1375',null,'235');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6357','ESPOSITO UMBERTO','TECHNICIAN','858',to_date('09-JUN-81','DD-MON-RR'),'952',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6358','LEOPARDI SILVIA','TECHNICIAN','5858',to_date('09-JUN-81','DD-MON-RR'),'603',null,'335');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6359','SANTE ANDREA','SECRETARY','2433',to_date('09-JUN-81','DD-MON-RR'),'696',null,'258');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6360','CORONA ALFONSO','SUPERVISOR','3325',to_date('09-JUN-81','DD-MON-RR'),'1592',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6361','DANTE ANDREA','SECRETARY','1696',to_date('09-JUN-81','DD-MON-RR'),'1304',null,'34');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6362','CARBONE CLARA','MANAGER','4160',to_date('09-JUN-81','DD-MON-RR'),'698',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6363','BIANCHI FRANCESCO','MANAGER','4980',to_date('09-JUN-81','DD-MON-RR'),'1325',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6364','TIBALDI LUCIA','TECHNICIAN','1210',to_date('09-JUN-81','DD-MON-RR'),'5',null,'177');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6365','PETRARCA DONATO','TECHNICIAN','5164',to_date('09-JUN-81','DD-MON-RR'),'55',null,'376');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6366','ECO MARIA','HEADMASTER','4007',to_date('09-JUN-81','DD-MON-RR'),'401',null,'34');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6367','SANTE ALFONSO','SECRETARY','3060',to_date('09-JUN-81','DD-MON-RR'),'1183',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('70','LEVI MARIO','TECHNICIAN','51',to_date('09-JUN-81','DD-MON-RR'),'1009',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('71','CALVINO ANDREA','PROFESSOR','51',to_date('09-JUN-81','DD-MON-RR'),'1095',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('72','FUMAROLA LUDOVICO','SECRETARY','0',to_date('09-JUN-81','DD-MON-RR'),'1501',null,'108');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('73','NERI ELENA','MANAGER','31',to_date('09-JUN-81','DD-MON-RR'),'521',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('74','SANTE ANDREA','MANAGER','3',to_date('09-JUN-81','DD-MON-RR'),'1663',null,'28');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('75','ESPOSITO ANDREA','SUPERVISOR','56',to_date('09-JUN-81','DD-MON-RR'),'1668',null,'181');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('76','ECO MASSIMO','PHDSTUDENT','15',to_date('09-JUN-81','DD-MON-RR'),'235',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('77','NERI GIOVANNI','MANAGER','38',to_date('09-JUN-81','DD-MON-RR'),'548',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('78','NERI MASSIMO','SUPERVISOR','38',to_date('09-JUN-81','DD-MON-RR'),'1247',null,'38');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('79','TIBALDI GAETANO','ENGINEER','40',to_date('09-JUN-81','DD-MON-RR'),'671',null,'120');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('80','MANZONI CLARA','HEADMASTER','33',to_date('09-JUN-81','DD-MON-RR'),'680',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('81','NERI DAMIANO','SUPERVISOR','65',to_date('09-JUN-81','DD-MON-RR'),'1192',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('82','ECO COSIMO','MANAGER','43',to_date('09-JUN-81','DD-MON-RR'),'822',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('83','LEOPARDI ANGELO','MANAGER','20',to_date('09-JUN-81','DD-MON-RR'),'1263',null,'24');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('84','CARBONE DONATO','TECHNICIAN','61',to_date('09-JUN-81','DD-MON-RR'),'456',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('85','BIANCHI GIOVANNI','MANAGER','27',to_date('09-JUN-81','DD-MON-RR'),'438',null,'304');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('86','LEOPARDI ROBERTA','MANAGER','5',to_date('09-JUN-81','DD-MON-RR'),'1631',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('87','NERI DONATO','ENGINEER','61',to_date('09-JUN-81','DD-MON-RR'),'1456',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('88','CARBONE CLARA','MANAGER','31',to_date('09-JUN-81','DD-MON-RR'),'808',null,'337');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('89','MANZONI ANTONIO','HEADMASTER','67',to_date('09-JUN-81','DD-MON-RR'),'922',null,'310');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('90','PETRARCA DAMIANO','ENGINEER','63',to_date('09-JUN-81','DD-MON-RR'),'1511',null,'317');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('91','COZZA ANDREA','LAWYER','27',to_date('09-JUN-81','DD-MON-RR'),'630',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('92','CARBONE FRANCESCO','SUPERVISOR','36',to_date('09-JUN-81','DD-MON-RR'),'1538',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('93','LEOPARDI COSIMO','SECRETARY','32',to_date('09-JUN-81','DD-MON-RR'),'131',null,'472');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('94','TIBALDI DAMIANO','HEADMASTER','38',to_date('09-JUN-81','DD-MON-RR'),'462',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('95','DANTE ROBERTA','ENGINEER','42',to_date('09-JUN-81','DD-MON-RR'),'731',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('96','LEVI SILVIA','LAWYER','69',to_date('09-JUN-81','DD-MON-RR'),'1965',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('97','SANTE GIOVANNI','MANAGER','80',to_date('09-JUN-81','DD-MON-RR'),'551',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('98','CORONA ANTONIO','PHDSTUDENT','74',to_date('09-JUN-81','DD-MON-RR'),'1858',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('99','CARBONE LUIGI','SECRETARY','36',to_date('09-JUN-81','DD-MON-RR'),'732',null,'101');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('100','SANTE MARIO','ENGINEER','7',to_date('09-JUN-81','DD-MON-RR'),'1704',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('101','TIBALDI CLARA','PROFESSOR','99',to_date('09-JUN-81','DD-MON-RR'),'1325',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('102','FO LUCIA','LAWYER','84',to_date('09-JUN-81','DD-MON-RR'),'1357',null,'24');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('103','MANZONI CLARA','PHDSTUDENT','101',to_date('09-JUN-81','DD-MON-RR'),'1304',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('104','GRIMALDI DONATO','LAWYER','47',to_date('09-JUN-81','DD-MON-RR'),'1452',null,'438');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('105','TIBALDI MARIO','PROFESSOR','55',to_date('09-JUN-81','DD-MON-RR'),'621',null,'65');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('106','ESPOSITO SILVIA','PHDSTUDENT','71',to_date('09-JUN-81','DD-MON-RR'),'1391',null,'365');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('107','LEOPARDI FEDERICO','TECHNICIAN','36',to_date('09-JUN-81','DD-MON-RR'),'802',null,'126');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('108','BIANCHI MARIO','TECHNICIAN','1',to_date('09-JUN-81','DD-MON-RR'),'1893',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('109','MANZONI UMBERTO','SECRETARY','9',to_date('09-JUN-81','DD-MON-RR'),'1774',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('110','ECO PAOLO','SUPERVISOR','26',to_date('09-JUN-81','DD-MON-RR'),'151',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('111','LEOPARDI ALFONSO','PROFESSOR','48',to_date('09-JUN-81','DD-MON-RR'),'1017',null,'417');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('112','CARBONE ANTONIO','LAWYER','83',to_date('09-JUN-81','DD-MON-RR'),'820',null,'402');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('113','FUMAROLA FEDERICO','PHDSTUDENT','16',to_date('09-JUN-81','DD-MON-RR'),'1621',null,'355');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('114','PETRARCA ANDREA','MANAGER','11',to_date('09-JUN-81','DD-MON-RR'),'937',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('115','COZZA DONATO','LAWYER','11',to_date('09-JUN-81','DD-MON-RR'),'1338',null,'325');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('116','LEOPARDI ANTONIO','SUPERVISOR','76',to_date('09-JUN-81','DD-MON-RR'),'955',null,'498');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('117','FO MASSIMO','PROFESSOR','105',to_date('09-JUN-81','DD-MON-RR'),'782',null,'240');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('118','ECO MARIO','SUPERVISOR','55',to_date('09-JUN-81','DD-MON-RR'),'1071',null,'43');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('119','ECO FEDERICO','LAWYER','38',to_date('09-JUN-81','DD-MON-RR'),'1169',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('120','MANZONI ANGELO','ENGINEER','110',to_date('09-JUN-81','DD-MON-RR'),'1325',null,'19');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('121','CORONA LUDOVICO','ENGINEER','7',to_date('09-JUN-81','DD-MON-RR'),'1685',null,'278');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('122','PETRARCA ANTONIO','SUPERVISOR','16',to_date('09-JUN-81','DD-MON-RR'),'469',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('123','MANZONI PASQUALE','LAWYER','109',to_date('09-JUN-81','DD-MON-RR'),'811',null,'259');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('124','PETRARCA PAOLO','PROFESSOR','55',to_date('09-JUN-81','DD-MON-RR'),'1807',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('125','ESPOSITO ELIO','LAWYER','94',to_date('09-JUN-81','DD-MON-RR'),'350',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('126','TIBALDI IVANO','SECRETARY','110',to_date('09-JUN-81','DD-MON-RR'),'1626',null,'421');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('127','FO DAMIANO','MANAGER','80',to_date('09-JUN-81','DD-MON-RR'),'10',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('128','CARBONE PAOLO','ENGINEER','27',to_date('09-JUN-81','DD-MON-RR'),'1009',null,'378');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('129','CORONA PAOLO','MANAGER','94',to_date('09-JUN-81','DD-MON-RR'),'1848',null,'122');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('130','ECO GIOVANNI','HEADMASTER','61',to_date('09-JUN-81','DD-MON-RR'),'129',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('131','CALVINO SILVIA','LAWYER','38',to_date('09-JUN-81','DD-MON-RR'),'1467',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('132','FUMAROLA MASSIMO','MANAGER','41',to_date('09-JUN-81','DD-MON-RR'),'1598',null,'57');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('133','LEVI DAMIANO','MANAGER','10',to_date('09-JUN-81','DD-MON-RR'),'483',null,'118');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('134','BIANCHI DONATO','HEADMASTER','23',to_date('09-JUN-81','DD-MON-RR'),'1419',null,'319');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('135','ESPOSITO CLARA','LAWYER','123',to_date('09-JUN-81','DD-MON-RR'),'1015',null,'6');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('136','NERI ANDREA','SECRETARY','1',to_date('09-JUN-81','DD-MON-RR'),'184',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('137','CALVINO CLARA','SECRETARY','48',to_date('09-JUN-81','DD-MON-RR'),'1078',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('138','GRIMALDI UMBERTO','SECRETARY','28',to_date('09-JUN-81','DD-MON-RR'),'684',null,'420');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('139','TIBALDI LUCIA','SUPERVISOR','21',to_date('09-JUN-81','DD-MON-RR'),'706',null,'262');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('140','ESPOSITO LUCA','SUPERVISOR','103',to_date('09-JUN-81','DD-MON-RR'),'1386',null,'32');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('141','LEOPARDI ANDREA','SUPERVISOR','88',to_date('09-JUN-81','DD-MON-RR'),'592',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('142','LEVI FEDERICO','ENGINEER','1',to_date('09-JUN-81','DD-MON-RR'),'1802',null,'362');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('143','SANTE IVANO','MANAGER','25',to_date('09-JUN-81','DD-MON-RR'),'1152',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('144','DANTE FEDERICO','ENGINEER','120',to_date('09-JUN-81','DD-MON-RR'),'339',null,'430');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('145','FUMAROLA UMBERTO','MANAGER','133',to_date('09-JUN-81','DD-MON-RR'),'1411',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('146','NERI MARIA','SUPERVISOR','124',to_date('09-JUN-81','DD-MON-RR'),'181',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('147','GRIMALDI DAMIANO','MANAGER','146',to_date('09-JUN-81','DD-MON-RR'),'672',null,'177');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('148','BIANCHI UMBERTO','ENGINEER','105',to_date('09-JUN-81','DD-MON-RR'),'194',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('149','CALVINO FEDERICO','SUPERVISOR','81',to_date('09-JUN-81','DD-MON-RR'),'1914',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('150','MANZONI GIOVANNI','TECHNICIAN','7',to_date('09-JUN-81','DD-MON-RR'),'486',null,'79');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('151','ECO IVANO','PROFESSOR','149',to_date('09-JUN-81','DD-MON-RR'),'166',null,'355');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('152','SANTE UMBERTO','TECHNICIAN','53',to_date('09-JUN-81','DD-MON-RR'),'1781',null,'187');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('153','ECO UGO','PROFESSOR','67',to_date('09-JUN-81','DD-MON-RR'),'641',null,'194');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('154','COZZA ANDREA','ENGINEER','9',to_date('09-JUN-81','DD-MON-RR'),'1822',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('155','FUMAROLA MASSIMO','PROFESSOR','0',to_date('09-JUN-81','DD-MON-RR'),'741',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('156','COZZA SILVIA','LAWYER','122',to_date('09-JUN-81','DD-MON-RR'),'1479',null,'171');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('157','LEOPARDI ELENA','TECHNICIAN','83',to_date('09-JUN-81','DD-MON-RR'),'1991',null,'64');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('158','LEOPARDI ANTONIO','MANAGER','31',to_date('09-JUN-81','DD-MON-RR'),'288',null,'30');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('159','NERI SILVIA','TECHNICIAN','14',to_date('09-JUN-81','DD-MON-RR'),'1896',null,'166');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('160','ECO PASQUALE','TECHNICIAN','55',to_date('09-JUN-81','DD-MON-RR'),'1008',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('161','LEVI LUCIA','SUPERVISOR','102',to_date('09-JUN-81','DD-MON-RR'),'901',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('162','ECO UGO','SECRETARY','34',to_date('09-JUN-81','DD-MON-RR'),'954',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('163','CARBONE GIOVANNI','MANAGER','13',to_date('09-JUN-81','DD-MON-RR'),'1164',null,'0');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('164','ECO ANGELO','SECRETARY','92',to_date('09-JUN-81','DD-MON-RR'),'524',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('165','CALVINO MARIA','PHDSTUDENT','91',to_date('09-JUN-81','DD-MON-RR'),'331',null,'420');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('166','LEOPARDI ANDREA','PROFESSOR','59',to_date('09-JUN-81','DD-MON-RR'),'347',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('167','TIBALDI FEDERICO','SECRETARY','4',to_date('09-JUN-81','DD-MON-RR'),'728',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('168','SANTE LUCIA','SUPERVISOR','5',to_date('09-JUN-81','DD-MON-RR'),'1577',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('169','FUMAROLA UMBERTO','HEADMASTER','156',to_date('09-JUN-81','DD-MON-RR'),'991',null,'389');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('170','CORONA FEDERICO','LAWYER','16',to_date('09-JUN-81','DD-MON-RR'),'1898',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('171','FO LUDOVICO','LAWYER','75',to_date('09-JUN-81','DD-MON-RR'),'1775',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('172','CORONA GAETANO','MANAGER','52',to_date('09-JUN-81','DD-MON-RR'),'1572',null,'496');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('173','LEVI LUIGI','MANAGER','78',to_date('09-JUN-81','DD-MON-RR'),'1999',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('174','GRIMALDI ROBERTA','ENGINEER','54',to_date('09-JUN-81','DD-MON-RR'),'1920',null,'458');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('175','LEOPARDI GIOVANNI','MANAGER','121',to_date('09-JUN-81','DD-MON-RR'),'1634',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('176','CORONA ELIO','MANAGER','134',to_date('09-JUN-81','DD-MON-RR'),'395',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('177','FO DONATO','PHDSTUDENT','154',to_date('09-JUN-81','DD-MON-RR'),'1812',null,'111');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('178','NERI LUCA','HEADMASTER','100',to_date('09-JUN-81','DD-MON-RR'),'88',null,'93');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('179','SANTE COSIMO','PHDSTUDENT','84',to_date('09-JUN-81','DD-MON-RR'),'316',null,'91');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('180','DANTE GAETANO','MANAGER','126',to_date('09-JUN-81','DD-MON-RR'),'1885',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('181','FO LUIGI','PROFESSOR','135',to_date('09-JUN-81','DD-MON-RR'),'322',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('182','PETRARCA FEDERICO','LAWYER','157',to_date('09-JUN-81','DD-MON-RR'),'545',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('183','DANTE LUDOVICO','PROFESSOR','50',to_date('09-JUN-81','DD-MON-RR'),'1403',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('184','PETRARCA GAETANO','TECHNICIAN','125',to_date('09-JUN-81','DD-MON-RR'),'461',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('185','CALVINO LUIGI','LAWYER','142',to_date('09-JUN-81','DD-MON-RR'),'644',null,'6');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('186','CALVINO SILVIA','SUPERVISOR','179',to_date('09-JUN-81','DD-MON-RR'),'65',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('187','GRIMALDI LUCA','MANAGER','170',to_date('09-JUN-81','DD-MON-RR'),'650',null,'123');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('188','SANTE ANTONIO','HEADMASTER','162',to_date('09-JUN-81','DD-MON-RR'),'1374',null,'43');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('189','FUMAROLA GAETANO','PHDSTUDENT','64',to_date('09-JUN-81','DD-MON-RR'),'1665',null,'36');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('190','LEVI IVANO','MANAGER','44',to_date('09-JUN-81','DD-MON-RR'),'942',null,'8');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('191','CARBONE PAOLO','PROFESSOR','125',to_date('09-JUN-81','DD-MON-RR'),'1861',null,'166');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('192','COZZA UMBERTO','MANAGER','39',to_date('09-JUN-81','DD-MON-RR'),'969',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('193','COZZA MASSIMO','SECRETARY','161',to_date('09-JUN-81','DD-MON-RR'),'888',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('194','MANZONI LUCA','HEADMASTER','148',to_date('09-JUN-81','DD-MON-RR'),'942',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('195','CARBONE ANDREA','ENGINEER','104',to_date('09-JUN-81','DD-MON-RR'),'1730',null,'185');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('196','MANZONI IVANO','SECRETARY','166',to_date('09-JUN-81','DD-MON-RR'),'1529',null,'132');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('197','CALVINO DONATO','MANAGER','192',to_date('09-JUN-81','DD-MON-RR'),'394',null,'160');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('198','ECO LUIGI','MANAGER','124',to_date('09-JUN-81','DD-MON-RR'),'972',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('199','COZZA ELENA','PROFESSOR','42',to_date('09-JUN-81','DD-MON-RR'),'352',null,'471');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('200','FO COSIMO','MANAGER','62',to_date('09-JUN-81','DD-MON-RR'),'1102',null,'221');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('201','BIANCHI DAMIANO','SECRETARY','4',to_date('09-JUN-81','DD-MON-RR'),'1908',null,'158');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('202','COZZA GIOVANNI','MANAGER','25',to_date('09-JUN-81','DD-MON-RR'),'229',null,'253');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('203','FUMAROLA ELENA','MANAGER','70',to_date('09-JUN-81','DD-MON-RR'),'1674',null,'321');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('204','DANTE GAETANO','HEADMASTER','33',to_date('09-JUN-81','DD-MON-RR'),'1793',null,'114');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('205','ESPOSITO ELIO','TECHNICIAN','140',to_date('09-JUN-81','DD-MON-RR'),'1250',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('808','NERI ALFONSO','HEADMASTER','732',to_date('09-JUN-81','DD-MON-RR'),'1919',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('809','COZZA LUCA','ENGINEER','497',to_date('09-JUN-81','DD-MON-RR'),'51',null,'3');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2242','GRIMALDI ANDREA','ENGINEER','1330',to_date('09-JUN-81','DD-MON-RR'),'899',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2243','COZZA COSIMO','PROFESSOR','672',to_date('09-JUN-81','DD-MON-RR'),'1108',null,'484');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2244','SANTE MASSIMO','PROFESSOR','2189',to_date('09-JUN-81','DD-MON-RR'),'997',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2245','SANTE MASSIMO','PHDSTUDENT','2209',to_date('09-JUN-81','DD-MON-RR'),'1342',null,'309');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2246','GRIMALDI ROBERTA','HEADMASTER','320',to_date('09-JUN-81','DD-MON-RR'),'1075',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2247','FO FRANCESCO','ENGINEER','1618',to_date('09-JUN-81','DD-MON-RR'),'266',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2248','GRIMALDI DONATO','PROFESSOR','1208',to_date('09-JUN-81','DD-MON-RR'),'1627',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2249','DANTE PASQUALE','PHDSTUDENT','331',to_date('09-JUN-81','DD-MON-RR'),'1489',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2250','LEOPARDI ANGELO','SECRETARY','566',to_date('09-JUN-81','DD-MON-RR'),'1715',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2251','CARBONE ELENA','SECRETARY','1202',to_date('09-JUN-81','DD-MON-RR'),'1776',null,'12');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2252','TIBALDI FEDERICO','SUPERVISOR','2123',to_date('09-JUN-81','DD-MON-RR'),'1048',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2253','CORONA PAOLO','PROFESSOR','1144',to_date('09-JUN-81','DD-MON-RR'),'399',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2254','CORONA PAOLO','SUPERVISOR','1416',to_date('09-JUN-81','DD-MON-RR'),'1706',null,'269');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2255','FUMAROLA CLARA','PHDSTUDENT','2109',to_date('09-JUN-81','DD-MON-RR'),'1320',null,'135');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2256','PETRARCA ELENA','MANAGER','1686',to_date('09-JUN-81','DD-MON-RR'),'129',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2257','CORONA UGO','MANAGER','764',to_date('09-JUN-81','DD-MON-RR'),'494',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2258','DANTE MARIO','PROFESSOR','563',to_date('09-JUN-81','DD-MON-RR'),'1704',null,'47');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2259','LEOPARDI ELENA','HEADMASTER','160',to_date('09-JUN-81','DD-MON-RR'),'1907',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2260','ECO COSIMO','SUPERVISOR','56',to_date('09-JUN-81','DD-MON-RR'),'344',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2261','PETRARCA LUCA','MANAGER','707',to_date('09-JUN-81','DD-MON-RR'),'358',null,'159');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2262','LEVI ANGELO','MANAGER','2096',to_date('09-JUN-81','DD-MON-RR'),'581',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2263','CARBONE ROBERTA','SUPERVISOR','126',to_date('09-JUN-81','DD-MON-RR'),'1155',null,'33');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2264','SANTE IVANO','SECRETARY','2156',to_date('09-JUN-81','DD-MON-RR'),'1850',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2265','LEOPARDI ANTONIO','SUPERVISOR','1519',to_date('09-JUN-81','DD-MON-RR'),'1122',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2266','CALVINO ELENA','PROFESSOR','1471',to_date('09-JUN-81','DD-MON-RR'),'341',null,'183');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2267','LEVI LUCA','ENGINEER','1343',to_date('09-JUN-81','DD-MON-RR'),'630',null,'304');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2268','SANTE MARIA','ENGINEER','1541',to_date('09-JUN-81','DD-MON-RR'),'1063',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2269','PETRARCA LUIGI','MANAGER','317',to_date('09-JUN-81','DD-MON-RR'),'1271',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2270','CORONA ALFONSO','MANAGER','159',to_date('09-JUN-81','DD-MON-RR'),'1827',null,'196');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2271','ECO GIOVANNI','LAWYER','31',to_date('09-JUN-81','DD-MON-RR'),'1914',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2272','MANZONI LUIGI','MANAGER','1587',to_date('09-JUN-81','DD-MON-RR'),'1037',null,'62');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2273','CALVINO DAMIANO','SECRETARY','559',to_date('09-JUN-81','DD-MON-RR'),'1324',null,'65');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2274','TIBALDI GIOVANNI','LAWYER','298',to_date('09-JUN-81','DD-MON-RR'),'1098',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2275','ECO COSIMO','SUPERVISOR','584',to_date('09-JUN-81','DD-MON-RR'),'213',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2276','BIANCHI GIOVANNI','SECRETARY','2046',to_date('09-JUN-81','DD-MON-RR'),'1893',null,'436');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2277','PETRARCA UGO','PHDSTUDENT','293',to_date('09-JUN-81','DD-MON-RR'),'51',null,'158');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2278','SANTE GIOVANNI','PROFESSOR','1944',to_date('09-JUN-81','DD-MON-RR'),'1160',null,'481');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2279','GRIMALDI DAMIANO','ENGINEER','1823',to_date('09-JUN-81','DD-MON-RR'),'946',null,'461');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2280','TIBALDI MARIA','TECHNICIAN','2153',to_date('09-JUN-81','DD-MON-RR'),'311',null,'32');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2281','PETRARCA LUCA','HEADMASTER','1066',to_date('09-JUN-81','DD-MON-RR'),'1408',null,'472');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2282','NERI GIOVANNI','PHDSTUDENT','318',to_date('09-JUN-81','DD-MON-RR'),'306',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2283','BIANCHI ELENA','PROFESSOR','1731',to_date('09-JUN-81','DD-MON-RR'),'520',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2284','CALVINO DONATO','SECRETARY','215',to_date('09-JUN-81','DD-MON-RR'),'91',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2285','ESPOSITO PAOLO','MANAGER','2228',to_date('09-JUN-81','DD-MON-RR'),'481',null,'40');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2286','PETRARCA COSIMO','LAWYER','86',to_date('09-JUN-81','DD-MON-RR'),'519',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2287','SANTE DAMIANO','MANAGER','581',to_date('09-JUN-81','DD-MON-RR'),'1479',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2288','DANTE PASQUALE','MANAGER','419',to_date('09-JUN-81','DD-MON-RR'),'1911',null,'217');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2289','CORONA ROBERTA','MANAGER','2173',to_date('09-JUN-81','DD-MON-RR'),'1543',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2290','MANZONI DONATO','SECRETARY','2068',to_date('09-JUN-81','DD-MON-RR'),'1527',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2291','LEVI UGO','PHDSTUDENT','1997',to_date('09-JUN-81','DD-MON-RR'),'1683',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2292','MANZONI PAOLO','MANAGER','180',to_date('09-JUN-81','DD-MON-RR'),'157',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2293','ECO MASSIMO','ENGINEER','51',to_date('09-JUN-81','DD-MON-RR'),'1627',null,'404');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2294','ESPOSITO MARIO','LAWYER','317',to_date('09-JUN-81','DD-MON-RR'),'316',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2295','DANTE FRANCESCO','HEADMASTER','2036',to_date('09-JUN-81','DD-MON-RR'),'76',null,'404');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2296','ECO FRANCESCO','ENGINEER','473',to_date('09-JUN-81','DD-MON-RR'),'1791',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2297','DANTE ANGELO','SUPERVISOR','1007',to_date('09-JUN-81','DD-MON-RR'),'874',null,'179');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2298','ECO LUCIA','ENGINEER','2177',to_date('09-JUN-81','DD-MON-RR'),'614',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2299','BIANCHI ANDREA','HEADMASTER','556',to_date('09-JUN-81','DD-MON-RR'),'1806',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2300','LEVI ANTONIO','PHDSTUDENT','1255',to_date('09-JUN-81','DD-MON-RR'),'1309',null,'171');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2301','DANTE LUCA','MANAGER','2231',to_date('09-JUN-81','DD-MON-RR'),'23',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2302','CORONA ALFONSO','SECRETARY','1624',to_date('09-JUN-81','DD-MON-RR'),'1945',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2303','TIBALDI PAOLO','HEADMASTER','124',to_date('09-JUN-81','DD-MON-RR'),'29',null,'325');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2304','GRIMALDI IVANO','SECRETARY','2001',to_date('09-JUN-81','DD-MON-RR'),'25',null,'159');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2305','ESPOSITO LUCA','MANAGER','793',to_date('09-JUN-81','DD-MON-RR'),'115',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2306','ESPOSITO FRANCESCO','LAWYER','128',to_date('09-JUN-81','DD-MON-RR'),'766',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2307','LEOPARDI CLARA','ENGINEER','2169',to_date('09-JUN-81','DD-MON-RR'),'1029',null,'33');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2308','BIANCHI GIOVANNI','MANAGER','793',to_date('09-JUN-81','DD-MON-RR'),'1267',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2309','DANTE FRANCESCO','TECHNICIAN','948',to_date('09-JUN-81','DD-MON-RR'),'717',null,'465');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2310','SANTE PASQUALE','SECRETARY','1885',to_date('09-JUN-81','DD-MON-RR'),'1483',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2311','MANZONI LUDOVICO','HEADMASTER','243',to_date('09-JUN-81','DD-MON-RR'),'970',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2312','CORONA ROBERTA','PROFESSOR','1752',to_date('09-JUN-81','DD-MON-RR'),'1489',null,'310');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2313','LEOPARDI FEDERICO','ENGINEER','2214',to_date('09-JUN-81','DD-MON-RR'),'176',null,'417');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2314','DANTE LUDOVICO','PHDSTUDENT','55',to_date('09-JUN-81','DD-MON-RR'),'987',null,'341');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2315','MANZONI GAETANO','MANAGER','921',to_date('09-JUN-81','DD-MON-RR'),'79',null,'411');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2316','BIANCHI UGO','MANAGER','1884',to_date('09-JUN-81','DD-MON-RR'),'1407',null,'369');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2317','FUMAROLA GIOVANNI','SECRETARY','505',to_date('09-JUN-81','DD-MON-RR'),'252',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2318','LEOPARDI ANGELO','SUPERVISOR','92',to_date('09-JUN-81','DD-MON-RR'),'1816',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2319','CALVINO ANDREA','PHDSTUDENT','460',to_date('09-JUN-81','DD-MON-RR'),'75',null,'348');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2320','BIANCHI ROBERTA','PROFESSOR','2234',to_date('09-JUN-81','DD-MON-RR'),'781',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2321','FUMAROLA MARIA','PROFESSOR','89',to_date('09-JUN-81','DD-MON-RR'),'206',null,'130');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2322','CARBONE ANDREA','LAWYER','739',to_date('09-JUN-81','DD-MON-RR'),'865',null,'378');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2323','NERI ANGELO','PROFESSOR','1479',to_date('09-JUN-81','DD-MON-RR'),'623',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2324','LEOPARDI DONATO','LAWYER','2229',to_date('09-JUN-81','DD-MON-RR'),'769',null,'333');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2325','CORONA LUCIA','MANAGER','1339',to_date('09-JUN-81','DD-MON-RR'),'459',null,'25');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2326','CALVINO ALFONSO','LAWYER','219',to_date('09-JUN-81','DD-MON-RR'),'107',null,'221');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2327','FO LUIGI','HEADMASTER','2295',to_date('09-JUN-81','DD-MON-RR'),'297',null,'45');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2328','CARBONE IVANO','ENGINEER','1048',to_date('09-JUN-81','DD-MON-RR'),'781',null,'337');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2329','CARBONE GAETANO','PHDSTUDENT','1620',to_date('09-JUN-81','DD-MON-RR'),'213',null,'122');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2330','GRIMALDI LUCA','SUPERVISOR','52',to_date('09-JUN-81','DD-MON-RR'),'677',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2331','PETRARCA SILVIA','PROFESSOR','963',to_date('09-JUN-81','DD-MON-RR'),'1938',null,'405');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2332','CORONA MASSIMO','PROFESSOR','1199',to_date('09-JUN-81','DD-MON-RR'),'624',null,'394');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2333','LEVI ELIO','HEADMASTER','2259',to_date('09-JUN-81','DD-MON-RR'),'1011',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2334','CALVINO FEDERICO','MANAGER','1176',to_date('09-JUN-81','DD-MON-RR'),'535',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2335','LEOPARDI LUCIA','ENGINEER','611',to_date('09-JUN-81','DD-MON-RR'),'1306',null,'145');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2798','GRIMALDI GIOVANNI','TECHNICIAN','623',to_date('09-JUN-81','DD-MON-RR'),'734',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2799','ESPOSITO ANGELO','TECHNICIAN','1973',to_date('09-JUN-81','DD-MON-RR'),'806',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2800','SANTE DONATO','SECRETARY','2530',to_date('09-JUN-81','DD-MON-RR'),'953',null,'209');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2801','COZZA UGO','SUPERVISOR','1191',to_date('09-JUN-81','DD-MON-RR'),'147',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2802','MANZONI PASQUALE','ENGINEER','2612',to_date('09-JUN-81','DD-MON-RR'),'1660',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2803','ESPOSITO LUIGI','SECRETARY','160',to_date('09-JUN-81','DD-MON-RR'),'546',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2804','ESPOSITO ANDREA','SUPERVISOR','913',to_date('09-JUN-81','DD-MON-RR'),'94',null,'407');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2805','DANTE ANGELO','LAWYER','510',to_date('09-JUN-81','DD-MON-RR'),'1855',null,'122');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2806','CARBONE ANGELO','LAWYER','432',to_date('09-JUN-81','DD-MON-RR'),'1918',null,'373');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2807','FO LUIGI','SECRETARY','1586',to_date('09-JUN-81','DD-MON-RR'),'577',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2808','SANTE FEDERICO','SUPERVISOR','90',to_date('09-JUN-81','DD-MON-RR'),'360',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2809','BIANCHI GAETANO','MANAGER','109',to_date('09-JUN-81','DD-MON-RR'),'1642',null,'465');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2810','ECO COSIMO','SECRETARY','1751',to_date('09-JUN-81','DD-MON-RR'),'1315',null,'441');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2811','CORONA IVANO','ENGINEER','1520',to_date('09-JUN-81','DD-MON-RR'),'827',null,'187');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2812','ESPOSITO SILVIA','MANAGER','1899',to_date('09-JUN-81','DD-MON-RR'),'1625',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2813','ECO PASQUALE','PHDSTUDENT','455',to_date('09-JUN-81','DD-MON-RR'),'1300',null,'162');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2814','GRIMALDI PASQUALE','MANAGER','1650',to_date('09-JUN-81','DD-MON-RR'),'631',null,'320');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2815','COZZA PAOLO','PROFESSOR','1327',to_date('09-JUN-81','DD-MON-RR'),'1587',null,'386');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2816','BIANCHI IVANO','SUPERVISOR','2170',to_date('09-JUN-81','DD-MON-RR'),'406',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2817','FUMAROLA COSIMO','SECRETARY','2475',to_date('09-JUN-81','DD-MON-RR'),'333',null,'253');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2818','SANTE MASSIMO','MANAGER','123',to_date('09-JUN-81','DD-MON-RR'),'443',null,'387');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2819','LEOPARDI ELENA','ENGINEER','527',to_date('09-JUN-81','DD-MON-RR'),'1023',null,'183');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2820','NERI GAETANO','MANAGER','2661',to_date('09-JUN-81','DD-MON-RR'),'1000',null,'166');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2821','CORONA IVANO','MANAGER','2118',to_date('09-JUN-81','DD-MON-RR'),'1250',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2822','FO ROBERTA','PHDSTUDENT','2518',to_date('09-JUN-81','DD-MON-RR'),'1301',null,'427');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2823','FUMAROLA ELIO','HEADMASTER','1482',to_date('09-JUN-81','DD-MON-RR'),'1188',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2824','LEOPARDI DAMIANO','MANAGER','995',to_date('09-JUN-81','DD-MON-RR'),'297',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2825','GRIMALDI COSIMO','SECRETARY','732',to_date('09-JUN-81','DD-MON-RR'),'1840',null,'51');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2826','FO GAETANO','ENGINEER','1657',to_date('09-JUN-81','DD-MON-RR'),'777',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2827','FO GAETANO','MANAGER','1337',to_date('09-JUN-81','DD-MON-RR'),'959',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2828','MANZONI PAOLO','LAWYER','690',to_date('09-JUN-81','DD-MON-RR'),'808',null,'74');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2829','CORONA CLARA','SECRETARY','1255',to_date('09-JUN-81','DD-MON-RR'),'114',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2830','CARBONE FRANCESCO','MANAGER','1754',to_date('09-JUN-81','DD-MON-RR'),'74',null,'78');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2831','SANTE ROBERTA','LAWYER','1923',to_date('09-JUN-81','DD-MON-RR'),'430',null,'91');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2832','LEVI PAOLO','SUPERVISOR','1743',to_date('09-JUN-81','DD-MON-RR'),'945',null,'124');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2833','CARBONE IVANO','MANAGER','497',to_date('09-JUN-81','DD-MON-RR'),'91',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2834','LEVI PAOLO','MANAGER','1234',to_date('09-JUN-81','DD-MON-RR'),'1742',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2835','BIANCHI MARIA','SUPERVISOR','2642',to_date('09-JUN-81','DD-MON-RR'),'1017',null,'55');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2836','ESPOSITO COSIMO','PROFESSOR','2504',to_date('09-JUN-81','DD-MON-RR'),'1821',null,'477');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2713','ECO MARIA','MANAGER','1709',to_date('09-JUN-81','DD-MON-RR'),'1149',null,'221');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2714','ESPOSITO UMBERTO','PROFESSOR','1315',to_date('09-JUN-81','DD-MON-RR'),'737',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2715','PETRARCA CLARA','HEADMASTER','2232',to_date('09-JUN-81','DD-MON-RR'),'942',null,'197');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4273','ECO ANGELO','SUPERVISOR','640',to_date('09-JUN-81','DD-MON-RR'),'1141',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4274','GRIMALDI CLARA','MANAGER','2841',to_date('09-JUN-81','DD-MON-RR'),'275',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4275','MANZONI GAETANO','MANAGER','418',to_date('09-JUN-81','DD-MON-RR'),'500',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4276','GRIMALDI GAETANO','HEADMASTER','4059',to_date('09-JUN-81','DD-MON-RR'),'697',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4277','ECO FEDERICO','MANAGER','1854',to_date('09-JUN-81','DD-MON-RR'),'904',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4278','GRIMALDI ELIO','MANAGER','1695',to_date('09-JUN-81','DD-MON-RR'),'1505',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4279','CORONA GIOVANNI','PHDSTUDENT','3828',to_date('09-JUN-81','DD-MON-RR'),'1382',null,'113');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4280','PETRARCA PAOLO','HEADMASTER','686',to_date('09-JUN-81','DD-MON-RR'),'73',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4281','LEOPARDI MARIA','MANAGER','2462',to_date('09-JUN-81','DD-MON-RR'),'1135',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4282','FO ELIO','ENGINEER','2931',to_date('09-JUN-81','DD-MON-RR'),'1794',null,'385');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4283','BIANCHI DONATO','TECHNICIAN','3970',to_date('09-JUN-81','DD-MON-RR'),'50',null,'63');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4284','FO LUCA','HEADMASTER','2170',to_date('09-JUN-81','DD-MON-RR'),'1332',null,'421');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4285','NERI DONATO','MANAGER','2026',to_date('09-JUN-81','DD-MON-RR'),'800',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4286','LEOPARDI LUDOVICO','SUPERVISOR','1584',to_date('09-JUN-81','DD-MON-RR'),'559',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4287','CALVINO UMBERTO','PHDSTUDENT','4049',to_date('09-JUN-81','DD-MON-RR'),'1183',null,'183');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4288','ESPOSITO ELIO','SUPERVISOR','380',to_date('09-JUN-81','DD-MON-RR'),'1053',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4289','MANZONI GAETANO','TECHNICIAN','1574',to_date('09-JUN-81','DD-MON-RR'),'900',null,'229');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4290','LEVI PASQUALE','HEADMASTER','4261',to_date('09-JUN-81','DD-MON-RR'),'1314',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4291','ESPOSITO UMBERTO','SUPERVISOR','1075',to_date('09-JUN-81','DD-MON-RR'),'977',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4292','LEVI ANGELO','ENGINEER','3111',to_date('09-JUN-81','DD-MON-RR'),'119',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4293','CORONA MASSIMO','LAWYER','368',to_date('09-JUN-81','DD-MON-RR'),'1727',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4294','DANTE GIOVANNI','ENGINEER','3854',to_date('09-JUN-81','DD-MON-RR'),'890',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4295','CORONA IVANO','PHDSTUDENT','231',to_date('09-JUN-81','DD-MON-RR'),'1299',null,'471');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4296','CARBONE DONATO','MANAGER','4101',to_date('09-JUN-81','DD-MON-RR'),'1426',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4297','NERI DONATO','HEADMASTER','111',to_date('09-JUN-81','DD-MON-RR'),'1388',null,'362');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4298','LEOPARDI MASSIMO','SECRETARY','3384',to_date('09-JUN-81','DD-MON-RR'),'1741',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4299','MANZONI GAETANO','ENGINEER','626',to_date('09-JUN-81','DD-MON-RR'),'1748',null,'443');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4300','COZZA GAETANO','TECHNICIAN','2291',to_date('09-JUN-81','DD-MON-RR'),'568',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4301','GRIMALDI LUIGI','SUPERVISOR','2316',to_date('09-JUN-81','DD-MON-RR'),'781',null,'184');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4302','SANTE MARIA','PHDSTUDENT','3251',to_date('09-JUN-81','DD-MON-RR'),'907',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4303','FUMAROLA ELENA','MANAGER','4226',to_date('09-JUN-81','DD-MON-RR'),'1696',null,'344');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4304','LEVI UMBERTO','PROFESSOR','3395',to_date('09-JUN-81','DD-MON-RR'),'977',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4305','FO UGO','PHDSTUDENT','950',to_date('09-JUN-81','DD-MON-RR'),'537',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4306','DANTE ELENA','MANAGER','305',to_date('09-JUN-81','DD-MON-RR'),'566',null,'441');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4307','LEOPARDI UMBERTO','PROFESSOR','3360',to_date('09-JUN-81','DD-MON-RR'),'257',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4308','BIANCHI ALFONSO','PROFESSOR','2727',to_date('09-JUN-81','DD-MON-RR'),'1185',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4309','COZZA MARIA','ENGINEER','4264',to_date('09-JUN-81','DD-MON-RR'),'1456',null,'252');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4310','CARBONE LUIGI','TECHNICIAN','1301',to_date('09-JUN-81','DD-MON-RR'),'1250',null,'254');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4311','CALVINO GIOVANNI','TECHNICIAN','3659',to_date('09-JUN-81','DD-MON-RR'),'221',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4312','CORONA DAMIANO','PROFESSOR','179',to_date('09-JUN-81','DD-MON-RR'),'663',null,'19');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4313','LEOPARDI PAOLO','PHDSTUDENT','2719',to_date('09-JUN-81','DD-MON-RR'),'1557',null,'120');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4314','FO SILVIA','PROFESSOR','1378',to_date('09-JUN-81','DD-MON-RR'),'183',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4315','DANTE DONATO','MANAGER','277',to_date('09-JUN-81','DD-MON-RR'),'1848',null,'469');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4316','BIANCHI FRANCESCO','TECHNICIAN','3567',to_date('09-JUN-81','DD-MON-RR'),'261',null,'45');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4317','NERI FRANCESCO','SECRETARY','1177',to_date('09-JUN-81','DD-MON-RR'),'1807',null,'486');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4318','FO ALFONSO','MANAGER','4145',to_date('09-JUN-81','DD-MON-RR'),'680',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4319','FUMAROLA UGO','MANAGER','1653',to_date('09-JUN-81','DD-MON-RR'),'1926',null,'46');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4320','BIANCHI LUCA','LAWYER','2617',to_date('09-JUN-81','DD-MON-RR'),'1703',null,'319');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4321','CARBONE ELIO','MANAGER','2266',to_date('09-JUN-81','DD-MON-RR'),'503',null,'25');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4322','DANTE ANDREA','MANAGER','1107',to_date('09-JUN-81','DD-MON-RR'),'1775',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4323','BIANCHI SILVIA','HEADMASTER','1509',to_date('09-JUN-81','DD-MON-RR'),'317',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4324','FUMAROLA UGO','MANAGER','1071',to_date('09-JUN-81','DD-MON-RR'),'1486',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4325','COZZA LUCA','HEADMASTER','234',to_date('09-JUN-81','DD-MON-RR'),'1282',null,'56');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4326','DANTE IVANO','SUPERVISOR','2656',to_date('09-JUN-81','DD-MON-RR'),'1421',null,'394');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4327','BIANCHI UGO','ENGINEER','2507',to_date('09-JUN-81','DD-MON-RR'),'1163',null,'146');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4328','LEVI DAMIANO','TECHNICIAN','4001',to_date('09-JUN-81','DD-MON-RR'),'320',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4795','GRIMALDI PAOLO','SECRETARY','295',to_date('09-JUN-81','DD-MON-RR'),'537',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4796','LEOPARDI GIOVANNI','ENGINEER','1074',to_date('09-JUN-81','DD-MON-RR'),'1132',null,'413');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4797','DANTE MARIO','HEADMASTER','2777',to_date('09-JUN-81','DD-MON-RR'),'477',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4798','PETRARCA COSIMO','PROFESSOR','4097',to_date('09-JUN-81','DD-MON-RR'),'120',null,'298');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4799','LEOPARDI GAETANO','TECHNICIAN','175',to_date('09-JUN-81','DD-MON-RR'),'220',null,'36');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4800','CALVINO ELIO','TECHNICIAN','1782',to_date('09-JUN-81','DD-MON-RR'),'1537',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4801','ESPOSITO LUCA','SECRETARY','3497',to_date('09-JUN-81','DD-MON-RR'),'155',null,'321');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4802','LEOPARDI ANGELO','MANAGER','1359',to_date('09-JUN-81','DD-MON-RR'),'159',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4803','ESPOSITO COSIMO','HEADMASTER','780',to_date('09-JUN-81','DD-MON-RR'),'1288',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4804','CALVINO SILVIA','MANAGER','635',to_date('09-JUN-81','DD-MON-RR'),'389',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4805','CARBONE UMBERTO','SUPERVISOR','1205',to_date('09-JUN-81','DD-MON-RR'),'434',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4806','FO MARIO','TECHNICIAN','3081',to_date('09-JUN-81','DD-MON-RR'),'489',null,'304');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4807','FUMAROLA DAMIANO','HEADMASTER','1036',to_date('09-JUN-81','DD-MON-RR'),'168',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4808','CALVINO ANTONIO','LAWYER','2596',to_date('09-JUN-81','DD-MON-RR'),'289',null,'312');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4809','MANZONI LUDOVICO','MANAGER','4063',to_date('09-JUN-81','DD-MON-RR'),'74',null,'488');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4810','CALVINO PASQUALE','ENGINEER','4593',to_date('09-JUN-81','DD-MON-RR'),'986',null,'20');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4811','NERI LUCIA','PROFESSOR','789',to_date('09-JUN-81','DD-MON-RR'),'1399',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4812','COZZA SILVIA','ENGINEER','4253',to_date('09-JUN-81','DD-MON-RR'),'396',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4813','CALVINO DAMIANO','MANAGER','262',to_date('09-JUN-81','DD-MON-RR'),'249',null,'407');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4814','ESPOSITO LUDOVICO','SECRETARY','2224',to_date('09-JUN-81','DD-MON-RR'),'1447',null,'378');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4815','CORONA COSIMO','MANAGER','1270',to_date('09-JUN-81','DD-MON-RR'),'1449',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4816','BIANCHI ANGELO','SECRETARY','4148',to_date('09-JUN-81','DD-MON-RR'),'1042',null,'125');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4817','ECO FRANCESCO','PHDSTUDENT','1282',to_date('09-JUN-81','DD-MON-RR'),'357',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4818','SANTE GIOVANNI','PHDSTUDENT','3003',to_date('09-JUN-81','DD-MON-RR'),'614',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4819','LEVI GAETANO','TECHNICIAN','760',to_date('09-JUN-81','DD-MON-RR'),'897',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4820','BIANCHI ANDREA','MANAGER','4405',to_date('09-JUN-81','DD-MON-RR'),'305',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4821','CARBONE MASSIMO','MANAGER','4615',to_date('09-JUN-81','DD-MON-RR'),'636',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4822','CORONA LUCA','PROFESSOR','2127',to_date('09-JUN-81','DD-MON-RR'),'495',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4823','SANTE LUCA','ENGINEER','4291',to_date('09-JUN-81','DD-MON-RR'),'1649',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4824','PETRARCA ELENA','ENGINEER','251',to_date('09-JUN-81','DD-MON-RR'),'841',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4825','MANZONI COSIMO','TECHNICIAN','1499',to_date('09-JUN-81','DD-MON-RR'),'499',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4826','ESPOSITO ANTONIO','HEADMASTER','710',to_date('09-JUN-81','DD-MON-RR'),'1226',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4827','PETRARCA MARIO','TECHNICIAN','3276',to_date('09-JUN-81','DD-MON-RR'),'525',null,'317');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4828','LEOPARDI FRANCESCO','MANAGER','560',to_date('09-JUN-81','DD-MON-RR'),'50',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4829','SANTE IVANO','SECRETARY','1968',to_date('09-JUN-81','DD-MON-RR'),'217',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4830','TIBALDI FEDERICO','SUPERVISOR','2280',to_date('09-JUN-81','DD-MON-RR'),'432',null,'464');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4831','COZZA ELENA','LAWYER','905',to_date('09-JUN-81','DD-MON-RR'),'1827',null,'99');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4832','ECO ELIO','TECHNICIAN','4727',to_date('09-JUN-81','DD-MON-RR'),'1716',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4833','PETRARCA DONATO','PROFESSOR','2167',to_date('09-JUN-81','DD-MON-RR'),'490',null,'222');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4834','DANTE ANGELO','HEADMASTER','157',to_date('09-JUN-81','DD-MON-RR'),'1843',null,'304');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4835','ECO ANDREA','TECHNICIAN','276',to_date('09-JUN-81','DD-MON-RR'),'778',null,'365');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4836','SANTE FRANCESCO','TECHNICIAN','2767',to_date('09-JUN-81','DD-MON-RR'),'1355',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4837','PETRARCA ELIO','MANAGER','3830',to_date('09-JUN-81','DD-MON-RR'),'497',null,'224');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4838','CORONA GAETANO','SUPERVISOR','2388',to_date('09-JUN-81','DD-MON-RR'),'619',null,'411');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4839','ESPOSITO IVANO','TECHNICIAN','2122',to_date('09-JUN-81','DD-MON-RR'),'902',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4840','LEVI LUIGI','PROFESSOR','2728',to_date('09-JUN-81','DD-MON-RR'),'1770',null,'282');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4841','SANTE LUCA','SUPERVISOR','3839',to_date('09-JUN-81','DD-MON-RR'),'888',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4842','GRIMALDI FEDERICO','PHDSTUDENT','3852',to_date('09-JUN-81','DD-MON-RR'),'15',null,'126');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4843','CARBONE SILVIA','HEADMASTER','3983',to_date('09-JUN-81','DD-MON-RR'),'1152',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4844','CORONA LUCA','MANAGER','4760',to_date('09-JUN-81','DD-MON-RR'),'1905',null,'146');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4845','DANTE FRANCESCO','PROFESSOR','2023',to_date('09-JUN-81','DD-MON-RR'),'1130',null,'3');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4846','DANTE LUIGI','MANAGER','186',to_date('09-JUN-81','DD-MON-RR'),'1306',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4847','GRIMALDI MASSIMO','PROFESSOR','3761',to_date('09-JUN-81','DD-MON-RR'),'1307',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4848','MANZONI IVANO','MANAGER','686',to_date('09-JUN-81','DD-MON-RR'),'1441',null,'102');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4849','CALVINO UGO','MANAGER','1971',to_date('09-JUN-81','DD-MON-RR'),'698',null,'335');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4850','ECO MARIO','MANAGER','3980',to_date('09-JUN-81','DD-MON-RR'),'16',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4851','PETRARCA DAMIANO','HEADMASTER','3422',to_date('09-JUN-81','DD-MON-RR'),'59',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4852','PETRARCA UGO','SECRETARY','2750',to_date('09-JUN-81','DD-MON-RR'),'1155',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4853','TIBALDI ROBERTA','HEADMASTER','3601',to_date('09-JUN-81','DD-MON-RR'),'1495',null,'441');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4854','ECO GAETANO','MANAGER','3234',to_date('09-JUN-81','DD-MON-RR'),'1438',null,'298');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4855','FO ROBERTA','LAWYER','54',to_date('09-JUN-81','DD-MON-RR'),'478',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4856','LEVI PAOLO','MANAGER','1687',to_date('09-JUN-81','DD-MON-RR'),'1543',null,'108');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4857','CORONA IVANO','LAWYER','3443',to_date('09-JUN-81','DD-MON-RR'),'734',null,'298');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4858','PETRARCA ANGELO','PROFESSOR','652',to_date('09-JUN-81','DD-MON-RR'),'444',null,'475');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4859','GRIMALDI DONATO','PROFESSOR','1289',to_date('09-JUN-81','DD-MON-RR'),'1671',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4860','ECO LUDOVICO','PROFESSOR','252',to_date('09-JUN-81','DD-MON-RR'),'370',null,'320');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4329','SANTE ELIO','HEADMASTER','1312',to_date('09-JUN-81','DD-MON-RR'),'1311',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4330','SANTE ELENA','MANAGER','167',to_date('09-JUN-81','DD-MON-RR'),'99',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4331','PETRARCA ANGELO','PHDSTUDENT','2988',to_date('09-JUN-81','DD-MON-RR'),'714',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4332','CARBONE UMBERTO','MANAGER','3829',to_date('09-JUN-81','DD-MON-RR'),'1204',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4333','CORONA PAOLO','LAWYER','2891',to_date('09-JUN-81','DD-MON-RR'),'1848',null,'103');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4334','ECO DONATO','HEADMASTER','1421',to_date('09-JUN-81','DD-MON-RR'),'38',null,'135');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4335','TIBALDI SILVIA','HEADMASTER','3777',to_date('09-JUN-81','DD-MON-RR'),'1670',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4336','SANTE GAETANO','PROFESSOR','3983',to_date('09-JUN-81','DD-MON-RR'),'1354',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4337','CORONA LUCIA','SUPERVISOR','3901',to_date('09-JUN-81','DD-MON-RR'),'81',null,'20');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4338','PETRARCA ANTONIO','ENGINEER','782',to_date('09-JUN-81','DD-MON-RR'),'1768',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4339','BIANCHI PASQUALE','PROFESSOR','6',to_date('09-JUN-81','DD-MON-RR'),'1059',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4340','MANZONI LUIGI','MANAGER','2334',to_date('09-JUN-81','DD-MON-RR'),'965',null,'166');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4747','ESPOSITO MASSIMO','LAWYER','2051',to_date('09-JUN-81','DD-MON-RR'),'325',null,'465');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4748','DANTE CLARA','SECRETARY','2909',to_date('09-JUN-81','DD-MON-RR'),'54',null,'124');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6777','TIBALDI PAOLO','SUPERVISOR','2438',to_date('09-JUN-81','DD-MON-RR'),'1477',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6778','MANZONI GIOVANNI','TECHNICIAN','5869',to_date('09-JUN-81','DD-MON-RR'),'1166',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6779','DANTE PASQUALE','HEADMASTER','223',to_date('09-JUN-81','DD-MON-RR'),'660',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6780','FO FEDERICO','LAWYER','6176',to_date('09-JUN-81','DD-MON-RR'),'414',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6781','LEOPARDI LUDOVICO','SECRETARY','4237',to_date('09-JUN-81','DD-MON-RR'),'297',null,'428');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6782','BIANCHI UGO','PHDSTUDENT','6462',to_date('09-JUN-81','DD-MON-RR'),'974',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6783','CORONA ANGELO','LAWYER','3826',to_date('09-JUN-81','DD-MON-RR'),'532',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6784','FO MARIO','SECRETARY','1075',to_date('09-JUN-81','DD-MON-RR'),'696',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5853','DANTE MARIA','MANAGER','2947',to_date('09-JUN-81','DD-MON-RR'),'801',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5854','BIANCHI FEDERICO','SUPERVISOR','1997',to_date('09-JUN-81','DD-MON-RR'),'286',null,'386');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5855','SANTE ALFONSO','ENGINEER','3026',to_date('09-JUN-81','DD-MON-RR'),'1384',null,'428');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5856','PETRARCA MASSIMO','HEADMASTER','4737',to_date('09-JUN-81','DD-MON-RR'),'1990',null,'160');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5857','NERI ELENA','MANAGER','2574',to_date('09-JUN-81','DD-MON-RR'),'951',null,'347');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5858','LEVI DAMIANO','TECHNICIAN','1677',to_date('09-JUN-81','DD-MON-RR'),'472',null,'477');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5859','GRIMALDI LUIGI','PROFESSOR','4334',to_date('09-JUN-81','DD-MON-RR'),'921',null,'253');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5860','COZZA MARIO','MANAGER','5279',to_date('09-JUN-81','DD-MON-RR'),'668',null,'179');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5861','SANTE MASSIMO','MANAGER','5155',to_date('09-JUN-81','DD-MON-RR'),'1931',null,'347');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5862','DANTE MARIA','HEADMASTER','4968',to_date('09-JUN-81','DD-MON-RR'),'270',null,'472');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5863','CARBONE MASSIMO','MANAGER','574',to_date('09-JUN-81','DD-MON-RR'),'955',null,'457');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5864','TIBALDI GIOVANNI','ENGINEER','2444',to_date('09-JUN-81','DD-MON-RR'),'976',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5865','NERI ANTONIO','MANAGER','3461',to_date('09-JUN-81','DD-MON-RR'),'1802',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5866','CORONA UGO','MANAGER','3800',to_date('09-JUN-81','DD-MON-RR'),'1078',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5867','CORONA GIOVANNI','SECRETARY','4763',to_date('09-JUN-81','DD-MON-RR'),'1173',null,'299');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5868','MANZONI CLARA','ENGINEER','2555',to_date('09-JUN-81','DD-MON-RR'),'456',null,'134');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5869','CORONA ANGELO','PHDSTUDENT','2250',to_date('09-JUN-81','DD-MON-RR'),'1396',null,'252');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5870','FUMAROLA ROBERTA','SECRETARY','1112',to_date('09-JUN-81','DD-MON-RR'),'424',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5871','NERI MARIA','ENGINEER','3749',to_date('09-JUN-81','DD-MON-RR'),'1618',null,'302');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5872','CORONA LUCIA','SECRETARY','5115',to_date('09-JUN-81','DD-MON-RR'),'1926',null,'465');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5873','DANTE ROBERTA','MANAGER','1536',to_date('09-JUN-81','DD-MON-RR'),'312',null,'145');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5874','SANTE ELENA','LAWYER','3215',to_date('09-JUN-81','DD-MON-RR'),'1778',null,'134');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5875','ECO LUDOVICO','MANAGER','3282',to_date('09-JUN-81','DD-MON-RR'),'1912',null,'51');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5876','NERI PASQUALE','TECHNICIAN','186',to_date('09-JUN-81','DD-MON-RR'),'861',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5877','TIBALDI FRANCESCO','PROFESSOR','5773',to_date('09-JUN-81','DD-MON-RR'),'1417',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5878','CALVINO MARIO','PHDSTUDENT','5736',to_date('09-JUN-81','DD-MON-RR'),'882',null,'32');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5879','NERI ANTONIO','MANAGER','4923',to_date('09-JUN-81','DD-MON-RR'),'1037',null,'229');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5880','PETRARCA LUCIA','SECRETARY','5875',to_date('09-JUN-81','DD-MON-RR'),'261',null,'91');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5881','GRIMALDI CLARA','MANAGER','2166',to_date('09-JUN-81','DD-MON-RR'),'255',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5882','BIANCHI COSIMO','LAWYER','3927',to_date('09-JUN-81','DD-MON-RR'),'1494',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5883','CARBONE IVANO','LAWYER','4498',to_date('09-JUN-81','DD-MON-RR'),'1274',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5884','LEOPARDI SILVIA','ENGINEER','2354',to_date('09-JUN-81','DD-MON-RR'),'1481',null,'31');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5885','NERI UMBERTO','MANAGER','510',to_date('09-JUN-81','DD-MON-RR'),'1695',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5886','LEVI DAMIANO','MANAGER','1443',to_date('09-JUN-81','DD-MON-RR'),'638',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5887','LEOPARDI ANGELO','ENGINEER','5268',to_date('09-JUN-81','DD-MON-RR'),'858',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5888','CALVINO ELIO','MANAGER','5767',to_date('09-JUN-81','DD-MON-RR'),'100',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5889','CALVINO LUIGI','PHDSTUDENT','571',to_date('09-JUN-81','DD-MON-RR'),'559',null,'222');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5890','LEOPARDI ROBERTA','LAWYER','4686',to_date('09-JUN-81','DD-MON-RR'),'453',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5891','ECO IVANO','ENGINEER','2491',to_date('09-JUN-81','DD-MON-RR'),'1484',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5892','COZZA LUDOVICO','PHDSTUDENT','978',to_date('09-JUN-81','DD-MON-RR'),'576',null,'300');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5893','CARBONE ROBERTA','MANAGER','4892',to_date('09-JUN-81','DD-MON-RR'),'230',null,'468');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5894','NERI LUCA','PROFESSOR','1969',to_date('09-JUN-81','DD-MON-RR'),'1529',null,'48');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5895','SANTE ROBERTA','SECRETARY','420',to_date('09-JUN-81','DD-MON-RR'),'1441',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5896','PETRARCA DAMIANO','SUPERVISOR','1786',to_date('09-JUN-81','DD-MON-RR'),'1409',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5897','TIBALDI MARIA','MANAGER','5224',to_date('09-JUN-81','DD-MON-RR'),'565',null,'192');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5898','DANTE LUCA','LAWYER','2212',to_date('09-JUN-81','DD-MON-RR'),'1561',null,'317');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5899','BIANCHI GAETANO','SECRETARY','766',to_date('09-JUN-81','DD-MON-RR'),'1490',null,'33');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5900','LEVI ELENA','SECRETARY','2740',to_date('09-JUN-81','DD-MON-RR'),'1190',null,'356');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5901','BIANCHI ANTONIO','MANAGER','5249',to_date('09-JUN-81','DD-MON-RR'),'219',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5902','MANZONI UGO','MANAGER','4067',to_date('09-JUN-81','DD-MON-RR'),'1419',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5903','CALVINO UMBERTO','TECHNICIAN','3506',to_date('09-JUN-81','DD-MON-RR'),'1145',null,'415');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5904','CALVINO ANTONIO','HEADMASTER','3142',to_date('09-JUN-81','DD-MON-RR'),'30',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5905','SANTE LUDOVICO','TECHNICIAN','3500',to_date('09-JUN-81','DD-MON-RR'),'1413',null,'53');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5906','LEVI ANTONIO','PROFESSOR','1783',to_date('09-JUN-81','DD-MON-RR'),'1050',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5907','FO UMBERTO','ENGINEER','4842',to_date('09-JUN-81','DD-MON-RR'),'1614',null,'278');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5908','LEVI ALFONSO','LAWYER','5733',to_date('09-JUN-81','DD-MON-RR'),'949',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5909','SANTE ALFONSO','MANAGER','259',to_date('09-JUN-81','DD-MON-RR'),'473',null,'113');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5910','ECO FRANCESCO','MANAGER','3205',to_date('09-JUN-81','DD-MON-RR'),'859',null,'87');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5911','PETRARCA ROBERTA','SECRETARY','3320',to_date('09-JUN-81','DD-MON-RR'),'75',null,'168');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5912','NERI LUCIA','LAWYER','2551',to_date('09-JUN-81','DD-MON-RR'),'1719',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5913','ECO ANGELO','MANAGER','4383',to_date('09-JUN-81','DD-MON-RR'),'1500',null,'309');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5914','NERI ANGELO','ENGINEER','1649',to_date('09-JUN-81','DD-MON-RR'),'1191',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5915','NERI ELIO','LAWYER','5762',to_date('09-JUN-81','DD-MON-RR'),'338',null,'412');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5916','CALVINO FRANCESCO','PROFESSOR','5689',to_date('09-JUN-81','DD-MON-RR'),'759',null,'299');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5917','PETRARCA CLARA','SECRETARY','4458',to_date('09-JUN-81','DD-MON-RR'),'792',null,'249');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5918','CARBONE DONATO','SECRETARY','939',to_date('09-JUN-81','DD-MON-RR'),'251',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5919','ESPOSITO GAETANO','HEADMASTER','587',to_date('09-JUN-81','DD-MON-RR'),'943',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5920','TIBALDI LUCA','MANAGER','319',to_date('09-JUN-81','DD-MON-RR'),'1903',null,'486');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5921','DANTE FEDERICO','LAWYER','2607',to_date('09-JUN-81','DD-MON-RR'),'126',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5922','CARBONE UGO','MANAGER','4018',to_date('09-JUN-81','DD-MON-RR'),'230',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5923','FUMAROLA COSIMO','HEADMASTER','2704',to_date('09-JUN-81','DD-MON-RR'),'579',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5924','ECO LUCA','ENGINEER','396',to_date('09-JUN-81','DD-MON-RR'),'331',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5925','GRIMALDI IVANO','TECHNICIAN','283',to_date('09-JUN-81','DD-MON-RR'),'1756',null,'318');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5926','CALVINO UGO','TECHNICIAN','4817',to_date('09-JUN-81','DD-MON-RR'),'395',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5927','CARBONE LUCA','ENGINEER','716',to_date('09-JUN-81','DD-MON-RR'),'1831',null,'139');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5928','PETRARCA PAOLO','ENGINEER','3384',to_date('09-JUN-81','DD-MON-RR'),'1099',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5929','MANZONI MARIO','TECHNICIAN','5036',to_date('09-JUN-81','DD-MON-RR'),'204',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5930','NERI MARIA','HEADMASTER','1437',to_date('09-JUN-81','DD-MON-RR'),'788',null,'317');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5931','LEOPARDI ALFONSO','SUPERVISOR','3664',to_date('09-JUN-81','DD-MON-RR'),'456',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5932','ESPOSITO PASQUALE','PROFESSOR','3464',to_date('09-JUN-81','DD-MON-RR'),'667',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5933','TIBALDI MARIO','PHDSTUDENT','1627',to_date('09-JUN-81','DD-MON-RR'),'1117',null,'192');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5934','ESPOSITO IVANO','TECHNICIAN','4401',to_date('09-JUN-81','DD-MON-RR'),'43',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5935','ESPOSITO SILVIA','LAWYER','2562',to_date('09-JUN-81','DD-MON-RR'),'1643',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5936','LEOPARDI UMBERTO','PHDSTUDENT','2728',to_date('09-JUN-81','DD-MON-RR'),'637',null,'453');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5937','COZZA FEDERICO','SECRETARY','5208',to_date('09-JUN-81','DD-MON-RR'),'645',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5938','BIANCHI SILVIA','SUPERVISOR','2707',to_date('09-JUN-81','DD-MON-RR'),'921',null,'0');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5939','LEOPARDI FEDERICO','ENGINEER','1560',to_date('09-JUN-81','DD-MON-RR'),'354',null,'97');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5940','ESPOSITO IVANO','PHDSTUDENT','3896',to_date('09-JUN-81','DD-MON-RR'),'567',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5941','ECO UGO','MANAGER','3560',to_date('09-JUN-81','DD-MON-RR'),'1620',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5942','ESPOSITO DONATO','MANAGER','3727',to_date('09-JUN-81','DD-MON-RR'),'1474',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5943','TIBALDI DAMIANO','MANAGER','3108',to_date('09-JUN-81','DD-MON-RR'),'1626',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5944','CARBONE LUIGI','SECRETARY','4136',to_date('09-JUN-81','DD-MON-RR'),'1835',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5945','CALVINO MASSIMO','HEADMASTER','3946',to_date('09-JUN-81','DD-MON-RR'),'719',null,'35');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5946','ESPOSITO MARIA','PROFESSOR','3300',to_date('09-JUN-81','DD-MON-RR'),'1758',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5947','MANZONI ALFONSO','MANAGER','3113',to_date('09-JUN-81','DD-MON-RR'),'26',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5948','TIBALDI GIOVANNI','HEADMASTER','373',to_date('09-JUN-81','DD-MON-RR'),'1235',null,'0');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5949','CORONA LUDOVICO','ENGINEER','863',to_date('09-JUN-81','DD-MON-RR'),'1673',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5950','FO UMBERTO','ENGINEER','5168',to_date('09-JUN-81','DD-MON-RR'),'781',null,'318');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5951','BIANCHI MARIO','SECRETARY','2153',to_date('09-JUN-81','DD-MON-RR'),'409',null,'398');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5952','SANTE LUCA','ENGINEER','4085',to_date('09-JUN-81','DD-MON-RR'),'1797',null,'97');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5953','CORONA GAETANO','SECRETARY','4186',to_date('09-JUN-81','DD-MON-RR'),'322',null,'453');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5954','NERI FRANCESCO','SUPERVISOR','2141',to_date('09-JUN-81','DD-MON-RR'),'1385',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5955','CALVINO ANGELO','TECHNICIAN','1254',to_date('09-JUN-81','DD-MON-RR'),'1285',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5956','TIBALDI ELENA','MANAGER','4557',to_date('09-JUN-81','DD-MON-RR'),'1888',null,'429');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5957','CARBONE DAMIANO','LAWYER','4429',to_date('09-JUN-81','DD-MON-RR'),'450',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5958','CORONA UGO','SECRETARY','1365',to_date('09-JUN-81','DD-MON-RR'),'888',null,'196');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5959','GRIMALDI DONATO','PHDSTUDENT','1107',to_date('09-JUN-81','DD-MON-RR'),'1016',null,'316');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5960','CALVINO COSIMO','PHDSTUDENT','4079',to_date('09-JUN-81','DD-MON-RR'),'1303',null,'24');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5961','LEVI LUDOVICO','HEADMASTER','2038',to_date('09-JUN-81','DD-MON-RR'),'529',null,'288');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5962','ESPOSITO UMBERTO','TECHNICIAN','2590',to_date('09-JUN-81','DD-MON-RR'),'1139',null,'170');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5963','LEOPARDI UGO','MANAGER','4756',to_date('09-JUN-81','DD-MON-RR'),'1476',null,'262');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5964','CALVINO DONATO','SUPERVISOR','777',to_date('09-JUN-81','DD-MON-RR'),'121',null,'91');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5965','MANZONI ELIO','SUPERVISOR','1016',to_date('09-JUN-81','DD-MON-RR'),'1633',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5966','CORONA GIOVANNI','MANAGER','5082',to_date('09-JUN-81','DD-MON-RR'),'1694',null,'20');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5967','PETRARCA ELIO','SECRETARY','3243',to_date('09-JUN-81','DD-MON-RR'),'964',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5968','BIANCHI ROBERTA','SUPERVISOR','5759',to_date('09-JUN-81','DD-MON-RR'),'1693',null,'341');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5969','GRIMALDI ANGELO','MANAGER','986',to_date('09-JUN-81','DD-MON-RR'),'334',null,'309');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5970','GRIMALDI IVANO','SECRETARY','5798',to_date('09-JUN-81','DD-MON-RR'),'202',null,'284');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5971','TIBALDI ALFONSO','MANAGER','130',to_date('09-JUN-81','DD-MON-RR'),'345',null,'460');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5972','COZZA ELIO','LAWYER','5545',to_date('09-JUN-81','DD-MON-RR'),'289',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5973','COZZA ELIO','LAWYER','1854',to_date('09-JUN-81','DD-MON-RR'),'1986',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5974','FUMAROLA ANGELO','ENGINEER','3299',to_date('09-JUN-81','DD-MON-RR'),'1299',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5975','ESPOSITO LUCA','PROFESSOR','5515',to_date('09-JUN-81','DD-MON-RR'),'1937',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5976','PETRARCA COSIMO','SECRETARY','3376',to_date('09-JUN-81','DD-MON-RR'),'474',null,'38');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5977','GRIMALDI PAOLO','PHDSTUDENT','2714',to_date('09-JUN-81','DD-MON-RR'),'456',null,'410');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5978','MANZONI LUIGI','SECRETARY','2420',to_date('09-JUN-81','DD-MON-RR'),'1807',null,'421');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5979','LEOPARDI MASSIMO','HEADMASTER','808',to_date('09-JUN-81','DD-MON-RR'),'899',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6368','LEVI DAMIANO','PHDSTUDENT','5468',to_date('09-JUN-81','DD-MON-RR'),'359',null,'18');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('810','COZZA ANDREA','LAWYER','300',to_date('09-JUN-81','DD-MON-RR'),'1551',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('811','DANTE ANDREA','PROFESSOR','751',to_date('09-JUN-81','DD-MON-RR'),'1186',null,'230');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('812','ECO MARIO','HEADMASTER','327',to_date('09-JUN-81','DD-MON-RR'),'1661',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('813','PETRARCA ELENA','TECHNICIAN','678',to_date('09-JUN-81','DD-MON-RR'),'1967',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('814','MANZONI GAETANO','LAWYER','341',to_date('09-JUN-81','DD-MON-RR'),'1070',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('815','LEVI LUDOVICO','MANAGER','255',to_date('09-JUN-81','DD-MON-RR'),'1608',null,'355');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('816','PETRARCA PASQUALE','TECHNICIAN','461',to_date('09-JUN-81','DD-MON-RR'),'1153',null,'496');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('817','CARBONE PASQUALE','PHDSTUDENT','309',to_date('09-JUN-81','DD-MON-RR'),'247',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('818','FO SILVIA','LAWYER','655',to_date('09-JUN-81','DD-MON-RR'),'1751',null,'484');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('819','PETRARCA PAOLO','PROFESSOR','552',to_date('09-JUN-81','DD-MON-RR'),'290',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('820','FUMAROLA DONATO','ENGINEER','522',to_date('09-JUN-81','DD-MON-RR'),'1772',null,'331');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('821','MANZONI SILVIA','TECHNICIAN','613',to_date('09-JUN-81','DD-MON-RR'),'1917',null,'444');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('822','NERI ANTONIO','LAWYER','671',to_date('09-JUN-81','DD-MON-RR'),'725',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('823','ECO ELIO','PHDSTUDENT','584',to_date('09-JUN-81','DD-MON-RR'),'108',null,'325');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('824','CORONA MARIA','LAWYER','469',to_date('09-JUN-81','DD-MON-RR'),'801',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('825','TIBALDI ELIO','MANAGER','703',to_date('09-JUN-81','DD-MON-RR'),'1482',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('826','FO MARIA','PROFESSOR','684',to_date('09-JUN-81','DD-MON-RR'),'1671',null,'166');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('827','CORONA LUDOVICO','PROFESSOR','271',to_date('09-JUN-81','DD-MON-RR'),'784',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('828','SANTE GIOVANNI','PROFESSOR','693',to_date('09-JUN-81','DD-MON-RR'),'1655',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('829','GRIMALDI LUDOVICO','HEADMASTER','717',to_date('09-JUN-81','DD-MON-RR'),'154',null,'56');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('830','PETRARCA ANGELO','HEADMASTER','399',to_date('09-JUN-81','DD-MON-RR'),'1851',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('831','GRIMALDI COSIMO','LAWYER','694',to_date('09-JUN-81','DD-MON-RR'),'540',null,'441');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('832','CALVINO UMBERTO','LAWYER','403',to_date('09-JUN-81','DD-MON-RR'),'632',null,'425');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('833','ECO ANTONIO','SECRETARY','80',to_date('09-JUN-81','DD-MON-RR'),'429',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('834','DANTE MARIO','PHDSTUDENT','663',to_date('09-JUN-81','DD-MON-RR'),'1136',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('835','LEVI FRANCESCO','LAWYER','106',to_date('09-JUN-81','DD-MON-RR'),'874',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('836','COZZA ELIO','HEADMASTER','111',to_date('09-JUN-81','DD-MON-RR'),'1469',null,'45');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('837','DANTE CLARA','LAWYER','397',to_date('09-JUN-81','DD-MON-RR'),'775',null,'197');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('838','LEOPARDI SILVIA','MANAGER','246',to_date('09-JUN-81','DD-MON-RR'),'1297',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('839','ECO GIOVANNI','TECHNICIAN','330',to_date('09-JUN-81','DD-MON-RR'),'1055',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('840','FO ANTONIO','PROFESSOR','191',to_date('09-JUN-81','DD-MON-RR'),'1128',null,'325');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('841','TIBALDI COSIMO','MANAGER','360',to_date('09-JUN-81','DD-MON-RR'),'1567',null,'142');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('842','GRIMALDI DAMIANO','PROFESSOR','503',to_date('09-JUN-81','DD-MON-RR'),'550',null,'287');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('843','MANZONI GIOVANNI','LAWYER','646',to_date('09-JUN-81','DD-MON-RR'),'1791',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('844','ESPOSITO UGO','MANAGER','375',to_date('09-JUN-81','DD-MON-RR'),'759',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('845','COZZA ELENA','HEADMASTER','775',to_date('09-JUN-81','DD-MON-RR'),'765',null,'18');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('846','BIANCHI COSIMO','HEADMASTER','100',to_date('09-JUN-81','DD-MON-RR'),'836',null,'235');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('847','FUMAROLA MARIA','TECHNICIAN','500',to_date('09-JUN-81','DD-MON-RR'),'1071',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('848','FUMAROLA GIOVANNI','SUPERVISOR','249',to_date('09-JUN-81','DD-MON-RR'),'591',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('849','ESPOSITO DAMIANO','TECHNICIAN','491',to_date('09-JUN-81','DD-MON-RR'),'988',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('850','BIANCHI MARIA','SECRETARY','74',to_date('09-JUN-81','DD-MON-RR'),'229',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('851','LEVI SILVIA','HEADMASTER','691',to_date('09-JUN-81','DD-MON-RR'),'1604',null,'177');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('852','SANTE COSIMO','MANAGER','473',to_date('09-JUN-81','DD-MON-RR'),'1593',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('853','TIBALDI LUCIA','TECHNICIAN','214',to_date('09-JUN-81','DD-MON-RR'),'515',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('854','GRIMALDI PASQUALE','TECHNICIAN','278',to_date('09-JUN-81','DD-MON-RR'),'1813',null,'99');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('855','BIANCHI ELIO','PHDSTUDENT','256',to_date('09-JUN-81','DD-MON-RR'),'1216',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('856','CARBONE CLARA','HEADMASTER','158',to_date('09-JUN-81','DD-MON-RR'),'1090',null,'497');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('857','PETRARCA DAMIANO','PHDSTUDENT','715',to_date('09-JUN-81','DD-MON-RR'),'769',null,'498');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('858','ECO UMBERTO','LAWYER','19',to_date('09-JUN-81','DD-MON-RR'),'1477',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('859','BIANCHI ANDREA','MANAGER','328',to_date('09-JUN-81','DD-MON-RR'),'721',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('860','FUMAROLA ANDREA','ENGINEER','839',to_date('09-JUN-81','DD-MON-RR'),'794',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('861','GRIMALDI ANGELO','SECRETARY','585',to_date('09-JUN-81','DD-MON-RR'),'1660',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('862','NERI SILVIA','PHDSTUDENT','755',to_date('09-JUN-81','DD-MON-RR'),'412',null,'38');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('863','BIANCHI COSIMO','MANAGER','720',to_date('09-JUN-81','DD-MON-RR'),'1787',null,'151');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('864','LEVI LUIGI','LAWYER','520',to_date('09-JUN-81','DD-MON-RR'),'1907',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('865','PETRARCA ANGELO','HEADMASTER','27',to_date('09-JUN-81','DD-MON-RR'),'1021',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('866','CALVINO FRANCESCO','HEADMASTER','807',to_date('09-JUN-81','DD-MON-RR'),'1353',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('867','GRIMALDI MASSIMO','LAWYER','421',to_date('09-JUN-81','DD-MON-RR'),'455',null,'123');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('868','BIANCHI MASSIMO','HEADMASTER','109',to_date('09-JUN-81','DD-MON-RR'),'1873',null,'5');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('869','MANZONI COSIMO','HEADMASTER','666',to_date('09-JUN-81','DD-MON-RR'),'1186',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('870','DANTE UMBERTO','HEADMASTER','226',to_date('09-JUN-81','DD-MON-RR'),'1363',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('871','BIANCHI IVANO','ENGINEER','253',to_date('09-JUN-81','DD-MON-RR'),'458',null,'127');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('872','GRIMALDI LUCA','PHDSTUDENT','870',to_date('09-JUN-81','DD-MON-RR'),'1018',null,'417');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('873','DANTE ALFONSO','LAWYER','315',to_date('09-JUN-81','DD-MON-RR'),'394',null,'436');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('874','CARBONE PASQUALE','SUPERVISOR','834',to_date('09-JUN-81','DD-MON-RR'),'784',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('206','COZZA MARIO','SUPERVISOR','139',to_date('09-JUN-81','DD-MON-RR'),'665',null,'426');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('207','DANTE PAOLO','SECRETARY','63',to_date('09-JUN-81','DD-MON-RR'),'1488',null,'53');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('208','COZZA SILVIA','HEADMASTER','201',to_date('09-JUN-81','DD-MON-RR'),'1073',null,'77');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('209','CALVINO ELENA','PHDSTUDENT','138',to_date('09-JUN-81','DD-MON-RR'),'782',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('210','SANTE ALFONSO','TECHNICIAN','28',to_date('09-JUN-81','DD-MON-RR'),'364',null,'335');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('211','FO GAETANO','PROFESSOR','175',to_date('09-JUN-81','DD-MON-RR'),'1974',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('212','CORONA ELENA','ENGINEER','143',to_date('09-JUN-81','DD-MON-RR'),'572',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('213','NERI SILVIA','SUPERVISOR','21',to_date('09-JUN-81','DD-MON-RR'),'132',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('214','CARBONE DONATO','PROFESSOR','19',to_date('09-JUN-81','DD-MON-RR'),'681',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('215','FO UGO','MANAGER','186',to_date('09-JUN-81','DD-MON-RR'),'738',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('216','LEVI PAOLO','ENGINEER','112',to_date('09-JUN-81','DD-MON-RR'),'266',null,'0');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('217','SANTE MARIO','MANAGER','167',to_date('09-JUN-81','DD-MON-RR'),'989',null,'134');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('218','DANTE LUCA','MANAGER','68',to_date('09-JUN-81','DD-MON-RR'),'753',null,'216');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('219','CARBONE MARIA','LAWYER','77',to_date('09-JUN-81','DD-MON-RR'),'1441',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('220','CALVINO ALFONSO','LAWYER','197',to_date('09-JUN-81','DD-MON-RR'),'830',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('221','ESPOSITO SILVIA','PHDSTUDENT','136',to_date('09-JUN-81','DD-MON-RR'),'952',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('222','ESPOSITO IVANO','PHDSTUDENT','133',to_date('09-JUN-81','DD-MON-RR'),'162',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('223','SANTE PAOLO','TECHNICIAN','52',to_date('09-JUN-81','DD-MON-RR'),'1691',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('224','FUMAROLA GAETANO','LAWYER','175',to_date('09-JUN-81','DD-MON-RR'),'1842',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('225','FUMAROLA SILVIA','PHDSTUDENT','206',to_date('09-JUN-81','DD-MON-RR'),'397',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('226','PETRARCA ANTONIO','PROFESSOR','74',to_date('09-JUN-81','DD-MON-RR'),'840',null,'99');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('227','TIBALDI ELIO','SECRETARY','28',to_date('09-JUN-81','DD-MON-RR'),'1277',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('228','COZZA LUCIA','LAWYER','1',to_date('09-JUN-81','DD-MON-RR'),'1491',null,'483');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('229','FUMAROLA ANDREA','SECRETARY','125',to_date('09-JUN-81','DD-MON-RR'),'396',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('230','SANTE ROBERTA','ENGINEER','162',to_date('09-JUN-81','DD-MON-RR'),'701',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('231','LEVI COSIMO','TECHNICIAN','45',to_date('09-JUN-81','DD-MON-RR'),'1302',null,'87');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('232','COZZA LUCA','SECRETARY','210',to_date('09-JUN-81','DD-MON-RR'),'1188',null,'426');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('233','CORONA LUDOVICO','SECRETARY','144',to_date('09-JUN-81','DD-MON-RR'),'1056',null,'53');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('234','ECO UMBERTO','SECRETARY','27',to_date('09-JUN-81','DD-MON-RR'),'1080',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('235','CALVINO GIOVANNI','PROFESSOR','76',to_date('09-JUN-81','DD-MON-RR'),'1209',null,'252');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('236','MANZONI ALFONSO','MANAGER','8',to_date('09-JUN-81','DD-MON-RR'),'558',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('237','NERI LUIGI','HEADMASTER','100',to_date('09-JUN-81','DD-MON-RR'),'1166',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('238','PETRARCA ROBERTA','LAWYER','152',to_date('09-JUN-81','DD-MON-RR'),'1401',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('239','NERI FEDERICO','MANAGER','64',to_date('09-JUN-81','DD-MON-RR'),'811',null,'61');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('240','LEOPARDI PAOLO','LAWYER','34',to_date('09-JUN-81','DD-MON-RR'),'613',null,'311');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('241','LEOPARDI ANDREA','PROFESSOR','114',to_date('09-JUN-81','DD-MON-RR'),'1244',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('242','LEVI PAOLO','PROFESSOR','217',to_date('09-JUN-81','DD-MON-RR'),'517',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('243','CORONA ELIO','ENGINEER','122',to_date('09-JUN-81','DD-MON-RR'),'352',null,'12');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('244','PETRARCA DONATO','SECRETARY','165',to_date('09-JUN-81','DD-MON-RR'),'381',null,'358');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('245','MANZONI UMBERTO','PHDSTUDENT','201',to_date('09-JUN-81','DD-MON-RR'),'648',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('246','TIBALDI FEDERICO','MANAGER','36',to_date('09-JUN-81','DD-MON-RR'),'892',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('247','PETRARCA ANDREA','PROFESSOR','196',to_date('09-JUN-81','DD-MON-RR'),'599',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('248','FUMAROLA ANTONIO','LAWYER','89',to_date('09-JUN-81','DD-MON-RR'),'495',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('249','ECO ELENA','TECHNICIAN','174',to_date('09-JUN-81','DD-MON-RR'),'50',null,'65');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('250','PETRARCA LUIGI','HEADMASTER','28',to_date('09-JUN-81','DD-MON-RR'),'1301',null,'318');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('251','ECO GAETANO','SECRETARY','177',to_date('09-JUN-81','DD-MON-RR'),'493',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('252','BIANCHI CLARA','TECHNICIAN','243',to_date('09-JUN-81','DD-MON-RR'),'349',null,'376');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('253','CALVINO MARIO','ENGINEER','29',to_date('09-JUN-81','DD-MON-RR'),'1146',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('254','CALVINO LUCIA','LAWYER','18',to_date('09-JUN-81','DD-MON-RR'),'1319',null,'56');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('255','GRIMALDI PASQUALE','LAWYER','132',to_date('09-JUN-81','DD-MON-RR'),'382',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('256','CARBONE SILVIA','SUPERVISOR','195',to_date('09-JUN-81','DD-MON-RR'),'36',null,'468');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('257','TIBALDI GIOVANNI','MANAGER','69',to_date('09-JUN-81','DD-MON-RR'),'1813',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('258','PETRARCA DAMIANO','SECRETARY','134',to_date('09-JUN-81','DD-MON-RR'),'588',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('259','FO MARIO','SECRETARY','91',to_date('09-JUN-81','DD-MON-RR'),'1002',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('260','CALVINO ANTONIO','PROFESSOR','106',to_date('09-JUN-81','DD-MON-RR'),'448',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('261','CALVINO MARIO','HEADMASTER','180',to_date('09-JUN-81','DD-MON-RR'),'284',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('262','DANTE UGO','ENGINEER','248',to_date('09-JUN-81','DD-MON-RR'),'464',null,'169');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('263','CORONA DONATO','SUPERVISOR','37',to_date('09-JUN-81','DD-MON-RR'),'1559',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('264','NERI SILVIA','SECRETARY','173',to_date('09-JUN-81','DD-MON-RR'),'798',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('265','BIANCHI LUIGI','TECHNICIAN','140',to_date('09-JUN-81','DD-MON-RR'),'554',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('266','BIANCHI LUDOVICO','HEADMASTER','44',to_date('09-JUN-81','DD-MON-RR'),'1946',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('267','SANTE FRANCESCO','MANAGER','24',to_date('09-JUN-81','DD-MON-RR'),'1099',null,'192');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('268','GRIMALDI MARIA','MANAGER','254',to_date('09-JUN-81','DD-MON-RR'),'266',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('269','DANTE ANTONIO','HEADMASTER','0',to_date('09-JUN-81','DD-MON-RR'),'423',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('270','GRIMALDI PAOLO','PHDSTUDENT','51',to_date('09-JUN-81','DD-MON-RR'),'589',null,'6');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('271','BIANCHI SILVIA','PHDSTUDENT','247',to_date('09-JUN-81','DD-MON-RR'),'311',null,'132');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('272','COZZA LUCIA','SUPERVISOR','71',to_date('09-JUN-81','DD-MON-RR'),'1813',null,'209');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('273','FO LUCA','HEADMASTER','79',to_date('09-JUN-81','DD-MON-RR'),'568',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('274','ESPOSITO MARIA','TECHNICIAN','50',to_date('09-JUN-81','DD-MON-RR'),'89',null,'153');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('275','LEVI ANDREA','MANAGER','216',to_date('09-JUN-81','DD-MON-RR'),'1954',null,'184');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('276','GRIMALDI LUIGI','SECRETARY','26',to_date('09-JUN-81','DD-MON-RR'),'1511',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2716','FO GAETANO','SECRETARY','2647',to_date('09-JUN-81','DD-MON-RR'),'21',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2717','GRIMALDI LUDOVICO','MANAGER','590',to_date('09-JUN-81','DD-MON-RR'),'1636',null,'195');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2718','BIANCHI MARIA','SUPERVISOR','2658',to_date('09-JUN-81','DD-MON-RR'),'643',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2719','ESPOSITO MARIA','MANAGER','2297',to_date('09-JUN-81','DD-MON-RR'),'1122',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2720','ECO ALFONSO','ENGINEER','1613',to_date('09-JUN-81','DD-MON-RR'),'1759',null,'5');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2721','LEOPARDI LUCA','SUPERVISOR','389',to_date('09-JUN-81','DD-MON-RR'),'1936',null,'246');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2722','CORONA MARIA','ENGINEER','1359',to_date('09-JUN-81','DD-MON-RR'),'1413',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2723','BIANCHI ANGELO','HEADMASTER','921',to_date('09-JUN-81','DD-MON-RR'),'536',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2724','ESPOSITO IVANO','LAWYER','730',to_date('09-JUN-81','DD-MON-RR'),'1067',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2725','SANTE ELIO','PHDSTUDENT','232',to_date('09-JUN-81','DD-MON-RR'),'338',null,'436');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2726','PETRARCA MARIO','PHDSTUDENT','1579',to_date('09-JUN-81','DD-MON-RR'),'602',null,'417');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2727','BIANCHI MARIA','PHDSTUDENT','1465',to_date('09-JUN-81','DD-MON-RR'),'611',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2728','CORONA GIOVANNI','SUPERVISOR','2168',to_date('09-JUN-81','DD-MON-RR'),'1071',null,'294');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2729','CALVINO PAOLO','PROFESSOR','1266',to_date('09-JUN-81','DD-MON-RR'),'328',null,'405');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2730','GRIMALDI PASQUALE','HEADMASTER','1067',to_date('09-JUN-81','DD-MON-RR'),'1588',null,'278');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2731','ESPOSITO PAOLO','ENGINEER','351',to_date('09-JUN-81','DD-MON-RR'),'941',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2732','BIANCHI ELENA','MANAGER','783',to_date('09-JUN-81','DD-MON-RR'),'161',null,'64');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2733','DANTE ELENA','LAWYER','1743',to_date('09-JUN-81','DD-MON-RR'),'1392',null,'430');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2734','MANZONI ALFONSO','HEADMASTER','1381',to_date('09-JUN-81','DD-MON-RR'),'502',null,'460');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2735','FUMAROLA ANTONIO','HEADMASTER','1928',to_date('09-JUN-81','DD-MON-RR'),'82',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2736','DANTE FRANCESCO','TECHNICIAN','2673',to_date('09-JUN-81','DD-MON-RR'),'866',null,'393');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2737','BIANCHI ANDREA','SUPERVISOR','2231',to_date('09-JUN-81','DD-MON-RR'),'1365',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2738','ECO ALFONSO','MANAGER','735',to_date('09-JUN-81','DD-MON-RR'),'1275',null,'3');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2739','FUMAROLA LUCIA','PROFESSOR','2427',to_date('09-JUN-81','DD-MON-RR'),'740',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2740','COZZA LUCIA','MANAGER','1197',to_date('09-JUN-81','DD-MON-RR'),'785',null,'368');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2741','FO ALFONSO','SUPERVISOR','485',to_date('09-JUN-81','DD-MON-RR'),'1264',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2742','GRIMALDI GIOVANNI','ENGINEER','805',to_date('09-JUN-81','DD-MON-RR'),'881',null,'276');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2743','BIANCHI UGO','SUPERVISOR','44',to_date('09-JUN-81','DD-MON-RR'),'1305',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2744','CARBONE LUIGI','SECRETARY','2248',to_date('09-JUN-81','DD-MON-RR'),'1336',null,'213');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2745','FUMAROLA FRANCESCO','PHDSTUDENT','1543',to_date('09-JUN-81','DD-MON-RR'),'1824',null,'253');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2746','SANTE DONATO','HEADMASTER','937',to_date('09-JUN-81','DD-MON-RR'),'1901',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2747','ECO MARIA','HEADMASTER','1886',to_date('09-JUN-81','DD-MON-RR'),'416',null,'430');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2748','BIANCHI MARIO','HEADMASTER','2180',to_date('09-JUN-81','DD-MON-RR'),'1857',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2749','NERI FEDERICO','PROFESSOR','113',to_date('09-JUN-81','DD-MON-RR'),'1545',null,'174');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2750','FO ANTONIO','MANAGER','1601',to_date('09-JUN-81','DD-MON-RR'),'401',null,'368');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2751','LEOPARDI FEDERICO','PROFESSOR','691',to_date('09-JUN-81','DD-MON-RR'),'1683',null,'230');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2752','ECO UGO','HEADMASTER','1279',to_date('09-JUN-81','DD-MON-RR'),'689',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2753','CARBONE PASQUALE','ENGINEER','1569',to_date('09-JUN-81','DD-MON-RR'),'757',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2754','GRIMALDI FRANCESCO','TECHNICIAN','407',to_date('09-JUN-81','DD-MON-RR'),'810',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2755','TIBALDI ANTONIO','MANAGER','883',to_date('09-JUN-81','DD-MON-RR'),'911',null,'495');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2756','FUMAROLA LUIGI','PHDSTUDENT','1564',to_date('09-JUN-81','DD-MON-RR'),'1592',null,'166');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2757','ESPOSITO UMBERTO','PHDSTUDENT','1114',to_date('09-JUN-81','DD-MON-RR'),'614',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2758','FO SILVIA','MANAGER','1336',to_date('09-JUN-81','DD-MON-RR'),'405',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2759','CORONA FRANCESCO','MANAGER','795',to_date('09-JUN-81','DD-MON-RR'),'1637',null,'34');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2760','BIANCHI MASSIMO','SECRETARY','632',to_date('09-JUN-81','DD-MON-RR'),'1272',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2761','LEOPARDI ALFONSO','HEADMASTER','1959',to_date('09-JUN-81','DD-MON-RR'),'523',null,'369');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2762','FO ALFONSO','MANAGER','89',to_date('09-JUN-81','DD-MON-RR'),'1389',null,'443');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2763','DANTE ALFONSO','MANAGER','796',to_date('09-JUN-81','DD-MON-RR'),'335',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2764','GRIMALDI LUIGI','SECRETARY','693',to_date('09-JUN-81','DD-MON-RR'),'731',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2765','PETRARCA LUCIA','SECRETARY','722',to_date('09-JUN-81','DD-MON-RR'),'69',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2766','FO LUDOVICO','HEADMASTER','1662',to_date('09-JUN-81','DD-MON-RR'),'1926',null,'60');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2767','BIANCHI ROBERTA','HEADMASTER','2548',to_date('09-JUN-81','DD-MON-RR'),'74',null,'52');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2768','CARBONE PAOLO','LAWYER','912',to_date('09-JUN-81','DD-MON-RR'),'1386',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2769','ESPOSITO LUIGI','SUPERVISOR','1236',to_date('09-JUN-81','DD-MON-RR'),'1063',null,'200');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2770','CORONA GIOVANNI','ENGINEER','520',to_date('09-JUN-81','DD-MON-RR'),'224',null,'120');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2771','TIBALDI GAETANO','TECHNICIAN','586',to_date('09-JUN-81','DD-MON-RR'),'743',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2772','DANTE LUDOVICO','PROFESSOR','2060',to_date('09-JUN-81','DD-MON-RR'),'1266',null,'249');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2773','BIANCHI PAOLO','SECRETARY','1769',to_date('09-JUN-81','DD-MON-RR'),'1543',null,'298');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2774','CORONA ELIO','ENGINEER','1744',to_date('09-JUN-81','DD-MON-RR'),'542',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2775','CORONA PAOLO','ENGINEER','650',to_date('09-JUN-81','DD-MON-RR'),'237',null,'186');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2776','CALVINO UMBERTO','ENGINEER','2689',to_date('09-JUN-81','DD-MON-RR'),'1366',null,'258');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2777','PETRARCA ANDREA','PHDSTUDENT','2466',to_date('09-JUN-81','DD-MON-RR'),'1517',null,'430');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2778','FO PASQUALE','PHDSTUDENT','813',to_date('09-JUN-81','DD-MON-RR'),'492',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2779','CALVINO DONATO','MANAGER','2138',to_date('09-JUN-81','DD-MON-RR'),'938',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2780','CORONA PAOLO','TECHNICIAN','1226',to_date('09-JUN-81','DD-MON-RR'),'1465',null,'110');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2781','FO LUIGI','MANAGER','2668',to_date('09-JUN-81','DD-MON-RR'),'352',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2782','LEVI UGO','HEADMASTER','1959',to_date('09-JUN-81','DD-MON-RR'),'980',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2783','CORONA MARIO','PHDSTUDENT','2422',to_date('09-JUN-81','DD-MON-RR'),'341',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2784','LEOPARDI LUIGI','MANAGER','2357',to_date('09-JUN-81','DD-MON-RR'),'1662',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2785','SANTE LUDOVICO','PROFESSOR','336',to_date('09-JUN-81','DD-MON-RR'),'904',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2786','ESPOSITO PASQUALE','SECRETARY','97',to_date('09-JUN-81','DD-MON-RR'),'452',null,'465');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2787','ESPOSITO LUIGI','PROFESSOR','2238',to_date('09-JUN-81','DD-MON-RR'),'813',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2788','TIBALDI PAOLO','HEADMASTER','1989',to_date('09-JUN-81','DD-MON-RR'),'1686',null,'35');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2789','LEVI PASQUALE','LAWYER','1575',to_date('09-JUN-81','DD-MON-RR'),'1272',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2790','CORONA DAMIANO','ENGINEER','1936',to_date('09-JUN-81','DD-MON-RR'),'1550',null,'213');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2791','NERI PASQUALE','MANAGER','2775',to_date('09-JUN-81','DD-MON-RR'),'304',null,'460');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2792','ESPOSITO FRANCESCO','MANAGER','1274',to_date('09-JUN-81','DD-MON-RR'),'733',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2793','FUMAROLA MASSIMO','HEADMASTER','1060',to_date('09-JUN-81','DD-MON-RR'),'69',null,'423');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2794','BIANCHI LUCA','TECHNICIAN','1633',to_date('09-JUN-81','DD-MON-RR'),'636',null,'136');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2795','LEOPARDI DONATO','PHDSTUDENT','1465',to_date('09-JUN-81','DD-MON-RR'),'1784',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2796','NERI CLARA','ENGINEER','1805',to_date('09-JUN-81','DD-MON-RR'),'254',null,'485');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2797','LEVI LUIGI','TECHNICIAN','531',to_date('09-JUN-81','DD-MON-RR'),'1016',null,'450');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1872','PETRARCA ANGELO','ENGINEER','39',to_date('09-JUN-81','DD-MON-RR'),'803',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1873','LEOPARDI FRANCESCO','ENGINEER','1417',to_date('09-JUN-81','DD-MON-RR'),'1244',null,'398');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1874','BIANCHI SILVIA','ENGINEER','1364',to_date('09-JUN-81','DD-MON-RR'),'1505',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1875','GRIMALDI DAMIANO','MANAGER','700',to_date('09-JUN-81','DD-MON-RR'),'1960',null,'402');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1876','LEVI IVANO','LAWYER','1002',to_date('09-JUN-81','DD-MON-RR'),'1185',null,'214');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1877','NERI DAMIANO','SECRETARY','1240',to_date('09-JUN-81','DD-MON-RR'),'804',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1878','NERI COSIMO','MANAGER','87',to_date('09-JUN-81','DD-MON-RR'),'395',null,'469');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1879','FUMAROLA GIOVANNI','MANAGER','604',to_date('09-JUN-81','DD-MON-RR'),'1218',null,'192');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1880','MANZONI LUIGI','SUPERVISOR','1359',to_date('09-JUN-81','DD-MON-RR'),'566',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1881','ECO CLARA','HEADMASTER','1598',to_date('09-JUN-81','DD-MON-RR'),'757',null,'140');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1882','MANZONI PASQUALE','MANAGER','1586',to_date('09-JUN-81','DD-MON-RR'),'504',null,'32');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1883','PETRARCA LUIGI','PROFESSOR','236',to_date('09-JUN-81','DD-MON-RR'),'5',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1884','TIBALDI ALFONSO','ENGINEER','1316',to_date('09-JUN-81','DD-MON-RR'),'337',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1885','PETRARCA LUCIA','PROFESSOR','1303',to_date('09-JUN-81','DD-MON-RR'),'1951',null,'193');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1886','COZZA ANDREA','SUPERVISOR','1824',to_date('09-JUN-81','DD-MON-RR'),'706',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1887','BIANCHI ANTONIO','SECRETARY','1718',to_date('09-JUN-81','DD-MON-RR'),'951',null,'226');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1888','COZZA CLARA','PHDSTUDENT','907',to_date('09-JUN-81','DD-MON-RR'),'819',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1889','BIANCHI ELIO','SUPERVISOR','1451',to_date('09-JUN-81','DD-MON-RR'),'347',null,'214');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1890','TIBALDI ALFONSO','PROFESSOR','124',to_date('09-JUN-81','DD-MON-RR'),'1900',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1891','GRIMALDI MARIO','SECRETARY','1294',to_date('09-JUN-81','DD-MON-RR'),'393',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1892','CARBONE MARIA','TECHNICIAN','938',to_date('09-JUN-81','DD-MON-RR'),'711',null,'311');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1893','TIBALDI ELENA','PROFESSOR','681',to_date('09-JUN-81','DD-MON-RR'),'1623',null,'158');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1894','PETRARCA GAETANO','LAWYER','61',to_date('09-JUN-81','DD-MON-RR'),'1527',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1895','NERI IVANO','MANAGER','268',to_date('09-JUN-81','DD-MON-RR'),'1582',null,'86');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1896','ECO CLARA','LAWYER','1817',to_date('09-JUN-81','DD-MON-RR'),'1856',null,'299');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1897','PETRARCA GIOVANNI','PHDSTUDENT','1174',to_date('09-JUN-81','DD-MON-RR'),'1437',null,'200');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1898','SANTE IVANO','HEADMASTER','281',to_date('09-JUN-81','DD-MON-RR'),'57',null,'271');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1899','DANTE FRANCESCO','MANAGER','486',to_date('09-JUN-81','DD-MON-RR'),'1668',null,'151');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1900','PETRARCA UMBERTO','HEADMASTER','845',to_date('09-JUN-81','DD-MON-RR'),'874',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1901','LEOPARDI ELIO','SECRETARY','41',to_date('09-JUN-81','DD-MON-RR'),'388',null,'496');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1902','DANTE CLARA','SUPERVISOR','1266',to_date('09-JUN-81','DD-MON-RR'),'572',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1903','SANTE LUCA','PROFESSOR','1518',to_date('09-JUN-81','DD-MON-RR'),'1351',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1904','ECO FEDERICO','PHDSTUDENT','1674',to_date('09-JUN-81','DD-MON-RR'),'793',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1905','ECO GIOVANNI','LAWYER','400',to_date('09-JUN-81','DD-MON-RR'),'126',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1906','TIBALDI LUCIA','HEADMASTER','177',to_date('09-JUN-81','DD-MON-RR'),'1407',null,'214');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1907','TIBALDI ROBERTA','PROFESSOR','572',to_date('09-JUN-81','DD-MON-RR'),'1981',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1908','BIANCHI FEDERICO','MANAGER','1595',to_date('09-JUN-81','DD-MON-RR'),'1710',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1909','DANTE PASQUALE','HEADMASTER','1716',to_date('09-JUN-81','DD-MON-RR'),'151',null,'61');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1910','SANTE SILVIA','MANAGER','1389',to_date('09-JUN-81','DD-MON-RR'),'935',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1911','FO SILVIA','MANAGER','1836',to_date('09-JUN-81','DD-MON-RR'),'1181',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1912','SANTE CLARA','ENGINEER','928',to_date('09-JUN-81','DD-MON-RR'),'1952',null,'252');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1913','CARBONE GIOVANNI','MANAGER','1486',to_date('09-JUN-81','DD-MON-RR'),'91',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1914','FUMAROLA ALFONSO','MANAGER','169',to_date('09-JUN-81','DD-MON-RR'),'824',null,'344');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1915','ESPOSITO UGO','MANAGER','1822',to_date('09-JUN-81','DD-MON-RR'),'611',null,'207');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1916','COZZA SILVIA','HEADMASTER','461',to_date('09-JUN-81','DD-MON-RR'),'1986',null,'251');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1917','LEVI FRANCESCO','PHDSTUDENT','1810',to_date('09-JUN-81','DD-MON-RR'),'1736',null,'77');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1918','BIANCHI COSIMO','MANAGER','22',to_date('09-JUN-81','DD-MON-RR'),'1025',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1919','CALVINO COSIMO','PHDSTUDENT','81',to_date('09-JUN-81','DD-MON-RR'),'1928',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1920','BIANCHI PASQUALE','PHDSTUDENT','1301',to_date('09-JUN-81','DD-MON-RR'),'254',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1921','FO ANGELO','HEADMASTER','8',to_date('09-JUN-81','DD-MON-RR'),'246',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2837','MANZONI DONATO','ENGINEER','2374',to_date('09-JUN-81','DD-MON-RR'),'1577',null,'213');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2838','BIANCHI UGO','MANAGER','613',to_date('09-JUN-81','DD-MON-RR'),'1169',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2839','LEVI COSIMO','MANAGER','2805',to_date('09-JUN-81','DD-MON-RR'),'690',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4749','CARBONE ROBERTA','HEADMASTER','2843',to_date('09-JUN-81','DD-MON-RR'),'923',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4750','GRIMALDI LUDOVICO','HEADMASTER','3068',to_date('09-JUN-81','DD-MON-RR'),'747',null,'233');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4751','NERI ANTONIO','SUPERVISOR','4116',to_date('09-JUN-81','DD-MON-RR'),'1992',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4752','CORONA ANGELO','MANAGER','4326',to_date('09-JUN-81','DD-MON-RR'),'551',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4753','DANTE ANGELO','PROFESSOR','3928',to_date('09-JUN-81','DD-MON-RR'),'1083',null,'322');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4754','ECO GAETANO','SUPERVISOR','4281',to_date('09-JUN-81','DD-MON-RR'),'53',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4755','LEVI ANGELO','HEADMASTER','1090',to_date('09-JUN-81','DD-MON-RR'),'521',null,'287');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4756','GRIMALDI ALFONSO','SECRETARY','1031',to_date('09-JUN-81','DD-MON-RR'),'1084',null,'94');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4757','MANZONI LUCA','MANAGER','3469',to_date('09-JUN-81','DD-MON-RR'),'1408',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4758','SANTE LUCA','ENGINEER','107',to_date('09-JUN-81','DD-MON-RR'),'743',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4759','CARBONE ALFONSO','PROFESSOR','1837',to_date('09-JUN-81','DD-MON-RR'),'697',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4760','ECO LUCA','HEADMASTER','3654',to_date('09-JUN-81','DD-MON-RR'),'187',null,'55');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4761','COZZA CLARA','HEADMASTER','2551',to_date('09-JUN-81','DD-MON-RR'),'11',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4762','BIANCHI ANTONIO','TECHNICIAN','3615',to_date('09-JUN-81','DD-MON-RR'),'1901',null,'413');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4763','BIANCHI MASSIMO','PROFESSOR','1461',to_date('09-JUN-81','DD-MON-RR'),'758',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4764','LEVI DAMIANO','PHDSTUDENT','1405',to_date('09-JUN-81','DD-MON-RR'),'864',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4765','ECO GAETANO','HEADMASTER','1809',to_date('09-JUN-81','DD-MON-RR'),'1533',null,'249');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4766','CARBONE MARIA','PROFESSOR','1318',to_date('09-JUN-81','DD-MON-RR'),'1290',null,'146');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4767','ESPOSITO DONATO','MANAGER','3465',to_date('09-JUN-81','DD-MON-RR'),'260',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4768','FO SILVIA','MANAGER','4407',to_date('09-JUN-81','DD-MON-RR'),'1011',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4769','CALVINO IVANO','PHDSTUDENT','4099',to_date('09-JUN-81','DD-MON-RR'),'1774',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4770','GRIMALDI LUIGI','HEADMASTER','3839',to_date('09-JUN-81','DD-MON-RR'),'1594',null,'222');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4771','MANZONI CLARA','SECRETARY','2818',to_date('09-JUN-81','DD-MON-RR'),'1128',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4772','COZZA ANGELO','PHDSTUDENT','1905',to_date('09-JUN-81','DD-MON-RR'),'1792',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4773','COZZA ELIO','PHDSTUDENT','3281',to_date('09-JUN-81','DD-MON-RR'),'747',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4774','TIBALDI GAETANO','LAWYER','651',to_date('09-JUN-81','DD-MON-RR'),'1802',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4775','ECO CLARA','SUPERVISOR','2363',to_date('09-JUN-81','DD-MON-RR'),'212',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4776','LEOPARDI LUIGI','ENGINEER','2365',to_date('09-JUN-81','DD-MON-RR'),'1',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4777','FUMAROLA MARIO','SUPERVISOR','1272',to_date('09-JUN-81','DD-MON-RR'),'568',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4778','FO LUCIA','MANAGER','4142',to_date('09-JUN-81','DD-MON-RR'),'1673',null,'420');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4779','COZZA GIOVANNI','LAWYER','1288',to_date('09-JUN-81','DD-MON-RR'),'1723',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4780','TIBALDI PAOLO','TECHNICIAN','2184',to_date('09-JUN-81','DD-MON-RR'),'346',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4781','TIBALDI ANGELO','LAWYER','4516',to_date('09-JUN-81','DD-MON-RR'),'1218',null,'301');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4782','CARBONE UMBERTO','LAWYER','88',to_date('09-JUN-81','DD-MON-RR'),'1141',null,'386');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4783','GRIMALDI MASSIMO','TECHNICIAN','2412',to_date('09-JUN-81','DD-MON-RR'),'810',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4784','MANZONI GIOVANNI','PROFESSOR','1097',to_date('09-JUN-81','DD-MON-RR'),'1893',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4785','SANTE MARIO','PROFESSOR','483',to_date('09-JUN-81','DD-MON-RR'),'1116',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4786','LEVI MARIA','LAWYER','4293',to_date('09-JUN-81','DD-MON-RR'),'120',null,'459');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4787','FUMAROLA MARIO','MANAGER','4734',to_date('09-JUN-81','DD-MON-RR'),'1950',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4788','COZZA PAOLO','PHDSTUDENT','3272',to_date('09-JUN-81','DD-MON-RR'),'1032',null,'369');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4789','NERI MASSIMO','MANAGER','4434',to_date('09-JUN-81','DD-MON-RR'),'183',null,'181');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4790','BIANCHI UMBERTO','TECHNICIAN','1417',to_date('09-JUN-81','DD-MON-RR'),'414',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4791','CARBONE PASQUALE','SECRETARY','3852',to_date('09-JUN-81','DD-MON-RR'),'796',null,'99');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4792','GRIMALDI PAOLO','LAWYER','4545',to_date('09-JUN-81','DD-MON-RR'),'1776',null,'65');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4793','GRIMALDI IVANO','MANAGER','372',to_date('09-JUN-81','DD-MON-RR'),'665',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4794','TIBALDI PAOLO','HEADMASTER','1118',to_date('09-JUN-81','DD-MON-RR'),'1401',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3863','ECO DONATO','ENGINEER','2885',to_date('09-JUN-81','DD-MON-RR'),'1712',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3864','TIBALDI CLARA','TECHNICIAN','3243',to_date('09-JUN-81','DD-MON-RR'),'1128',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3865','SANTE IVANO','PROFESSOR','2103',to_date('09-JUN-81','DD-MON-RR'),'1692',null,'81');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3866','BIANCHI CLARA','TECHNICIAN','1015',to_date('09-JUN-81','DD-MON-RR'),'419',null,'359');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3867','TIBALDI ANGELO','PHDSTUDENT','2653',to_date('09-JUN-81','DD-MON-RR'),'747',null,'102');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3868','CALVINO FEDERICO','MANAGER','3030',to_date('09-JUN-81','DD-MON-RR'),'264',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3869','GRIMALDI MARIA','HEADMASTER','1317',to_date('09-JUN-81','DD-MON-RR'),'1979',null,'386');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3870','ECO DONATO','PROFESSOR','467',to_date('09-JUN-81','DD-MON-RR'),'918',null,'387');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3871','COZZA ELIO','TECHNICIAN','914',to_date('09-JUN-81','DD-MON-RR'),'1025',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3872','NERI SILVIA','MANAGER','1268',to_date('09-JUN-81','DD-MON-RR'),'567',null,'302');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3873','DANTE ELIO','HEADMASTER','3357',to_date('09-JUN-81','DD-MON-RR'),'966',null,'61');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3874','ECO SILVIA','SECRETARY','1027',to_date('09-JUN-81','DD-MON-RR'),'57',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3875','COZZA LUIGI','HEADMASTER','3741',to_date('09-JUN-81','DD-MON-RR'),'1588',null,'318');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3876','ESPOSITO DONATO','ENGINEER','22',to_date('09-JUN-81','DD-MON-RR'),'629',null,'199');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3877','LEVI ANGELO','PHDSTUDENT','2767',to_date('09-JUN-81','DD-MON-RR'),'1194',null,'140');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3878','DANTE SILVIA','SECRETARY','1206',to_date('09-JUN-81','DD-MON-RR'),'1992',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3879','SANTE DONATO','HEADMASTER','2745',to_date('09-JUN-81','DD-MON-RR'),'637',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3880','ECO CLARA','MANAGER','579',to_date('09-JUN-81','DD-MON-RR'),'643',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3881','LEOPARDI IVANO','TECHNICIAN','2615',to_date('09-JUN-81','DD-MON-RR'),'134',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3882','CARBONE ANDREA','SUPERVISOR','274',to_date('09-JUN-81','DD-MON-RR'),'525',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3883','SANTE ALFONSO','LAWYER','1288',to_date('09-JUN-81','DD-MON-RR'),'1787',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3884','PETRARCA GIOVANNI','PROFESSOR','3677',to_date('09-JUN-81','DD-MON-RR'),'71',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3885','BIANCHI SILVIA','TECHNICIAN','3813',to_date('09-JUN-81','DD-MON-RR'),'312',null,'42');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3886','NERI ANTONIO','LAWYER','1387',to_date('09-JUN-81','DD-MON-RR'),'1233',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3887','GRIMALDI LUCA','HEADMASTER','2763',to_date('09-JUN-81','DD-MON-RR'),'1521',null,'12');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3888','CORONA COSIMO','SECRETARY','2558',to_date('09-JUN-81','DD-MON-RR'),'888',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3889','COZZA COSIMO','MANAGER','3034',to_date('09-JUN-81','DD-MON-RR'),'372',null,'432');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3890','BIANCHI MASSIMO','LAWYER','3697',to_date('09-JUN-81','DD-MON-RR'),'590',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3891','CORONA DONATO','HEADMASTER','706',to_date('09-JUN-81','DD-MON-RR'),'564',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3892','DANTE LUDOVICO','TECHNICIAN','611',to_date('09-JUN-81','DD-MON-RR'),'784',null,'19');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3893','SANTE ANDREA','LAWYER','3074',to_date('09-JUN-81','DD-MON-RR'),'1340',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3894','TIBALDI FEDERICO','PHDSTUDENT','467',to_date('09-JUN-81','DD-MON-RR'),'285',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3895','PETRARCA MASSIMO','SUPERVISOR','3337',to_date('09-JUN-81','DD-MON-RR'),'561',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3896','ESPOSITO LUCIA','PHDSTUDENT','3336',to_date('09-JUN-81','DD-MON-RR'),'995',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3897','NERI PASQUALE','TECHNICIAN','2815',to_date('09-JUN-81','DD-MON-RR'),'99',null,'455');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3898','SANTE FEDERICO','ENGINEER','3559',to_date('09-JUN-81','DD-MON-RR'),'43',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3899','FO IVANO','ENGINEER','1340',to_date('09-JUN-81','DD-MON-RR'),'865',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3900','FUMAROLA LUCA','LAWYER','2730',to_date('09-JUN-81','DD-MON-RR'),'549',null,'354');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3901','PETRARCA COSIMO','SECRETARY','3452',to_date('09-JUN-81','DD-MON-RR'),'32',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3902','NERI COSIMO','LAWYER','939',to_date('09-JUN-81','DD-MON-RR'),'366',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3903','DANTE MARIA','PHDSTUDENT','291',to_date('09-JUN-81','DD-MON-RR'),'1715',null,'359');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3904','LEOPARDI LUIGI','PROFESSOR','2436',to_date('09-JUN-81','DD-MON-RR'),'1420',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3905','PETRARCA MARIA','PROFESSOR','593',to_date('09-JUN-81','DD-MON-RR'),'1551',null,'79');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3906','CALVINO UGO','MANAGER','3465',to_date('09-JUN-81','DD-MON-RR'),'1981',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3907','BIANCHI ELENA','PHDSTUDENT','3227',to_date('09-JUN-81','DD-MON-RR'),'1907',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3908','CORONA LUIGI','TECHNICIAN','3865',to_date('09-JUN-81','DD-MON-RR'),'360',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3909','LEOPARDI ROBERTA','PHDSTUDENT','2895',to_date('09-JUN-81','DD-MON-RR'),'945',null,'428');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3910','BIANCHI SILVIA','HEADMASTER','348',to_date('09-JUN-81','DD-MON-RR'),'695',null,'354');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3911','CARBONE FRANCESCO','MANAGER','2210',to_date('09-JUN-81','DD-MON-RR'),'192',null,'402');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3912','CALVINO PASQUALE','SUPERVISOR','2720',to_date('09-JUN-81','DD-MON-RR'),'665',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3913','SANTE ANGELO','HEADMASTER','2336',to_date('09-JUN-81','DD-MON-RR'),'1227',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3914','MANZONI PAOLO','SECRETARY','2057',to_date('09-JUN-81','DD-MON-RR'),'126',null,'39');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3915','LEVI LUCIA','ENGINEER','1242',to_date('09-JUN-81','DD-MON-RR'),'716',null,'311');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3916','DANTE DAMIANO','PHDSTUDENT','3295',to_date('09-JUN-81','DD-MON-RR'),'340',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3917','DANTE PASQUALE','TECHNICIAN','650',to_date('09-JUN-81','DD-MON-RR'),'1531',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3918','CALVINO PASQUALE','TECHNICIAN','848',to_date('09-JUN-81','DD-MON-RR'),'73',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3919','SANTE LUDOVICO','HEADMASTER','2279',to_date('09-JUN-81','DD-MON-RR'),'1881',null,'195');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3920','GRIMALDI CLARA','LAWYER','3668',to_date('09-JUN-81','DD-MON-RR'),'1283',null,'8');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3921','PETRARCA UGO','TECHNICIAN','1527',to_date('09-JUN-81','DD-MON-RR'),'1019',null,'396');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3922','CARBONE IVANO','SUPERVISOR','2949',to_date('09-JUN-81','DD-MON-RR'),'646',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3923','COZZA FEDERICO','HEADMASTER','3574',to_date('09-JUN-81','DD-MON-RR'),'356',null,'52');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3924','LEOPARDI GAETANO','HEADMASTER','958',to_date('09-JUN-81','DD-MON-RR'),'1469',null,'230');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3925','FUMAROLA ELENA','PROFESSOR','1156',to_date('09-JUN-81','DD-MON-RR'),'663',null,'213');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3926','MANZONI ANGELO','TECHNICIAN','3671',to_date('09-JUN-81','DD-MON-RR'),'558',null,'302');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3927','ESPOSITO MASSIMO','HEADMASTER','2325',to_date('09-JUN-81','DD-MON-RR'),'698',null,'42');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3928','NERI MARIA','ENGINEER','1140',to_date('09-JUN-81','DD-MON-RR'),'1559',null,'112');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3929','LEVI LUCA','SECRETARY','3601',to_date('09-JUN-81','DD-MON-RR'),'1880',null,'56');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3930','GRIMALDI UMBERTO','PROFESSOR','643',to_date('09-JUN-81','DD-MON-RR'),'1739',null,'420');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3931','MANZONI ALFONSO','HEADMASTER','2701',to_date('09-JUN-81','DD-MON-RR'),'235',null,'5');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3932','LEOPARDI ANGELO','MANAGER','219',to_date('09-JUN-81','DD-MON-RR'),'876',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3933','PETRARCA ANTONIO','ENGINEER','743',to_date('09-JUN-81','DD-MON-RR'),'1899',null,'302');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3934','FUMAROLA MASSIMO','MANAGER','3119',to_date('09-JUN-81','DD-MON-RR'),'525',null,'120');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3935','TIBALDI LUIGI','SUPERVISOR','1634',to_date('09-JUN-81','DD-MON-RR'),'1608',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3936','GRIMALDI FEDERICO','PHDSTUDENT','3884',to_date('09-JUN-81','DD-MON-RR'),'166',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3937','LEVI ALFONSO','LAWYER','2379',to_date('09-JUN-81','DD-MON-RR'),'864',null,'135');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3938','CORONA PAOLO','PHDSTUDENT','1516',to_date('09-JUN-81','DD-MON-RR'),'1525',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3939','NERI ELIO','TECHNICIAN','1141',to_date('09-JUN-81','DD-MON-RR'),'1939',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3940','FUMAROLA ALFONSO','SECRETARY','1364',to_date('09-JUN-81','DD-MON-RR'),'583',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3941','FO LUDOVICO','ENGINEER','3548',to_date('09-JUN-81','DD-MON-RR'),'1070',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3942','ESPOSITO UGO','TECHNICIAN','2831',to_date('09-JUN-81','DD-MON-RR'),'273',null,'110');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3943','CORONA PASQUALE','TECHNICIAN','3622',to_date('09-JUN-81','DD-MON-RR'),'164',null,'278');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3944','BIANCHI MARIA','SUPERVISOR','97',to_date('09-JUN-81','DD-MON-RR'),'722',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3945','CALVINO FRANCESCO','MANAGER','2533',to_date('09-JUN-81','DD-MON-RR'),'476',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3946','TIBALDI UGO','SUPERVISOR','3572',to_date('09-JUN-81','DD-MON-RR'),'341',null,'477');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3947','PETRARCA LUIGI','MANAGER','422',to_date('09-JUN-81','DD-MON-RR'),'1550',null,'311');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3948','ESPOSITO ANDREA','MANAGER','484',to_date('09-JUN-81','DD-MON-RR'),'1365',null,'201');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3949','FO CLARA','TECHNICIAN','1634',to_date('09-JUN-81','DD-MON-RR'),'1012',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3950','BIANCHI PASQUALE','MANAGER','2758',to_date('09-JUN-81','DD-MON-RR'),'1323',null,'483');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4341','TIBALDI PAOLO','ENGINEER','3963',to_date('09-JUN-81','DD-MON-RR'),'1406',null,'498');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6369','FUMAROLA ANGELO','SECRETARY','1830',to_date('09-JUN-81','DD-MON-RR'),'1647',null,'329');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6370','COZZA ELIO','MANAGER','3816',to_date('09-JUN-81','DD-MON-RR'),'685',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6371','FO GAETANO','PROFESSOR','4891',to_date('09-JUN-81','DD-MON-RR'),'439',null,'162');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6372','SANTE ANDREA','PROFESSOR','753',to_date('09-JUN-81','DD-MON-RR'),'798',null,'427');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6373','PETRARCA IVANO','MANAGER','783',to_date('09-JUN-81','DD-MON-RR'),'1993',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6374','CORONA DONATO','ENGINEER','5195',to_date('09-JUN-81','DD-MON-RR'),'1128',null,'444');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6375','LEOPARDI MASSIMO','PROFESSOR','4065',to_date('09-JUN-81','DD-MON-RR'),'1612',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6376','FUMAROLA ELENA','ENGINEER','6083',to_date('09-JUN-81','DD-MON-RR'),'1851',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6377','CALVINO FRANCESCO','MANAGER','3463',to_date('09-JUN-81','DD-MON-RR'),'1760',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6378','CORONA PAOLO','LAWYER','4144',to_date('09-JUN-81','DD-MON-RR'),'1505',null,'12');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6379','BIANCHI MASSIMO','MANAGER','936',to_date('09-JUN-81','DD-MON-RR'),'1454',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6380','GRIMALDI ALFONSO','PHDSTUDENT','2907',to_date('09-JUN-81','DD-MON-RR'),'1677',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6381','GRIMALDI ANTONIO','MANAGER','3646',to_date('09-JUN-81','DD-MON-RR'),'1244',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6382','DANTE COSIMO','PHDSTUDENT','4055',to_date('09-JUN-81','DD-MON-RR'),'889',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6383','CALVINO FRANCESCO','SUPERVISOR','3541',to_date('09-JUN-81','DD-MON-RR'),'985',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6384','FO ANDREA','ENGINEER','5637',to_date('09-JUN-81','DD-MON-RR'),'1442',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6385','MANZONI IVANO','HEADMASTER','5262',to_date('09-JUN-81','DD-MON-RR'),'424',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6386','GRIMALDI UGO','SECRETARY','4746',to_date('09-JUN-81','DD-MON-RR'),'4',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6387','PETRARCA UGO','TECHNICIAN','2771',to_date('09-JUN-81','DD-MON-RR'),'1564',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6388','CALVINO LUIGI','HEADMASTER','1765',to_date('09-JUN-81','DD-MON-RR'),'1726',null,'320');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6389','LEVI GAETANO','PHDSTUDENT','1065',to_date('09-JUN-81','DD-MON-RR'),'652',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6390','NERI ELENA','HEADMASTER','3989',to_date('09-JUN-81','DD-MON-RR'),'1801',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6391','FUMAROLA ANDREA','SECRETARY','4020',to_date('09-JUN-81','DD-MON-RR'),'697',null,'169');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6392','CARBONE GIOVANNI','MANAGER','2860',to_date('09-JUN-81','DD-MON-RR'),'980',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6393','SANTE ANGELO','SUPERVISOR','5753',to_date('09-JUN-81','DD-MON-RR'),'1613',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6394','MANZONI FEDERICO','LAWYER','4825',to_date('09-JUN-81','DD-MON-RR'),'478',null,'103');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6395','NERI IVANO','LAWYER','2447',to_date('09-JUN-81','DD-MON-RR'),'1317',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6396','CORONA MARIA','MANAGER','3985',to_date('09-JUN-81','DD-MON-RR'),'1160',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6397','DANTE LUCA','LAWYER','2852',to_date('09-JUN-81','DD-MON-RR'),'1230',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6398','FO ROBERTA','TECHNICIAN','1839',to_date('09-JUN-81','DD-MON-RR'),'535',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6399','LEVI MARIA','ENGINEER','3880',to_date('09-JUN-81','DD-MON-RR'),'1125',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6400','LEVI ANGELO','TECHNICIAN','627',to_date('09-JUN-81','DD-MON-RR'),'1271',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6401','FO GAETANO','TECHNICIAN','464',to_date('09-JUN-81','DD-MON-RR'),'1092',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6402','LEVI FEDERICO','PHDSTUDENT','2599',to_date('09-JUN-81','DD-MON-RR'),'1906',null,'170');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6403','TIBALDI MARIA','LAWYER','1967',to_date('09-JUN-81','DD-MON-RR'),'1907',null,'488');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6404','CARBONE GIOVANNI','PROFESSOR','2721',to_date('09-JUN-81','DD-MON-RR'),'570',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6405','TIBALDI ALFONSO','HEADMASTER','816',to_date('09-JUN-81','DD-MON-RR'),'394',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6406','MANZONI SILVIA','HEADMASTER','848',to_date('09-JUN-81','DD-MON-RR'),'1105',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6407','ECO PAOLO','ENGINEER','2672',to_date('09-JUN-81','DD-MON-RR'),'339',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6408','NERI PASQUALE','LAWYER','2995',to_date('09-JUN-81','DD-MON-RR'),'1137',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6409','FUMAROLA ANTONIO','LAWYER','1464',to_date('09-JUN-81','DD-MON-RR'),'647',null,'374');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6410','BIANCHI MASSIMO','TECHNICIAN','1123',to_date('09-JUN-81','DD-MON-RR'),'420',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6411','NERI UGO','TECHNICIAN','3647',to_date('09-JUN-81','DD-MON-RR'),'994',null,'39');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6412','FO DAMIANO','ENGINEER','3113',to_date('09-JUN-81','DD-MON-RR'),'1210',null,'6');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6413','ESPOSITO CLARA','SUPERVISOR','3096',to_date('09-JUN-81','DD-MON-RR'),'1662',null,'421');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6414','GRIMALDI UMBERTO','ENGINEER','4694',to_date('09-JUN-81','DD-MON-RR'),'1008',null,'32');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6415','CORONA SILVIA','TECHNICIAN','2115',to_date('09-JUN-81','DD-MON-RR'),'509',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6416','FUMAROLA GAETANO','MANAGER','5788',to_date('09-JUN-81','DD-MON-RR'),'468',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6417','LEVI UMBERTO','HEADMASTER','5287',to_date('09-JUN-81','DD-MON-RR'),'1987',null,'6');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6418','MANZONI ANGELO','PROFESSOR','711',to_date('09-JUN-81','DD-MON-RR'),'254',null,'104');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6419','BIANCHI ELENA','TECHNICIAN','4460',to_date('09-JUN-81','DD-MON-RR'),'254',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6420','DANTE LUIGI','PROFESSOR','5824',to_date('09-JUN-81','DD-MON-RR'),'1876',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6421','LEVI PAOLO','SECRETARY','6342',to_date('09-JUN-81','DD-MON-RR'),'432',null,'111');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6422','TIBALDI GAETANO','PHDSTUDENT','3952',to_date('09-JUN-81','DD-MON-RR'),'42',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6423','COZZA MARIO','HEADMASTER','38',to_date('09-JUN-81','DD-MON-RR'),'1937',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6424','CARBONE MASSIMO','LAWYER','4488',to_date('09-JUN-81','DD-MON-RR'),'1234',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6425','ESPOSITO LUDOVICO','LAWYER','4848',to_date('09-JUN-81','DD-MON-RR'),'568',null,'282');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6426','DANTE ELIO','MANAGER','417',to_date('09-JUN-81','DD-MON-RR'),'1074',null,'47');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6427','COZZA LUIGI','LAWYER','110',to_date('09-JUN-81','DD-MON-RR'),'720',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6428','ESPOSITO CLARA','HEADMASTER','701',to_date('09-JUN-81','DD-MON-RR'),'1990',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6429','SANTE GAETANO','SUPERVISOR','3189',to_date('09-JUN-81','DD-MON-RR'),'1816',null,'340');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6430','DANTE LUCA','SUPERVISOR','909',to_date('09-JUN-81','DD-MON-RR'),'699',null,'171');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6431','LEOPARDI IVANO','HEADMASTER','3767',to_date('09-JUN-81','DD-MON-RR'),'983',null,'214');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6432','NERI MARIO','ENGINEER','6268',to_date('09-JUN-81','DD-MON-RR'),'1592',null,'267');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6433','PETRARCA ELENA','TECHNICIAN','2966',to_date('09-JUN-81','DD-MON-RR'),'1292',null,'259');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6434','TIBALDI ROBERTA','SECRETARY','4283',to_date('09-JUN-81','DD-MON-RR'),'1494',null,'318');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6435','FO UGO','HEADMASTER','2605',to_date('09-JUN-81','DD-MON-RR'),'805',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6436','ESPOSITO COSIMO','MANAGER','4115',to_date('09-JUN-81','DD-MON-RR'),'1390',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6437','COZZA PASQUALE','HEADMASTER','1565',to_date('09-JUN-81','DD-MON-RR'),'703',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6438','SANTE FEDERICO','PHDSTUDENT','1941',to_date('09-JUN-81','DD-MON-RR'),'202',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6439','CALVINO COSIMO','PHDSTUDENT','3533',to_date('09-JUN-81','DD-MON-RR'),'738',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6440','LEVI ANGELO','PHDSTUDENT','2688',to_date('09-JUN-81','DD-MON-RR'),'242',null,'460');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6441','TIBALDI UMBERTO','HEADMASTER','49',to_date('09-JUN-81','DD-MON-RR'),'1015',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6442','LEOPARDI DONATO','SUPERVISOR','5071',to_date('09-JUN-81','DD-MON-RR'),'1639',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6443','SANTE ANTONIO','PROFESSOR','3060',to_date('09-JUN-81','DD-MON-RR'),'1798',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6444','LEOPARDI MARIA','SUPERVISOR','1568',to_date('09-JUN-81','DD-MON-RR'),'537',null,'134');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6445','FO DONATO','PROFESSOR','119',to_date('09-JUN-81','DD-MON-RR'),'1742',null,'53');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6446','DANTE IVANO','MANAGER','6259',to_date('09-JUN-81','DD-MON-RR'),'1756',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6447','PETRARCA COSIMO','PHDSTUDENT','5163',to_date('09-JUN-81','DD-MON-RR'),'346',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6448','CORONA MARIO','ENGINEER','2263',to_date('09-JUN-81','DD-MON-RR'),'1022',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6449','CORONA LUIGI','HEADMASTER','2889',to_date('09-JUN-81','DD-MON-RR'),'976',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6450','NERI MARIO','PHDSTUDENT','4540',to_date('09-JUN-81','DD-MON-RR'),'13',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6451','SANTE FRANCESCO','MANAGER','5075',to_date('09-JUN-81','DD-MON-RR'),'1835',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6452','CARBONE COSIMO','ENGINEER','2132',to_date('09-JUN-81','DD-MON-RR'),'832',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6453','COZZA GAETANO','TECHNICIAN','4441',to_date('09-JUN-81','DD-MON-RR'),'46',null,'273');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6454','GRIMALDI CLARA','MANAGER','1046',to_date('09-JUN-81','DD-MON-RR'),'37',null,'139');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6455','CALVINO UGO','MANAGER','2239',to_date('09-JUN-81','DD-MON-RR'),'881',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6456','DANTE GIOVANNI','LAWYER','3868',to_date('09-JUN-81','DD-MON-RR'),'77',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6457','ESPOSITO MARIA','ENGINEER','5583',to_date('09-JUN-81','DD-MON-RR'),'1279',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6458','ESPOSITO LUIGI','SUPERVISOR','5808',to_date('09-JUN-81','DD-MON-RR'),'1077',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6459','NERI PASQUALE','PHDSTUDENT','1532',to_date('09-JUN-81','DD-MON-RR'),'1532',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6460','FO MASSIMO','TECHNICIAN','5067',to_date('09-JUN-81','DD-MON-RR'),'1281',null,'316');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6461','FO GIOVANNI','SUPERVISOR','1812',to_date('09-JUN-81','DD-MON-RR'),'554',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6462','CARBONE MARIA','TECHNICIAN','1130',to_date('09-JUN-81','DD-MON-RR'),'361',null,'436');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6463','ESPOSITO LUDOVICO','SUPERVISOR','1221',to_date('09-JUN-81','DD-MON-RR'),'1888',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6464','GRIMALDI LUDOVICO','LAWYER','3180',to_date('09-JUN-81','DD-MON-RR'),'1254',null,'316');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6465','FUMAROLA ALFONSO','PROFESSOR','906',to_date('09-JUN-81','DD-MON-RR'),'1856',null,'283');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6466','ECO MARIA','MANAGER','4261',to_date('09-JUN-81','DD-MON-RR'),'535',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6467','FUMAROLA PAOLO','PHDSTUDENT','5283',to_date('09-JUN-81','DD-MON-RR'),'1726',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6468','NERI DONATO','MANAGER','2677',to_date('09-JUN-81','DD-MON-RR'),'796',null,'4');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6469','PETRARCA UMBERTO','ENGINEER','3510',to_date('09-JUN-81','DD-MON-RR'),'1890',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6470','CORONA UGO','PHDSTUDENT','657',to_date('09-JUN-81','DD-MON-RR'),'66',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6471','SANTE PAOLO','SUPERVISOR','5913',to_date('09-JUN-81','DD-MON-RR'),'931',null,'177');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6472','CORONA MARIO','TECHNICIAN','1782',to_date('09-JUN-81','DD-MON-RR'),'1732',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6473','CARBONE FRANCESCO','LAWYER','2330',to_date('09-JUN-81','DD-MON-RR'),'1941',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6474','BIANCHI MARIO','PHDSTUDENT','4972',to_date('09-JUN-81','DD-MON-RR'),'379',null,'455');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6475','SANTE UGO','ENGINEER','6247',to_date('09-JUN-81','DD-MON-RR'),'933',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6476','LEVI LUIGI','PHDSTUDENT','970',to_date('09-JUN-81','DD-MON-RR'),'97',null,'54');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6477','COZZA PASQUALE','TECHNICIAN','3537',to_date('09-JUN-81','DD-MON-RR'),'1521',null,'12');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6478','ECO DONATO','MANAGER','3664',to_date('09-JUN-81','DD-MON-RR'),'832',null,'276');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6479','COZZA SILVIA','LAWYER','281',to_date('09-JUN-81','DD-MON-RR'),'1106',null,'195');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6480','ECO PASQUALE','PROFESSOR','4911',to_date('09-JUN-81','DD-MON-RR'),'625',null,'110');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6481','DANTE LUCIA','SECRETARY','1545',to_date('09-JUN-81','DD-MON-RR'),'1052',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6482','CORONA ELENA','PHDSTUDENT','3288',to_date('09-JUN-81','DD-MON-RR'),'1152',null,'326');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6483','PETRARCA MARIA','PROFESSOR','748',to_date('09-JUN-81','DD-MON-RR'),'1186',null,'62');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6484','SANTE LUCA','HEADMASTER','5635',to_date('09-JUN-81','DD-MON-RR'),'1429',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6485','FO GAETANO','TECHNICIAN','93',to_date('09-JUN-81','DD-MON-RR'),'853',null,'62');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6486','FO ANTONIO','HEADMASTER','3847',to_date('09-JUN-81','DD-MON-RR'),'520',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6487','NERI GIOVANNI','SUPERVISOR','5778',to_date('09-JUN-81','DD-MON-RR'),'231',null,'316');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6488','GRIMALDI PAOLO','SECRETARY','1634',to_date('09-JUN-81','DD-MON-RR'),'1527',null,'126');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6489','LEOPARDI LUIGI','TECHNICIAN','1865',to_date('09-JUN-81','DD-MON-RR'),'603',null,'319');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6490','GRIMALDI MASSIMO','MANAGER','3651',to_date('09-JUN-81','DD-MON-RR'),'1150',null,'367');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6491','FO DAMIANO','PHDSTUDENT','1215',to_date('09-JUN-81','DD-MON-RR'),'809',null,'8');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6492','ESPOSITO ANGELO','TECHNICIAN','1755',to_date('09-JUN-81','DD-MON-RR'),'589',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6493','PETRARCA IVANO','TECHNICIAN','3660',to_date('09-JUN-81','DD-MON-RR'),'179',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6494','CORONA ELENA','PROFESSOR','4819',to_date('09-JUN-81','DD-MON-RR'),'1508',null,'443');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6495','GRIMALDI MARIA','SUPERVISOR','4480',to_date('09-JUN-81','DD-MON-RR'),'136',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6496','FUMAROLA MARIO','HEADMASTER','1178',to_date('09-JUN-81','DD-MON-RR'),'1884',null,'120');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6497','CORONA COSIMO','LAWYER','5345',to_date('09-JUN-81','DD-MON-RR'),'852',null,'469');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6498','BIANCHI DAMIANO','SUPERVISOR','6185',to_date('09-JUN-81','DD-MON-RR'),'1787',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6499','LEOPARDI PASQUALE','PHDSTUDENT','4484',to_date('09-JUN-81','DD-MON-RR'),'906',null,'44');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6500','TIBALDI CLARA','MANAGER','164',to_date('09-JUN-81','DD-MON-RR'),'1048',null,'331');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6501','ESPOSITO CLARA','ENGINEER','5746',to_date('09-JUN-81','DD-MON-RR'),'261',null,'179');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6502','CORONA COSIMO','LAWYER','4993',to_date('09-JUN-81','DD-MON-RR'),'302',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6503','SANTE ANGELO','MANAGER','3147',to_date('09-JUN-81','DD-MON-RR'),'1332',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6504','LEVI ANTONIO','MANAGER','4455',to_date('09-JUN-81','DD-MON-RR'),'922',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('277','ECO FRANCESCO','ENGINEER','63',to_date('09-JUN-81','DD-MON-RR'),'254',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('278','CARBONE COSIMO','SUPERVISOR','15',to_date('09-JUN-81','DD-MON-RR'),'135',null,'427');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('279','FUMAROLA FRANCESCO','LAWYER','193',to_date('09-JUN-81','DD-MON-RR'),'1937',null,'471');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('280','LEVI UMBERTO','MANAGER','20',to_date('09-JUN-81','DD-MON-RR'),'1623',null,'354');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('281','PETRARCA ROBERTA','SECRETARY','224',to_date('09-JUN-81','DD-MON-RR'),'1415',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('282','ESPOSITO GIOVANNI','SECRETARY','180',to_date('09-JUN-81','DD-MON-RR'),'594',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('283','ECO UGO','ENGINEER','125',to_date('09-JUN-81','DD-MON-RR'),'0',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('284','CORONA UMBERTO','MANAGER','56',to_date('09-JUN-81','DD-MON-RR'),'579',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('285','CALVINO FEDERICO','MANAGER','248',to_date('09-JUN-81','DD-MON-RR'),'724',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('286','DANTE MARIO','PROFESSOR','37',to_date('09-JUN-81','DD-MON-RR'),'1205',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('287','FO FEDERICO','MANAGER','173',to_date('09-JUN-81','DD-MON-RR'),'1104',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('288','FO ELIO','HEADMASTER','280',to_date('09-JUN-81','DD-MON-RR'),'1738',null,'179');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('289','CARBONE LUDOVICO','SUPERVISOR','10',to_date('09-JUN-81','DD-MON-RR'),'731',null,'122');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('290','ESPOSITO LUIGI','SUPERVISOR','245',to_date('09-JUN-81','DD-MON-RR'),'761',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('291','LEVI UGO','ENGINEER','265',to_date('09-JUN-81','DD-MON-RR'),'184',null,'151');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('292','FUMAROLA ELENA','SECRETARY','22',to_date('09-JUN-81','DD-MON-RR'),'263',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('293','MANZONI ALFONSO','ENGINEER','248',to_date('09-JUN-81','DD-MON-RR'),'13',null,'32');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('294','CALVINO ELENA','TECHNICIAN','47',to_date('09-JUN-81','DD-MON-RR'),'315',null,'299');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('295','PETRARCA LUCA','PHDSTUDENT','277',to_date('09-JUN-81','DD-MON-RR'),'1867',null,'243');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('296','FO COSIMO','PROFESSOR','159',to_date('09-JUN-81','DD-MON-RR'),'837',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('297','CARBONE GAETANO','ENGINEER','17',to_date('09-JUN-81','DD-MON-RR'),'910',null,'99');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('298','LEVI PAOLO','PROFESSOR','7',to_date('09-JUN-81','DD-MON-RR'),'1582',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('299','BIANCHI ALFONSO','SUPERVISOR','95',to_date('09-JUN-81','DD-MON-RR'),'314',null,'258');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('300','DANTE DAMIANO','ENGINEER','7',to_date('09-JUN-81','DD-MON-RR'),'1008',null,'269');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('301','NERI ANGELO','MANAGER','289',to_date('09-JUN-81','DD-MON-RR'),'1762',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('302','SANTE DONATO','TECHNICIAN','172',to_date('09-JUN-81','DD-MON-RR'),'1566',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('303','COZZA MARIO','PHDSTUDENT','0',to_date('09-JUN-81','DD-MON-RR'),'1272',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('304','ECO GIOVANNI','LAWYER','183',to_date('09-JUN-81','DD-MON-RR'),'91',null,'93');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('305','MANZONI LUDOVICO','LAWYER','221',to_date('09-JUN-81','DD-MON-RR'),'1983',null,'127');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('306','BIANCHI ALFONSO','LAWYER','94',to_date('09-JUN-81','DD-MON-RR'),'932',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('307','ESPOSITO LUCIA','TECHNICIAN','189',to_date('09-JUN-81','DD-MON-RR'),'1078',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('308','CARBONE FEDERICO','TECHNICIAN','48',to_date('09-JUN-81','DD-MON-RR'),'624',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('309','ESPOSITO IVANO','HEADMASTER','68',to_date('09-JUN-81','DD-MON-RR'),'313',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('310','CORONA ANTONIO','ENGINEER','49',to_date('09-JUN-81','DD-MON-RR'),'3',null,'481');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('311','DANTE MASSIMO','SUPERVISOR','4',to_date('09-JUN-81','DD-MON-RR'),'1153',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('312','LEVI UGO','MANAGER','217',to_date('09-JUN-81','DD-MON-RR'),'1935',null,'220');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('313','FUMAROLA ALFONSO','HEADMASTER','87',to_date('09-JUN-81','DD-MON-RR'),'80',null,'31');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('314','CARBONE ANDREA','SECRETARY','149',to_date('09-JUN-81','DD-MON-RR'),'904',null,'387');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('315','PETRARCA COSIMO','PHDSTUDENT','142',to_date('09-JUN-81','DD-MON-RR'),'43',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('316','COZZA SILVIA','HEADMASTER','278',to_date('09-JUN-81','DD-MON-RR'),'902',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('317','ESPOSITO CLARA','MANAGER','227',to_date('09-JUN-81','DD-MON-RR'),'1279',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('318','ECO MASSIMO','TECHNICIAN','289',to_date('09-JUN-81','DD-MON-RR'),'1204',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('319','FO LUCA','SECRETARY','189',to_date('09-JUN-81','DD-MON-RR'),'1185',null,'410');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('320','MANZONI GAETANO','ENGINEER','134',to_date('09-JUN-81','DD-MON-RR'),'1051',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('321','DANTE DONATO','MANAGER','254',to_date('09-JUN-81','DD-MON-RR'),'1646',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('322','PETRARCA MASSIMO','MANAGER','301',to_date('09-JUN-81','DD-MON-RR'),'715',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('323','TIBALDI GIOVANNI','PHDSTUDENT','80',to_date('09-JUN-81','DD-MON-RR'),'858',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('324','CORONA LUCA','PHDSTUDENT','245',to_date('09-JUN-81','DD-MON-RR'),'1994',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('325','CORONA ELIO','MANAGER','85',to_date('09-JUN-81','DD-MON-RR'),'1571',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('326','ECO ROBERTA','ENGINEER','35',to_date('09-JUN-81','DD-MON-RR'),'103',null,'87');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('327','ECO SILVIA','SUPERVISOR','78',to_date('09-JUN-81','DD-MON-RR'),'1356',null,'86');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('328','ECO UGO','PROFESSOR','300',to_date('09-JUN-81','DD-MON-RR'),'160',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('329','CARBONE UMBERTO','ENGINEER','77',to_date('09-JUN-81','DD-MON-RR'),'451',null,'260');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('330','CORONA SILVIA','SECRETARY','308',to_date('09-JUN-81','DD-MON-RR'),'133',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('331','SANTE ANTONIO','LAWYER','231',to_date('09-JUN-81','DD-MON-RR'),'283',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('332','SANTE LUIGI','MANAGER','229',to_date('09-JUN-81','DD-MON-RR'),'165',null,'201');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('333','CALVINO PASQUALE','TECHNICIAN','184',to_date('09-JUN-81','DD-MON-RR'),'830',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('334','CORONA ANTONIO','MANAGER','65',to_date('09-JUN-81','DD-MON-RR'),'1339',null,'3');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('335','ESPOSITO LUIGI','MANAGER','202',to_date('09-JUN-81','DD-MON-RR'),'1306',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('336','GRIMALDI MARIA','MANAGER','70',to_date('09-JUN-81','DD-MON-RR'),'1398',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('337','ESPOSITO CLARA','PROFESSOR','309',to_date('09-JUN-81','DD-MON-RR'),'528',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('338','GRIMALDI FEDERICO','MANAGER','187',to_date('09-JUN-81','DD-MON-RR'),'1362',null,'447');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('339','DANTE ANDREA','PROFESSOR','220',to_date('09-JUN-81','DD-MON-RR'),'1104',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('340','CALVINO FRANCESCO','ENGINEER','159',to_date('09-JUN-81','DD-MON-RR'),'1751',null,'185');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('341','CORONA FEDERICO','ENGINEER','89',to_date('09-JUN-81','DD-MON-RR'),'725',null,'34');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('342','ECO ELENA','SUPERVISOR','73',to_date('09-JUN-81','DD-MON-RR'),'945',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('343','ECO LUIGI','TECHNICIAN','231',to_date('09-JUN-81','DD-MON-RR'),'693',null,'358');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('344','CALVINO CLARA','PROFESSOR','309',to_date('09-JUN-81','DD-MON-RR'),'1727',null,'311');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('345','CALVINO ALFONSO','ENGINEER','212',to_date('09-JUN-81','DD-MON-RR'),'1979',null,'385');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('346','LEOPARDI DAMIANO','HEADMASTER','123',to_date('09-JUN-81','DD-MON-RR'),'1200',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('347','TIBALDI MARIA','TECHNICIAN','24',to_date('09-JUN-81','DD-MON-RR'),'260',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('348','ESPOSITO ANGELO','MANAGER','5',to_date('09-JUN-81','DD-MON-RR'),'0',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('349','GRIMALDI IVANO','PROFESSOR','280',to_date('09-JUN-81','DD-MON-RR'),'941',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('350','FO LUIGI','MANAGER','112',to_date('09-JUN-81','DD-MON-RR'),'1968',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('351','MANZONI GIOVANNI','ENGINEER','5',to_date('09-JUN-81','DD-MON-RR'),'653',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('352','CALVINO PAOLO','MANAGER','51',to_date('09-JUN-81','DD-MON-RR'),'1648',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('353','LEOPARDI ANDREA','SUPERVISOR','201',to_date('09-JUN-81','DD-MON-RR'),'1635',null,'176');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('354','CARBONE ANGELO','LAWYER','246',to_date('09-JUN-81','DD-MON-RR'),'706',null,'197');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('355','CALVINO DONATO','TECHNICIAN','100',to_date('09-JUN-81','DD-MON-RR'),'206',null,'374');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('356','BIANCHI LUCIA','SUPERVISOR','252',to_date('09-JUN-81','DD-MON-RR'),'425',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('357','MANZONI IVANO','MANAGER','210',to_date('09-JUN-81','DD-MON-RR'),'1326',null,'311');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('358','PETRARCA LUDOVICO','MANAGER','347',to_date('09-JUN-81','DD-MON-RR'),'1389',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('359','DANTE GIOVANNI','PHDSTUDENT','90',to_date('09-JUN-81','DD-MON-RR'),'829',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('360','FO SILVIA','HEADMASTER','147',to_date('09-JUN-81','DD-MON-RR'),'1849',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('361','DANTE UGO','LAWYER','316',to_date('09-JUN-81','DD-MON-RR'),'1917',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('362','FUMAROLA GIOVANNI','SUPERVISOR','260',to_date('09-JUN-81','DD-MON-RR'),'477',null,'308');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('363','MANZONI MASSIMO','LAWYER','279',to_date('09-JUN-81','DD-MON-RR'),'1657',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('364','NERI LUCIA','ENGINEER','292',to_date('09-JUN-81','DD-MON-RR'),'811',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('365','LEOPARDI UGO','TECHNICIAN','320',to_date('09-JUN-81','DD-MON-RR'),'924',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('366','CARBONE DONATO','MANAGER','48',to_date('09-JUN-81','DD-MON-RR'),'994',null,'174');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('367','CORONA UGO','SECRETARY','192',to_date('09-JUN-81','DD-MON-RR'),'279',null,'118');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('368','CALVINO ROBERTA','TECHNICIAN','325',to_date('09-JUN-81','DD-MON-RR'),'503',null,'461');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('369','GRIMALDI LUDOVICO','SUPERVISOR','176',to_date('09-JUN-81','DD-MON-RR'),'136',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('370','CORONA ROBERTA','SECRETARY','98',to_date('09-JUN-81','DD-MON-RR'),'1791',null,'498');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('371','SANTE ROBERTA','MANAGER','295',to_date('09-JUN-81','DD-MON-RR'),'1868',null,'57');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('372','COZZA FEDERICO','LAWYER','53',to_date('09-JUN-81','DD-MON-RR'),'57',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('373','LEVI LUIGI','HEADMASTER','176',to_date('09-JUN-81','DD-MON-RR'),'111',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('374','FUMAROLA DAMIANO','SUPERVISOR','177',to_date('09-JUN-81','DD-MON-RR'),'1712',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('375','ESPOSITO CLARA','MANAGER','184',to_date('09-JUN-81','DD-MON-RR'),'344',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('376','FUMAROLA LUIGI','LAWYER','39',to_date('09-JUN-81','DD-MON-RR'),'745',null,'196');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('377','ECO SILVIA','SUPERVISOR','284',to_date('09-JUN-81','DD-MON-RR'),'1320',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('378','CALVINO GIOVANNI','TECHNICIAN','221',to_date('09-JUN-81','DD-MON-RR'),'1026',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('379','CORONA FEDERICO','HEADMASTER','252',to_date('09-JUN-81','DD-MON-RR'),'765',null,'193');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('380','ECO MARIA','PHDSTUDENT','63',to_date('09-JUN-81','DD-MON-RR'),'1663',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('381','ECO ANGELO','MANAGER','107',to_date('09-JUN-81','DD-MON-RR'),'854',null,'207');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('382','LEVI ELIO','MANAGER','217',to_date('09-JUN-81','DD-MON-RR'),'806',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('383','LEOPARDI LUDOVICO','PROFESSOR','226',to_date('09-JUN-81','DD-MON-RR'),'834',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('384','LEVI UGO','PROFESSOR','104',to_date('09-JUN-81','DD-MON-RR'),'157',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('385','CALVINO LUIGI','MANAGER','366',to_date('09-JUN-81','DD-MON-RR'),'1311',null,'304');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('386','ESPOSITO MARIO','HEADMASTER','177',to_date('09-JUN-81','DD-MON-RR'),'1523',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('387','ECO ROBERTA','HEADMASTER','312',to_date('09-JUN-81','DD-MON-RR'),'11',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('388','FO ELIO','HEADMASTER','12',to_date('09-JUN-81','DD-MON-RR'),'185',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('389','PETRARCA ANTONIO','PROFESSOR','89',to_date('09-JUN-81','DD-MON-RR'),'219',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('390','DANTE ELENA','HEADMASTER','173',to_date('09-JUN-81','DD-MON-RR'),'1441',null,'145');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('391','COZZA ROBERTA','ENGINEER','384',to_date('09-JUN-81','DD-MON-RR'),'1193',null,'265');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('392','TIBALDI LUCA','SUPERVISOR','135',to_date('09-JUN-81','DD-MON-RR'),'553',null,'486');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('393','PETRARCA FEDERICO','PROFESSOR','390',to_date('09-JUN-81','DD-MON-RR'),'1413',null,'283');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('394','ECO DONATO','MANAGER','284',to_date('09-JUN-81','DD-MON-RR'),'226',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('395','CORONA LUIGI','SUPERVISOR','199',to_date('09-JUN-81','DD-MON-RR'),'453',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('396','DANTE CLARA','SECRETARY','223',to_date('09-JUN-81','DD-MON-RR'),'529',null,'368');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('397','MANZONI DONATO','PROFESSOR','25',to_date('09-JUN-81','DD-MON-RR'),'1904',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('398','SANTE UGO','PHDSTUDENT','203',to_date('09-JUN-81','DD-MON-RR'),'1402',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('399','FO PASQUALE','MANAGER','192',to_date('09-JUN-81','DD-MON-RR'),'147',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('400','PETRARCA UGO','LAWYER','111',to_date('09-JUN-81','DD-MON-RR'),'893',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('401','CORONA PASQUALE','PHDSTUDENT','168',to_date('09-JUN-81','DD-MON-RR'),'1612',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('402','PETRARCA ANGELO','PHDSTUDENT','147',to_date('09-JUN-81','DD-MON-RR'),'1934',null,'487');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('403','FUMAROLA CLARA','HEADMASTER','4',to_date('09-JUN-81','DD-MON-RR'),'1033',null,'191');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('404','CARBONE FRANCESCO','PHDSTUDENT','253',to_date('09-JUN-81','DD-MON-RR'),'158',null,'404');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('405','FUMAROLA LUCIA','TECHNICIAN','54',to_date('09-JUN-81','DD-MON-RR'),'704',null,'99');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('406','SANTE ANTONIO','SECRETARY','64',to_date('09-JUN-81','DD-MON-RR'),'107',null,'123');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('407','PETRARCA ELENA','PHDSTUDENT','243',to_date('09-JUN-81','DD-MON-RR'),'1156',null,'58');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('408','DANTE LUDOVICO','ENGINEER','103',to_date('09-JUN-81','DD-MON-RR'),'880',null,'319');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('409','MANZONI MASSIMO','PROFESSOR','151',to_date('09-JUN-81','DD-MON-RR'),'1892',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('410','PETRARCA FEDERICO','SUPERVISOR','382',to_date('09-JUN-81','DD-MON-RR'),'1144',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('411','LEOPARDI DONATO','MANAGER','235',to_date('09-JUN-81','DD-MON-RR'),'1472',null,'213');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('412','BIANCHI GAETANO','ENGINEER','398',to_date('09-JUN-81','DD-MON-RR'),'1815',null,'108');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('550','ECO DAMIANO','MANAGER','314',to_date('09-JUN-81','DD-MON-RR'),'1374',null,'216');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2840','CARBONE ANTONIO','PHDSTUDENT','1015',to_date('09-JUN-81','DD-MON-RR'),'1946',null,'485');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2841','FUMAROLA LUCA','SECRETARY','591',to_date('09-JUN-81','DD-MON-RR'),'1890',null,'57');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2842','GRIMALDI MARIO','MANAGER','334',to_date('09-JUN-81','DD-MON-RR'),'1697',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2843','BIANCHI MASSIMO','TECHNICIAN','2201',to_date('09-JUN-81','DD-MON-RR'),'303',null,'34');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2844','BIANCHI PAOLO','PROFESSOR','2139',to_date('09-JUN-81','DD-MON-RR'),'1779',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2845','NERI PASQUALE','SECRETARY','2244',to_date('09-JUN-81','DD-MON-RR'),'1062',null,'168');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2846','CALVINO ANTONIO','LAWYER','2744',to_date('09-JUN-81','DD-MON-RR'),'415',null,'172');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2847','TIBALDI PAOLO','LAWYER','1041',to_date('09-JUN-81','DD-MON-RR'),'977',null,'102');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2848','LEOPARDI ANDREA','SUPERVISOR','2637',to_date('09-JUN-81','DD-MON-RR'),'1616',null,'146');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2849','SANTE ELENA','MANAGER','2775',to_date('09-JUN-81','DD-MON-RR'),'1220',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2850','FO ANGELO','MANAGER','1889',to_date('09-JUN-81','DD-MON-RR'),'1451',null,'394');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2851','NERI MARIA','ENGINEER','1141',to_date('09-JUN-81','DD-MON-RR'),'901',null,'498');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2852','BIANCHI LUCA','MANAGER','289',to_date('09-JUN-81','DD-MON-RR'),'1790',null,'427');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2853','CALVINO PAOLO','HEADMASTER','1276',to_date('09-JUN-81','DD-MON-RR'),'525',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2854','FUMAROLA PASQUALE','MANAGER','2665',to_date('09-JUN-81','DD-MON-RR'),'464',null,'83');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2855','LEOPARDI LUCIA','PROFESSOR','785',to_date('09-JUN-81','DD-MON-RR'),'387',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2856','LEOPARDI DAMIANO','TECHNICIAN','2432',to_date('09-JUN-81','DD-MON-RR'),'1189',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2857','CARBONE CLARA','PHDSTUDENT','614',to_date('09-JUN-81','DD-MON-RR'),'883',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2858','LEVI COSIMO','PHDSTUDENT','2744',to_date('09-JUN-81','DD-MON-RR'),'391',null,'394');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2859','LEVI LUDOVICO','MANAGER','613',to_date('09-JUN-81','DD-MON-RR'),'1739',null,'139');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2860','PETRARCA LUDOVICO','MANAGER','1384',to_date('09-JUN-81','DD-MON-RR'),'324',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2861','NERI DONATO','PROFESSOR','1796',to_date('09-JUN-81','DD-MON-RR'),'155',null,'396');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2862','CALVINO COSIMO','LAWYER','1971',to_date('09-JUN-81','DD-MON-RR'),'281',null,'287');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2863','SANTE LUDOVICO','PROFESSOR','1163',to_date('09-JUN-81','DD-MON-RR'),'342',null,'259');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2336','FUMAROLA LUCA','PHDSTUDENT','1777',to_date('09-JUN-81','DD-MON-RR'),'279',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2337','GRIMALDI DONATO','HEADMASTER','497',to_date('09-JUN-81','DD-MON-RR'),'1021',null,'386');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2338','DANTE MARIO','MANAGER','1277',to_date('09-JUN-81','DD-MON-RR'),'169',null,'166');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2339','CORONA GIOVANNI','MANAGER','1318',to_date('09-JUN-81','DD-MON-RR'),'464',null,'86');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2340','DANTE PAOLO','SUPERVISOR','1648',to_date('09-JUN-81','DD-MON-RR'),'487',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2341','ESPOSITO UMBERTO','SECRETARY','375',to_date('09-JUN-81','DD-MON-RR'),'17',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2342','LEOPARDI MASSIMO','PHDSTUDENT','1769',to_date('09-JUN-81','DD-MON-RR'),'1586',null,'415');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2343','FUMAROLA ALFONSO','MANAGER','834',to_date('09-JUN-81','DD-MON-RR'),'685',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2344','NERI PAOLO','LAWYER','1394',to_date('09-JUN-81','DD-MON-RR'),'775',null,'495');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2345','TIBALDI LUCIA','MANAGER','1341',to_date('09-JUN-81','DD-MON-RR'),'1690',null,'108');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2346','TIBALDI CLARA','TECHNICIAN','500',to_date('09-JUN-81','DD-MON-RR'),'1',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2347','ESPOSITO MASSIMO','SUPERVISOR','2012',to_date('09-JUN-81','DD-MON-RR'),'103',null,'423');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2348','MANZONI GAETANO','MANAGER','1491',to_date('09-JUN-81','DD-MON-RR'),'1872',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2349','TIBALDI SILVIA','PROFESSOR','1002',to_date('09-JUN-81','DD-MON-RR'),'440',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2350','DANTE ANDREA','TECHNICIAN','921',to_date('09-JUN-81','DD-MON-RR'),'1121',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2351','COZZA ANTONIO','HEADMASTER','175',to_date('09-JUN-81','DD-MON-RR'),'1607',null,'12');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2352','DANTE ALFONSO','MANAGER','1417',to_date('09-JUN-81','DD-MON-RR'),'397',null,'186');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2353','CALVINO MARIO','SUPERVISOR','220',to_date('09-JUN-81','DD-MON-RR'),'1044',null,'444');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2354','GRIMALDI GAETANO','PHDSTUDENT','2093',to_date('09-JUN-81','DD-MON-RR'),'1232',null,'367');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2355','ESPOSITO DONATO','SUPERVISOR','1003',to_date('09-JUN-81','DD-MON-RR'),'852',null,'142');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2356','ECO LUIGI','LAWYER','1496',to_date('09-JUN-81','DD-MON-RR'),'221',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2357','ECO LUDOVICO','MANAGER','2313',to_date('09-JUN-81','DD-MON-RR'),'523',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2358','LEVI ROBERTA','MANAGER','724',to_date('09-JUN-81','DD-MON-RR'),'1610',null,'313');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2359','LEVI LUCIA','PHDSTUDENT','1677',to_date('09-JUN-81','DD-MON-RR'),'1548',null,'216');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2360','ESPOSITO DAMIANO','ENGINEER','400',to_date('09-JUN-81','DD-MON-RR'),'576',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2361','CALVINO ELIO','MANAGER','775',to_date('09-JUN-81','DD-MON-RR'),'1067',null,'20');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2362','CORONA MASSIMO','PHDSTUDENT','63',to_date('09-JUN-81','DD-MON-RR'),'351',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2363','LEOPARDI MASSIMO','SECRETARY','826',to_date('09-JUN-81','DD-MON-RR'),'1674',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2364','NERI GIOVANNI','PROFESSOR','1877',to_date('09-JUN-81','DD-MON-RR'),'1489',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2365','COZZA ALFONSO','LAWYER','1642',to_date('09-JUN-81','DD-MON-RR'),'721',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2366','COZZA MARIO','HEADMASTER','1226',to_date('09-JUN-81','DD-MON-RR'),'286',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2367','SANTE PASQUALE','PHDSTUDENT','611',to_date('09-JUN-81','DD-MON-RR'),'354',null,'45');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2368','FO SILVIA','PHDSTUDENT','2113',to_date('09-JUN-81','DD-MON-RR'),'1543',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2369','ESPOSITO MASSIMO','SECRETARY','1740',to_date('09-JUN-81','DD-MON-RR'),'1086',null,'118');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2370','TIBALDI PAOLO','PHDSTUDENT','2067',to_date('09-JUN-81','DD-MON-RR'),'930',null,'393');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2371','DANTE MASSIMO','LAWYER','823',to_date('09-JUN-81','DD-MON-RR'),'1143',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2372','COZZA DONATO','SECRETARY','2329',to_date('09-JUN-81','DD-MON-RR'),'777',null,'36');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2373','COZZA ALFONSO','SECRETARY','1642',to_date('09-JUN-81','DD-MON-RR'),'1001',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2374','BIANCHI PASQUALE','LAWYER','1521',to_date('09-JUN-81','DD-MON-RR'),'1213',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2375','CORONA COSIMO','SUPERVISOR','722',to_date('09-JUN-81','DD-MON-RR'),'703',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2376','ESPOSITO IVANO','SECRETARY','1649',to_date('09-JUN-81','DD-MON-RR'),'1718',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2377','COZZA ANDREA','SECRETARY','797',to_date('09-JUN-81','DD-MON-RR'),'1817',null,'469');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2378','FUMAROLA GIOVANNI','ENGINEER','2148',to_date('09-JUN-81','DD-MON-RR'),'1347',null,'24');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2379','DANTE UMBERTO','PHDSTUDENT','442',to_date('09-JUN-81','DD-MON-RR'),'928',null,'263');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2380','CORONA DONATO','HEADMASTER','178',to_date('09-JUN-81','DD-MON-RR'),'1292',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2381','MANZONI ELENA','ENGINEER','1710',to_date('09-JUN-81','DD-MON-RR'),'864',null,'364');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2382','FUMAROLA MASSIMO','SECRETARY','1640',to_date('09-JUN-81','DD-MON-RR'),'414',null,'282');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2383','CARBONE FEDERICO','MANAGER','418',to_date('09-JUN-81','DD-MON-RR'),'1039',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2384','NERI GAETANO','HEADMASTER','344',to_date('09-JUN-81','DD-MON-RR'),'1752',null,'253');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2385','LEOPARDI FEDERICO','LAWYER','1616',to_date('09-JUN-81','DD-MON-RR'),'1393',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2386','FO GIOVANNI','PROFESSOR','2159',to_date('09-JUN-81','DD-MON-RR'),'569',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2387','ECO UMBERTO','MANAGER','689',to_date('09-JUN-81','DD-MON-RR'),'224',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2388','CORONA DONATO','TECHNICIAN','953',to_date('09-JUN-81','DD-MON-RR'),'1831',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2389','COZZA SILVIA','SUPERVISOR','1579',to_date('09-JUN-81','DD-MON-RR'),'568',null,'222');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2390','LEVI UGO','MANAGER','40',to_date('09-JUN-81','DD-MON-RR'),'1266',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2391','BIANCHI UGO','ENGINEER','1780',to_date('09-JUN-81','DD-MON-RR'),'1146',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2392','FUMAROLA ELIO','TECHNICIAN','2263',to_date('09-JUN-81','DD-MON-RR'),'992',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2393','MANZONI ANTONIO','LAWYER','120',to_date('09-JUN-81','DD-MON-RR'),'1497',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2394','TIBALDI ANGELO','MANAGER','1196',to_date('09-JUN-81','DD-MON-RR'),'56',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2395','LEOPARDI LUDOVICO','SUPERVISOR','30',to_date('09-JUN-81','DD-MON-RR'),'427',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2396','CALVINO FEDERICO','HEADMASTER','256',to_date('09-JUN-81','DD-MON-RR'),'940',null,'30');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2397','FUMAROLA CLARA','SECRETARY','1824',to_date('09-JUN-81','DD-MON-RR'),'1652',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2398','TIBALDI COSIMO','HEADMASTER','1925',to_date('09-JUN-81','DD-MON-RR'),'1133',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2399','FUMAROLA LUCIA','SUPERVISOR','1334',to_date('09-JUN-81','DD-MON-RR'),'1993',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2400','PETRARCA GIOVANNI','TECHNICIAN','2336',to_date('09-JUN-81','DD-MON-RR'),'1909',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2401','CALVINO LUCA','LAWYER','674',to_date('09-JUN-81','DD-MON-RR'),'1676',null,'432');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2402','NERI PAOLO','MANAGER','1467',to_date('09-JUN-81','DD-MON-RR'),'643',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2403','CALVINO GIOVANNI','SUPERVISOR','1178',to_date('09-JUN-81','DD-MON-RR'),'72',null,'326');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2404','ESPOSITO MARIO','TECHNICIAN','1404',to_date('09-JUN-81','DD-MON-RR'),'404',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2405','FUMAROLA FRANCESCO','PHDSTUDENT','717',to_date('09-JUN-81','DD-MON-RR'),'1924',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2406','LEOPARDI LUCIA','PROFESSOR','869',to_date('09-JUN-81','DD-MON-RR'),'72',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2407','FO LUIGI','MANAGER','2335',to_date('09-JUN-81','DD-MON-RR'),'1979',null,'248');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2408','LEOPARDI DAMIANO','PROFESSOR','1510',to_date('09-JUN-81','DD-MON-RR'),'1712',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2409','DANTE FRANCESCO','PROFESSOR','1039',to_date('09-JUN-81','DD-MON-RR'),'1588',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2410','GRIMALDI UGO','SUPERVISOR','1611',to_date('09-JUN-81','DD-MON-RR'),'1870',null,'283');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2411','BIANCHI GIOVANNI','HEADMASTER','1180',to_date('09-JUN-81','DD-MON-RR'),'527',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2412','ESPOSITO MARIA','ENGINEER','671',to_date('09-JUN-81','DD-MON-RR'),'919',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2413','ESPOSITO MARIO','SECRETARY','1219',to_date('09-JUN-81','DD-MON-RR'),'1254',null,'474');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2414','FUMAROLA FEDERICO','SECRETARY','1652',to_date('09-JUN-81','DD-MON-RR'),'678',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2415','TIBALDI PASQUALE','MANAGER','2180',to_date('09-JUN-81','DD-MON-RR'),'1174',null,'262');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2416','CARBONE MARIA','PHDSTUDENT','1908',to_date('09-JUN-81','DD-MON-RR'),'1580',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2417','BIANCHI LUIGI','SUPERVISOR','2137',to_date('09-JUN-81','DD-MON-RR'),'345',null,'320');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2418','FO UGO','SUPERVISOR','1699',to_date('09-JUN-81','DD-MON-RR'),'906',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2419','MANZONI SILVIA','MANAGER','1960',to_date('09-JUN-81','DD-MON-RR'),'819',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2420','FO LUDOVICO','PHDSTUDENT','854',to_date('09-JUN-81','DD-MON-RR'),'1223',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2421','GRIMALDI GAETANO','PHDSTUDENT','740',to_date('09-JUN-81','DD-MON-RR'),'1740',null,'55');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2422','LEVI ELIO','TECHNICIAN','430',to_date('09-JUN-81','DD-MON-RR'),'1804',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2423','LEOPARDI GIOVANNI','SECRETARY','1111',to_date('09-JUN-81','DD-MON-RR'),'431',null,'289');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2424','COZZA SILVIA','SUPERVISOR','2185',to_date('09-JUN-81','DD-MON-RR'),'1355',null,'356');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2425','TIBALDI MARIA','ENGINEER','2059',to_date('09-JUN-81','DD-MON-RR'),'1589',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2426','CORONA DONATO','TECHNICIAN','460',to_date('09-JUN-81','DD-MON-RR'),'1958',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2427','NERI COSIMO','MANAGER','742',to_date('09-JUN-81','DD-MON-RR'),'307',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2428','FUMAROLA GIOVANNI','HEADMASTER','1477',to_date('09-JUN-81','DD-MON-RR'),'861',null,'316');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2429','DANTE PAOLO','SECRETARY','1190',to_date('09-JUN-81','DD-MON-RR'),'116',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2430','BIANCHI MARIO','MANAGER','1519',to_date('09-JUN-81','DD-MON-RR'),'646',null,'207');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2431','BIANCHI MASSIMO','MANAGER','1878',to_date('09-JUN-81','DD-MON-RR'),'765',null,'33');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2432','FO MARIA','HEADMASTER','1845',to_date('09-JUN-81','DD-MON-RR'),'1978',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2433','BIANCHI IVANO','TECHNICIAN','193',to_date('09-JUN-81','DD-MON-RR'),'162',null,'299');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2434','TIBALDI ANTONIO','MANAGER','517',to_date('09-JUN-81','DD-MON-RR'),'1516',null,'407');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2435','TIBALDI ELIO','ENGINEER','24',to_date('09-JUN-81','DD-MON-RR'),'1173',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2436','CORONA ANGELO','MANAGER','1246',to_date('09-JUN-81','DD-MON-RR'),'37',null,'93');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2437','FO ANDREA','PROFESSOR','1511',to_date('09-JUN-81','DD-MON-RR'),'1067',null,'429');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2438','FO GAETANO','LAWYER','2401',to_date('09-JUN-81','DD-MON-RR'),'552',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2439','ECO PAOLO','SUPERVISOR','828',to_date('09-JUN-81','DD-MON-RR'),'402',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2440','LEOPARDI LUCIA','TECHNICIAN','1079',to_date('09-JUN-81','DD-MON-RR'),'1204',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2441','PETRARCA MARIA','ENGINEER','2096',to_date('09-JUN-81','DD-MON-RR'),'1076',null,'126');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2442','BIANCHI ROBERTA','PHDSTUDENT','2238',to_date('09-JUN-81','DD-MON-RR'),'1472',null,'280');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2443','COZZA DONATO','TECHNICIAN','267',to_date('09-JUN-81','DD-MON-RR'),'1074',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2444','ESPOSITO MARIA','SUPERVISOR','500',to_date('09-JUN-81','DD-MON-RR'),'922',null,'112');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2445','NERI SILVIA','ENGINEER','111',to_date('09-JUN-81','DD-MON-RR'),'114',null,'209');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2446','BIANCHI ALFONSO','SUPERVISOR','655',to_date('09-JUN-81','DD-MON-RR'),'1941',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4342','LEVI COSIMO','PROFESSOR','3338',to_date('09-JUN-81','DD-MON-RR'),'1698',null,'97');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4343','CARBONE ELENA','MANAGER','3700',to_date('09-JUN-81','DD-MON-RR'),'327',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4344','NERI FRANCESCO','HEADMASTER','2170',to_date('09-JUN-81','DD-MON-RR'),'1104',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4345','DANTE MARIA','PROFESSOR','3035',to_date('09-JUN-81','DD-MON-RR'),'724',null,'61');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4346','CORONA UGO','PROFESSOR','1530',to_date('09-JUN-81','DD-MON-RR'),'258',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4347','PETRARCA DAMIANO','SUPERVISOR','2191',to_date('09-JUN-81','DD-MON-RR'),'454',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4348','FO ALFONSO','SUPERVISOR','486',to_date('09-JUN-81','DD-MON-RR'),'1780',null,'278');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4349','ESPOSITO SILVIA','PROFESSOR','3946',to_date('09-JUN-81','DD-MON-RR'),'415',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4350','SANTE FRANCESCO','HEADMASTER','2502',to_date('09-JUN-81','DD-MON-RR'),'214',null,'423');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4351','ESPOSITO ANDREA','MANAGER','2633',to_date('09-JUN-81','DD-MON-RR'),'982',null,'96');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4352','LEVI ELIO','LAWYER','3380',to_date('09-JUN-81','DD-MON-RR'),'691',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4353','FUMAROLA DAMIANO','LAWYER','2525',to_date('09-JUN-81','DD-MON-RR'),'314',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4354','BIANCHI ELENA','TECHNICIAN','1070',to_date('09-JUN-81','DD-MON-RR'),'946',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4355','CARBONE ANGELO','MANAGER','1704',to_date('09-JUN-81','DD-MON-RR'),'1968',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4356','BIANCHI LUCIA','SECRETARY','1314',to_date('09-JUN-81','DD-MON-RR'),'574',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4357','SANTE GIOVANNI','SECRETARY','632',to_date('09-JUN-81','DD-MON-RR'),'560',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4358','PETRARCA ELIO','TECHNICIAN','4096',to_date('09-JUN-81','DD-MON-RR'),'94',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4359','CALVINO MARIO','TECHNICIAN','1138',to_date('09-JUN-81','DD-MON-RR'),'860',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4360','TIBALDI UGO','PHDSTUDENT','497',to_date('09-JUN-81','DD-MON-RR'),'1456',null,'344');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4361','SANTE ELENA','SECRETARY','3180',to_date('09-JUN-81','DD-MON-RR'),'537',null,'329');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4362','PETRARCA MARIO','MANAGER','1343',to_date('09-JUN-81','DD-MON-RR'),'1816',null,'221');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4363','LEVI MARIA','PHDSTUDENT','2023',to_date('09-JUN-81','DD-MON-RR'),'1743',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4364','COZZA COSIMO','SUPERVISOR','2376',to_date('09-JUN-81','DD-MON-RR'),'1758',null,'285');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4365','FUMAROLA GAETANO','MANAGER','2385',to_date('09-JUN-81','DD-MON-RR'),'1953',null,'318');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4366','MANZONI ANDREA','MANAGER','2652',to_date('09-JUN-81','DD-MON-RR'),'116',null,'436');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4367','FUMAROLA ROBERTA','SUPERVISOR','1875',to_date('09-JUN-81','DD-MON-RR'),'1928',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4368','CORONA ANGELO','MANAGER','3416',to_date('09-JUN-81','DD-MON-RR'),'1582',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4369','COZZA IVANO','SECRETARY','3846',to_date('09-JUN-81','DD-MON-RR'),'113',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4370','ESPOSITO LUCIA','SUPERVISOR','1578',to_date('09-JUN-81','DD-MON-RR'),'888',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4371','TIBALDI SILVIA','MANAGER','2636',to_date('09-JUN-81','DD-MON-RR'),'575',null,'36');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4372','DANTE ALFONSO','MANAGER','492',to_date('09-JUN-81','DD-MON-RR'),'1968',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4373','FUMAROLA LUCIA','TECHNICIAN','583',to_date('09-JUN-81','DD-MON-RR'),'1277',null,'405');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4374','BIANCHI DAMIANO','PHDSTUDENT','1958',to_date('09-JUN-81','DD-MON-RR'),'516',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4375','TIBALDI FEDERICO','MANAGER','9',to_date('09-JUN-81','DD-MON-RR'),'144',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4376','SANTE UGO','SECRETARY','3072',to_date('09-JUN-81','DD-MON-RR'),'1347',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4377','CORONA LUIGI','LAWYER','2205',to_date('09-JUN-81','DD-MON-RR'),'526',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4378','MANZONI IVANO','PHDSTUDENT','953',to_date('09-JUN-81','DD-MON-RR'),'107',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4379','FO DONATO','SECRETARY','1551',to_date('09-JUN-81','DD-MON-RR'),'1965',null,'181');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4380','SANTE PAOLO','MANAGER','65',to_date('09-JUN-81','DD-MON-RR'),'556',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4381','SANTE ANDREA','TECHNICIAN','624',to_date('09-JUN-81','DD-MON-RR'),'1336',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4382','NERI ELENA','PHDSTUDENT','356',to_date('09-JUN-81','DD-MON-RR'),'1894',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4383','CARBONE ELIO','ENGINEER','1752',to_date('09-JUN-81','DD-MON-RR'),'724',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4384','FUMAROLA IVANO','SUPERVISOR','1013',to_date('09-JUN-81','DD-MON-RR'),'1492',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4385','COZZA DONATO','ENGINEER','2929',to_date('09-JUN-81','DD-MON-RR'),'993',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4386','SANTE MARIO','SUPERVISOR','136',to_date('09-JUN-81','DD-MON-RR'),'755',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4387','GRIMALDI DAMIANO','LAWYER','4225',to_date('09-JUN-81','DD-MON-RR'),'587',null,'187');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4388','FO LUCA','TECHNICIAN','2158',to_date('09-JUN-81','DD-MON-RR'),'12',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4389','PETRARCA GAETANO','TECHNICIAN','2557',to_date('09-JUN-81','DD-MON-RR'),'727',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4390','ECO LUCA','PHDSTUDENT','1974',to_date('09-JUN-81','DD-MON-RR'),'1251',null,'498');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4391','FO PAOLO','SECRETARY','510',to_date('09-JUN-81','DD-MON-RR'),'942',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4392','CARBONE MASSIMO','LAWYER','2320',to_date('09-JUN-81','DD-MON-RR'),'712',null,'58');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4393','SANTE ROBERTA','SUPERVISOR','1854',to_date('09-JUN-81','DD-MON-RR'),'231',null,'364');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4394','CALVINO PASQUALE','MANAGER','2530',to_date('09-JUN-81','DD-MON-RR'),'935',null,'112');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4395','CORONA ANTONIO','ENGINEER','419',to_date('09-JUN-81','DD-MON-RR'),'591',null,'404');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4396','NERI LUDOVICO','SECRETARY','1429',to_date('09-JUN-81','DD-MON-RR'),'423',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4397','LEVI ANDREA','PROFESSOR','3336',to_date('09-JUN-81','DD-MON-RR'),'1682',null,'234');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4398','SANTE LUDOVICO','ENGINEER','2633',to_date('09-JUN-81','DD-MON-RR'),'332',null,'104');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4399','CORONA MASSIMO','PROFESSOR','835',to_date('09-JUN-81','DD-MON-RR'),'90',null,'280');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4400','LEOPARDI SILVIA','SUPERVISOR','2632',to_date('09-JUN-81','DD-MON-RR'),'1470',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4401','PETRARCA ROBERTA','SECRETARY','2889',to_date('09-JUN-81','DD-MON-RR'),'306',null,'5');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4402','GRIMALDI LUCA','MANAGER','2157',to_date('09-JUN-81','DD-MON-RR'),'1695',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4403','GRIMALDI MARIA','ENGINEER','234',to_date('09-JUN-81','DD-MON-RR'),'644',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4404','CALVINO FRANCESCO','ENGINEER','1568',to_date('09-JUN-81','DD-MON-RR'),'1680',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4405','PETRARCA COSIMO','LAWYER','1436',to_date('09-JUN-81','DD-MON-RR'),'1707',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4406','CALVINO MASSIMO','PROFESSOR','3652',to_date('09-JUN-81','DD-MON-RR'),'1835',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4407','GRIMALDI ELIO','PROFESSOR','723',to_date('09-JUN-81','DD-MON-RR'),'1569',null,'441');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4408','DANTE LUCIA','LAWYER','1050',to_date('09-JUN-81','DD-MON-RR'),'1595',null,'464');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4409','NERI UMBERTO','LAWYER','3785',to_date('09-JUN-81','DD-MON-RR'),'832',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4410','ECO ROBERTA','PROFESSOR','2994',to_date('09-JUN-81','DD-MON-RR'),'1320',null,'264');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4411','NERI CLARA','PROFESSOR','1934',to_date('09-JUN-81','DD-MON-RR'),'1038',null,'354');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4412','CORONA FEDERICO','SECRETARY','1859',to_date('09-JUN-81','DD-MON-RR'),'1047',null,'393');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4413','NERI GAETANO','HEADMASTER','4025',to_date('09-JUN-81','DD-MON-RR'),'181',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4414','COZZA PASQUALE','TECHNICIAN','1859',to_date('09-JUN-81','DD-MON-RR'),'526',null,'402');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4415','LEVI ROBERTA','ENGINEER','2281',to_date('09-JUN-81','DD-MON-RR'),'782',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4416','LEVI FEDERICO','TECHNICIAN','3694',to_date('09-JUN-81','DD-MON-RR'),'948',null,'4');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4417','DANTE ELENA','TECHNICIAN','2419',to_date('09-JUN-81','DD-MON-RR'),'562',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4418','ESPOSITO LUIGI','SUPERVISOR','3832',to_date('09-JUN-81','DD-MON-RR'),'997',null,'417');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4419','LEVI FEDERICO','LAWYER','2594',to_date('09-JUN-81','DD-MON-RR'),'1523',null,'251');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4420','ESPOSITO PAOLO','SECRETARY','2354',to_date('09-JUN-81','DD-MON-RR'),'239',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4421','FO MASSIMO','LAWYER','3638',to_date('09-JUN-81','DD-MON-RR'),'4',null,'58');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4422','CARBONE PAOLO','MANAGER','888',to_date('09-JUN-81','DD-MON-RR'),'189',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4423','GRIMALDI COSIMO','TECHNICIAN','3706',to_date('09-JUN-81','DD-MON-RR'),'595',null,'171');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4424','TIBALDI ELIO','PROFESSOR','4041',to_date('09-JUN-81','DD-MON-RR'),'164',null,'222');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4425','BIANCHI FRANCESCO','LAWYER','2795',to_date('09-JUN-81','DD-MON-RR'),'15',null,'83');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4426','NERI FRANCESCO','MANAGER','3895',to_date('09-JUN-81','DD-MON-RR'),'326',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4427','CALVINO ELENA','PHDSTUDENT','4308',to_date('09-JUN-81','DD-MON-RR'),'393',null,'488');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4428','TIBALDI ELIO','ENGINEER','335',to_date('09-JUN-81','DD-MON-RR'),'255',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4429','CORONA GIOVANNI','MANAGER','452',to_date('09-JUN-81','DD-MON-RR'),'1429',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4430','ESPOSITO CLARA','HEADMASTER','2634',to_date('09-JUN-81','DD-MON-RR'),'1526',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4431','LEOPARDI UGO','LAWYER','420',to_date('09-JUN-81','DD-MON-RR'),'1762',null,'134');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4432','GRIMALDI ANDREA','ENGINEER','1384',to_date('09-JUN-81','DD-MON-RR'),'1702',null,'230');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4433','CALVINO ANGELO','LAWYER','3088',to_date('09-JUN-81','DD-MON-RR'),'316',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4434','CORONA IVANO','ENGINEER','2668',to_date('09-JUN-81','DD-MON-RR'),'1358',null,'197');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4435','NERI LUCIA','MANAGER','2846',to_date('09-JUN-81','DD-MON-RR'),'1642',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4436','SANTE LUDOVICO','PROFESSOR','2272',to_date('09-JUN-81','DD-MON-RR'),'1356',null,'86');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4437','FUMAROLA FRANCESCO','LAWYER','202',to_date('09-JUN-81','DD-MON-RR'),'841',null,'450');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4438','MANZONI ANDREA','TECHNICIAN','1146',to_date('09-JUN-81','DD-MON-RR'),'813',null,'71');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4439','TIBALDI MARIO','HEADMASTER','3629',to_date('09-JUN-81','DD-MON-RR'),'820',null,'199');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4440','FO UMBERTO','SECRETARY','3281',to_date('09-JUN-81','DD-MON-RR'),'1873',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4441','GRIMALDI IVANO','MANAGER','1418',to_date('09-JUN-81','DD-MON-RR'),'1711',null,'354');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4442','CALVINO CLARA','SECRETARY','2406',to_date('09-JUN-81','DD-MON-RR'),'1364',null,'118');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4443','FO COSIMO','SECRETARY','1899',to_date('09-JUN-81','DD-MON-RR'),'895',null,'177');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4444','GRIMALDI LUDOVICO','TECHNICIAN','1286',to_date('09-JUN-81','DD-MON-RR'),'805',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4445','LEOPARDI UGO','MANAGER','1395',to_date('09-JUN-81','DD-MON-RR'),'708',null,'402');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4446','CARBONE ROBERTA','LAWYER','3515',to_date('09-JUN-81','DD-MON-RR'),'1404',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4447','BIANCHI CLARA','PROFESSOR','1405',to_date('09-JUN-81','DD-MON-RR'),'1471',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4448','NERI PAOLO','MANAGER','2232',to_date('09-JUN-81','DD-MON-RR'),'1213',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4449','LEOPARDI LUCA','LAWYER','88',to_date('09-JUN-81','DD-MON-RR'),'932',null,'474');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4450','TIBALDI ANTONIO','ENGINEER','2055',to_date('09-JUN-81','DD-MON-RR'),'936',null,'458');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4451','CALVINO LUCA','LAWYER','1849',to_date('09-JUN-81','DD-MON-RR'),'39',null,'1');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4452','DANTE PAOLO','PHDSTUDENT','267',to_date('09-JUN-81','DD-MON-RR'),'1670',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4453','CARBONE ANTONIO','SECRETARY','3989',to_date('09-JUN-81','DD-MON-RR'),'1781',null,'358');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4454','FUMAROLA GIOVANNI','HEADMASTER','1789',to_date('09-JUN-81','DD-MON-RR'),'1534',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4455','CALVINO UMBERTO','PHDSTUDENT','4068',to_date('09-JUN-81','DD-MON-RR'),'1645',null,'491');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4456','FO CLARA','ENGINEER','586',to_date('09-JUN-81','DD-MON-RR'),'1010',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4457','CALVINO UGO','TECHNICIAN','1475',to_date('09-JUN-81','DD-MON-RR'),'1969',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4458','LEVI ANGELO','TECHNICIAN','1669',to_date('09-JUN-81','DD-MON-RR'),'527',null,'432');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4459','SANTE ANGELO','SUPERVISOR','4398',to_date('09-JUN-81','DD-MON-RR'),'1043',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4460','ESPOSITO GAETANO','MANAGER','3841',to_date('09-JUN-81','DD-MON-RR'),'1569',null,'281');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4461','CARBONE ANDREA','ENGINEER','252',to_date('09-JUN-81','DD-MON-RR'),'1494',null,'78');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4462','ECO LUIGI','HEADMASTER','174',to_date('09-JUN-81','DD-MON-RR'),'425',null,'33');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4463','FO ROBERTA','HEADMASTER','2677',to_date('09-JUN-81','DD-MON-RR'),'1701',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4464','GRIMALDI FRANCESCO','SUPERVISOR','350',to_date('09-JUN-81','DD-MON-RR'),'1859',null,'170');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4465','MANZONI COSIMO','SUPERVISOR','889',to_date('09-JUN-81','DD-MON-RR'),'275',null,'498');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4466','CORONA LUDOVICO','SUPERVISOR','1854',to_date('09-JUN-81','DD-MON-RR'),'77',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4467','TIBALDI COSIMO','MANAGER','2928',to_date('09-JUN-81','DD-MON-RR'),'732',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4468','CARBONE COSIMO','MANAGER','704',to_date('09-JUN-81','DD-MON-RR'),'1182',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4469','DANTE FRANCESCO','HEADMASTER','3017',to_date('09-JUN-81','DD-MON-RR'),'270',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4470','CALVINO COSIMO','MANAGER','1019',to_date('09-JUN-81','DD-MON-RR'),'1585',null,'34');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4471','FO MASSIMO','PROFESSOR','3747',to_date('09-JUN-81','DD-MON-RR'),'1941',null,'44');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4472','CORONA UMBERTO','SUPERVISOR','1969',to_date('09-JUN-81','DD-MON-RR'),'398',null,'391');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4473','GRIMALDI ALFONSO','SECRETARY','3694',to_date('09-JUN-81','DD-MON-RR'),'159',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4474','NERI ANGELO','HEADMASTER','1485',to_date('09-JUN-81','DD-MON-RR'),'1222',null,'278');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4475','ESPOSITO MASSIMO','PHDSTUDENT','4101',to_date('09-JUN-81','DD-MON-RR'),'1710',null,'471');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4476','FO ROBERTA','SUPERVISOR','156',to_date('09-JUN-81','DD-MON-RR'),'1837',null,'234');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4477','FUMAROLA IVANO','PROFESSOR','2420',to_date('09-JUN-81','DD-MON-RR'),'1115',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7319','FO COSIMO','MANAGER','6054',to_date('09-JUN-81','DD-MON-RR'),'941',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7320','FO UGO','PHDSTUDENT','5655',to_date('09-JUN-81','DD-MON-RR'),'1317',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7321','ECO LUCIA','HEADMASTER','1618',to_date('09-JUN-81','DD-MON-RR'),'1548',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7322','LEVI ELIO','HEADMASTER','7012',to_date('09-JUN-81','DD-MON-RR'),'1625',null,'348');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7323','FO GAETANO','HEADMASTER','118',to_date('09-JUN-81','DD-MON-RR'),'989',null,'64');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7324','TIBALDI COSIMO','SUPERVISOR','815',to_date('09-JUN-81','DD-MON-RR'),'1992',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7325','CALVINO FRANCESCO','ENGINEER','41',to_date('09-JUN-81','DD-MON-RR'),'663',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7326','CALVINO SILVIA','PHDSTUDENT','2749',to_date('09-JUN-81','DD-MON-RR'),'661',null,'220');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7327','GRIMALDI ROBERTA','LAWYER','4944',to_date('09-JUN-81','DD-MON-RR'),'373',null,'136');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7328','PETRARCA PASQUALE','MANAGER','2787',to_date('09-JUN-81','DD-MON-RR'),'1605',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7329','TIBALDI CLARA','ENGINEER','1287',to_date('09-JUN-81','DD-MON-RR'),'374',null,'177');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7330','CORONA UMBERTO','HEADMASTER','1431',to_date('09-JUN-81','DD-MON-RR'),'1175',null,'122');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7331','CALVINO DONATO','HEADMASTER','2951',to_date('09-JUN-81','DD-MON-RR'),'1707',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7332','MANZONI FEDERICO','TECHNICIAN','2227',to_date('09-JUN-81','DD-MON-RR'),'10',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7333','CORONA DONATO','TECHNICIAN','1990',to_date('09-JUN-81','DD-MON-RR'),'1513',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7334','ECO MARIA','TECHNICIAN','6017',to_date('09-JUN-81','DD-MON-RR'),'881',null,'477');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7335','ECO UGO','LAWYER','657',to_date('09-JUN-81','DD-MON-RR'),'1899',null,'62');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7336','SANTE LUCA','PHDSTUDENT','5066',to_date('09-JUN-81','DD-MON-RR'),'175',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7337','COZZA SILVIA','SUPERVISOR','2144',to_date('09-JUN-81','DD-MON-RR'),'472',null,'395');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7338','ESPOSITO ELENA','ENGINEER','2074',to_date('09-JUN-81','DD-MON-RR'),'167',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7339','BIANCHI ANGELO','SECRETARY','5439',to_date('09-JUN-81','DD-MON-RR'),'731',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7340','NERI LUDOVICO','ENGINEER','1710',to_date('09-JUN-81','DD-MON-RR'),'1261',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7341','CARBONE ALFONSO','PROFESSOR','7053',to_date('09-JUN-81','DD-MON-RR'),'1313',null,'54');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7342','CALVINO ELENA','MANAGER','1499',to_date('09-JUN-81','DD-MON-RR'),'651',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7343','SANTE LUCIA','SUPERVISOR','1206',to_date('09-JUN-81','DD-MON-RR'),'5',null,'86');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7344','SANTE MARIO','SECRETARY','2050',to_date('09-JUN-81','DD-MON-RR'),'1435',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7345','DANTE COSIMO','MANAGER','2169',to_date('09-JUN-81','DD-MON-RR'),'1293',null,'127');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7346','LEVI GAETANO','TECHNICIAN','4782',to_date('09-JUN-81','DD-MON-RR'),'1931',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7347','CORONA ROBERTA','MANAGER','5876',to_date('09-JUN-81','DD-MON-RR'),'1174',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7348','TIBALDI ELENA','HEADMASTER','1212',to_date('09-JUN-81','DD-MON-RR'),'1495',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7349','MANZONI ANTONIO','LAWYER','403',to_date('09-JUN-81','DD-MON-RR'),'232',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7350','BIANCHI GAETANO','LAWYER','5607',to_date('09-JUN-81','DD-MON-RR'),'643',null,'358');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7351','BIANCHI ANDREA','HEADMASTER','1767',to_date('09-JUN-81','DD-MON-RR'),'1206',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7352','LEOPARDI UGO','MANAGER','231',to_date('09-JUN-81','DD-MON-RR'),'325',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7353','ECO PAOLO','SUPERVISOR','1678',to_date('09-JUN-81','DD-MON-RR'),'808',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7354','CALVINO COSIMO','PROFESSOR','941',to_date('09-JUN-81','DD-MON-RR'),'1592',null,'471');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7355','BIANCHI ELENA','PROFESSOR','6284',to_date('09-JUN-81','DD-MON-RR'),'1395',null,'145');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7356','CALVINO DONATO','MANAGER','2159',to_date('09-JUN-81','DD-MON-RR'),'1913',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7357','LEVI MARIA','ENGINEER','380',to_date('09-JUN-81','DD-MON-RR'),'214',null,'185');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7358','NERI PAOLO','LAWYER','6996',to_date('09-JUN-81','DD-MON-RR'),'1210',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7359','CORONA ROBERTA','MANAGER','5635',to_date('09-JUN-81','DD-MON-RR'),'1846',null,'276');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7360','DANTE PAOLO','MANAGER','4980',to_date('09-JUN-81','DD-MON-RR'),'1123',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7361','ESPOSITO ANTONIO','HEADMASTER','1541',to_date('09-JUN-81','DD-MON-RR'),'854',null,'429');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7362','FUMAROLA UGO','SECRETARY','1944',to_date('09-JUN-81','DD-MON-RR'),'919',null,'20');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7363','TIBALDI ELIO','SECRETARY','1810',to_date('09-JUN-81','DD-MON-RR'),'240',null,'12');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7364','PETRARCA MARIA','MANAGER','122',to_date('09-JUN-81','DD-MON-RR'),'1651',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7365','FO LUIGI','ENGINEER','416',to_date('09-JUN-81','DD-MON-RR'),'421',null,'6');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7366','CARBONE DAMIANO','SUPERVISOR','1052',to_date('09-JUN-81','DD-MON-RR'),'774',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7367','COZZA UGO','MANAGER','6888',to_date('09-JUN-81','DD-MON-RR'),'1413',null,'220');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7368','PETRARCA FRANCESCO','SECRETARY','2910',to_date('09-JUN-81','DD-MON-RR'),'1176',null,'365');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7369','TIBALDI LUDOVICO','LAWYER','1757',to_date('09-JUN-81','DD-MON-RR'),'1730',null,'308');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7370','TIBALDI SILVIA','PHDSTUDENT','3180',to_date('09-JUN-81','DD-MON-RR'),'982',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7371','DANTE ELIO','LAWYER','4345',to_date('09-JUN-81','DD-MON-RR'),'1751',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7372','ESPOSITO UGO','PHDSTUDENT','1058',to_date('09-JUN-81','DD-MON-RR'),'1623',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7373','COZZA UMBERTO','MANAGER','1437',to_date('09-JUN-81','DD-MON-RR'),'366',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7374','CALVINO LUCIA','PROFESSOR','5282',to_date('09-JUN-81','DD-MON-RR'),'1681',null,'359');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7375','CALVINO FEDERICO','PROFESSOR','3567',to_date('09-JUN-81','DD-MON-RR'),'507',null,'322');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7376','MANZONI PASQUALE','HEADMASTER','2834',to_date('09-JUN-81','DD-MON-RR'),'574',null,'126');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7377','CARBONE ANGELO','HEADMASTER','5011',to_date('09-JUN-81','DD-MON-RR'),'1186',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7378','LEOPARDI IVANO','TECHNICIAN','1270',to_date('09-JUN-81','DD-MON-RR'),'745',null,'456');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7379','ESPOSITO COSIMO','TECHNICIAN','233',to_date('09-JUN-81','DD-MON-RR'),'29',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7380','LEVI COSIMO','LAWYER','6678',to_date('09-JUN-81','DD-MON-RR'),'1662',null,'216');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7381','GRIMALDI UMBERTO','PHDSTUDENT','6847',to_date('09-JUN-81','DD-MON-RR'),'121',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7382','SANTE DONATO','SUPERVISOR','2294',to_date('09-JUN-81','DD-MON-RR'),'100',null,'229');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7383','FUMAROLA DAMIANO','PHDSTUDENT','7249',to_date('09-JUN-81','DD-MON-RR'),'1954',null,'4');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7384','LEVI MASSIMO','ENGINEER','3028',to_date('09-JUN-81','DD-MON-RR'),'373',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7385','CARBONE ANGELO','MANAGER','6976',to_date('09-JUN-81','DD-MON-RR'),'1685',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7386','FO MARIA','LAWYER','3738',to_date('09-JUN-81','DD-MON-RR'),'640',null,'118');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7387','MANZONI ANDREA','MANAGER','5826',to_date('09-JUN-81','DD-MON-RR'),'1624',null,'329');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7388','COZZA FRANCESCO','SECRETARY','6534',to_date('09-JUN-81','DD-MON-RR'),'92',null,'220');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7389','COZZA UMBERTO','ENGINEER','1487',to_date('09-JUN-81','DD-MON-RR'),'702',null,'391');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7390','LEOPARDI PAOLO','PROFESSOR','1427',to_date('09-JUN-81','DD-MON-RR'),'124',null,'281');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7391','MANZONI CLARA','MANAGER','6440',to_date('09-JUN-81','DD-MON-RR'),'1890',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7392','COZZA ANGELO','MANAGER','5310',to_date('09-JUN-81','DD-MON-RR'),'1313',null,'295');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7393','CARBONE CLARA','TECHNICIAN','6229',to_date('09-JUN-81','DD-MON-RR'),'1577',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7394','LEVI MASSIMO','LAWYER','6518',to_date('09-JUN-81','DD-MON-RR'),'1768',null,'496');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7395','CORONA SILVIA','PHDSTUDENT','2857',to_date('09-JUN-81','DD-MON-RR'),'1201',null,'86');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7396','FO MASSIMO','MANAGER','6707',to_date('09-JUN-81','DD-MON-RR'),'332',null,'278');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7397','NERI LUCIA','TECHNICIAN','7116',to_date('09-JUN-81','DD-MON-RR'),'1987',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7398','TIBALDI ELIO','MANAGER','1532',to_date('09-JUN-81','DD-MON-RR'),'429',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7399','GRIMALDI UGO','ENGINEER','4073',to_date('09-JUN-81','DD-MON-RR'),'761',null,'171');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7400','TIBALDI ANGELO','HEADMASTER','4850',to_date('09-JUN-81','DD-MON-RR'),'864',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7401','PETRARCA SILVIA','ENGINEER','3268',to_date('09-JUN-81','DD-MON-RR'),'578',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7402','COZZA LUDOVICO','SECRETARY','3149',to_date('09-JUN-81','DD-MON-RR'),'870',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7403','TIBALDI PAOLO','ENGINEER','3665',to_date('09-JUN-81','DD-MON-RR'),'389',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7404','LEVI MASSIMO','PHDSTUDENT','5404',to_date('09-JUN-81','DD-MON-RR'),'1306',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7405','LEOPARDI FEDERICO','HEADMASTER','6098',to_date('09-JUN-81','DD-MON-RR'),'1706',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7406','ESPOSITO UGO','SUPERVISOR','6082',to_date('09-JUN-81','DD-MON-RR'),'247',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7407','PETRARCA SILVIA','PROFESSOR','5347',to_date('09-JUN-81','DD-MON-RR'),'1097',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7408','CARBONE PAOLO','PROFESSOR','1912',to_date('09-JUN-81','DD-MON-RR'),'1103',null,'394');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7409','FO LUCIA','TECHNICIAN','699',to_date('09-JUN-81','DD-MON-RR'),'1106',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7410','FO LUIGI','SECRETARY','1757',to_date('09-JUN-81','DD-MON-RR'),'899',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7411','PETRARCA PAOLO','SECRETARY','4983',to_date('09-JUN-81','DD-MON-RR'),'891',null,'200');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7412','FUMAROLA PASQUALE','SECRETARY','4015',to_date('09-JUN-81','DD-MON-RR'),'1603',null,'36');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7413','COZZA COSIMO','PHDSTUDENT','5501',to_date('09-JUN-81','DD-MON-RR'),'1727',null,'341');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7414','DANTE ALFONSO','SUPERVISOR','3131',to_date('09-JUN-81','DD-MON-RR'),'1770',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7415','CALVINO COSIMO','PROFESSOR','5265',to_date('09-JUN-81','DD-MON-RR'),'1530',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7416','SANTE PAOLO','ENGINEER','4328',to_date('09-JUN-81','DD-MON-RR'),'1402',null,'102');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7417','CORONA LUIGI','MANAGER','3784',to_date('09-JUN-81','DD-MON-RR'),'1226',null,'43');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7418','CARBONE DONATO','PROFESSOR','5299',to_date('09-JUN-81','DD-MON-RR'),'1007',null,'278');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7419','CARBONE IVANO','ENGINEER','6695',to_date('09-JUN-81','DD-MON-RR'),'913',null,'115');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7420','PETRARCA PAOLO','MANAGER','4791',to_date('09-JUN-81','DD-MON-RR'),'268',null,'262');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7421','NERI PAOLO','MANAGER','4001',to_date('09-JUN-81','DD-MON-RR'),'47',null,'127');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7422','CORONA UGO','PHDSTUDENT','215',to_date('09-JUN-81','DD-MON-RR'),'1038',null,'469');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7423','GRIMALDI GIOVANNI','PHDSTUDENT','5995',to_date('09-JUN-81','DD-MON-RR'),'1635',null,'102');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7424','CALVINO PAOLO','MANAGER','5275',to_date('09-JUN-81','DD-MON-RR'),'233',null,'347');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7425','MANZONI SILVIA','ENGINEER','5212',to_date('09-JUN-81','DD-MON-RR'),'1447',null,'127');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7426','TIBALDI GIOVANNI','HEADMASTER','5796',to_date('09-JUN-81','DD-MON-RR'),'86',null,'358');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7427','SANTE DAMIANO','MANAGER','2684',to_date('09-JUN-81','DD-MON-RR'),'1632',null,'123');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7428','BIANCHI GAETANO','LAWYER','16',to_date('09-JUN-81','DD-MON-RR'),'1479',null,'83');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7429','DANTE ROBERTA','MANAGER','3312',to_date('09-JUN-81','DD-MON-RR'),'1628',null,'249');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7430','SANTE UGO','SECRETARY','1943',to_date('09-JUN-81','DD-MON-RR'),'916',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7431','SANTE ELIO','PROFESSOR','1559',to_date('09-JUN-81','DD-MON-RR'),'931',null,'423');
Insert into