--------------------------------------------------------
--  File created - 15/11/2018
--------------------------------------------------------
--------------------------------------------------------
--  DDL for Table EMP
--------------------------------------------------------

DROP TABLE "EMP";

alter session set NLS_LANGUAGE=ENGLISH; -- set month format to english strings

CREATE TABLE "EMP" 
(	"EMPNO" NUMBER(6,0), 
    "ENAME" VARCHAR2(20 BYTE), 
    "JOB" VARCHAR2(11 BYTE), 
    "MGR" NUMBER(6,0), 
    "HIREDATE" DATE, 
    "SAL" NUMBER(7,2), 
    "COMM" NUMBER(7,2), 
    "DEPTNO" NUMBER(3,0)
) SEGMENT CREATION IMMEDIATE 
PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
STORAGE(INITIAL 4194304 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
TABLESPACE "USERS" ;

REM INSERTING into EMP
SET DEFINE OFF;
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24103', 'BIANCHI SILVIA', 'SUPERVISOR', '17737', to_date('09-JUN-81','DD-MON-RR'), '1685', null, '193');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('28924', 'FUMAROLA DAMIANO', 'TECHNICIAN', '3884', to_date('09-JUN-81','DD-MON-RR'), '1487', null, '193');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('5051', 'FO CLARA', 'PROFESSOR', '1973', to_date('09-JUN-81','DD-MON-RR'), '1345', null, '193');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('23256', 'BIANCHI LUDOVICO', 'MANAGER', '9561', to_date('09-JUN-81','DD-MON-RR'), '252', null, '193');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47944', 'CORONA UGO', 'PROFESSOR', '38873', to_date('09-JUN-81','DD-MON-RR'), '197', null, '193');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('49147', 'NERI CLARA', 'SECRETARY', '36847', to_date('09-JUN-81','DD-MON-RR'), '691', null, '193');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('29013', 'ESPOSITO GAETANO', 'PROFESSOR', '8924', to_date('09-JUN-81','DD-MON-RR'), '1895', null, '193');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38596', 'LEVI ROBERTA', 'ENGINEER', '27153', to_date('09-JUN-81','DD-MON-RR'), '1259', null, '286');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('34906', 'BIANCHI COSIMO', 'TECHNICIAN', '22362', to_date('09-JUN-81','DD-MON-RR'), '542', null, '286');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('22859', 'FUMAROLA ANDREA', 'MANAGER', '15379', to_date('09-JUN-81','DD-MON-RR'), '1812', null, '286');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('27183', 'ECO LUDOVICO', 'MANAGER', '16293', to_date('09-JUN-81','DD-MON-RR'), '1307', null, '286');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('36521', 'FO GAETANO', 'PROFESSOR', '17521', to_date('09-JUN-81','DD-MON-RR'), '1317', null, '286');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('14997', 'DANTE ELENA', 'SUPERVISOR', '8947', to_date('09-JUN-81','DD-MON-RR'), '1995', null, '257');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6952', 'SANTE MARIA', 'PHDSTUDENT', '3987', to_date('09-JUN-81','DD-MON-RR'), '1176', null, '257');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('21521', 'LEOPARDI PASQUALE', 'SUPERVISOR', '16988', to_date('09-JUN-81','DD-MON-RR'), '52', null, '257');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18940', 'FUMAROLA LUIGI', 'MANAGER', '7031', to_date('09-JUN-81','DD-MON-RR'), '1759', null, '257');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('23594', 'LEVI PASQUALE', 'SECRETARY', '18623', to_date('09-JUN-81','DD-MON-RR'), '1673', null, '257');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('734', 'MANZONI MARIA', 'TECHNICIAN', '280', to_date('09-JUN-81','DD-MON-RR'), '200', null, '257');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('41765', 'SANTE LUCIA', 'SUPERVISOR', '38962', to_date('09-JUN-81','DD-MON-RR'), '620', null, '257');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('14475', 'COZZA GIOVANNI', 'SECRETARY', '10451', to_date('09-JUN-81','DD-MON-RR'), '1277', null, '186');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('15989', 'LEVI ELIO', 'MANAGER', '4415', to_date('09-JUN-81','DD-MON-RR'), '354', null, '186');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('42909', 'MANZONI ANDREA', 'ENGINEER', '27355', to_date('09-JUN-81','DD-MON-RR'), '1309', null, '186');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('15602', 'PETRARCA LUDOVICO', 'MANAGER', '6080', to_date('09-JUN-81','DD-MON-RR'), '637', null, '186');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('25788', 'LEOPARDI ANTONIO', 'LAWYER', '13072', to_date('09-JUN-81','DD-MON-RR'), '416', null, '186');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('34416', 'COZZA LUIGI', 'MANAGER', '9769', to_date('09-JUN-81','DD-MON-RR'), '29', null, '186');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18696', 'TIBALDI LUIGI', 'MANAGER', '11467', to_date('09-JUN-81','DD-MON-RR'), '57', null, '186');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47855', 'LEOPARDI LUCA', 'LAWYER', '32100', to_date('09-JUN-81','DD-MON-RR'), '1323', null, '186');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('29629', 'GRIMALDI GAETANO', 'MANAGER', '3917', to_date('09-JUN-81','DD-MON-RR'), '790', null, '56');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('4325', 'COZZA LUCA', 'HEADMASTER', '234', to_date('09-JUN-81','DD-MON-RR'), '1282', null, '56');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('254', 'CALVINO LUCIA', 'LAWYER', '18', to_date('09-JUN-81','DD-MON-RR'), '1319', null, '56');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('36558', 'COZZA DONATO', 'PROFESSOR', '10235', to_date('09-JUN-81','DD-MON-RR'), '54', null, '56');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('4073', 'PETRARCA MASSIMO', 'SUPERVISOR', '2795', to_date('09-JUN-81','DD-MON-RR'), '784', null, '56');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('9633', 'LEOPARDI ELIO', 'MANAGER', '2686', to_date('09-JUN-81','DD-MON-RR'), '471', null, '56');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('19685', 'FUMAROLA COSIMO', 'ENGINEER', '16331', to_date('09-JUN-81','DD-MON-RR'), '1043', null, '56');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('3190', 'ESPOSITO LUDOVICO', 'PROFESSOR', '122', to_date('09-JUN-81','DD-MON-RR'), '563', null, '459');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('23478', 'TIBALDI COSIMO', 'HEADMASTER', '6858', to_date('09-JUN-81','DD-MON-RR'), '302', null, '459');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('7163', 'BIANCHI ANDREA', 'SUPERVISOR', '1055', to_date('09-JUN-81','DD-MON-RR'), '386', null, '459');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38234', 'FUMAROLA GAETANO', 'PHDSTUDENT', '25170', to_date('09-JUN-81','DD-MON-RR'), '1123', null, '459');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('46365', 'ECO DAMIANO', 'MANAGER', '31709', to_date('09-JUN-81','DD-MON-RR'), '1136', null, '459');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('23967', 'FO ANGELO', 'HEADMASTER', '20684', to_date('09-JUN-81','DD-MON-RR'), '1157', null, '459');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('17100', 'BIANCHI GIOVANNI', 'ENGINEER', '12698', to_date('09-JUN-81','DD-MON-RR'), '1259', null, '459');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('44311', 'SANTE PAOLO', 'SUPERVISOR', '28758', to_date('09-JUN-81','DD-MON-RR'), '193', null, '459');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('14133', 'MANZONI LUIGI', 'SUPERVISOR', '6198', to_date('09-JUN-81','DD-MON-RR'), '1057', null, '459');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('10172', 'ESPOSITO IVANO', 'PHDSTUDENT', '7093', to_date('09-JUN-81','DD-MON-RR'), '485', null, '24');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('44342', 'CALVINO SILVIA', 'TECHNICIAN', '41862', to_date('09-JUN-81','DD-MON-RR'), '983', null, '24');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('31280', 'CORONA UMBERTO', 'SECRETARY', '23119', to_date('09-JUN-81','DD-MON-RR'), '534', null, '24');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('41872', 'FUMAROLA LUCIA', 'MANAGER', '23786', to_date('09-JUN-81','DD-MON-RR'), '325', null, '24');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('34868', 'COZZA MARIO', 'SECRETARY', '22749', to_date('09-JUN-81','DD-MON-RR'), '1674', null, '24');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('37519', 'ESPOSITO LUCIA', 'HEADMASTER', '8100', to_date('09-JUN-81','DD-MON-RR'), '313', null, '24');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('33288', 'CALVINO FEDERICO', 'LAWYER', '25702', to_date('09-JUN-81','DD-MON-RR'), '1703', null, '24');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38373', 'SANTE ANDREA', 'MANAGER', '21069', to_date('09-JUN-81','DD-MON-RR'), '351', null, '138');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('3094', 'MANZONI ROBERTA', 'HEADMASTER', '701', to_date('09-JUN-81','DD-MON-RR'), '1173', null, '138');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('28568', 'NERI FRANCESCO', 'LAWYER', '14988', to_date('09-JUN-81','DD-MON-RR'), '1729', null, '138');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('2214', 'BIANCHI DAMIANO', 'MANAGER', '1218', to_date('09-JUN-81','DD-MON-RR'), '1182', null, '138');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('36569', 'CORONA FRANCESCO', 'MANAGER', '15670', to_date('09-JUN-81','DD-MON-RR'), '1569', null, '138');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('41173', 'PETRARCA DONATO', 'MANAGER', '25487', to_date('09-JUN-81','DD-MON-RR'), '948', null, '138');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('48373', 'ECO SILVIA', 'TECHNICIAN', '3693', to_date('09-JUN-81','DD-MON-RR'), '521', null, '138');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('39514', 'GRIMALDI GIOVANNI', 'HEADMASTER', '32534', to_date('09-JUN-81','DD-MON-RR'), '1358', null, '138');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('37669', 'LEOPARDI UMBERTO', 'SECRETARY', '17411', to_date('09-JUN-81','DD-MON-RR'), '55', null, '138');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('36335', 'LEVI COSIMO', 'HEADMASTER', '8124', to_date('09-JUN-81','DD-MON-RR'), '1254', null, '138');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('2645', 'ESPOSITO DONATO', 'SECRETARY', '1125', to_date('09-JUN-81','DD-MON-RR'), '1478', null, '332');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('41373', 'LEVI COSIMO', 'SECRETARY', '28786', to_date('09-JUN-81','DD-MON-RR'), '1666', null, '332');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24608', 'CALVINO ANGELO', 'PHDSTUDENT', '15635', to_date('09-JUN-81','DD-MON-RR'), '655', null, '332');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('41569', 'LEOPARDI UGO', 'LAWYER', '41171', to_date('09-JUN-81','DD-MON-RR'), '110', null, '332');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('13582', 'ECO ANDREA', 'ENGINEER', '6113', to_date('09-JUN-81','DD-MON-RR'), '929', null, '332');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('22828', 'DANTE MARIA', 'PHDSTUDENT', '4181', to_date('09-JUN-81','DD-MON-RR'), '952', null, '332');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('31232', 'SANTE LUCA', 'MANAGER', '25403', to_date('09-JUN-81','DD-MON-RR'), '820', null, '332');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('41969', 'ESPOSITO ALFONSO', 'SUPERVISOR', '38668', to_date('09-JUN-81','DD-MON-RR'), '901', null, '332');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24864', 'TIBALDI LUIGI', 'HEADMASTER', '14694', to_date('09-JUN-81','DD-MON-RR'), '1846', null, '332');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('46082', 'FO FRANCESCO', 'SUPERVISOR', '15596', to_date('09-JUN-81','DD-MON-RR'), '1754', null, '58');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('19917', 'PETRARCA LUIGI', 'PHDSTUDENT', '10250', to_date('09-JUN-81','DD-MON-RR'), '1272', null, '58');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47853', 'TIBALDI FEDERICO', 'SUPERVISOR', '42496', to_date('09-JUN-81','DD-MON-RR'), '191', null, '58');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('44307', 'TIBALDI ELENA', 'MANAGER', '41290', to_date('09-JUN-81','DD-MON-RR'), '351', null, '58');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('17884', 'CALVINO ANDREA', 'SECRETARY', '15944', to_date('09-JUN-81','DD-MON-RR'), '800', null, '58');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('32290', 'GRIMALDI FRANCESCO', 'PHDSTUDENT', '28407', to_date('09-JUN-81','DD-MON-RR'), '1626', null, '58');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('35006', 'MANZONI ELIO', 'LAWYER', '4314', to_date('09-JUN-81','DD-MON-RR'), '663', null, '58');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('11958', 'CARBONE MARIO', 'TECHNICIAN', '966', to_date('09-JUN-81','DD-MON-RR'), '787', null, '58');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('45582', 'DANTE ANTONIO', 'SECRETARY', '16068', to_date('09-JUN-81','DD-MON-RR'), '1606', null, '58');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47419', 'MANZONI LUIGI', 'MANAGER', '20101', to_date('09-JUN-81','DD-MON-RR'), '917', null, '461');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('3105', 'BIANCHI PASQUALE', 'ENGINEER', '2750', to_date('09-JUN-81','DD-MON-RR'), '1956', null, '461');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38851', 'NERI CLARA', 'TECHNICIAN', '35458', to_date('09-JUN-81','DD-MON-RR'), '1082', null, '461');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('4983', 'SANTE DONATO', 'LAWYER', '382', to_date('09-JUN-81','DD-MON-RR'), '267', null, '461');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('42426', 'LEOPARDI DONATO', 'SUPERVISOR', '13059', to_date('09-JUN-81','DD-MON-RR'), '1729', null, '461');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('12531', 'ECO ELIO', 'MANAGER', '346', to_date('09-JUN-81','DD-MON-RR'), '107', null, '461');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('26717', 'PETRARCA IVANO', 'MANAGER', '10350', to_date('09-JUN-81','DD-MON-RR'), '1473', null, '461');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('27809', 'FUMAROLA DONATO', 'SUPERVISOR', '2997', to_date('09-JUN-81','DD-MON-RR'), '1601', null, '461');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('40763', 'MANZONI SILVIA', 'ENGINEER', '1960', to_date('09-JUN-81','DD-MON-RR'), '1899', null, '461');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('10317', 'COZZA ANDREA', 'SECRETARY', '640', to_date('09-JUN-81','DD-MON-RR'), '1147', null, '245');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('14988', 'TIBALDI ANTONIO', 'HEADMASTER', '14645', to_date('09-JUN-81','DD-MON-RR'), '1294', null, '245');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('4245', 'CARBONE ROBERTA', 'MANAGER', '1944', to_date('09-JUN-81','DD-MON-RR'), '800', null, '245');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('22923', 'MANZONI DONATO', 'PROFESSOR', '12489', to_date('09-JUN-81','DD-MON-RR'), '434', null, '245');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('43505', 'FO LUCA', 'TECHNICIAN', '12142', to_date('09-JUN-81','DD-MON-RR'), '1516', null, '245');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('11953', 'FUMAROLA MARIO', 'LAWYER', '1451', to_date('09-JUN-81','DD-MON-RR'), '421', null, '245');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('49386', 'CORONA DAMIANO', 'PHDSTUDENT', '12349', to_date('09-JUN-81','DD-MON-RR'), '999', null, '245');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('14811', 'GRIMALDI PAOLO', 'HEADMASTER', '1134', to_date('09-JUN-81','DD-MON-RR'), '1666', null, '245');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38286', 'DANTE ANDREA', 'HEADMASTER', '31180', to_date('09-JUN-81','DD-MON-RR'), '1774', null, '245');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24414', 'CARBONE PASQUALE', 'MANAGER', '11386', to_date('09-JUN-81','DD-MON-RR'), '620', null, '82');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('25676', 'CORONA CLARA', 'MANAGER', '1696', to_date('09-JUN-81','DD-MON-RR'), '1317', null, '82');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6170', 'CORONA SILVIA', 'SECRETARY', '4493', to_date('09-JUN-81','DD-MON-RR'), '1929', null, '82');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('9156', 'SANTE ANTONIO', 'MANAGER', '6161', to_date('09-JUN-81','DD-MON-RR'), '764', null, '82');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('43600', 'CARBONE ELENA', 'MANAGER', '24147', to_date('09-JUN-81','DD-MON-RR'), '1880', null, '82');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('1509', 'LEOPARDI UGO', 'MANAGER', '746', to_date('09-JUN-81','DD-MON-RR'), '104', null, '82');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('10922', 'FO ALFONSO', 'PROFESSOR', '3729', to_date('09-JUN-81','DD-MON-RR'), '477', null, '82');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('17565', 'GRIMALDI ROBERTA', 'LAWYER', '11738', to_date('09-JUN-81','DD-MON-RR'), '1395', null, '82');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('44136', 'ESPOSITO PAOLO', 'LAWYER', '14888', to_date('09-JUN-81','DD-MON-RR'), '236', null, '127');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24655', 'LEVI ANDREA', 'HEADMASTER', '24042', to_date('09-JUN-81','DD-MON-RR'), '16', null, '127');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('7345', 'DANTE COSIMO', 'MANAGER', '2169', to_date('09-JUN-81','DD-MON-RR'), '1293', null, '127');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('2079', 'CARBONE DONATO', 'SECRETARY', '836', to_date('09-JUN-81','DD-MON-RR'), '1290', null, '127');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38154', 'CARBONE CLARA', 'SUPERVISOR', '22128', to_date('09-JUN-81','DD-MON-RR'), '539', null, '127');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('30916', 'ESPOSITO DAMIANO', 'MANAGER', '6122', to_date('09-JUN-81','DD-MON-RR'), '564', null, '127');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('12343', 'BIANCHI MARIA', 'ENGINEER', '9495', to_date('09-JUN-81','DD-MON-RR'), '911', null, '127');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('37450', 'TIBALDI CLARA', 'PROFESSOR', '2505', to_date('09-JUN-81','DD-MON-RR'), '274', null, '127');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('32657', 'CORONA MARIA', 'HEADMASTER', '12744', to_date('09-JUN-81','DD-MON-RR'), '1864', null, '386');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('48434', 'NERI ANTONIO', 'LAWYER', '48010', to_date('09-JUN-81','DD-MON-RR'), '1122', null, '386');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('3869', 'GRIMALDI MARIA', 'HEADMASTER', '1317', to_date('09-JUN-81','DD-MON-RR'), '1979', null, '386');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('34573', 'BIANCHI MASSIMO', 'SECRETARY', '14833', to_date('09-JUN-81','DD-MON-RR'), '1081', null, '386');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('43177', 'FUMAROLA ELENA', 'PROFESSOR', '26604', to_date('09-JUN-81','DD-MON-RR'), '1495', null, '386');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('15373', 'PETRARCA MARIA', 'LAWYER', '7604', to_date('09-JUN-81','DD-MON-RR'), '1614', null, '386');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('45513', 'ESPOSITO LUDOVICO', 'SUPERVISOR', '17724', to_date('09-JUN-81','DD-MON-RR'), '427', null, '386');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18340', 'NERI LUDOVICO', 'MANAGER', '410', to_date('09-JUN-81','DD-MON-RR'), '809', null, '386');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('26190', 'LEVI CLARA', 'SECRETARY', '1531', to_date('09-JUN-81','DD-MON-RR'), '456', null, '349');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('4507', 'LEVI GAETANO', 'TECHNICIAN', '3442', to_date('09-JUN-81','DD-MON-RR'), '207', null, '349');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('40423', 'LEOPARDI DONATO', 'MANAGER', '8243', to_date('09-JUN-81','DD-MON-RR'), '1578', null, '349');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('30305', 'CORONA CLARA', 'LAWYER', '25364', to_date('09-JUN-81','DD-MON-RR'), '1162', null, '349');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24872', 'FUMAROLA FEDERICO', 'TECHNICIAN', '2912', to_date('09-JUN-81','DD-MON-RR'), '786', null, '349');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('29119', 'COZZA MASSIMO', 'MANAGER', '4891', to_date('09-JUN-81','DD-MON-RR'), '464', null, '349');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('607', 'COZZA MARIO', 'LAWYER', '487', to_date('09-JUN-81','DD-MON-RR'), '1228', null, '349');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('3816', 'GRIMALDI ANGELO', 'LAWYER', '3784', to_date('09-JUN-81','DD-MON-RR'), '135', null, '431');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('30226', 'DANTE DONATO', 'ENGINEER', '9714', to_date('09-JUN-81','DD-MON-RR'), '859', null, '431');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('45386', 'DANTE IVANO', 'LAWYER', '6762', to_date('09-JUN-81','DD-MON-RR'), '1111', null, '431');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('3774', 'LEVI ALFONSO', 'PROFESSOR', '609', to_date('09-JUN-81','DD-MON-RR'), '1565', null, '431');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('765', 'FO IVANO', 'MANAGER', '139', to_date('09-JUN-81','DD-MON-RR'), '513', null, '431');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('1154', 'LEOPARDI ALFONSO', 'MANAGER', '622', to_date('09-JUN-81','DD-MON-RR'), '289', null, '431');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('39351', 'LEVI ROBERTA', 'MANAGER', '3127', to_date('09-JUN-81','DD-MON-RR'), '943', null, '431');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('32639', 'MANZONI UGO', 'MANAGER', '238', to_date('09-JUN-81','DD-MON-RR'), '630', null, '431');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('3648', 'LEVI LUIGI', 'TECHNICIAN', '1073', to_date('09-JUN-81','DD-MON-RR'), '1387', null, '431');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('33412', 'BIANCHI LUCIA', 'LAWYER', '6447', to_date('09-JUN-81','DD-MON-RR'), '1226', null, '293');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('22680', 'GRIMALDI LUDOVICO', 'PROFESSOR', '5665', to_date('09-JUN-81','DD-MON-RR'), '355', null, '293');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('4824', 'PETRARCA ELENA', 'ENGINEER', '251', to_date('09-JUN-81','DD-MON-RR'), '841', null, '293');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('49304', 'NERI GAETANO', 'PROFESSOR', '13786', to_date('09-JUN-81','DD-MON-RR'), '1222', null, '293');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('28883', 'FO GIOVANNI', 'HEADMASTER', '13607', to_date('09-JUN-81','DD-MON-RR'), '613', null, '293');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('37169', 'NERI ANGELO', 'LAWYER', '33022', to_date('09-JUN-81','DD-MON-RR'), '1974', null, '293');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('23169', 'LEOPARDI LUDOVICO', 'HEADMASTER', '5055', to_date('09-JUN-81','DD-MON-RR'), '1840', null, '293');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24554', 'BIANCHI SILVIA', 'PHDSTUDENT', '24217', to_date('09-JUN-81','DD-MON-RR'), '278', null, '293');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('16993', 'COZZA PAOLO', 'MANAGER', '1584', to_date('09-JUN-81','DD-MON-RR'), '1118', null, '7');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('39290', 'CALVINO LUCA', 'TECHNICIAN', '37952', to_date('09-JUN-81','DD-MON-RR'), '240', null, '7');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('35414', 'TIBALDI LUIGI', 'ENGINEER', '15429', to_date('09-JUN-81','DD-MON-RR'), '1999', null, '7');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('16237', 'SANTE LUCA', 'SECRETARY', '11570', to_date('09-JUN-81','DD-MON-RR'), '1652', null, '7');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('5849', 'NERI ANTONIO', 'PHDSTUDENT', '4297', to_date('09-JUN-81','DD-MON-RR'), '605', null, '7');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('45408', 'LEOPARDI ROBERTA', 'PHDSTUDENT', '19165', to_date('09-JUN-81','DD-MON-RR'), '1410', null, '7');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6749', 'LEOPARDI UGO', 'TECHNICIAN', '3505', to_date('09-JUN-81','DD-MON-RR'), '1491', null, '7');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('29795', 'PETRARCA PAOLO', 'PHDSTUDENT', '15042', to_date('09-JUN-81','DD-MON-RR'), '885', null, '7');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('35215', 'CALVINO ROBERTA', 'PROFESSOR', '17262', to_date('09-JUN-81','DD-MON-RR'), '462', null, '7');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('31739', 'SANTE DAMIANO', 'MANAGER', '13768', to_date('09-JUN-81','DD-MON-RR'), '1143', null, '243');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('36829', 'ECO UMBERTO', 'TECHNICIAN', '8988', to_date('09-JUN-81','DD-MON-RR'), '67', null, '243');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('35514', 'FO ALFONSO', 'PROFESSOR', '16992', to_date('09-JUN-81','DD-MON-RR'), '1724', null, '243');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('20619', 'PETRARCA FEDERICO', 'SUPERVISOR', '19135', to_date('09-JUN-81','DD-MON-RR'), '1539', null, '243');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('37164', 'PETRARCA LUCIA', 'PHDSTUDENT', '1221', to_date('09-JUN-81','DD-MON-RR'), '615', null, '243');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('25600', 'BIANCHI GAETANO', 'MANAGER', '9878', to_date('09-JUN-81','DD-MON-RR'), '952', null, '243');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('41216', 'GRIMALDI LUCIA', 'SUPERVISOR', '823', to_date('09-JUN-81','DD-MON-RR'), '940', null, '243');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('48486', 'ESPOSITO FEDERICO', 'HEADMASTER', '37984', to_date('09-JUN-81','DD-MON-RR'), '1768', null, '243');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38692', 'PETRARCA ROBERTA', 'TECHNICIAN', '36985', to_date('09-JUN-81','DD-MON-RR'), '551', null, '14');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('13991', 'ESPOSITO UMBERTO', 'SUPERVISOR', '5120', to_date('09-JUN-81','DD-MON-RR'), '596', null, '14');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('46034', 'CALVINO GAETANO', 'SECRETARY', '42351', to_date('09-JUN-81','DD-MON-RR'), '158', null, '14');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('3890', 'BIANCHI MASSIMO', 'LAWYER', '3697', to_date('09-JUN-81','DD-MON-RR'), '590', null, '14');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('16044', 'SANTE ELENA', 'LAWYER', '3318', to_date('09-JUN-81','DD-MON-RR'), '1053', null, '14');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47417', 'NERI ALFONSO', 'PHDSTUDENT', '17448', to_date('09-JUN-81','DD-MON-RR'), '1712', null, '14');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('45342', 'TIBALDI UGO', 'SUPERVISOR', '9481', to_date('09-JUN-81','DD-MON-RR'), '739', null, '14');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('48158', 'ECO IVANO', 'PROFESSOR', '10173', to_date('09-JUN-81','DD-MON-RR'), '1510', null, '14');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('13765', 'BIANCHI ANDREA', 'ENGINEER', '11355', to_date('09-JUN-81','DD-MON-RR'), '155', null, '450');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('48214', 'BIANCHI IVANO', 'TECHNICIAN', '7732', to_date('09-JUN-81','DD-MON-RR'), '775', null, '450');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('13422', 'CALVINO ANGELO', 'TECHNICIAN', '10581', to_date('09-JUN-81','DD-MON-RR'), '50', null, '450');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6752', 'ECO ELENA', 'HEADMASTER', '5926', to_date('09-JUN-81','DD-MON-RR'), '485', null, '450');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('34699', 'TIBALDI FEDERICO', 'SUPERVISOR', '2831', to_date('09-JUN-81','DD-MON-RR'), '268', null, '450');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('31058', 'NERI GAETANO', 'SUPERVISOR', '5605', to_date('09-JUN-81','DD-MON-RR'), '317', null, '450');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('20593', 'TIBALDI GAETANO', 'TECHNICIAN', '10821', to_date('09-JUN-81','DD-MON-RR'), '830', null, '450');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('40385', 'GRIMALDI MARIO', 'TECHNICIAN', '1237', to_date('09-JUN-81','DD-MON-RR'), '1845', null, '479');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('8504', 'CARBONE ALFONSO', 'SUPERVISOR', '7666', to_date('09-JUN-81','DD-MON-RR'), '999', null, '479');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('26054', 'MANZONI PAOLO', 'HEADMASTER', '9853', to_date('09-JUN-81','DD-MON-RR'), '1297', null, '479');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('23562', 'CORONA FRANCESCO', 'ENGINEER', '13078', to_date('09-JUN-81','DD-MON-RR'), '108', null, '479');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('45927', 'PETRARCA UMBERTO', 'HEADMASTER', '23754', to_date('09-JUN-81','DD-MON-RR'), '1674', null, '479');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('43679', 'SANTE IVANO', 'PHDSTUDENT', '2892', to_date('09-JUN-81','DD-MON-RR'), '1463', null, '479');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('141', 'LEOPARDI ANDREA', 'SUPERVISOR', '88', to_date('09-JUN-81','DD-MON-RR'), '592', null, '479');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6240', 'GRIMALDI LUCA', 'MANAGER', '4613', to_date('09-JUN-81','DD-MON-RR'), '73', null, '479');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('26183', 'TIBALDI ANTONIO', 'MANAGER', '13645', to_date('09-JUN-81','DD-MON-RR'), '211', null, '479');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('21297', 'SANTE FEDERICO', 'ENGINEER', '2644', to_date('09-JUN-81','DD-MON-RR'), '1988', null, '393');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('4106', 'LEVI ANGELO', 'HEADMASTER', '3140', to_date('09-JUN-81','DD-MON-RR'), '1585', null, '393');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('35062', 'COZZA LUDOVICO', 'MANAGER', '27337', to_date('09-JUN-81','DD-MON-RR'), '440', null, '393');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47709', 'CARBONE ALFONSO', 'MANAGER', '6191', to_date('09-JUN-81','DD-MON-RR'), '1535', null, '393');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('41904', 'CORONA DONATO', 'ENGINEER', '34397', to_date('09-JUN-81','DD-MON-RR'), '1363', null, '393');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('49523', 'GRIMALDI GAETANO', 'MANAGER', '11647', to_date('09-JUN-81','DD-MON-RR'), '1960', null, '393');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('9608', 'PETRARCA ANGELO', 'ENGINEER', '8442', to_date('09-JUN-81','DD-MON-RR'), '1979', null, '393');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('11625', 'LEVI LUCA', 'TECHNICIAN', '4666', to_date('09-JUN-81','DD-MON-RR'), '1157', null, '240');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6842', 'MANZONI UGO', 'PROFESSOR', '2612', to_date('09-JUN-81','DD-MON-RR'), '1039', null, '240');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('49934', 'FUMAROLA ELENA', 'HEADMASTER', '12678', to_date('09-JUN-81','DD-MON-RR'), '1795', null, '240');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('43128', 'LEVI CLARA', 'SECRETARY', '34633', to_date('09-JUN-81','DD-MON-RR'), '1336', null, '240');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('46253', 'GRIMALDI DAMIANO', 'PHDSTUDENT', '29695', to_date('09-JUN-81','DD-MON-RR'), '1340', null, '240');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('37114', 'MANZONI ALFONSO', 'SECRETARY', '21983', to_date('09-JUN-81','DD-MON-RR'), '1008', null, '240');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24243', 'FUMAROLA IVANO', 'TECHNICIAN', '19970', to_date('09-JUN-81','DD-MON-RR'), '258', null, '240');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('23157', 'COZZA MARIO', 'LAWYER', '8301', to_date('09-JUN-81','DD-MON-RR'), '1064', null, '240');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('7520', 'NERI UGO', 'MANAGER', '3154', to_date('09-JUN-81','DD-MON-RR'), '1929', null, '215');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('13323', 'LEVI MARIA', 'SECRETARY', '4158', to_date('09-JUN-81','DD-MON-RR'), '173', null, '215');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('20620', 'CARBONE CLARA', 'MANAGER', '18080', to_date('09-JUN-81','DD-MON-RR'), '1881', null, '215');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('39470', 'LEOPARDI ANTONIO', 'PROFESSOR', '35633', to_date('09-JUN-81','DD-MON-RR'), '1885', null, '215');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('4817', 'ECO FRANCESCO', 'PHDSTUDENT', '1282', to_date('09-JUN-81','DD-MON-RR'), '357', null, '215');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('5825', 'TIBALDI FRANCESCO', 'PROFESSOR', '4750', to_date('09-JUN-81','DD-MON-RR'), '477', null, '215');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('22965', 'CORONA ROBERTA', 'MANAGER', '20082', to_date('09-JUN-81','DD-MON-RR'), '1881', null, '215');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('439', 'LEOPARDI GAETANO', 'MANAGER', '60', to_date('09-JUN-81','DD-MON-RR'), '1539', null, '215');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6408', 'NERI PASQUALE', 'LAWYER', '2995', to_date('09-JUN-81','DD-MON-RR'), '1137', null, '392');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24793', 'LEVI UGO', 'MANAGER', '9188', to_date('09-JUN-81','DD-MON-RR'), '1285', null, '392');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('45118', 'ECO PASQUALE', 'MANAGER', '7900', to_date('09-JUN-81','DD-MON-RR'), '906', null, '392');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('12231', 'ESPOSITO MARIA', 'LAWYER', '7894', to_date('09-JUN-81','DD-MON-RR'), '874', null, '392');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('42351', 'FUMAROLA MARIO', 'PHDSTUDENT', '19537', to_date('09-JUN-81','DD-MON-RR'), '136', null, '392');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('3079', 'MANZONI PASQUALE', 'PROFESSOR', '1659', to_date('09-JUN-81','DD-MON-RR'), '293', null, '392');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47291', 'ECO COSIMO', 'ENGINEER', '20825', to_date('09-JUN-81','DD-MON-RR'), '1136', null, '392');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38529', 'ECO ELIO', 'PROFESSOR', '19727', to_date('09-JUN-81','DD-MON-RR'), '185', null, '392');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('25753', 'SANTE MARIO', 'MANAGER', '3999', to_date('09-JUN-81','DD-MON-RR'), '1716', null, '392');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47463', 'FO ANGELO', 'MANAGER', '34460', to_date('09-JUN-81','DD-MON-RR'), '879', null, '260');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('28456', 'LEOPARDI ELENA', 'PHDSTUDENT', '4266', to_date('09-JUN-81','DD-MON-RR'), '1775', null, '260');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('4704', 'NERI LUCIA', 'HEADMASTER', '2370', to_date('09-JUN-81','DD-MON-RR'), '1127', null, '260');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('34594', 'CARBONE UMBERTO', 'PHDSTUDENT', '20588', to_date('09-JUN-81','DD-MON-RR'), '773', null, '260');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('19969', 'PETRARCA MASSIMO', 'MANAGER', '2734', to_date('09-JUN-81','DD-MON-RR'), '114', null, '260');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('20161', 'SANTE SILVIA', 'HEADMASTER', '18490', to_date('09-JUN-81','DD-MON-RR'), '593', null, '260');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('5489', 'NERI LUCA', 'TECHNICIAN', '5124', to_date('09-JUN-81','DD-MON-RR'), '515', null, '260');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('9012', 'LEVI DAMIANO', 'SUPERVISOR', '2096', to_date('09-JUN-81','DD-MON-RR'), '1838', null, '13');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6739', 'TIBALDI UMBERTO', 'SECRETARY', '97', to_date('09-JUN-81','DD-MON-RR'), '1962', null, '13');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6400', 'LEVI ANGELO', 'TECHNICIAN', '627', to_date('09-JUN-81','DD-MON-RR'), '1271', null, '13');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('34764', 'CORONA UMBERTO', 'MANAGER', '4631', to_date('09-JUN-81','DD-MON-RR'), '1030', null, '13');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('7053', 'NERI DAMIANO', 'SUPERVISOR', '1351', to_date('09-JUN-81','DD-MON-RR'), '150', null, '13');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('13945', 'GRIMALDI ELIO', 'TECHNICIAN', '11042', to_date('09-JUN-81','DD-MON-RR'), '828', null, '13');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('5452', 'TIBALDI COSIMO', 'SUPERVISOR', '4169', to_date('09-JUN-81','DD-MON-RR'), '628', null, '13');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6946', 'CALVINO FEDERICO', 'PROFESSOR', '418', to_date('09-JUN-81','DD-MON-RR'), '45', null, '13');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('42942', 'FO SILVIA', 'LAWYER', '32882', to_date('09-JUN-81','DD-MON-RR'), '436', null, '13');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('3777', 'ECO ELIO', 'PROFESSOR', '2500', to_date('09-JUN-81','DD-MON-RR'), '551', null, '13');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('49862', 'LEOPARDI UGO', 'SECRETARY', '49374', to_date('09-JUN-81','DD-MON-RR'), '123', null, '330');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('16247', 'SANTE SILVIA', 'TECHNICIAN', '7918', to_date('09-JUN-81','DD-MON-RR'), '577', null, '330');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('4828', 'LEOPARDI FRANCESCO', 'MANAGER', '560', to_date('09-JUN-81','DD-MON-RR'), '50', null, '330');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('32551', 'FO MASSIMO', 'MANAGER', '1157', to_date('09-JUN-81','DD-MON-RR'), '507', null, '330');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24524', 'PETRARCA ELIO', 'PHDSTUDENT', '9685', to_date('09-JUN-81','DD-MON-RR'), '471', null, '330');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('14910', 'GRIMALDI GIOVANNI', 'SECRETARY', '2721', to_date('09-JUN-81','DD-MON-RR'), '1294', null, '330');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('5008', 'GRIMALDI UMBERTO', 'MANAGER', '121', to_date('09-JUN-81','DD-MON-RR'), '408', null, '330');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('49213', 'ECO ANTONIO', 'SECRETARY', '39604', to_date('09-JUN-81','DD-MON-RR'), '794', null, '330');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('49546', 'CORONA DONATO', 'TECHNICIAN', '27152', to_date('09-JUN-81','DD-MON-RR'), '413', null, '330');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('44426', 'ESPOSITO MARIO', 'MANAGER', '18373', to_date('09-JUN-81','DD-MON-RR'), '1431', null, '302');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('5653', 'TIBALDI LUDOVICO', 'SECRETARY', '3824', to_date('09-JUN-81','DD-MON-RR'), '1164', null, '302');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('45585', 'FUMAROLA CLARA', 'SUPERVISOR', '4726', to_date('09-JUN-81','DD-MON-RR'), '112', null, '302');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('5009', 'CALVINO CLARA', 'ENGINEER', '4767', to_date('09-JUN-81','DD-MON-RR'), '1613', null, '302');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18004', 'GRIMALDI SILVIA', 'SECRETARY', '14865', to_date('09-JUN-81','DD-MON-RR'), '1365', null, '302');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('16362', 'TIBALDI PAOLO', 'LAWYER', '9343', to_date('09-JUN-81','DD-MON-RR'), '878', null, '302');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('46195', 'GRIMALDI ELIO', 'HEADMASTER', '4784', to_date('09-JUN-81','DD-MON-RR'), '427', null, '302');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('2074', 'LEOPARDI IVANO', 'MANAGER', '43', to_date('09-JUN-81','DD-MON-RR'), '1046', null, '302');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('40591', 'PETRARCA FEDERICO', 'ENGINEER', '30303', to_date('09-JUN-81','DD-MON-RR'), '1597', null, '5');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('11684', 'ECO UMBERTO', 'TECHNICIAN', '5329', to_date('09-JUN-81','DD-MON-RR'), '1193', null, '5');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('10194', 'NERI IVANO', 'TECHNICIAN', '8101', to_date('09-JUN-81','DD-MON-RR'), '604', null, '5');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('15331', 'COZZA CLARA', 'LAWYER', '2467', to_date('09-JUN-81','DD-MON-RR'), '1731', null, '5');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('35940', 'MANZONI COSIMO', 'PHDSTUDENT', '27191', to_date('09-JUN-81','DD-MON-RR'), '440', null, '5');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('1566', 'CARBONE ANGELO', 'SUPERVISOR', '30', to_date('09-JUN-81','DD-MON-RR'), '1038', null, '5');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('40800', 'GRIMALDI PASQUALE', 'SECRETARY', '18605', to_date('09-JUN-81','DD-MON-RR'), '1202', null, '5');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('17215', 'BIANCHI LUCA', 'SUPERVISOR', '1875', to_date('09-JUN-81','DD-MON-RR'), '72', null, '219');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('44549', 'TIBALDI GAETANO', 'SUPERVISOR', '1250', to_date('09-JUN-81','DD-MON-RR'), '51', null, '219');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('8891', 'COZZA ROBERTA', 'TECHNICIAN', '3852', to_date('09-JUN-81','DD-MON-RR'), '1760', null, '219');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('2439', 'ECO PAOLO', 'SUPERVISOR', '828', to_date('09-JUN-81','DD-MON-RR'), '402', null, '219');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('8', 'BIANCHI IVANO', 'ENGINEER', '7', to_date('09-JUN-81','DD-MON-RR'), '716', null, '219');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('10178', 'TIBALDI PAOLO', 'MANAGER', '3924', to_date('09-JUN-81','DD-MON-RR'), '74', null, '219');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('16387', 'ESPOSITO LUIGI', 'PHDSTUDENT', '9945', to_date('09-JUN-81','DD-MON-RR'), '929', null, '219');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('17577', 'TIBALDI UGO', 'LAWYER', '15085', to_date('09-JUN-81','DD-MON-RR'), '1419', null, '219');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('36031', 'LEOPARDI SILVIA', 'PROFESSOR', '20414', to_date('09-JUN-81','DD-MON-RR'), '1193', null, '347');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('13104', 'CORONA FEDERICO', 'LAWYER', '4469', to_date('09-JUN-81','DD-MON-RR'), '1747', null, '347');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('45678', 'LEOPARDI ANGELO', 'MANAGER', '43076', to_date('09-JUN-81','DD-MON-RR'), '147', null, '347');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('45892', 'ESPOSITO UGO', 'PROFESSOR', '18420', to_date('09-JUN-81','DD-MON-RR'), '1054', null, '347');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('30952', 'NERI UMBERTO', 'PHDSTUDENT', '12800', to_date('09-JUN-81','DD-MON-RR'), '852', null, '347');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('39495', 'LEOPARDI ROBERTA', 'MANAGER', '20765', to_date('09-JUN-81','DD-MON-RR'), '1534', null, '347');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('13194', 'NERI MARIO', 'PHDSTUDENT', '9577', to_date('09-JUN-81','DD-MON-RR'), '944', null, '347');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('12674', 'TIBALDI SILVIA', 'PHDSTUDENT', '6101', to_date('09-JUN-81','DD-MON-RR'), '707', null, '347');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('30429', 'BIANCHI FEDERICO', 'SECRETARY', '22420', to_date('09-JUN-81','DD-MON-RR'), '1807', null, '347');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('5861', 'SANTE MASSIMO', 'MANAGER', '5155', to_date('09-JUN-81','DD-MON-RR'), '1931', null, '347');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6802', 'FUMAROLA ROBERTA', 'HEADMASTER', '5799', to_date('09-JUN-81','DD-MON-RR'), '342', null, '452');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('29186', 'SANTE FRANCESCO', 'ENGINEER', '28281', to_date('09-JUN-81','DD-MON-RR'), '875', null, '452');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('31377', 'BIANCHI DONATO', 'SUPERVISOR', '3209', to_date('09-JUN-81','DD-MON-RR'), '971', null, '452');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('19472', 'PETRARCA SILVIA', 'LAWYER', '2284', to_date('09-JUN-81','DD-MON-RR'), '8', null, '452');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('3534', 'LEVI LUCA', 'MANAGER', '2076', to_date('09-JUN-81','DD-MON-RR'), '817', null, '452');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('23551', 'NERI DAMIANO', 'PHDSTUDENT', '9370', to_date('09-JUN-81','DD-MON-RR'), '1580', null, '452');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('2427', 'NERI COSIMO', 'MANAGER', '742', to_date('09-JUN-81','DD-MON-RR'), '307', null, '452');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6390', 'NERI ELENA', 'HEADMASTER', '3989', to_date('09-JUN-81','DD-MON-RR'), '1801', null, '452');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('40110', 'SANTE LUIGI', 'SECRETARY', '5651', to_date('09-JUN-81','DD-MON-RR'), '1915', null, '452');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('8476', 'CARBONE IVANO', 'LAWYER', '2850', to_date('09-JUN-81','DD-MON-RR'), '1399', null, '70');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('16000', 'GRIMALDI COSIMO', 'TECHNICIAN', '5204', to_date('09-JUN-81','DD-MON-RR'), '614', null, '70');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('43959', 'PETRARCA ANDREA', 'PHDSTUDENT', '5914', to_date('09-JUN-81','DD-MON-RR'), '118', null, '70');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('11502', 'SANTE FRANCESCO', 'MANAGER', '10116', to_date('09-JUN-81','DD-MON-RR'), '550', null, '70');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('9475', 'ECO UMBERTO', 'LAWYER', '5775', to_date('09-JUN-81','DD-MON-RR'), '1286', null, '70');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('46256', 'BIANCHI MARIA', 'MANAGER', '20754', to_date('09-JUN-81','DD-MON-RR'), '70', null, '70');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('10715', 'MANZONI PASQUALE', 'MANAGER', '739', to_date('09-JUN-81','DD-MON-RR'), '445', null, '70');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('26343', 'BIANCHI COSIMO', 'PHDSTUDENT', '2173', to_date('09-JUN-81','DD-MON-RR'), '1802', null, '70');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('27530', 'NERI PAOLO', 'SUPERVISOR', '2991', to_date('09-JUN-81','DD-MON-RR'), '1101', null, '439');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18678', 'COZZA ANGELO', 'LAWYER', '3883', to_date('09-JUN-81','DD-MON-RR'), '1335', null, '439');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38563', 'CALVINO DAMIANO', 'HEADMASTER', '27646', to_date('09-JUN-81','DD-MON-RR'), '727', null, '439');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6572', 'LEVI SILVIA', 'HEADMASTER', '1916', to_date('09-JUN-81','DD-MON-RR'), '434', null, '439');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47919', 'MANZONI MARIA', 'MANAGER', '14472', to_date('09-JUN-81','DD-MON-RR'), '633', null, '439');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('7346', 'LEVI GAETANO', 'TECHNICIAN', '4782', to_date('09-JUN-81','DD-MON-RR'), '1931', null, '439');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('30474', 'GRIMALDI ANDREA', 'SUPERVISOR', '23540', to_date('09-JUN-81','DD-MON-RR'), '1896', null, '439');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('32', 'FUMAROLA UMBERTO', 'MANAGER', '31', to_date('09-JUN-81','DD-MON-RR'), '1661', null, '439');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('17962', 'CALVINO COSIMO', 'PROFESSOR', '1411', to_date('09-JUN-81','DD-MON-RR'), '99', null, '439');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('8538', 'ECO ROBERTA', 'PHDSTUDENT', '4435', to_date('09-JUN-81','DD-MON-RR'), '1867', null, '75');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('39983', 'SANTE LUIGI', 'TECHNICIAN', '14432', to_date('09-JUN-81','DD-MON-RR'), '637', null, '75');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('2782', 'LEVI UGO', 'HEADMASTER', '1959', to_date('09-JUN-81','DD-MON-RR'), '980', null, '75');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24752', 'CORONA ROBERTA', 'TECHNICIAN', '11306', to_date('09-JUN-81','DD-MON-RR'), '1123', null, '75');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('25812', 'GRIMALDI LUDOVICO', 'SECRETARY', '709', to_date('09-JUN-81','DD-MON-RR'), '1321', null, '75');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('36346', 'CALVINO GIOVANNI', 'LAWYER', '11091', to_date('09-JUN-81','DD-MON-RR'), '8', null, '75');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('42449', 'CORONA SILVIA', 'HEADMASTER', '33029', to_date('09-JUN-81','DD-MON-RR'), '28', null, '75');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('1482', 'TIBALDI ALFONSO', 'PHDSTUDENT', '1376', to_date('09-JUN-81','DD-MON-RR'), '1560', null, '75');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38636', 'PETRARCA LUCIA', 'LAWYER', '34589', to_date('09-JUN-81','DD-MON-RR'), '537', null, '377');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('21163', 'SANTE GAETANO', 'LAWYER', '18305', to_date('09-JUN-81','DD-MON-RR'), '70', null, '377');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('8430', 'GRIMALDI MASSIMO', 'TECHNICIAN', '3429', to_date('09-JUN-81','DD-MON-RR'), '160', null, '377');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('27925', 'TIBALDI UMBERTO', 'PROFESSOR', '436', to_date('09-JUN-81','DD-MON-RR'), '574', null, '377');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('10931', 'CALVINO MARIO', 'SECRETARY', '73', to_date('09-JUN-81','DD-MON-RR'), '1855', null, '377');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('7860', 'CORONA PAOLO', 'ENGINEER', '4379', to_date('09-JUN-81','DD-MON-RR'), '1950', null, '377');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('13907', 'LEVI PAOLO', 'SUPERVISOR', '7277', to_date('09-JUN-81','DD-MON-RR'), '744', null, '377');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18839', 'CORONA CLARA', 'ENGINEER', '7834', to_date('09-JUN-81','DD-MON-RR'), '635', null, '377');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('28780', 'FUMAROLA ELIO', 'PHDSTUDENT', '8296', to_date('09-JUN-81','DD-MON-RR'), '1601', null, '377');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('13933', 'LEOPARDI MASSIMO', 'HEADMASTER', '2560', to_date('09-JUN-81','DD-MON-RR'), '1592', null, '377');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38299', 'CORONA SILVIA', 'MANAGER', '21014', to_date('09-JUN-81','DD-MON-RR'), '1084', null, '456');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('36057', 'LEOPARDI DONATO', 'TECHNICIAN', '26070', to_date('09-JUN-81','DD-MON-RR'), '755', null, '456');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6133', 'FO SILVIA', 'PROFESSOR', '5725', to_date('09-JUN-81','DD-MON-RR'), '1966', null, '456');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24847', 'LEVI LUCA', 'SUPERVISOR', '24083', to_date('09-JUN-81','DD-MON-RR'), '1265', null, '456');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24049', 'GRIMALDI ALFONSO', 'ENGINEER', '21010', to_date('09-JUN-81','DD-MON-RR'), '1276', null, '456');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('1197', 'CALVINO LUDOVICO', 'LAWYER', '729', to_date('09-JUN-81','DD-MON-RR'), '1383', null, '456');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24133', 'LEVI ALFONSO', 'SECRETARY', '24056', to_date('09-JUN-81','DD-MON-RR'), '165', null, '456');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('49230', 'DANTE GIOVANNI', 'MANAGER', '573', to_date('09-JUN-81','DD-MON-RR'), '178', null, '456');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18495', 'ESPOSITO LUDOVICO', 'LAWYER', '17560', to_date('09-JUN-81','DD-MON-RR'), '736', null, '9');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38620', 'TIBALDI ALFONSO', 'MANAGER', '25806', to_date('09-JUN-81','DD-MON-RR'), '1207', null, '9');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('15423', 'CALVINO LUIGI', 'SECRETARY', '13926', to_date('09-JUN-81','DD-MON-RR'), '506', null, '9');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18211', 'LEVI ELENA', 'SECRETARY', '7939', to_date('09-JUN-81','DD-MON-RR'), '643', null, '9');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('21805', 'FUMAROLA MARIA', 'LAWYER', '19062', to_date('09-JUN-81','DD-MON-RR'), '1399', null, '9');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('30722', 'CARBONE ELENA', 'SECRETARY', '22918', to_date('09-JUN-81','DD-MON-RR'), '1621', null, '9');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6467', 'FUMAROLA PAOLO', 'PHDSTUDENT', '5283', to_date('09-JUN-81','DD-MON-RR'), '1726', null, '9');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('14104', 'CALVINO ALFONSO', 'ENGINEER', '9878', to_date('09-JUN-81','DD-MON-RR'), '160', null, '9');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('45018', 'MANZONI ELENA', 'PROFESSOR', '38045', to_date('09-JUN-81','DD-MON-RR'), '864', null, '9');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('7704', 'MANZONI GAETANO', 'SECRETARY', '6309', to_date('09-JUN-81','DD-MON-RR'), '1159', null, '106');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('17916', 'LEVI DAMIANO', 'LAWYER', '14772', to_date('09-JUN-81','DD-MON-RR'), '1932', null, '106');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('11731', 'FO LUCA', 'PROFESSOR', '160', to_date('09-JUN-81','DD-MON-RR'), '775', null, '106');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38878', 'FUMAROLA COSIMO', 'SECRETARY', '27188', to_date('09-JUN-81','DD-MON-RR'), '673', null, '106');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38176', 'MANZONI DONATO', 'PROFESSOR', '18107', to_date('09-JUN-81','DD-MON-RR'), '1321', null, '106');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('46893', 'LEVI PAOLO', 'PHDSTUDENT', '38465', to_date('09-JUN-81','DD-MON-RR'), '1946', null, '106');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('9424', 'SANTE ANTONIO', 'PROFESSOR', '2546', to_date('09-JUN-81','DD-MON-RR'), '1503', null, '106');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('45792', 'NERI ROBERTA', 'MANAGER', '25030', to_date('09-JUN-81','DD-MON-RR'), '66', null, '106');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('16774', 'GRIMALDI ANTONIO', 'SUPERVISOR', '4525', to_date('09-JUN-81','DD-MON-RR'), '433', null, '27');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47453', 'DANTE ANDREA', 'MANAGER', '1712', to_date('09-JUN-81','DD-MON-RR'), '1235', null, '27');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18003', 'GRIMALDI PAOLO', 'PROFESSOR', '15511', to_date('09-JUN-81','DD-MON-RR'), '1735', null, '27');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('14659', 'LEOPARDI ALFONSO', 'PROFESSOR', '11309', to_date('09-JUN-81','DD-MON-RR'), '599', null, '27');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('36879', 'FO LUCA', 'SUPERVISOR', '7746', to_date('09-JUN-81','DD-MON-RR'), '987', null, '27');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('19494', 'BIANCHI IVANO', 'MANAGER', '13376', to_date('09-JUN-81','DD-MON-RR'), '1717', null, '27');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('16600', 'PETRARCA ANGELO', 'ENGINEER', '4027', to_date('09-JUN-81','DD-MON-RR'), '869', null, '27');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('11877', 'GRIMALDI PASQUALE', 'SUPERVISOR', '8959', to_date('09-JUN-81','DD-MON-RR'), '576', null, '27');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('13662', 'FO GAETANO', 'LAWYER', '7861', to_date('09-JUN-81','DD-MON-RR'), '489', null, '27');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('44542', 'CORONA UGO', 'PHDSTUDENT', '17576', to_date('09-JUN-81','DD-MON-RR'), '1914', null, '27');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('34188', 'ECO ROBERTA', 'LAWYER', '22209', to_date('09-JUN-81','DD-MON-RR'), '1676', null, '165');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('19114', 'CARBONE CLARA', 'HEADMASTER', '13698', to_date('09-JUN-81','DD-MON-RR'), '1092', null, '165');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('35906', 'BIANCHI DONATO', 'PHDSTUDENT', '20165', to_date('09-JUN-81','DD-MON-RR'), '228', null, '165');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('14633', 'CALVINO ALFONSO', 'MANAGER', '7191', to_date('09-JUN-81','DD-MON-RR'), '1154', null, '165');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('25394', 'ECO GIOVANNI', 'ENGINEER', '19429', to_date('09-JUN-81','DD-MON-RR'), '1940', null, '165');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('39489', 'FUMAROLA GIOVANNI', 'TECHNICIAN', '23430', to_date('09-JUN-81','DD-MON-RR'), '730', null, '165');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('44879', 'ESPOSITO PAOLO', 'ENGINEER', '39040', to_date('09-JUN-81','DD-MON-RR'), '419', null, '165');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('32676', 'FO DAMIANO', 'MANAGER', '12390', to_date('09-JUN-81','DD-MON-RR'), '1161', null, '39');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('3914', 'MANZONI PAOLO', 'SECRETARY', '2057', to_date('09-JUN-81','DD-MON-RR'), '126', null, '39');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('29839', 'PETRARCA ANDREA', 'MANAGER', '25141', to_date('09-JUN-81','DD-MON-RR'), '363', null, '39');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('14513', 'COZZA GAETANO', 'PROFESSOR', '8347', to_date('09-JUN-81','DD-MON-RR'), '947', null, '39');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('27664', 'CALVINO GIOVANNI', 'SUPERVISOR', '8661', to_date('09-JUN-81','DD-MON-RR'), '1881', null, '39');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('5024', 'SANTE ANTONIO', 'ENGINEER', '3105', to_date('09-JUN-81','DD-MON-RR'), '1411', null, '39');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('41564', 'LEOPARDI IVANO', 'TECHNICIAN', '30722', to_date('09-JUN-81','DD-MON-RR'), '423', null, '39');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24205', 'LEOPARDI MARIO', 'MANAGER', '2588', to_date('09-JUN-81','DD-MON-RR'), '907', null, '39');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('34411', 'CALVINO LUDOVICO', 'HEADMASTER', '12455', to_date('09-JUN-81','DD-MON-RR'), '31', null, '80');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('29548', 'ECO IVANO', 'SECRETARY', '11974', to_date('09-JUN-81','DD-MON-RR'), '1534', null, '80');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('5026', 'PETRARCA LUCA', 'ENGINEER', '3637', to_date('09-JUN-81','DD-MON-RR'), '1485', null, '80');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('23496', 'FUMAROLA DONATO', 'MANAGER', '9854', to_date('09-JUN-81','DD-MON-RR'), '1023', null, '80');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('17078', 'PETRARCA SILVIA', 'LAWYER', '5650', to_date('09-JUN-81','DD-MON-RR'), '821', null, '80');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('13753', 'LEVI LUCIA', 'LAWYER', '6251', to_date('09-JUN-81','DD-MON-RR'), '1955', null, '80');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47755', 'PETRARCA DAMIANO', 'MANAGER', '25544', to_date('09-JUN-81','DD-MON-RR'), '1680', null, '80');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38873', 'GRIMALDI UMBERTO', 'TECHNICIAN', '24451', to_date('09-JUN-81','DD-MON-RR'), '1313', null, '80');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('12067', 'FUMAROLA GIOVANNI', 'LAWYER', '6487', to_date('09-JUN-81','DD-MON-RR'), '369', null, '470');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('43845', 'GRIMALDI FEDERICO', 'TECHNICIAN', '28369', to_date('09-JUN-81','DD-MON-RR'), '823', null, '470');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('31959', 'FUMAROLA DAMIANO', 'HEADMASTER', '12782', to_date('09-JUN-81','DD-MON-RR'), '138', null, '470');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('11752', 'PETRARCA FEDERICO', 'PHDSTUDENT', '773', to_date('09-JUN-81','DD-MON-RR'), '364', null, '470');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('17702', 'PETRARCA FEDERICO', 'TECHNICIAN', '5890', to_date('09-JUN-81','DD-MON-RR'), '879', null, '470');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('48688', 'TIBALDI ANTONIO', 'ENGINEER', '14612', to_date('09-JUN-81','DD-MON-RR'), '1273', null, '470');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('44230', 'PETRARCA MARIA', 'LAWYER', '8819', to_date('09-JUN-81','DD-MON-RR'), '1371', null, '470');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('31723', 'BIANCHI PAOLO', 'MANAGER', '6978', to_date('09-JUN-81','DD-MON-RR'), '1171', null, '470');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6502', 'CORONA COSIMO', 'LAWYER', '4993', to_date('09-JUN-81','DD-MON-RR'), '302', null, '470');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('35438', 'MANZONI FEDERICO', 'PROFESSOR', '6816', to_date('09-JUN-81','DD-MON-RR'), '296', null, '363');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38518', 'SANTE LUIGI', 'SUPERVISOR', '5887', to_date('09-JUN-81','DD-MON-RR'), '1619', null, '363');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('42424', 'MANZONI FRANCESCO', 'MANAGER', '12791', to_date('09-JUN-81','DD-MON-RR'), '1447', null, '363');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('14343', 'DANTE ANGELO', 'PHDSTUDENT', '11513', to_date('09-JUN-81','DD-MON-RR'), '732', null, '363');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('28857', 'NERI ALFONSO', 'MANAGER', '9484', to_date('09-JUN-81','DD-MON-RR'), '65', null, '363');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('20537', 'ECO PASQUALE', 'LAWYER', '14440', to_date('09-JUN-81','DD-MON-RR'), '1766', null, '363');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('8978', 'FUMAROLA SILVIA', 'MANAGER', '3733', to_date('09-JUN-81','DD-MON-RR'), '1065', null, '363');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('34123', 'ESPOSITO ANGELO', 'LAWYER', '15726', to_date('09-JUN-81','DD-MON-RR'), '13', null, '363');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('1092', 'CARBONE LUIGI', 'MANAGER', '18', to_date('09-JUN-81','DD-MON-RR'), '217', null, '440');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('14614', 'CALVINO ANGELO', 'PROFESSOR', '3647', to_date('09-JUN-81','DD-MON-RR'), '1688', null, '440');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('8970', 'SANTE PASQUALE', 'MANAGER', '2217', to_date('09-JUN-81','DD-MON-RR'), '766', null, '440');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('36227', 'DANTE ANTONIO', 'TECHNICIAN', '4425', to_date('09-JUN-81','DD-MON-RR'), '1861', null, '440');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('2678', 'CORONA GAETANO', 'MANAGER', '1695', to_date('09-JUN-81','DD-MON-RR'), '1742', null, '440');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('5029', 'PETRARCA COSIMO', 'TECHNICIAN', '4184', to_date('09-JUN-81','DD-MON-RR'), '1828', null, '440');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('9393', 'FO IVANO', 'SUPERVISOR', '4040', to_date('09-JUN-81','DD-MON-RR'), '1337', null, '440');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('33723', 'CALVINO ANGELO', 'MANAGER', '32135', to_date('09-JUN-81','DD-MON-RR'), '1750', null, '440');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('34332', 'CORONA DONATO', 'MANAGER', '16954', to_date('09-JUN-81','DD-MON-RR'), '1629', null, '258');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('40729', 'ECO LUCIA', 'HEADMASTER', '2940', to_date('09-JUN-81','DD-MON-RR'), '1625', null, '258');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47696', 'NERI UMBERTO', 'ENGINEER', '22495', to_date('09-JUN-81','DD-MON-RR'), '1505', null, '258');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('29924', 'ECO ANTONIO', 'PROFESSOR', '17020', to_date('09-JUN-81','DD-MON-RR'), '1674', null, '258');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('31409', 'PETRARCA GAETANO', 'LAWYER', '24361', to_date('09-JUN-81','DD-MON-RR'), '1158', null, '258');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('7782', 'GRIMALDI MASSIMO', 'MANAGER', '3681', to_date('09-JUN-81','DD-MON-RR'), '1765', null, '258');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('23159', 'CARBONE ALFONSO', 'MANAGER', '1028', to_date('09-JUN-81','DD-MON-RR'), '276', null, '258');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('19079', 'LEVI ALFONSO', 'HEADMASTER', '14462', to_date('09-JUN-81','DD-MON-RR'), '1552', null, '37');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('27640', 'CARBONE COSIMO', 'HEADMASTER', '18106', to_date('09-JUN-81','DD-MON-RR'), '1068', null, '37');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('41530', 'DANTE LUIGI', 'MANAGER', '36401', to_date('09-JUN-81','DD-MON-RR'), '1116', null, '37');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('35589', 'PETRARCA PASQUALE', 'ENGINEER', '8261', to_date('09-JUN-81','DD-MON-RR'), '922', null, '37');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('11359', 'CORONA GIOVANNI', 'PROFESSOR', '6664', to_date('09-JUN-81','DD-MON-RR'), '1052', null, '37');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('32973', 'BIANCHI ROBERTA', 'PROFESSOR', '19195', to_date('09-JUN-81','DD-MON-RR'), '1564', null, '37');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('2842', 'GRIMALDI MARIO', 'MANAGER', '334', to_date('09-JUN-81','DD-MON-RR'), '1697', null, '37');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6612', 'NERI DONATO', 'LAWYER', '1940', to_date('09-JUN-81','DD-MON-RR'), '327', null, '37');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6437', 'COZZA PASQUALE', 'HEADMASTER', '1565', to_date('09-JUN-81','DD-MON-RR'), '703', null, '37');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('20802', 'GRIMALDI ELIO', 'HEADMASTER', '19631', to_date('09-JUN-81','DD-MON-RR'), '1577', null, '294');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18598', 'ECO SILVIA', 'LAWYER', '3118', to_date('09-JUN-81','DD-MON-RR'), '169', null, '294');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('33322', 'LEVI DONATO', 'SUPERVISOR', '9117', to_date('09-JUN-81','DD-MON-RR'), '1204', null, '294');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18119', 'FUMAROLA LUIGI', 'PROFESSOR', '8800', to_date('09-JUN-81','DD-MON-RR'), '154', null, '294');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('9788', 'PETRARCA LUDOVICO', 'PROFESSOR', '5287', to_date('09-JUN-81','DD-MON-RR'), '1072', null, '294');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38603', 'COZZA LUIGI', 'MANAGER', '33674', to_date('09-JUN-81','DD-MON-RR'), '975', null, '294');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('22677', 'ESPOSITO FEDERICO', 'HEADMASTER', '21300', to_date('09-JUN-81','DD-MON-RR'), '1738', null, '294');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('42097', 'GRIMALDI COSIMO', 'SECRETARY', '20671', to_date('09-JUN-81','DD-MON-RR'), '3', null, '294');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('5692', 'NERI ELENA', 'SECRETARY', '2280', to_date('09-JUN-81','DD-MON-RR'), '1790', null, '17');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('3044', 'ESPOSITO MASSIMO', 'PROFESSOR', '1133', to_date('09-JUN-81','DD-MON-RR'), '916', null, '17');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('17310', 'NERI FEDERICO', 'SUPERVISOR', '98', to_date('09-JUN-81','DD-MON-RR'), '1453', null, '17');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('12013', 'CARBONE GIOVANNI', 'MANAGER', '11066', to_date('09-JUN-81','DD-MON-RR'), '56', null, '17');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('9509', 'CALVINO LUCIA', 'SUPERVISOR', '9331', to_date('09-JUN-81','DD-MON-RR'), '222', null, '17');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('27064', 'ESPOSITO COSIMO', 'PHDSTUDENT', '7373', to_date('09-JUN-81','DD-MON-RR'), '1445', null, '17');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('3632', 'CORONA PASQUALE', 'MANAGER', '2408', to_date('09-JUN-81','DD-MON-RR'), '1651', null, '17');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('30619', 'SANTE ANGELO', 'MANAGER', '16718', to_date('09-JUN-81','DD-MON-RR'), '1760', null, '17');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('40901', 'MANZONI CLARA', 'HEADMASTER', '32903', to_date('09-JUN-81','DD-MON-RR'), '134', null, '17');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('22237', 'FUMAROLA GAETANO', 'MANAGER', '8774', to_date('09-JUN-81','DD-MON-RR'), '116', null, '11');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('30747', 'CARBONE DONATO', 'MANAGER', '18799', to_date('09-JUN-81','DD-MON-RR'), '1919', null, '11');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('5906', 'LEVI ANTONIO', 'PROFESSOR', '1783', to_date('09-JUN-81','DD-MON-RR'), '1050', null, '11');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('16888', 'ECO GIOVANNI', 'PHDSTUDENT', '15985', to_date('09-JUN-81','DD-MON-RR'), '516', null, '11');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47924', 'NERI ELIO', 'PROFESSOR', '8644', to_date('09-JUN-81','DD-MON-RR'), '1298', null, '11');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('27899', 'ECO ROBERTA', 'SUPERVISOR', '14726', to_date('09-JUN-81','DD-MON-RR'), '1085', null, '11');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('17011', 'FO ELENA', 'ENGINEER', '13069', to_date('09-JUN-81','DD-MON-RR'), '802', null, '11');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38270', 'CARBONE IVANO', 'PHDSTUDENT', '13029', to_date('09-JUN-81','DD-MON-RR'), '1727', null, '11');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('43428', 'LEOPARDI MASSIMO', 'TECHNICIAN', '6014', to_date('09-JUN-81','DD-MON-RR'), '577', null, '11');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('46192', 'LEOPARDI UGO', 'MANAGER', '34180', to_date('09-JUN-81','DD-MON-RR'), '783', null, '488');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18558', 'ECO SILVIA', 'MANAGER', '13222', to_date('09-JUN-81','DD-MON-RR'), '669', null, '488');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('16805', 'DANTE ELENA', 'MANAGER', '12515', to_date('09-JUN-81','DD-MON-RR'), '1986', null, '488');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('25309', 'ECO LUCIA', 'SECRETARY', '21327', to_date('09-JUN-81','DD-MON-RR'), '545', null, '488');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('36172', 'LEOPARDI ANDREA', 'MANAGER', '29846', to_date('09-JUN-81','DD-MON-RR'), '1569', null, '488');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('36372', 'NERI FRANCESCO', 'ENGINEER', '4080', to_date('09-JUN-81','DD-MON-RR'), '1413', null, '488');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('32685', 'FUMAROLA COSIMO', 'PROFESSOR', '31991', to_date('09-JUN-81','DD-MON-RR'), '547', null, '488');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('21199', 'LEOPARDI CLARA', 'SUPERVISOR', '7217', to_date('09-JUN-81','DD-MON-RR'), '665', null, '488');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('10379', 'ESPOSITO UGO', 'ENGINEER', '5708', to_date('09-JUN-81','DD-MON-RR'), '1434', null, '221');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('21837', 'TIBALDI UGO', 'PHDSTUDENT', '16744', to_date('09-JUN-81','DD-MON-RR'), '1970', null, '221');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('38628', 'CARBONE MARIA', 'MANAGER', '18367', to_date('09-JUN-81','DD-MON-RR'), '1320', null, '221');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('26218', 'MANZONI MARIA', 'SUPERVISOR', '12040', to_date('09-JUN-81','DD-MON-RR'), '285', null, '221');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('41189', 'SANTE DONATO', 'MANAGER', '9492', to_date('09-JUN-81','DD-MON-RR'), '1201', null, '221');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('39101', 'LEVI PASQUALE', 'ENGINEER', '6865', to_date('09-JUN-81','DD-MON-RR'), '1054', null, '221');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('20056', 'CORONA MARIO', 'SUPERVISOR', '8380', to_date('09-JUN-81','DD-MON-RR'), '1974', null, '221');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('36498', 'LEOPARDI GIOVANNI', 'PROFESSOR', '18355', to_date('09-JUN-81','DD-MON-RR'), '783', null, '462');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('42937', 'SANTE ANGELO', 'SUPERVISOR', '10674', to_date('09-JUN-81','DD-MON-RR'), '921', null, '462');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('16973', 'FUMAROLA MASSIMO', 'PHDSTUDENT', '15571', to_date('09-JUN-81','DD-MON-RR'), '505', null, '462');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18198', 'ESPOSITO ROBERTA', 'MANAGER', '6618', to_date('09-JUN-81','DD-MON-RR'), '1784', null, '462');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('34599', 'ESPOSITO MARIA', 'SUPERVISOR', '21574', to_date('09-JUN-81','DD-MON-RR'), '1049', null, '462');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('31544', 'PETRARCA ELENA', 'PROFESSOR', '29751', to_date('09-JUN-81','DD-MON-RR'), '1589', null, '462');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('46052', 'NERI FEDERICO', 'HEADMASTER', '14420', to_date('09-JUN-81','DD-MON-RR'), '118', null, '462');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24089', 'NERI CLARA', 'HEADMASTER', '7887', to_date('09-JUN-81','DD-MON-RR'), '1799', null, '462');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('12802', 'BIANCHI COSIMO', 'SUPERVISOR', '4490', to_date('09-JUN-81','DD-MON-RR'), '874', null, '321');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24058', 'ESPOSITO ANGELO', 'MANAGER', '5165', to_date('09-JUN-81','DD-MON-RR'), '1407', null, '321');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('24072', 'FUMAROLA PAOLO', 'ENGINEER', '23443', to_date('09-JUN-81','DD-MON-RR'), '525', null, '321');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('35852', 'ESPOSITO GIOVANNI', 'PHDSTUDENT', '23281', to_date('09-JUN-81','DD-MON-RR'), '1878', null, '321');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('28051', 'CORONA ANGELO', 'MANAGER', '2751', to_date('09-JUN-81','DD-MON-RR'), '988', null, '321');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('17494', 'TIBALDI DONATO', 'SECRETARY', '14079', to_date('09-JUN-81','DD-MON-RR'), '1376', null, '321');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('23997', 'BIANCHI DAMIANO', 'LAWYER', '2172', to_date('09-JUN-81','DD-MON-RR'), '1579', null, '321');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('35317', 'FO LUIGI', 'MANAGER', '30579', to_date('09-JUN-81','DD-MON-RR'), '1018', null, '321');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('2132', 'CARBONE MARIO', 'MANAGER', '741', to_date('09-JUN-81','DD-MON-RR'), '1599', null, '321');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('25082', 'PETRARCA FEDERICO', 'PROFESSOR', '3979', to_date('09-JUN-81','DD-MON-RR'), '1563', null, '267');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('17008', 'LEOPARDI PASQUALE', 'TECHNICIAN', '7129', to_date('09-JUN-81','DD-MON-RR'), '245', null, '267');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('12458', 'COZZA LUDOVICO', 'HEADMASTER', '5017', to_date('09-JUN-81','DD-MON-RR'), '587', null, '267');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('45572', 'CORONA FEDERICO', 'PROFESSOR', '37292', to_date('09-JUN-81','DD-MON-RR'), '935', null, '267');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('29918', 'CORONA ELIO', 'ENGINEER', '24689', to_date('09-JUN-81','DD-MON-RR'), '1590', null, '267');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('2129', 'LEOPARDI GIOVANNI', 'LAWYER', '464', to_date('09-JUN-81','DD-MON-RR'), '828', null, '267');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('48169', 'TIBALDI ELENA', 'LAWYER', '28611', to_date('09-JUN-81','DD-MON-RR'), '820', null, '267');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('20715', 'ESPOSITO ROBERTA', 'PROFESSOR', '5642', to_date('09-JUN-81','DD-MON-RR'), '765', null, '267');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('2699', 'FUMAROLA MASSIMO', 'PROFESSOR', '1830', to_date('09-JUN-81','DD-MON-RR'), '478', null, '395');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('17922', 'TIBALDI ALFONSO', 'LAWYER', '1265', to_date('09-JUN-81','DD-MON-RR'), '148', null, '395');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('27072', 'FO CLARA', 'SUPERVISOR', '13444', to_date('09-JUN-81','DD-MON-RR'), '720', null, '395');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('22546', 'ECO GAETANO', 'LAWYER', '8838', to_date('09-JUN-81','DD-MON-RR'), '206', null, '395');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('7010', 'LEOPARDI FEDERICO', 'ENGINEER', '5211', to_date('09-JUN-81','DD-MON-RR'), '276', null, '395');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('30229', 'TIBALDI ALFONSO', 'ENGINEER', '14643', to_date('09-JUN-81','DD-MON-RR'), '1794', null, '395');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6221', 'COZZA DONATO', 'MANAGER', '2446', to_date('09-JUN-81','DD-MON-RR'), '352', null, '395');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('48326', 'COZZA PAOLO', 'PHDSTUDENT', '39579', to_date('09-JUN-81','DD-MON-RR'), '645', null, '395');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('2617', 'ECO DAMIANO', 'SECRETARY', '1580', to_date('09-JUN-81','DD-MON-RR'), '536', null, '22');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('48417', 'GRIMALDI ALFONSO', 'MANAGER', '48349', to_date('09-JUN-81','DD-MON-RR'), '999', null, '22');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47025', 'TIBALDI ELIO', 'PHDSTUDENT', '11454', to_date('09-JUN-81','DD-MON-RR'), '1097', null, '22');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('35433', 'CALVINO DONATO', 'SUPERVISOR', '29857', to_date('09-JUN-81','DD-MON-RR'), '1295', null, '22');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('21604', 'LEVI ANGELO', 'SUPERVISOR', '4254', to_date('09-JUN-81','DD-MON-RR'), '398', null, '22');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6940', 'LEVI ELIO', 'MANAGER', '333', to_date('09-JUN-81','DD-MON-RR'), '245', null, '22');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18726', 'FO LUCA', 'ENGINEER', '13107', to_date('09-JUN-81','DD-MON-RR'), '975', null, '22');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('1079', 'LEVI GAETANO', 'MANAGER', '470', to_date('09-JUN-81','DD-MON-RR'), '1101', null, '22');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('11845', 'BIANCHI FRANCESCO', 'TECHNICIAN', '7314', to_date('09-JUN-81','DD-MON-RR'), '1662', null, '300');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('48514', 'FO LUCIA', 'ENGINEER', '41915', to_date('09-JUN-81','DD-MON-RR'), '1908', null, '300');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('6943', 'CALVINO LUDOVICO', 'PHDSTUDENT', '6695', to_date('09-JUN-81','DD-MON-RR'), '518', null, '300');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('27662', 'BIANCHI ELIO', 'HEADMASTER', '12970', to_date('09-JUN-81','DD-MON-RR'), '1408', null, '300');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('42339', 'NERI DONATO', 'SECRETARY', '41866', to_date('09-JUN-81','DD-MON-RR'), '1117', null, '300');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('44438', 'CARBONE LUDOVICO', 'MANAGER', '7681', to_date('09-JUN-81','DD-MON-RR'), '487', null, '300');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('18890', 'MANZONI PAOLO', 'SECRETARY', '11374', to_date('09-JUN-81','DD-MON-RR'), '1158', null, '300');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('47666', 'PETRARCA MARIO', 'SUPERVISOR', '40430', to_date('09-JUN-81','DD-MON-RR'), '1058', null, '300');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('21660', 'LEVI ANGELO', 'SECRETARY', '13005', to_date('09-JUN-81','DD-MON-RR'), '876', null, '495');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('14481', 'NERI MASSIMO', 'HEADMASTER', '6895', to_date('09-JUN-81','DD-MON-RR'), '870', null, '495');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('36862', 'ECO CLARA', 'MANAGER', '229', to_date('09-JUN-81','DD-MON-RR'), '603', null, '495');
INSERT INTO EMP (EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO) VALUES ('23121', 'CALVINO ANTONIO', 'HEADMASTER', '1371', to_date('09-JUN-81','DD-MON-RR'), '1211', null, '495');

--------------------------------------------------------
--  DDL for Index SYS_C0063107
--------------------------------------------------------

  CREATE UNIQUE INDEX "SYS_C0063107" ON "EMP" ("EMPNO") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 2097152 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PPAP
--------------------------------------------------------

  CREATE INDEX "PPAP" ON "EMP" ("MGR") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  Constraints for Table EMP
--------------------------------------------------------

  ALTER TABLE "EMP" ADD PRIMARY KEY ("EMPNO")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 2097152 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
  ALTER TABLE "EMP" MODIFY ("EMPNO" NOT NULL ENABLE);
