--------------------------------------------------------
--  File created - 28/11/2025
--------------------------------------------------------
--------------------------------------------------------
--  DDL for Table EMP
--------------------------------------------------------

DROP TABLE "EMP";

alter session set NLS_LANGUAGE=ENGLISH; -- set month format to english strings

CREATE TABLE "EMP" 
(	"EMPNO" NUMBER(6,0), 
    "ENAME" VARCHAR2(20 BYTE), 
    "JOB" VARCHAR2(11 BYTE), 
    "MGR" NUMBER(6,0), 
    "HIREDATE" DATE, 
    "SAL" NUMBER(7,2), 
    "COMM" NUMBER(7,2), 
    "DEPTNO" NUMBER(3,0)
) SEGMENT CREATION IMMEDIATE 
PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
STORAGE(INITIAL 4194304 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
TABLESPACE "USERS" ;

REM INSERTING into EMP
SET DEFINE OFF;
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4899','ESPOSITO LUDOVICO','MANAGER','3163',to_date('09/JUN/81','DD/MON/RR'),'311',null,'193');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4900','PETRARCA FEDERICO','SECRETARY','4729',to_date('09-JUN-81','DD-MON-RR'),'602',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4901','BIANCHI ELENA','SECRETARY','537',to_date('09-JUN-81','DD-MON-RR'),'851',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4902','CORONA DAMIANO','LAWYER','2026',to_date('09-JUN-81','DD-MON-RR'),'1505',null,'71');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4903','TIBALDI GAETANO','TECHNICIAN','3607',to_date('09-JUN-81','DD-MON-RR'),'368',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4904','NERI LUCIA','MANAGER','1835',to_date('09-JUN-81','DD-MON-RR'),'564',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4905','COZZA ANGELO','SECRETARY','1556',to_date('09-JUN-81','DD-MON-RR'),'1876',null,'20');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4906','PETRARCA SILVIA','LAWYER','668',to_date('09-JUN-81','DD-MON-RR'),'1756',null,'139');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4907','ECO CLARA','SUPERVISOR','3945',to_date('09-JUN-81','DD-MON-RR'),'542',null,'217');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4908','FO ELIO','PROFESSOR','2693',to_date('09-JUN-81','DD-MON-RR'),'239',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4909','MANZONI MASSIMO','ENGINEER','2516',to_date('09-JUN-81','DD-MON-RR'),'632',null,'394');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4910','BIANCHI GAETANO','ENGINEER','356',to_date('09-JUN-81','DD-MON-RR'),'791',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4911','FO UMBERTO','MANAGER','4748',to_date('09-JUN-81','DD-MON-RR'),'1007',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4912','FO FEDERICO','HEADMASTER','4553',to_date('09-JUN-81','DD-MON-RR'),'419',null,'238');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4913','CARBONE LUCA','SUPERVISOR','228',to_date('09-JUN-81','DD-MON-RR'),'1411',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4914','CORONA ANDREA','ENGINEER','2076',to_date('09-JUN-81','DD-MON-RR'),'133',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4915','NERI LUCIA','ENGINEER','4784',to_date('09-JUN-81','DD-MON-RR'),'943',null,'356');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4916','FUMAROLA DONATO','SUPERVISOR','703',to_date('09-JUN-81','DD-MON-RR'),'1105',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4917','LEOPARDI ANTONIO','PHDSTUDENT','3421',to_date('09-JUN-81','DD-MON-RR'),'1450',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4918','ESPOSITO COSIMO','TECHNICIAN','165',to_date('09-JUN-81','DD-MON-RR'),'265',null,'31');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4919','CALVINO UMBERTO','LAWYER','4608',to_date('09-JUN-81','DD-MON-RR'),'942',null,'341');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4920','GRIMALDI LUDOVICO','MANAGER','2425',to_date('09-JUN-81','DD-MON-RR'),'1312',null,'277');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4921','PETRARCA ALFONSO','ENGINEER','1408',to_date('09-JUN-81','DD-MON-RR'),'946',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4922','ESPOSITO ANGELO','PHDSTUDENT','4236',to_date('09-JUN-81','DD-MON-RR'),'1319',null,'108');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4923','COZZA MARIA','LAWYER','2057',to_date('09-JUN-81','DD-MON-RR'),'1732',null,'217');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4924','CORONA PAOLO','ENGINEER','480',to_date('09-JUN-81','DD-MON-RR'),'1634',null,'477');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4925','GRIMALDI MARIO','HEADMASTER','4254',to_date('09-JUN-81','DD-MON-RR'),'971',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4926','CARBONE IVANO','PROFESSOR','2752',to_date('09-JUN-81','DD-MON-RR'),'1955',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4927','PETRARCA PASQUALE','LAWYER','3661',to_date('09-JUN-81','DD-MON-RR'),'1418',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4928','DANTE LUCA','SUPERVISOR','1289',to_date('09-JUN-81','DD-MON-RR'),'376',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4929','COZZA ANGELO','MANAGER','889',to_date('09-JUN-81','DD-MON-RR'),'1532',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4930','SANTE ANDREA','MANAGER','3814',to_date('09-JUN-81','DD-MON-RR'),'822',null,'298');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4931','SANTE ELIO','PHDSTUDENT','3417',to_date('09-JUN-81','DD-MON-RR'),'776',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4932','CARBONE FEDERICO','SECRETARY','4211',to_date('09-JUN-81','DD-MON-RR'),'766',null,'412');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4933','MANZONI LUDOVICO','ENGINEER','645',to_date('09-JUN-81','DD-MON-RR'),'1208',null,'391');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4934','CALVINO DAMIANO','TECHNICIAN','4209',to_date('09-JUN-81','DD-MON-RR'),'962',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4935','LEVI LUCIA','HEADMASTER','413',to_date('09-JUN-81','DD-MON-RR'),'781',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4936','ESPOSITO MASSIMO','SECRETARY','4792',to_date('09-JUN-81','DD-MON-RR'),'304',null,'197');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4937','MANZONI MASSIMO','PHDSTUDENT','1749',to_date('09-JUN-81','DD-MON-RR'),'1595',null,'209');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4938','ESPOSITO GIOVANNI','MANAGER','3826',to_date('09-JUN-81','DD-MON-RR'),'1009',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4939','NERI LUCA','LAWYER','51',to_date('09-JUN-81','DD-MON-RR'),'1819',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4940','MANZONI ANTONIO','MANAGER','4913',to_date('09-JUN-81','DD-MON-RR'),'1930',null,'77');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4941','DANTE LUDOVICO','SECRETARY','881',to_date('09-JUN-81','DD-MON-RR'),'1235',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4942','GRIMALDI ROBERTA','HEADMASTER','3008',to_date('09-JUN-81','DD-MON-RR'),'421',null,'254');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4943','PETRARCA ELENA','MANAGER','3896',to_date('09-JUN-81','DD-MON-RR'),'330',null,'193');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4944','DANTE FRANCESCO','PHDSTUDENT','4054',to_date('09-JUN-81','DD-MON-RR'),'1468',null,'176');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4945','PETRARCA CLARA','SECRETARY','3623',to_date('09-JUN-81','DD-MON-RR'),'1914',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4946','LEOPARDI GIOVANNI','MANAGER','2491',to_date('09-JUN-81','DD-MON-RR'),'614',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4947','COZZA LUCA','PROFESSOR','4860',to_date('09-JUN-81','DD-MON-RR'),'979',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4948','CALVINO ELENA','SECRETARY','1852',to_date('09-JUN-81','DD-MON-RR'),'610',null,'44');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4949','PETRARCA LUCIA','HEADMASTER','1017',to_date('09-JUN-81','DD-MON-RR'),'557',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4950','PETRARCA LUCA','MANAGER','3930',to_date('09-JUN-81','DD-MON-RR'),'1959',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4951','NERI FRANCESCO','SUPERVISOR','4167',to_date('09-JUN-81','DD-MON-RR'),'744',null,'451');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4952','CORONA UGO','LAWYER','3112',to_date('09-JUN-81','DD-MON-RR'),'1251',null,'136');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4953','CARBONE SILVIA','SECRETARY','414',to_date('09-JUN-81','DD-MON-RR'),'983',null,'47');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4954','SANTE MARIA','ENGINEER','4873',to_date('09-JUN-81','DD-MON-RR'),'918',null,'416');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4955','NERI IVANO','PHDSTUDENT','188',to_date('09-JUN-81','DD-MON-RR'),'1624',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4956','ESPOSITO FEDERICO','MANAGER','491',to_date('09-JUN-81','DD-MON-RR'),'1296',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4957','GRIMALDI MASSIMO','MANAGER','3892',to_date('09-JUN-81','DD-MON-RR'),'1168',null,'284');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4958','FO CLARA','LAWYER','4205',to_date('09-JUN-81','DD-MON-RR'),'1657',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4959','DANTE FEDERICO','TECHNICIAN','2466',to_date('09-JUN-81','DD-MON-RR'),'1968',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4960','ESPOSITO PASQUALE','PHDSTUDENT','2033',to_date('09-JUN-81','DD-MON-RR'),'1104',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4961','PETRARCA DONATO','SECRETARY','1969',to_date('09-JUN-81','DD-MON-RR'),'310',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4962','MANZONI ANDREA','MANAGER','3177',to_date('09-JUN-81','DD-MON-RR'),'1884',null,'357');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4963','CARBONE LUIGI','MANAGER','4447',to_date('09-JUN-81','DD-MON-RR'),'1697',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4964','CALVINO ANGELO','LAWYER','2513',to_date('09-JUN-81','DD-MON-RR'),'579',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4965','BIANCHI FEDERICO','PROFESSOR','1520',to_date('09-JUN-81','DD-MON-RR'),'59',null,'170');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4966','CORONA ELENA','PROFESSOR','2758',to_date('09-JUN-81','DD-MON-RR'),'1792',null,'276');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4967','FUMAROLA ANTONIO','LAWYER','4290',to_date('09-JUN-81','DD-MON-RR'),'467',null,'326');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4968','NERI PASQUALE','HEADMASTER','202',to_date('09-JUN-81','DD-MON-RR'),'678',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4969','NERI ANGELO','SUPERVISOR','3086',to_date('09-JUN-81','DD-MON-RR'),'1840',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4970','MANZONI LUCA','LAWYER','3405',to_date('09-JUN-81','DD-MON-RR'),'1247',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4971','SANTE FRANCESCO','LAWYER','2105',to_date('09-JUN-81','DD-MON-RR'),'413',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4972','MANZONI DAMIANO','HEADMASTER','3411',to_date('09-JUN-81','DD-MON-RR'),'1605',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4973','BIANCHI ELENA','MANAGER','4928',to_date('09-JUN-81','DD-MON-RR'),'846',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4974','CORONA UGO','MANAGER','3915',to_date('09-JUN-81','DD-MON-RR'),'750',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4975','FO UMBERTO','LAWYER','2860',to_date('09-JUN-81','DD-MON-RR'),'1913',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4976','CARBONE ANGELO','SECRETARY','2693',to_date('09-JUN-81','DD-MON-RR'),'812',null,'186');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4977','ECO UGO','PROFESSOR','1954',to_date('09-JUN-81','DD-MON-RR'),'137',null,'56');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4978','CALVINO MARIA','MANAGER','3722',to_date('09-JUN-81','DD-MON-RR'),'796',null,'459');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4979','DANTE LUIGI','SECRETARY','3182',to_date('09-JUN-81','DD-MON-RR'),'1356',null,'24');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4980','BIANCHI CLARA','LAWYER','511',to_date('09-JUN-81','DD-MON-RR'),'1248',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4981','SANTE ANDREA','TECHNICIAN','3897',to_date('09-JUN-81','DD-MON-RR'),'1948',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4982','COZZA ALFONSO','PROFESSOR','2323',to_date('09-JUN-81','DD-MON-RR'),'1074',null,'58');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4983','SANTE DONATO','LAWYER','382',to_date('09-JUN-81','DD-MON-RR'),'267',null,'461');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4984','ECO PASQUALE','PHDSTUDENT','3335',to_date('09-JUN-81','DD-MON-RR'),'1518',null,'245');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4985','MANZONI FRANCESCO','MANAGER','184',to_date('09-JUN-81','DD-MON-RR'),'148',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4986','COZZA GIOVANNI','MANAGER','2851',to_date('09-JUN-81','DD-MON-RR'),'947',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4987','LEOPARDI ELENA','PHDSTUDENT','1422',to_date('09-JUN-81','DD-MON-RR'),'190',null,'127');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4988','CARBONE UGO','LAWYER','4617',to_date('09-JUN-81','DD-MON-RR'),'1504',null,'386');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4989','CALVINO DONATO','MANAGER','3297',to_date('09-JUN-81','DD-MON-RR'),'834',null,'326');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4990','COZZA LUIGI','HEADMASTER','3457',to_date('09-JUN-81','DD-MON-RR'),'343',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4991','LEVI ALFONSO','PHDSTUDENT','2275',to_date('09-JUN-81','DD-MON-RR'),'113',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4992','LEOPARDI COSIMO','PROFESSOR','3719',to_date('09-JUN-81','DD-MON-RR'),'1158',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4993','BIANCHI CLARA','MANAGER','3191',to_date('09-JUN-81','DD-MON-RR'),'1813',null,'7');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4994','ECO COSIMO','PROFESSOR','1531',to_date('09-JUN-81','DD-MON-RR'),'830',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4995','ECO SILVIA','LAWYER','2917',to_date('09-JUN-81','DD-MON-RR'),'521',null,'243');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4996','BIANCHI LUIGI','PHDSTUDENT','3358',to_date('09-JUN-81','DD-MON-RR'),'1149',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4997','BIANCHI CLARA','LAWYER','133',to_date('09-JUN-81','DD-MON-RR'),'695',null,'450');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4998','DANTE LUDOVICO','MANAGER','4376',to_date('09-JUN-81','DD-MON-RR'),'1972',null,'394');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4999','BIANCHI FRANCESCO','HEADMASTER','3260',to_date('09-JUN-81','DD-MON-RR'),'1411',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5000','FO UMBERTO','PROFESSOR','735',to_date('09-JUN-81','DD-MON-RR'),'499',null,'393');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5001','GRIMALDI GAETANO','HEADMASTER','3028',to_date('09-JUN-81','DD-MON-RR'),'408',null,'240');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5002','NERI SILVIA','PROFESSOR','4783',to_date('09-JUN-81','DD-MON-RR'),'1532',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5003','CALVINO IVANO','PROFESSOR','3702',to_date('09-JUN-81','DD-MON-RR'),'510',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5004','BIANCHI ELENA','ENGINEER','365',to_date('09-JUN-81','DD-MON-RR'),'1595',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5005','LEVI DONATO','TECHNICIAN','2796',to_date('09-JUN-81','DD-MON-RR'),'1553',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5006','MANZONI ALFONSO','LAWYER','1261',to_date('09-JUN-81','DD-MON-RR'),'32',null,'260');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5007','DANTE MARIO','LAWYER','4083',to_date('09-JUN-81','DD-MON-RR'),'1213',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5008','GRIMALDI UMBERTO','MANAGER','121',to_date('09-JUN-81','DD-MON-RR'),'408',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5009','CALVINO CLARA','ENGINEER','4767',to_date('09-JUN-81','DD-MON-RR'),'1613',null,'302');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5010','TIBALDI IVANO','MANAGER','1780',to_date('09-JUN-81','DD-MON-RR'),'794',null,'5');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5011','SANTE ROBERTA','SECRETARY','2283',to_date('09-JUN-81','DD-MON-RR'),'1990',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5012','ESPOSITO PAOLO','SECRETARY','1186',to_date('09-JUN-81','DD-MON-RR'),'1086',null,'347');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5013','BIANCHI FEDERICO','SUPERVISOR','3359',to_date('09-JUN-81','DD-MON-RR'),'1628',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5014','CALVINO CLARA','LAWYER','698',to_date('09-JUN-81','DD-MON-RR'),'1108',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5015','BIANCHI MARIO','PHDSTUDENT','4907',to_date('09-JUN-81','DD-MON-RR'),'1461',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5016','FUMAROLA ANDREA','SECRETARY','2068',to_date('09-JUN-81','DD-MON-RR'),'651',null,'439');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5017','TIBALDI ALFONSO','MANAGER','4714',to_date('09-JUN-81','DD-MON-RR'),'1078',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5018','CALVINO MASSIMO','SUPERVISOR','3988',to_date('09-JUN-81','DD-MON-RR'),'945',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5019','GRIMALDI ALFONSO','MANAGER','1288',to_date('09-JUN-81','DD-MON-RR'),'1888',null,'456');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5020','DANTE LUCIA','SUPERVISOR','4537',to_date('09-JUN-81','DD-MON-RR'),'1333',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5021','CALVINO ANDREA','MANAGER','4659',to_date('09-JUN-81','DD-MON-RR'),'138',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5022','DANTE MARIO','MANAGER','2081',to_date('09-JUN-81','DD-MON-RR'),'1719',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5023','ESPOSITO MARIO','TECHNICIAN','2540',to_date('09-JUN-81','DD-MON-RR'),'579',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5024','SANTE ANTONIO','ENGINEER','3105',to_date('09-JUN-81','DD-MON-RR'),'1411',null,'39');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5025','CALVINO GIOVANNI','ENGINEER','4108',to_date('09-JUN-81','DD-MON-RR'),'1540',null,'217');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5026','PETRARCA LUCA','ENGINEER','3637',to_date('09-JUN-81','DD-MON-RR'),'1485',null,'80');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5027','ESPOSITO MASSIMO','LAWYER','2279',to_date('09-JUN-81','DD-MON-RR'),'1928',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5028','LEVI PAOLO','MANAGER','1841',to_date('09-JUN-81','DD-MON-RR'),'70',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5029','PETRARCA COSIMO','TECHNICIAN','4184',to_date('09-JUN-81','DD-MON-RR'),'1828',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5030','MANZONI ALFONSO','PHDSTUDENT','3416',to_date('09-JUN-81','DD-MON-RR'),'523',null,'258');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5031','FO ANGELO','HEADMASTER','1034',to_date('09-JUN-81','DD-MON-RR'),'1642',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5032','BIANCHI FEDERICO','HEADMASTER','2252',to_date('09-JUN-81','DD-MON-RR'),'424',null,'294');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5033','FO DONATO','MANAGER','4152',to_date('09-JUN-81','DD-MON-RR'),'174',null,'77');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5034','GRIMALDI PAOLO','ENGINEER','3654',to_date('09-JUN-81','DD-MON-RR'),'1231',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6930','LEOPARDI LUCA','PROFESSOR','3294',to_date('09-JUN-81','DD-MON-RR'),'1725',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6931','TIBALDI LUCA','SECRETARY','2546',to_date('09-JUN-81','DD-MON-RR'),'1003',null,'477');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6932','LEOPARDI ROBERTA','PHDSTUDENT','660',to_date('09-JUN-81','DD-MON-RR'),'821',null,'11');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6933','COZZA UMBERTO','PROFESSOR','287',to_date('09-JUN-81','DD-MON-RR'),'566',null,'488');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6934','PETRARCA LUDOVICO','SECRETARY','3054',to_date('09-JUN-81','DD-MON-RR'),'1108',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6935','SANTE SILVIA','TECHNICIAN','2193',to_date('09-JUN-81','DD-MON-RR'),'730',null,'221');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6936','CARBONE ANGELO','SUPERVISOR','613',to_date('09-JUN-81','DD-MON-RR'),'263',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6937','CARBONE DAMIANO','LAWYER','2092',to_date('09-JUN-81','DD-MON-RR'),'1709',null,'321');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6938','BIANCHI MARIA','SECRETARY','180',to_date('09-JUN-81','DD-MON-RR'),'86',null,'267');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6939','ESPOSITO MASSIMO','ENGINEER','5830',to_date('09-JUN-81','DD-MON-RR'),'1901',null,'395');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6940','LEVI ELIO','MANAGER','333',to_date('09-JUN-81','DD-MON-RR'),'245',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6941','DANTE DAMIANO','SECRETARY','6339',to_date('09-JUN-81','DD-MON-RR'),'1125',null,'470');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6942','CORONA LUCA','SECRETARY','487',to_date('09-JUN-81','DD-MON-RR'),'1816',null,'277');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6943','CALVINO LUDOVICO','PHDSTUDENT','6695',to_date('09-JUN-81','DD-MON-RR'),'518',null,'300');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6944','PETRARCA ALFONSO','MANAGER','5104',to_date('09-JUN-81','DD-MON-RR'),'205',null,'31');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6945','SANTE ALFONSO','PROFESSOR','1428',to_date('09-JUN-81','DD-MON-RR'),'1238',null,'495');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6946','CALVINO FEDERICO','PROFESSOR','418',to_date('09-JUN-81','DD-MON-RR'),'45',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6947','COZZA UGO','LAWYER','4876',to_date('09-JUN-81','DD-MON-RR'),'1862',null,'271');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6948','DANTE MARIA','PROFESSOR','5657',to_date('09-JUN-81','DD-MON-RR'),'1217',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6949','ESPOSITO ANTONIO','MANAGER','3654',to_date('09-JUN-81','DD-MON-RR'),'1685',null,'199');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6950','CARBONE DAMIANO','ENGINEER','3170',to_date('09-JUN-81','DD-MON-RR'),'1148',null,'294');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6951','LEOPARDI ELIO','PROFESSOR','6337',to_date('09-JUN-81','DD-MON-RR'),'1770',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6952','SANTE MARIA','PHDSTUDENT','3987',to_date('09-JUN-81','DD-MON-RR'),'1176',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6953','ESPOSITO DAMIANO','MANAGER','6201',to_date('09-JUN-81','DD-MON-RR'),'1319',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6954','LEVI ANGELO','SUPERVISOR','1558',to_date('09-JUN-81','DD-MON-RR'),'1200',null,'359');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6955','MANZONI ELENA','HEADMASTER','4136',to_date('09-JUN-81','DD-MON-RR'),'1288',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6956','MANZONI ELIO','MANAGER','6150',to_date('09-JUN-81','DD-MON-RR'),'5',null,'185');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6957','GRIMALDI ALFONSO','TECHNICIAN','1325',to_date('09-JUN-81','DD-MON-RR'),'1031',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6958','NERI PAOLO','HEADMASTER','6019',to_date('09-JUN-81','DD-MON-RR'),'1047',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6959','GRIMALDI ELIO','PHDSTUDENT','3545',to_date('09-JUN-81','DD-MON-RR'),'1349',null,'12');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6960','SANTE UGO','TECHNICIAN','2196',to_date('09-JUN-81','DD-MON-RR'),'1786',null,'428');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6961','LEOPARDI ANTONIO','TECHNICIAN','3224',to_date('09-JUN-81','DD-MON-RR'),'1924',null,'475');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6962','FO MARIO','HEADMASTER','641',to_date('09-JUN-81','DD-MON-RR'),'1519',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6963','TIBALDI ANDREA','HEADMASTER','4380',to_date('09-JUN-81','DD-MON-RR'),'660',null,'282');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6964','BIANCHI UMBERTO','ENGINEER','2819',to_date('09-JUN-81','DD-MON-RR'),'946',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6965','FUMAROLA UMBERTO','PHDSTUDENT','4481',to_date('09-JUN-81','DD-MON-RR'),'34',null,'441');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6966','CORONA UGO','SUPERVISOR','3133',to_date('09-JUN-81','DD-MON-RR'),'915',null,'461');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6967','NERI ROBERTA','HEADMASTER','2055',to_date('09-JUN-81','DD-MON-RR'),'768',null,'125');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6968','GRIMALDI MARIA','TECHNICIAN','5194',to_date('09-JUN-81','DD-MON-RR'),'1902',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6969','CORONA IVANO','TECHNICIAN','2272',to_date('09-JUN-81','DD-MON-RR'),'671',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6970','FO DAMIANO','TECHNICIAN','37',to_date('09-JUN-81','DD-MON-RR'),'818',null,'101');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6971','ECO PAOLO','LAWYER','5908',to_date('09-JUN-81','DD-MON-RR'),'720',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6972','FUMAROLA LUDOVICO','PROFESSOR','1820',to_date('09-JUN-81','DD-MON-RR'),'113',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6973','GRIMALDI LUCIA','MANAGER','1589',to_date('09-JUN-81','DD-MON-RR'),'1012',null,'302');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6974','SANTE ELENA','TECHNICIAN','1983',to_date('09-JUN-81','DD-MON-RR'),'285',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6975','SANTE DONATO','SECRETARY','6649',to_date('09-JUN-81','DD-MON-RR'),'329',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6976','BIANCHI DAMIANO','HEADMASTER','2462',to_date('09-JUN-81','DD-MON-RR'),'1799',null,'158');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6977','ESPOSITO LUCIA','ENGINEER','6659',to_date('09-JUN-81','DD-MON-RR'),'1861',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6978','LEVI ANGELO','SECRETARY','6548',to_date('09-JUN-81','DD-MON-RR'),'1341',null,'201');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6979','CARBONE MASSIMO','PHDSTUDENT','544',to_date('09-JUN-81','DD-MON-RR'),'459',null,'181');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6980','FO MASSIMO','HEADMASTER','4092',to_date('09-JUN-81','DD-MON-RR'),'1901',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6981','SANTE LUCA','MANAGER','4116',to_date('09-JUN-81','DD-MON-RR'),'919',null,'319');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6982','TIBALDI LUIGI','MANAGER','6882',to_date('09-JUN-81','DD-MON-RR'),'844',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6983','NERI LUDOVICO','PROFESSOR','122',to_date('09-JUN-81','DD-MON-RR'),'1291',null,'176');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6984','FUMAROLA LUCIA','MANAGER','4467',to_date('09-JUN-81','DD-MON-RR'),'533',null,'263');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6985','PETRARCA ALFONSO','LAWYER','3656',to_date('09-JUN-81','DD-MON-RR'),'1604',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6986','ESPOSITO FRANCESCO','HEADMASTER','6625',to_date('09-JUN-81','DD-MON-RR'),'49',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6987','CARBONE CLARA','HEADMASTER','6251',to_date('09-JUN-81','DD-MON-RR'),'1834',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6988','LEOPARDI COSIMO','TECHNICIAN','5695',to_date('09-JUN-81','DD-MON-RR'),'112',null,'142');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6989','NERI PASQUALE','TECHNICIAN','3251',to_date('09-JUN-81','DD-MON-RR'),'232',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6990','CALVINO LUIGI','LAWYER','3617',to_date('09-JUN-81','DD-MON-RR'),'1283',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6991','BIANCHI ANTONIO','SUPERVISOR','4026',to_date('09-JUN-81','DD-MON-RR'),'1599',null,'109');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6992','PETRARCA FEDERICO','ENGINEER','898',to_date('09-JUN-81','DD-MON-RR'),'562',null,'33');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6993','NERI COSIMO','SECRETARY','4898',to_date('09-JUN-81','DD-MON-RR'),'459',null,'81');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6994','COZZA ANDREA','MANAGER','3220',to_date('09-JUN-81','DD-MON-RR'),'1725',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6995','NERI SILVIA','ENGINEER','1107',to_date('09-JUN-81','DD-MON-RR'),'745',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6996','ESPOSITO IVANO','PROFESSOR','776',to_date('09-JUN-81','DD-MON-RR'),'1883',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6997','BIANCHI FEDERICO','MANAGER','3352',to_date('09-JUN-81','DD-MON-RR'),'1377',null,'416');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6998','MANZONI ALFONSO','MANAGER','4565',to_date('09-JUN-81','DD-MON-RR'),'900',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6999','CALVINO ELIO','MANAGER','3172',to_date('09-JUN-81','DD-MON-RR'),'1793',null,'369');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7000','FUMAROLA GAETANO','SUPERVISOR','566',to_date('09-JUN-81','DD-MON-RR'),'513',null,'483');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7001','COZZA GIOVANNI','PROFESSOR','6729',to_date('09-JUN-81','DD-MON-RR'),'569',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7002','TIBALDI ANTONIO','SUPERVISOR','4755',to_date('09-JUN-81','DD-MON-RR'),'186',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7003','FO ALFONSO','PHDSTUDENT','5329',to_date('09-JUN-81','DD-MON-RR'),'584',null,'361');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7004','PETRARCA ANDREA','PROFESSOR','803',to_date('09-JUN-81','DD-MON-RR'),'1119',null,'28');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7005','FO MARIA','MANAGER','3126',to_date('09-JUN-81','DD-MON-RR'),'1697',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7006','LEVI FRANCESCO','TECHNICIAN','5216',to_date('09-JUN-81','DD-MON-RR'),'810',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7007','NERI LUCA','MANAGER','5976',to_date('09-JUN-81','DD-MON-RR'),'422',null,'288');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7008','CARBONE ROBERTA','SECRETARY','4550',to_date('09-JUN-81','DD-MON-RR'),'970',null,'254');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7009','DANTE UMBERTO','HEADMASTER','3729',to_date('09-JUN-81','DD-MON-RR'),'1677',null,'87');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7010','LEOPARDI FEDERICO','ENGINEER','5211',to_date('09-JUN-81','DD-MON-RR'),'276',null,'395');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7011','LEOPARDI ANTONIO','SECRETARY','5188',to_date('09-JUN-81','DD-MON-RR'),'590',null,'320');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7012','GRIMALDI GIOVANNI','PHDSTUDENT','656',to_date('09-JUN-81','DD-MON-RR'),'333',null,'192');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7013','CALVINO ELIO','ENGINEER','6221',to_date('09-JUN-81','DD-MON-RR'),'384',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7014','GRIMALDI MASSIMO','MANAGER','76',to_date('09-JUN-81','DD-MON-RR'),'193',null,'78');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7015','MANZONI COSIMO','SECRETARY','903',to_date('09-JUN-81','DD-MON-RR'),'858',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7016','FUMAROLA ELENA','PROFESSOR','1094',to_date('09-JUN-81','DD-MON-RR'),'647',null,'416');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7017','CALVINO SILVIA','TECHNICIAN','6806',to_date('09-JUN-81','DD-MON-RR'),'54',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7018','BIANCHI GIOVANNI','ENGINEER','3249',to_date('09-JUN-81','DD-MON-RR'),'1169',null,'23');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7019','ESPOSITO CLARA','SUPERVISOR','2628',to_date('09-JUN-81','DD-MON-RR'),'1983',null,'354');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7020','TIBALDI LUCA','ENGINEER','2666',to_date('09-JUN-81','DD-MON-RR'),'612',null,'412');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7021','LEOPARDI DONATO','PROFESSOR','6344',to_date('09-JUN-81','DD-MON-RR'),'764',null,'365');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7022','NERI UMBERTO','MANAGER','6193',to_date('09-JUN-81','DD-MON-RR'),'298',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7023','CORONA COSIMO','SUPERVISOR','354',to_date('09-JUN-81','DD-MON-RR'),'1933',null,'487');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7024','BIANCHI COSIMO','PHDSTUDENT','4994',to_date('09-JUN-81','DD-MON-RR'),'795',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7025','TIBALDI GAETANO','HEADMASTER','5733',to_date('09-JUN-81','DD-MON-RR'),'618',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7026','FO LUCIA','LAWYER','341',to_date('09-JUN-81','DD-MON-RR'),'1158',null,'20');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7027','BIANCHI UGO','ENGINEER','3135',to_date('09-JUN-81','DD-MON-RR'),'394',null,'184');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7028','CORONA ANGELO','ENGINEER','3723',to_date('09-JUN-81','DD-MON-RR'),'884',null,'419');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7029','MANZONI SILVIA','TECHNICIAN','3245',to_date('09-JUN-81','DD-MON-RR'),'503',null,'130');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7030','MANZONI LUIGI','MANAGER','3758',to_date('09-JUN-81','DD-MON-RR'),'977',null,'249');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7031','LEOPARDI LUIGI','MANAGER','4385',to_date('09-JUN-81','DD-MON-RR'),'355',null,'376');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7032','SANTE PAOLO','HEADMASTER','6213',to_date('09-JUN-81','DD-MON-RR'),'808',null,'132');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7033','CALVINO GIOVANNI','TECHNICIAN','878',to_date('09-JUN-81','DD-MON-RR'),'146',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7034','CARBONE MASSIMO','ENGINEER','5814',to_date('09-JUN-81','DD-MON-RR'),'80',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7035','BIANCHI SILVIA','HEADMASTER','1946',to_date('09-JUN-81','DD-MON-RR'),'1969',null,'26');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7036','DANTE PAOLO','MANAGER','6679',to_date('09-JUN-81','DD-MON-RR'),'1148',null,'179');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7037','FUMAROLA GAETANO','SECRETARY','5424',to_date('09-JUN-81','DD-MON-RR'),'243',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7038','CALVINO MASSIMO','PHDSTUDENT','4880',to_date('09-JUN-81','DD-MON-RR'),'998',null,'169');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7039','LEOPARDI LUIGI','ENGINEER','3046',to_date('09-JUN-81','DD-MON-RR'),'580',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7040','LEVI DAMIANO','SUPERVISOR','6256',to_date('09-JUN-81','DD-MON-RR'),'1307',null,'195');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7041','CALVINO MASSIMO','TECHNICIAN','868',to_date('09-JUN-81','DD-MON-RR'),'757',null,'458');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7042','MANZONI LUIGI','LAWYER','5633',to_date('09-JUN-81','DD-MON-RR'),'1703',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7043','LEOPARDI PAOLO','SECRETARY','5538',to_date('09-JUN-81','DD-MON-RR'),'1163',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7044','TIBALDI ALFONSO','ENGINEER','290',to_date('09-JUN-81','DD-MON-RR'),'1614',null,'451');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7045','SANTE MASSIMO','ENGINEER','2856',to_date('09-JUN-81','DD-MON-RR'),'41',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7046','SANTE COSIMO','MANAGER','981',to_date('09-JUN-81','DD-MON-RR'),'170',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7047','GRIMALDI SILVIA','LAWYER','1485',to_date('09-JUN-81','DD-MON-RR'),'736',null,'337');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7048','ECO UGO','PHDSTUDENT','977',to_date('09-JUN-81','DD-MON-RR'),'1351',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7049','SANTE DONATO','MANAGER','6364',to_date('09-JUN-81','DD-MON-RR'),'1683',null,'163');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7050','BIANCHI MASSIMO','TECHNICIAN','617',to_date('09-JUN-81','DD-MON-RR'),'491',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8048','FUMAROLA MASSIMO','PHDSTUDENT','7703',to_date('09-JUN-81','DD-MON-RR'),'1190',null,'391');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8049','CORONA ALFONSO','ENGINEER','1809',to_date('09-JUN-81','DD-MON-RR'),'1513',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8050','ECO CLARA','TECHNICIAN','3430',to_date('09-JUN-81','DD-MON-RR'),'410',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8051','TIBALDI MARIA','PROFESSOR','2170',to_date('09-JUN-81','DD-MON-RR'),'1104',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8052','ESPOSITO LUCA','SECRETARY','2167',to_date('09-JUN-81','DD-MON-RR'),'895',null,'481');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8053','GRIMALDI IVANO','PROFESSOR','2225',to_date('09-JUN-81','DD-MON-RR'),'282',null,'368');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8054','COZZA ANGELO','LAWYER','6509',to_date('09-JUN-81','DD-MON-RR'),'214',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8055','PETRARCA ELIO','MANAGER','2505',to_date('09-JUN-81','DD-MON-RR'),'111',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8056','TIBALDI MASSIMO','SECRETARY','1765',to_date('09-JUN-81','DD-MON-RR'),'965',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8057','SANTE LUDOVICO','MANAGER','7078',to_date('09-JUN-81','DD-MON-RR'),'1163',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8058','GRIMALDI PAOLO','PHDSTUDENT','7916',to_date('09-JUN-81','DD-MON-RR'),'1040',null,'350');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8059','COZZA GAETANO','MANAGER','5751',to_date('09-JUN-81','DD-MON-RR'),'774',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8060','NERI ALFONSO','HEADMASTER','6878',to_date('09-JUN-81','DD-MON-RR'),'353',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8061','LEOPARDI GAETANO','HEADMASTER','4814',to_date('09-JUN-81','DD-MON-RR'),'22',null,'36');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1770','TIBALDI PAOLO','PHDSTUDENT','1458',to_date('09-JUN-81','DD-MON-RR'),'1358',null,'419');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1771','MANZONI ANTONIO','TECHNICIAN','1043',to_date('09-JUN-81','DD-MON-RR'),'897',null,'359');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1772','PETRARCA ALFONSO','MANAGER','1001',to_date('09-JUN-81','DD-MON-RR'),'1221',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1773','LEVI MARIA','MANAGER','1742',to_date('09-JUN-81','DD-MON-RR'),'1450',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1774','NERI ELENA','HEADMASTER','1727',to_date('09-JUN-81','DD-MON-RR'),'670',null,'44');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1775','TIBALDI DONATO','SECRETARY','1569',to_date('09-JUN-81','DD-MON-RR'),'495',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1776','COZZA MASSIMO','TECHNICIAN','782',to_date('09-JUN-81','DD-MON-RR'),'740',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1777','GRIMALDI PAOLO','ENGINEER','210',to_date('09-JUN-81','DD-MON-RR'),'1304',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1778','TIBALDI LUCA','ENGINEER','1048',to_date('09-JUN-81','DD-MON-RR'),'430',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1779','BIANCHI LUCIA','ENGINEER','347',to_date('09-JUN-81','DD-MON-RR'),'1771',null,'91');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1780','FO GAETANO','SUPERVISOR','1116',to_date('09-JUN-81','DD-MON-RR'),'646',null,'426');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1781','CARBONE DAMIANO','SUPERVISOR','907',to_date('09-JUN-81','DD-MON-RR'),'971',null,'2');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1782','CALVINO ELIO','MANAGER','17',to_date('09-JUN-81','DD-MON-RR'),'1528',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1783','DANTE LUCIA','SECRETARY','659',to_date('09-JUN-81','DD-MON-RR'),'353',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1784','CARBONE DONATO','HEADMASTER','891',to_date('09-JUN-81','DD-MON-RR'),'1526',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1785','MANZONI MASSIMO','PROFESSOR','513',to_date('09-JUN-81','DD-MON-RR'),'1350',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1786','FUMAROLA MASSIMO','SUPERVISOR','1386',to_date('09-JUN-81','DD-MON-RR'),'1667',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1787','MANZONI ANGELO','SUPERVISOR','1558',to_date('09-JUN-81','DD-MON-RR'),'1324',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1788','NERI IVANO','SUPERVISOR','1057',to_date('09-JUN-81','DD-MON-RR'),'1688',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1789','CORONA ANDREA','SECRETARY','1584',to_date('09-JUN-81','DD-MON-RR'),'1994',null,'393');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1790','LEVI UMBERTO','MANAGER','542',to_date('09-JUN-81','DD-MON-RR'),'1934',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1791','ECO LUCA','SECRETARY','1524',to_date('09-JUN-81','DD-MON-RR'),'1769',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1792','DANTE ELENA','PHDSTUDENT','112',to_date('09-JUN-81','DD-MON-RR'),'1075',null,'492');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1793','TIBALDI COSIMO','PROFESSOR','63',to_date('09-JUN-81','DD-MON-RR'),'1489',null,'151');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1794','DANTE CLARA','HEADMASTER','926',to_date('09-JUN-81','DD-MON-RR'),'826',null,'398');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1795','FUMAROLA ELENA','MANAGER','250',to_date('09-JUN-81','DD-MON-RR'),'1181',null,'221');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1796','SANTE FRANCESCO','SUPERVISOR','871',to_date('09-JUN-81','DD-MON-RR'),'992',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1797','SANTE PAOLO','PHDSTUDENT','855',to_date('09-JUN-81','DD-MON-RR'),'1386',null,'320');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1798','LEOPARDI SILVIA','PHDSTUDENT','1652',to_date('09-JUN-81','DD-MON-RR'),'968',null,'269');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1799','ESPOSITO ANGELO','MANAGER','38',to_date('09-JUN-81','DD-MON-RR'),'985',null,'239');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1800','CALVINO ALFONSO','LAWYER','530',to_date('09-JUN-81','DD-MON-RR'),'1872',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1801','TIBALDI UMBERTO','TECHNICIAN','521',to_date('09-JUN-81','DD-MON-RR'),'143',null,'249');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1802','FO COSIMO','ENGINEER','1492',to_date('09-JUN-81','DD-MON-RR'),'1405',null,'411');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1803','DANTE MARIA','PROFESSOR','472',to_date('09-JUN-81','DD-MON-RR'),'164',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1804','SANTE ELIO','SECRETARY','1560',to_date('09-JUN-81','DD-MON-RR'),'650',null,'112');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1805','FUMAROLA CLARA','PROFESSOR','199',to_date('09-JUN-81','DD-MON-RR'),'876',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('875','FUMAROLA ROBERTA','PHDSTUDENT','491',to_date('09-JUN-81','DD-MON-RR'),'235',null,'394');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('876','DANTE PASQUALE','PROFESSOR','632',to_date('09-JUN-81','DD-MON-RR'),'1722',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('877','FUMAROLA UMBERTO','SUPERVISOR','511',to_date('09-JUN-81','DD-MON-RR'),'1637',null,'423');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('878','NERI ELIO','ENGINEER','310',to_date('09-JUN-81','DD-MON-RR'),'848',null,'57');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('879','CARBONE MARIO','SECRETARY','78',to_date('09-JUN-81','DD-MON-RR'),'1501',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('880','ESPOSITO LUCA','SUPERVISOR','573',to_date('09-JUN-81','DD-MON-RR'),'1605',null,'54');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('881','ESPOSITO DAMIANO','LAWYER','462',to_date('09-JUN-81','DD-MON-RR'),'1334',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('882','MANZONI FRANCESCO','MANAGER','157',to_date('09-JUN-81','DD-MON-RR'),'455',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('883','NERI UGO','TECHNICIAN','834',to_date('09-JUN-81','DD-MON-RR'),'1997',null,'333');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('884','CALVINO MARIA','MANAGER','709',to_date('09-JUN-81','DD-MON-RR'),'627',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('885','ECO LUCIA','ENGINEER','821',to_date('09-JUN-81','DD-MON-RR'),'1023',null,'129');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('886','MANZONI MASSIMO','MANAGER','636',to_date('09-JUN-81','DD-MON-RR'),'954',null,'436');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('887','DANTE FRANCESCO','PROFESSOR','551',to_date('09-JUN-81','DD-MON-RR'),'991',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('888','LEOPARDI UMBERTO','PHDSTUDENT','40',to_date('09-JUN-81','DD-MON-RR'),'933',null,'194');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('889','CARBONE DONATO','TECHNICIAN','158',to_date('09-JUN-81','DD-MON-RR'),'660',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('890','SANTE PAOLO','TECHNICIAN','756',to_date('09-JUN-81','DD-MON-RR'),'391',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('891','PETRARCA ANDREA','LAWYER','279',to_date('09-JUN-81','DD-MON-RR'),'1904',null,'363');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('892','CARBONE FEDERICO','TECHNICIAN','627',to_date('09-JUN-81','DD-MON-RR'),'1669',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('893','ECO PASQUALE','SUPERVISOR','747',to_date('09-JUN-81','DD-MON-RR'),'1367',null,'264');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('894','FUMAROLA DAMIANO','PHDSTUDENT','750',to_date('09-JUN-81','DD-MON-RR'),'1151',null,'193');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('895','LEVI GAETANO','MANAGER','495',to_date('09-JUN-81','DD-MON-RR'),'1637',null,'424');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('896','PETRARCA ANTONIO','MANAGER','92',to_date('09-JUN-81','DD-MON-RR'),'483',null,'18');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('897','PETRARCA DAMIANO','SUPERVISOR','785',to_date('09-JUN-81','DD-MON-RR'),'263',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('898','CORONA PASQUALE','MANAGER','428',to_date('09-JUN-81','DD-MON-RR'),'832',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('899','MANZONI PAOLO','HEADMASTER','56',to_date('09-JUN-81','DD-MON-RR'),'961',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('900','PETRARCA GIOVANNI','SUPERVISOR','94',to_date('09-JUN-81','DD-MON-RR'),'1602',null,'83');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('901','TIBALDI IVANO','ENGINEER','34',to_date('09-JUN-81','DD-MON-RR'),'1514',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('902','FUMAROLA ELIO','ENGINEER','291',to_date('09-JUN-81','DD-MON-RR'),'925',null,'448');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('903','CORONA LUIGI','SECRETARY','116',to_date('09-JUN-81','DD-MON-RR'),'712',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('904','PETRARCA FRANCESCO','SUPERVISOR','304',to_date('09-JUN-81','DD-MON-RR'),'852',null,'6');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('905','CORONA ANDREA','SECRETARY','56',to_date('09-JUN-81','DD-MON-RR'),'1962',null,'31');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('906','LEVI ANDREA','MANAGER','292',to_date('09-JUN-81','DD-MON-RR'),'1948',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('907','LEOPARDI GAETANO','PHDSTUDENT','383',to_date('09-JUN-81','DD-MON-RR'),'744',null,'262');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('908','FUMAROLA IVANO','MANAGER','721',to_date('09-JUN-81','DD-MON-RR'),'1817',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('909','DANTE LUCIA','TECHNICIAN','198',to_date('09-JUN-81','DD-MON-RR'),'1558',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('910','DANTE GIOVANNI','SECRETARY','449',to_date('09-JUN-81','DD-MON-RR'),'1113',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('911','MANZONI LUCA','SUPERVISOR','248',to_date('09-JUN-81','DD-MON-RR'),'217',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('912','CORONA PASQUALE','PROFESSOR','736',to_date('09-JUN-81','DD-MON-RR'),'380',null,'368');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('913','FO SILVIA','LAWYER','671',to_date('09-JUN-81','DD-MON-RR'),'607',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('914','CORONA ANTONIO','PHDSTUDENT','563',to_date('09-JUN-81','DD-MON-RR'),'415',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('915','NERI ELIO','MANAGER','539',to_date('09-JUN-81','DD-MON-RR'),'1866',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('916','TIBALDI ANGELO','ENGINEER','309',to_date('09-JUN-81','DD-MON-RR'),'1524',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('917','COZZA ANTONIO','TECHNICIAN','17',to_date('09-JUN-81','DD-MON-RR'),'633',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('918','LEOPARDI UMBERTO','PROFESSOR','249',to_date('09-JUN-81','DD-MON-RR'),'769',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('919','CORONA ELENA','SUPERVISOR','519',to_date('09-JUN-81','DD-MON-RR'),'990',null,'280');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('920','FO LUDOVICO','SUPERVISOR','326',to_date('09-JUN-81','DD-MON-RR'),'500',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('921','ESPOSITO ALFONSO','LAWYER','496',to_date('09-JUN-81','DD-MON-RR'),'1168',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('922','CALVINO IVANO','SUPERVISOR','453',to_date('09-JUN-81','DD-MON-RR'),'513',null,'5');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('923','GRIMALDI ALFONSO','MANAGER','95',to_date('09-JUN-81','DD-MON-RR'),'569',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('924','COZZA ANTONIO','LAWYER','758',to_date('09-JUN-81','DD-MON-RR'),'1095',null,'209');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('925','CARBONE FEDERICO','MANAGER','354',to_date('09-JUN-81','DD-MON-RR'),'231',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('926','GRIMALDI ELENA','MANAGER','686',to_date('09-JUN-81','DD-MON-RR'),'1416',null,'80');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('927','COZZA ANDREA','SECRETARY','575',to_date('09-JUN-81','DD-MON-RR'),'664',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('928','CALVINO ELIO','HEADMASTER','271',to_date('09-JUN-81','DD-MON-RR'),'957',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('929','GRIMALDI COSIMO','MANAGER','242',to_date('09-JUN-81','DD-MON-RR'),'1535',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('930','DANTE PASQUALE','SUPERVISOR','707',to_date('09-JUN-81','DD-MON-RR'),'1067',null,'179');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('931','GRIMALDI PAOLO','HEADMASTER','620',to_date('09-JUN-81','DD-MON-RR'),'1184',null,'118');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('932','DANTE SILVIA','PROFESSOR','210',to_date('09-JUN-81','DD-MON-RR'),'279',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('933','TIBALDI ELENA','LAWYER','513',to_date('09-JUN-81','DD-MON-RR'),'128',null,'132');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('934','NERI ELIO','MANAGER','409',to_date('09-JUN-81','DD-MON-RR'),'1325',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('935','BIANCHI CLARA','PROFESSOR','153',to_date('09-JUN-81','DD-MON-RR'),'206',null,'331');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('936','FO DONATO','TECHNICIAN','49',to_date('09-JUN-81','DD-MON-RR'),'1720',null,'53');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('937','LEOPARDI ELENA','HEADMASTER','344',to_date('09-JUN-81','DD-MON-RR'),'1827',null,'382');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('938','GRIMALDI DAMIANO','SUPERVISOR','528',to_date('09-JUN-81','DD-MON-RR'),'694',null,'300');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('939','MANZONI LUCA','SUPERVISOR','35',to_date('09-JUN-81','DD-MON-RR'),'578',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('940','MANZONI MASSIMO','MANAGER','136',to_date('09-JUN-81','DD-MON-RR'),'749',null,'55');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('941','MANZONI FRANCESCO','SUPERVISOR','303',to_date('09-JUN-81','DD-MON-RR'),'1903',null,'82');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('942','MANZONI COSIMO','HEADMASTER','51',to_date('09-JUN-81','DD-MON-RR'),'1220',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('943','CALVINO DAMIANO','LAWYER','337',to_date('09-JUN-81','DD-MON-RR'),'1902',null,'455');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('944','DANTE UGO','TECHNICIAN','907',to_date('09-JUN-81','DD-MON-RR'),'1632',null,'25');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('945','BIANCHI LUCA','MANAGER','599',to_date('09-JUN-81','DD-MON-RR'),'1955',null,'317');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('946','ESPOSITO DONATO','PHDSTUDENT','49',to_date('09-JUN-81','DD-MON-RR'),'217',null,'243');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('947','CARBONE MASSIMO','MANAGER','67',to_date('09-JUN-81','DD-MON-RR'),'1186',null,'169');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('948','MANZONI LUIGI','MANAGER','381',to_date('09-JUN-81','DD-MON-RR'),'1543',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('949','LEOPARDI ANGELO','MANAGER','71',to_date('09-JUN-81','DD-MON-RR'),'1383',null,'136');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('950','NERI MARIA','PROFESSOR','367',to_date('09-JUN-81','DD-MON-RR'),'1906',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('951','LEOPARDI UMBERTO','LAWYER','529',to_date('09-JUN-81','DD-MON-RR'),'1503',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('952','SANTE UGO','SECRETARY','734',to_date('09-JUN-81','DD-MON-RR'),'83',null,'54');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('953','NERI ANDREA','SUPERVISOR','797',to_date('09-JUN-81','DD-MON-RR'),'567',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('954','GRIMALDI DAMIANO','PHDSTUDENT','926',to_date('09-JUN-81','DD-MON-RR'),'1343',null,'358');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('955','CALVINO ELIO','MANAGER','334',to_date('09-JUN-81','DD-MON-RR'),'367',null,'494');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('956','CALVINO ANGELO','TECHNICIAN','290',to_date('09-JUN-81','DD-MON-RR'),'1527',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('957','GRIMALDI ANDREA','MANAGER','763',to_date('09-JUN-81','DD-MON-RR'),'1158',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('958','BIANCHI PAOLO','MANAGER','413',to_date('09-JUN-81','DD-MON-RR'),'1053',null,'308');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('959','LEVI FRANCESCO','SECRETARY','720',to_date('09-JUN-81','DD-MON-RR'),'26',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('960','LEVI MARIA','ENGINEER','483',to_date('09-JUN-81','DD-MON-RR'),'1216',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('961','LEVI DONATO','ENGINEER','172',to_date('09-JUN-81','DD-MON-RR'),'691',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('962','NERI LUDOVICO','HEADMASTER','28',to_date('09-JUN-81','DD-MON-RR'),'851',null,'111');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('963','CARBONE ALFONSO','ENGINEER','784',to_date('09-JUN-81','DD-MON-RR'),'1528',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('964','SANTE MASSIMO','SUPERVISOR','620',to_date('09-JUN-81','DD-MON-RR'),'483',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('965','SANTE IVANO','PROFESSOR','203',to_date('09-JUN-81','DD-MON-RR'),'427',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('966','LEOPARDI PAOLO','SECRETARY','145',to_date('09-JUN-81','DD-MON-RR'),'1770',null,'374');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('967','ECO FRANCESCO','PROFESSOR','610',to_date('09-JUN-81','DD-MON-RR'),'1069',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('968','BIANCHI DONATO','ENGINEER','742',to_date('09-JUN-81','DD-MON-RR'),'1662',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('969','MANZONI SILVIA','ENGINEER','667',to_date('09-JUN-81','DD-MON-RR'),'1810',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('970','CARBONE UMBERTO','MANAGER','908',to_date('09-JUN-81','DD-MON-RR'),'1290',null,'277');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('971','CARBONE GAETANO','MANAGER','681',to_date('09-JUN-81','DD-MON-RR'),'1746',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('972','FO DONATO','TECHNICIAN','803',to_date('09-JUN-81','DD-MON-RR'),'981',null,'93');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('686','LEOPARDI FRANCESCO','LAWYER','34',to_date('09-JUN-81','DD-MON-RR'),'513',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2870','NERI FEDERICO','LAWYER','2505',to_date('09-JUN-81','DD-MON-RR'),'1030',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2871','MANZONI MASSIMO','SECRETARY','2433',to_date('09-JUN-81','DD-MON-RR'),'780',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2872','ECO ANTONIO','TECHNICIAN','371',to_date('09-JUN-81','DD-MON-RR'),'368',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2873','NERI MASSIMO','PROFESSOR','2381',to_date('09-JUN-81','DD-MON-RR'),'1170',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2874','ECO PAOLO','LAWYER','2621',to_date('09-JUN-81','DD-MON-RR'),'1605',null,'341');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2875','GRIMALDI ANDREA','SUPERVISOR','973',to_date('09-JUN-81','DD-MON-RR'),'673',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2876','LEVI UMBERTO','SUPERVISOR','663',to_date('09-JUN-81','DD-MON-RR'),'863',null,'311');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2877','CORONA FRANCESCO','PROFESSOR','827',to_date('09-JUN-81','DD-MON-RR'),'173',null,'264');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2878','FUMAROLA ANDREA','TECHNICIAN','760',to_date('09-JUN-81','DD-MON-RR'),'1579',null,'168');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2879','GRIMALDI MASSIMO','MANAGER','2599',to_date('09-JUN-81','DD-MON-RR'),'1315',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2880','CALVINO ELENA','MANAGER','1300',to_date('09-JUN-81','DD-MON-RR'),'1817',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2881','ECO ANTONIO','PHDSTUDENT','186',to_date('09-JUN-81','DD-MON-RR'),'1625',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2882','BIANCHI LUCIA','SUPERVISOR','93',to_date('09-JUN-81','DD-MON-RR'),'1475',null,'233');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2883','ESPOSITO ELIO','HEADMASTER','903',to_date('09-JUN-81','DD-MON-RR'),'1744',null,'108');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2884','FO GIOVANNI','ENGINEER','1312',to_date('09-JUN-81','DD-MON-RR'),'1303',null,'309');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2885','COZZA CLARA','MANAGER','384',to_date('09-JUN-81','DD-MON-RR'),'1379',null,'49');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2886','DANTE ALFONSO','MANAGER','1537',to_date('09-JUN-81','DD-MON-RR'),'1171',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2887','ECO MARIA','MANAGER','970',to_date('09-JUN-81','DD-MON-RR'),'613',null,'341');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2888','PETRARCA MARIA','LAWYER','666',to_date('09-JUN-81','DD-MON-RR'),'362',null,'81');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2889','LEOPARDI PAOLO','MANAGER','1184',to_date('09-JUN-81','DD-MON-RR'),'574',null,'281');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2890','COZZA MARIA','MANAGER','635',to_date('09-JUN-81','DD-MON-RR'),'965',null,'245');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2891','FUMAROLA MARIO','ENGINEER','0',to_date('09-JUN-81','DD-MON-RR'),'1113',null,'299');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2892','PETRARCA UGO','SECRETARY','1268',to_date('09-JUN-81','DD-MON-RR'),'1696',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2893','ECO FEDERICO','MANAGER','1188',to_date('09-JUN-81','DD-MON-RR'),'1764',null,'114');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2894','LEVI LUCA','SECRETARY','1400',to_date('09-JUN-81','DD-MON-RR'),'1480',null,'173');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2895','SANTE MARIA','PROFESSOR','2454',to_date('09-JUN-81','DD-MON-RR'),'1979',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2896','FO ANDREA','MANAGER','1017',to_date('09-JUN-81','DD-MON-RR'),'617',null,'379');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2897','SANTE FEDERICO','PHDSTUDENT','2380',to_date('09-JUN-81','DD-MON-RR'),'483',null,'60');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2898','NERI ANGELO','PROFESSOR','138',to_date('09-JUN-81','DD-MON-RR'),'1546',null,'327');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2899','PETRARCA FEDERICO','ENGINEER','975',to_date('09-JUN-81','DD-MON-RR'),'1660',null,'362');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2900','NERI ROBERTA','LAWYER','1103',to_date('09-JUN-81','DD-MON-RR'),'1450',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2901','CARBONE IVANO','TECHNICIAN','2214',to_date('09-JUN-81','DD-MON-RR'),'830',null,'50');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2902','PETRARCA LUCIA','HEADMASTER','2309',to_date('09-JUN-81','DD-MON-RR'),'372',null,'73');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2903','LEVI IVANO','LAWYER','2000',to_date('09-JUN-81','DD-MON-RR'),'469',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2904','FUMAROLA ROBERTA','MANAGER','954',to_date('09-JUN-81','DD-MON-RR'),'1694',null,'229');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2905','ECO DONATO','ENGINEER','1593',to_date('09-JUN-81','DD-MON-RR'),'1823',null,'30');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2906','ECO PASQUALE','MANAGER','2400',to_date('09-JUN-81','DD-MON-RR'),'470',null,'269');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2907','SANTE ELIO','PROFESSOR','2421',to_date('09-JUN-81','DD-MON-RR'),'1108',null,'45');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2908','ESPOSITO FRANCESCO','MANAGER','1419',to_date('09-JUN-81','DD-MON-RR'),'319',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2909','CALVINO ANGELO','LAWYER','1159',to_date('09-JUN-81','DD-MON-RR'),'1664',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2910','LEVI ALFONSO','SECRETARY','561',to_date('09-JUN-81','DD-MON-RR'),'868',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2911','FUMAROLA DAMIANO','PHDSTUDENT','1102',to_date('09-JUN-81','DD-MON-RR'),'586',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2912','CARBONE COSIMO','MANAGER','2396',to_date('09-JUN-81','DD-MON-RR'),'108',null,'166');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2913','COZZA IVANO','HEADMASTER','557',to_date('09-JUN-81','DD-MON-RR'),'1043',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2914','PETRARCA DAMIANO','LAWYER','2118',to_date('09-JUN-81','DD-MON-RR'),'1381',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2915','FO MARIO','LAWYER','2912',to_date('09-JUN-81','DD-MON-RR'),'1482',null,'310');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2916','TIBALDI PAOLO','TECHNICIAN','285',to_date('09-JUN-81','DD-MON-RR'),'747',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2917','PETRARCA LUCIA','HEADMASTER','2618',to_date('09-JUN-81','DD-MON-RR'),'230',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2918','CORONA CLARA','MANAGER','104',to_date('09-JUN-81','DD-MON-RR'),'441',null,'106');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2919','PETRARCA FEDERICO','PHDSTUDENT','1365',to_date('09-JUN-81','DD-MON-RR'),'1302',null,'97');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2920','FUMAROLA ALFONSO','ENGINEER','2786',to_date('09-JUN-81','DD-MON-RR'),'495',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2921','FO ANTONIO','LAWYER','1935',to_date('09-JUN-81','DD-MON-RR'),'1317',null,'426');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2922','DANTE FRANCESCO','SECRETARY','1889',to_date('09-JUN-81','DD-MON-RR'),'1350',null,'130');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2923','GRIMALDI LUCA','TECHNICIAN','2906',to_date('09-JUN-81','DD-MON-RR'),'1884',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2924','NERI ANTONIO','SUPERVISOR','2081',to_date('09-JUN-81','DD-MON-RR'),'820',null,'43');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2925','DANTE SILVIA','SUPERVISOR','1904',to_date('09-JUN-81','DD-MON-RR'),'265',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2926','LEOPARDI MASSIMO','MANAGER','1800',to_date('09-JUN-81','DD-MON-RR'),'740',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2927','GRIMALDI ANGELO','LAWYER','1798',to_date('09-JUN-81','DD-MON-RR'),'121',null,'127');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2928','CARBONE COSIMO','MANAGER','486',to_date('09-JUN-81','DD-MON-RR'),'717',null,'51');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2929','CALVINO UGO','SUPERVISOR','329',to_date('09-JUN-81','DD-MON-RR'),'554',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2930','ECO COSIMO','HEADMASTER','1564',to_date('09-JUN-81','DD-MON-RR'),'1671',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2931','CORONA UMBERTO','ENGINEER','763',to_date('09-JUN-81','DD-MON-RR'),'1174',null,'422');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2932','CALVINO GAETANO','MANAGER','1883',to_date('09-JUN-81','DD-MON-RR'),'1341',null,'159');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2933','CORONA LUIGI','SUPERVISOR','171',to_date('09-JUN-81','DD-MON-RR'),'1425',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2934','DANTE FRANCESCO','PHDSTUDENT','609',to_date('09-JUN-81','DD-MON-RR'),'1004',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2935','BIANCHI DAMIANO','PROFESSOR','873',to_date('09-JUN-81','DD-MON-RR'),'469',null,'453');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2936','LEOPARDI IVANO','PROFESSOR','1581',to_date('09-JUN-81','DD-MON-RR'),'1224',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2937','CALVINO ELIO','HEADMASTER','1885',to_date('09-JUN-81','DD-MON-RR'),'633',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2938','FO ELENA','ENGINEER','1896',to_date('09-JUN-81','DD-MON-RR'),'545',null,'225');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2939','NERI LUIGI','ENGINEER','871',to_date('09-JUN-81','DD-MON-RR'),'1284',null,'171');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2940','PETRARCA LUDOVICO','TECHNICIAN','741',to_date('09-JUN-81','DD-MON-RR'),'1206',null,'139');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2941','COZZA GAETANO','MANAGER','107',to_date('09-JUN-81','DD-MON-RR'),'412',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2942','CORONA IVANO','MANAGER','66',to_date('09-JUN-81','DD-MON-RR'),'462',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2943','DANTE MARIO','PHDSTUDENT','2803',to_date('09-JUN-81','DD-MON-RR'),'1676',null,'360');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2944','LEVI GIOVANNI','PHDSTUDENT','719',to_date('09-JUN-81','DD-MON-RR'),'1645',null,'398');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2945','ESPOSITO FEDERICO','ENGINEER','1859',to_date('09-JUN-81','DD-MON-RR'),'513',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2946','ESPOSITO LUCA','HEADMASTER','1594',to_date('09-JUN-81','DD-MON-RR'),'904',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2947','ECO MASSIMO','PHDSTUDENT','2067',to_date('09-JUN-81','DD-MON-RR'),'1952',null,'200');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2948','DANTE LUDOVICO','PROFESSOR','1134',to_date('09-JUN-81','DD-MON-RR'),'286',null,'215');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2949','SANTE MARIO','PHDSTUDENT','771',to_date('09-JUN-81','DD-MON-RR'),'1582',null,'390');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2950','PETRARCA PAOLO','HEADMASTER','481',to_date('09-JUN-81','DD-MON-RR'),'19',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2951','GRIMALDI LUCA','PROFESSOR','723',to_date('09-JUN-81','DD-MON-RR'),'923',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2952','GRIMALDI SILVIA','SECRETARY','2940',to_date('09-JUN-81','DD-MON-RR'),'1894',null,'419');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2953','LEOPARDI UGO','PROFESSOR','2926',to_date('09-JUN-81','DD-MON-RR'),'536',null,'86');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2954','DANTE FRANCESCO','SECRETARY','1124',to_date('09-JUN-81','DD-MON-RR'),'1271',null,'255');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2955','SANTE MARIA','TECHNICIAN','2797',to_date('09-JUN-81','DD-MON-RR'),'1717',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2956','CARBONE PAOLO','PHDSTUDENT','1319',to_date('09-JUN-81','DD-MON-RR'),'1949',null,'140');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2957','TIBALDI SILVIA','HEADMASTER','647',to_date('09-JUN-81','DD-MON-RR'),'1593',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2958','CARBONE ELENA','PHDSTUDENT','261',to_date('09-JUN-81','DD-MON-RR'),'370',null,'313');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2959','PETRARCA CLARA','SECRETARY','2905',to_date('09-JUN-81','DD-MON-RR'),'1977',null,'318');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2960','NERI MASSIMO','ENGINEER','1133',to_date('09-JUN-81','DD-MON-RR'),'193',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2961','GRIMALDI MARIA','LAWYER','303',to_date('09-JUN-81','DD-MON-RR'),'1063',null,'447');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2962','FO PASQUALE','TECHNICIAN','2699',to_date('09-JUN-81','DD-MON-RR'),'213',null,'245');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2963','CALVINO MASSIMO','ENGINEER','2205',to_date('09-JUN-81','DD-MON-RR'),'507',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2964','ECO LUCIA','MANAGER','1101',to_date('09-JUN-81','DD-MON-RR'),'994',null,'233');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2965','PETRARCA ELIO','SECRETARY','1008',to_date('09-JUN-81','DD-MON-RR'),'747',null,'357');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2966','MANZONI ANGELO','LAWYER','1337',to_date('09-JUN-81','DD-MON-RR'),'1518',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2967','CORONA IVANO','SECRETARY','120',to_date('09-JUN-81','DD-MON-RR'),'109',null,'162');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2968','ECO LUCIA','TECHNICIAN','648',to_date('09-JUN-81','DD-MON-RR'),'370',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2969','DANTE LUIGI','MANAGER','1687',to_date('09-JUN-81','DD-MON-RR'),'1854',null,'378');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2970','BIANCHI DAMIANO','MANAGER','1939',to_date('09-JUN-81','DD-MON-RR'),'550',null,'60');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2971','NERI DONATO','SECRETARY','494',to_date('09-JUN-81','DD-MON-RR'),'514',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2972','LEOPARDI GAETANO','PHDSTUDENT','2126',to_date('09-JUN-81','DD-MON-RR'),'1287',null,'367');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2973','ESPOSITO ALFONSO','MANAGER','1576',to_date('09-JUN-81','DD-MON-RR'),'789',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2974','LEOPARDI PASQUALE','PROFESSOR','1584',to_date('09-JUN-81','DD-MON-RR'),'105',null,'421');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2975','ECO DAMIANO','LAWYER','108',to_date('09-JUN-81','DD-MON-RR'),'1482',null,'27');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2976','LEOPARDI MASSIMO','ENGINEER','2782',to_date('09-JUN-81','DD-MON-RR'),'550',null,'58');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2977','COZZA ANTONIO','LAWYER','450',to_date('09-JUN-81','DD-MON-RR'),'975',null,'181');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2978','NERI ELENA','LAWYER','179',to_date('09-JUN-81','DD-MON-RR'),'116',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2979','FUMAROLA UMBERTO','PROFESSOR','1001',to_date('09-JUN-81','DD-MON-RR'),'1729',null,'235');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2980','MANZONI PASQUALE','LAWYER','2855',to_date('09-JUN-81','DD-MON-RR'),'381',null,'150');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2981','ESPOSITO MARIA','PROFESSOR','2601',to_date('09-JUN-81','DD-MON-RR'),'566',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2982','LEVI FRANCESCO','LAWYER','2118',to_date('09-JUN-81','DD-MON-RR'),'1811',null,'472');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2983','ESPOSITO MARIA','LAWYER','1832',to_date('09-JUN-81','DD-MON-RR'),'1703',null,'265');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2984','CALVINO COSIMO','HEADMASTER','2890',to_date('09-JUN-81','DD-MON-RR'),'1216',null,'364');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2985','LEVI DONATO','PROFESSOR','2',to_date('09-JUN-81','DD-MON-RR'),'1492',null,'37');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2986','CARBONE COSIMO','MANAGER','2129',to_date('09-JUN-81','DD-MON-RR'),'1262',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2987','GRIMALDI FRANCESCO','PROFESSOR','2558',to_date('09-JUN-81','DD-MON-RR'),'664',null,'183');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2988','PETRARCA MARIO','MANAGER','823',to_date('09-JUN-81','DD-MON-RR'),'41',null,'4');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2989','CALVINO ANTONIO','MANAGER','2007',to_date('09-JUN-81','DD-MON-RR'),'1077',null,'444');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2990','MANZONI ANTONIO','MANAGER','849',to_date('09-JUN-81','DD-MON-RR'),'1960',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2991','DANTE ANTONIO','TECHNICIAN','2334',to_date('09-JUN-81','DD-MON-RR'),'1991',null,'406');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2992','SANTE PASQUALE','SUPERVISOR','2831',to_date('09-JUN-81','DD-MON-RR'),'502',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2993','ECO ANGELO','SUPERVISOR','1408',to_date('09-JUN-81','DD-MON-RR'),'657',null,'97');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2994','FO DONATO','TECHNICIAN','2278',to_date('09-JUN-81','DD-MON-RR'),'1615',null,'151');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2995','MANZONI FRANCESCO','ENGINEER','981',to_date('09-JUN-81','DD-MON-RR'),'985',null,'131');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2996','CALVINO PASQUALE','MANAGER','2795',to_date('09-JUN-81','DD-MON-RR'),'1263',null,'270');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2997','ESPOSITO MARIO','ENGINEER','542',to_date('09-JUN-81','DD-MON-RR'),'128',null,'93');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2998','LEOPARDI PASQUALE','HEADMASTER','364',to_date('09-JUN-81','DD-MON-RR'),'1695',null,'284');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2999','CARBONE ALFONSO','PHDSTUDENT','241',to_date('09-JUN-81','DD-MON-RR'),'177',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3000','LEOPARDI LUCA','MANAGER','2000',to_date('09-JUN-81','DD-MON-RR'),'134',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1922','PETRARCA MARIO','HEADMASTER','1316',to_date('09-JUN-81','DD-MON-RR'),'994',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1923','ESPOSITO COSIMO','PHDSTUDENT','391',to_date('09-JUN-81','DD-MON-RR'),'1916',null,'371');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1924','BIANCHI ANGELO','LAWYER','1032',to_date('09-JUN-81','DD-MON-RR'),'859',null,'291');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1925','LEVI ELIO','SECRETARY','1511',to_date('09-JUN-81','DD-MON-RR'),'1678',null,'443');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1926','LEOPARDI DAMIANO','ENGINEER','490',to_date('09-JUN-81','DD-MON-RR'),'1871',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3951','PETRARCA PASQUALE','LAWYER','3911',to_date('09-JUN-81','DD-MON-RR'),'285',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3952','BIANCHI PAOLO','TECHNICIAN','1707',to_date('09-JUN-81','DD-MON-RR'),'1135',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3953','CALVINO LUCIA','MANAGER','1489',to_date('09-JUN-81','DD-MON-RR'),'36',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3954','ESPOSITO CLARA','PHDSTUDENT','1008',to_date('09-JUN-81','DD-MON-RR'),'224',null,'337');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3955','ESPOSITO LUIGI','TECHNICIAN','3241',to_date('09-JUN-81','DD-MON-RR'),'1857',null,'177');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3956','COZZA ANDREA','ENGINEER','88',to_date('09-JUN-81','DD-MON-RR'),'977',null,'367');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3957','NERI UMBERTO','PROFESSOR','3535',to_date('09-JUN-81','DD-MON-RR'),'1731',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3958','MANZONI GIOVANNI','ENGINEER','539',to_date('09-JUN-81','DD-MON-RR'),'597',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3959','CORONA ANDREA','SECRETARY','3921',to_date('09-JUN-81','DD-MON-RR'),'667',null,'243');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3960','FUMAROLA LUCIA','MANAGER','1418',to_date('09-JUN-81','DD-MON-RR'),'490',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3961','ECO MARIA','SUPERVISOR','1212',to_date('09-JUN-81','DD-MON-RR'),'106',null,'317');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3962','SANTE CLARA','SECRETARY','939',to_date('09-JUN-81','DD-MON-RR'),'753',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3963','CALVINO UGO','MANAGER','2614',to_date('09-JUN-81','DD-MON-RR'),'1291',null,'77');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3964','GRIMALDI ANTONIO','PROFESSOR','2826',to_date('09-JUN-81','DD-MON-RR'),'918',null,'283');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3965','GRIMALDI SILVIA','MANAGER','3644',to_date('09-JUN-81','DD-MON-RR'),'964',null,'118');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3966','TIBALDI ANTONIO','SUPERVISOR','2822',to_date('09-JUN-81','DD-MON-RR'),'1003',null,'160');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3967','NERI LUCA','TECHNICIAN','1643',to_date('09-JUN-81','DD-MON-RR'),'1560',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3968','CORONA LUCIA','PHDSTUDENT','810',to_date('09-JUN-81','DD-MON-RR'),'880',null,'168');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3969','LEVI LUDOVICO','SECRETARY','2349',to_date('09-JUN-81','DD-MON-RR'),'980',null,'132');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3970','CARBONE PAOLO','LAWYER','601',to_date('09-JUN-81','DD-MON-RR'),'1220',null,'435');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3971','NERI LUCA','SUPERVISOR','2609',to_date('09-JUN-81','DD-MON-RR'),'1776',null,'284');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3972','CALVINO UMBERTO','PROFESSOR','3112',to_date('09-JUN-81','DD-MON-RR'),'1296',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3973','PETRARCA SILVIA','SECRETARY','2605',to_date('09-JUN-81','DD-MON-RR'),'401',null,'55');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3974','PETRARCA GAETANO','PHDSTUDENT','3171',to_date('09-JUN-81','DD-MON-RR'),'303',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3975','ESPOSITO ANDREA','MANAGER','1792',to_date('09-JUN-81','DD-MON-RR'),'924',null,'340');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3976','GRIMALDI COSIMO','LAWYER','1542',to_date('09-JUN-81','DD-MON-RR'),'1015',null,'372');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3977','FO ROBERTA','HEADMASTER','267',to_date('09-JUN-81','DD-MON-RR'),'540',null,'314');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3978','FUMAROLA MARIA','LAWYER','2506',to_date('09-JUN-81','DD-MON-RR'),'1782',null,'412');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3979','CARBONE ANTONIO','HEADMASTER','2511',to_date('09-JUN-81','DD-MON-RR'),'1364',null,'268');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3980','FUMAROLA ELENA','PHDSTUDENT','325',to_date('09-JUN-81','DD-MON-RR'),'391',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3981','SANTE ALFONSO','SUPERVISOR','2471',to_date('09-JUN-81','DD-MON-RR'),'1811',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3982','ESPOSITO MARIA','TECHNICIAN','1380',to_date('09-JUN-81','DD-MON-RR'),'1857',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3983','SANTE LUCA','SECRETARY','2388',to_date('09-JUN-81','DD-MON-RR'),'1034',null,'276');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3984','LEOPARDI SILVIA','ENGINEER','3229',to_date('09-JUN-81','DD-MON-RR'),'1781',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3985','PETRARCA DONATO','SECRETARY','776',to_date('09-JUN-81','DD-MON-RR'),'1965',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3986','CARBONE ANTONIO','PROFESSOR','2648',to_date('09-JUN-81','DD-MON-RR'),'733',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3987','FO MARIO','PHDSTUDENT','1943',to_date('09-JUN-81','DD-MON-RR'),'160',null,'136');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3988','CORONA LUCIA','HEADMASTER','2288',to_date('09-JUN-81','DD-MON-RR'),'1309',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3989','COZZA DAMIANO','TECHNICIAN','2243',to_date('09-JUN-81','DD-MON-RR'),'1781',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3990','FUMAROLA IVANO','SUPERVISOR','2174',to_date('09-JUN-81','DD-MON-RR'),'865',null,'356');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3991','CORONA FEDERICO','SUPERVISOR','725',to_date('09-JUN-81','DD-MON-RR'),'1203',null,'412');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3992','CARBONE SILVIA','LAWYER','36',to_date('09-JUN-81','DD-MON-RR'),'843',null,'319');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3993','COZZA MASSIMO','MANAGER','1771',to_date('09-JUN-81','DD-MON-RR'),'1817',null,'174');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3994','CORONA ELENA','SUPERVISOR','237',to_date('09-JUN-81','DD-MON-RR'),'1194',null,'159');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3995','GRIMALDI MARIO','SECRETARY','2465',to_date('09-JUN-81','DD-MON-RR'),'1646',null,'495');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3996','PETRARCA ALFONSO','SUPERVISOR','3149',to_date('09-JUN-81','DD-MON-RR'),'1218',null,'264');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3997','CORONA FRANCESCO','ENGINEER','687',to_date('09-JUN-81','DD-MON-RR'),'565',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3998','CALVINO FRANCESCO','SECRETARY','2017',to_date('09-JUN-81','DD-MON-RR'),'18',null,'64');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3999','FUMAROLA GAETANO','MANAGER','1126',to_date('09-JUN-81','DD-MON-RR'),'381',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4000','CARBONE LUCIA','SECRETARY','633',to_date('09-JUN-81','DD-MON-RR'),'1391',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4001','SANTE LUCA','SECRETARY','305',to_date('09-JUN-81','DD-MON-RR'),'1626',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4002','LEVI COSIMO','TECHNICIAN','278',to_date('09-JUN-81','DD-MON-RR'),'1197',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4003','DANTE ROBERTA','MANAGER','703',to_date('09-JUN-81','DD-MON-RR'),'1829',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4004','NERI FEDERICO','PHDSTUDENT','1876',to_date('09-JUN-81','DD-MON-RR'),'99',null,'176');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4005','SANTE ANDREA','MANAGER','1075',to_date('09-JUN-81','DD-MON-RR'),'1617',null,'63');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4006','CARBONE ANDREA','HEADMASTER','1684',to_date('09-JUN-81','DD-MON-RR'),'67',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4007','FO PAOLO','PHDSTUDENT','1974',to_date('09-JUN-81','DD-MON-RR'),'1418',null,'495');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4008','MANZONI DONATO','LAWYER','3888',to_date('09-JUN-81','DD-MON-RR'),'1680',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4009','MANZONI LUCA','SUPERVISOR','653',to_date('09-JUN-81','DD-MON-RR'),'1227',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4010','COZZA ELIO','SUPERVISOR','3797',to_date('09-JUN-81','DD-MON-RR'),'223',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4011','SANTE CLARA','PHDSTUDENT','907',to_date('09-JUN-81','DD-MON-RR'),'1326',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4012','FUMAROLA ANDREA','TECHNICIAN','2345',to_date('09-JUN-81','DD-MON-RR'),'951',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4013','TIBALDI GIOVANNI','PHDSTUDENT','3921',to_date('09-JUN-81','DD-MON-RR'),'788',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4014','MANZONI IVANO','LAWYER','1510',to_date('09-JUN-81','DD-MON-RR'),'1116',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4015','MANZONI UGO','TECHNICIAN','1177',to_date('09-JUN-81','DD-MON-RR'),'41',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4016','CORONA PASQUALE','TECHNICIAN','1753',to_date('09-JUN-81','DD-MON-RR'),'642',null,'28');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4017','TIBALDI FEDERICO','PROFESSOR','983',to_date('09-JUN-81','DD-MON-RR'),'195',null,'258');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4018','CALVINO MARIA','TECHNICIAN','3114',to_date('09-JUN-81','DD-MON-RR'),'1301',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4019','FUMAROLA LUCIA','MANAGER','3196',to_date('09-JUN-81','DD-MON-RR'),'640',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4020','ESPOSITO MARIA','ENGINEER','127',to_date('09-JUN-81','DD-MON-RR'),'246',null,'191');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4021','BIANCHI ELENA','MANAGER','2323',to_date('09-JUN-81','DD-MON-RR'),'891',null,'399');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4022','LEVI ROBERTA','LAWYER','2719',to_date('09-JUN-81','DD-MON-RR'),'1422',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4023','CALVINO MARIO','ENGINEER','533',to_date('09-JUN-81','DD-MON-RR'),'1328',null,'367');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4024','FO LUCIA','ENGINEER','792',to_date('09-JUN-81','DD-MON-RR'),'1344',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4025','FO MARIA','PHDSTUDENT','3404',to_date('09-JUN-81','DD-MON-RR'),'1391',null,'475');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4026','BIANCHI UMBERTO','HEADMASTER','2839',to_date('09-JUN-81','DD-MON-RR'),'913',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4027','GRIMALDI MASSIMO','PROFESSOR','3283',to_date('09-JUN-81','DD-MON-RR'),'1537',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4028','TIBALDI LUCIA','MANAGER','1240',to_date('09-JUN-81','DD-MON-RR'),'187',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4029','FUMAROLA PAOLO','MANAGER','2900',to_date('09-JUN-81','DD-MON-RR'),'1515',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4030','SANTE DAMIANO','TECHNICIAN','2201',to_date('09-JUN-81','DD-MON-RR'),'176',null,'22');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4031','PETRARCA LUCA','PROFESSOR','1845',to_date('09-JUN-81','DD-MON-RR'),'44',null,'190');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4032','PETRARCA UGO','PHDSTUDENT','2971',to_date('09-JUN-81','DD-MON-RR'),'682',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4033','ECO LUIGI','SUPERVISOR','3206',to_date('09-JUN-81','DD-MON-RR'),'1747',null,'149');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4034','SANTE FEDERICO','TECHNICIAN','3821',to_date('09-JUN-81','DD-MON-RR'),'1271',null,'308');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4035','CALVINO PAOLO','HEADMASTER','3971',to_date('09-JUN-81','DD-MON-RR'),'1800',null,'474');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4036','TIBALDI LUDOVICO','TECHNICIAN','3855',to_date('09-JUN-81','DD-MON-RR'),'1710',null,'143');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4037','CARBONE SILVIA','TECHNICIAN','3277',to_date('09-JUN-81','DD-MON-RR'),'913',null,'76');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4038','CORONA ANTONIO','MANAGER','1048',to_date('09-JUN-81','DD-MON-RR'),'1145',null,'296');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4039','DANTE LUCIA','PHDSTUDENT','1686',to_date('09-JUN-81','DD-MON-RR'),'906',null,'72');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4040','FO DAMIANO','SECRETARY','3614',to_date('09-JUN-81','DD-MON-RR'),'142',null,'199');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4041','LEOPARDI MARIA','PROFESSOR','435',to_date('09-JUN-81','DD-MON-RR'),'113',null,'326');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4042','CALVINO COSIMO','PHDSTUDENT','838',to_date('09-JUN-81','DD-MON-RR'),'412',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4043','CARBONE MASSIMO','MANAGER','328',to_date('09-JUN-81','DD-MON-RR'),'1041',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4044','FUMAROLA ANTONIO','TECHNICIAN','746',to_date('09-JUN-81','DD-MON-RR'),'992',null,'69');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4045','BIANCHI GIOVANNI','ENGINEER','3356',to_date('09-JUN-81','DD-MON-RR'),'852',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4046','CALVINO CLARA','SUPERVISOR','110',to_date('09-JUN-81','DD-MON-RR'),'753',null,'227');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4047','CARBONE FRANCESCO','MANAGER','214',to_date('09-JUN-81','DD-MON-RR'),'1958',null,'28');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4048','PETRARCA ANDREA','HEADMASTER','1981',to_date('09-JUN-81','DD-MON-RR'),'843',null,'419');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4049','CARBONE MASSIMO','LAWYER','1440',to_date('09-JUN-81','DD-MON-RR'),'563',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4050','PETRARCA ALFONSO','ENGINEER','2919',to_date('09-JUN-81','DD-MON-RR'),'882',null,'185');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4051','DANTE DONATO','MANAGER','1689',to_date('09-JUN-81','DD-MON-RR'),'1396',null,'8');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4052','ESPOSITO DONATO','LAWYER','2930',to_date('09-JUN-81','DD-MON-RR'),'862',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4053','COZZA IVANO','SUPERVISOR','391',to_date('09-JUN-81','DD-MON-RR'),'1606',null,'265');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4054','FUMAROLA PASQUALE','MANAGER','3453',to_date('09-JUN-81','DD-MON-RR'),'1657',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4055','FUMAROLA ELENA','SECRETARY','852',to_date('09-JUN-81','DD-MON-RR'),'88',null,'480');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4056','CARBONE GIOVANNI','TECHNICIAN','896',to_date('09-JUN-81','DD-MON-RR'),'959',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4057','LEOPARDI DAMIANO','SUPERVISOR','105',to_date('09-JUN-81','DD-MON-RR'),'151',null,'70');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4058','PETRARCA IVANO','MANAGER','3659',to_date('09-JUN-81','DD-MON-RR'),'1903',null,'128');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4059','CARBONE MARIO','SECRETARY','240',to_date('09-JUN-81','DD-MON-RR'),'1476',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4060','CALVINO FRANCESCO','LAWYER','1983',to_date('09-JUN-81','DD-MON-RR'),'428',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4061','DANTE ELIO','PHDSTUDENT','338',to_date('09-JUN-81','DD-MON-RR'),'32',null,'234');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5059','PETRARCA ELIO','ENGINEER','3421',to_date('09-JUN-81','DD-MON-RR'),'1255',null,'364');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5060','COZZA ROBERTA','PHDSTUDENT','4929',to_date('09-JUN-81','DD-MON-RR'),'1271',null,'251');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5061','TIBALDI ELIO','LAWYER','1171',to_date('09-JUN-81','DD-MON-RR'),'1525',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5062','DANTE GAETANO','ENGINEER','4702',to_date('09-JUN-81','DD-MON-RR'),'111',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5063','COZZA CLARA','HEADMASTER','1922',to_date('09-JUN-81','DD-MON-RR'),'1959',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5064','ESPOSITO ROBERTA','MANAGER','1036',to_date('09-JUN-81','DD-MON-RR'),'1598',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5065','FUMAROLA UMBERTO','TECHNICIAN','574',to_date('09-JUN-81','DD-MON-RR'),'1123',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5066','DANTE ELIO','PROFESSOR','3759',to_date('09-JUN-81','DD-MON-RR'),'435',null,'60');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5067','LEVI MASSIMO','SECRETARY','1914',to_date('09-JUN-81','DD-MON-RR'),'1716',null,'248');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5068','LEOPARDI ELENA','PROFESSOR','1959',to_date('09-JUN-81','DD-MON-RR'),'1654',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5069','ESPOSITO CLARA','MANAGER','4677',to_date('09-JUN-81','DD-MON-RR'),'1458',null,'258');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5070','COZZA MARIA','MANAGER','4252',to_date('09-JUN-81','DD-MON-RR'),'1551',null,'333');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5071','CORONA PASQUALE','PROFESSOR','4885',to_date('09-JUN-81','DD-MON-RR'),'269',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5072','NERI ANGELO','MANAGER','2672',to_date('09-JUN-81','DD-MON-RR'),'785',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5073','ECO COSIMO','SUPERVISOR','3245',to_date('09-JUN-81','DD-MON-RR'),'923',null,'466');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5074','PETRARCA LUIGI','MANAGER','4831',to_date('09-JUN-81','DD-MON-RR'),'299',null,'93');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5075','MANZONI IVANO','MANAGER','2909',to_date('09-JUN-81','DD-MON-RR'),'1393',null,'312');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5076','FUMAROLA MARIO','SUPERVISOR','4524',to_date('09-JUN-81','DD-MON-RR'),'530',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5077','COZZA ROBERTA','PROFESSOR','2843',to_date('09-JUN-81','DD-MON-RR'),'1753',null,'279');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5078','TIBALDI COSIMO','SECRETARY','1636',to_date('09-JUN-81','DD-MON-RR'),'1083',null,'47');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5079','CARBONE ANGELO','PHDSTUDENT','3612',to_date('09-JUN-81','DD-MON-RR'),'1456',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5080','ECO ANGELO','HEADMASTER','3790',to_date('09-JUN-81','DD-MON-RR'),'1540',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5081','MANZONI LUIGI','SECRETARY','1967',to_date('09-JUN-81','DD-MON-RR'),'1802',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5082','BIANCHI COSIMO','MANAGER','3582',to_date('09-JUN-81','DD-MON-RR'),'444',null,'410');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8062','CARBONE DAMIANO','LAWYER','1843',to_date('09-JUN-81','DD-MON-RR'),'307',null,'483');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5980','DANTE FEDERICO','SUPERVISOR','1001',to_date('09-JUN-81','DD-MON-RR'),'1089',null,'472');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5981','COZZA CLARA','MANAGER','3907',to_date('09-JUN-81','DD-MON-RR'),'1202',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5982','CALVINO DONATO','MANAGER','2432',to_date('09-JUN-81','DD-MON-RR'),'1081',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5983','FUMAROLA IVANO','MANAGER','470',to_date('09-JUN-81','DD-MON-RR'),'1701',null,'211');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5984','SANTE LUDOVICO','HEADMASTER','1499',to_date('09-JUN-81','DD-MON-RR'),'1474',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5985','LEVI LUCIA','HEADMASTER','1221',to_date('09-JUN-81','DD-MON-RR'),'1181',null,'467');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5986','SANTE DONATO','PROFESSOR','1845',to_date('09-JUN-81','DD-MON-RR'),'1988',null,'286');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5987','SANTE LUDOVICO','ENGINEER','2407',to_date('09-JUN-81','DD-MON-RR'),'260',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5988','GRIMALDI ELENA','SUPERVISOR','5062',to_date('09-JUN-81','DD-MON-RR'),'874',null,'248');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5989','NERI CLARA','TECHNICIAN','3516',to_date('09-JUN-81','DD-MON-RR'),'1220',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5990','CORONA COSIMO','HEADMASTER','4481',to_date('09-JUN-81','DD-MON-RR'),'86',null,'425');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5991','GRIMALDI SILVIA','MANAGER','3928',to_date('09-JUN-81','DD-MON-RR'),'999',null,'92');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5992','LEVI GAETANO','SUPERVISOR','5322',to_date('09-JUN-81','DD-MON-RR'),'1214',null,'19');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5993','FO ALFONSO','PHDSTUDENT','4404',to_date('09-JUN-81','DD-MON-RR'),'1560',null,'417');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5994','FUMAROLA PASQUALE','PROFESSOR','1983',to_date('09-JUN-81','DD-MON-RR'),'1269',null,'402');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5995','CORONA UGO','MANAGER','2562',to_date('09-JUN-81','DD-MON-RR'),'1479',null,'343');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5996','GRIMALDI GAETANO','HEADMASTER','2816',to_date('09-JUN-81','DD-MON-RR'),'158',null,'188');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5997','COZZA UGO','SUPERVISOR','3384',to_date('09-JUN-81','DD-MON-RR'),'392',null,'95');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5998','FUMAROLA SILVIA','HEADMASTER','5',to_date('09-JUN-81','DD-MON-RR'),'39',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5999','CARBONE IVANO','LAWYER','178',to_date('09-JUN-81','DD-MON-RR'),'1165',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6000','TIBALDI ANTONIO','MANAGER','2866',to_date('09-JUN-81','DD-MON-RR'),'355',null,'159');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6001','LEOPARDI UGO','PHDSTUDENT','254',to_date('09-JUN-81','DD-MON-RR'),'1851',null,'410');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6002','FO ELENA','SUPERVISOR','20',to_date('09-JUN-81','DD-MON-RR'),'290',null,'162');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6003','COZZA IVANO','MANAGER','1915',to_date('09-JUN-81','DD-MON-RR'),'1499',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6004','DANTE DAMIANO','LAWYER','1063',to_date('09-JUN-81','DD-MON-RR'),'1229',null,'232');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6005','SANTE PASQUALE','ENGINEER','2064',to_date('09-JUN-81','DD-MON-RR'),'1853',null,'196');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6006','FO DONATO','MANAGER','2432',to_date('09-JUN-81','DD-MON-RR'),'267',null,'386');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6007','BIANCHI MARIO','SECRETARY','2141',to_date('09-JUN-81','DD-MON-RR'),'1114',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6008','MANZONI FRANCESCO','MANAGER','1759',to_date('09-JUN-81','DD-MON-RR'),'140',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6009','ECO LUDOVICO','TECHNICIAN','4837',to_date('09-JUN-81','DD-MON-RR'),'943',null,'99');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6010','SANTE ANTONIO','PROFESSOR','2907',to_date('09-JUN-81','DD-MON-RR'),'1160',null,'287');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6011','CALVINO COSIMO','SECRETARY','4351',to_date('09-JUN-81','DD-MON-RR'),'1296',null,'399');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6012','CALVINO CLARA','SUPERVISOR','5124',to_date('09-JUN-81','DD-MON-RR'),'462',null,'455');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6013','CALVINO ANGELO','HEADMASTER','3616',to_date('09-JUN-81','DD-MON-RR'),'412',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6014','MANZONI COSIMO','SUPERVISOR','1105',to_date('09-JUN-81','DD-MON-RR'),'1869',null,'249');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6015','BIANCHI LUCIA','SECRETARY','183',to_date('09-JUN-81','DD-MON-RR'),'1375',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6016','NERI MASSIMO','LAWYER','1633',to_date('09-JUN-81','DD-MON-RR'),'575',null,'103');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6017','ESPOSITO SILVIA','TECHNICIAN','2555',to_date('09-JUN-81','DD-MON-RR'),'1274',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6018','CALVINO DAMIANO','HEADMASTER','6000',to_date('09-JUN-81','DD-MON-RR'),'1182',null,'216');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6019','BIANCHI UMBERTO','SECRETARY','4549',to_date('09-JUN-81','DD-MON-RR'),'750',null,'248');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6020','NERI LUDOVICO','HEADMASTER','5956',to_date('09-JUN-81','DD-MON-RR'),'1576',null,'194');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6021','LEVI PAOLO','MANAGER','5196',to_date('09-JUN-81','DD-MON-RR'),'1330',null,'119');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6022','LEVI ROBERTA','ENGINEER','907',to_date('09-JUN-81','DD-MON-RR'),'322',null,'330');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6023','PETRARCA MASSIMO','SUPERVISOR','4150',to_date('09-JUN-81','DD-MON-RR'),'987',null,'121');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6024','PETRARCA LUCA','MANAGER','4118',to_date('09-JUN-81','DD-MON-RR'),'1956',null,'405');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6025','TIBALDI ROBERTA','PHDSTUDENT','5304',to_date('09-JUN-81','DD-MON-RR'),'444',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6026','PETRARCA UMBERTO','SECRETARY','1327',to_date('09-JUN-81','DD-MON-RR'),'780',null,'207');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6027','SANTE ELENA','HEADMASTER','2917',to_date('09-JUN-81','DD-MON-RR'),'1220',null,'156');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6028','DANTE LUCA','PROFESSOR','4809',to_date('09-JUN-81','DD-MON-RR'),'1525',null,'151');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6029','BIANCHI ELIO','HEADMASTER','2871',to_date('09-JUN-81','DD-MON-RR'),'1135',null,'252');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6030','COZZA MARIO','PHDSTUDENT','5156',to_date('09-JUN-81','DD-MON-RR'),'1256',null,'479');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6031','PETRARCA PASQUALE','PHDSTUDENT','5806',to_date('09-JUN-81','DD-MON-RR'),'234',null,'438');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6032','CALVINO SILVIA','LAWYER','3201',to_date('09-JUN-81','DD-MON-RR'),'121',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6033','ECO GAETANO','ENGINEER','3944',to_date('09-JUN-81','DD-MON-RR'),'9',null,'391');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6034','GRIMALDI FEDERICO','MANAGER','2914',to_date('09-JUN-81','DD-MON-RR'),'1044',null,'117');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6035','GRIMALDI ANTONIO','TECHNICIAN','4373',to_date('09-JUN-81','DD-MON-RR'),'1328',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6036','CARBONE MASSIMO','LAWYER','1031',to_date('09-JUN-81','DD-MON-RR'),'1678',null,'312');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6037','CARBONE FEDERICO','LAWYER','2318',to_date('09-JUN-81','DD-MON-RR'),'1496',null,'130');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6038','LEVI IVANO','MANAGER','2116',to_date('09-JUN-81','DD-MON-RR'),'492',null,'236');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6039','GRIMALDI DONATO','HEADMASTER','4827',to_date('09-JUN-81','DD-MON-RR'),'1373',null,'20');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6040','CORONA MARIA','MANAGER','95',to_date('09-JUN-81','DD-MON-RR'),'797',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6041','FO ANGELO','SECRETARY','807',to_date('09-JUN-81','DD-MON-RR'),'507',null,'114');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6042','TIBALDI PAOLO','SECRETARY','5795',to_date('09-JUN-81','DD-MON-RR'),'1371',null,'98');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6043','COZZA COSIMO','TECHNICIAN','4167',to_date('09-JUN-81','DD-MON-RR'),'733',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6044','FUMAROLA ANTONIO','ENGINEER','4121',to_date('09-JUN-81','DD-MON-RR'),'597',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6045','COZZA ANGELO','PROFESSOR','3467',to_date('09-JUN-81','DD-MON-RR'),'696',null,'498');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6046','ECO GAETANO','PROFESSOR','2897',to_date('09-JUN-81','DD-MON-RR'),'216',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6047','GRIMALDI ALFONSO','ENGINEER','948',to_date('09-JUN-81','DD-MON-RR'),'1650',null,'160');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6048','DANTE COSIMO','SECRETARY','855',to_date('09-JUN-81','DD-MON-RR'),'1472',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6049','ECO ELENA','ENGINEER','2510',to_date('09-JUN-81','DD-MON-RR'),'1161',null,'251');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6050','LEVI PAOLO','MANAGER','5680',to_date('09-JUN-81','DD-MON-RR'),'1755',null,'91');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6051','ESPOSITO SILVIA','PROFESSOR','104',to_date('09-JUN-81','DD-MON-RR'),'890',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7051','LEVI ANGELO','MANAGER','2723',to_date('09-JUN-81','DD-MON-RR'),'364',null,'263');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7052','PETRARCA PAOLO','PROFESSOR','6716',to_date('09-JUN-81','DD-MON-RR'),'897',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7053','NERI DAMIANO','SUPERVISOR','1351',to_date('09-JUN-81','DD-MON-RR'),'150',null,'13');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7054','COZZA SILVIA','SUPERVISOR','6039',to_date('09-JUN-81','DD-MON-RR'),'533',null,'334');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7055','NERI DAMIANO','PROFESSOR','4524',to_date('09-JUN-81','DD-MON-RR'),'322',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7056','CALVINO UGO','MANAGER','3959',to_date('09-JUN-81','DD-MON-RR'),'1139',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7057','CARBONE ROBERTA','ENGINEER','1285',to_date('09-JUN-81','DD-MON-RR'),'1302',null,'333');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7058','PETRARCA UMBERTO','SUPERVISOR','7034',to_date('09-JUN-81','DD-MON-RR'),'941',null,'339');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7059','CARBONE UGO','SECRETARY','6020',to_date('09-JUN-81','DD-MON-RR'),'1326',null,'154');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7060','DANTE ANDREA','PROFESSOR','231',to_date('09-JUN-81','DD-MON-RR'),'975',null,'271');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7061','CARBONE DONATO','HEADMASTER','4140',to_date('09-JUN-81','DD-MON-RR'),'338',null,'148');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7062','LEOPARDI FEDERICO','SUPERVISOR','5542',to_date('09-JUN-81','DD-MON-RR'),'877',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7063','ECO ANDREA','SUPERVISOR','387',to_date('09-JUN-81','DD-MON-RR'),'160',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7064','ECO DONATO','MANAGER','5476',to_date('09-JUN-81','DD-MON-RR'),'1915',null,'433');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7065','COZZA LUCA','LAWYER','3300',to_date('09-JUN-81','DD-MON-RR'),'1026',null,'100');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7066','ESPOSITO PAOLO','SUPERVISOR','5218',to_date('09-JUN-81','DD-MON-RR'),'1776',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7067','DANTE GAETANO','PROFESSOR','224',to_date('09-JUN-81','DD-MON-RR'),'478',null,'336');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7068','ESPOSITO MARIO','ENGINEER','4273',to_date('09-JUN-81','DD-MON-RR'),'1491',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7069','FO CLARA','MANAGER','1447',to_date('09-JUN-81','DD-MON-RR'),'508',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7070','LEVI MARIA','MANAGER','5554',to_date('09-JUN-81','DD-MON-RR'),'1611',null,'446');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7071','ESPOSITO ANGELO','LAWYER','5627',to_date('09-JUN-81','DD-MON-RR'),'1110',null,'41');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7072','CORONA ROBERTA','LAWYER','61',to_date('09-JUN-81','DD-MON-RR'),'1245',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7073','CALVINO ANTONIO','TECHNICIAN','3107',to_date('09-JUN-81','DD-MON-RR'),'1812',null,'107');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7074','LEOPARDI LUCIA','LAWYER','1547',to_date('09-JUN-81','DD-MON-RR'),'224',null,'473');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7075','BIANCHI LUDOVICO','ENGINEER','3530',to_date('09-JUN-81','DD-MON-RR'),'1939',null,'45');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7076','DANTE ELIO','LAWYER','4160',to_date('09-JUN-81','DD-MON-RR'),'1504',null,'231');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7077','CALVINO FRANCESCO','LAWYER','1480',to_date('09-JUN-81','DD-MON-RR'),'1070',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7078','LEOPARDI PASQUALE','TECHNICIAN','3220',to_date('09-JUN-81','DD-MON-RR'),'1313',null,'442');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7079','CARBONE FRANCESCO','SUPERVISOR','2565',to_date('09-JUN-81','DD-MON-RR'),'304',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7080','TIBALDI ROBERTA','HEADMASTER','4214',to_date('09-JUN-81','DD-MON-RR'),'1539',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7081','ECO ANTONIO','TECHNICIAN','4211',to_date('09-JUN-81','DD-MON-RR'),'1500',null,'383');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7082','FO MARIO','MANAGER','797',to_date('09-JUN-81','DD-MON-RR'),'1261',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7083','DANTE COSIMO','PROFESSOR','5445',to_date('09-JUN-81','DD-MON-RR'),'144',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7084','DANTE CLARA','SECRETARY','3161',to_date('09-JUN-81','DD-MON-RR'),'208',null,'393');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7085','BIANCHI LUIGI','PROFESSOR','3111',to_date('09-JUN-81','DD-MON-RR'),'18',null,'414');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7086','FO ELIO','LAWYER','3628',to_date('09-JUN-81','DD-MON-RR'),'581',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7087','COZZA UGO','ENGINEER','4058',to_date('09-JUN-81','DD-MON-RR'),'922',null,'396');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7088','GRIMALDI UMBERTO','HEADMASTER','3167',to_date('09-JUN-81','DD-MON-RR'),'40',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7089','LEVI DONATO','ENGINEER','5564',to_date('09-JUN-81','DD-MON-RR'),'240',null,'164');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7090','CARBONE LUDOVICO','MANAGER','4475',to_date('09-JUN-81','DD-MON-RR'),'1820',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7091','BIANCHI ANDREA','PROFESSOR','3191',to_date('09-JUN-81','DD-MON-RR'),'1839',null,'369');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7092','CALVINO DAMIANO','PHDSTUDENT','2507',to_date('09-JUN-81','DD-MON-RR'),'1543',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7093','BIANCHI DAMIANO','PROFESSOR','3954',to_date('09-JUN-81','DD-MON-RR'),'1239',null,'409');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7094','ESPOSITO ELENA','PHDSTUDENT','1883',to_date('09-JUN-81','DD-MON-RR'),'1107',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7095','ESPOSITO LUCIA','LAWYER','2392',to_date('09-JUN-81','DD-MON-RR'),'1516',null,'497');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7096','TIBALDI IVANO','ENGINEER','3808',to_date('09-JUN-81','DD-MON-RR'),'1335',null,'160');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7097','CORONA IVANO','PHDSTUDENT','2568',to_date('09-JUN-81','DD-MON-RR'),'424',null,'145');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7098','LEVI UGO','PHDSTUDENT','5036',to_date('09-JUN-81','DD-MON-RR'),'1833',null,'42');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7099','NERI LUDOVICO','HEADMASTER','161',to_date('09-JUN-81','DD-MON-RR'),'445',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7100','DANTE LUDOVICO','TECHNICIAN','5121',to_date('09-JUN-81','DD-MON-RR'),'308',null,'146');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7101','PETRARCA ALFONSO','SECRETARY','839',to_date('09-JUN-81','DD-MON-RR'),'1560',null,'88');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7102','FO UMBERTO','ENGINEER','6819',to_date('09-JUN-81','DD-MON-RR'),'833',null,'124');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7103','CORONA UMBERTO','HEADMASTER','5091',to_date('09-JUN-81','DD-MON-RR'),'73',null,'261');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7104','TIBALDI GIOVANNI','PROFESSOR','4648',to_date('09-JUN-81','DD-MON-RR'),'1177',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7105','CARBONE PASQUALE','SUPERVISOR','4231',to_date('09-JUN-81','DD-MON-RR'),'1893',null,'337');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7106','DANTE GIOVANNI','SUPERVISOR','2823',to_date('09-JUN-81','DD-MON-RR'),'1561',null,'349');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7107','SANTE UGO','PROFESSOR','4339',to_date('09-JUN-81','DD-MON-RR'),'362',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7108','NERI UGO','SUPERVISOR','3310',to_date('09-JUN-81','DD-MON-RR'),'300',null,'267');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7109','DANTE ALFONSO','HEADMASTER','3342',to_date('09-JUN-81','DD-MON-RR'),'1210',null,'344');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7110','MANZONI LUIGI','SECRETARY','4938',to_date('09-JUN-81','DD-MON-RR'),'525',null,'430');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7111','DANTE ELIO','MANAGER','2049',to_date('09-JUN-81','DD-MON-RR'),'1095',null,'152');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7112','ECO UMBERTO','ENGINEER','5264',to_date('09-JUN-81','DD-MON-RR'),'1466',null,'353');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7113','BIANCHI ANDREA','PHDSTUDENT','2905',to_date('09-JUN-81','DD-MON-RR'),'115',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('687','ESPOSITO ANDREA','SECRETARY','427',to_date('09-JUN-81','DD-MON-RR'),'1323',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('688','SANTE MARIA','MANAGER','320',to_date('09-JUN-81','DD-MON-RR'),'1278',null,'228');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('689','PETRARCA DONATO','MANAGER','185',to_date('09-JUN-81','DD-MON-RR'),'813',null,'451');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('690','NERI MASSIMO','SUPERVISOR','328',to_date('09-JUN-81','DD-MON-RR'),'737',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('691','ECO UMBERTO','MANAGER','637',to_date('09-JUN-81','DD-MON-RR'),'1468',null,'469');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('692','PETRARCA ELIO','PROFESSOR','555',to_date('09-JUN-81','DD-MON-RR'),'262',null,'34');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('693','LEOPARDI ANTONIO','SECRETARY','604',to_date('09-JUN-81','DD-MON-RR'),'278',null,'307');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('694','GRIMALDI CLARA','MANAGER','452',to_date('09-JUN-81','DD-MON-RR'),'1712',null,'468');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('695','NERI LUCIA','PROFESSOR','198',to_date('09-JUN-81','DD-MON-RR'),'1076',null,'352');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('696','ECO ALFONSO','MANAGER','453',to_date('09-JUN-81','DD-MON-RR'),'108',null,'61');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('697','PETRARCA GAETANO','HEADMASTER','694',to_date('09-JUN-81','DD-MON-RR'),'607',null,'381');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('698','MANZONI PAOLO','MANAGER','28',to_date('09-JUN-81','DD-MON-RR'),'490',null,'288');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('699','TIBALDI MARIA','ENGINEER','130',to_date('09-JUN-81','DD-MON-RR'),'451',null,'10');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('700','TIBALDI COSIMO','HEADMASTER','322',to_date('09-JUN-81','DD-MON-RR'),'131',null,'310');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('701','COZZA PASQUALE','PHDSTUDENT','389',to_date('09-JUN-81','DD-MON-RR'),'1376',null,'402');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('702','COZZA ELIO','ENGINEER','217',to_date('09-JUN-81','DD-MON-RR'),'548',null,'305');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('703','CALVINO LUCIA','SECRETARY','358',to_date('09-JUN-81','DD-MON-RR'),'758',null,'114');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('704','NERI LUCIA','TECHNICIAN','176',to_date('09-JUN-81','DD-MON-RR'),'443',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('705','SANTE ELENA','PHDSTUDENT','248',to_date('09-JUN-81','DD-MON-RR'),'1611',null,'437');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('706','NERI LUDOVICO','PROFESSOR','511',to_date('09-JUN-81','DD-MON-RR'),'1053',null,'299');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('707','FO ALFONSO','MANAGER','591',to_date('09-JUN-81','DD-MON-RR'),'1029',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('708','CARBONE COSIMO','MANAGER','305',to_date('09-JUN-81','DD-MON-RR'),'195',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('709','NERI MARIA','MANAGER','327',to_date('09-JUN-81','DD-MON-RR'),'869',null,'63');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('710','SANTE ALFONSO','LAWYER','212',to_date('09-JUN-81','DD-MON-RR'),'115',null,'138');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('711','DANTE ANDREA','LAWYER','60',to_date('09-JUN-81','DD-MON-RR'),'1512',null,'387');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('712','TIBALDI ROBERTA','MANAGER','398',to_date('09-JUN-81','DD-MON-RR'),'247',null,'247');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('713','LEOPARDI LUCA','TECHNICIAN','143',to_date('09-JUN-81','DD-MON-RR'),'4',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('714','GRIMALDI CLARA','LAWYER','695',to_date('09-JUN-81','DD-MON-RR'),'248',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('715','GRIMALDI GAETANO','PROFESSOR','409',to_date('09-JUN-81','DD-MON-RR'),'1827',null,'281');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('716','PETRARCA MASSIMO','LAWYER','71',to_date('09-JUN-81','DD-MON-RR'),'343',null,'175');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('717','BIANCHI UGO','ENGINEER','613',to_date('09-JUN-81','DD-MON-RR'),'830',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('718','NERI ANDREA','SECRETARY','311',to_date('09-JUN-81','DD-MON-RR'),'654',null,'167');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('719','CALVINO DAMIANO','SUPERVISOR','705',to_date('09-JUN-81','DD-MON-RR'),'742',null,'60');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('720','SANTE COSIMO','MANAGER','207',to_date('09-JUN-81','DD-MON-RR'),'90',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('721','CORONA ANTONIO','HEADMASTER','321',to_date('09-JUN-81','DD-MON-RR'),'1989',null,'454');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('722','PETRARCA ALFONSO','SUPERVISOR','313',to_date('09-JUN-81','DD-MON-RR'),'1449',null,'89');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('723','LEOPARDI MARIA','MANAGER','381',to_date('09-JUN-81','DD-MON-RR'),'1018',null,'316');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('724','CALVINO LUCIA','MANAGER','622',to_date('09-JUN-81','DD-MON-RR'),'211',null,'200');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('725','BIANCHI ELENA','HEADMASTER','518',to_date('09-JUN-81','DD-MON-RR'),'349',null,'458');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('726','BIANCHI ELIO','SECRETARY','72',to_date('09-JUN-81','DD-MON-RR'),'944',null,'403');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('727','CORONA IVANO','LAWYER','561',to_date('09-JUN-81','DD-MON-RR'),'1407',null,'200');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('728','DANTE DONATO','MANAGER','186',to_date('09-JUN-81','DD-MON-RR'),'854',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('729','LEOPARDI ANDREA','MANAGER','668',to_date('09-JUN-81','DD-MON-RR'),'298',null,'108');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('730','DANTE DONATO','LAWYER','138',to_date('09-JUN-81','DD-MON-RR'),'1688',null,'139');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('731','BIANCHI MARIO','PHDSTUDENT','673',to_date('09-JUN-81','DD-MON-RR'),'618',null,'388');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('732','SANTE DAMIANO','SECRETARY','297',to_date('09-JUN-81','DD-MON-RR'),'179',null,'375');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('733','ECO ANTONIO','MANAGER','209',to_date('09-JUN-81','DD-MON-RR'),'591',null,'38');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('734','MANZONI MARIA','TECHNICIAN','280',to_date('09-JUN-81','DD-MON-RR'),'200',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('735','CALVINO PASQUALE','PHDSTUDENT','516',to_date('09-JUN-81','DD-MON-RR'),'1215',null,'244');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('736','SANTE MASSIMO','PROFESSOR','210',to_date('09-JUN-81','DD-MON-RR'),'1274',null,'3');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('737','COZZA PASQUALE','MANAGER','80',to_date('09-JUN-81','DD-MON-RR'),'1545',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('738','FUMAROLA ANGELO','HEADMASTER','375',to_date('09-JUN-81','DD-MON-RR'),'1732',null,'374');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('739','CALVINO MASSIMO','MANAGER','703',to_date('09-JUN-81','DD-MON-RR'),'1039',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('740','CARBONE UGO','SECRETARY','83',to_date('09-JUN-81','DD-MON-RR'),'1641',null,'29');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('741','SANTE DAMIANO','SUPERVISOR','221',to_date('09-JUN-81','DD-MON-RR'),'176',null,'205');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('742','CALVINO CLARA','ENGINEER','467',to_date('09-JUN-81','DD-MON-RR'),'522',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('743','COZZA DONATO','MANAGER','370',to_date('09-JUN-81','DD-MON-RR'),'1259',null,'499');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('744','SANTE FRANCESCO','SECRETARY','134',to_date('09-JUN-81','DD-MON-RR'),'336',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('745','PETRARCA ANDREA','PROFESSOR','496',to_date('09-JUN-81','DD-MON-RR'),'1498',null,'297');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('746','FUMAROLA LUCA','ENGINEER','373',to_date('09-JUN-81','DD-MON-RR'),'1301',null,'242');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('747','DANTE LUDOVICO','HEADMASTER','515',to_date('09-JUN-81','DD-MON-RR'),'1174',null,'449');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('748','ECO ANGELO','SECRETARY','280',to_date('09-JUN-81','DD-MON-RR'),'258',null,'324');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('749','LEVI LUDOVICO','LAWYER','382',to_date('09-JUN-81','DD-MON-RR'),'1116',null,'16');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('750','CALVINO ANTONIO','MANAGER','705',to_date('09-JUN-81','DD-MON-RR'),'879',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('751','GRIMALDI MASSIMO','MANAGER','701',to_date('09-JUN-81','DD-MON-RR'),'1331',null,'210');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('752','FUMAROLA IVANO','LAWYER','42',to_date('09-JUN-81','DD-MON-RR'),'537',null,'482');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('753','FO IVANO','MANAGER','733',to_date('09-JUN-81','DD-MON-RR'),'1770',null,'362');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('754','SANTE SILVIA','SUPERVISOR','366',to_date('09-JUN-81','DD-MON-RR'),'1537',null,'329');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('755','LEVI IVANO','SECRETARY','141',to_date('09-JUN-81','DD-MON-RR'),'1752',null,'436');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('756','BIANCHI CLARA','PROFESSOR','283',to_date('09-JUN-81','DD-MON-RR'),'694',null,'351');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('757','PETRARCA UMBERTO','TECHNICIAN','130',to_date('09-JUN-81','DD-MON-RR'),'1648',null,'274');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('758','ECO MARIA','MANAGER','553',to_date('09-JUN-81','DD-MON-RR'),'1507',null,'472');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('759','DANTE MARIO','SECRETARY','421',to_date('09-JUN-81','DD-MON-RR'),'1726',null,'486');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('760','FO COSIMO','MANAGER','492',to_date('09-JUN-81','DD-MON-RR'),'1139',null,'392');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('761','NERI UGO','SECRETARY','424',to_date('09-JUN-81','DD-MON-RR'),'1099',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('762','FUMAROLA DONATO','TECHNICIAN','412',to_date('09-JUN-81','DD-MON-RR'),'1032',null,'68');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('763','CALVINO LUIGI','MANAGER','115',to_date('09-JUN-81','DD-MON-RR'),'766',null,'335');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('764','CORONA IVANO','TECHNICIAN','229',to_date('09-JUN-81','DD-MON-RR'),'787',null,'455');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('765','FO IVANO','MANAGER','139',to_date('09-JUN-81','DD-MON-RR'),'513',null,'431');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('766','COZZA DAMIANO','LAWYER','125',to_date('09-JUN-81','DD-MON-RR'),'669',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('767','CARBONE UMBERTO','LAWYER','16',to_date('09-JUN-81','DD-MON-RR'),'274',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('768','FO PASQUALE','PHDSTUDENT','57',to_date('09-JUN-81','DD-MON-RR'),'760',null,'241');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('769','CORONA MARIA','ENGINEER','609',to_date('09-JUN-81','DD-MON-RR'),'1556',null,'357');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('770','ESPOSITO PAOLO','MANAGER','766',to_date('09-JUN-81','DD-MON-RR'),'468',null,'290');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('771','TIBALDI LUCIA','SUPERVISOR','689',to_date('09-JUN-81','DD-MON-RR'),'731',null,'346');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('772','TIBALDI ELENA','LAWYER','318',to_date('09-JUN-81','DD-MON-RR'),'193',null,'212');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('773','ECO DONATO','ENGINEER','742',to_date('09-JUN-81','DD-MON-RR'),'661',null,'17');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('774','CALVINO ANGELO','MANAGER','592',to_date('09-JUN-81','DD-MON-RR'),'1738',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('775','SANTE PASQUALE','MANAGER','623',to_date('09-JUN-81','DD-MON-RR'),'1135',null,'287');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('776','LEOPARDI LUDOVICO','PHDSTUDENT','576',to_date('09-JUN-81','DD-MON-RR'),'639',null,'71');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('777','COZZA COSIMO','SUPERVISOR','562',to_date('09-JUN-81','DD-MON-RR'),'428',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('778','BIANCHI MASSIMO','ENGINEER','624',to_date('09-JUN-81','DD-MON-RR'),'72',null,'450');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('779','CORONA DAMIANO','SUPERVISOR','271',to_date('09-JUN-81','DD-MON-RR'),'491',null,'423');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('780','FUMAROLA ANGELO','LAWYER','763',to_date('09-JUN-81','DD-MON-RR'),'1061',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('781','NERI GIOVANNI','PROFESSOR','258',to_date('09-JUN-81','DD-MON-RR'),'1318',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('782','CARBONE UGO','PROFESSOR','540',to_date('09-JUN-81','DD-MON-RR'),'1636',null,'374');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('783','TIBALDI UGO','PROFESSOR','449',to_date('09-JUN-81','DD-MON-RR'),'1540',null,'429');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('784','LEVI PAOLO','TECHNICIAN','354',to_date('09-JUN-81','DD-MON-RR'),'1910',null,'292');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('785','PETRARCA GAETANO','PROFESSOR','564',to_date('09-JUN-81','DD-MON-RR'),'1143',null,'420');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('786','FUMAROLA IVANO','MANAGER','93',to_date('09-JUN-81','DD-MON-RR'),'913',null,'208');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('787','TIBALDI PAOLO','PHDSTUDENT','302',to_date('09-JUN-81','DD-MON-RR'),'1241',null,'165');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('788','CORONA LUDOVICO','SUPERVISOR','753',to_date('09-JUN-81','DD-MON-RR'),'400',null,'34');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('789','MANZONI LUCIA','MANAGER','121',to_date('09-JUN-81','DD-MON-RR'),'255',null,'315');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('790','MANZONI FEDERICO','SUPERVISOR','39',to_date('09-JUN-81','DD-MON-RR'),'291',null,'397');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('791','DANTE ELENA','SECRETARY','514',to_date('09-JUN-81','DD-MON-RR'),'1939',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('792','PETRARCA ELIO','LAWYER','460',to_date('09-JUN-81','DD-MON-RR'),'411',null,'464');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('793','TIBALDI PASQUALE','MANAGER','166',to_date('09-JUN-81','DD-MON-RR'),'589',null,'377');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('794','FUMAROLA COSIMO','TECHNICIAN','758',to_date('09-JUN-81','DD-MON-RR'),'528',null,'278');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('795','COZZA SILVIA','PROFESSOR','644',to_date('09-JUN-81','DD-MON-RR'),'108',null,'65');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('796','LEOPARDI LUDOVICO','SECRETARY','420',to_date('09-JUN-81','DD-MON-RR'),'1195',null,'475');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('797','TIBALDI ELENA','HEADMASTER','171',to_date('09-JUN-81','DD-MON-RR'),'493',null,'489');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('798','COZZA MARIA','SUPERVISOR','557',to_date('09-JUN-81','DD-MON-RR'),'739',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('799','DANTE GIOVANNI','MANAGER','706',to_date('09-JUN-81','DD-MON-RR'),'1208',null,'493');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('800','SANTE DONATO','PHDSTUDENT','341',to_date('09-JUN-81','DD-MON-RR'),'2',null,'21');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('801','CARBONE MARIO','PROFESSOR','431',to_date('09-JUN-81','DD-MON-RR'),'270',null,'293');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('802','COZZA ANTONIO','SUPERVISOR','211',to_date('09-JUN-81','DD-MON-RR'),'513',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('803','FO GIOVANNI','ENGINEER','449',to_date('09-JUN-81','DD-MON-RR'),'199',null,'14');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('804','LEVI LUDOVICO','ENGINEER','718',to_date('09-JUN-81','DD-MON-RR'),'875',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('805','FUMAROLA ELIO','TECHNICIAN','700',to_date('09-JUN-81','DD-MON-RR'),'613',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('806','CALVINO FEDERICO','ENGINEER','728',to_date('09-JUN-81','DD-MON-RR'),'805',null,'108');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('807','MANZONI DONATO','PROFESSOR','601',to_date('09-JUN-81','DD-MON-RR'),'314',null,'257');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1','COZZA MARIA','PROFESSOR','0',to_date('09-JUN-81','DD-MON-RR'),'1181',null,'126');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2','ECO LUIGI','PHDSTUDENT','0',to_date('09-JUN-81','DD-MON-RR'),'1360',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('3','CORONA CLARA','PHDSTUDENT','2',to_date('09-JUN-81','DD-MON-RR'),'624',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('4','CALVINO MASSIMO','PROFESSOR','2',to_date('09-JUN-81','DD-MON-RR'),'1224',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('5','PETRARCA LUCIA','PHDSTUDENT','2',to_date('09-JUN-81','DD-MON-RR'),'1098',null,'18');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('6','CALVINO MARIA','LAWYER','3',to_date('09-JUN-81','DD-MON-RR'),'1513',null,'223');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('7','DANTE UGO','MANAGER','6',to_date('09-JUN-81','DD-MON-RR'),'1751',null,'280');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('8','BIANCHI IVANO','ENGINEER','7',to_date('09-JUN-81','DD-MON-RR'),'716',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('9','ESPOSITO ELIO','SECRETARY','3',to_date('09-JUN-81','DD-MON-RR'),'56',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('10','MANZONI ANTONIO','PHDSTUDENT','0',to_date('09-JUN-81','DD-MON-RR'),'1096',null,'345');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('11','LEVI GIOVANNI','SECRETARY','10',to_date('09-JUN-81','DD-MON-RR'),'1320',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('12','CORONA ANTONIO','MANAGER','3',to_date('09-JUN-81','DD-MON-RR'),'964',null,'24');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('13','LEOPARDI PASQUALE','TECHNICIAN','12',to_date('09-JUN-81','DD-MON-RR'),'1488',null,'440');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('14','TIBALDI LUCIA','SECRETARY','11',to_date('09-JUN-81','DD-MON-RR'),'207',null,'137');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('15','SANTE UGO','MANAGER','14',to_date('09-JUN-81','DD-MON-RR'),'1619',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('16','ECO LUDOVICO','PHDSTUDENT','9',to_date('09-JUN-81','DD-MON-RR'),'1664',null,'267');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1927','FO ELENA','LAWYER','241',to_date('09-JUN-81','DD-MON-RR'),'255',null,'471');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1928','LEVI UMBERTO','ENGINEER','1641',to_date('09-JUN-81','DD-MON-RR'),'340',null,'423');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1929','ESPOSITO MARIA','PHDSTUDENT','414',to_date('09-JUN-81','DD-MON-RR'),'640',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1930','COZZA ANTONIO','PROFESSOR','1077',to_date('09-JUN-81','DD-MON-RR'),'1953',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1931','TIBALDI GIOVANNI','PHDSTUDENT','413',to_date('09-JUN-81','DD-MON-RR'),'470',null,'266');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1932','TIBALDI CLARA','LAWYER','1066',to_date('09-JUN-81','DD-MON-RR'),'1719',null,'51');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1933','SANTE LUDOVICO','SECRETARY','740',to_date('09-JUN-81','DD-MON-RR'),'663',null,'120');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1934','ESPOSITO MARIA','TECHNICIAN','898',to_date('09-JUN-81','DD-MON-RR'),'284',null,'171');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1935','COZZA IVANO','TECHNICIAN','1848',to_date('09-JUN-81','DD-MON-RR'),'998',null,'256');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1936','LEVI UMBERTO','MANAGER','421',to_date('09-JUN-81','DD-MON-RR'),'318',null,'364');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1937','SANTE ELENA','SECRETARY','1407',to_date('09-JUN-81','DD-MON-RR'),'1634',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1938','ECO PAOLO','TECHNICIAN','1744',to_date('09-JUN-81','DD-MON-RR'),'1388',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1939','NERI SILVIA','SECRETARY','317',to_date('09-JUN-81','DD-MON-RR'),'778',null,'101');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1940','FUMAROLA LUDOVICO','SUPERVISOR','84',to_date('09-JUN-81','DD-MON-RR'),'947',null,'322');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1941','LEVI IVANO','SECRETARY','97',to_date('09-JUN-81','DD-MON-RR'),'625',null,'373');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1942','LEVI LUCIA','HEADMASTER','470',to_date('09-JUN-81','DD-MON-RR'),'1580',null,'415');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1943','LEVI MARIO','MANAGER','714',to_date('09-JUN-81','DD-MON-RR'),'1040',null,'418');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1944','FO ROBERTA','SUPERVISOR','1095',to_date('09-JUN-81','DD-MON-RR'),'1648',null,'75');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1945','FUMAROLA ALFONSO','MANAGER','1773',to_date('09-JUN-81','DD-MON-RR'),'751',null,'71');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1946','PETRARCA LUCIA','MANAGER','281',to_date('09-JUN-81','DD-MON-RR'),'1965',null,'275');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1947','NERI ANGELO','ENGINEER','1764',to_date('09-JUN-81','DD-MON-RR'),'8',null,'202');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1948','FUMAROLA PAOLO','SECRETARY','1713',to_date('09-JUN-81','DD-MON-RR'),'1873',null,'272');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1949','BIANCHI ANDREA','SUPERVISOR','930',to_date('09-JUN-81','DD-MON-RR'),'4',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1950','CORONA ELIO','PHDSTUDENT','580',to_date('09-JUN-81','DD-MON-RR'),'1362',null,'368');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1951','PETRARCA MARIA','MANAGER','1323',to_date('09-JUN-81','DD-MON-RR'),'763',null,'326');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1952','GRIMALDI PAOLO','SECRETARY','1646',to_date('09-JUN-81','DD-MON-RR'),'361',null,'209');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1953','BIANCHI FEDERICO','TECHNICIAN','532',to_date('09-JUN-81','DD-MON-RR'),'1594',null,'462');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1954','ESPOSITO UMBERTO','LAWYER','47',to_date('09-JUN-81','DD-MON-RR'),'1981',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1955','CALVINO ELIO','PHDSTUDENT','813',to_date('09-JUN-81','DD-MON-RR'),'1833',null,'408');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1956','BIANCHI ANDREA','MANAGER','1610',to_date('09-JUN-81','DD-MON-RR'),'71',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1957','PETRARCA ANDREA','MANAGER','1741',to_date('09-JUN-81','DD-MON-RR'),'216',null,'445');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1958','CARBONE ELIO','PHDSTUDENT','579',to_date('09-JUN-81','DD-MON-RR'),'1257',null,'303');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1959','MANZONI PAOLO','HEADMASTER','1144',to_date('09-JUN-81','DD-MON-RR'),'942',null,'55');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1960','CARBONE IVANO','ENGINEER','167',to_date('09-JUN-81','DD-MON-RR'),'1883',null,'323');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1961','DANTE UMBERTO','MANAGER','1875',to_date('09-JUN-81','DD-MON-RR'),'1837',null,'19');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1962','FUMAROLA LUDOVICO','TECHNICIAN','201',to_date('09-JUN-81','DD-MON-RR'),'568',null,'206');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1963','BIANCHI LUCIA','MANAGER','1576',to_date('09-JUN-81','DD-MON-RR'),'1778',null,'198');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1964','ECO LUCA','MANAGER','1037',to_date('09-JUN-81','DD-MON-RR'),'1387',null,'157');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1965','NERI MASSIMO','HEADMASTER','723',to_date('09-JUN-81','DD-MON-RR'),'1459',null,'391');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1966','COZZA ANTONIO','MANAGER','34',to_date('09-JUN-81','DD-MON-RR'),'1176',null,'398');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1967','DANTE UMBERTO','PROFESSOR','709',to_date('09-JUN-81','DD-MON-RR'),'167',null,'237');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1968','CALVINO LUCIA','TECHNICIAN','1065',to_date('09-JUN-81','DD-MON-RR'),'1761',null,'478');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1969','FUMAROLA GIOVANNI','SECRETARY','1541',to_date('09-JUN-81','DD-MON-RR'),'1637',null,'380');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1970','GRIMALDI DONATO','LAWYER','1851',to_date('09-JUN-81','DD-MON-RR'),'1651',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1971','LEOPARDI ELIO','ENGINEER','1182',to_date('09-JUN-81','DD-MON-RR'),'1715',null,'177');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1972','ESPOSITO LUDOVICO','LAWYER','1158',to_date('09-JUN-81','DD-MON-RR'),'550',null,'209');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1973','MANZONI SILVIA','TECHNICIAN','257',to_date('09-JUN-81','DD-MON-RR'),'1179',null,'189');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1974','ESPOSITO LUCIA','PHDSTUDENT','304',to_date('09-JUN-81','DD-MON-RR'),'622',null,'243');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1975','MANZONI LUIGI','LAWYER','632',to_date('09-JUN-81','DD-MON-RR'),'698',null,'384');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1976','CORONA MARIO','MANAGER','437',to_date('09-JUN-81','DD-MON-RR'),'1343',null,'233');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1977','COZZA GIOVANNI','TECHNICIAN','1802',to_date('09-JUN-81','DD-MON-RR'),'1311',null,'328');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1978','LEVI ANTONIO','PROFESSOR','1637',to_date('09-JUN-81','DD-MON-RR'),'1696',null,'147');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1979','CORONA FEDERICO','TECHNICIAN','1729',to_date('09-JUN-81','DD-MON-RR'),'179',null,'67');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1980','CARBONE LUCIA','ENGINEER','604',to_date('09-JUN-81','DD-MON-RR'),'650',null,'447');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1981','CORONA ELENA','HEADMASTER','1357',to_date('09-JUN-81','DD-MON-RR'),'2',null,'318');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1982','PETRARCA ROBERTA','LAWYER','1060',to_date('09-JUN-81','DD-MON-RR'),'978',null,'180');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1983','TIBALDI UMBERTO','MANAGER','1782',to_date('09-JUN-81','DD-MON-RR'),'1295',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1984','CALVINO MASSIMO','PROFESSOR','38',to_date('09-JUN-81','DD-MON-RR'),'1456',null,'476');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1985','ECO UMBERTO','ENGINEER','1388',to_date('09-JUN-81','DD-MON-RR'),'788',null,'141');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1986','SANTE UMBERTO','HEADMASTER','1111',to_date('09-JUN-81','DD-MON-RR'),'309',null,'32');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1987','BIANCHI ELENA','HEADMASTER','1794',to_date('09-JUN-81','DD-MON-RR'),'1685',null,'65');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1988','GRIMALDI ELENA','ENGINEER','682',to_date('09-JUN-81','DD-MON-RR'),'1868',null,'299');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1989','FUMAROLA MARIA','PHDSTUDENT','266',to_date('09-JUN-81','DD-MON-RR'),'296',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1990','LEVI DONATO','SECRETARY','89',to_date('09-JUN-81','DD-MON-RR'),'4',null,'332');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1991','NERI FEDERICO','MANAGER','779',to_date('09-JUN-81','DD-MON-RR'),'310',null,'144');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1992','BIANCHI LUCIA','PHDSTUDENT','195',to_date('09-JUN-81','DD-MON-RR'),'510',null,'219');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1993','CARBONE FRANCESCO','ENGINEER','358',to_date('09-JUN-81','DD-MON-RR'),'1725',null,'204');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1994','PETRARCA LUIGI','TECHNICIAN','462',to_date('09-JUN-81','DD-MON-RR'),'535',null,'342');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1995','CALVINO LUCIA','SECRETARY','1363',to_date('09-JUN-81','DD-MON-RR'),'798',null,'495');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1996','PETRARCA MASSIMO','TECHNICIAN','962',to_date('09-JUN-81','DD-MON-RR'),'237',null,'370');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1997','CORONA FEDERICO','LAWYER','732',to_date('09-JUN-81','DD-MON-RR'),'1345',null,'174');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1998','FUMAROLA COSIMO','MANAGER','558',to_date('09-JUN-81','DD-MON-RR'),'163',null,'365');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('1999','MANZONI GIOVANNI','LAWYER','449',to_date('09-JUN-81','DD-MON-RR'),'185',null,'66');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2000','NERI UMBERTO','PROFESSOR','1798',to_date('09-JUN-81','DD-MON-RR'),'379',null,'443');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2001','CALVINO ANDREA','PROFESSOR','953',to_date('09-JUN-81','DD-MON-RR'),'39',null,'366');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2002','CALVINO MARIA','LAWYER','624',to_date('09-JUN-81','DD-MON-RR'),'314',null,'490');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2003','COZZA LUDOVICO','SUPERVISOR','1061',to_date('09-JUN-81','DD-MON-RR'),'483',null,'481');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2004','DANTE ALFONSO','MANAGER','253',to_date('09-JUN-81','DD-MON-RR'),'309',null,'458');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2005','LEVI ALFONSO','PROFESSOR','1496',to_date('09-JUN-81','DD-MON-RR'),'1928',null,'306');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2006','CORONA COSIMO','SUPERVISOR','495',to_date('09-JUN-81','DD-MON-RR'),'660',null,'85');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2007','ESPOSITO PAOLO','ENGINEER','577',to_date('09-JUN-81','DD-MON-RR'),'1721',null,'59');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2008','COZZA PAOLO','TECHNICIAN','302',to_date('09-JUN-81','DD-MON-RR'),'103',null,'161');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2009','FO MARIA','MANAGER','1886',to_date('09-JUN-81','DD-MON-RR'),'879',null,'203');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2010','SANTE COSIMO','PHDSTUDENT','563',to_date('09-JUN-81','DD-MON-RR'),'890',null,'218');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2011','CARBONE ELIO','SECRETARY','90',to_date('09-JUN-81','DD-MON-RR'),'651',null,'310');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2012','ECO MARIA','LAWYER','356',to_date('09-JUN-81','DD-MON-RR'),'1186',null,'15');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2013','ESPOSITO PAOLO','PROFESSOR','757',to_date('09-JUN-81','DD-MON-RR'),'24',null,'301');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2014','GRIMALDI MARIA','TECHNICIAN','1915',to_date('09-JUN-81','DD-MON-RR'),'131',null,'178');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2015','SANTE MASSIMO','TECHNICIAN','1672',to_date('09-JUN-81','DD-MON-RR'),'405',null,'250');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2016','CARBONE LUCA','HEADMASTER','1122',to_date('09-JUN-81','DD-MON-RR'),'283',null,'452');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2017','MANZONI FRANCESCO','HEADMASTER','699',to_date('09-JUN-81','DD-MON-RR'),'1070',null,'401');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2018','GRIMALDI DAMIANO','LAWYER','1875',to_date('09-JUN-81','DD-MON-RR'),'413',null,'338');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2019','CALVINO SILVIA','HEADMASTER','908',to_date('09-JUN-81','DD-MON-RR'),'1713',null,'434');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2020','GRIMALDI MARIO','LAWYER','1741',to_date('09-JUN-81','DD-MON-RR'),'89',null,'497');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2021','DANTE ANTONIO','ENGINEER','1904',to_date('09-JUN-81','DD-MON-RR'),'1734',null,'116');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2022','GRIMALDI DAMIANO','TECHNICIAN','116',to_date('09-JUN-81','DD-MON-RR'),'783',null,'63');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2023','NERI PASQUALE','HEADMASTER','1065',to_date('09-JUN-81','DD-MON-RR'),'1396',null,'81');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2024','DANTE COSIMO','LAWYER','17',to_date('09-JUN-81','DD-MON-RR'),'1362',null,'463');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2025','GRIMALDI ELENA','LAWYER','1358',to_date('09-JUN-81','DD-MON-RR'),'701',null,'93');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2026','LEOPARDI LUCIA','HEADMASTER','1535',to_date('09-JUN-81','DD-MON-RR'),'1311',null,'182');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2027','NERI UMBERTO','SUPERVISOR','1183',to_date('09-JUN-81','DD-MON-RR'),'1120',null,'400');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2028','CALVINO LUDOVICO','SECRETARY','1354',to_date('09-JUN-81','DD-MON-RR'),'1896',null,'133');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2029','ESPOSITO ALFONSO','LAWYER','1829',to_date('09-JUN-81','DD-MON-RR'),'322',null,'90');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2030','GRIMALDI UGO','PHDSTUDENT','1967',to_date('09-JUN-81','DD-MON-RR'),'1421',null,'9');
Insert into EMP (EMPNO,ENAME,JOB,MGR,HIREDATE,SAL,COMM,DEPTNO) values ('2031','GRIMALDI ANTONIO','PROFESSOR','1324',to_date('09-JUN-81','DD-MON-RR'),'268',null,'194');
