
public class ReducerBigData extends Reducer<Text, Text, Text, NullWritable> {
    @Override
    protected void reduce(
            Text key,
            Iterable<Text> values,
            Context context)
            throws IOException, InterruptedException {

        int poiCount = 0;

        String category1 = null;
        String category2 = null;

        for (Text val : values) {
            poiCount++;

            String category = val.toString();

            if (category1 == null)
                category1 = category;
            else if (category.equals(category1))
                continue;
            else if (category2 == null)
                category2 = category;
            else if (category.equals(category2))
                continue;
            else
                return; // stop processing if distinct categories > 2
        }

        if (poiCount > 10000)
            context.write(key, NullWritable.get());
    }
}
